#!/bin/bash
#
#
# Dies ist ein Script um aus der Datei (Vorgaenger) 
#   WHO-COVID-19-global-data.csv_2022-02-07_19:40:01 
# die Datei 
#   WHO-COVID-19-global-data.csv_2022-02-08_18:40:01
# zu generieren. .
#
# Wenn  sich mehrere Dateien mit Endnug .diff.bash im Verz. befinden können 
# sie mit 
#   for datei in $(ls *.diff.bash) ;do ./${datei} ; done
# ausgeführt werden. Wichtig ist, das die Reihenfolge des Aufrufs stimmt 
# weil jedes Script auf das Ergebnis des Vorgängerscripts angewiesen ist. 
#
# Bekannter Fehler: wenn die Originaldatei keinen Zeilenumbruch am Dateiende 
# hatte hängt das ed-Script einen Zeilenumbruch an. 
#
/bin/ed WHO-COVID-19-global-data.csv_2022-02-07_19:40:01 <<ed_heredoc
180362,181069d
180305c
2022-02-04,ZM,Zambia,AFRO,790,306347,5,3925
2022-02-05,ZM,Zambia,AFRO,430,306777,3,3928
2022-02-06,ZM,Zambia,AFRO,0,306777,2,3930
2022-02-07,ZM,Zambia,AFRO,429,307206,0,3930
.
179541c
2022-02-04,YE,Yemen,EMRO,42,11187,2,2020
2022-02-05,YE,Yemen,EMRO,44,11231,2,2022
2022-02-06,YE,Yemen,EMRO,18,11249,4,2026
2022-02-07,YE,Yemen,EMRO,17,11266,2,2028
.
178777a
2022-02-05,WF,Wallis and Futuna,WPRO,0,453,0,7
2022-02-06,WF,Wallis and Futuna,WPRO,0,453,0,7
2022-02-07,WF,Wallis and Futuna,WPRO,0,453,0,7
.
178013a
2022-02-05,VN,Viet Nam,WPRO,11594,2315689,84,38147
2022-02-06,VN,Viet Nam,WPRO,12170,2327859,114,38261
2022-02-07,VN,Viet Nam,WPRO,14112,2341971,63,38324
.
177249a
2022-02-05,VE,Venezuela (Bolivarian Republic of),AMRO,1711,491016,7,5469
2022-02-06,VE,Venezuela (Bolivarian Republic of),AMRO,1662,492678,5,5474
2022-02-07,VE,Venezuela (Bolivarian Republic of),AMRO,2157,494835,7,5481
.
176485a
2022-02-05,VU,Vanuatu,WPRO,0,7,0,0
2022-02-06,VU,Vanuatu,WPRO,0,7,0,0
2022-02-07,VU,Vanuatu,WPRO,0,7,0,0
.
175721a
2022-02-05,UZ,Uzbekistan,EURO,912,227909,2,1581
2022-02-06,UZ,Uzbekistan,EURO,887,228796,3,1584
2022-02-07,UZ,Uzbekistan,EURO,832,229628,2,1586
.
174957a
2022-02-05,UY,Uruguay,AMRO,10015,700511,39,6579
2022-02-06,UY,Uruguay,AMRO,10363,710874,27,6606
2022-02-07,UY,Uruguay,AMRO,9074,719948,19,6625
.
174193a
2022-02-05,VI,United States Virgin Islands,AMRO,53,14988,0,102
2022-02-06,VI,United States Virgin Islands,AMRO,0,14988,0,102
2022-02-07,VI,United States Virgin Islands,AMRO,0,14988,0,102
.
173429a
2022-02-05,US,United States of America,AMRO,328989,75416961,2351,890464
2022-02-06,US,United States of America,AMRO,0,75416961,0,890464
2022-02-07,US,United States of America,AMRO,308282,75725243,3406,893870
.
172665a
2022-02-05,TZ,United Republic of Tanzania,AFRO,0,32920,0,778
2022-02-06,TZ,United Republic of Tanzania,AFRO,310,33230,11,789
2022-02-07,TZ,United Republic of Tanzania,AFRO,0,33230,0,789
.
171901a
2022-02-05,AE,United Arab Emirates,EMRO,2114,853651,5,2258
2022-02-06,AE,United Arab Emirates,EMRO,1991,855642,4,2262
2022-02-07,AE,United Arab Emirates,EMRO,2015,857657,2,2264
.
171137a
2022-02-05,UA,Ukraine,EURO,42533,4256208,185,101168
2022-02-06,UA,Ukraine,EURO,27851,4284059,109,101277
2022-02-07,UA,Ukraine,EURO,23378,4307437,115,101392
.
170373c
2022-02-04,UG,Uganda,AFRO,196,162203,9,3554
2022-02-05,UG,Uganda,AFRO,0,162203,0,3554
2022-02-06,UG,Uganda,AFRO,137,162340,8,3562
2022-02-07,UG,Uganda,AFRO,35,162375,4,3566
.
169609a
2022-02-05,TV,Tuvalu,WPRO,0,0,0,0
2022-02-06,TV,Tuvalu,WPRO,0,0,0,0
2022-02-07,TV,Tuvalu,WPRO,0,0,0,0
.
168845a
2022-02-05,TC,Turks and Caicos Islands,AMRO,4,5774,0,34
2022-02-06,TC,Turks and Caicos Islands,AMRO,4,5778,1,35
2022-02-07,TC,Turks and Caicos Islands,AMRO,9,5787,0,35
.
168081a
2022-02-05,TM,Turkmenistan,EURO,0,0,0,0
2022-02-06,TM,Turkmenistan,EURO,0,0,0,0
2022-02-07,TM,Turkmenistan,EURO,0,0,0,0
.
167317a
2022-02-05,TR,Turkey,EURO,111157,12050961,248,88312
2022-02-06,TR,Turkey,EURO,98715,12149676,221,88533
2022-02-07,TR,Turkey,EURO,87934,12237610,201,88734
.
166553c
2022-02-04,TN,Tunisia,EMRO,5715,930090,67,26496
2022-02-05,TN,Tunisia,EMRO,4622,934712,52,26548
2022-02-06,TN,Tunisia,EMRO,5511,940223,64,26612
2022-02-07,TN,Tunisia,EMRO,3952,944175,67,26679
.
165789a
2022-02-05,TT,Trinidad and Tobago,AMRO,0,113317,0,3433
2022-02-06,TT,Trinidad and Tobago,AMRO,581,113898,15,3448
2022-02-07,TT,Trinidad and Tobago,AMRO,867,114765,6,3454
.
165025c
2022-02-04,TO,Tonga,WPRO,1,6,0,0
2022-02-05,TO,Tonga,WPRO,1,7,0,0
2022-02-06,TO,Tonga,WPRO,0,7,0,0
2022-02-07,TO,Tonga,WPRO,1,8,0,0
.
164261a
2022-02-05,TK,Tokelau,WPRO,0,0,0,0
2022-02-06,TK,Tokelau,WPRO,0,0,0,0
2022-02-07,TK,Tokelau,WPRO,0,0,0,0
.
163497c
2022-02-04,TG,Togo,AFRO,12,36550,0,268
2022-02-05,TG,Togo,AFRO,0,36550,0,268
2022-02-06,TG,Togo,AFRO,7,36557,0,268
2022-02-07,TG,Togo,AFRO,41,36598,1,269
.
162733a
2022-02-05,TL,Timor-Leste,SEARO,88,20328,0,122
2022-02-06,TL,Timor-Leste,SEARO,75,20403,0,122
2022-02-07,TL,Timor-Leste,SEARO,98,20501,0,122
.
161969a
2022-02-05,GB,The United Kingdom,EURO,82053,17689889,254,157984
2022-02-06,GB,The United Kingdom,EURO,60114,17750003,259,158243
2022-02-07,GB,The United Kingdom,EURO,53326,17803329,75,158318
.
161205a
2022-02-05,TH,Thailand,SEARO,10490,2486122,21,22271
2022-02-06,TH,Thailand,SEARO,10879,2497001,20,22291
2022-02-07,TH,Thailand,SEARO,10470,2507471,12,22303
.
160441a
2022-02-05,TJ,Tajikistan,EURO,5,17738,0,125
2022-02-06,TJ,Tajikistan,EURO,4,17742,0,125
2022-02-07,TJ,Tajikistan,EURO,3,17745,0,125
.
159677c
2022-02-04,SY,Syrian Arab Republic,EMRO,87,51656,3,2998
2022-02-05,SY,Syrian Arab Republic,EMRO,85,51741,3,3001
2022-02-06,SY,Syrian Arab Republic,EMRO,85,51826,3,3004
2022-02-07,SY,Syrian Arab Republic,EMRO,89,51915,4,3008
.
158844,158913c
2021-11-27,CH,Switzerland,EURO,7968,995643,14,11095
2021-11-28,CH,Switzerland,EURO,5262,1000905,16,11111
2021-11-29,CH,Switzerland,EURO,4243,1005148,19,11130
2021-11-30,CH,Switzerland,EURO,11502,1016650,21,11151
2021-12-01,CH,Switzerland,EURO,10000,1026650,27,11178
2021-12-02,CH,Switzerland,EURO,10419,1037069,28,11206
2021-12-03,CH,Switzerland,EURO,10159,1047228,26,11232
2021-12-04,CH,Switzerland,EURO,9806,1057034,23,11255
2021-12-05,CH,Switzerland,EURO,6257,1063291,22,11277
2021-12-06,CH,Switzerland,EURO,4937,1068228,25,11302
2021-12-07,CH,Switzerland,EURO,12662,1080890,34,11336
2021-12-08,CH,Switzerland,EURO,11033,1091923,23,11359
2021-12-09,CH,Switzerland,EURO,9950,1101873,29,11388
2021-12-10,CH,Switzerland,EURO,10421,1112294,28,11416
2021-12-11,CH,Switzerland,EURO,9756,1122050,21,11437
2021-12-12,CH,Switzerland,EURO,6089,1128139,22,11459
2021-12-13,CH,Switzerland,EURO,4393,1132532,28,11487
2021-12-14,CH,Switzerland,EURO,12431,1144963,21,11508
2021-12-15,CH,Switzerland,EURO,10528,1155491,35,11543
2021-12-16,CH,Switzerland,EURO,9532,1165023,33,11576
2021-12-17,CH,Switzerland,EURO,9144,1174167,29,11605
2021-12-18,CH,Switzerland,EURO,8738,1182905,24,11629
2021-12-19,CH,Switzerland,EURO,5876,1188781,21,11650
2021-12-20,CH,Switzerland,EURO,4331,1193112,20,11670
2021-12-21,CH,Switzerland,EURO,11467,1204579,29,11699
2021-12-22,CH,Switzerland,EURO,10775,1215354,20,11719
2021-12-23,CH,Switzerland,EURO,11009,1226363,24,11743
2021-12-24,CH,Switzerland,EURO,11266,1237629,26,11769
2021-12-25,CH,Switzerland,EURO,9630,1247259,11,11780
2021-12-26,CH,Switzerland,EURO,6448,1253707,20,11800
2021-12-27,CH,Switzerland,EURO,7370,1261077,13,11813
2021-12-28,CH,Switzerland,EURO,17421,1278498,17,11830
2021-12-29,CH,Switzerland,EURO,17666,1296164,25,11855
2021-12-30,CH,Switzerland,EURO,18989,1315153,14,11869
2021-12-31,CH,Switzerland,EURO,19740,1334893,22,11891
2022-01-01,CH,Switzerland,EURO,16132,1351025,23,11914
2022-01-02,CH,Switzerland,EURO,9394,1360419,17,11931
2022-01-03,CH,Switzerland,EURO,12804,1373223,11,11942
2022-01-04,CH,Switzerland,EURO,32265,1405488,11,11953
2022-01-05,CH,Switzerland,EURO,33360,1438848,10,11963
2022-01-06,CH,Switzerland,EURO,30629,1469477,13,11976
2022-01-07,CH,Switzerland,EURO,26102,1495579,12,11988
2022-01-08,CH,Switzerland,EURO,27265,1522844,28,12016
2022-01-09,CH,Switzerland,EURO,17770,1540614,17,12033
2022-01-10,CH,Switzerland,EURO,13379,1553993,10,12043
2022-01-11,CH,Switzerland,EURO,34522,1588515,17,12060
2022-01-12,CH,Switzerland,EURO,30866,1619381,12,12072
2022-01-13,CH,Switzerland,EURO,29546,1648927,9,12081
2022-01-14,CH,Switzerland,EURO,28613,1677540,13,12094
2022-01-15,CH,Switzerland,EURO,27621,1705161,13,12107
2022-01-16,CH,Switzerland,EURO,19287,1724448,16,12123
2022-01-17,CH,Switzerland,EURO,14756,1739204,14,12137
2022-01-18,CH,Switzerland,EURO,41793,1780997,12,12149
2022-01-19,CH,Switzerland,EURO,39305,1820302,16,12165
2022-01-20,CH,Switzerland,EURO,39086,1859388,21,12186
2022-01-21,CH,Switzerland,EURO,37654,1897042,19,12205
2022-01-22,CH,Switzerland,EURO,36628,1933670,11,12216
2022-01-23,CH,Switzerland,EURO,24577,1958247,17,12233
2022-01-24,CH,Switzerland,EURO,18338,1976585,7,12240
2022-01-25,CH,Switzerland,EURO,48217,2024802,7,12247
2022-01-26,CH,Switzerland,EURO,43220,2068022,18,12265
2022-01-27,CH,Switzerland,EURO,41277,2109299,10,12275
2022-01-28,CH,Switzerland,EURO,37768,2147067,9,12284
2022-01-29,CH,Switzerland,EURO,35621,2182688,16,12300
2022-01-30,CH,Switzerland,EURO,23314,2206002,12,12312
2022-01-31,CH,Switzerland,EURO,18060,2224062,18,12330
2022-02-01,CH,Switzerland,EURO,43451,2267513,12,12342
2022-02-02,CH,Switzerland,EURO,36928,2304441,12,12354
2022-02-03,CH,Switzerland,EURO,33385,2337826,12,12366
2022-02-04,CH,Switzerland,EURO,17006,2354832,4,12370
2022-02-05,CH,Switzerland,EURO,159,2354991,0,12370
2022-02-06,CH,Switzerland,EURO,0,2354991,0,12370
2022-02-07,CH,Switzerland,EURO,0,2354991,0,12370
.
158829,158841c
2021-11-12,CH,Switzerland,EURO,3953,907279,13,10915
2021-11-13,CH,Switzerland,EURO,4144,911423,7,10922
2021-11-14,CH,Switzerland,EURO,2709,914132,7,10929
2021-11-15,CH,Switzerland,EURO,2165,916297,8,10937
2021-11-16,CH,Switzerland,EURO,6133,922430,8,10945
2021-11-17,CH,Switzerland,EURO,5626,928056,14,10959
2021-11-18,CH,Switzerland,EURO,6183,934239,13,10972
2021-11-19,CH,Switzerland,EURO,6055,940294,17,10989
2021-11-20,CH,Switzerland,EURO,6200,946494,6,10995
2021-11-21,CH,Switzerland,EURO,4141,950635,9,11004
2021-11-22,CH,Switzerland,EURO,3406,954041,13,11017
2021-11-23,CH,Switzerland,EURO,9167,963208,20,11037
2021-11-24,CH,Switzerland,EURO,8011,971219,18,11055
.
158137,158149c
2022-01-23,SE,Sweden,EURO,39812,1825404,35,15865
2022-01-24,SE,Sweden,EURO,37706,1863110,32,15897
2022-01-25,SE,Sweden,EURO,30984,1894094,31,15928
2022-01-26,SE,Sweden,EURO,33916,1928010,36,15964
2022-01-27,SE,Sweden,EURO,46667,1974677,33,15997
2022-01-28,SE,Sweden,EURO,41682,2016359,42,16039
2022-01-29,SE,Sweden,EURO,53901,2070260,24,16063
2022-01-30,SE,Sweden,EURO,39523,2109783,30,16093
2022-01-31,SE,Sweden,EURO,34331,2144114,17,16110
2022-02-01,SE,Sweden,EURO,15068,2159182,15,16125
2022-02-02,SE,Sweden,EURO,24802,2183984,27,16152
2022-02-03,SE,Sweden,EURO,40937,2224921,20,16172
2022-02-04,SE,Sweden,EURO,35955,2260876,7,16179
2022-02-05,SE,Sweden,EURO,26909,2287785,1,16180
2022-02-06,SE,Sweden,EURO,0,2287785,0,16180
2022-02-07,SE,Sweden,EURO,0,2287785,0,16180
.
157765,158082c
2021-01-16,SE,Sweden,EURO,4743,523436,96,11132
2021-01-17,SE,Sweden,EURO,4205,527641,90,11222
2021-01-18,SE,Sweden,EURO,2160,529801,83,11305
2021-01-19,SE,Sweden,EURO,1250,531051,61,11366
2021-01-20,SE,Sweden,EURO,2112,533163,72,11438
2021-01-21,SE,Sweden,EURO,4732,537895,92,11530
2021-01-22,SE,Sweden,EURO,4947,542842,88,11618
2021-01-23,SE,Sweden,EURO,4198,547040,88,11706
2021-01-24,SE,Sweden,EURO,3722,550762,59,11765
2021-01-25,SE,Sweden,EURO,2368,553130,64,11829
2021-01-26,SE,Sweden,EURO,1147,554277,51,11880
2021-01-27,SE,Sweden,EURO,1884,556161,59,11939
2021-01-28,SE,Sweden,EURO,4186,560347,67,12006
2021-01-29,SE,Sweden,EURO,4106,564453,54,12060
2021-01-30,SE,Sweden,EURO,2368,566821,55,12115
2021-01-31,SE,Sweden,EURO,4252,571073,58,12173
2021-02-01,SE,Sweden,EURO,2695,573768,57,12230
2021-02-02,SE,Sweden,EURO,1164,574932,39,12269
2021-02-03,SE,Sweden,EURO,1552,576484,46,12315
2021-02-04,SE,Sweden,EURO,4315,580799,43,12358
2021-02-05,SE,Sweden,EURO,3737,584536,52,12410
2021-02-06,SE,Sweden,EURO,3396,587932,30,12440
2021-02-07,SE,Sweden,EURO,3260,591192,36,12476
2021-02-08,SE,Sweden,EURO,2333,593525,33,12509
2021-02-09,SE,Sweden,EURO,1013,594538,29,12538
2021-02-10,SE,Sweden,EURO,1505,596043,39,12577
2021-02-11,SE,Sweden,EURO,4069,600112,25,12602
2021-02-12,SE,Sweden,EURO,4353,604465,27,12629
2021-02-13,SE,Sweden,EURO,3805,608270,33,12662
2021-02-14,SE,Sweden,EURO,3569,611839,28,12690
2021-02-15,SE,Sweden,EURO,2771,614610,25,12715
2021-02-16,SE,Sweden,EURO,1211,615821,28,12743
2021-02-17,SE,Sweden,EURO,1902,617723,23,12766
2021-02-18,SE,Sweden,EURO,4206,621929,22,12788
2021-02-19,SE,Sweden,EURO,4965,626894,34,12822
2021-02-20,SE,Sweden,EURO,4134,631028,18,12840
2021-02-21,SE,Sweden,EURO,4028,635056,25,12865
2021-02-22,SE,Sweden,EURO,2781,637837,29,12894
2021-02-23,SE,Sweden,EURO,1599,639436,21,12915
2021-02-24,SE,Sweden,EURO,2542,641978,25,12940
2021-02-25,SE,Sweden,EURO,5407,647385,13,12953
2021-02-26,SE,Sweden,EURO,4977,652362,26,12979
2021-02-27,SE,Sweden,EURO,4831,657193,20,12999
2021-02-28,SE,Sweden,EURO,4583,661776,18,13017
2021-03-01,SE,Sweden,EURO,3107,664883,19,13036
2021-03-02,SE,Sweden,EURO,1242,666125,25,13061
2021-03-03,SE,Sweden,EURO,2827,668952,24,13085
2021-03-04,SE,Sweden,EURO,6189,675141,23,13108
2021-03-05,SE,Sweden,EURO,4871,680012,19,13127
2021-03-06,SE,Sweden,EURO,4883,684895,19,13146
2021-03-07,SE,Sweden,EURO,4069,688964,15,13161
2021-03-08,SE,Sweden,EURO,3454,692418,12,13173
2021-03-09,SE,Sweden,EURO,1451,693869,17,13190
2021-03-10,SE,Sweden,EURO,1982,695851,24,13214
2021-03-11,SE,Sweden,EURO,5928,701779,20,13234
2021-03-12,SE,Sweden,EURO,5328,707107,21,13255
2021-03-13,SE,Sweden,EURO,5332,712439,16,13271
2021-03-14,SE,Sweden,EURO,4995,717434,19,13290
2021-03-15,SE,Sweden,EURO,3953,721387,19,13309
2021-03-16,SE,Sweden,EURO,1040,722427,22,13331
2021-03-17,SE,Sweden,EURO,2715,725142,21,13352
2021-03-18,SE,Sweden,EURO,6787,731929,16,13368
2021-03-19,SE,Sweden,EURO,6431,738360,19,13387
2021-03-20,SE,Sweden,EURO,5736,744096,18,13405
2021-03-21,SE,Sweden,EURO,5406,749502,11,13416
2021-03-22,SE,Sweden,EURO,4380,753882,25,13441
2021-03-23,SE,Sweden,EURO,1579,755461,18,13459
2021-03-24,SE,Sweden,EURO,2687,758148,16,13475
2021-03-25,SE,Sweden,EURO,7652,765800,14,13489
2021-03-26,SE,Sweden,EURO,7706,773506,16,13505
2021-03-27,SE,Sweden,EURO,6365,779871,22,13527
2021-03-28,SE,Sweden,EURO,6294,786165,22,13549
2021-03-29,SE,Sweden,EURO,5196,791361,19,13568
2021-03-30,SE,Sweden,EURO,1980,793341,17,13585
2021-03-31,SE,Sweden,EURO,2962,796303,23,13608
2021-04-01,SE,Sweden,EURO,8468,804771,16,13624
2021-04-02,SE,Sweden,EURO,8292,813063,24,13648
2021-04-03,SE,Sweden,EURO,6976,820039,25,13673
2021-04-04,SE,Sweden,EURO,6837,826876,22,13695
2021-04-05,SE,Sweden,EURO,3403,830279,18,13713
2021-04-06,SE,Sweden,EURO,1449,831728,14,13727
2021-04-07,SE,Sweden,EURO,3103,834831,24,13751
2021-04-08,SE,Sweden,EURO,6813,841644,13,13764
2021-04-09,SE,Sweden,EURO,7824,849468,22,13786
2021-04-10,SE,Sweden,EURO,7760,857228,22,13808
2021-04-11,SE,Sweden,EURO,7629,864857,24,13832
2021-04-12,SE,Sweden,EURO,5626,870483,11,13843
2021-04-13,SE,Sweden,EURO,2390,872873,17,13860
2021-04-14,SE,Sweden,EURO,3472,876345,16,13876
2021-04-15,SE,Sweden,EURO,8870,885215,21,13897
2021-04-16,SE,Sweden,EURO,7093,892308,28,13925
2021-04-17,SE,Sweden,EURO,7665,899973,25,13950
2021-04-18,SE,Sweden,EURO,6440,906413,15,13965
2021-04-19,SE,Sweden,EURO,4983,911396,20,13985
2021-04-20,SE,Sweden,EURO,2514,913910,16,14001
2021-04-21,SE,Sweden,EURO,2713,916623,15,14016
2021-04-22,SE,Sweden,EURO,7538,924161,26,14042
2021-04-23,SE,Sweden,EURO,7706,931867,24,14066
2021-04-24,SE,Sweden,EURO,6250,938117,16,14082
2021-04-25,SE,Sweden,EURO,5501,943618,17,14099
2021-04-26,SE,Sweden,EURO,4568,948186,13,14112
2021-04-27,SE,Sweden,EURO,1756,949942,20,14132
2021-04-28,SE,Sweden,EURO,3069,953011,11,14143
2021-04-29,SE,Sweden,EURO,7267,960278,23,14166
2021-04-30,SE,Sweden,EURO,7144,967422,21,14187
2021-05-01,SE,Sweden,EURO,5931,973353,19,14206
2021-05-02,SE,Sweden,EURO,5424,978777,17,14223
2021-05-03,SE,Sweden,EURO,4753,983530,12,14235
2021-05-04,SE,Sweden,EURO,1718,985248,12,14247
2021-05-05,SE,Sweden,EURO,3069,988317,19,14266
2021-05-06,SE,Sweden,EURO,7035,995352,13,14279
2021-05-07,SE,Sweden,EURO,6482,1001834,17,14296
2021-05-08,SE,Sweden,EURO,5716,1007550,10,14306
2021-05-09,SE,Sweden,EURO,5245,1012795,13,14319
2021-05-10,SE,Sweden,EURO,4476,1017271,19,14338
2021-05-11,SE,Sweden,EURO,1657,1018928,16,14354
2021-05-12,SE,Sweden,EURO,2460,1021388,22,14376
2021-05-13,SE,Sweden,EURO,6311,1027699,10,14386
2021-05-14,SE,Sweden,EURO,5269,1032968,11,14397
2021-05-15,SE,Sweden,EURO,3918,1036886,19,14416
2021-05-16,SE,Sweden,EURO,2579,1039465,24,14440
2021-05-17,SE,Sweden,EURO,3969,1043434,12,14452
2021-05-18,SE,Sweden,EURO,1408,1044842,13,14465
2021-05-19,SE,Sweden,EURO,2106,1046948,9,14474
2021-05-20,SE,Sweden,EURO,4642,1051590,9,14483
2021-05-21,SE,Sweden,EURO,3410,1055000,7,14490
2021-05-22,SE,Sweden,EURO,3166,1058166,12,14502
2021-05-23,SE,Sweden,EURO,2317,1060483,12,14514
2021-05-24,SE,Sweden,EURO,1909,1062392,10,14524
2021-05-25,SE,Sweden,EURO,620,1063012,11,14535
2021-05-26,SE,Sweden,EURO,1195,1064207,4,14539
2021-05-27,SE,Sweden,EURO,2739,1066946,8,14547
2021-05-28,SE,Sweden,EURO,1418,1068364,9,14556
2021-05-29,SE,Sweden,EURO,92,1068456,7,14563
2021-05-30,SE,Sweden,EURO,297,1068753,8,14571
2021-05-31,SE,Sweden,EURO,285,1069038,3,14574
2021-06-01,SE,Sweden,EURO,1948,1070986,8,14582
2021-06-02,SE,Sweden,EURO,1898,1072884,6,14588
2021-06-03,SE,Sweden,EURO,2783,1075667,1,14589
2021-06-04,SE,Sweden,EURO,1364,1077031,6,14595
2021-06-05,SE,Sweden,EURO,1080,1078111,6,14601
2021-06-06,SE,Sweden,EURO,989,1079100,14,14615
2021-06-07,SE,Sweden,EURO,758,1079858,3,14618
2021-06-08,SE,Sweden,EURO,222,1080080,3,14621
2021-06-09,SE,Sweden,EURO,490,1080570,5,14626
2021-06-10,SE,Sweden,EURO,1183,1081753,4,14630
2021-06-11,SE,Sweden,EURO,825,1082578,7,14637
2021-06-12,SE,Sweden,EURO,729,1083307,3,14640
2021-06-13,SE,Sweden,EURO,484,1083791,1,14641
2021-06-14,SE,Sweden,EURO,524,1084315,2,14643
2021-06-15,SE,Sweden,EURO,159,1084474,0,14643
2021-06-16,SE,Sweden,EURO,0,1084474,4,14647
2021-06-17,SE,Sweden,EURO,1,1084475,2,14649
2021-06-18,SE,Sweden,EURO,36,1084511,2,14651
2021-06-19,SE,Sweden,EURO,2190,1086701,1,14652
2021-06-20,SE,Sweden,EURO,601,1087302,3,14655
2021-06-21,SE,Sweden,EURO,19,1087321,2,14657
2021-06-22,SE,Sweden,EURO,1,1087322,3,14660
2021-06-23,SE,Sweden,EURO,678,1088000,2,14662
2021-06-24,SE,Sweden,EURO,506,1088506,3,14665
2021-06-25,SE,Sweden,EURO,379,1088885,0,14665
2021-06-26,SE,Sweden,EURO,373,1089258,2,14667
2021-06-27,SE,Sweden,EURO,31,1089289,2,14669
2021-06-28,SE,Sweden,EURO,8,1089297,0,14669
2021-06-29,SE,Sweden,EURO,8,1089305,0,14669
2021-06-30,SE,Sweden,EURO,444,1089749,2,14671
2021-07-01,SE,Sweden,EURO,251,1090000,1,14672
2021-07-02,SE,Sweden,EURO,560,1090560,1,14673
2021-07-03,SE,Sweden,EURO,284,1090844,1,14674
2021-07-04,SE,Sweden,EURO,326,1091170,1,14675
2021-07-05,SE,Sweden,EURO,3,1091173,2,14677
2021-07-06,SE,Sweden,EURO,2,1091175,0,14677
2021-07-07,SE,Sweden,EURO,415,1091590,0,14677
2021-07-08,SE,Sweden,EURO,369,1091959,2,14679
2021-07-09,SE,Sweden,EURO,258,1092217,0,14679
2021-07-10,SE,Sweden,EURO,237,1092454,0,14679
2021-07-11,SE,Sweden,EURO,228,1092682,0,14679
2021-07-12,SE,Sweden,EURO,7,1092689,0,14679
2021-07-13,SE,Sweden,EURO,0,1092689,1,14680
2021-07-14,SE,Sweden,EURO,443,1093132,0,14680
2021-07-15,SE,Sweden,EURO,370,1093502,0,14680
2021-07-16,SE,Sweden,EURO,350,1093852,0,14680
2021-07-17,SE,Sweden,EURO,366,1094218,1,14681
2021-07-18,SE,Sweden,EURO,337,1094555,0,14681
2021-07-19,SE,Sweden,EURO,11,1094566,1,14682
2021-07-20,SE,Sweden,EURO,6,1094572,0,14682
2021-07-21,SE,Sweden,EURO,628,1095200,0,14682
2021-07-22,SE,Sweden,EURO,517,1095717,0,14682
2021-07-23,SE,Sweden,EURO,582,1096299,1,14683
2021-07-24,SE,Sweden,EURO,477,1096776,1,14684
2021-07-25,SE,Sweden,EURO,444,1097220,1,14685
2021-07-26,SE,Sweden,EURO,11,1097231,0,14685
2021-07-27,SE,Sweden,EURO,2,1097233,0,14685
2021-07-28,SE,Sweden,EURO,839,1098072,0,14685
2021-07-29,SE,Sweden,EURO,653,1098725,0,14685
2021-07-30,SE,Sweden,EURO,656,1099381,1,14686
2021-07-31,SE,Sweden,EURO,621,1100002,2,14688
2021-08-01,SE,Sweden,EURO,686,1100688,1,14689
2021-08-02,SE,Sweden,EURO,4,1100692,0,14689
2021-08-03,SE,Sweden,EURO,1,1100693,0,14689
2021-08-04,SE,Sweden,EURO,1151,1101844,0,14689
2021-08-05,SE,Sweden,EURO,959,1102803,0,14689
2021-08-06,SE,Sweden,EURO,852,1103655,0,14689
2021-08-07,SE,Sweden,EURO,819,1104474,2,14691
2021-08-08,SE,Sweden,EURO,818,1105292,3,14694
2021-08-09,SE,Sweden,EURO,6,1105298,0,14694
2021-08-10,SE,Sweden,EURO,3,1105301,2,14696
2021-08-11,SE,Sweden,EURO,1485,1106786,0,14696
2021-08-12,SE,Sweden,EURO,1201,1107987,1,14697
2021-08-13,SE,Sweden,EURO,1057,1109044,0,14697
2021-08-14,SE,Sweden,EURO,1040,1110084,1,14698
2021-08-15,SE,Sweden,EURO,1016,1111100,2,14700
2021-08-16,SE,Sweden,EURO,8,1111108,1,14701
2021-08-17,SE,Sweden,EURO,10,1111118,1,14702
2021-08-18,SE,Sweden,EURO,1781,1112899,0,14702
2021-08-19,SE,Sweden,EURO,1330,1114229,3,14705
2021-08-20,SE,Sweden,EURO,1275,1115504,1,14706
2021-08-21,SE,Sweden,EURO,1028,1116532,2,14708
2021-08-22,SE,Sweden,EURO,1047,1117579,2,14710
2021-08-23,SE,Sweden,EURO,1,1117580,1,14711
2021-08-24,SE,Sweden,EURO,3,1117583,2,14713
2021-08-25,SE,Sweden,EURO,1708,1119291,5,14718
2021-08-26,SE,Sweden,EURO,1270,1120561,5,14723
2021-08-27,SE,Sweden,EURO,1515,1122076,3,14726
2021-08-28,SE,Sweden,EURO,1271,1123347,1,14727
2021-08-29,SE,Sweden,EURO,917,1124264,0,14727
2021-08-30,SE,Sweden,EURO,3,1124267,1,14728
2021-08-31,SE,Sweden,EURO,5,1124272,5,14733
2021-09-01,SE,Sweden,EURO,2354,1126626,3,14736
2021-09-02,SE,Sweden,EURO,1022,1127648,2,14738
2021-09-03,SE,Sweden,EURO,1103,1128751,2,14740
2021-09-04,SE,Sweden,EURO,1425,1130176,6,14746
2021-09-05,SE,Sweden,EURO,1323,1131499,3,14749
2021-09-06,SE,Sweden,EURO,1,1131500,3,14752
2021-09-07,SE,Sweden,EURO,10,1131510,6,14758
2021-09-08,SE,Sweden,EURO,2179,1133689,4,14762
2021-09-09,SE,Sweden,EURO,1399,1135088,4,14766
2021-09-10,SE,Sweden,EURO,1395,1136483,10,14776
2021-09-11,SE,Sweden,EURO,1479,1137962,8,14784
2021-09-12,SE,Sweden,EURO,1515,1139477,11,14795
2021-09-13,SE,Sweden,EURO,2,1139479,4,14799
2021-09-14,SE,Sweden,EURO,0,1139479,8,14807
2021-09-15,SE,Sweden,EURO,2137,1141616,8,14815
2021-09-16,SE,Sweden,EURO,1114,1142730,7,14822
2021-09-17,SE,Sweden,EURO,1184,1143914,8,14830
2021-09-18,SE,Sweden,EURO,994,1144908,12,14842
2021-09-19,SE,Sweden,EURO,830,1145738,7,14849
2021-09-20,SE,Sweden,EURO,1,1145739,3,14852
2021-09-21,SE,Sweden,EURO,0,1145739,6,14858
2021-09-22,SE,Sweden,EURO,1178,1146917,4,14862
2021-09-23,SE,Sweden,EURO,891,1147808,7,14869
2021-09-24,SE,Sweden,EURO,742,1148550,10,14879
2021-09-25,SE,Sweden,EURO,771,1149321,6,14885
2021-09-26,SE,Sweden,EURO,715,1150036,6,14891
2021-09-27,SE,Sweden,EURO,1,1150037,4,14895
2021-09-28,SE,Sweden,EURO,6,1150043,6,14901
2021-09-29,SE,Sweden,EURO,1069,1151112,3,14904
2021-09-30,SE,Sweden,EURO,845,1151957,4,14908
2021-10-01,SE,Sweden,EURO,852,1152809,7,14915
2021-10-02,SE,Sweden,EURO,766,1153575,5,14920
2021-10-03,SE,Sweden,EURO,698,1154273,5,14925
2021-10-04,SE,Sweden,EURO,2,1154275,6,14931
2021-10-05,SE,Sweden,EURO,0,1154275,9,14940
2021-10-06,SE,Sweden,EURO,1192,1155467,5,14945
2021-10-07,SE,Sweden,EURO,738,1156205,6,14951
2021-10-08,SE,Sweden,EURO,842,1157047,11,14962
2021-10-09,SE,Sweden,EURO,741,1157788,8,14970
2021-10-10,SE,Sweden,EURO,599,1158387,8,14978
2021-10-11,SE,Sweden,EURO,16,1158403,6,14984
2021-10-12,SE,Sweden,EURO,9,1158412,5,14989
2021-10-13,SE,Sweden,EURO,1121,1159533,5,14994
2021-10-14,SE,Sweden,EURO,905,1160438,4,14998
2021-10-15,SE,Sweden,EURO,796,1161234,7,15005
2021-10-16,SE,Sweden,EURO,668,1161902,4,15009
2021-10-17,SE,Sweden,EURO,565,1162467,1,15010
2021-10-18,SE,Sweden,EURO,14,1162481,6,15016
2021-10-19,SE,Sweden,EURO,0,1162481,5,15021
2021-10-20,SE,Sweden,EURO,1078,1163559,6,15027
2021-10-21,SE,Sweden,EURO,818,1164377,3,15030
2021-10-22,SE,Sweden,EURO,786,1165163,3,15033
2021-10-23,SE,Sweden,EURO,777,1165940,4,15037
2021-10-24,SE,Sweden,EURO,891,1166831,3,15040
2021-10-25,SE,Sweden,EURO,525,1167356,3,15043
2021-10-26,SE,Sweden,EURO,319,1167675,1,15044
2021-10-27,SE,Sweden,EURO,540,1168215,6,15050
2021-10-28,SE,Sweden,EURO,1262,1169477,4,15054
2021-10-29,SE,Sweden,EURO,891,1170368,4,15058
2021-10-30,SE,Sweden,EURO,1079,1171447,6,15064
2021-10-31,SE,Sweden,EURO,977,1172424,4,15068
2021-11-01,SE,Sweden,EURO,861,1173285,2,15070
2021-11-02,SE,Sweden,EURO,301,1173586,4,15074
2021-11-03,SE,Sweden,EURO,629,1174215,2,15076
2021-11-04,SE,Sweden,EURO,1162,1175377,5,15081
2021-11-05,SE,Sweden,EURO,837,1176214,10,15091
2021-11-06,SE,Sweden,EURO,826,1177040,2,15093
2021-11-07,SE,Sweden,EURO,731,1177771,4,15097
2021-11-08,SE,Sweden,EURO,597,1178368,7,15104
2021-11-09,SE,Sweden,EURO,278,1178646,3,15107
2021-11-10,SE,Sweden,EURO,502,1179148,2,15109
2021-11-11,SE,Sweden,EURO,1321,1180469,8,15117
2021-11-12,SE,Sweden,EURO,1020,1181489,2,15119
2021-11-13,SE,Sweden,EURO,925,1182414,8,15127
2021-11-14,SE,Sweden,EURO,911,1183325,6,15133
2021-11-15,SE,Sweden,EURO,829,1184154,2,15135
2021-11-16,SE,Sweden,EURO,311,1184465,3,15138
2021-11-17,SE,Sweden,EURO,574,1185039,6,15144
2021-11-18,SE,Sweden,EURO,1296,1186335,5,15149
2021-11-19,SE,Sweden,EURO,1206,1187541,4,15153
2021-11-20,SE,Sweden,EURO,1130,1188671,4,15157
2021-11-21,SE,Sweden,EURO,1314,1189985,6,15163
2021-11-22,SE,Sweden,EURO,1092,1191077,2,15165
2021-11-23,SE,Sweden,EURO,482,1191559,3,15168
2021-11-24,SE,Sweden,EURO,952,1192511,3,15171
2021-11-25,SE,Sweden,EURO,2077,1194588,4,15175
2021-11-26,SE,Sweden,EURO,2107,1196695,2,15177
2021-11-27,SE,Sweden,EURO,2114,1198809,0,15177
2021-11-28,SE,Sweden,EURO,2025,1200834,2,15179
2021-11-29,SE,Sweden,EURO,1759,1202593,2,15181
.
157385a
2022-02-05,SR,Suriname,AMRO,388,74858,3,1274
2022-02-06,SR,Suriname,AMRO,394,75252,0,1274
2022-02-07,SR,Suriname,AMRO,150,75402,5,1279
.
156621c
2022-02-04,SD,Sudan,EMRO,178,59052,15,3603
2022-02-05,SD,Sudan,EMRO,93,59145,1,3604
2022-02-06,SD,Sudan,EMRO,49,59194,0,3604
2022-02-07,SD,Sudan,EMRO,0,59194,0,3604
.
155857c
2022-02-04,LK,Sri Lanka,SEARO,1243,615902,29,15544
2022-02-05,LK,Sri Lanka,SEARO,1287,617189,28,15572
2022-02-06,LK,Sri Lanka,SEARO,1331,618520,23,15595
2022-02-07,LK,Sri Lanka,SEARO,0,618520,0,15595
.
154416,155093c
2020-03-29,ES,Spain,EURO,12717,99816,941,6959
2020-03-30,ES,Spain,EURO,7096,106912,839,7798
2020-03-31,ES,Spain,EURO,5092,112004,811,8609
2020-04-01,ES,Spain,EURO,8008,120012,913,9522
2020-04-02,ES,Spain,EURO,7925,127937,899,10421
2020-04-03,ES,Spain,EURO,7058,134995,895,11316
2020-04-04,ES,Spain,EURO,6905,141900,858,12174
2020-04-05,ES,Spain,EURO,6821,148721,786,12960
2020-04-06,ES,Spain,EURO,4670,153391,740,13700
2020-04-07,ES,Spain,EURO,3147,156538,750,14450
2020-04-08,ES,Spain,EURO,5396,161934,766,15216
2020-04-09,ES,Spain,EURO,5324,167258,736,15952
2020-04-10,ES,Spain,EURO,5488,172746,749,16701
2020-04-11,ES,Spain,EURO,4609,177355,667,17368
2020-04-12,ES,Spain,EURO,4438,181793,676,18044
2020-04-13,ES,Spain,EURO,3075,184868,628,18672
2020-04-14,ES,Spain,EURO,2379,187247,544,19216
2020-04-15,ES,Spain,EURO,3127,190374,587,19803
2020-04-16,ES,Spain,EURO,3993,194367,607,20410
2020-04-17,ES,Spain,EURO,3702,198069,552,20962
2020-04-18,ES,Spain,EURO,3417,201486,487,21449
2020-04-19,ES,Spain,EURO,3462,204948,507,21956
2020-04-20,ES,Spain,EURO,2181,207129,435,22391
2020-04-21,ES,Spain,EURO,1446,208575,401,22792
2020-04-22,ES,Spain,EURO,2518,211093,387,23179
2020-04-23,ES,Spain,EURO,2728,213821,427,23606
2020-04-24,ES,Spain,EURO,2770,216591,344,23950
2020-04-25,ES,Spain,EURO,2222,218813,331,24281
2020-04-26,ES,Spain,EURO,2283,221096,330,24611
2020-04-27,ES,Spain,EURO,1292,222388,295,24906
2020-04-28,ES,Spain,EURO,818,223206,272,25178
2020-04-29,ES,Spain,EURO,1653,224859,258,25436
2020-04-30,ES,Spain,EURO,1736,226595,259,25695
2020-05-01,ES,Spain,EURO,1484,228079,236,25931
2020-05-02,ES,Spain,EURO,1438,229517,223,26154
2020-05-03,ES,Spain,EURO,792,230309,176,26330
2020-05-04,ES,Spain,EURO,566,230875,202,26532
2020-05-05,ES,Spain,EURO,452,231327,197,26729
2020-05-06,ES,Spain,EURO,1013,232340,186,26915
2020-05-07,ES,Spain,EURO,980,233320,183,27098
2020-05-08,ES,Spain,EURO,981,234301,153,27251
2020-05-09,ES,Spain,EURO,956,235257,166,27417
2020-05-10,ES,Spain,EURO,917,236174,146,27563
2020-05-11,ES,Spain,EURO,491,236665,125,27688
2020-05-12,ES,Spain,EURO,317,236982,110,27798
2020-05-13,ES,Spain,EURO,736,237718,122,27920
2020-05-14,ES,Spain,EURO,696,238414,113,28033
2020-05-15,ES,Spain,EURO,792,239206,87,28120
2020-05-16,ES,Spain,EURO,777,239983,86,28206
2020-05-17,ES,Spain,EURO,787,240770,77,28283
2020-05-18,ES,Spain,EURO,342,241112,63,28346
2020-05-19,ES,Spain,EURO,240,241352,61,28407
2020-05-20,ES,Spain,EURO,617,241969,72,28479
2020-05-21,ES,Spain,EURO,823,242792,70,28549
2020-05-22,ES,Spain,EURO,729,243521,57,28606
2020-05-23,ES,Spain,EURO,767,244288,70,28676
2020-05-24,ES,Spain,EURO,797,245085,71,28747
2020-05-25,ES,Spain,EURO,303,245388,60,28807
2020-05-26,ES,Spain,EURO,259,245647,55,28862
2020-05-27,ES,Spain,EURO,537,246184,68,28930
2020-05-28,ES,Spain,EURO,733,246917,55,28985
2020-05-29,ES,Spain,EURO,601,247518,45,29030
2020-05-30,ES,Spain,EURO,645,248163,41,29071
2020-05-31,ES,Spain,EURO,708,248871,45,29116
2020-06-01,ES,Spain,EURO,331,249202,43,29159
2020-06-02,ES,Spain,EURO,178,249380,40,29199
2020-06-03,ES,Spain,EURO,345,249725,35,29234
2020-06-04,ES,Spain,EURO,456,250181,47,29281
2020-06-05,ES,Spain,EURO,573,250754,39,29320
2020-06-06,ES,Spain,EURO,487,251241,48,29368
2020-06-07,ES,Spain,EURO,636,251877,23,29391
2020-06-08,ES,Spain,EURO,257,252134,29,29420
2020-06-09,ES,Spain,EURO,143,252277,21,29441
2020-06-10,ES,Spain,EURO,330,252607,29,29470
2020-06-11,ES,Spain,EURO,434,253041,15,29485
2020-06-12,ES,Spain,EURO,441,253482,31,29516
2020-06-13,ES,Spain,EURO,373,253855,24,29540
2020-06-14,ES,Spain,EURO,481,254336,19,29559
2020-06-15,ES,Spain,EURO,121,254457,23,29582
2020-06-16,ES,Spain,EURO,84,254541,20,29602
2020-06-17,ES,Spain,EURO,286,254827,20,29622
2020-06-18,ES,Spain,EURO,376,255203,11,29633
2020-06-19,ES,Spain,EURO,340,255543,25,29658
2020-06-20,ES,Spain,EURO,364,255907,12,29670
2020-06-21,ES,Spain,EURO,340,256247,18,29688
2020-06-22,ES,Spain,EURO,226,256473,14,29702
2020-06-23,ES,Spain,EURO,163,256636,15,29717
2020-06-24,ES,Spain,EURO,236,256872,7,29724
2020-06-25,ES,Spain,EURO,434,257306,8,29732
2020-06-26,ES,Spain,EURO,330,257636,12,29744
2020-06-27,ES,Spain,EURO,357,257993,11,29755
2020-06-28,ES,Spain,EURO,470,258463,9,29764
2020-06-29,ES,Spain,EURO,251,258714,3,29767
2020-06-30,ES,Spain,EURO,190,258904,12,29779
2020-07-01,ES,Spain,EURO,274,259178,11,29790
2020-07-02,ES,Spain,EURO,444,259622,11,29801
2020-07-03,ES,Spain,EURO,457,260079,10,29811
2020-07-04,ES,Spain,EURO,483,260562,1,29812
2020-07-05,ES,Spain,EURO,592,261154,5,29817
2020-07-06,ES,Spain,EURO,295,261449,7,29824
2020-07-07,ES,Spain,EURO,208,261657,1,29825
2020-07-08,ES,Spain,EURO,340,261997,3,29828
2020-07-09,ES,Spain,EURO,707,262704,6,29834
2020-07-10,ES,Spain,EURO,738,263442,4,29838
2020-07-11,ES,Spain,EURO,848,264290,1,29839
2020-07-12,ES,Spain,EURO,1146,265436,5,29844
2020-07-13,ES,Spain,EURO,614,266050,7,29851
2020-07-14,ES,Spain,EURO,387,266437,2,29853
2020-07-15,ES,Spain,EURO,852,267289,2,29855
2020-07-16,ES,Spain,EURO,1255,268544,3,29858
2020-07-17,ES,Spain,EURO,1557,270101,5,29863
2020-07-18,ES,Spain,EURO,1624,271725,2,29865
2020-07-19,ES,Spain,EURO,2071,273796,2,29867
2020-07-20,ES,Spain,EURO,1516,275312,4,29871
2020-07-21,ES,Spain,EURO,1149,276461,6,29877
2020-07-22,ES,Spain,EURO,1589,278050,8,29885
2020-07-23,ES,Spain,EURO,2320,280370,8,29893
2020-07-24,ES,Spain,EURO,2332,282702,4,29897
2020-07-25,ES,Spain,EURO,2363,285065,4,29901
2020-07-26,ES,Spain,EURO,2844,287909,8,29909
2020-07-27,ES,Spain,EURO,1714,289623,11,29920
2020-07-28,ES,Spain,EURO,1379,291002,7,29927
2020-07-29,ES,Spain,EURO,2039,293041,10,29937
2020-07-30,ES,Spain,EURO,2900,295941,13,29950
2020-07-31,ES,Spain,EURO,3150,299091,11,29961
2020-08-01,ES,Spain,EURO,3409,302500,12,29973
2020-08-02,ES,Spain,EURO,3822,306322,16,29989
2020-08-03,ES,Spain,EURO,3050,309372,12,30001
2020-08-04,ES,Spain,EURO,1841,311213,15,30016
2020-08-05,ES,Spain,EURO,2709,313922,12,30028
2020-08-06,ES,Spain,EURO,4405,318327,20,30048
2020-08-07,ES,Spain,EURO,4287,322614,13,30061
2020-08-08,ES,Spain,EURO,4816,327430,30,30091
2020-08-09,ES,Spain,EURO,5656,333086,23,30114
2020-08-10,ES,Spain,EURO,3498,336584,31,30145
2020-08-11,ES,Spain,EURO,2626,339210,18,30163
2020-08-12,ES,Spain,EURO,3847,343057,31,30194
2020-08-13,ES,Spain,EURO,5990,349047,31,30225
2020-08-14,ES,Spain,EURO,6392,355439,29,30254
2020-08-15,ES,Spain,EURO,7010,362449,25,30279
2020-08-16,ES,Spain,EURO,8328,370777,37,30316
2020-08-17,ES,Spain,EURO,4828,375605,30,30346
2020-08-18,ES,Spain,EURO,3296,378901,23,30369
2020-08-19,ES,Spain,EURO,4970,383871,31,30400
2020-08-20,ES,Spain,EURO,8463,392334,44,30444
2020-08-21,ES,Spain,EURO,8633,400967,47,30491
2020-08-22,ES,Spain,EURO,9020,409987,41,30532
2020-08-23,ES,Spain,EURO,10479,420466,44,30576
2020-08-24,ES,Spain,EURO,6052,426518,44,30620
2020-08-25,ES,Spain,EURO,4294,430812,55,30675
2020-08-26,ES,Spain,EURO,6034,436846,55,30730
2020-08-27,ES,Spain,EURO,10313,447159,44,30774
2020-08-28,ES,Spain,EURO,10297,457456,51,30825
2020-08-29,ES,Spain,EURO,10318,467774,49,30874
2020-08-30,ES,Spain,EURO,11956,479730,70,30944
2020-08-31,ES,Spain,EURO,6871,486601,53,30997
2020-09-01,ES,Spain,EURO,5180,491781,59,31056
2020-09-02,ES,Spain,EURO,6640,498421,65,31121
2020-09-03,ES,Spain,EURO,10469,508890,68,31189
2020-09-04,ES,Spain,EURO,10713,519603,79,31268
2020-09-05,ES,Spain,EURO,10958,530561,80,31348
2020-09-06,ES,Spain,EURO,13189,543750,80,31428
2020-09-07,ES,Spain,EURO,7881,551631,68,31496
2020-09-08,ES,Spain,EURO,5489,557120,61,31557
2020-09-09,ES,Spain,EURO,7035,564155,80,31637
2020-09-10,ES,Spain,EURO,11949,576104,84,31721
2020-09-11,ES,Spain,EURO,12786,588890,95,31816
2020-09-12,ES,Spain,EURO,12992,601882,96,31912
2020-09-13,ES,Spain,EURO,14407,616289,96,32008
2020-09-14,ES,Spain,EURO,8312,624601,102,32110
2020-09-15,ES,Spain,EURO,6401,631002,106,32216
2020-09-16,ES,Spain,EURO,8190,639192,109,32325
2020-09-17,ES,Spain,EURO,13807,652999,137,32462
2020-09-18,ES,Spain,EURO,14017,667016,109,32571
2020-09-19,ES,Spain,EURO,13779,680795,124,32695
2020-09-20,ES,Spain,EURO,16732,697527,115,32810
2020-09-21,ES,Spain,EURO,8327,705854,123,32933
2020-09-22,ES,Spain,EURO,5856,711710,103,33036
2020-09-23,ES,Spain,EURO,8022,719732,123,33159
2020-09-24,ES,Spain,EURO,12794,732526,127,33286
2020-09-25,ES,Spain,EURO,12746,745272,111,33397
2020-09-26,ES,Spain,EURO,12651,757923,133,33530
2020-09-27,ES,Spain,EURO,13532,771455,131,33661
2020-09-28,ES,Spain,EURO,7642,779097,116,33777
2020-09-29,ES,Spain,EURO,5045,784142,120,33897
2020-09-30,ES,Spain,EURO,7069,791211,141,34038
2020-10-01,ES,Spain,EURO,11323,802534,147,34185
2020-10-02,ES,Spain,EURO,11195,813729,153,34338
2020-10-03,ES,Spain,EURO,11055,824784,135,34473
2020-10-04,ES,Spain,EURO,12380,837164,132,34605
2020-10-05,ES,Spain,EURO,6883,844047,106,34711
2020-10-06,ES,Spain,EURO,5130,849177,96,34807
2020-10-07,ES,Spain,EURO,8873,858050,127,34934
2020-10-08,ES,Spain,EURO,12230,870280,132,35066
2020-10-09,ES,Spain,EURO,12403,882683,132,35198
2020-10-10,ES,Spain,EURO,13862,896545,134,35332
2020-10-11,ES,Spain,EURO,14786,911331,150,35482
2020-10-12,ES,Spain,EURO,8720,920051,137,35619
2020-10-13,ES,Spain,EURO,6761,926812,113,35732
2020-10-14,ES,Spain,EURO,6330,933142,128,35860
2020-10-15,ES,Spain,EURO,12371,945513,148,36008
2020-10-16,ES,Spain,EURO,16377,961890,141,36149
2020-10-17,ES,Spain,EURO,17518,979408,148,36297
2020-10-18,ES,Spain,EURO,18275,997683,150,36447
2020-10-19,ES,Spain,EURO,11946,1009629,132,36579
2020-10-20,ES,Spain,EURO,8249,1017878,152,36731
2020-10-21,ES,Spain,EURO,15678,1033556,175,36906
2020-10-22,ES,Spain,EURO,20917,1054473,188,37094
2020-10-23,ES,Spain,EURO,23234,1077707,176,37270
2020-10-24,ES,Spain,EURO,23827,1101534,209,37479
2020-10-25,ES,Spain,EURO,25020,1126554,216,37695
2020-10-26,ES,Spain,EURO,15445,1141999,192,37887
2020-10-27,ES,Spain,EURO,11276,1153275,195,38082
2020-10-28,ES,Spain,EURO,20005,1173280,218,38300
2020-10-29,ES,Spain,EURO,24345,1197625,242,38542
2020-10-30,ES,Spain,EURO,24638,1222263,247,38789
2020-10-31,ES,Spain,EURO,24206,1246469,254,39043
2020-11-01,ES,Spain,EURO,24954,1271423,263,39306
2020-11-02,ES,Spain,EURO,16086,1287509,269,39575
2020-11-03,ES,Spain,EURO,10977,1298486,268,39843
2020-11-04,ES,Spain,EURO,15513,1313999,304,40147
2020-11-05,ES,Spain,EURO,22051,1336050,325,40472
2020-11-06,ES,Spain,EURO,24143,1360193,356,40828
2020-11-07,ES,Spain,EURO,23564,1383757,331,41159
2020-11-08,ES,Spain,EURO,23518,1407275,355,41514
2020-11-09,ES,Spain,EURO,14581,1421856,287,41801
2020-11-10,ES,Spain,EURO,9847,1431703,319,42120
2020-11-11,ES,Spain,EURO,16534,1448237,320,42440
2020-11-12,ES,Spain,EURO,20586,1468823,350,42790
2020-11-13,ES,Spain,EURO,19993,1488816,362,43152
2020-11-14,ES,Spain,EURO,19166,1507982,359,43511
2020-11-15,ES,Spain,EURO,18425,1526407,357,43868
2020-11-16,ES,Spain,EURO,10587,1536994,302,44170
2020-11-17,ES,Spain,EURO,6664,1543658,287,44457
2020-11-18,ES,Spain,EURO,12800,1556458,326,44783
2020-11-19,ES,Spain,EURO,15866,1572324,377,45160
2020-11-20,ES,Spain,EURO,14807,1587131,296,45456
2020-11-21,ES,Spain,EURO,13179,1600310,315,45771
2020-11-22,ES,Spain,EURO,12632,1612942,323,46094
2020-11-23,ES,Spain,EURO,7237,1620179,283,46377
2020-11-24,ES,Spain,EURO,4609,1624788,252,46629
2020-11-25,ES,Spain,EURO,9131,1633919,297,46926
2020-11-26,ES,Spain,EURO,10938,1644857,244,47170
2020-11-27,ES,Spain,EURO,9981,1654838,294,47464
2020-11-28,ES,Spain,EURO,9633,1664471,293,47757
2020-11-29,ES,Spain,EURO,9922,1674393,269,48026
2020-11-30,ES,Spain,EURO,5509,1679902,221,48247
2020-12-01,ES,Spain,EURO,3418,1683320,222,48469
2020-12-02,ES,Spain,EURO,7420,1690740,229,48698
2020-12-03,ES,Spain,EURO,9505,1700245,231,48929
2020-12-04,ES,Spain,EURO,8880,1709125,221,49150
2020-12-05,ES,Spain,EURO,8136,1717261,238,49388
2020-12-06,ES,Spain,EURO,8422,1725683,233,49621
2020-12-07,ES,Spain,EURO,4956,1730639,195,49816
2020-12-08,ES,Spain,EURO,3275,1733914,173,49989
2020-12-09,ES,Spain,EURO,5223,1739137,203,50192
2020-12-10,ES,Spain,EURO,4033,1743170,169,50361
2020-12-11,ES,Spain,EURO,8408,1751578,224,50585
2020-12-12,ES,Spain,EURO,10749,1762327,187,50772
2020-12-13,ES,Spain,EURO,11315,1773642,211,50983
2020-12-14,ES,Spain,EURO,6588,1780230,185,51168
2020-12-15,ES,Spain,EURO,4239,1784469,162,51330
2020-12-16,ES,Spain,EURO,9895,1794364,165,51495
2020-12-17,ES,Spain,EURO,12164,1806528,186,51681
2020-12-18,ES,Spain,EURO,11732,1818260,150,51831
2020-12-19,ES,Spain,EURO,10966,1829226,177,52008
2020-12-20,ES,Spain,EURO,12202,1841428,176,52184
2020-12-21,ES,Spain,EURO,6914,1848342,141,52325
2020-12-22,ES,Spain,EURO,4390,1852732,156,52481
2020-12-23,ES,Spain,EURO,10992,1863724,148,52629
2020-12-24,ES,Spain,EURO,13394,1877118,184,52813
2020-12-25,ES,Spain,EURO,14497,1891615,195,53008
2020-12-26,ES,Spain,EURO,9984,1901599,157,53165
2020-12-27,ES,Spain,EURO,4822,1906421,146,53311
2020-12-28,ES,Spain,EURO,6398,1912819,176,53487
2020-12-29,ES,Spain,EURO,5986,1918805,166,53653
2020-12-30,ES,Spain,EURO,15081,1933886,195,53848
2020-12-31,ES,Spain,EURO,18894,1952780,166,54014
2021-01-01,ES,Spain,EURO,21119,1973899,200,54214
2021-01-02,ES,Spain,EURO,15591,1989490,192,54406
2021-01-03,ES,Spain,EURO,7652,1997142,174,54580
2021-01-04,ES,Spain,EURO,10461,2007603,188,54768
2021-01-05,ES,Spain,EURO,9965,2017568,179,54947
2021-01-06,ES,Spain,EURO,22127,2039695,192,55139
2021-01-07,ES,Spain,EURO,30729,2070424,243,55382
2021-01-08,ES,Spain,EURO,14581,2085005,180,55562
2021-01-09,ES,Spain,EURO,26772,2111777,236,55798
2021-01-10,ES,Spain,EURO,32852,2144629,242,56040
2021-01-11,ES,Spain,EURO,19298,2163927,230,56270
2021-01-12,ES,Spain,EURO,13904,2177831,243,56513
2021-01-13,ES,Spain,EURO,32463,2210294,286,56799
2021-01-14,ES,Spain,EURO,37343,2247637,284,57083
2021-01-15,ES,Spain,EURO,38954,2286591,292,57375
2021-01-16,ES,Spain,EURO,38356,2324947,319,57694
2021-01-17,ES,Spain,EURO,42919,2367866,393,58087
2021-01-18,ES,Spain,EURO,24998,2392864,365,58452
2021-01-19,ES,Spain,EURO,18622,2411486,367,58819
2021-01-20,ES,Spain,EURO,35722,2447208,412,59231
2021-01-21,ES,Spain,EURO,42380,2489588,490,59721
2021-01-22,ES,Spain,EURO,41859,2531447,459,60180
2021-01-23,ES,Spain,EURO,40795,2572242,491,60671
2021-01-24,ES,Spain,EURO,42176,2614418,568,61239
2021-01-25,ES,Spain,EURO,23810,2638228,453,61692
2021-01-26,ES,Spain,EURO,17326,2655554,518,62210
2021-01-27,ES,Spain,EURO,32758,2688312,529,62739
2021-01-28,ES,Spain,EURO,37440,2725752,550,63289
2021-01-29,ES,Spain,EURO,35839,2761591,595,63884
2021-01-30,ES,Spain,EURO,33344,2794935,576,64460
2021-01-31,ES,Spain,EURO,32339,2827274,533,64993
2021-02-01,ES,Spain,EURO,18172,2845446,515,65508
2021-02-02,ES,Spain,EURO,11708,2857154,486,65994
2021-02-03,ES,Spain,EURO,22497,2879651,544,66538
2021-02-04,ES,Spain,EURO,25989,2905640,493,67031
2021-02-05,ES,Spain,EURO,23804,2929444,492,67523
2021-02-06,ES,Spain,EURO,21110,2950554,464,67987
2021-02-07,ES,Spain,EURO,20167,2970721,462,68449
2021-02-08,ES,Spain,EURO,10322,2981043,408,68857
2021-02-09,ES,Spain,EURO,6097,2987140,382,69239
2021-02-10,ES,Spain,EURO,13790,3000930,411,69650
2021-02-11,ES,Spain,EURO,15357,3016287,386,70036
2021-02-12,ES,Spain,EURO,13337,3029624,408,70444
2021-02-13,ES,Spain,EURO,11856,3041480,355,70799
2021-02-14,ES,Spain,EURO,11692,3053172,340,71139
2021-02-15,ES,Spain,EURO,5744,3058916,289,71428
2021-02-16,ES,Spain,EURO,3584,3062500,244,71672
2021-02-17,ES,Spain,EURO,8857,3071357,285,71957
2021-02-18,ES,Spain,EURO,9862,3081219,298,72255
2021-02-19,ES,Spain,EURO,8618,3089837,260,72515
2021-02-20,ES,Spain,EURO,8179,3098016,242,72757
2021-02-21,ES,Spain,EURO,7974,3105990,225,72982
2021-02-22,ES,Spain,EURO,4014,3110004,185,73167
2021-02-23,ES,Spain,EURO,2669,3112673,183,73350
2021-02-24,ES,Spain,EURO,6836,3119509,226,73576
2021-02-25,ES,Spain,EURO,7374,3126883,190,73766
2021-02-26,ES,Spain,EURO,6477,3133360,207,73973
2021-02-27,ES,Spain,EURO,6178,3139538,197,74170
2021-02-28,ES,Spain,EURO,6464,3146002,176,74346
2021-03-01,ES,Spain,EURO,3212,3149214,162,74508
2021-03-02,ES,Spain,EURO,2242,3151456,149,74657
2021-03-03,ES,Spain,EURO,5383,3156839,134,74791
2021-03-04,ES,Spain,EURO,5892,3162731,154,74945
2021-03-05,ES,Spain,EURO,5952,3168683,142,75087
2021-03-06,ES,Spain,EURO,5605,3174288,136,75223
2021-03-07,ES,Spain,EURO,5730,3180018,131,75354
2021-03-08,ES,Spain,EURO,2860,3182878,126,75480
2021-03-09,ES,Spain,EURO,2050,3184928,98,75578
2021-03-10,ES,Spain,EURO,5120,3190048,119,75697
2021-03-11,ES,Spain,EURO,5671,3195719,117,75814
2021-03-12,ES,Spain,EURO,5526,3201245,102,75916
2021-03-13,ES,Spain,EURO,5367,3206612,97,76013
2021-03-14,ES,Spain,EURO,5822,3212434,107,76120
2021-03-15,ES,Spain,EURO,2833,3215267,85,76205
2021-03-16,ES,Spain,EURO,1973,3217240,78,76283
2021-03-17,ES,Spain,EURO,5585,3222825,100,76383
2021-03-18,ES,Spain,EURO,6112,3228937,112,76495
2021-03-19,ES,Spain,EURO,5830,3234767,96,76591
2021-03-20,ES,Spain,EURO,6382,3241149,70,76661
2021-03-21,ES,Spain,EURO,4696,3245845,67,76728
2021-03-22,ES,Spain,EURO,2914,3248759,67,76795
2021-03-23,ES,Spain,EURO,2315,3251074,67,76862
2021-03-24,ES,Spain,EURO,6152,3257226,74,76936
2021-03-25,ES,Spain,EURO,7379,3264605,90,77026
2021-03-26,ES,Spain,EURO,6951,3271556,54,77080
2021-03-27,ES,Spain,EURO,7341,3278897,67,77147
2021-03-28,ES,Spain,EURO,7672,3286569,86,77233
2021-03-29,ES,Spain,EURO,4124,3290693,65,77298
2021-03-30,ES,Spain,EURO,2943,3293636,71,77369
2021-03-31,ES,Spain,EURO,7418,3301054,88,77457
2021-04-01,ES,Spain,EURO,8213,3309267,85,77542
2021-04-02,ES,Spain,EURO,9021,3318288,76,77618
2021-04-03,ES,Spain,EURO,5712,3324000,74,77692
2021-04-04,ES,Spain,EURO,3856,3327856,70,77762
2021-04-05,ES,Spain,EURO,4592,3332448,78,77840
2021-04-06,ES,Spain,EURO,4274,3336722,58,77898
2021-04-07,ES,Spain,EURO,7724,3344446,73,77971
2021-04-08,ES,Spain,EURO,10888,3355334,80,78051
2021-04-09,ES,Spain,EURO,10625,3365959,92,78143
2021-04-10,ES,Spain,EURO,10392,3376351,83,78226
2021-04-11,ES,Spain,EURO,10549,3386900,81,78307
2021-04-12,ES,Spain,EURO,5666,3392566,90,78397
2021-04-13,ES,Spain,EURO,3943,3396509,52,78449
2021-04-14,ES,Spain,EURO,9043,3405552,95,78544
2021-04-15,ES,Spain,EURO,10198,3415750,81,78625
2021-04-16,ES,Spain,EURO,10399,3426149,90,78715
2021-04-17,ES,Spain,EURO,9739,3435888,73,78788
2021-04-18,ES,Spain,EURO,10064,3445952,81,78869
2021-04-19,ES,Spain,EURO,5342,3451294,76,78945
2021-04-20,ES,Spain,EURO,3937,3455231,59,79004
2021-04-21,ES,Spain,EURO,8736,3463967,85,79089
2021-04-22,ES,Spain,EURO,10713,3474680,80,79169
2021-04-23,ES,Spain,EURO,9758,3484438,64,79233
2021-04-24,ES,Spain,EURO,9839,3494277,72,79305
2021-04-25,ES,Spain,EURO,9952,3504229,78,79383
2021-04-26,ES,Spain,EURO,5052,3509281,74,79457
2021-04-27,ES,Spain,EURO,3868,3513149,64,79521
2021-04-28,ES,Spain,EURO,8959,3522108,67,79588
2021-04-29,ES,Spain,EURO,9781,3531889,66,79654
2021-04-30,ES,Spain,EURO,9332,3541221,66,79720
2021-05-01,ES,Spain,EURO,8902,3550123,60,79780
2021-05-02,ES,Spain,EURO,9064,3559187,65,79845
2021-05-03,ES,Spain,EURO,3921,3563108,55,79900
2021-05-04,ES,Spain,EURO,3111,3566219,51,79951
2021-05-05,ES,Spain,EURO,6080,3572299,73,80024
2021-05-06,ES,Spain,EURO,7524,3579823,68,80092
2021-05-07,ES,Spain,EURO,7945,3587768,68,80160
2021-05-08,ES,Spain,EURO,6950,3594718,60,80220
2021-05-09,ES,Spain,EURO,7553,3602271,69,80289
2021-05-10,ES,Spain,EURO,3444,3605715,52,80341
2021-05-11,ES,Spain,EURO,2430,3608145,50,80391
2021-05-12,ES,Spain,EURO,6060,3614205,53,80444
2021-05-13,ES,Spain,EURO,5965,3620170,50,80494
2021-05-14,ES,Spain,EURO,5904,3626074,54,80548
2021-05-15,ES,Spain,EURO,5730,3631804,54,80602
2021-05-16,ES,Spain,EURO,5922,3637726,45,80647
2021-05-17,ES,Spain,EURO,2855,3640581,42,80689
2021-05-18,ES,Spain,EURO,2205,3642786,40,80729
2021-05-19,ES,Spain,EURO,5189,3647975,35,80764
2021-05-20,ES,Spain,EURO,6000,3653975,35,80799
2021-05-21,ES,Spain,EURO,5378,3659353,48,80847
2021-05-22,ES,Spain,EURO,5466,3664819,33,80880
2021-05-23,ES,Spain,EURO,5645,3670464,43,80923
2021-05-24,ES,Spain,EURO,2695,3673159,34,80957
2021-05-25,ES,Spain,EURO,1986,3675145,32,80989
2021-05-26,ES,Spain,EURO,4552,3679697,36,81025
2021-05-27,ES,Spain,EURO,5413,3685110,23,81048
2021-05-28,ES,Spain,EURO,5301,3690411,38,81086
2021-05-29,ES,Spain,EURO,5359,3695770,16,81102
2021-05-30,ES,Spain,EURO,5356,3701126,21,81123
2021-05-31,ES,Spain,EURO,2898,3704024,21,81144
2021-06-01,ES,Spain,EURO,1946,3705970,28,81172
2021-06-02,ES,Spain,EURO,4855,3710825,38,81210
2021-06-03,ES,Spain,EURO,5124,3715949,24,81234
2021-06-04,ES,Spain,EURO,5116,3721065,33,81267
2021-06-05,ES,Spain,EURO,4468,3725533,28,81295
2021-06-06,ES,Spain,EURO,4569,3730102,32,81327
2021-06-07,ES,Spain,EURO,2436,3732538,24,81351
2021-06-08,ES,Spain,EURO,1708,3734246,26,81377
2021-06-09,ES,Spain,EURO,4158,3738404,19,81396
2021-06-10,ES,Spain,EURO,4137,3742541,27,81423
2021-06-11,ES,Spain,EURO,4093,3746634,18,81441
2021-06-12,ES,Spain,EURO,4123,3750757,25,81466
2021-06-13,ES,Spain,EURO,3993,3754750,12,81478
2021-06-14,ES,Spain,EURO,2200,3756950,20,81498
2021-06-15,ES,Spain,EURO,1543,3758493,19,81517
2021-06-16,ES,Spain,EURO,3615,3762108,16,81533
2021-06-17,ES,Spain,EURO,4067,3766175,23,81556
2021-06-18,ES,Spain,EURO,3974,3770149,21,81577
2021-06-19,ES,Spain,EURO,3978,3774127,21,81598
2021-06-20,ES,Spain,EURO,4004,3778131,16,81614
2021-06-21,ES,Spain,EURO,2257,3780388,8,81622
2021-06-22,ES,Spain,EURO,1663,3782051,15,81637
2021-06-23,ES,Spain,EURO,3858,3785909,19,81656
2021-06-24,ES,Spain,EURO,4418,3790327,17,81673
2021-06-25,ES,Spain,EURO,5021,3795348,17,81690
2021-06-26,ES,Spain,EURO,3879,3799227,14,81704
2021-06-27,ES,Spain,EURO,5662,3804889,13,81717
2021-06-28,ES,Spain,EURO,3744,3808633,13,81730
2021-06-29,ES,Spain,EURO,3118,3811751,19,81749
2021-06-30,ES,Spain,EURO,8107,3819858,14,81763
2021-07-01,ES,Spain,EURO,10707,3830565,14,81777
2021-07-02,ES,Spain,EURO,13064,3843629,13,81790
2021-07-03,ES,Spain,EURO,14014,3857643,15,81805
2021-07-04,ES,Spain,EURO,14921,3872564,6,81811
2021-07-05,ES,Spain,EURO,10273,3882837,15,81826
2021-07-06,ES,Spain,EURO,7634,3890471,9,81835
2021-07-07,ES,Spain,EURO,16879,3907350,10,81845
2021-07-08,ES,Spain,EURO,20439,3927789,13,81858
2021-07-09,ES,Spain,EURO,23014,3950803,9,81867
2021-07-10,ES,Spain,EURO,22713,3973516,7,81874
2021-07-11,ES,Spain,EURO,24515,3998031,14,81888
2021-07-12,ES,Spain,EURO,15002,4013033,18,81906
2021-07-13,ES,Spain,EURO,12261,4025294,15,81921
2021-07-14,ES,Spain,EURO,25794,4051088,16,81937
2021-07-15,ES,Spain,EURO,28384,4079472,20,81957
2021-07-16,ES,Spain,EURO,29823,4109295,21,81978
2021-07-17,ES,Spain,EURO,29460,4138755,20,81998
2021-07-18,ES,Spain,EURO,29657,4168412,37,82035
2021-07-19,ES,Spain,EURO,18508,4186920,18,82053
2021-07-20,ES,Spain,EURO,14456,4201376,20,82073
2021-07-21,ES,Spain,EURO,29799,4231175,32,82105
2021-07-22,ES,Spain,EURO,31784,4262959,46,82151
2021-07-23,ES,Spain,EURO,31831,4294790,49,82200
2021-07-24,ES,Spain,EURO,31014,4325804,45,82245
2021-07-25,ES,Spain,EURO,30078,4355882,44,82289
2021-07-26,ES,Spain,EURO,18125,4374007,78,82367
2021-07-27,ES,Spain,EURO,12631,4386638,51,82418
2021-07-28,ES,Spain,EURO,25687,4412325,59,82477
2021-07-29,ES,Spain,EURO,28854,4441179,77,82554
2021-07-30,ES,Spain,EURO,26950,4468129,64,82618
2021-07-31,ES,Spain,EURO,25567,4493696,67,82685
2021-08-01,ES,Spain,EURO,25720,4519416,87,82772
2021-08-02,ES,Spain,EURO,14748,4534164,83,82855
2021-08-03,ES,Spain,EURO,9575,4543739,75,82930
2021-08-04,ES,Spain,EURO,19821,4563560,91,83021
2021-08-05,ES,Spain,EURO,21549,4585109,90,83111
2021-08-06,ES,Spain,EURO,20551,4605660,112,83223
2021-08-07,ES,Spain,EURO,19554,4625214,89,83312
2021-08-08,ES,Spain,EURO,19125,4644339,95,83407
2021-08-09,ES,Spain,EURO,10978,4655317,80,83487
2021-08-10,ES,Spain,EURO,7231,4662548,75,83562
2021-08-11,ES,Spain,EURO,15031,4677579,104,83666
2021-08-12,ES,Spain,EURO,17209,4694788,99,83765
2021-08-13,ES,Spain,EURO,15782,4710570,102,83867
2021-08-14,ES,Spain,EURO,14856,4725426,123,83990
2021-08-15,ES,Spain,EURO,13839,4739265,101,84091
2021-08-16,ES,Spain,EURO,8027,4747292,102,84193
2021-08-17,ES,Spain,EURO,5558,4752850,113,84306
2021-08-18,ES,Spain,EURO,9581,4762431,107,84413
2021-08-19,ES,Spain,EURO,11988,4774419,123,84536
2021-08-20,ES,Spain,EURO,12584,4787003,103,84639
2021-08-21,ES,Spain,EURO,11744,4798747,93,84732
2021-08-22,ES,Spain,EURO,11720,4810467,92,84824
2021-08-23,ES,Spain,EURO,6498,4816965,82,84906
2021-08-24,ES,Spain,EURO,4094,4821059,72,84978
2021-08-25,ES,Spain,EURO,9812,4830871,94,85072
2021-08-26,ES,Spain,EURO,9819,4840690,84,85156
2021-08-27,ES,Spain,EURO,9041,4849731,104,85260
2021-08-28,ES,Spain,EURO,8167,4857898,77,85337
2021-08-29,ES,Spain,EURO,8102,4866000,85,85422
2021-08-30,ES,Spain,EURO,4016,4870016,71,85493
2021-08-31,ES,Spain,EURO,2681,4872697,72,85565
2021-09-01,ES,Spain,EURO,6222,4878919,89,85654
2021-09-02,ES,Spain,EURO,7128,4886047,80,85734
2021-09-03,ES,Spain,EURO,5929,4891976,85,85819
2021-09-04,ES,Spain,EURO,5255,4897231,70,85889
2021-09-05,ES,Spain,EURO,4878,4902109,75,85964
2021-09-06,ES,Spain,EURO,2698,4904807,53,86017
2021-09-07,ES,Spain,EURO,1898,4906705,55,86072
2021-09-08,ES,Spain,EURO,4212,4910917,65,86137
2021-09-09,ES,Spain,EURO,4706,4915623,58,86195
2021-09-10,ES,Spain,EURO,3716,4919339,66,86261
2021-09-11,ES,Spain,EURO,3716,4923055,57,86318
2021-09-12,ES,Spain,EURO,3765,4926820,52,86370
2021-09-13,ES,Spain,EURO,1716,4928536,42,86412
2021-09-14,ES,Spain,EURO,1269,4929805,53,86465
2021-09-15,ES,Spain,EURO,3369,4933174,41,86506
2021-09-16,ES,Spain,EURO,3407,4936581,55,86561
2021-09-17,ES,Spain,EURO,2874,4939455,55,86616
2021-09-18,ES,Spain,EURO,2878,4942333,49,86665
2021-09-19,ES,Spain,EURO,2951,4945284,45,86710
2021-09-20,ES,Spain,EURO,1367,4946651,41,86751
2021-09-21,ES,Spain,EURO,891,4947542,46,86797
2021-09-22,ES,Spain,EURO,2377,4949919,41,86838
2021-09-23,ES,Spain,EURO,2715,4952634,43,86881
2021-09-24,ES,Spain,EURO,2496,4955130,31,86912
2021-09-25,ES,Spain,EURO,2305,4957435,29,86941
2021-09-26,ES,Spain,EURO,2440,4959875,37,86978
2021-09-27,ES,Spain,EURO,1222,4961097,27,87005
2021-09-28,ES,Spain,EURO,812,4961909,19,87024
2021-09-29,ES,Spain,EURO,2456,4964365,21,87045
2021-09-30,ES,Spain,EURO,2209,4966574,21,87066
2021-10-01,ES,Spain,EURO,2066,4968640,25,87091
2021-10-02,ES,Spain,EURO,1831,4970471,32,87123
2021-10-03,ES,Spain,EURO,1874,4972345,27,87150
2021-10-04,ES,Spain,EURO,969,4973314,30,87180
2021-10-05,ES,Spain,EURO,676,4973990,19,87199
2021-10-06,ES,Spain,EURO,1876,4975866,27,87226
2021-10-07,ES,Spain,EURO,1791,4977657,11,87237
2021-10-08,ES,Spain,EURO,1762,4979419,23,87260
2021-10-09,ES,Spain,EURO,1670,4981089,27,87287
2021-10-10,ES,Spain,EURO,1820,4982909,16,87303
2021-10-11,ES,Spain,EURO,879,4983788,16,87319
2021-10-12,ES,Spain,EURO,519,4984307,16,87335
2021-10-13,ES,Spain,EURO,1966,4986273,19,87354
2021-10-14,ES,Spain,EURO,818,4987091,17,87371
2021-10-15,ES,Spain,EURO,1865,4988956,18,87389
2021-10-16,ES,Spain,EURO,2024,4990980,17,87406
2021-10-17,ES,Spain,EURO,2004,4992984,18,87424
2021-10-18,ES,Spain,EURO,1106,4994090,14,87438
2021-10-19,ES,Spain,EURO,765,4994855,13,87451
2021-10-20,ES,Spain,EURO,2112,4996967,16,87467
2021-10-21,ES,Spain,EURO,2069,4999036,17,87484
2021-10-22,ES,Spain,EURO,2086,5001122,22,87506
2021-10-23,ES,Spain,EURO,1972,5003094,21,87527
2021-10-24,ES,Spain,EURO,2091,5005185,14,87541
2021-10-25,ES,Spain,EURO,1120,5006305,14,87555
2021-10-26,ES,Spain,EURO,831,5007136,14,87569
2021-10-27,ES,Spain,EURO,2247,5009383,14,87583
2021-10-28,ES,Spain,EURO,2083,5011466,18,87601
2021-10-29,ES,Spain,EURO,2106,5013572,15,87616
2021-10-30,ES,Spain,EURO,2124,5015696,18,87634
2021-10-31,ES,Spain,EURO,2426,5018122,7,87641
2021-11-01,ES,Spain,EURO,1348,5019470,19,87660
2021-11-02,ES,Spain,EURO,936,5020406,11,87671
2021-11-03,ES,Spain,EURO,993,5021399,13,87684
2021-11-04,ES,Spain,EURO,2880,5024279,9,87693
2021-11-05,ES,Spain,EURO,2912,5027191,15,87708
2021-11-06,ES,Spain,EURO,2969,5030160,9,87717
2021-11-07,ES,Spain,EURO,3167,5033327,10,87727
2021-11-08,ES,Spain,EURO,1823,5035150,14,87741
2021-11-09,ES,Spain,EURO,1197,5036347,20,87761
2021-11-10,ES,Spain,EURO,3418,5039765,26,87787
2021-11-11,ES,Spain,EURO,3815,5043580,25,87812
2021-11-12,ES,Spain,EURO,3849,5047429,22,87834
2021-11-13,ES,Spain,EURO,4333,5051762,15,87849
2021-11-14,ES,Spain,EURO,4871,5056633,26,87875
2021-11-15,ES,Spain,EURO,2878,5059511,17,87892
2021-11-16,ES,Spain,EURO,2127,5061638,16,87908
2021-11-17,ES,Spain,EURO,5587,5067225,22,87930
2021-11-18,ES,Spain,EURO,6320,5073545,22,87952
2021-11-19,ES,Spain,EURO,6408,5079953,21,87973
2021-11-20,ES,Spain,EURO,6824,5086777,21,87994
2021-11-21,ES,Spain,EURO,7706,5094483,10,88004
2021-11-22,ES,Spain,EURO,4466,5098949,19,88023
2021-11-23,ES,Spain,EURO,3157,5102106,25,88048
2021-11-24,ES,Spain,EURO,8079,5110185,24,88072
2021-11-25,ES,Spain,EURO,9069,5119254,18,88090
2021-11-26,ES,Spain,EURO,9576,5128830,16,88106
2021-11-27,ES,Spain,EURO,9866,5138696,25,88131
2021-11-28,ES,Spain,EURO,11005,5149701,25,88156
2021-11-29,ES,Spain,EURO,6748,5156449,26,88182
2021-11-30,ES,Spain,EURO,4510,5160959,19,88201
2021-12-01,ES,Spain,EURO,11434,5172393,31,88232
2021-12-02,ES,Spain,EURO,13199,5185592,38,88270
2021-12-03,ES,Spain,EURO,14225,5199817,27,88297
2021-12-04,ES,Spain,EURO,15402,5215219,31,88328
2021-12-05,ES,Spain,EURO,15957,5231176,34,88362
2021-12-06,ES,Spain,EURO,10947,5242123,34,88396
2021-12-07,ES,Spain,EURO,7600,5249723,37,88433
2021-12-08,ES,Spain,EURO,7937,5257660,47,88480
2021-12-09,ES,Spain,EURO,18032,5275692,42,88522
2021-12-10,ES,Spain,EURO,11907,5287599,38,88560
2021-12-11,ES,Spain,EURO,20803,5308402,41,88601
2021-12-12,ES,Spain,EURO,25741,5334143,41,88642
2021-12-13,ES,Spain,EURO,16486,5350629,38,88680
2021-12-14,ES,Spain,EURO,12843,5363472,29,88709
2021-12-15,ES,Spain,EURO,26999,5390471,47,88756
2021-12-16,ES,Spain,EURO,31799,5422270,52,88808
2021-12-17,ES,Spain,EURO,36281,5458551,34,88842
2021-12-18,ES,Spain,EURO,38041,5496592,62,88904
2021-12-19,ES,Spain,EURO,43829,5540421,57,88961
2021-12-20,ES,Spain,EURO,26454,5566875,55,89016
2021-12-21,ES,Spain,EURO,22121,5588996,59,89075
2021-12-22,ES,Spain,EURO,54548,5643544,69,89144
2021-12-23,ES,Spain,EURO,73721,5717265,63,89207
2021-12-24,ES,Spain,EURO,85277,5802542,52,89259
2021-12-25,ES,Spain,EURO,95507,5898049,56,89315
2021-12-26,ES,Spain,EURO,73862,5971911,53,89368
2021-12-27,ES,Spain,EURO,46147,6018058,63,89431
2021-12-28,ES,Spain,EURO,51422,6069480,57,89488
2021-12-29,ES,Spain,EURO,114021,6183501,78,89566
2021-12-30,ES,Spain,EURO,135282,6318783,71,89637
2021-12-31,ES,Spain,EURO,147093,6465876,83,89720
2022-01-01,ES,Spain,EURO,144533,6610409,75,89795
2022-01-02,ES,Spain,EURO,102140,6712549,77,89872
2022-01-03,ES,Spain,EURO,57336,6769885,82,89954
2022-01-04,ES,Spain,EURO,69002,6838887,74,90028
2022-01-05,ES,Spain,EURO,141903,6980790,94,90122
2022-01-06,ES,Spain,EURO,162791,7143581,106,90228
2022-01-07,ES,Spain,EURO,158261,7301842,100,90328
2022-01-08,ES,Spain,EURO,73263,7375105,90,90418
2022-01-09,ES,Spain,EURO,146373,7521478,95,90513
2022-01-10,ES,Spain,EURO,88758,7610236,112,90625
2022-01-11,ES,Spain,EURO,89130,7699366,115,90740
2022-01-12,ES,Spain,EURO,169538,7868904,142,90882
2022-01-13,ES,Spain,EURO,167035,8035939,115,90997
2022-01-14,ES,Spain,EURO,156114,8192053,115,91112
2022-01-15,ES,Spain,EURO,144852,8336905,142,91254
2022-01-16,ES,Spain,EURO,130202,8467107,151,91405
2022-01-17,ES,Spain,EURO,82854,8549961,128,91533
2022-01-18,ES,Spain,EURO,73194,8623155,164,91697
2022-01-19,ES,Spain,EURO,151406,8774561,156,91853
2022-01-20,ES,Spain,EURO,144617,8919178,142,91995
2022-01-21,ES,Spain,EURO,137801,9056979,158,92153
2022-01-22,ES,Spain,EURO,127528,9184507,138,92291
2022-01-23,ES,Spain,EURO,123242,9307749,187,92478
2022-01-24,ES,Spain,EURO,69737,9377486,129,92607
2022-01-25,ES,Spain,EURO,63941,9441427,139,92746
2022-01-26,ES,Spain,EURO,126930,9568357,179,92925
2022-01-27,ES,Spain,EURO,114020,9682377,165,93090
2022-01-28,ES,Spain,EURO,105949,9788326,150,93240
2022-01-29,ES,Spain,EURO,89766,9878092,127,93367
2022-01-30,ES,Spain,EURO,80165,9958257,141,93508
2022-01-31,ES,Spain,EURO,43909,10002166,141,93649
2022-02-01,ES,Spain,EURO,36481,10038647,121,93770
2022-02-02,ES,Spain,EURO,72752,10111399,126,93896
2022-02-03,ES,Spain,EURO,57124,10168523,100,93996
2022-02-04,ES,Spain,EURO,31194,10199717,44,94040
2022-02-05,ES,Spain,EURO,0,10199717,0,94040
2022-02-06,ES,Spain,EURO,0,10199717,0,94040
2022-02-07,ES,Spain,EURO,0,10199717,0,94040
.
154329c
2022-02-04,SS,South Sudan,AFRO,13,16833,0,137
2022-02-05,SS,South Sudan,AFRO,8,16841,0,137
2022-02-06,SS,South Sudan,AFRO,8,16849,0,137
2022-02-07,SS,South Sudan,AFRO,2,16851,0,137
.
153565c
2022-02-04,ZA,South Africa,AFRO,3266,3616075,82,95545
2022-02-05,ZA,South Africa,AFRO,2778,3618853,221,95766
2022-02-06,ZA,South Africa,AFRO,3357,3622210,51,95817
2022-02-07,ZA,South Africa,AFRO,1752,3623962,18,95835
.
152801a
2022-02-05,SO,Somalia,EMRO,0,26067,0,1335
2022-02-06,SO,Somalia,EMRO,0,26067,0,1335
2022-02-07,SO,Somalia,EMRO,0,26067,0,1335
.
152037a
2022-02-05,SB,Solomon Islands,WPRO,433,2790,4,25
2022-02-06,SB,Solomon Islands,WPRO,0,2790,0,25
2022-02-07,SB,Solomon Islands,WPRO,392,3182,8,33
.
150891,151273c
2021-01-18,SI,Slovenia,EURO,575,149271,34,3490
2021-01-19,SI,Slovenia,EURO,300,149571,31,3521
2021-01-20,SI,Slovenia,EURO,1707,151278,28,3549
2021-01-21,SI,Slovenia,EURO,1718,152996,25,3574
2021-01-22,SI,Slovenia,EURO,1458,154454,29,3603
2021-01-23,SI,Slovenia,EURO,1461,155915,24,3627
2021-01-24,SI,Slovenia,EURO,1521,157436,27,3654
2021-01-25,SI,Slovenia,EURO,541,157977,30,3684
2021-01-26,SI,Slovenia,EURO,297,158274,24,3708
2021-01-27,SI,Slovenia,EURO,1682,159956,23,3731
2021-01-28,SI,Slovenia,EURO,1877,161833,24,3755
2021-01-29,SI,Slovenia,EURO,1541,163374,16,3771
2021-01-30,SI,Slovenia,EURO,1305,164679,26,3797
2021-01-31,SI,Slovenia,EURO,1302,165981,22,3819
2021-02-01,SI,Slovenia,EURO,587,166568,17,3836
2021-02-02,SI,Slovenia,EURO,348,166916,21,3857
2021-02-03,SI,Slovenia,EURO,1516,168432,16,3873
2021-02-04,SI,Slovenia,EURO,1567,169999,24,3897
2021-02-05,SI,Slovenia,EURO,1267,171266,25,3922
2021-02-06,SI,Slovenia,EURO,960,172226,16,3938
2021-02-07,SI,Slovenia,EURO,984,173210,13,3951
2021-02-08,SI,Slovenia,EURO,498,173708,17,3968
2021-02-09,SI,Slovenia,EURO,308,174016,8,3976
2021-02-10,SI,Slovenia,EURO,338,174354,18,3994
2021-02-11,SI,Slovenia,EURO,1369,175723,12,4006
2021-02-12,SI,Slovenia,EURO,1338,177061,10,4016
2021-02-13,SI,Slovenia,EURO,1047,178108,17,4033
2021-02-14,SI,Slovenia,EURO,993,179101,15,4048
2021-02-15,SI,Slovenia,EURO,387,179488,9,4057
2021-02-16,SI,Slovenia,EURO,244,179732,10,4067
2021-02-17,SI,Slovenia,EURO,747,180479,6,4073
2021-02-18,SI,Slovenia,EURO,1100,181579,6,4079
2021-02-19,SI,Slovenia,EURO,875,182454,8,4087
2021-02-20,SI,Slovenia,EURO,911,183365,5,4092
2021-02-21,SI,Slovenia,EURO,960,184325,7,4099
2021-02-22,SI,Slovenia,EURO,419,184744,4,4103
2021-02-23,SI,Slovenia,EURO,250,184994,5,4108
2021-02-24,SI,Slovenia,EURO,903,185897,6,4114
2021-02-25,SI,Slovenia,EURO,1095,186992,10,4124
2021-02-26,SI,Slovenia,EURO,859,187851,7,4131
2021-02-27,SI,Slovenia,EURO,920,188771,12,4143
2021-02-28,SI,Slovenia,EURO,949,189720,10,4153
2021-03-01,SI,Slovenia,EURO,454,190174,10,4163
2021-03-02,SI,Slovenia,EURO,246,190420,11,4174
2021-03-03,SI,Slovenia,EURO,730,191150,6,4180
2021-03-04,SI,Slovenia,EURO,1212,192362,7,4187
2021-03-05,SI,Slovenia,EURO,1022,193384,9,4196
2021-03-06,SI,Slovenia,EURO,885,194269,7,4203
2021-03-07,SI,Slovenia,EURO,926,195195,2,4205
2021-03-08,SI,Slovenia,EURO,384,195579,4,4209
2021-03-09,SI,Slovenia,EURO,211,195790,3,4212
2021-03-10,SI,Slovenia,EURO,743,196533,7,4219
2021-03-11,SI,Slovenia,EURO,960,197493,7,4226
2021-03-12,SI,Slovenia,EURO,862,198355,12,4238
2021-03-13,SI,Slovenia,EURO,772,199127,7,4245
2021-03-14,SI,Slovenia,EURO,852,199979,5,4250
2021-03-15,SI,Slovenia,EURO,482,200461,4,4254
2021-03-16,SI,Slovenia,EURO,205,200666,4,4258
2021-03-17,SI,Slovenia,EURO,921,201587,4,4262
2021-03-18,SI,Slovenia,EURO,1114,202701,8,4270
2021-03-19,SI,Slovenia,EURO,976,203677,3,4273
2021-03-20,SI,Slovenia,EURO,944,204621,10,4283
2021-03-21,SI,Slovenia,EURO,1034,205655,10,4293
2021-03-22,SI,Slovenia,EURO,518,206173,6,4299
2021-03-23,SI,Slovenia,EURO,290,206463,8,4307
2021-03-24,SI,Slovenia,EURO,988,207451,8,4315
2021-03-25,SI,Slovenia,EURO,1289,208740,12,4327
2021-03-26,SI,Slovenia,EURO,1163,209903,6,4333
2021-03-27,SI,Slovenia,EURO,1037,210940,9,4342
2021-03-28,SI,Slovenia,EURO,1252,212192,6,4348
2021-03-29,SI,Slovenia,EURO,641,212833,6,4354
2021-03-30,SI,Slovenia,EURO,289,213122,6,4360
2021-03-31,SI,Slovenia,EURO,1084,214206,11,4371
2021-04-01,SI,Slovenia,EURO,1572,215778,12,4383
2021-04-02,SI,Slovenia,EURO,1340,217118,7,4390
2021-04-03,SI,Slovenia,EURO,1172,218290,11,4401
2021-04-04,SI,Slovenia,EURO,1300,219590,6,4407
2021-04-05,SI,Slovenia,EURO,721,220311,9,4416
2021-04-06,SI,Slovenia,EURO,283,220594,5,4421
2021-04-07,SI,Slovenia,EURO,273,220867,9,4430
2021-04-08,SI,Slovenia,EURO,1192,222059,6,4436
2021-04-09,SI,Slovenia,EURO,1531,223590,5,4441
2021-04-10,SI,Slovenia,EURO,1284,224874,3,4444
2021-04-11,SI,Slovenia,EURO,1257,226131,12,4456
2021-04-12,SI,Slovenia,EURO,549,226680,4,4460
2021-04-13,SI,Slovenia,EURO,291,226971,5,4465
2021-04-14,SI,Slovenia,EURO,1050,228021,7,4472
2021-04-15,SI,Slovenia,EURO,1236,229257,6,4478
2021-04-16,SI,Slovenia,EURO,894,230151,4,4482
2021-04-17,SI,Slovenia,EURO,862,231013,9,4491
2021-04-18,SI,Slovenia,EURO,772,231785,7,4498
2021-04-19,SI,Slovenia,EURO,476,232261,4,4502
2021-04-20,SI,Slovenia,EURO,233,232494,9,4511
2021-04-21,SI,Slovenia,EURO,726,233220,8,4519
2021-04-22,SI,Slovenia,EURO,1039,234259,5,4524
2021-04-23,SI,Slovenia,EURO,744,235003,14,4538
2021-04-24,SI,Slovenia,EURO,901,235904,2,4540
2021-04-25,SI,Slovenia,EURO,831,236735,9,4549
2021-04-26,SI,Slovenia,EURO,417,237152,8,4557
2021-04-27,SI,Slovenia,EURO,192,237344,9,4566
2021-04-28,SI,Slovenia,EURO,810,238154,2,4568
2021-04-29,SI,Slovenia,EURO,404,238558,12,4580
2021-04-30,SI,Slovenia,EURO,921,239479,9,4589
2021-05-01,SI,Slovenia,EURO,949,240428,8,4597
2021-05-02,SI,Slovenia,EURO,1019,241447,9,4606
2021-05-03,SI,Slovenia,EURO,367,241814,4,4610
2021-05-04,SI,Slovenia,EURO,210,242024,8,4618
2021-05-05,SI,Slovenia,EURO,893,242917,3,4621
2021-05-06,SI,Slovenia,EURO,930,243847,9,4630
2021-05-07,SI,Slovenia,EURO,777,244624,2,4632
2021-05-08,SI,Slovenia,EURO,609,245233,3,4635
2021-05-09,SI,Slovenia,EURO,634,245867,0,4635
2021-05-10,SI,Slovenia,EURO,291,246158,7,4642
2021-05-11,SI,Slovenia,EURO,146,246304,7,4649
2021-05-12,SI,Slovenia,EURO,491,246795,2,4651
2021-05-13,SI,Slovenia,EURO,730,247525,5,4656
2021-05-14,SI,Slovenia,EURO,599,248124,5,4661
2021-05-15,SI,Slovenia,EURO,472,248596,7,4668
2021-05-16,SI,Slovenia,EURO,496,249092,2,4670
2021-05-17,SI,Slovenia,EURO,293,249385,3,4673
2021-05-18,SI,Slovenia,EURO,115,249500,5,4678
2021-05-19,SI,Slovenia,EURO,497,249997,4,4682
2021-05-20,SI,Slovenia,EURO,538,250535,4,4686
2021-05-21,SI,Slovenia,EURO,358,250893,5,4691
2021-05-22,SI,Slovenia,EURO,334,251227,2,4693
2021-05-23,SI,Slovenia,EURO,382,251609,2,4695
2021-05-24,SI,Slovenia,EURO,158,251767,1,4696
2021-05-25,SI,Slovenia,EURO,84,251851,2,4698
2021-05-26,SI,Slovenia,EURO,323,252174,1,4699
2021-05-27,SI,Slovenia,EURO,391,252565,4,4703
2021-05-28,SI,Slovenia,EURO,367,252932,1,4704
2021-05-29,SI,Slovenia,EURO,289,253221,3,4707
2021-05-30,SI,Slovenia,EURO,356,253577,3,4710
2021-05-31,SI,Slovenia,EURO,137,253714,4,4714
2021-06-01,SI,Slovenia,EURO,92,253806,2,4716
2021-06-02,SI,Slovenia,EURO,323,254129,1,4717
2021-06-03,SI,Slovenia,EURO,373,254502,3,4720
2021-06-04,SI,Slovenia,EURO,273,254775,2,4722
2021-06-05,SI,Slovenia,EURO,280,255055,3,4725
2021-06-06,SI,Slovenia,EURO,247,255302,1,4726
2021-06-07,SI,Slovenia,EURO,157,255459,2,4728
2021-06-08,SI,Slovenia,EURO,58,255517,2,4730
2021-06-09,SI,Slovenia,EURO,220,255737,3,4733
2021-06-10,SI,Slovenia,EURO,254,255991,0,4733
2021-06-11,SI,Slovenia,EURO,195,256186,3,4736
2021-06-12,SI,Slovenia,EURO,123,256309,3,4739
2021-06-13,SI,Slovenia,EURO,126,256435,3,4742
2021-06-14,SI,Slovenia,EURO,91,256526,5,4747
2021-06-15,SI,Slovenia,EURO,24,256550,3,4750
2021-06-16,SI,Slovenia,EURO,113,256663,3,4753
2021-06-17,SI,Slovenia,EURO,117,256780,1,4754
2021-06-18,SI,Slovenia,EURO,84,256864,0,4754
2021-06-19,SI,Slovenia,EURO,89,256953,1,4755
2021-06-20,SI,Slovenia,EURO,84,257037,0,4755
2021-06-21,SI,Slovenia,EURO,26,257063,2,4757
2021-06-22,SI,Slovenia,EURO,19,257082,2,4759
2021-06-23,SI,Slovenia,EURO,67,257149,2,4761
2021-06-24,SI,Slovenia,EURO,54,257203,0,4761
2021-06-25,SI,Slovenia,EURO,43,257246,1,4762
2021-06-26,SI,Slovenia,EURO,46,257292,1,4763
2021-06-27,SI,Slovenia,EURO,11,257303,2,4765
2021-06-28,SI,Slovenia,EURO,19,257322,0,4765
2021-06-29,SI,Slovenia,EURO,11,257333,0,4765
2021-06-30,SI,Slovenia,EURO,36,257369,0,4765
2021-07-01,SI,Slovenia,EURO,47,257416,0,4765
2021-07-02,SI,Slovenia,EURO,23,257439,0,4765
2021-07-03,SI,Slovenia,EURO,24,257463,0,4765
2021-07-04,SI,Slovenia,EURO,30,257493,0,4765
2021-07-05,SI,Slovenia,EURO,9,257502,0,4765
2021-07-06,SI,Slovenia,EURO,8,257510,1,4766
2021-07-07,SI,Slovenia,EURO,48,257558,1,4767
2021-07-08,SI,Slovenia,EURO,73,257631,3,4770
2021-07-09,SI,Slovenia,EURO,69,257700,0,4770
2021-07-10,SI,Slovenia,EURO,81,257781,2,4772
2021-07-11,SI,Slovenia,EURO,81,257862,0,4772
2021-07-12,SI,Slovenia,EURO,24,257886,0,4772
2021-07-13,SI,Slovenia,EURO,11,257897,1,4773
2021-07-14,SI,Slovenia,EURO,84,257981,0,4773
2021-07-15,SI,Slovenia,EURO,83,258064,0,4773
2021-07-16,SI,Slovenia,EURO,56,258120,0,4773
2021-07-17,SI,Slovenia,EURO,63,258183,0,4773
2021-07-18,SI,Slovenia,EURO,61,258244,0,4773
2021-07-19,SI,Slovenia,EURO,21,258265,0,4773
2021-07-20,SI,Slovenia,EURO,9,258274,0,4773
2021-07-21,SI,Slovenia,EURO,89,258363,0,4773
2021-07-22,SI,Slovenia,EURO,110,258473,0,4773
2021-07-23,SI,Slovenia,EURO,70,258543,0,4773
2021-07-24,SI,Slovenia,EURO,58,258601,0,4773
2021-07-25,SI,Slovenia,EURO,93,258694,1,4774
2021-07-26,SI,Slovenia,EURO,32,258726,0,4774
2021-07-27,SI,Slovenia,EURO,21,258747,0,4774
2021-07-28,SI,Slovenia,EURO,106,258853,0,4774
2021-07-29,SI,Slovenia,EURO,85,258938,0,4774
2021-07-30,SI,Slovenia,EURO,99,259037,0,4774
2021-07-31,SI,Slovenia,EURO,117,259154,0,4774
2021-08-01,SI,Slovenia,EURO,135,259289,1,4775
2021-08-02,SI,Slovenia,EURO,58,259347,0,4775
2021-08-03,SI,Slovenia,EURO,31,259378,0,4775
2021-08-04,SI,Slovenia,EURO,181,259559,0,4775
2021-08-05,SI,Slovenia,EURO,139,259698,0,4775
2021-08-06,SI,Slovenia,EURO,139,259837,0,4775
2021-08-07,SI,Slovenia,EURO,143,259980,1,4776
2021-08-08,SI,Slovenia,EURO,133,260113,0,4776
2021-08-09,SI,Slovenia,EURO,67,260180,0,4776
2021-08-10,SI,Slovenia,EURO,46,260226,0,4776
2021-08-11,SI,Slovenia,EURO,219,260445,0,4776
2021-08-12,SI,Slovenia,EURO,247,260692,0,4776
2021-08-13,SI,Slovenia,EURO,250,260942,0,4776
2021-08-14,SI,Slovenia,EURO,199,261141,0,4776
2021-08-15,SI,Slovenia,EURO,264,261405,0,4776
2021-08-16,SI,Slovenia,EURO,97,261502,0,4776
2021-08-17,SI,Slovenia,EURO,57,261559,0,4776
2021-08-18,SI,Slovenia,EURO,318,261877,0,4776
2021-08-19,SI,Slovenia,EURO,387,262264,2,4778
2021-08-20,SI,Slovenia,EURO,382,262646,4,4782
2021-08-21,SI,Slovenia,EURO,335,262981,0,4782
2021-08-22,SI,Slovenia,EURO,388,263369,0,4782
2021-08-23,SI,Slovenia,EURO,246,263615,2,4784
2021-08-24,SI,Slovenia,EURO,117,263732,1,4785
2021-08-25,SI,Slovenia,EURO,476,264208,3,4788
2021-08-26,SI,Slovenia,EURO,509,264717,1,4789
2021-08-27,SI,Slovenia,EURO,511,265228,1,4790
2021-08-28,SI,Slovenia,EURO,544,265772,3,4793
2021-08-29,SI,Slovenia,EURO,540,266312,2,4795
2021-08-30,SI,Slovenia,EURO,277,266589,0,4795
2021-08-31,SI,Slovenia,EURO,144,266733,0,4795
2021-09-01,SI,Slovenia,EURO,540,267273,2,4797
2021-09-02,SI,Slovenia,EURO,772,268045,2,4799
2021-09-03,SI,Slovenia,EURO,668,268713,1,4800
2021-09-04,SI,Slovenia,EURO,611,269324,1,4801
2021-09-05,SI,Slovenia,EURO,743,270067,2,4803
2021-09-06,SI,Slovenia,EURO,318,270385,0,4803
2021-09-07,SI,Slovenia,EURO,236,270621,0,4803
2021-09-08,SI,Slovenia,EURO,880,271501,3,4806
2021-09-09,SI,Slovenia,EURO,1095,272596,5,4811
2021-09-10,SI,Slovenia,EURO,1018,273614,2,4813
2021-09-11,SI,Slovenia,EURO,999,274613,3,4816
2021-09-12,SI,Slovenia,EURO,1088,275701,5,4821
2021-09-13,SI,Slovenia,EURO,560,276261,0,4821
2021-09-14,SI,Slovenia,EURO,285,276546,3,4824
2021-09-15,SI,Slovenia,EURO,1394,277940,4,4828
2021-09-16,SI,Slovenia,EURO,1365,279305,5,4833
2021-09-17,SI,Slovenia,EURO,1327,280632,8,4841
2021-09-18,SI,Slovenia,EURO,1145,281777,4,4845
2021-09-19,SI,Slovenia,EURO,1253,283030,6,4851
2021-09-20,SI,Slovenia,EURO,545,283575,3,4854
2021-09-21,SI,Slovenia,EURO,292,283867,6,4860
2021-09-22,SI,Slovenia,EURO,1308,285175,5,4865
2021-09-23,SI,Slovenia,EURO,1189,286364,7,4872
2021-09-24,SI,Slovenia,EURO,1012,287376,4,4876
2021-09-25,SI,Slovenia,EURO,941,288317,7,4883
2021-09-26,SI,Slovenia,EURO,1007,289324,8,4891
2021-09-27,SI,Slovenia,EURO,447,289771,7,4898
2021-09-28,SI,Slovenia,EURO,286,290057,7,4905
2021-09-29,SI,Slovenia,EURO,1041,291098,13,4918
2021-09-30,SI,Slovenia,EURO,1342,292440,4,4922
2021-10-01,SI,Slovenia,EURO,1028,293468,9,4931
2021-10-02,SI,Slovenia,EURO,973,294441,5,4936
2021-10-03,SI,Slovenia,EURO,993,295434,9,4945
2021-10-04,SI,Slovenia,EURO,533,295967,7,4952
2021-10-05,SI,Slovenia,EURO,225,296192,7,4959
2021-10-06,SI,Slovenia,EURO,980,297172,7,4966
2021-10-07,SI,Slovenia,EURO,1209,298381,11,4977
2021-10-08,SI,Slovenia,EURO,969,299350,4,4981
2021-10-09,SI,Slovenia,EURO,842,300192,3,4984
2021-10-10,SI,Slovenia,EURO,883,301075,10,4994
2021-10-11,SI,Slovenia,EURO,489,301564,9,5003
2021-10-12,SI,Slovenia,EURO,188,301752,6,5009
2021-10-13,SI,Slovenia,EURO,1005,302757,2,5011
2021-10-14,SI,Slovenia,EURO,1229,303986,4,5015
2021-10-15,SI,Slovenia,EURO,1082,305068,9,5024
2021-10-16,SI,Slovenia,EURO,1105,306173,5,5029
2021-10-17,SI,Slovenia,EURO,1438,307611,4,5033
2021-10-18,SI,Slovenia,EURO,632,308243,4,5037
2021-10-19,SI,Slovenia,EURO,364,308607,7,5044
2021-10-20,SI,Slovenia,EURO,1673,310280,5,5049
2021-10-21,SI,Slovenia,EURO,2155,312435,7,5056
2021-10-22,SI,Slovenia,EURO,1852,314287,11,5067
2021-10-23,SI,Slovenia,EURO,1969,316256,4,5071
2021-10-24,SI,Slovenia,EURO,2272,318528,11,5082
2021-10-25,SI,Slovenia,EURO,1498,320026,5,5087
2021-10-26,SI,Slovenia,EURO,708,320734,9,5096
2021-10-27,SI,Slovenia,EURO,2296,323030,10,5106
2021-10-28,SI,Slovenia,EURO,3138,326168,11,5117
2021-10-29,SI,Slovenia,EURO,2632,328800,11,5128
2021-10-30,SI,Slovenia,EURO,2517,331317,15,5143
2021-10-31,SI,Slovenia,EURO,2991,334308,7,5150
2021-11-01,SI,Slovenia,EURO,1664,335972,8,5158
2021-11-02,SI,Slovenia,EURO,1258,337230,12,5170
2021-11-03,SI,Slovenia,EURO,1136,338366,10,5180
2021-11-04,SI,Slovenia,EURO,3462,341828,19,5199
2021-11-05,SI,Slovenia,EURO,4518,346346,12,5211
2021-11-06,SI,Slovenia,EURO,3779,350125,17,5228
2021-11-07,SI,Slovenia,EURO,3664,353789,12,5240
2021-11-08,SI,Slovenia,EURO,2325,356114,15,5255
2021-11-09,SI,Slovenia,EURO,1288,357402,20,5275
2021-11-10,SI,Slovenia,EURO,3348,360750,13,5288
2021-11-11,SI,Slovenia,EURO,4483,365233,20,5308
2021-11-12,SI,Slovenia,EURO,3573,368806,12,5320
2021-11-13,SI,Slovenia,EURO,3435,372241,12,5332
2021-11-14,SI,Slovenia,EURO,3667,375908,24,5356
2021-11-15,SI,Slovenia,EURO,2369,378277,24,5380
2021-11-16,SI,Slovenia,EURO,1820,380097,23,5403
2021-11-17,SI,Slovenia,EURO,3771,383868,9,5412
2021-11-18,SI,Slovenia,EURO,4283,388151,15,5427
2021-11-19,SI,Slovenia,EURO,3667,391818,26,5453
2021-11-20,SI,Slovenia,EURO,3518,395336,25,5478
2021-11-21,SI,Slovenia,EURO,3239,398575,20,5498
2021-11-22,SI,Slovenia,EURO,2248,400823,27,5525
2021-11-23,SI,Slovenia,EURO,1390,402213,18,5543
2021-11-24,SI,Slovenia,EURO,3400,405613,19,5562
2021-11-25,SI,Slovenia,EURO,3143,408756,19,5581
2021-11-26,SI,Slovenia,EURO,2670,411426,14,5595
2021-11-27,SI,Slovenia,EURO,2367,413793,18,5613
2021-11-28,SI,Slovenia,EURO,2227,416020,25,5638
2021-11-29,SI,Slovenia,EURO,1481,417501,31,5669
2021-11-30,SI,Slovenia,EURO,1039,418540,21,5690
2021-12-01,SI,Slovenia,EURO,2484,421024,19,5709
2021-12-02,SI,Slovenia,EURO,2258,423282,23,5732
2021-12-03,SI,Slovenia,EURO,2128,425410,20,5752
2021-12-04,SI,Slovenia,EURO,1739,427149,20,5772
2021-12-05,SI,Slovenia,EURO,1908,429057,22,5794
2021-12-06,SI,Slovenia,EURO,1116,430173,20,5814
2021-12-07,SI,Slovenia,EURO,775,430948,11,5825
2021-12-08,SI,Slovenia,EURO,1955,432903,18,5843
2021-12-09,SI,Slovenia,EURO,1852,434755,17,5860
2021-12-10,SI,Slovenia,EURO,1688,436443,14,5874
2021-12-11,SI,Slovenia,EURO,1324,437767,19,5893
2021-12-12,SI,Slovenia,EURO,1480,439247,15,5908
2021-12-13,SI,Slovenia,EURO,786,440033,12,5920
2021-12-14,SI,Slovenia,EURO,677,440710,19,5939
2021-12-15,SI,Slovenia,EURO,1716,442426,16,5955
2021-12-16,SI,Slovenia,EURO,1530,443956,14,5969
2021-12-17,SI,Slovenia,EURO,1347,445303,7,5976
2021-12-18,SI,Slovenia,EURO,1281,446584,11,5987
2021-12-19,SI,Slovenia,EURO,1288,447872,16,6003
2021-12-20,SI,Slovenia,EURO,769,448641,12,6015
2021-12-21,SI,Slovenia,EURO,586,449227,8,6023
2021-12-22,SI,Slovenia,EURO,1558,450785,10,6033
2021-12-23,SI,Slovenia,EURO,1255,452040,9,6042
2021-12-24,SI,Slovenia,EURO,1124,453164,8,6050
2021-12-25,SI,Slovenia,EURO,1207,454371,9,6059
2021-12-26,SI,Slovenia,EURO,1091,455462,4,6063
2021-12-27,SI,Slovenia,EURO,666,456128,11,6074
2021-12-28,SI,Slovenia,EURO,701,456829,9,6083
2021-12-29,SI,Slovenia,EURO,1819,458648,11,6094
2021-12-30,SI,Slovenia,EURO,1871,460519,17,6111
2021-12-31,SI,Slovenia,EURO,1691,462210,7,6118
2022-01-01,SI,Slovenia,EURO,1898,464108,5,6123
2022-01-02,SI,Slovenia,EURO,1668,465776,7,6130
2022-01-03,SI,Slovenia,EURO,835,466611,8,6138
2022-01-04,SI,Slovenia,EURO,1010,467621,9,6147
2022-01-05,SI,Slovenia,EURO,3403,471024,10,6157
2022-01-06,SI,Slovenia,EURO,4084,475108,8,6165
2022-01-07,SI,Slovenia,EURO,3848,478956,7,6172
2022-01-08,SI,Slovenia,EURO,4085,483041,11,6183
2022-01-09,SI,Slovenia,EURO,4492,487533,5,6188
2022-01-10,SI,Slovenia,EURO,3360,490893,6,6194
2022-01-11,SI,Slovenia,EURO,2530,493423,8,6202
2022-01-12,SI,Slovenia,EURO,5174,498597,4,6206
2022-01-13,SI,Slovenia,EURO,7436,506033,12,6218
2022-01-14,SI,Slovenia,EURO,6879,512912,9,6227
2022-01-15,SI,Slovenia,EURO,6941,519853,9,6236
2022-01-16,SI,Slovenia,EURO,7603,527456,6,6242
2022-01-17,SI,Slovenia,EURO,6022,533478,4,6246
2022-01-18,SI,Slovenia,EURO,4979,538457,7,6253
2022-01-19,SI,Slovenia,EURO,8694,547151,10,6263
2022-01-20,SI,Slovenia,EURO,12302,559453,14,6277
2022-01-21,SI,Slovenia,EURO,10305,569758,4,6281
2022-01-22,SI,Slovenia,EURO,9866,579624,11,6292
2022-01-23,SI,Slovenia,EURO,9960,589584,13,6305
2022-01-24,SI,Slovenia,EURO,14190,603774,17,6322
2022-01-25,SI,Slovenia,EURO,8414,612188,12,6334
2022-01-26,SI,Slovenia,EURO,12837,625025,15,6349
2022-01-27,SI,Slovenia,EURO,17507,642532,21,6370
2022-01-28,SI,Slovenia,EURO,14218,656750,16,6386
2022-01-29,SI,Slovenia,EURO,16889,673639,8,6394
2022-01-30,SI,Slovenia,EURO,14894,688533,15,6409
2022-01-31,SI,Slovenia,EURO,13861,702394,18,6427
2022-02-01,SI,Slovenia,EURO,8578,710972,13,6440
2022-02-02,SI,Slovenia,EURO,11722,722694,11,6451
2022-02-03,SI,Slovenia,EURO,24152,746846,8,6459
2022-02-04,SI,Slovenia,EURO,16731,763577,5,6464
2022-02-05,SI,Slovenia,EURO,11725,775302,11,6475
2022-02-06,SI,Slovenia,EURO,11683,786985,5,6480
2022-02-07,SI,Slovenia,EURO,7458,794443,2,6482
.
150509a
2022-02-05,SK,Slovakia,EURO,19577,1101506,17,17938
2022-02-06,SK,Slovakia,EURO,15549,1117055,20,17958
2022-02-07,SK,Slovakia,EURO,9965,1127020,15,17973
.
149745a
2022-02-05,SX,Sint Maarten,AMRO,20,9373,0,79
2022-02-06,SX,Sint Maarten,AMRO,0,9373,0,79
2022-02-07,SX,Sint Maarten,AMRO,0,9373,0,79
.
148981a
2022-02-05,XB,Sint Eustatius,AMRO,0,390,0,1
2022-02-06,XB,Sint Eustatius,AMRO,0,390,0,1
2022-02-07,XB,Sint Eustatius,AMRO,0,390,0,1
.
148217a
2022-02-05,SG,Singapore,WPRO,13208,379681,6,866
2022-02-06,SG,Singapore,WPRO,10390,390071,2,868
2022-02-07,SG,Singapore,WPRO,7752,397823,3,871
.
147453a
2022-02-05,SL,Sierra Leone,AFRO,0,7623,0,125
2022-02-06,SL,Sierra Leone,AFRO,4,7627,0,125
2022-02-07,SL,Sierra Leone,AFRO,0,7627,0,125
.
146689c
2022-02-04,SC,Seychelles,AFRO,305,37775,1,147
2022-02-05,SC,Seychelles,AFRO,0,37775,0,147
2022-02-06,SC,Seychelles,AFRO,0,37775,0,147
2022-02-07,SC,Seychelles,AFRO,110,37885,0,147
.
145925a
2022-02-05,RS,Serbia,EURO,14519,1745005,61,13868
2022-02-06,RS,Serbia,EURO,12736,1757741,60,13928
2022-02-07,RS,Serbia,EURO,10602,1768343,63,13991
.
145161c
2022-02-04,SN,Senegal,AFRO,45,85117,1,1950
2022-02-05,SN,Senegal,AFRO,26,85143,3,1953
2022-02-06,SN,Senegal,AFRO,35,85178,2,1955
2022-02-07,SN,Senegal,AFRO,28,85206,1,1956
.
144397a
2022-02-05,SA,Saudi Arabia,EMRO,3555,702624,3,8950
2022-02-06,SA,Saudi Arabia,EMRO,3013,705637,3,8953
2022-02-07,SA,Saudi Arabia,EMRO,3260,708897,1,8954
.
143633c
2022-02-04,ST,Sao Tome and Principe,AFRO,4,5907,0,70
2022-02-05,ST,Sao Tome and Principe,AFRO,1,5908,0,70
2022-02-06,ST,Sao Tome and Principe,AFRO,3,5911,1,71
2022-02-07,ST,Sao Tome and Principe,AFRO,1,5912,0,71
.
142402,142869c
2020-10-25,SM,San Marino,EURO,13,858,0,42
2020-10-26,SM,San Marino,EURO,0,858,0,42
2020-10-27,SM,San Marino,EURO,31,889,0,42
2020-10-28,SM,San Marino,EURO,20,909,0,42
2020-10-29,SM,San Marino,EURO,26,935,0,42
2020-10-30,SM,San Marino,EURO,29,964,0,42
2020-10-31,SM,San Marino,EURO,36,1000,0,42
2020-11-01,SM,San Marino,EURO,0,1000,0,42
2020-11-02,SM,San Marino,EURO,0,1000,0,42
2020-11-03,SM,San Marino,EURO,0,1000,0,42
2020-11-04,SM,San Marino,EURO,13,1013,0,42
2020-11-05,SM,San Marino,EURO,41,1054,0,42
2020-11-06,SM,San Marino,EURO,58,1112,0,42
2020-11-07,SM,San Marino,EURO,18,1130,0,42
2020-11-08,SM,San Marino,EURO,0,1130,0,42
2020-11-09,SM,San Marino,EURO,0,1130,0,42
2020-11-10,SM,San Marino,EURO,41,1171,0,42
2020-11-11,SM,San Marino,EURO,35,1206,0,42
2020-11-12,SM,San Marino,EURO,44,1250,0,42
2020-11-13,SM,San Marino,EURO,19,1269,0,42
2020-11-14,SM,San Marino,EURO,37,1306,0,42
2020-11-15,SM,San Marino,EURO,0,1306,0,42
2020-11-16,SM,San Marino,EURO,31,1337,1,43
2020-11-17,SM,San Marino,EURO,0,1337,0,43
2020-11-18,SM,San Marino,EURO,37,1374,0,43
2020-11-19,SM,San Marino,EURO,15,1389,0,43
2020-11-20,SM,San Marino,EURO,22,1411,0,43
2020-11-21,SM,San Marino,EURO,32,1443,0,43
2020-11-22,SM,San Marino,EURO,1,1444,1,44
2020-11-23,SM,San Marino,EURO,26,1470,0,44
2020-11-24,SM,San Marino,EURO,0,1470,0,44
2020-11-25,SM,San Marino,EURO,38,1508,0,44
2020-11-26,SM,San Marino,EURO,22,1530,0,44
2020-11-27,SM,San Marino,EURO,40,1570,0,44
2020-11-28,SM,San Marino,EURO,32,1602,1,45
2020-11-29,SM,San Marino,EURO,23,1625,0,45
2020-11-30,SM,San Marino,EURO,3,1628,1,46
2020-12-01,SM,San Marino,EURO,38,1666,0,46
2020-12-02,SM,San Marino,EURO,37,1703,0,46
2020-12-03,SM,San Marino,EURO,27,1730,0,46
2020-12-04,SM,San Marino,EURO,42,1772,1,47
2020-12-05,SM,San Marino,EURO,33,1805,1,48
2020-12-06,SM,San Marino,EURO,11,1816,0,48
2020-12-07,SM,San Marino,EURO,0,1816,0,48
2020-12-08,SM,San Marino,EURO,32,1848,0,48
2020-12-09,SM,San Marino,EURO,2,1850,1,49
2020-12-10,SM,San Marino,EURO,34,1884,0,49
2020-12-11,SM,San Marino,EURO,40,1924,1,50
2020-12-12,SM,San Marino,EURO,24,1948,1,51
2020-12-13,SM,San Marino,EURO,15,1963,0,51
2020-12-14,SM,San Marino,EURO,35,1998,1,52
2020-12-15,SM,San Marino,EURO,43,2041,2,54
2020-12-16,SM,San Marino,EURO,0,2041,0,54
2020-12-17,SM,San Marino,EURO,24,2065,0,54
2020-12-18,SM,San Marino,EURO,0,2065,1,55
2020-12-19,SM,San Marino,EURO,58,2123,0,55
2020-12-20,SM,San Marino,EURO,28,2151,0,55
2020-12-21,SM,San Marino,EURO,0,2151,0,55
2020-12-22,SM,San Marino,EURO,41,2192,1,56
2020-12-23,SM,San Marino,EURO,30,2222,0,56
2020-12-24,SM,San Marino,EURO,25,2247,0,56
2020-12-25,SM,San Marino,EURO,33,2280,1,57
2020-12-26,SM,San Marino,EURO,12,2292,0,57
2020-12-27,SM,San Marino,EURO,0,2292,0,57
2020-12-28,SM,San Marino,EURO,57,2349,2,59
2020-12-29,SM,San Marino,EURO,0,2349,0,59
2020-12-30,SM,San Marino,EURO,51,2400,0,59
2020-12-31,SM,San Marino,EURO,0,2400,0,59
2021-01-01,SM,San Marino,EURO,44,2444,0,59
2021-01-02,SM,San Marino,EURO,35,2479,2,61
2021-01-03,SM,San Marino,EURO,30,2509,1,62
2021-01-04,SM,San Marino,EURO,0,2509,0,62
2021-01-05,SM,San Marino,EURO,56,2565,0,62
2021-01-06,SM,San Marino,EURO,34,2599,2,64
2021-01-07,SM,San Marino,EURO,0,2599,0,64
2021-01-08,SM,San Marino,EURO,45,2644,0,64
2021-01-09,SM,San Marino,EURO,22,2666,0,64
2021-01-10,SM,San Marino,EURO,56,2722,1,65
2021-01-11,SM,San Marino,EURO,0,2722,0,65
2021-01-12,SM,San Marino,EURO,0,2722,0,65
2021-01-13,SM,San Marino,EURO,17,2739,0,65
2021-01-14,SM,San Marino,EURO,15,2754,0,65
2021-01-15,SM,San Marino,EURO,29,2783,0,65
2021-01-16,SM,San Marino,EURO,11,2794,0,65
2021-01-17,SM,San Marino,EURO,9,2803,0,65
2021-01-18,SM,San Marino,EURO,0,2803,0,65
2021-01-19,SM,San Marino,EURO,28,2831,0,65
2021-01-20,SM,San Marino,EURO,0,2831,0,65
2021-01-21,SM,San Marino,EURO,18,2849,0,65
2021-01-22,SM,San Marino,EURO,28,2877,0,65
2021-01-23,SM,San Marino,EURO,13,2890,0,65
2021-01-24,SM,San Marino,EURO,15,2905,0,65
2021-01-25,SM,San Marino,EURO,0,2905,0,65
2021-01-26,SM,San Marino,EURO,26,2931,0,65
2021-01-27,SM,San Marino,EURO,26,2957,0,65
2021-01-28,SM,San Marino,EURO,28,2985,0,65
2021-01-29,SM,San Marino,EURO,27,3012,0,65
2021-01-30,SM,San Marino,EURO,29,3041,2,67
2021-01-31,SM,San Marino,EURO,41,3082,0,67
2021-02-01,SM,San Marino,EURO,0,3082,0,67
2021-02-02,SM,San Marino,EURO,28,3110,1,68
2021-02-03,SM,San Marino,EURO,17,3127,0,68
2021-02-04,SM,San Marino,EURO,14,3141,0,68
2021-02-05,SM,San Marino,EURO,2,3143,1,69
2021-02-06,SM,San Marino,EURO,9,3152,0,69
2021-02-07,SM,San Marino,EURO,1,3153,0,69
2021-02-08,SM,San Marino,EURO,50,3203,2,71
2021-02-09,SM,San Marino,EURO,0,3203,0,71
2021-02-10,SM,San Marino,EURO,26,3229,0,71
2021-02-11,SM,San Marino,EURO,34,3263,1,72
2021-02-12,SM,San Marino,EURO,31,3294,0,72
2021-02-13,SM,San Marino,EURO,26,3320,0,72
2021-02-14,SM,San Marino,EURO,10,3330,0,72
2021-02-15,SM,San Marino,EURO,3,3333,0,72
2021-02-16,SM,San Marino,EURO,35,3368,0,72
2021-02-17,SM,San Marino,EURO,42,3410,0,72
2021-02-18,SM,San Marino,EURO,26,3436,0,72
2021-02-19,SM,San Marino,EURO,20,3456,0,72
2021-02-20,SM,San Marino,EURO,32,3488,0,72
2021-02-21,SM,San Marino,EURO,20,3508,0,72
2021-02-22,SM,San Marino,EURO,2,3510,0,72
2021-02-23,SM,San Marino,EURO,44,3554,1,73
2021-02-24,SM,San Marino,EURO,47,3601,0,73
2021-02-25,SM,San Marino,EURO,36,3637,0,73
2021-02-26,SM,San Marino,EURO,50,3687,0,73
2021-02-27,SM,San Marino,EURO,45,3732,1,74
2021-02-28,SM,San Marino,EURO,30,3762,0,74
2021-03-01,SM,San Marino,EURO,0,3762,0,74
2021-03-02,SM,San Marino,EURO,45,3807,0,74
2021-03-03,SM,San Marino,EURO,38,3845,1,75
2021-03-04,SM,San Marino,EURO,38,3883,0,75
2021-03-05,SM,San Marino,EURO,29,3912,1,76
2021-03-06,SM,San Marino,EURO,26,3938,0,76
2021-03-07,SM,San Marino,EURO,13,3951,0,76
2021-03-08,SM,San Marino,EURO,49,4000,1,77
2021-03-09,SM,San Marino,EURO,46,4046,0,77
2021-03-10,SM,San Marino,EURO,32,4078,0,77
2021-03-11,SM,San Marino,EURO,34,4112,0,77
2021-03-12,SM,San Marino,EURO,30,4142,0,77
2021-03-13,SM,San Marino,EURO,25,4167,0,77
2021-03-14,SM,San Marino,EURO,0,4167,0,77
2021-03-15,SM,San Marino,EURO,0,4167,0,77
2021-03-16,SM,San Marino,EURO,53,4220,0,77
2021-03-17,SM,San Marino,EURO,45,4265,0,77
2021-03-18,SM,San Marino,EURO,43,4308,1,78
2021-03-19,SM,San Marino,EURO,36,4344,1,79
2021-03-20,SM,San Marino,EURO,28,4372,0,79
2021-03-21,SM,San Marino,EURO,32,4404,0,79
2021-03-22,SM,San Marino,EURO,0,4404,0,79
2021-03-23,SM,San Marino,EURO,45,4449,1,80
2021-03-24,SM,San Marino,EURO,51,4500,2,82
2021-03-25,SM,San Marino,EURO,63,4563,2,84
2021-03-26,SM,San Marino,EURO,56,4619,0,84
2021-03-27,SM,San Marino,EURO,23,4642,0,84
2021-03-28,SM,San Marino,EURO,5,4647,0,84
2021-03-29,SM,San Marino,EURO,55,4702,0,84
2021-03-30,SM,San Marino,EURO,46,4748,0,84
2021-03-31,SM,San Marino,EURO,6,4754,0,84
2021-04-01,SM,San Marino,EURO,48,4802,0,84
2021-04-02,SM,San Marino,EURO,16,4818,0,84
2021-04-03,SM,San Marino,EURO,3,4821,0,84
2021-04-04,SM,San Marino,EURO,59,4880,1,85
2021-04-05,SM,San Marino,EURO,40,4920,0,85
2021-04-06,SM,San Marino,EURO,0,4920,0,85
2021-04-07,SM,San Marino,EURO,0,4920,0,85
2021-04-08,SM,San Marino,EURO,28,4948,0,85
2021-04-09,SM,San Marino,EURO,12,4960,0,85
2021-04-10,SM,San Marino,EURO,12,4972,0,85
2021-04-11,SM,San Marino,EURO,6,4978,1,86
2021-04-12,SM,San Marino,EURO,0,4978,0,86
2021-04-13,SM,San Marino,EURO,23,5001,0,86
2021-04-14,SM,San Marino,EURO,19,5020,0,86
2021-04-15,SM,San Marino,EURO,6,5026,0,86
2021-04-16,SM,San Marino,EURO,20,5046,2,88
2021-04-17,SM,San Marino,EURO,0,5046,0,88
2021-04-18,SM,San Marino,EURO,0,5046,0,88
2021-04-19,SM,San Marino,EURO,10,5056,0,88
2021-04-20,SM,San Marino,EURO,4,5060,0,88
2021-04-21,SM,San Marino,EURO,2,5062,0,88
2021-04-22,SM,San Marino,EURO,1,5063,1,89
2021-04-23,SM,San Marino,EURO,8,5071,1,90
2021-04-24,SM,San Marino,EURO,0,5071,0,90
2021-04-25,SM,San Marino,EURO,0,5071,0,90
2021-04-26,SM,San Marino,EURO,3,5074,0,90
2021-04-27,SM,San Marino,EURO,2,5076,0,90
2021-04-28,SM,San Marino,EURO,0,5076,0,90
2021-04-29,SM,San Marino,EURO,6,5082,0,90
2021-04-30,SM,San Marino,EURO,0,5082,0,90
2021-05-01,SM,San Marino,EURO,1,5083,0,90
2021-05-02,SM,San Marino,EURO,0,5083,0,90
2021-05-03,SM,San Marino,EURO,4,5087,0,90
2021-05-04,SM,San Marino,EURO,5,5092,0,90
2021-05-05,SM,San Marino,EURO,3,5095,0,90
2021-05-06,SM,San Marino,EURO,0,5095,0,90
2021-05-07,SM,San Marino,EURO,0,5095,0,90
2021-05-08,SM,San Marino,EURO,0,5095,0,90
2021-05-09,SM,San Marino,EURO,4,5099,0,90
2021-05-10,SM,San Marino,EURO,0,5099,0,90
2021-05-11,SM,San Marino,EURO,3,5102,0,90
2021-05-12,SM,San Marino,EURO,1,5103,0,90
2021-05-13,SM,San Marino,EURO,0,5103,0,90
2021-05-14,SM,San Marino,EURO,2,5105,0,90
2021-05-15,SM,San Marino,EURO,0,5105,0,90
2021-05-16,SM,San Marino,EURO,0,5105,0,90
2021-05-17,SM,San Marino,EURO,0,5105,0,90
2021-05-18,SM,San Marino,EURO,0,5105,0,90
2021-05-19,SM,San Marino,EURO,0,5105,0,90
2021-05-20,SM,San Marino,EURO,0,5105,0,90
2021-05-21,SM,San Marino,EURO,0,5105,0,90
2021-05-22,SM,San Marino,EURO,0,5105,0,90
2021-05-23,SM,San Marino,EURO,0,5105,0,90
2021-05-24,SM,San Marino,EURO,0,5105,0,90
2021-05-25,SM,San Marino,EURO,0,5105,0,90
2021-05-26,SM,San Marino,EURO,1,5106,0,90
2021-05-27,SM,San Marino,EURO,0,5106,0,90
2021-05-28,SM,San Marino,EURO,0,5106,0,90
2021-05-29,SM,San Marino,EURO,0,5106,0,90
2021-05-30,SM,San Marino,EURO,0,5106,0,90
2021-05-31,SM,San Marino,EURO,0,5106,0,90
2021-06-01,SM,San Marino,EURO,0,5106,0,90
2021-06-02,SM,San Marino,EURO,1,5107,0,90
2021-06-03,SM,San Marino,EURO,0,5107,0,90
2021-06-04,SM,San Marino,EURO,0,5107,0,90
2021-06-05,SM,San Marino,EURO,0,5107,0,90
2021-06-06,SM,San Marino,EURO,0,5107,0,90
2021-06-07,SM,San Marino,EURO,0,5107,0,90
2021-06-08,SM,San Marino,EURO,0,5107,0,90
2021-06-09,SM,San Marino,EURO,0,5107,0,90
2021-06-10,SM,San Marino,EURO,0,5107,0,90
2021-06-11,SM,San Marino,EURO,0,5107,0,90
2021-06-12,SM,San Marino,EURO,0,5107,0,90
2021-06-13,SM,San Marino,EURO,0,5107,0,90
2021-06-14,SM,San Marino,EURO,0,5107,0,90
2021-06-15,SM,San Marino,EURO,0,5107,0,90
2021-06-16,SM,San Marino,EURO,0,5107,0,90
2021-06-17,SM,San Marino,EURO,0,5107,0,90
2021-06-18,SM,San Marino,EURO,0,5107,0,90
2021-06-19,SM,San Marino,EURO,1,5108,0,90
2021-06-20,SM,San Marino,EURO,0,5108,0,90
2021-06-21,SM,San Marino,EURO,0,5108,0,90
2021-06-22,SM,San Marino,EURO,0,5108,0,90
2021-06-23,SM,San Marino,EURO,0,5108,0,90
2021-06-24,SM,San Marino,EURO,0,5108,0,90
2021-06-25,SM,San Marino,EURO,0,5108,0,90
2021-06-26,SM,San Marino,EURO,0,5108,0,90
2021-06-27,SM,San Marino,EURO,0,5108,0,90
2021-06-28,SM,San Marino,EURO,0,5108,0,90
2021-06-29,SM,San Marino,EURO,0,5108,0,90
2021-06-30,SM,San Marino,EURO,0,5108,0,90
2021-07-01,SM,San Marino,EURO,0,5108,0,90
2021-07-02,SM,San Marino,EURO,0,5108,0,90
2021-07-03,SM,San Marino,EURO,0,5108,0,90
2021-07-04,SM,San Marino,EURO,0,5108,0,90
2021-07-05,SM,San Marino,EURO,0,5108,0,90
2021-07-06,SM,San Marino,EURO,0,5108,0,90
2021-07-07,SM,San Marino,EURO,0,5108,0,90
2021-07-08,SM,San Marino,EURO,0,5108,0,90
2021-07-09,SM,San Marino,EURO,1,5109,0,90
2021-07-10,SM,San Marino,EURO,0,5109,0,90
2021-07-11,SM,San Marino,EURO,0,5109,0,90
2021-07-12,SM,San Marino,EURO,1,5110,0,90
2021-07-13,SM,San Marino,EURO,0,5110,0,90
2021-07-14,SM,San Marino,EURO,2,5112,0,90
2021-07-15,SM,San Marino,EURO,1,5113,0,90
2021-07-16,SM,San Marino,EURO,1,5114,0,90
2021-07-17,SM,San Marino,EURO,1,5115,0,90
2021-07-18,SM,San Marino,EURO,1,5116,0,90
2021-07-19,SM,San Marino,EURO,0,5116,0,90
2021-07-20,SM,San Marino,EURO,5,5121,0,90
2021-07-21,SM,San Marino,EURO,0,5121,0,90
2021-07-22,SM,San Marino,EURO,4,5125,0,90
2021-07-23,SM,San Marino,EURO,3,5128,0,90
2021-07-24,SM,San Marino,EURO,3,5131,0,90
2021-07-25,SM,San Marino,EURO,4,5135,0,90
2021-07-26,SM,San Marino,EURO,0,5135,0,90
2021-07-27,SM,San Marino,EURO,15,5150,0,90
2021-07-28,SM,San Marino,EURO,2,5152,0,90
2021-07-29,SM,San Marino,EURO,0,5152,0,90
2021-07-30,SM,San Marino,EURO,10,5162,0,90
2021-07-31,SM,San Marino,EURO,3,5165,0,90
2021-08-01,SM,San Marino,EURO,2,5167,0,90
2021-08-02,SM,San Marino,EURO,0,5167,0,90
2021-08-03,SM,San Marino,EURO,19,5186,0,90
2021-08-04,SM,San Marino,EURO,10,5196,0,90
2021-08-05,SM,San Marino,EURO,1,5197,0,90
2021-08-06,SM,San Marino,EURO,3,5200,0,90
2021-08-07,SM,San Marino,EURO,8,5208,0,90
2021-08-08,SM,San Marino,EURO,2,5210,0,90
2021-08-09,SM,San Marino,EURO,0,5210,0,90
2021-08-10,SM,San Marino,EURO,13,5223,0,90
2021-08-11,SM,San Marino,EURO,3,5226,0,90
2021-08-12,SM,San Marino,EURO,6,5232,0,90
2021-08-13,SM,San Marino,EURO,7,5239,0,90
2021-08-14,SM,San Marino,EURO,6,5245,0,90
2021-08-15,SM,San Marino,EURO,1,5246,0,90
2021-08-16,SM,San Marino,EURO,1,5247,0,90
2021-08-17,SM,San Marino,EURO,7,5254,0,90
2021-08-18,SM,San Marino,EURO,5,5259,0,90
2021-08-19,SM,San Marino,EURO,5,5264,0,90
2021-08-20,SM,San Marino,EURO,5,5269,0,90
2021-08-21,SM,San Marino,EURO,5,5274,0,90
2021-08-22,SM,San Marino,EURO,1,5275,0,90
2021-08-23,SM,San Marino,EURO,4,5279,0,90
2021-08-24,SM,San Marino,EURO,17,5296,0,90
2021-08-25,SM,San Marino,EURO,10,5306,0,90
2021-08-26,SM,San Marino,EURO,12,5318,0,90
2021-08-27,SM,San Marino,EURO,9,5327,0,90
2021-08-28,SM,San Marino,EURO,8,5335,0,90
2021-08-29,SM,San Marino,EURO,1,5336,0,90
2021-08-30,SM,San Marino,EURO,0,5336,0,90
2021-08-31,SM,San Marino,EURO,9,5345,0,90
2021-09-01,SM,San Marino,EURO,5,5350,0,90
2021-09-02,SM,San Marino,EURO,9,5359,0,90
2021-09-03,SM,San Marino,EURO,4,5363,0,90
2021-09-04,SM,San Marino,EURO,0,5363,0,90
2021-09-05,SM,San Marino,EURO,1,5364,0,90
2021-09-06,SM,San Marino,EURO,0,5364,0,90
2021-09-07,SM,San Marino,EURO,8,5372,0,90
2021-09-08,SM,San Marino,EURO,4,5376,0,90
2021-09-09,SM,San Marino,EURO,5,5381,0,90
2021-09-10,SM,San Marino,EURO,7,5388,0,90
2021-09-11,SM,San Marino,EURO,9,5397,0,90
2021-09-12,SM,San Marino,EURO,4,5401,0,90
2021-09-13,SM,San Marino,EURO,1,5402,0,90
2021-09-14,SM,San Marino,EURO,11,5413,0,90
2021-09-15,SM,San Marino,EURO,3,5416,0,90
2021-09-16,SM,San Marino,EURO,6,5422,0,90
2021-09-17,SM,San Marino,EURO,4,5426,0,90
2021-09-18,SM,San Marino,EURO,6,5432,0,90
2021-09-19,SM,San Marino,EURO,2,5434,0,90
2021-09-20,SM,San Marino,EURO,0,5434,0,90
2021-09-21,SM,San Marino,EURO,2,5436,0,90
2021-09-22,SM,San Marino,EURO,0,5436,0,90
2021-09-23,SM,San Marino,EURO,3,5439,0,90
2021-09-24,SM,San Marino,EURO,1,5440,0,90
2021-09-25,SM,San Marino,EURO,1,5441,0,90
2021-09-26,SM,San Marino,EURO,0,5441,1,91
2021-09-27,SM,San Marino,EURO,0,5441,0,91
2021-09-28,SM,San Marino,EURO,7,5448,0,91
2021-09-29,SM,San Marino,EURO,1,5449,0,91
2021-09-30,SM,San Marino,EURO,1,5450,0,91
2021-10-01,SM,San Marino,EURO,1,5451,0,91
2021-10-02,SM,San Marino,EURO,0,5451,0,91
2021-10-03,SM,San Marino,EURO,3,5454,0,91
2021-10-04,SM,San Marino,EURO,0,5454,0,91
2021-10-05,SM,San Marino,EURO,12,5466,0,91
2021-10-06,SM,San Marino,EURO,4,5470,0,91
2021-10-07,SM,San Marino,EURO,4,5474,0,91
2021-10-08,SM,San Marino,EURO,2,5476,0,91
2021-10-09,SM,San Marino,EURO,4,5480,0,91
2021-10-10,SM,San Marino,EURO,0,5480,0,91
2021-10-11,SM,San Marino,EURO,0,5480,0,91
2021-10-12,SM,San Marino,EURO,0,5480,0,91
2021-10-13,SM,San Marino,EURO,0,5480,0,91
2021-10-14,SM,San Marino,EURO,0,5480,0,91
2021-10-15,SM,San Marino,EURO,3,5483,0,91
2021-10-16,SM,San Marino,EURO,1,5484,0,91
2021-10-17,SM,San Marino,EURO,1,5485,0,91
2021-10-18,SM,San Marino,EURO,0,5485,0,91
2021-10-19,SM,San Marino,EURO,4,5489,0,91
2021-10-20,SM,San Marino,EURO,2,5491,0,91
2021-10-21,SM,San Marino,EURO,8,5499,0,91
2021-10-22,SM,San Marino,EURO,6,5505,0,91
2021-10-23,SM,San Marino,EURO,4,5509,1,92
2021-10-24,SM,San Marino,EURO,1,5510,0,92
2021-10-25,SM,San Marino,EURO,3,5513,0,92
2021-10-26,SM,San Marino,EURO,16,5529,0,92
2021-10-27,SM,San Marino,EURO,13,5542,0,92
2021-10-28,SM,San Marino,EURO,6,5548,0,92
2021-10-29,SM,San Marino,EURO,8,5556,0,92
2021-10-30,SM,San Marino,EURO,13,5569,0,92
2021-10-31,SM,San Marino,EURO,2,5571,0,92
2021-11-01,SM,San Marino,EURO,3,5574,0,92
2021-11-02,SM,San Marino,EURO,3,5577,0,92
2021-11-03,SM,San Marino,EURO,2,5579,0,92
2021-11-04,SM,San Marino,EURO,11,5590,0,92
2021-11-05,SM,San Marino,EURO,8,5598,0,92
2021-11-06,SM,San Marino,EURO,11,5609,0,92
2021-11-07,SM,San Marino,EURO,0,5609,0,92
2021-11-08,SM,San Marino,EURO,0,5609,0,92
2021-11-09,SM,San Marino,EURO,12,5621,0,92
2021-11-10,SM,San Marino,EURO,4,5625,0,92
2021-11-11,SM,San Marino,EURO,11,5636,0,92
2021-11-12,SM,San Marino,EURO,16,5652,0,92
2021-11-13,SM,San Marino,EURO,8,5660,0,92
2021-11-14,SM,San Marino,EURO,6,5666,0,92
2021-11-15,SM,San Marino,EURO,2,5668,0,92
2021-11-16,SM,San Marino,EURO,28,5696,0,92
2021-11-17,SM,San Marino,EURO,27,5723,1,93
2021-11-18,SM,San Marino,EURO,24,5747,0,93
2021-11-19,SM,San Marino,EURO,24,5771,0,93
2021-11-20,SM,San Marino,EURO,23,5794,0,93
2021-11-21,SM,San Marino,EURO,14,5808,0,93
2021-11-22,SM,San Marino,EURO,2,5810,0,93
2021-11-23,SM,San Marino,EURO,41,5851,0,93
2021-11-24,SM,San Marino,EURO,38,5889,0,93
2021-11-25,SM,San Marino,EURO,35,5924,0,93
2021-11-26,SM,San Marino,EURO,23,5947,0,93
2021-11-27,SM,San Marino,EURO,26,5973,0,93
2021-11-28,SM,San Marino,EURO,17,5990,0,93
2021-11-29,SM,San Marino,EURO,6,5996,0,93
2021-11-30,SM,San Marino,EURO,57,6053,0,93
2021-12-01,SM,San Marino,EURO,46,6099,0,93
2021-12-02,SM,San Marino,EURO,35,6134,0,93
2021-12-03,SM,San Marino,EURO,32,6166,0,93
2021-12-04,SM,San Marino,EURO,39,6205,0,93
2021-12-05,SM,San Marino,EURO,29,6234,1,94
2021-12-06,SM,San Marino,EURO,0,6234,0,94
2021-12-07,SM,San Marino,EURO,91,6325,0,94
2021-12-08,SM,San Marino,EURO,42,6367,0,94
2021-12-09,SM,San Marino,EURO,7,6374,0,94
2021-12-10,SM,San Marino,EURO,106,6480,0,94
2021-12-11,SM,San Marino,EURO,84,6564,0,94
2021-12-12,SM,San Marino,EURO,46,6610,0,94
2021-12-13,SM,San Marino,EURO,3,6613,0,94
2021-12-14,SM,San Marino,EURO,121,6734,0,94
2021-12-15,SM,San Marino,EURO,89,6823,0,94
2021-12-16,SM,San Marino,EURO,109,6932,1,95
2021-12-17,SM,San Marino,EURO,92,7024,0,95
2021-12-18,SM,San Marino,EURO,80,7104,1,96
2021-12-19,SM,San Marino,EURO,65,7169,0,96
2021-12-20,SM,San Marino,EURO,8,7177,0,96
2021-12-21,SM,San Marino,EURO,92,7269,1,97
2021-12-22,SM,San Marino,EURO,96,7365,0,97
2021-12-23,SM,San Marino,EURO,91,7456,0,97
2021-12-24,SM,San Marino,EURO,79,7535,1,98
2021-12-25,SM,San Marino,EURO,70,7605,0,98
2021-12-26,SM,San Marino,EURO,9,7614,0,98
2021-12-27,SM,San Marino,EURO,51,7665,0,98
2021-12-28,SM,San Marino,EURO,159,7824,0,98
2021-12-29,SM,San Marino,EURO,117,7941,0,98
2021-12-30,SM,San Marino,EURO,128,8069,0,98
2021-12-31,SM,San Marino,EURO,152,8221,1,99
2022-01-01,SM,San Marino,EURO,167,8388,1,100
2022-01-02,SM,San Marino,EURO,5,8393,0,100
2022-01-03,SM,San Marino,EURO,123,8516,0,100
2022-01-04,SM,San Marino,EURO,194,8710,2,102
2022-01-05,SM,San Marino,EURO,172,8882,0,102
2022-01-06,SM,San Marino,EURO,247,9129,1,103
2022-01-07,SM,San Marino,EURO,18,9147,0,103
2022-01-08,SM,San Marino,EURO,259,9406,0,103
2022-01-09,SM,San Marino,EURO,164,9570,0,103
2022-01-10,SM,San Marino,EURO,13,9583,0,103
2022-01-11,SM,San Marino,EURO,272,9855,0,103
2022-01-12,SM,San Marino,EURO,218,10073,0,103
2022-01-13,SM,San Marino,EURO,176,10249,0,103
2022-01-14,SM,San Marino,EURO,147,10396,0,103
2022-01-15,SM,San Marino,EURO,147,10543,0,103
2022-01-16,SM,San Marino,EURO,128,10671,0,103
2022-01-17,SM,San Marino,EURO,5,10676,0,103
2022-01-18,SM,San Marino,EURO,222,10898,0,103
2022-01-19,SM,San Marino,EURO,215,11113,0,103
2022-01-20,SM,San Marino,EURO,210,11323,2,105
2022-01-21,SM,San Marino,EURO,177,11500,1,106
2022-01-22,SM,San Marino,EURO,172,11672,1,107
2022-01-23,SM,San Marino,EURO,140,11812,0,107
2022-01-24,SM,San Marino,EURO,14,11826,1,108
2022-01-25,SM,San Marino,EURO,210,12036,0,108
2022-01-26,SM,San Marino,EURO,236,12272,1,109
2022-01-27,SM,San Marino,EURO,229,12501,0,109
2022-01-28,SM,San Marino,EURO,164,12665,0,109
2022-01-29,SM,San Marino,EURO,142,12807,0,109
2022-01-30,SM,San Marino,EURO,110,12917,0,109
2022-01-31,SM,San Marino,EURO,13,12930,0,109
2022-02-01,SM,San Marino,EURO,193,13123,0,109
2022-02-02,SM,San Marino,EURO,129,13252,0,109
2022-02-03,SM,San Marino,EURO,104,13356,0,109
2022-02-04,SM,San Marino,EURO,99,13455,0,109
2022-02-05,SM,San Marino,EURO,94,13549,0,109
2022-02-06,SM,San Marino,EURO,5,13554,0,109
2022-02-07,SM,San Marino,EURO,17,13571,0,109
.
142105a
2022-02-05,WS,Samoa,WPRO,0,33,0,0
2022-02-06,WS,Samoa,WPRO,0,33,0,0
2022-02-07,WS,Samoa,WPRO,0,33,0,0
.
141341a
2022-02-05,VC,Saint Vincent and the Grenadines,AMRO,79,8114,0,95
2022-02-06,VC,Saint Vincent and the Grenadines,AMRO,0,8114,0,95
2022-02-07,VC,Saint Vincent and the Grenadines,AMRO,0,8114,0,95
.
140577a
2022-02-05,PM,Saint Pierre and Miquelon,AMRO,0,828,0,1
2022-02-06,PM,Saint Pierre and Miquelon,AMRO,0,828,0,1
2022-02-07,PM,Saint Pierre and Miquelon,AMRO,0,828,0,1
.
139813a
2022-02-05,MF,Saint Martin,AMRO,0,9433,0,42
2022-02-06,MF,Saint Martin,AMRO,0,9433,0,42
2022-02-07,MF,Saint Martin,AMRO,0,9433,0,42
.
139049a
2022-02-05,LC,Saint Lucia,AMRO,199,21399,0,333
2022-02-06,LC,Saint Lucia,AMRO,114,21513,8,341
2022-02-07,LC,Saint Lucia,AMRO,0,21513,0,341
.
138285a
2022-02-05,KN,Saint Kitts and Nevis,AMRO,14,5467,0,37
2022-02-06,KN,Saint Kitts and Nevis,AMRO,2,5469,0,37
2022-02-07,KN,Saint Kitts and Nevis,AMRO,6,5475,0,37
.
137521a
2022-02-05,SH,Saint Helena,AFRO,0,0,0,0
2022-02-06,SH,Saint Helena,AFRO,0,0,0,0
2022-02-07,SH,Saint Helena,AFRO,0,0,0,0
.
136757a
2022-02-05,BL,Saint Barthélemy,AMRO,0,3427,0,4
2022-02-06,BL,Saint Barthélemy,AMRO,0,3427,0,4
2022-02-07,BL,Saint Barthélemy,AMRO,0,3427,0,4
.
135993a
2022-02-05,XC,Saba,AMRO,0,200,0,0
2022-02-06,XC,Saba,AMRO,0,200,0,0
2022-02-07,XC,Saba,AMRO,0,200,0,0
.
135229c
2022-02-04,RW,Rwanda,AFRO,68,129039,0,1444
2022-02-05,RW,Rwanda,AFRO,45,129084,1,1445
2022-02-06,RW,Rwanda,AFRO,41,129125,1,1446
2022-02-07,RW,Rwanda,AFRO,0,129125,0,1446
.
134465a
2022-02-05,RU,Russian Federation,EURO,177282,12630047,714,334753
2022-02-06,RU,Russian Federation,EURO,180071,12810118,661,335414
2022-02-07,RU,Russian Federation,EURO,171905,12982023,609,336023
.
133701a
2022-02-05,RO,Romania,EURO,31776,2356792,97,60450
2022-02-06,RO,Romania,EURO,28921,2385713,110,60560
2022-02-07,RO,Romania,EURO,16108,2401821,82,60642
.
132937a
2022-02-05,RE,Réunion,AFRO,0,226005,0,531
2022-02-06,RE,Réunion,AFRO,0,226005,0,531
2022-02-07,RE,Réunion,AFRO,0,226005,0,531
.
132173a
2022-02-05,MD,Republic of Moldova,EURO,3927,464234,21,10755
2022-02-06,MD,Republic of Moldova,EURO,3037,467271,13,10768
2022-02-07,MD,Republic of Moldova,EURO,1511,468782,8,10776
.
131409c
2022-02-04,KR,Republic of Korea,WPRO,27437,934650,24,6836
2022-02-05,KR,Republic of Korea,WPRO,36347,970997,22,6858
2022-02-06,KR,Republic of Korea,WPRO,38680,1009677,15,6873
2022-02-07,KR,Republic of Korea,WPRO,35286,1044963,13,6886
.
130645a
2022-02-05,QA,Qatar,EMRO,997,343808,1,652
2022-02-06,QA,Qatar,EMRO,903,344711,0,652
2022-02-07,QA,Qatar,EMRO,912,345623,0,652
.
129881a
2022-02-05,PR,Puerto Rico,AMRO,1533,462543,17,3925
2022-02-06,PR,Puerto Rico,AMRO,745,463288,14,3939
2022-02-07,PR,Puerto Rico,AMRO,1733,465021,5,3944
.
129117a
2022-02-05,PT,Portugal,EURO,47199,2843029,50,20127
2022-02-06,PT,Portugal,EURO,41511,2884540,44,20171
2022-02-07,PT,Portugal,EURO,31431,2915971,51,20222
.
128353a
2022-02-05,PL,Poland,EURO,45748,5129080,272,106578
2022-02-06,PL,Poland,EURO,34700,5163780,19,106597
2022-02-07,PL,Poland,EURO,21977,5185757,10,106607
.
127589a
2022-02-05,PN,Pitcairn Islands,WPRO,0,0,0,0
2022-02-06,PN,Pitcairn Islands,WPRO,0,0,0,0
2022-02-07,PN,Pitcairn Islands,WPRO,0,0,0,0
.
126825a
2022-02-05,PH,Philippines,WPRO,8321,3593782,46,54214
2022-02-06,PH,Philippines,WPRO,7425,3601207,0,54214
2022-02-07,PH,Philippines,WPRO,8361,3609568,312,54526
.
126061a
2022-02-05,PE,Peru,AMRO,22542,3308693,186,206406
2022-02-06,PE,Peru,AMRO,22597,3331290,240,206646
2022-02-07,PE,Peru,AMRO,18008,3349298,245,206891
.
125297a
2022-02-05,PY,Paraguay,AMRO,3740,598170,50,17476
2022-02-06,PY,Paraguay,AMRO,3646,601816,39,17515
2022-02-07,PY,Paraguay,AMRO,3189,605005,43,17558
.
124533a
2022-02-05,PG,Papua New Guinea,WPRO,0,37390,0,597
2022-02-06,PG,Papua New Guinea,WPRO,276,37666,0,597
2022-02-07,PG,Papua New Guinea,WPRO,66,37732,0,597
.
123769a
2022-02-05,PA,Panama,AMRO,5480,717171,15,7788
2022-02-06,PA,Panama,AMRO,4308,721479,25,7813
2022-02-07,PA,Panama,AMRO,3589,725068,11,7824
.
123005a
2022-02-05,PW,Palau,WPRO,237,2352,0,0
2022-02-06,PW,Palau,WPRO,143,2495,0,0
2022-02-07,PW,Palau,WPRO,61,2556,0,0
.
123003,123004c
2022-02-02,PW,Palau,WPRO,168,1850,0,0
2022-02-03,PW,Palau,WPRO,90,1940,0,0
.
122240,122241c
2022-02-03,PK,Pakistan,EMRO,6067,1436433,29,29330
2022-02-04,PK,Pakistan,EMRO,5853,1442286,42,29372
2022-02-05,PK,Pakistan,EMRO,6377,1448663,48,29420
2022-02-06,PK,Pakistan,EMRO,6236,1454899,28,29448
2022-02-07,PK,Pakistan,EMRO,4874,1459773,30,29478
.
121477a
2022-02-05, ,Other,Other,0,764,0,13
2022-02-06, ,Other,Other,0,764,0,13
2022-02-07, ,Other,Other,0,764,0,13
.
120713a
2022-02-05,OM,Oman,EMRO,0,346041,0,4158
2022-02-06,OM,Oman,EMRO,0,346041,0,4158
2022-02-07,OM,Oman,EMRO,6146,352187,14,4172
.
119949c
2022-02-04,PS,"occupied Palestinian territory, including east Jerusalem",EMRO,7934,564484,6,5134
2022-02-05,PS,"occupied Palestinian territory, including east Jerusalem",EMRO,6570,571054,10,5144
2022-02-06,PS,"occupied Palestinian territory, including east Jerusalem",EMRO,3051,574105,8,5152
2022-02-07,PS,"occupied Palestinian territory, including east Jerusalem",EMRO,4319,578424,14,5166
.
118858,119185c
2021-03-14,NO,Norway,EURO,951,80536,1,639
2021-03-15,NO,Norway,EURO,737,81273,0,639
2021-03-16,NO,Norway,EURO,698,81971,0,639
2021-03-17,NO,Norway,EURO,1107,83078,0,639
2021-03-18,NO,Norway,EURO,1007,84085,1,640
2021-03-19,NO,Norway,EURO,1059,85144,1,641
2021-03-20,NO,Norway,EURO,1044,86188,7,648
2021-03-21,NO,Norway,EURO,1001,87189,0,648
2021-03-22,NO,Norway,EURO,709,87898,0,648
2021-03-23,NO,Norway,EURO,649,88547,0,648
2021-03-24,NO,Norway,EURO,1107,89654,0,648
2021-03-25,NO,Norway,EURO,967,90621,1,649
2021-03-26,NO,Norway,EURO,1001,91622,0,649
2021-03-27,NO,Norway,EURO,871,92493,7,656
2021-03-28,NO,Norway,EURO,895,93388,0,656
2021-03-29,NO,Norway,EURO,602,93990,0,656
2021-03-30,NO,Norway,EURO,477,94467,0,656
2021-03-31,NO,Norway,EURO,865,95332,0,656
2021-04-01,NO,Norway,EURO,849,96181,4,660
2021-04-02,NO,Norway,EURO,805,96986,1,661
2021-04-03,NO,Norway,EURO,624,97610,12,673
2021-04-04,NO,Norway,EURO,699,98309,0,673
2021-04-05,NO,Norway,EURO,612,98921,0,673
2021-04-06,NO,Norway,EURO,653,99574,0,673
2021-04-07,NO,Norway,EURO,715,100289,0,673
2021-04-08,NO,Norway,EURO,888,101177,3,676
2021-04-09,NO,Norway,EURO,848,102025,1,677
2021-04-10,NO,Norway,EURO,770,102795,6,683
2021-04-11,NO,Norway,EURO,712,103507,1,684
2021-04-12,NO,Norway,EURO,496,104003,0,684
2021-04-13,NO,Norway,EURO,396,104399,0,684
2021-04-14,NO,Norway,EURO,738,105137,0,684
2021-04-15,NO,Norway,EURO,595,105732,3,687
2021-04-16,NO,Norway,EURO,601,106333,1,688
2021-04-17,NO,Norway,EURO,549,106882,18,706
2021-04-18,NO,Norway,EURO,579,107461,1,707
2021-04-19,NO,Norway,EURO,331,107792,1,708
2021-04-20,NO,Norway,EURO,346,108138,0,708
2021-04-21,NO,Norway,EURO,575,108713,0,708
2021-04-22,NO,Norway,EURO,532,109245,1,709
2021-04-23,NO,Norway,EURO,538,109783,0,709
2021-04-24,NO,Norway,EURO,463,110246,25,734
2021-04-25,NO,Norway,EURO,510,110756,1,735
2021-04-26,NO,Norway,EURO,287,111043,1,736
2021-04-27,NO,Norway,EURO,317,111360,0,736
2021-04-28,NO,Norway,EURO,502,111862,0,736
2021-04-29,NO,Norway,EURO,481,112343,1,737
2021-04-30,NO,Norway,EURO,419,112762,0,737
2021-05-01,NO,Norway,EURO,414,113176,16,753
2021-05-02,NO,Norway,EURO,441,113617,1,754
2021-05-03,NO,Norway,EURO,251,113868,2,756
2021-05-04,NO,Norway,EURO,296,114164,0,756
2021-05-05,NO,Norway,EURO,511,114675,0,756
2021-05-06,NO,Norway,EURO,463,115138,1,757
2021-05-07,NO,Norway,EURO,495,115633,0,757
2021-05-08,NO,Norway,EURO,509,116142,10,767
2021-05-09,NO,Norway,EURO,438,116580,0,767
2021-05-10,NO,Norway,EURO,352,116932,0,767
2021-05-11,NO,Norway,EURO,352,117284,0,767
2021-05-12,NO,Norway,EURO,524,117808,0,767
2021-05-13,NO,Norway,EURO,427,118235,0,767
2021-05-14,NO,Norway,EURO,380,118615,1,768
2021-05-15,NO,Norway,EURO,298,118913,6,774
2021-05-16,NO,Norway,EURO,415,119328,0,774
2021-05-17,NO,Norway,EURO,240,119568,0,774
2021-05-18,NO,Norway,EURO,280,119848,0,774
2021-05-19,NO,Norway,EURO,183,120031,0,774
2021-05-20,NO,Norway,EURO,542,120573,0,774
2021-05-21,NO,Norway,EURO,541,121114,0,774
2021-05-22,NO,Norway,EURO,603,121717,7,781
2021-05-23,NO,Norway,EURO,668,122385,0,781
2021-05-24,NO,Norway,EURO,352,122737,0,781
2021-05-25,NO,Norway,EURO,338,123075,0,781
2021-05-26,NO,Norway,EURO,383,123458,0,781
2021-05-27,NO,Norway,EURO,428,123886,1,782
2021-05-28,NO,Norway,EURO,363,124249,0,782
2021-05-29,NO,Norway,EURO,384,124633,1,783
2021-05-30,NO,Norway,EURO,347,124980,0,783
2021-05-31,NO,Norway,EURO,199,125179,0,783
2021-06-01,NO,Norway,EURO,185,125364,0,783
2021-06-02,NO,Norway,EURO,344,125708,0,783
2021-06-03,NO,Norway,EURO,387,126095,0,783
2021-06-04,NO,Norway,EURO,293,126388,0,783
2021-06-05,NO,Norway,EURO,282,126670,1,784
2021-06-06,NO,Norway,EURO,262,126932,0,784
2021-06-07,NO,Norway,EURO,145,127077,0,784
2021-06-08,NO,Norway,EURO,151,127228,0,784
2021-06-09,NO,Norway,EURO,203,127431,0,784
2021-06-10,NO,Norway,EURO,213,127644,0,784
2021-06-11,NO,Norway,EURO,207,127851,1,785
2021-06-12,NO,Norway,EURO,202,128053,4,789
2021-06-13,NO,Norway,EURO,155,128208,0,789
2021-06-14,NO,Norway,EURO,129,128337,0,789
2021-06-15,NO,Norway,EURO,111,128448,0,789
2021-06-16,NO,Norway,EURO,208,128656,0,789
2021-06-17,NO,Norway,EURO,195,128851,0,789
2021-06-18,NO,Norway,EURO,215,129066,0,789
2021-06-19,NO,Norway,EURO,197,129263,1,790
2021-06-20,NO,Norway,EURO,172,129435,0,790
2021-06-21,NO,Norway,EURO,153,129588,0,790
2021-06-22,NO,Norway,EURO,115,129703,0,790
2021-06-23,NO,Norway,EURO,205,129908,0,790
2021-06-24,NO,Norway,EURO,266,130174,0,790
2021-06-25,NO,Norway,EURO,239,130413,0,790
2021-06-26,NO,Norway,EURO,174,130587,2,792
2021-06-27,NO,Norway,EURO,175,130762,0,792
2021-06-28,NO,Norway,EURO,106,130868,0,792
2021-06-29,NO,Norway,EURO,106,130974,0,792
2021-06-30,NO,Norway,EURO,226,131200,0,792
2021-07-01,NO,Norway,EURO,213,131413,0,792
2021-07-02,NO,Norway,EURO,261,131674,2,794
2021-07-03,NO,Norway,EURO,197,131871,0,794
2021-07-04,NO,Norway,EURO,186,132057,0,794
2021-07-05,NO,Norway,EURO,99,132156,0,794
2021-07-06,NO,Norway,EURO,123,132279,0,794
2021-07-07,NO,Norway,EURO,207,132486,0,794
2021-07-08,NO,Norway,EURO,200,132686,0,794
2021-07-09,NO,Norway,EURO,204,132890,2,796
2021-07-10,NO,Norway,EURO,183,133073,0,796
2021-07-11,NO,Norway,EURO,175,133248,0,796
2021-07-12,NO,Norway,EURO,108,133356,0,796
2021-07-13,NO,Norway,EURO,101,133457,0,796
2021-07-14,NO,Norway,EURO,187,133644,0,796
2021-07-15,NO,Norway,EURO,146,133790,0,796
2021-07-16,NO,Norway,EURO,183,133973,0,796
2021-07-17,NO,Norway,EURO,187,134160,0,796
2021-07-18,NO,Norway,EURO,226,134386,0,796
2021-07-19,NO,Norway,EURO,111,134497,0,796
2021-07-20,NO,Norway,EURO,144,134641,0,796
2021-07-21,NO,Norway,EURO,229,134870,0,796
2021-07-22,NO,Norway,EURO,173,135043,0,796
2021-07-23,NO,Norway,EURO,260,135303,3,799
2021-07-24,NO,Norway,EURO,215,135518,0,799
2021-07-25,NO,Norway,EURO,251,135769,0,799
2021-07-26,NO,Norway,EURO,175,135944,0,799
2021-07-27,NO,Norway,EURO,199,136143,0,799
2021-07-28,NO,Norway,EURO,315,136458,0,799
2021-07-29,NO,Norway,EURO,349,136807,0,799
2021-07-30,NO,Norway,EURO,422,137229,0,799
2021-07-31,NO,Norway,EURO,346,137575,0,799
2021-08-01,NO,Norway,EURO,354,137929,0,799
2021-08-02,NO,Norway,EURO,249,138178,0,799
2021-08-03,NO,Norway,EURO,242,138420,0,799
2021-08-04,NO,Norway,EURO,455,138875,0,799
2021-08-05,NO,Norway,EURO,446,139321,0,799
2021-08-06,NO,Norway,EURO,502,139823,5,804
2021-08-07,NO,Norway,EURO,463,140286,0,804
2021-08-08,NO,Norway,EURO,478,140764,0,804
2021-08-09,NO,Norway,EURO,322,141086,0,804
2021-08-10,NO,Norway,EURO,331,141417,0,804
2021-08-11,NO,Norway,EURO,669,142086,0,804
2021-08-12,NO,Norway,EURO,576,142662,0,804
2021-08-13,NO,Norway,EURO,609,143271,1,805
2021-08-14,NO,Norway,EURO,539,143810,2,807
2021-08-15,NO,Norway,EURO,546,144356,0,807
2021-08-16,NO,Norway,EURO,434,144790,2,809
2021-08-17,NO,Norway,EURO,376,145166,0,809
2021-08-18,NO,Norway,EURO,625,145791,0,809
2021-08-19,NO,Norway,EURO,637,146428,1,810
2021-08-20,NO,Norway,EURO,689,147117,1,811
2021-08-21,NO,Norway,EURO,669,147786,1,812
2021-08-22,NO,Norway,EURO,741,148527,0,812
2021-08-23,NO,Norway,EURO,592,149119,1,813
2021-08-24,NO,Norway,EURO,554,149673,0,813
2021-08-25,NO,Norway,EURO,1179,150852,0,813
2021-08-26,NO,Norway,EURO,1334,152186,0,813
2021-08-27,NO,Norway,EURO,1416,153602,3,816
2021-08-28,NO,Norway,EURO,1394,154996,0,816
2021-08-29,NO,Norway,EURO,1435,156431,0,816
2021-08-30,NO,Norway,EURO,1000,157431,4,820
2021-08-31,NO,Norway,EURO,956,158387,0,820
2021-09-01,NO,Norway,EURO,1856,160243,0,820
2021-09-02,NO,Norway,EURO,1624,161867,8,828
2021-09-03,NO,Norway,EURO,1613,163480,0,828
2021-09-04,NO,Norway,EURO,1523,165003,0,828
2021-09-05,NO,Norway,EURO,1545,166548,0,828
2021-09-06,NO,Norway,EURO,992,167540,0,828
2021-09-07,NO,Norway,EURO,954,168494,0,828
2021-09-08,NO,Norway,EURO,1784,170278,1,829
2021-09-09,NO,Norway,EURO,1438,171716,4,833
2021-09-10,NO,Norway,EURO,1382,173098,0,833
2021-09-11,NO,Norway,EURO,1326,174424,0,833
2021-09-12,NO,Norway,EURO,1183,175607,2,835
2021-09-13,NO,Norway,EURO,665,176272,9,844
2021-09-14,NO,Norway,EURO,778,177050,6,850
2021-09-15,NO,Norway,EURO,1313,178363,0,850
2021-09-16,NO,Norway,EURO,1012,179375,5,855
2021-09-17,NO,Norway,EURO,921,180296,0,855
2021-09-18,NO,Norway,EURO,810,181106,0,855
2021-09-19,NO,Norway,EURO,684,181790,0,855
2021-09-20,NO,Norway,EURO,510,182300,2,857
2021-09-21,NO,Norway,EURO,481,182781,0,857
2021-09-22,NO,Norway,EURO,988,183769,0,857
2021-09-23,NO,Norway,EURO,702,184471,0,857
2021-09-24,NO,Norway,EURO,725,185196,0,857
2021-09-25,NO,Norway,EURO,760,185956,0,857
2021-09-26,NO,Norway,EURO,650,186606,0,857
2021-09-27,NO,Norway,EURO,404,187010,12,869
2021-09-28,NO,Norway,EURO,386,187396,0,869
2021-09-29,NO,Norway,EURO,750,188146,0,869
2021-09-30,NO,Norway,EURO,609,188755,0,869
2021-10-01,NO,Norway,EURO,583,189338,0,869
2021-10-02,NO,Norway,EURO,498,189836,0,869
2021-10-03,NO,Norway,EURO,488,190324,0,869
2021-10-04,NO,Norway,EURO,300,190624,7,876
2021-10-05,NO,Norway,EURO,256,190880,0,876
2021-10-06,NO,Norway,EURO,657,191537,0,876
2021-10-07,NO,Norway,EURO,486,192023,1,877
2021-10-08,NO,Norway,EURO,492,192515,0,877
2021-10-09,NO,Norway,EURO,449,192964,0,877
2021-10-10,NO,Norway,EURO,446,193410,0,877
2021-10-11,NO,Norway,EURO,238,193648,7,884
2021-10-12,NO,Norway,EURO,243,193891,0,884
2021-10-13,NO,Norway,EURO,616,194507,0,884
2021-10-14,NO,Norway,EURO,459,194966,1,885
2021-10-15,NO,Norway,EURO,386,195352,0,885
2021-10-16,NO,Norway,EURO,375,195727,0,885
2021-10-17,NO,Norway,EURO,447,196174,0,885
2021-10-18,NO,Norway,EURO,290,196464,5,890
2021-10-19,NO,Norway,EURO,259,196723,0,890
2021-10-20,NO,Norway,EURO,745,197468,0,890
2021-10-21,NO,Norway,EURO,580,198048,3,893
2021-10-22,NO,Norway,EURO,717,198765,0,893
2021-10-23,NO,Norway,EURO,645,199410,0,893
2021-10-24,NO,Norway,EURO,752,200162,0,893
2021-10-25,NO,Norway,EURO,463,200625,8,901
2021-10-26,NO,Norway,EURO,502,201127,0,901
2021-10-27,NO,Norway,EURO,1224,202351,0,901
2021-10-28,NO,Norway,EURO,1055,203406,0,901
2021-10-29,NO,Norway,EURO,1114,204520,0,901
2021-10-30,NO,Norway,EURO,1143,205663,0,901
2021-10-31,NO,Norway,EURO,1179,206842,0,901
2021-11-01,NO,Norway,EURO,605,207447,16,917
2021-11-02,NO,Norway,EURO,687,208134,2,919
2021-11-03,NO,Norway,EURO,1975,210109,0,919
2021-11-04,NO,Norway,EURO,1415,211524,0,919
2021-11-05,NO,Norway,EURO,1650,213174,0,919
2021-11-06,NO,Norway,EURO,1498,214672,0,919
2021-11-07,NO,Norway,EURO,1457,216129,0,919
2021-11-08,NO,Norway,EURO,885,217014,29,948
2021-11-09,NO,Norway,EURO,956,217970,0,948
2021-11-10,NO,Norway,EURO,2390,220360,0,948
2021-11-11,NO,Norway,EURO,1753,222113,2,950
2021-11-12,NO,Norway,EURO,1966,224079,0,950
2021-11-13,NO,Norway,EURO,1773,225852,2,952
2021-11-14,NO,Norway,EURO,1791,227643,0,952
2021-11-15,NO,Norway,EURO,1088,228731,39,991
2021-11-16,NO,Norway,EURO,1060,229791,2,993
2021-11-17,NO,Norway,EURO,2860,232651,2,995
2021-11-18,NO,Norway,EURO,2138,234789,5,1000
2021-11-19,NO,Norway,EURO,2434,237223,1,1001
2021-11-20,NO,Norway,EURO,2334,239557,0,1001
2021-11-21,NO,Norway,EURO,2222,241779,3,1004
2021-11-22,NO,Norway,EURO,1378,243157,36,1040
2021-11-23,NO,Norway,EURO,1351,244508,2,1042
2021-11-24,NO,Norway,EURO,3534,248042,0,1042
2021-11-25,NO,Norway,EURO,2800,250842,6,1048
2021-11-26,NO,Norway,EURO,2938,253780,7,1055
2021-11-27,NO,Norway,EURO,2822,256602,0,1055
2021-11-28,NO,Norway,EURO,2727,259329,0,1055
2021-11-29,NO,Norway,EURO,1796,261125,33,1088
2021-11-30,NO,Norway,EURO,1845,262970,0,1088
2021-12-01,NO,Norway,EURO,4685,267655,4,1092
2021-12-02,NO,Norway,EURO,3787,271442,10,1102
2021-12-03,NO,Norway,EURO,4073,275515,1,1103
2021-12-04,NO,Norway,EURO,4185,279700,0,1103
2021-12-05,NO,Norway,EURO,4290,283990,0,1103
2021-12-06,NO,Norway,EURO,2680,286670,32,1135
2021-12-07,NO,Norway,EURO,2897,289567,3,1138
2021-12-08,NO,Norway,EURO,6470,296037,0,1138
2021-12-09,NO,Norway,EURO,5515,301552,1,1139
2021-12-10,NO,Norway,EURO,5308,306860,1,1140
2021-12-11,NO,Norway,EURO,5301,312161,1,1141
2021-12-12,NO,Norway,EURO,5181,317342,0,1141
2021-12-13,NO,Norway,EURO,3166,320508,42,1183
2021-12-14,NO,Norway,EURO,3211,323719,0,1183
2021-12-15,NO,Norway,EURO,6645,330364,22,1205
2021-12-16,NO,Norway,EURO,5199,335563,0,1205
2021-12-17,NO,Norway,EURO,5020,340583,0,1205
2021-12-18,NO,Norway,EURO,4655,345238,2,1207
2021-12-19,NO,Norway,EURO,4252,349490,0,1207
2021-12-20,NO,Norway,EURO,2747,352237,27,1234
2021-12-21,NO,Norway,EURO,2605,354842,3,1237
2021-12-22,NO,Norway,EURO,5365,360207,2,1239
2021-12-23,NO,Norway,EURO,4173,364380,21,1260
2021-12-24,NO,Norway,EURO,3690,368070,0,1260
2021-12-25,NO,Norway,EURO,3353,371423,0,1260
2021-12-26,NO,Norway,EURO,1781,373204,0,1260
2021-12-27,NO,Norway,EURO,2024,375228,41,1301
2021-12-28,NO,Norway,EURO,2431,377659,1,1302
2021-12-29,NO,Norway,EURO,4796,382455,1,1303
2021-12-30,NO,Norway,EURO,4009,386464,0,1303
2021-12-31,NO,Norway,EURO,4171,390635,2,1305
2022-01-01,NO,Norway,EURO,4191,394826,0,1305
2022-01-02,NO,Norway,EURO,2830,397656,0,1305
2022-01-03,NO,Norway,EURO,2590,400246,40,1345
2022-01-04,NO,Norway,EURO,4055,404301,0,1345
2022-01-05,NO,Norway,EURO,9134,413435,2,1347
2022-01-06,NO,Norway,EURO,8006,421441,2,1349
2022-01-07,NO,Norway,EURO,7033,428474,0,1349
2022-01-08,NO,Norway,EURO,6213,434687,1,1350
2022-01-09,NO,Norway,EURO,6371,441058,0,1350
2022-01-10,NO,Norway,EURO,4432,445490,0,1350
2022-01-11,NO,Norway,EURO,5169,450659,20,1370
2022-01-12,NO,Norway,EURO,12121,462780,0,1370
2022-01-13,NO,Norway,EURO,10902,473682,22,1392
2022-01-14,NO,Norway,EURO,11113,484795,9,1401
2022-01-15,NO,Norway,EURO,10878,495673,0,1401
2022-01-16,NO,Norway,EURO,11344,507017,0,1401
2022-01-17,NO,Norway,EURO,7743,514760,0,1401
2022-01-18,NO,Norway,EURO,8640,523400,8,1409
2022-01-19,NO,Norway,EURO,20807,544207,2,1411
2022-01-20,NO,Norway,EURO,18528,562735,1,1412
2022-01-21,NO,Norway,EURO,18147,580882,1,1413
2022-01-22,NO,Norway,EURO,18277,599159,0,1413
2022-01-23,NO,Norway,EURO,18552,617711,0,1413
2022-01-24,NO,Norway,EURO,12266,629977,0,1413
2022-01-25,NO,Norway,EURO,12864,642841,23,1436
2022-01-26,NO,Norway,EURO,28359,671200,2,1438
2022-01-27,NO,Norway,EURO,23584,694784,2,1440
2022-01-28,NO,Norway,EURO,22083,716867,0,1440
2022-01-29,NO,Norway,EURO,20085,736952,0,1440
2022-01-30,NO,Norway,EURO,18989,755941,0,1440
2022-01-31,NO,Norway,EURO,10767,766708,0,1440
2022-02-01,NO,Norway,EURO,11540,778248,25,1465
2022-02-02,NO,Norway,EURO,27841,806089,0,1465
2022-02-03,NO,Norway,EURO,23418,829507,1,1466
2022-02-04,NO,Norway,EURO,20313,849820,0,1466
2022-02-05,NO,Norway,EURO,17443,867263,0,1466
2022-02-06,NO,Norway,EURO,16488,883751,0,1466
2022-02-07,NO,Norway,EURO,8094,891845,0,1466
.
118421a
2022-02-05,MP,Northern Mariana Islands (Commonwealth of the),WPRO,112,5687,0,23
2022-02-06,MP,Northern Mariana Islands (Commonwealth of the),WPRO,204,5891,0,23
2022-02-07,MP,Northern Mariana Islands (Commonwealth of the),WPRO,211,6102,0,23
.
117646,117657c
2022-01-24,MK,North Macedonia,EURO,1424,256272,18,8239
2022-01-25,MK,North Macedonia,EURO,715,256987,24,8263
2022-01-26,MK,North Macedonia,EURO,2339,259326,25,8288
2022-01-27,MK,North Macedonia,EURO,2015,261341,22,8310
2022-01-28,MK,North Macedonia,EURO,1861,263202,25,8335
2022-01-29,MK,North Macedonia,EURO,1887,265089,28,8363
2022-01-30,MK,North Macedonia,EURO,1836,266925,26,8389
2022-01-31,MK,North Macedonia,EURO,1254,268179,25,8414
2022-02-01,MK,North Macedonia,EURO,710,268889,22,8436
2022-02-02,MK,North Macedonia,EURO,1997,270886,23,8459
2022-02-03,MK,North Macedonia,EURO,1543,272429,19,8478
2022-02-04,MK,North Macedonia,EURO,1715,274144,20,8498
2022-02-05,MK,North Macedonia,EURO,1493,275637,39,8537
2022-02-06,MK,North Macedonia,EURO,1500,277137,16,8553
2022-02-07,MK,North Macedonia,EURO,1045,278182,25,8578
.
116893a
2022-02-05,NU,Niue,WPRO,0,0,0,0
2022-02-06,NU,Niue,WPRO,0,0,0,0
2022-02-07,NU,Niue,WPRO,0,0,0,0
.
116129a
2022-02-05,NG,Nigeria,AFRO,135,253540,0,3136
2022-02-06,NG,Nigeria,AFRO,145,253685,0,3136
2022-02-07,NG,Nigeria,AFRO,42,253727,3,3139
.
115365c
2022-02-04,NE,Niger,AFRO,10,8666,0,301
2022-02-05,NE,Niger,AFRO,4,8670,0,301
2022-02-06,NE,Niger,AFRO,12,8682,1,302
2022-02-07,NE,Niger,AFRO,4,8686,0,302
.
114601a
2022-02-05,NI,Nicaragua,AMRO,0,13727,0,221
2022-02-06,NI,Nicaragua,AMRO,0,13727,0,221
2022-02-07,NI,Nicaragua,AMRO,0,13727,0,221
.
113837a
2022-02-05,NZ,New Zealand,WPRO,269,17170,0,53
2022-02-06,NZ,New Zealand,WPRO,227,17397,0,53
2022-02-07,NZ,New Zealand,WPRO,215,17612,0,53
.
113073a
2022-02-05,NC,New Caledonia,WPRO,0,24627,0,284
2022-02-06,NC,New Caledonia,WPRO,0,24627,0,284
2022-02-07,NC,New Caledonia,WPRO,1289,25916,0,284
.
112225,112309c
2021-11-12,NL,Netherlands,EURO,16249,2252679,25,18661
2021-11-13,NL,Netherlands,EURO,16051,2268730,31,18692
2021-11-14,NL,Netherlands,EURO,13801,2282531,32,18724
2021-11-15,NL,Netherlands,EURO,11976,2294507,7,18731
2021-11-16,NL,Netherlands,EURO,19192,2313699,16,18747
2021-11-17,NL,Netherlands,EURO,20143,2333842,35,18782
2021-11-18,NL,Netherlands,EURO,20705,2354547,44,18826
2021-11-19,NL,Netherlands,EURO,23563,2378110,34,18860
2021-11-20,NL,Netherlands,EURO,20973,2399083,39,18899
2021-11-21,NL,Netherlands,EURO,21758,2420841,55,18954
2021-11-22,NL,Netherlands,EURO,20632,2441473,11,18965
2021-11-23,NL,Netherlands,EURO,22986,2464459,29,18994
2021-11-24,NL,Netherlands,EURO,22949,2487408,53,19047
2021-11-25,NL,Netherlands,EURO,23700,2511108,50,19097
2021-11-26,NL,Netherlands,EURO,22174,2533282,61,19158
2021-11-27,NL,Netherlands,EURO,21264,2554546,59,19217
2021-11-28,NL,Netherlands,EURO,21990,2576536,54,19271
2021-11-29,NL,Netherlands,EURO,22067,2598603,43,19314
2021-11-30,NL,Netherlands,EURO,21454,2620057,33,19347
2021-12-01,NL,Netherlands,EURO,22059,2642116,65,19412
2021-12-02,NL,Netherlands,EURO,18498,2660614,43,19455
2021-12-03,NL,Netherlands,EURO,23031,2683645,65,19520
2021-12-04,NL,Netherlands,EURO,21480,2705125,62,19582
2021-12-05,NL,Netherlands,EURO,22600,2727725,56,19638
2021-12-06,NL,Netherlands,EURO,23051,2750776,26,19664
2021-12-07,NL,Netherlands,EURO,20977,2771753,34,19698
2021-12-08,NL,Netherlands,EURO,17942,2789695,68,19766
2021-12-09,NL,Netherlands,EURO,18055,2807750,71,19837
2021-12-10,NL,Netherlands,EURO,19731,2827481,78,19915
2021-12-11,NL,Netherlands,EURO,17445,2844926,84,19999
2021-12-12,NL,Netherlands,EURO,17746,2862672,69,20068
2021-12-13,NL,Netherlands,EURO,16605,2879277,39,20107
2021-12-14,NL,Netherlands,EURO,13790,2893067,28,20135
2021-12-15,NL,Netherlands,EURO,12796,2905863,74,20209
2021-12-16,NL,Netherlands,EURO,13496,2919359,41,20250
2021-12-17,NL,Netherlands,EURO,16348,2935707,54,20304
2021-12-18,NL,Netherlands,EURO,15338,2951045,59,20363
2021-12-19,NL,Netherlands,EURO,14661,2965706,50,20413
2021-12-20,NL,Netherlands,EURO,13256,2978962,48,20461
2021-12-21,NL,Netherlands,EURO,12141,2991103,35,20496
2021-12-22,NL,Netherlands,EURO,9392,3000495,31,20527
2021-12-23,NL,Netherlands,EURO,13397,3013892,48,20575
2021-12-24,NL,Netherlands,EURO,13315,3027207,40,20615
2021-12-25,NL,Netherlands,EURO,12468,3039675,40,20655
2021-12-26,NL,Netherlands,EURO,12555,3052230,45,20700
2021-12-27,NL,Netherlands,EURO,11893,3064123,11,20711
2021-12-28,NL,Netherlands,EURO,11429,3075552,12,20723
2021-12-29,NL,Netherlands,EURO,9134,3084686,75,20798
2021-12-30,NL,Netherlands,EURO,15696,3100382,50,20848
2021-12-31,NL,Netherlands,EURO,14760,3115142,40,20888
2022-01-01,NL,Netherlands,EURO,16682,3131824,33,20921
2022-01-02,NL,Netherlands,EURO,15586,3147410,27,20948
2022-01-03,NL,Netherlands,EURO,17462,3164872,6,20954
2022-01-04,NL,Netherlands,EURO,14539,3179411,14,20968
2022-01-05,NL,Netherlands,EURO,18553,3197964,19,20987
2022-01-06,NL,Netherlands,EURO,24508,3222472,38,21025
2022-01-07,NL,Netherlands,EURO,24605,3247077,12,21037
2022-01-08,NL,Netherlands,EURO,34828,3281905,24,21061
2022-01-09,NL,Netherlands,EURO,27899,3309804,8,21069
2022-01-10,NL,Netherlands,EURO,32498,3342302,7,21076
2022-01-11,NL,Netherlands,EURO,27902,3370204,7,21083
2022-01-12,NL,Netherlands,EURO,28993,3399197,18,21101
2022-01-13,NL,Netherlands,EURO,32061,3431258,8,21109
2022-01-14,NL,Netherlands,EURO,33321,3464579,13,21122
2022-01-15,NL,Netherlands,EURO,35367,3499946,16,21138
2022-01-16,NL,Netherlands,EURO,31794,3531740,6,21144
2022-01-17,NL,Netherlands,EURO,35951,3567691,7,21151
2022-01-18,NL,Netherlands,EURO,41990,3609681,3,21154
2022-01-19,NL,Netherlands,EURO,31174,3640855,10,21164
2022-01-20,NL,Netherlands,EURO,38170,3679025,10,21174
2022-01-21,NL,Netherlands,EURO,39920,3718945,10,21184
2022-01-22,NL,Netherlands,EURO,57455,3776400,12,21196
2022-01-23,NL,Netherlands,EURO,46161,3822561,8,21204
2022-01-24,NL,Netherlands,EURO,65310,3887871,1,21205
2022-01-25,NL,Netherlands,EURO,64645,3952516,8,21213
2022-01-26,NL,Netherlands,EURO,53964,4006480,9,21222
2022-01-27,NL,Netherlands,EURO,58519,4064999,11,21233
2022-01-28,NL,Netherlands,EURO,64507,4129506,14,21247
2022-01-29,NL,Netherlands,EURO,74002,4203508,9,21256
2022-01-30,NL,Netherlands,EURO,39483,4242991,8,21264
2022-01-31,NL,Netherlands,EURO,75140,4318131,2,21266
2022-02-01,NL,Netherlands,EURO,112224,4430355,5,21271
2022-02-02,NL,Netherlands,EURO,105767,4536122,16,21287
2022-02-03,NL,Netherlands,EURO,66993,4603115,10,21297
2022-02-04,NL,Netherlands,EURO,81818,4684933,11,21308
2022-02-05,NL,Netherlands,EURO,72152,4757085,5,21313
2022-02-06,NL,Netherlands,EURO,54010,4811095,11,21324
2022-02-07,NL,Netherlands,EURO,80946,4892041,8,21332
.
111545a
2022-02-05,NP,Nepal,SEARO,1103,965222,9,11803
2022-02-06,NP,Nepal,SEARO,1183,966405,11,11814
2022-02-07,NP,Nepal,SEARO,1022,967427,13,11827
.
110781a
2022-02-05,NR,Nauru,WPRO,0,0,0,0
2022-02-06,NR,Nauru,WPRO,0,0,0,0
2022-02-07,NR,Nauru,WPRO,0,0,0,0
.
110017c
2022-02-04,NA,Namibia,AFRO,58,156102,0,3973
2022-02-05,NA,Namibia,AFRO,0,156102,0,3973
2022-02-06,NA,Namibia,AFRO,85,156187,1,3974
2022-02-07,NA,Namibia,AFRO,184,156371,6,3980
.
109253c
2022-02-04,MM,Myanmar,SEARO,319,537223,0,19310
2022-02-05,MM,Myanmar,SEARO,346,537569,0,19310
2022-02-06,MM,Myanmar,SEARO,332,537901,0,19310
2022-02-07,MM,Myanmar,SEARO,0,537901,0,19310
.
108489c
2022-02-04,MZ,Mozambique,AFRO,100,224143,0,2180
2022-02-05,MZ,Mozambique,AFRO,81,224224,3,2183
2022-02-06,MZ,Mozambique,AFRO,85,224309,0,2183
2022-02-07,MZ,Mozambique,AFRO,30,224339,0,2183
.
107725c
2022-02-04,MA,Morocco,EMRO,2861,1141708,51,15515
2022-02-05,MA,Morocco,EMRO,2266,1143974,25,15540
2022-02-06,MA,Morocco,EMRO,2067,1146041,35,15575
2022-02-07,MA,Morocco,EMRO,1202,1147243,18,15593
.
106961a
2022-02-05,MS,Montserrat,AMRO,0,163,0,1
2022-02-06,MS,Montserrat,AMRO,0,163,0,1
2022-02-07,MS,Montserrat,AMRO,0,163,0,1
.
106165,106197c
2022-01-03,ME,Montenegro,EURO,1343,173310,3,2414
2022-01-04,ME,Montenegro,EURO,1875,175185,2,2416
2022-01-05,ME,Montenegro,EURO,2389,177574,4,2420
2022-01-06,ME,Montenegro,EURO,2831,180405,2,2422
2022-01-07,ME,Montenegro,EURO,3099,183504,1,2423
2022-01-08,ME,Montenegro,EURO,2358,185862,5,2428
2022-01-09,ME,Montenegro,EURO,2190,188052,5,2433
2022-01-10,ME,Montenegro,EURO,2428,190480,1,2434
2022-01-11,ME,Montenegro,EURO,1896,192376,8,2442
2022-01-12,ME,Montenegro,EURO,2498,194874,6,2448
2022-01-13,ME,Montenegro,EURO,2024,196898,5,2453
2022-01-14,ME,Montenegro,EURO,2192,199090,4,2457
2022-01-15,ME,Montenegro,EURO,1691,200781,3,2460
2022-01-16,ME,Montenegro,EURO,1755,202536,5,2465
2022-01-17,ME,Montenegro,EURO,1418,203954,1,2466
2022-01-18,ME,Montenegro,EURO,1069,205023,8,2474
2022-01-19,ME,Montenegro,EURO,1798,206821,5,2479
2022-01-20,ME,Montenegro,EURO,1499,208320,6,2485
2022-01-21,ME,Montenegro,EURO,1530,209850,8,2493
2022-01-22,ME,Montenegro,EURO,1179,211029,3,2496
2022-01-23,ME,Montenegro,EURO,1222,212251,9,2505
2022-01-24,ME,Montenegro,EURO,997,213248,2,2507
2022-01-25,ME,Montenegro,EURO,756,214004,6,2513
2022-01-26,ME,Montenegro,EURO,1085,215089,11,2524
2022-01-27,ME,Montenegro,EURO,950,216039,6,2530
2022-01-28,ME,Montenegro,EURO,896,216935,5,2535
2022-01-29,ME,Montenegro,EURO,883,217818,6,2541
2022-01-30,ME,Montenegro,EURO,866,218684,5,2546
2022-01-31,ME,Montenegro,EURO,682,219366,6,2552
2022-02-01,ME,Montenegro,EURO,470,219836,3,2555
2022-02-02,ME,Montenegro,EURO,806,220642,9,2564
2022-02-03,ME,Montenegro,EURO,596,221238,4,2568
2022-02-04,ME,Montenegro,EURO,677,221915,14,2582
2022-02-05,ME,Montenegro,EURO,523,222438,9,2591
2022-02-06,ME,Montenegro,EURO,528,222966,5,2596
2022-02-07,ME,Montenegro,EURO,491,223457,3,2599
.
105283,105433c
2021-09-07,MN,Mongolia,WPRO,4664,240938,91,976
2021-09-08,MN,Mongolia,WPRO,6203,247141,6,982
2021-09-09,MN,Mongolia,WPRO,6273,253414,10,992
2021-09-10,MN,Mongolia,WPRO,3393,256807,-58,934
2021-09-11,MN,Mongolia,WPRO,4405,261212,14,948
2021-09-12,MN,Mongolia,WPRO,4366,265578,15,963
2021-09-13,MN,Mongolia,WPRO,3405,268983,10,973
2021-09-14,MN,Mongolia,WPRO,4370,273353,10,983
2021-09-15,MN,Mongolia,WPRO,4976,278329,10,993
2021-09-16,MN,Mongolia,WPRO,5166,283495,8,1001
2021-09-17,MN,Mongolia,WPRO,5239,288734,9,1010
2021-09-18,MN,Mongolia,WPRO,8127,296861,13,1023
2021-09-19,MN,Mongolia,WPRO,5508,302369,12,1035
2021-09-20,MN,Mongolia,WPRO,5509,307878,11,1046
2021-09-21,MN,Mongolia,WPRO,8777,316655,13,1059
2021-09-22,MN,Mongolia,WPRO,9255,325910,14,1073
2021-09-23,MN,Mongolia,WPRO,8084,333994,13,1086
2021-09-24,MN,Mongolia,WPRO,7380,341374,12,1098
2021-09-25,MN,Mongolia,WPRO,7925,349299,18,1116
2021-09-26,MN,Mongolia,WPRO,5084,354383,17,1133
2021-09-27,MN,Mongolia,WPRO,4284,358667,19,1152
2021-09-28,MN,Mongolia,WPRO,8400,367067,17,1169
2021-09-29,MN,Mongolia,WPRO,7797,374864,16,1185
2021-09-30,MN,Mongolia,WPRO,7633,382497,19,1204
2021-10-01,MN,Mongolia,WPRO,7490,389987,18,1222
2021-10-02,MN,Mongolia,WPRO,7224,397211,19,1241
2021-10-03,MN,Mongolia,WPRO,4732,401943,19,1260
2021-10-04,MN,Mongolia,WPRO,3422,405365,14,1274
2021-10-05,MN,Mongolia,WPRO,7589,412954,15,1289
2021-10-06,MN,Mongolia,WPRO,7696,420650,14,1303
2021-10-07,MN,Mongolia,WPRO,7549,428199,15,1318
2021-10-08,MN,Mongolia,WPRO,7870,436069,13,1331
2021-10-09,MN,Mongolia,WPRO,7345,443414,15,1346
2021-10-10,MN,Mongolia,WPRO,4927,448341,17,1363
2021-10-11,MN,Mongolia,WPRO,4012,452353,14,1377
2021-10-12,MN,Mongolia,WPRO,7720,460073,15,1392
2021-10-13,MN,Mongolia,WPRO,8002,468075,17,1409
2021-10-14,MN,Mongolia,WPRO,7183,475258,15,1424
2021-10-15,MN,Mongolia,WPRO,7009,482267,16,1440
2021-10-16,MN,Mongolia,WPRO,6076,488343,14,1454
2021-10-17,MN,Mongolia,WPRO,6867,495210,15,1469
2021-10-18,MN,Mongolia,WPRO,3693,498903,14,1483
2021-10-19,MN,Mongolia,WPRO,6634,505537,18,1501
2021-10-20,MN,Mongolia,WPRO,7332,512869,17,1518
2021-10-21,MN,Mongolia,WPRO,6390,519259,16,1534
2021-10-22,MN,Mongolia,WPRO,6186,525445,19,1553
2021-10-23,MN,Mongolia,WPRO,6580,532025,17,1570
2021-10-24,MN,Mongolia,WPRO,3921,535946,17,1587
2021-10-25,MN,Mongolia,WPRO,3251,539197,6,1593
2021-10-26,MN,Mongolia,WPRO,5597,544794,11,1604
2021-10-27,MN,Mongolia,WPRO,6151,550945,12,1616
2021-10-28,MN,Mongolia,WPRO,5388,556333,10,1626
2021-10-29,MN,Mongolia,WPRO,5190,561523,12,1638
2021-10-30,MN,Mongolia,WPRO,4721,566244,11,1649
2021-10-31,MN,Mongolia,WPRO,24556,590800,12,1661
2021-11-01,MN,Mongolia,WPRO,2194,592994,11,1672
2021-11-02,MN,Mongolia,WPRO,3744,596738,10,1682
2021-11-03,MN,Mongolia,WPRO,6293,603031,12,1694
2021-11-04,MN,Mongolia,WPRO,5926,608957,10,1704
2021-11-05,MN,Mongolia,WPRO,3944,612901,11,1715
2021-11-06,MN,Mongolia,WPRO,3372,616273,9,1724
2021-11-07,MN,Mongolia,WPRO,1781,618054,12,1736
2021-11-08,MN,Mongolia,WPRO,1969,620023,8,1744
2021-11-09,MN,Mongolia,WPRO,2183,622206,12,1756
2021-11-10,MN,Mongolia,WPRO,3862,626068,11,1767
2021-11-11,MN,Mongolia,WPRO,3204,629272,10,1777
2021-11-12,MN,Mongolia,WPRO,2888,632160,9,1786
2021-11-13,MN,Mongolia,WPRO,2477,634637,10,1796
2021-11-14,MN,Mongolia,WPRO,2457,637094,9,1805
2021-11-15,MN,Mongolia,WPRO,1423,638517,10,1815
2021-11-16,MN,Mongolia,WPRO,1747,640264,11,1826
2021-11-17,MN,Mongolia,WPRO,2968,643232,10,1836
2021-11-18,MN,Mongolia,WPRO,3588,646820,10,1846
2021-11-19,MN,Mongolia,WPRO,2911,649731,6,1852
2021-11-20,MN,Mongolia,WPRO,2220,651951,8,1860
2021-11-21,MN,Mongolia,WPRO,1714,653665,7,1867
2021-11-22,MN,Mongolia,WPRO,1162,654827,8,1875
2021-11-23,MN,Mongolia,WPRO,1685,656512,10,1885
2021-11-24,MN,Mongolia,WPRO,2585,659097,11,1896
2021-11-25,MN,Mongolia,WPRO,1788,660885,7,1903
2021-11-26,MN,Mongolia,WPRO,2389,663274,5,1908
2021-11-27,MN,Mongolia,WPRO,1830,665104,4,1912
2021-11-28,MN,Mongolia,WPRO,1189,666293,5,1917
2021-11-29,MN,Mongolia,WPRO,1068,667361,5,1922
2021-11-30,MN,Mongolia,WPRO,1041,668402,8,1930
2021-12-01,MN,Mongolia,WPRO,1979,670381,2,1932
2021-12-02,MN,Mongolia,WPRO,1803,672184,3,1935
2021-12-03,MN,Mongolia,WPRO,1845,674029,3,1938
2021-12-04,MN,Mongolia,WPRO,922,674951,2,1940
2021-12-05,MN,Mongolia,WPRO,1111,676062,3,1943
2021-12-06,MN,Mongolia,WPRO,797,676859,1,1944
2021-12-07,MN,Mongolia,WPRO,1000,677859,3,1947
2021-12-08,MN,Mongolia,WPRO,1091,678950,3,1950
2021-12-09,MN,Mongolia,WPRO,995,679945,3,1953
2021-12-10,MN,Mongolia,WPRO,946,680891,0,1953
2021-12-11,MN,Mongolia,WPRO,869,681760,2,1955
2021-12-12,MN,Mongolia,WPRO,566,682326,5,1960
2021-12-13,MN,Mongolia,WPRO,401,682727,3,1963
2021-12-14,MN,Mongolia,WPRO,606,683333,2,1965
2021-12-15,MN,Mongolia,WPRO,917,684250,1,1966
2021-12-16,MN,Mongolia,WPRO,864,685114,2,1968
2021-12-17,MN,Mongolia,WPRO,684,685798,0,1968
2021-12-18,MN,Mongolia,WPRO,702,686500,2,1970
2021-12-19,MN,Mongolia,WPRO,623,687123,0,1970
2021-12-20,MN,Mongolia,WPRO,309,687432,2,1972
2021-12-21,MN,Mongolia,WPRO,617,688049,2,1974
2021-12-22,MN,Mongolia,WPRO,818,688867,3,1977
2021-12-23,MN,Mongolia,WPRO,565,689432,1,1978
2021-12-24,MN,Mongolia,WPRO,230,689662,2,1980
2021-12-25,MN,Mongolia,WPRO,310,689972,1,1981
2021-12-26,MN,Mongolia,WPRO,705,690677,0,1981
2021-12-27,MN,Mongolia,WPRO,273,690950,0,1981
2021-12-28,MN,Mongolia,WPRO,405,691355,0,1981
2021-12-29,MN,Mongolia,WPRO,431,691786,0,1981
2021-12-30,MN,Mongolia,WPRO,242,692028,4,1985
2021-12-31,MN,Mongolia,WPRO,593,692621,1,1986
2022-01-01,MN,Mongolia,WPRO,498,693119,0,1986
2022-01-02,MN,Mongolia,WPRO,427,693546,1,1987
2022-01-03,MN,Mongolia,WPRO,303,693849,0,1987
2022-01-04,MN,Mongolia,WPRO,1347,695196,2,1989
2022-01-05,MN,Mongolia,WPRO,745,695941,3,1992
2022-01-06,MN,Mongolia,WPRO,1869,697810,2,1994
2022-01-07,MN,Mongolia,WPRO,2001,699811,1,1995
2022-01-08,MN,Mongolia,WPRO,2353,702164,2,1997
2022-01-09,MN,Mongolia,WPRO,1428,703592,0,1997
2022-01-10,MN,Mongolia,WPRO,2394,705986,4,2001
2022-01-11,MN,Mongolia,WPRO,3443,709429,0,2001
2022-01-12,MN,Mongolia,WPRO,3222,712651,2,2003
2022-01-13,MN,Mongolia,WPRO,2610,715261,3,2006
2022-01-14,MN,Mongolia,WPRO,6280,721541,3,2009
2022-01-15,MN,Mongolia,WPRO,8348,729889,2,2011
2022-01-16,MN,Mongolia,WPRO,7089,736978,1,2012
2022-01-17,MN,Mongolia,WPRO,4704,741682,1,2013
2022-01-18,MN,Mongolia,WPRO,5640,747322,3,2016
2022-01-19,MN,Mongolia,WPRO,9071,756393,0,2016
2022-01-20,MN,Mongolia,WPRO,4441,760834,3,2019
2022-01-21,MN,Mongolia,WPRO,11059,771893,1,2020
2022-01-22,MN,Mongolia,WPRO,8269,780162,0,2020
2022-01-23,MN,Mongolia,WPRO,9518,789680,0,2020
2022-01-24,MN,Mongolia,WPRO,5228,794908,1,2021
2022-01-25,MN,Mongolia,WPRO,4871,799779,4,2025
2022-01-26,MN,Mongolia,WPRO,12310,812089,2,2027
2022-01-27,MN,Mongolia,WPRO,7768,819857,2,2029
2022-01-28,MN,Mongolia,WPRO,7896,827753,2,2031
2022-01-29,MN,Mongolia,WPRO,6646,834399,0,2031
2022-01-30,MN,Mongolia,WPRO,2725,837124,3,2034
2022-01-31,MN,Mongolia,WPRO,4724,841848,2,2036
2022-02-01,MN,Mongolia,WPRO,5092,846940,4,2040
2022-02-02,MN,Mongolia,WPRO,2728,849668,2,2042
2022-02-03,MN,Mongolia,WPRO,3472,853140,1,2043
2022-02-04,MN,Mongolia,WPRO,1939,855079,2,2045
2022-02-05,MN,Mongolia,WPRO,3297,858376,4,2049
2022-02-06,MN,Mongolia,WPRO,1740,860116,3,2052
2022-02-07,MN,Mongolia,WPRO,860,860976,3,2055
.
104669a
2022-02-05,MC,Monaco,EURO,66,8703,0,48
2022-02-06,MC,Monaco,EURO,58,8761,0,48
2022-02-07,MC,Monaco,EURO,9,8770,0,48
.
103905a
2022-02-05,FM,Micronesia (Federated States of),WPRO,0,0,0,0
2022-02-06,FM,Micronesia (Federated States of),WPRO,0,0,0,0
2022-02-07,FM,Micronesia (Federated States of),WPRO,0,0,0,0
.
103141a
2022-02-05,MX,Mexico,AMRO,83296,5068985,1221,308141
2022-02-06,MX,Mexico,AMRO,37063,5106048,688,308829
2022-02-07,MX,Mexico,AMRO,35243,5141291,588,309417
.
102377a
2022-02-05,YT,Mayotte,AFRO,0,36474,0,187
2022-02-06,YT,Mayotte,AFRO,0,36474,0,187
2022-02-07,YT,Mayotte,AFRO,0,36474,0,187
.
101613a
2022-02-05,MU,Mauritius,AFRO,0,70862,0,786
2022-02-06,MU,Mauritius,AFRO,0,70862,0,786
2022-02-07,MU,Mauritius,AFRO,0,70862,0,786
.
100849c
2022-02-04,MR,Mauritania,AFRO,46,58381,3,962
2022-02-05,MR,Mauritania,AFRO,26,58407,0,962
2022-02-06,MR,Mauritania,AFRO,36,58443,2,964
2022-02-07,MR,Mauritania,AFRO,15,58458,3,967
.
100085a
2022-02-05,MQ,Martinique,AMRO,1184,95443,0,842
2022-02-06,MQ,Martinique,AMRO,1176,96619,0,842
2022-02-07,MQ,Martinique,AMRO,0,96619,0,842
.
99321a
2022-02-05,MH,Marshall Islands,WPRO,0,4,0,0
2022-02-06,MH,Marshall Islands,WPRO,0,4,0,0
2022-02-07,MH,Marshall Islands,WPRO,0,4,0,0
.
98557a
2022-02-05,MT,Malta,EURO,214,68644,1,560
2022-02-06,MT,Malta,EURO,195,68839,5,565
2022-02-07,MT,Malta,EURO,158,68997,4,569
.
97793c
2022-02-04,ML,Mali,AFRO,-1,30101,0,715
2022-02-05,ML,Mali,AFRO,1,30102,0,715
2022-02-06,ML,Mali,AFRO,55,30157,0,715
2022-02-07,ML,Mali,AFRO,0,30157,0,715
.
97029c
2022-02-04,MV,Maldives,SEARO,1955,146991,0,280
2022-02-05,MV,Maldives,SEARO,1589,148580,1,281
2022-02-06,MV,Maldives,SEARO,1757,150337,2,283
2022-02-07,MV,Maldives,SEARO,0,150337,0,283
.
96265a
2022-02-05,MY,Malaysia,WPRO,7234,2895014,11,32011
2022-02-06,MY,Malaysia,WPRO,9117,2904131,14,32025
2022-02-07,MY,Malaysia,WPRO,10089,2914220,9,32034
.
95501c
2022-02-04,MW,Malawi,AFRO,61,84693,1,2565
2022-02-05,MW,Malawi,AFRO,45,84738,2,2567
2022-02-06,MW,Malawi,AFRO,57,84795,3,2570
2022-02-07,MW,Malawi,AFRO,18,84813,1,2571
.
94737a
2022-02-05,MG,Madagascar,AFRO,0,59319,0,1274
2022-02-06,MG,Madagascar,AFRO,2115,61434,33,1307
2022-02-07,MG,Madagascar,AFRO,0,61434,0,1307
.
93973a
2022-02-05,LU,Luxembourg,EURO,1978,165958,2,958
2022-02-06,LU,Luxembourg,EURO,0,165958,0,958
2022-02-07,LU,Luxembourg,EURO,0,165958,0,958
.
93209a
2022-02-05,LT,Lithuania,EURO,12968,740137,17,7969
2022-02-06,LT,Lithuania,EURO,9477,749614,17,7986
2022-02-07,LT,Lithuania,EURO,6592,756206,13,7999
.
92442,92445c
2022-02-01,LI,Liechtenstein,EURO,146,9281,0,70
2022-02-02,LI,Liechtenstein,EURO,121,9402,0,70
2022-02-03,LI,Liechtenstein,EURO,113,9515,0,70
2022-02-04,LI,Liechtenstein,EURO,107,9622,0,70
2022-02-05,LI,Liechtenstein,EURO,0,9622,0,70
2022-02-06,LI,Liechtenstein,EURO,0,9622,0,70
2022-02-07,LI,Liechtenstein,EURO,0,9622,0,70
.
91681a
2022-02-05,LY,Libya,EMRO,3917,445876,8,6052
2022-02-06,LY,Libya,EMRO,0,445876,0,6052
2022-02-07,LY,Libya,EMRO,4242,450118,15,6067
.
90917a
2022-02-05,LR,Liberia,AFRO,4,7276,0,290
2022-02-06,LR,Liberia,AFRO,0,7276,0,290
2022-02-07,LR,Liberia,AFRO,70,7346,0,290
.
90153a
2022-02-05,LS,Lesotho,AFRO,0,32258,0,694
2022-02-06,LS,Lesotho,AFRO,0,32258,0,694
2022-02-07,LS,Lesotho,AFRO,0,32258,0,694
.
89389c
2022-02-04,LB,Lebanon,EMRO,9446,948728,19,9657
2022-02-05,LB,Lebanon,EMRO,8427,957155,18,9675
2022-02-06,LB,Lebanon,EMRO,8472,965627,19,9694
2022-02-07,LB,Lebanon,EMRO,6147,971774,17,9711
.
88625a
2022-02-05,LV,Latvia,EURO,10137,432370,11,4934
2022-02-06,LV,Latvia,EURO,10501,442871,11,4945
2022-02-07,LV,Latvia,EURO,7234,450105,6,4951
.
87861a
2022-02-05,LA,Lao People's Democratic Republic,WPRO,359,135660,4,562
2022-02-06,LA,Lao People's Democratic Republic,WPRO,488,136148,3,565
2022-02-07,LA,Lao People's Democratic Republic,WPRO,290,136438,9,574
.
87097a
2022-02-05,KG,Kyrgyzstan,EURO,162,199326,3,2899
2022-02-06,KG,Kyrgyzstan,EURO,110,199436,3,2902
2022-02-07,KG,Kyrgyzstan,EURO,83,199519,3,2905
.
86333a
2022-02-05,KW,Kuwait,EMRO,5407,570142,2,2505
2022-02-06,KW,Kuwait,EMRO,4445,574587,3,2508
2022-02-07,KW,Kuwait,EMRO,4232,578819,2,2510
.
85569a
2022-02-05,XK,Kosovo[1],EURO,1853,214481,1,3023
2022-02-06,XK,Kosovo[1],EURO,1721,216202,4,3027
2022-02-07,XK,Kosovo[1],EURO,1283,217485,6,3033
.
84805a
2022-02-05,KI,Kiribati,WPRO,124,1037,0,0
2022-02-06,KI,Kiribati,WPRO,350,1387,0,0
2022-02-07,KI,Kiribati,WPRO,156,1543,0,0
.
84041c
2022-02-04,KE,Kenya,AFRO,93,321764,11,5604
2022-02-05,KE,Kenya,AFRO,158,321922,0,5604
2022-02-06,KE,Kenya,AFRO,121,322043,3,5607
2022-02-07,KE,Kenya,AFRO,53,322096,14,5621
.
83277a
2022-02-05,KZ,Kazakhstan,EURO,5865,1353048,22,18622
2022-02-06,KZ,Kazakhstan,EURO,4926,1357974,19,18641
2022-02-07,KZ,Kazakhstan,EURO,3689,1361663,19,18660
.
82513c
2022-02-04,JO,Jordan,EMRO,19123,1280106,23,13271
2022-02-05,JO,Jordan,EMRO,21386,1301492,17,13288
2022-02-06,JO,Jordan,EMRO,12751,1314243,12,13300
2022-02-07,JO,Jordan,EMRO,15864,1330107,20,13320
.
81749a
2022-02-05,JE,Jersey,EURO,191,32073,0,104
2022-02-06,JE,Jersey,EURO,0,32073,0,104
2022-02-07,JE,Jersey,EURO,0,32073,0,104
.
80985a
2022-02-05,JP,Japan,WPRO,99299,3106775,92,19131
2022-02-06,JP,Japan,WPRO,100949,3207724,126,19257
2022-02-07,JP,Japan,WPRO,92865,3300589,67,19324
.
80221a
2022-02-05,JM,Jamaica,AMRO,267,125517,10,2687
2022-02-06,JM,Jamaica,AMRO,264,125781,4,2691
2022-02-07,JM,Jamaica,AMRO,212,125993,3,2694
.
79457a
2022-02-05,IT,Italy,EURO,100900,11449601,433,148167
2022-02-06,IT,Italy,EURO,93192,11542793,375,148542
2022-02-07,IT,Italy,EURO,78943,11621736,229,148771
.
78193,78693c
2020-09-22,IL,Israel,EURO,3870,192014,32,1344
2020-09-23,IL,Israel,EURO,7017,199031,25,1369
2020-09-24,IL,Israel,EURO,7142,206173,25,1394
2020-09-25,IL,Israel,EURO,8259,214432,31,1425
2020-09-26,IL,Israel,EURO,8388,222820,29,1454
2020-09-27,IL,Israel,EURO,5880,228700,27,1481
2020-09-28,IL,Israel,EURO,3436,232136,31,1512
2020-09-29,IL,Israel,EURO,1154,233290,29,1541
2020-09-30,IL,Israel,EURO,4989,238279,35,1576
2020-10-01,IL,Israel,EURO,9050,247329,37,1613
2020-10-02,IL,Israel,EURO,7720,255049,46,1659
2020-10-03,IL,Israel,EURO,7053,262102,25,1684
2020-10-04,IL,Israel,EURO,2593,264695,38,1722
2020-10-05,IL,Israel,EURO,2932,267627,37,1759
2020-10-06,IL,Israel,EURO,5702,273329,27,1786
2020-10-07,IL,Israel,EURO,4718,278047,45,1831
2020-10-08,IL,Israel,EURO,4153,282200,26,1857
2020-10-09,IL,Israel,EURO,3752,285952,47,1904
2020-10-10,IL,Israel,EURO,2954,288906,40,1944
2020-10-11,IL,Israel,EURO,916,289822,35,1979
2020-10-12,IL,Israel,EURO,1638,291460,45,2024
2020-10-13,IL,Israel,EURO,3154,294614,30,2054
2020-10-14,IL,Israel,EURO,2335,296949,37,2091
2020-10-15,IL,Israel,EURO,2118,299067,34,2125
2020-10-16,IL,Israel,EURO,1609,300676,32,2157
2020-10-17,IL,Israel,EURO,1496,302172,35,2192
2020-10-18,IL,Israel,EURO,410,302582,32,2224
2020-10-19,IL,Israel,EURO,923,303505,33,2257
2020-10-20,IL,Israel,EURO,1516,305021,31,2288
2020-10-21,IL,Israel,EURO,1192,306213,20,2308
2020-10-22,IL,Israel,EURO,1170,307383,25,2333
2020-10-23,IL,Israel,EURO,1031,308414,29,2362
2020-10-24,IL,Israel,EURO,848,309262,26,2388
2020-10-25,IL,Israel,EURO,247,309509,26,2414
2020-10-26,IL,Israel,EURO,604,310113,34,2448
2020-10-27,IL,Israel,EURO,884,310997,28,2476
2020-10-28,IL,Israel,EURO,885,311882,28,2504
2020-10-29,IL,Israel,EURO,724,312606,10,2514
2020-10-30,IL,Israel,EURO,647,313253,19,2533
2020-10-31,IL,Israel,EURO,681,313934,12,2545
2020-11-01,IL,Israel,EURO,228,314162,25,2570
2020-11-02,IL,Israel,EURO,657,314819,19,2589
2020-11-03,IL,Israel,EURO,792,315611,15,2604
2020-11-04,IL,Israel,EURO,843,316454,26,2630
2020-11-05,IL,Israel,EURO,769,317223,15,2645
2020-11-06,IL,Israel,EURO,568,317791,14,2659
2020-11-07,IL,Israel,EURO,689,318480,16,2675
2020-11-08,IL,Israel,EURO,212,318692,8,2683
2020-11-09,IL,Israel,EURO,535,319227,7,2690
2020-11-10,IL,Israel,EURO,723,319950,8,2698
2020-11-11,IL,Israel,EURO,673,320623,10,2708
2020-11-12,IL,Israel,EURO,768,321391,7,2715
2020-11-13,IL,Israel,EURO,837,322228,12,2727
2020-11-14,IL,Israel,EURO,761,322989,5,2732
2020-11-15,IL,Israel,EURO,292,323281,11,2743
2020-11-16,IL,Israel,EURO,627,323908,14,2757
2020-11-17,IL,Israel,EURO,874,324782,9,2766
2020-11-18,IL,Israel,EURO,830,325612,12,2778
2020-11-19,IL,Israel,EURO,797,326409,7,2785
2020-11-20,IL,Israel,EURO,771,327180,8,2793
2020-11-21,IL,Israel,EURO,772,327952,6,2799
2020-11-22,IL,Israel,EURO,423,328375,12,2811
2020-11-23,IL,Israel,EURO,763,329138,16,2827
2020-11-24,IL,Israel,EURO,961,330099,7,2834
2020-11-25,IL,Israel,EURO,859,330958,5,2839
2020-11-26,IL,Israel,EURO,1082,332040,5,2844
2020-11-27,IL,Israel,EURO,1086,333126,9,2853
2020-11-28,IL,Israel,EURO,1033,334159,7,2860
2020-11-29,IL,Israel,EURO,583,334742,9,2869
2020-11-30,IL,Israel,EURO,1026,335768,10,2879
2020-12-01,IL,Israel,EURO,1257,337025,6,2885
2020-12-02,IL,Israel,EURO,1200,338225,10,2895
2020-12-03,IL,Israel,EURO,1589,339814,5,2900
2020-12-04,IL,Israel,EURO,1450,341264,10,2910
2020-12-05,IL,Israel,EURO,1515,342779,9,2919
2020-12-06,IL,Israel,EURO,1000,343779,10,2929
2020-12-07,IL,Israel,EURO,1359,345138,8,2937
2020-12-08,IL,Israel,EURO,1863,347001,7,2944
2020-12-09,IL,Israel,EURO,1771,348772,12,2956
2020-12-10,IL,Israel,EURO,1869,350641,13,2969
2020-12-11,IL,Israel,EURO,2008,352649,13,2982
2020-12-12,IL,Israel,EURO,1835,354484,11,2993
2020-12-13,IL,Israel,EURO,1297,355781,16,3009
2020-12-14,IL,Israel,EURO,1727,357508,9,3018
2020-12-15,IL,Israel,EURO,2322,359830,11,3029
2020-12-16,IL,Israel,EURO,2893,362723,15,3044
2020-12-17,IL,Israel,EURO,2860,365583,15,3059
2020-12-18,IL,Israel,EURO,2847,368430,17,3076
2020-12-19,IL,Israel,EURO,2793,371223,16,3092
2020-12-20,IL,Israel,EURO,1889,373112,20,3112
2020-12-21,IL,Israel,EURO,3096,376208,18,3130
2020-12-22,IL,Israel,EURO,3861,380069,16,3146
2020-12-23,IL,Israel,EURO,4381,384450,13,3159
2020-12-24,IL,Israel,EURO,4041,388491,25,3184
2020-12-25,IL,Israel,EURO,4050,392541,15,3199
2020-12-26,IL,Israel,EURO,4006,396547,21,3220
2020-12-27,IL,Israel,EURO,2660,399207,23,3243
2020-12-28,IL,Israel,EURO,3534,402741,21,3264
2020-12-29,IL,Israel,EURO,5525,408266,32,3296
2020-12-30,IL,Israel,EURO,5633,413899,25,3321
2020-12-31,IL,Israel,EURO,5871,419770,16,3337
2021-01-01,IL,Israel,EURO,5867,425637,36,3373
2021-01-02,IL,Israel,EURO,6014,431651,34,3407
2021-01-03,IL,Israel,EURO,4212,435863,27,3434
2021-01-04,IL,Israel,EURO,5232,441095,26,3460
2021-01-05,IL,Israel,EURO,8424,449519,38,3498
2021-01-06,IL,Israel,EURO,8233,457752,23,3521
2021-01-07,IL,Israel,EURO,7884,465636,43,3564
2021-01-08,IL,Israel,EURO,7664,473300,48,3612
2021-01-09,IL,Israel,EURO,8162,481462,46,3658
2021-01-10,IL,Israel,EURO,5165,486627,20,3678
2021-01-11,IL,Israel,EURO,6956,493583,43,3721
2021-01-12,IL,Israel,EURO,9730,503313,28,3749
2021-01-13,IL,Israel,EURO,9298,512611,55,3804
2021-01-14,IL,Israel,EURO,9474,522085,57,3861
2021-01-15,IL,Israel,EURO,9301,531386,59,3920
2021-01-16,IL,Israel,EURO,8431,539817,52,3972
2021-01-17,IL,Israel,EURO,5086,544903,47,4019
2021-01-18,IL,Israel,EURO,5661,550564,56,4075
2021-01-19,IL,Israel,EURO,10123,560687,46,4121
2021-01-20,IL,Israel,EURO,8633,569320,43,4164
2021-01-21,IL,Israel,EURO,8361,577681,56,4220
2021-01-22,IL,Israel,EURO,7270,584951,47,4267
2021-01-23,IL,Israel,EURO,7387,592338,66,4333
2021-01-24,IL,Israel,EURO,2447,594785,52,4385
2021-01-25,IL,Israel,EURO,4938,599723,75,4460
2021-01-26,IL,Israel,EURO,8718,608441,60,4520
2021-01-27,IL,Israel,EURO,7817,616258,53,4573
2021-01-28,IL,Israel,EURO,7750,624008,61,4634
2021-01-29,IL,Israel,EURO,7197,631205,49,4683
2021-01-30,IL,Israel,EURO,6776,637981,45,4728
2021-01-31,IL,Israel,EURO,2628,640609,38,4766
2021-02-01,IL,Israel,EURO,5240,645849,51,4817
2021-02-02,IL,Israel,EURO,8931,654780,46,4863
2021-02-03,IL,Israel,EURO,8024,662804,61,4924
2021-02-04,IL,Israel,EURO,7462,670266,57,4981
2021-02-05,IL,Israel,EURO,7262,677528,48,5029
2021-02-06,IL,Israel,EURO,6600,684128,34,5063
2021-02-07,IL,Israel,EURO,2660,686788,51,5114
2021-02-08,IL,Israel,EURO,4605,691393,44,5158
2021-02-09,IL,Israel,EURO,7856,699249,30,5188
2021-02-10,IL,Israel,EURO,6168,705417,42,5230
2021-02-11,IL,Israel,EURO,5678,711095,32,5262
2021-02-12,IL,Israel,EURO,5055,716150,30,5292
2021-02-13,IL,Israel,EURO,4674,720824,41,5333
2021-02-14,IL,Israel,EURO,1890,722714,29,5362
2021-02-15,IL,Israel,EURO,3489,726203,37,5399
2021-02-16,IL,Israel,EURO,5200,731403,16,5415
2021-02-17,IL,Israel,EURO,4583,735986,42,5457
2021-02-18,IL,Israel,EURO,4168,740154,27,5484
2021-02-19,IL,Israel,EURO,3338,743492,35,5519
2021-02-20,IL,Israel,EURO,3794,747286,22,5541
2021-02-21,IL,Israel,EURO,1255,748541,26,5567
2021-02-22,IL,Israel,EURO,3114,751655,25,5592
2021-02-23,IL,Israel,EURO,4812,756467,15,5607
2021-02-24,IL,Israel,EURO,4443,760910,35,5642
2021-02-25,IL,Israel,EURO,4375,765285,27,5669
2021-02-26,IL,Israel,EURO,3820,769105,23,5692
2021-02-27,IL,Israel,EURO,3819,772924,22,5714
2021-02-28,IL,Israel,EURO,1443,774367,30,5744
2021-03-01,IL,Israel,EURO,3030,777397,21,5765
2021-03-02,IL,Israel,EURO,4848,782245,18,5783
2021-03-03,IL,Israel,EURO,4390,786635,21,5804
2021-03-04,IL,Israel,EURO,4670,791305,17,5821
2021-03-05,IL,Israel,EURO,3658,794963,17,5838
2021-03-06,IL,Israel,EURO,3693,798656,18,5856
2021-03-07,IL,Israel,EURO,1843,800499,20,5876
2021-03-08,IL,Israel,EURO,2362,802861,16,5892
2021-03-09,IL,Israel,EURO,3796,806657,21,5913
2021-03-10,IL,Israel,EURO,3127,809784,15,5928
2021-03-11,IL,Israel,EURO,2843,812627,17,5945
2021-03-12,IL,Israel,EURO,2553,815180,18,5963
2021-03-13,IL,Israel,EURO,2414,817594,12,5975
2021-03-14,IL,Israel,EURO,787,818381,16,5991
2021-03-15,IL,Israel,EURO,1409,819790,26,6017
2021-03-16,IL,Israel,EURO,2130,821920,17,6034
2021-03-17,IL,Israel,EURO,1566,823486,16,6050
2021-03-18,IL,Israel,EURO,1541,825027,14,6064
2021-03-19,IL,Israel,EURO,1254,826281,9,6073
2021-03-20,IL,Israel,EURO,1085,827366,12,6085
2021-03-21,IL,Israel,EURO,351,827717,7,6092
2021-03-22,IL,Israel,EURO,681,828398,14,6106
2021-03-23,IL,Israel,EURO,984,829382,14,6120
2021-03-24,IL,Israel,EURO,695,830077,14,6134
2021-03-25,IL,Israel,EURO,478,830555,10,6144
2021-03-26,IL,Israel,EURO,883,831438,9,6153
2021-03-27,IL,Israel,EURO,539,831977,11,6164
2021-03-28,IL,Israel,EURO,237,832214,6,6170
2021-03-29,IL,Israel,EURO,131,832345,13,6183
2021-03-30,IL,Israel,EURO,376,832721,11,6194
2021-03-31,IL,Israel,EURO,451,833172,13,6207
2021-04-01,IL,Israel,EURO,498,833670,14,6221
2021-04-02,IL,Israel,EURO,334,834004,8,6229
2021-04-03,IL,Israel,EURO,419,834423,15,6244
2021-04-04,IL,Israel,EURO,124,834547,7,6251
2021-04-05,IL,Israel,EURO,197,834744,8,6259
2021-04-06,IL,Israel,EURO,383,835127,6,6265
2021-04-07,IL,Israel,EURO,307,835434,8,6273
2021-04-08,IL,Israel,EURO,274,835708,9,6282
2021-04-09,IL,Israel,EURO,212,835920,9,6291
2021-04-10,IL,Israel,EURO,226,836146,10,6301
2021-04-11,IL,Israel,EURO,86,836232,9,6310
2021-04-12,IL,Israel,EURO,141,836373,6,6316
2021-04-13,IL,Israel,EURO,224,836597,6,6322
2021-04-14,IL,Israel,EURO,198,836795,13,6335
2021-04-15,IL,Israel,EURO,195,836990,3,6338
2021-04-16,IL,Israel,EURO,95,837085,3,6341
2021-04-17,IL,Israel,EURO,110,837195,5,6346
2021-04-18,IL,Israel,EURO,87,837282,7,6353
2021-04-19,IL,Israel,EURO,185,837467,4,6357
2021-04-20,IL,Israel,EURO,143,837610,3,6360
2021-04-21,IL,Israel,EURO,169,837779,4,6364
2021-04-22,IL,Israel,EURO,115,837894,2,6366
2021-04-23,IL,Israel,EURO,148,838042,2,6368
2021-04-24,IL,Israel,EURO,112,838154,5,6373
2021-04-25,IL,Israel,EURO,36,838190,4,6377
2021-04-26,IL,Israel,EURO,80,838270,1,6378
2021-04-27,IL,Israel,EURO,101,838371,3,6381
2021-04-28,IL,Israel,EURO,107,838478,6,6387
2021-04-29,IL,Israel,EURO,106,838584,0,6387
2021-04-30,IL,Israel,EURO,97,838681,2,6389
2021-05-01,IL,Israel,EURO,79,838760,2,6391
2021-05-02,IL,Israel,EURO,15,838775,2,6393
2021-05-03,IL,Israel,EURO,54,838829,1,6394
2021-05-04,IL,Israel,EURO,77,838906,3,6397
2021-05-05,IL,Israel,EURO,64,838970,2,6399
2021-05-06,IL,Israel,EURO,73,839043,2,6401
2021-05-07,IL,Israel,EURO,54,839097,2,6403
2021-05-08,IL,Israel,EURO,34,839131,2,6405
2021-05-09,IL,Israel,EURO,16,839147,1,6406
2021-05-10,IL,Israel,EURO,33,839180,1,6407
2021-05-11,IL,Israel,EURO,57,839237,2,6409
2021-05-12,IL,Israel,EURO,39,839276,1,6410
2021-05-13,IL,Israel,EURO,28,839304,1,6411
2021-05-14,IL,Israel,EURO,33,839337,2,6413
2021-05-15,IL,Israel,EURO,27,839364,0,6413
2021-05-16,IL,Israel,EURO,20,839384,1,6414
2021-05-17,IL,Israel,EURO,34,839418,1,6415
2021-05-18,IL,Israel,EURO,15,839433,3,6418
2021-05-19,IL,Israel,EURO,23,839456,0,6418
2021-05-20,IL,Israel,EURO,56,839512,0,6418
2021-05-21,IL,Israel,EURO,35,839547,0,6418
2021-05-22,IL,Israel,EURO,22,839569,2,6420
2021-05-23,IL,Israel,EURO,12,839581,0,6420
2021-05-24,IL,Israel,EURO,27,839608,1,6421
2021-05-25,IL,Israel,EURO,30,839638,1,6422
2021-05-26,IL,Israel,EURO,22,839660,1,6423
2021-05-27,IL,Israel,EURO,16,839676,0,6423
2021-05-28,IL,Israel,EURO,16,839692,2,6425
2021-05-29,IL,Israel,EURO,18,839710,1,6426
2021-05-30,IL,Israel,EURO,13,839723,0,6426
2021-05-31,IL,Israel,EURO,3,839726,0,6426
2021-06-01,IL,Israel,EURO,14,839740,0,6426
2021-06-02,IL,Israel,EURO,35,839775,2,6428
2021-06-03,IL,Israel,EURO,13,839788,0,6428
2021-06-04,IL,Israel,EURO,11,839799,1,6429
2021-06-05,IL,Israel,EURO,31,839830,0,6429
2021-06-06,IL,Israel,EURO,6,839836,1,6430
2021-06-07,IL,Israel,EURO,4,839840,0,6430
2021-06-08,IL,Israel,EURO,7,839847,1,6431
2021-06-09,IL,Israel,EURO,30,839877,1,6432
2021-06-10,IL,Israel,EURO,8,839885,1,6433
2021-06-11,IL,Israel,EURO,18,839903,0,6433
2021-06-12,IL,Israel,EURO,18,839921,0,6433
2021-06-13,IL,Israel,EURO,5,839926,0,6433
2021-06-14,IL,Israel,EURO,3,839929,1,6434
2021-06-15,IL,Israel,EURO,26,839955,0,6434
2021-06-16,IL,Israel,EURO,26,839981,0,6434
2021-06-17,IL,Israel,EURO,14,839995,1,6435
2021-06-18,IL,Israel,EURO,29,840024,0,6435
2021-06-19,IL,Israel,EURO,35,840059,0,6435
2021-06-20,IL,Israel,EURO,47,840106,1,6436
2021-06-21,IL,Israel,EURO,51,840157,0,6436
2021-06-22,IL,Israel,EURO,125,840282,0,6436
2021-06-23,IL,Israel,EURO,113,840395,0,6436
2021-06-24,IL,Israel,EURO,151,840546,0,6436
2021-06-25,IL,Israel,EURO,242,840788,0,6436
2021-06-26,IL,Israel,EURO,233,841021,1,6437
2021-06-27,IL,Israel,EURO,119,841140,0,6437
2021-06-28,IL,Israel,EURO,145,841285,0,6437
2021-06-29,IL,Israel,EURO,289,841574,0,6437
2021-06-30,IL,Israel,EURO,301,841875,0,6437
2021-07-01,IL,Israel,EURO,332,842207,0,6437
2021-07-02,IL,Israel,EURO,299,842506,0,6437
2021-07-03,IL,Israel,EURO,359,842865,0,6437
2021-07-04,IL,Israel,EURO,189,843054,0,6437
2021-07-05,IL,Israel,EURO,350,843404,0,6437
2021-07-06,IL,Israel,EURO,504,843908,0,6437
2021-07-07,IL,Israel,EURO,539,844447,0,6437
2021-07-08,IL,Israel,EURO,527,844974,1,6438
2021-07-09,IL,Israel,EURO,472,845446,2,6440
2021-07-10,IL,Israel,EURO,541,845987,0,6440
2021-07-11,IL,Israel,EURO,261,846248,2,6442
2021-07-12,IL,Israel,EURO,443,846691,3,6445
2021-07-13,IL,Israel,EURO,764,847455,2,6447
2021-07-14,IL,Israel,EURO,749,848204,0,6447
2021-07-15,IL,Israel,EURO,774,848978,3,6450
2021-07-16,IL,Israel,EURO,873,849851,1,6451
2021-07-17,IL,Israel,EURO,1145,850996,1,6452
2021-07-18,IL,Israel,EURO,439,851435,2,6454
2021-07-19,IL,Israel,EURO,838,852273,3,6457
2021-07-20,IL,Israel,EURO,1395,853668,2,6459
2021-07-21,IL,Israel,EURO,1413,855081,2,6461
2021-07-22,IL,Israel,EURO,1367,856448,3,6464
2021-07-23,IL,Israel,EURO,1289,857737,1,6465
2021-07-24,IL,Israel,EURO,1442,859179,0,6465
2021-07-25,IL,Israel,EURO,973,860152,3,6468
2021-07-26,IL,Israel,EURO,1431,861583,4,6472
2021-07-27,IL,Israel,EURO,2135,863718,1,6473
2021-07-28,IL,Israel,EURO,2301,866019,1,6474
2021-07-29,IL,Israel,EURO,2197,868216,6,6480
2021-07-30,IL,Israel,EURO,2180,870396,6,6486
2021-07-31,IL,Israel,EURO,2460,872856,2,6488
2021-08-01,IL,Israel,EURO,2104,874960,5,6493
2021-08-02,IL,Israel,EURO,2126,877086,9,6502
2021-08-03,IL,Israel,EURO,3862,880948,9,6511
2021-08-04,IL,Israel,EURO,3312,884260,10,6521
2021-08-05,IL,Israel,EURO,3510,887770,5,6526
2021-08-06,IL,Israel,EURO,3887,891657,16,6542
2021-08-07,IL,Israel,EURO,3890,895547,14,6556
2021-08-08,IL,Israel,EURO,2936,898483,12,6568
2021-08-09,IL,Israel,EURO,3447,901930,19,6587
2021-08-10,IL,Israel,EURO,6382,908312,11,6598
2021-08-11,IL,Israel,EURO,5860,914172,17,6615
2021-08-12,IL,Israel,EURO,6027,920199,16,6631
2021-08-13,IL,Israel,EURO,6154,926353,19,6650
2021-08-14,IL,Israel,EURO,5976,932329,24,6674
2021-08-15,IL,Israel,EURO,4233,936562,18,6692
2021-08-16,IL,Israel,EURO,5199,941761,20,6712
2021-08-17,IL,Israel,EURO,8798,950559,28,6740
2021-08-18,IL,Israel,EURO,7994,958553,20,6760
2021-08-19,IL,Israel,EURO,8037,966590,22,6782
2021-08-20,IL,Israel,EURO,7842,974432,24,6806
2021-08-21,IL,Israel,EURO,7908,982340,24,6830
2021-08-22,IL,Israel,EURO,5416,987756,25,6855
2021-08-23,IL,Israel,EURO,6594,994350,33,6888
2021-08-24,IL,Israel,EURO,10116,1004466,20,6908
2021-08-25,IL,Israel,EURO,10086,1014552,31,6939
2021-08-26,IL,Israel,EURO,9245,1023797,28,6967
2021-08-27,IL,Israel,EURO,9124,1032921,32,6999
2021-08-28,IL,Israel,EURO,8700,1041621,25,7024
2021-08-29,IL,Israel,EURO,7280,1048901,23,7047
2021-08-30,IL,Israel,EURO,6792,1055693,29,7076
2021-08-31,IL,Israel,EURO,11158,1066851,26,7102
2021-09-01,IL,Israel,EURO,10447,1077298,31,7133
2021-09-02,IL,Israel,EURO,11304,1088602,31,7164
2021-09-03,IL,Israel,EURO,11346,1099948,31,7195
2021-09-04,IL,Israel,EURO,9913,1109861,34,7229
2021-09-05,IL,Israel,EURO,5067,1114928,26,7255
2021-09-06,IL,Israel,EURO,5868,1120796,26,7281
2021-09-07,IL,Israel,EURO,10871,1131667,23,7304
2021-09-08,IL,Israel,EURO,6866,1138533,27,7331
2021-09-09,IL,Israel,EURO,3320,1141853,29,7360
2021-09-10,IL,Israel,EURO,7962,1149815,22,7382
2021-09-11,IL,Israel,EURO,9901,1159716,17,7399
2021-09-12,IL,Israel,EURO,10292,1170008,27,7426
2021-09-13,IL,Israel,EURO,7808,1177816,22,7448
2021-09-14,IL,Israel,EURO,10955,1188771,20,7468
2021-09-15,IL,Israel,EURO,9859,1198630,29,7497
2021-09-16,IL,Israel,EURO,8864,1207494,20,7517
2021-09-17,IL,Israel,EURO,3285,1210779,21,7538
2021-09-18,IL,Israel,EURO,5024,1215803,17,7555
2021-09-19,IL,Israel,EURO,8617,1224420,17,7572
2021-09-20,IL,Israel,EURO,6553,1230973,28,7600
2021-09-21,IL,Israel,EURO,8828,1239801,15,7615
2021-09-22,IL,Israel,EURO,4829,1244630,17,7632
2021-09-23,IL,Israel,EURO,6026,1250656,19,7651
2021-09-24,IL,Israel,EURO,6453,1257109,19,7670
2021-09-25,IL,Israel,EURO,4990,1262099,21,7691
2021-09-26,IL,Israel,EURO,2653,1264752,24,7715
2021-09-27,IL,Israel,EURO,3875,1268627,14,7729
2021-09-28,IL,Israel,EURO,5246,1273873,17,7746
2021-09-29,IL,Israel,EURO,2441,1276314,21,7767
2021-09-30,IL,Israel,EURO,3636,1279950,23,7790
2021-10-01,IL,Israel,EURO,4398,1284348,14,7804
2021-10-02,IL,Israel,EURO,3622,1287970,22,7826
2021-10-03,IL,Israel,EURO,1739,1289709,18,7844
2021-10-04,IL,Israel,EURO,2700,1292409,23,7867
2021-10-05,IL,Israel,EURO,3278,1295687,11,7878
2021-10-06,IL,Israel,EURO,2556,1298243,15,7893
2021-10-07,IL,Israel,EURO,2429,1300672,15,7908
2021-10-08,IL,Israel,EURO,2120,1302792,17,7925
2021-10-09,IL,Israel,EURO,2024,1304816,6,7931
2021-10-10,IL,Israel,EURO,1040,1305856,14,7945
2021-10-11,IL,Israel,EURO,1490,1307346,14,7959
2021-10-12,IL,Israel,EURO,2343,1309689,13,7972
2021-10-13,IL,Israel,EURO,1816,1311505,10,7982
2021-10-14,IL,Israel,EURO,1772,1313277,11,7993
2021-10-15,IL,Israel,EURO,1345,1314622,14,8007
2021-10-16,IL,Israel,EURO,1575,1316197,10,8017
2021-10-17,IL,Israel,EURO,740,1316937,9,8026
2021-10-18,IL,Israel,EURO,1221,1318158,6,8032
2021-10-19,IL,Israel,EURO,1508,1319666,9,8041
2021-10-20,IL,Israel,EURO,1150,1320816,3,8044
2021-10-21,IL,Israel,EURO,1036,1321852,8,8052
2021-10-22,IL,Israel,EURO,993,1322845,7,8059
2021-10-23,IL,Israel,EURO,982,1323827,4,8063
2021-10-24,IL,Israel,EURO,332,1324159,8,8071
2021-10-25,IL,Israel,EURO,842,1325001,6,8077
2021-10-26,IL,Israel,EURO,929,1325930,11,8088
2021-10-27,IL,Israel,EURO,729,1326659,9,8097
2021-10-28,IL,Israel,EURO,647,1327306,5,8102
2021-10-29,IL,Israel,EURO,661,1327967,7,8109
2021-10-30,IL,Israel,EURO,617,1328584,6,8115
2021-10-31,IL,Israel,EURO,225,1328809,3,8118
2021-11-01,IL,Israel,EURO,528,1329337,2,8120
2021-11-02,IL,Israel,EURO,691,1330028,4,8124
2021-11-03,IL,Israel,EURO,667,1330695,3,8127
2021-11-04,IL,Israel,EURO,616,1331311,5,8132
2021-11-05,IL,Israel,EURO,519,1331830,6,8138
2021-11-06,IL,Israel,EURO,558,1332388,1,8139
2021-11-07,IL,Israel,EURO,199,1332587,1,8140
2021-11-08,IL,Israel,EURO,502,1333089,4,8144
2021-11-09,IL,Israel,EURO,566,1333655,3,8147
2021-11-10,IL,Israel,EURO,473,1334128,6,8153
2021-11-11,IL,Israel,EURO,498,1334626,5,8158
2021-11-12,IL,Israel,EURO,393,1335019,3,8161
2021-11-13,IL,Israel,EURO,448,1335467,2,8163
2021-11-14,IL,Israel,EURO,225,1335692,2,8165
2021-11-15,IL,Israel,EURO,397,1336089,0,8165
2021-11-16,IL,Israel,EURO,535,1336624,5,8170
2021-11-17,IL,Israel,EURO,558,1337182,4,8174
2021-11-18,IL,Israel,EURO,483,1337665,1,8175
2021-11-19,IL,Israel,EURO,469,1338134,3,8178
2021-11-20,IL,Israel,EURO,508,1338642,3,8181
2021-11-21,IL,Israel,EURO,237,1338879,6,8187
2021-11-22,IL,Israel,EURO,453,1339332,1,8188
2021-11-23,IL,Israel,EURO,715,1340047,2,8190
2021-11-24,IL,Israel,EURO,604,1340651,0,8190
2021-11-25,IL,Israel,EURO,543,1341194,3,8193
2021-11-26,IL,Israel,EURO,540,1341734,3,8196
2021-11-27,IL,Israel,EURO,540,1342274,2,8198
2021-11-28,IL,Israel,EURO,169,1342443,1,8199
2021-11-29,IL,Israel,EURO,543,1342986,3,8202
2021-11-30,IL,Israel,EURO,698,1343684,3,8205
2021-12-01,IL,Israel,EURO,577,1344261,3,8208
2021-12-02,IL,Israel,EURO,563,1344824,1,8209
2021-12-03,IL,Israel,EURO,521,1345345,2,8211
2021-12-04,IL,Israel,EURO,486,1345831,1,8212
2021-12-05,IL,Israel,EURO,248,1346079,2,8214
2021-12-06,IL,Israel,EURO,539,1346618,1,8215
2021-12-07,IL,Israel,EURO,739,1347357,2,8217
2021-12-08,IL,Israel,EURO,813,1348170,3,8220
2021-12-09,IL,Israel,EURO,714,1348884,6,8226
2021-12-10,IL,Israel,EURO,647,1349531,1,8227
2021-12-11,IL,Israel,EURO,607,1350138,2,8229
2021-12-12,IL,Israel,EURO,236,1350374,1,8230
2021-12-13,IL,Israel,EURO,492,1350866,2,8232
2021-12-14,IL,Israel,EURO,771,1351637,4,8236
2021-12-15,IL,Israel,EURO,702,1352339,1,8237
2021-12-16,IL,Israel,EURO,789,1353128,1,8238
2021-12-17,IL,Israel,EURO,863,1353991,1,8239
2021-12-18,IL,Israel,EURO,877,1354868,2,8241
2021-12-19,IL,Israel,EURO,393,1355261,2,8243
2021-12-20,IL,Israel,EURO,1021,1356282,2,8245
2021-12-21,IL,Israel,EURO,1329,1357611,2,8247
2021-12-22,IL,Israel,EURO,1200,1358811,0,8247
2021-12-23,IL,Israel,EURO,1417,1360228,0,8247
2021-12-24,IL,Israel,EURO,1514,1361742,1,8248
2021-12-25,IL,Israel,EURO,1789,1363531,1,8249
2021-12-26,IL,Israel,EURO,806,1364337,0,8249
2021-12-27,IL,Israel,EURO,1806,1366143,2,8251
2021-12-28,IL,Israel,EURO,2974,1369117,3,8254
2021-12-29,IL,Israel,EURO,3246,1372363,1,8255
2021-12-30,IL,Israel,EURO,4073,1376436,2,8257
2021-12-31,IL,Israel,EURO,5080,1381516,0,8257
2022-01-01,IL,Israel,EURO,5493,1387009,1,8258
2022-01-02,IL,Israel,EURO,4231,1391240,2,8260
2022-01-03,IL,Israel,EURO,6615,1397855,5,8265
2022-01-04,IL,Israel,EURO,10954,1408809,4,8269
2022-01-05,IL,Israel,EURO,12639,1421448,1,8270
2022-01-06,IL,Israel,EURO,18538,1439986,4,8274
2022-01-07,IL,Israel,EURO,19033,1459019,2,8276
2022-01-08,IL,Israel,EURO,21989,1481008,3,8279
2022-01-09,IL,Israel,EURO,22869,1503877,5,8284
2022-01-10,IL,Israel,EURO,31146,1535023,7,8291
2022-01-11,IL,Israel,EURO,41420,1576443,9,8300
2022-01-12,IL,Israel,EURO,46769,1623212,7,8307
2022-01-13,IL,Israel,EURO,48607,1671819,7,8314
2022-01-14,IL,Israel,EURO,49259,1721078,9,8323
2022-01-15,IL,Israel,EURO,45853,1766931,10,8333
2022-01-16,IL,Israel,EURO,45059,1811990,17,8350
2022-01-17,IL,Israel,EURO,64728,1876718,17,8367
2022-01-18,IL,Israel,EURO,71996,1948714,20,8387
2022-01-19,IL,Israel,EURO,73770,2022484,17,8404
2022-01-20,IL,Israel,EURO,74954,2097438,23,8427
2022-01-21,IL,Israel,EURO,75047,2172485,24,8451
2022-01-22,IL,Israel,EURO,65591,2238076,33,8484
2022-01-23,IL,Israel,EURO,67890,2305966,40,8524
2022-01-24,IL,Israel,EURO,85169,2391135,39,8563
2022-01-25,IL,Israel,EURO,83666,2474801,53,8616
2022-01-26,IL,Israel,EURO,76296,2551097,42,8658
2022-01-27,IL,Israel,EURO,67852,2618949,49,8707
2022-01-28,IL,Israel,EURO,57669,2676618,35,8742
2022-01-29,IL,Israel,EURO,53307,2729925,49,8791
2022-01-30,IL,Israel,EURO,49457,2779382,50,8841
2022-01-31,IL,Israel,EURO,74367,2853749,55,8896
2022-02-01,IL,Israel,EURO,67863,2921612,48,8944
2022-02-02,IL,Israel,EURO,60532,2982144,59,9003
2022-02-03,IL,Israel,EURO,60903,3043047,57,9060
2022-02-04,IL,Israel,EURO,46664,3089711,41,9101
2022-02-05,IL,Israel,EURO,38090,3127801,27,9128
2022-02-06,IL,Israel,EURO,33438,3161239,32,9160
2022-02-07,IL,Israel,EURO,52600,3213839,20,9180
.
78104,78183c
2020-06-25,IL,Israel,EURO,485,22117,3,316
2020-06-26,IL,Israel,EURO,516,22633,4,320
2020-06-27,IL,Israel,EURO,464,23097,3,323
2020-06-28,IL,Israel,EURO,397,23494,3,326
2020-06-29,IL,Israel,EURO,383,23877,2,328
2020-06-30,IL,Israel,EURO,759,24636,0,328
2020-07-01,IL,Israel,EURO,789,25425,1,329
2020-07-02,IL,Israel,EURO,968,26393,3,332
2020-07-03,IL,Israel,EURO,1154,27547,1,333
2020-07-04,IL,Israel,EURO,941,28488,3,336
2020-07-05,IL,Israel,EURO,821,29309,5,341
2020-07-06,IL,Israel,EURO,825,30134,2,343
2020-07-07,IL,Israel,EURO,1128,31262,8,351
2020-07-08,IL,Israel,EURO,1384,32646,5,356
2020-07-09,IL,Israel,EURO,1329,33975,5,361
2020-07-10,IL,Israel,EURO,1521,35496,5,366
2020-07-11,IL,Israel,EURO,1407,36903,4,370
2020-07-12,IL,Israel,EURO,1168,38071,5,375
2020-07-13,IL,Israel,EURO,1236,39307,7,382
2020-07-14,IL,Israel,EURO,1717,41024,4,386
2020-07-15,IL,Israel,EURO,1601,42625,7,393
2020-07-16,IL,Israel,EURO,1873,44498,6,399
2020-07-17,IL,Israel,EURO,1936,46434,9,408
2020-07-18,IL,Israel,EURO,1601,48035,12,420
2020-07-19,IL,Israel,EURO,1444,49479,8,428
2020-07-20,IL,Israel,EURO,1016,50495,10,438
2020-07-21,IL,Israel,EURO,1886,52381,12,450
2020-07-22,IL,Israel,EURO,2004,54385,9,459
2020-07-23,IL,Israel,EURO,2041,56426,6,465
2020-07-24,IL,Israel,EURO,1987,58413,16,481
2020-07-25,IL,Israel,EURO,1824,60237,8,489
2020-07-26,IL,Israel,EURO,1110,61347,7,496
2020-07-27,IL,Israel,EURO,1040,62387,11,507
2020-07-28,IL,Israel,EURO,2048,64435,7,514
2020-07-29,IL,Israel,EURO,2120,66555,8,522
2020-07-30,IL,Israel,EURO,1957,68512,15,537
2020-07-31,IL,Israel,EURO,1786,70298,15,552
2020-08-01,IL,Israel,EURO,1359,71657,14,566
2020-08-02,IL,Israel,EURO,623,72280,14,580
2020-08-03,IL,Israel,EURO,708,72988,12,592
2020-08-04,IL,Israel,EURO,1799,74787,15,607
2020-08-05,IL,Israel,EURO,1726,76513,11,618
2020-08-06,IL,Israel,EURO,1686,78199,10,628
2020-08-07,IL,Israel,EURO,1675,79874,9,637
2020-08-08,IL,Israel,EURO,1761,81635,12,649
2020-08-09,IL,Israel,EURO,755,82390,13,662
2020-08-10,IL,Israel,EURO,922,83312,8,670
2020-08-11,IL,Israel,EURO,1697,85009,15,685
2020-08-12,IL,Israel,EURO,1823,86832,11,696
2020-08-13,IL,Israel,EURO,1617,88449,16,712
2020-08-14,IL,Israel,EURO,1641,90090,16,728
2020-08-15,IL,Israel,EURO,1389,91479,12,740
2020-08-16,IL,Israel,EURO,754,92233,10,750
2020-08-17,IL,Israel,EURO,1069,93302,20,770
2020-08-18,IL,Israel,EURO,1649,94951,4,774
2020-08-19,IL,Israel,EURO,1647,96598,14,788
2020-08-20,IL,Israel,EURO,1639,98237,12,800
2020-08-21,IL,Israel,EURO,1485,99722,14,814
2020-08-22,IL,Israel,EURO,1491,101213,13,827
2020-08-23,IL,Israel,EURO,710,101923,10,837
2020-08-24,IL,Israel,EURO,964,102887,13,850
2020-08-25,IL,Israel,EURO,1901,104788,16,866
2020-08-26,IL,Israel,EURO,1958,106746,19,885
2020-08-27,IL,Israel,EURO,1984,108730,11,896
2020-08-28,IL,Israel,EURO,2106,110836,11,907
2020-08-29,IL,Israel,EURO,1833,112669,13,920
2020-08-30,IL,Israel,EURO,909,113578,5,925
2020-08-31,IL,Israel,EURO,1100,114678,14,939
2020-09-01,IL,Israel,EURO,2171,116849,23,962
2020-09-02,IL,Israel,EURO,2255,119104,15,977
2020-09-03,IL,Israel,EURO,3194,122298,13,990
2020-09-04,IL,Israel,EURO,2664,124962,16,1006
2020-09-05,IL,Israel,EURO,2623,127585,12,1018
2020-09-06,IL,Israel,EURO,1504,129089,15,1033
2020-09-07,IL,Israel,EURO,2175,131264,12,1045
2020-09-08,IL,Israel,EURO,3386,134650,17,1062
2020-09-09,IL,Israel,EURO,3488,138138,20,1082
2020-09-10,IL,Israel,EURO,3992,142130,15,1097
2020-09-11,IL,Israel,EURO,4154,146284,14,1111
2020-09-12,IL,Israel,EURO,3974,150258,20,1131
.
77929a
2022-02-05,IM,Isle of Man,EURO,51,21614,0,73
2022-02-06,IM,Isle of Man,EURO,50,21664,0,73
2022-02-07,IM,Isle of Man,EURO,28,21692,0,73
.
77165a
2022-02-05,IE,Ireland,EURO,6697,1205914,0,6228
2022-02-06,IE,Ireland,EURO,0,1205914,0,6228
2022-02-07,IE,Ireland,EURO,0,1205914,0,6228
.
76401a
2022-02-05,IQ,Iraq,EMRO,6569,2240294,21,24476
2022-02-06,IQ,Iraq,EMRO,4316,2244610,23,24499
2022-02-07,IQ,Iraq,EMRO,3589,2248199,17,24516
.
75637a
2022-02-05,IR,Iran (Islamic Republic of),EMRO,36908,6520707,57,132681
2022-02-06,IR,Iran (Islamic Republic of),EMRO,23130,6543837,64,132745
2022-02-07,IR,Iran (Islamic Republic of),EMRO,35429,6579266,85,132830
.
74873a
2022-02-05,ID,Indonesia,SEARO,0,4446694,44,144497
2022-02-06,ID,Indonesia,SEARO,69786,4516480,57,144554
2022-02-07,ID,Indonesia,SEARO,26121,4542601,82,144636
.
74109a
2022-02-05,IN,India,SEARO,127952,42080664,1059,501114
2022-02-06,IN,India,SEARO,107474,42188138,865,501979
2022-02-07,IN,India,SEARO,83876,42272014,895,502874
.
73340,73345c
2022-01-30,IS,Iceland,EURO,935,66576,0,46
2022-01-31,IS,Iceland,EURO,931,67507,0,46
2022-02-01,IS,Iceland,EURO,1347,68854,0,46
2022-02-02,IS,Iceland,EURO,1428,70282,1,47
2022-02-03,IS,Iceland,EURO,1500,71782,0,47
2022-02-04,IS,Iceland,EURO,1353,73135,2,49
2022-02-05,IS,Iceland,EURO,1615,74750,0,49
2022-02-06,IS,Iceland,EURO,1952,76702,0,49
2022-02-07,IS,Iceland,EURO,1499,78201,1,50
.
72581a
2022-02-05,HU,Hungary,EURO,0,1616846,0,41741
2022-02-06,HU,Hungary,EURO,0,1616846,0,41741
2022-02-07,HU,Hungary,EURO,33716,1650562,234,41975
.
71816,71817c
2022-02-03,HN,Honduras,AMRO,4675,396549,31,10535
2022-02-04,HN,Honduras,AMRO,999,397548,13,10548
2022-02-05,HN,Honduras,AMRO,0,397548,0,10548
2022-02-06,HN,Honduras,AMRO,0,397548,0,10548
2022-02-07,HN,Honduras,AMRO,0,397548,0,10548
.
71053a
2022-02-05,VA,Holy See,EURO,0,26,0,0
2022-02-06,VA,Holy See,EURO,0,26,0,0
2022-02-07,VA,Holy See,EURO,0,26,0,0
.
70289a
2022-02-05,HT,Haiti,AMRO,0,29549,0,804
2022-02-06,HT,Haiti,AMRO,0,29549,0,804
2022-02-07,HT,Haiti,AMRO,0,29549,0,804
.
69525a
2022-02-05,GY,Guyana,AMRO,291,60676,0,1176
2022-02-06,GY,Guyana,AMRO,432,61108,3,1179
2022-02-07,GY,Guyana,AMRO,296,61404,1,1180
.
68761c
2022-02-04,GW,Guinea-Bissau,AFRO,58,7749,2,158
2022-02-05,GW,Guinea-Bissau,AFRO,0,7749,0,158
2022-02-06,GW,Guinea-Bissau,AFRO,0,7749,0,158
2022-02-07,GW,Guinea-Bissau,AFRO,23,7772,0,158
.
67997c
2022-02-04,GN,Guinea,AFRO,40,36206,7,426
2022-02-05,GN,Guinea,AFRO,0,36206,0,426
2022-02-06,GN,Guinea,AFRO,56,36262,2,428
2022-02-07,GN,Guinea,AFRO,0,36262,0,428
.
67233a
2022-02-05,GG,Guernsey,EURO,96,11666,0,31
2022-02-06,GG,Guernsey,EURO,0,11666,0,31
2022-02-07,GG,Guernsey,EURO,0,11666,0,31
.
66469a
2022-02-05,GT,Guatemala,AMRO,7229,705614,49,16470
2022-02-06,GT,Guatemala,AMRO,0,705614,0,16470
2022-02-07,GT,Guatemala,AMRO,4296,709910,25,16495
.
65705a
2022-02-05,GU,Guam,WPRO,0,28237,0,296
2022-02-06,GU,Guam,WPRO,0,28237,0,296
2022-02-07,GU,Guam,WPRO,0,28237,0,296
.
64941a
2022-02-05,GP,Guadeloupe,AMRO,0,104179,0,855
2022-02-06,GP,Guadeloupe,AMRO,0,104179,0,855
2022-02-07,GP,Guadeloupe,AMRO,0,104179,0,855
.
64177a
2022-02-05,GD,Grenada,AMRO,76,12774,0,211
2022-02-06,GD,Grenada,AMRO,60,12834,0,211
2022-02-07,GD,Grenada,AMRO,28,12862,0,211
.
63413a
2022-02-05,GL,Greenland,EURO,52,11077,0,6
2022-02-06,GL,Greenland,EURO,0,11077,0,6
2022-02-07,GL,Greenland,EURO,0,11077,0,6
.
62649a
2022-02-05,GR,Greece,EURO,18640,2020846,94,23927
2022-02-06,GR,Greece,EURO,16023,2036869,72,23999
2022-02-07,GR,Greece,EURO,10980,2047849,95,24094
.
61883,61885c
2022-02-02,GI,Gibraltar,EURO,135,13085,0,101
2022-02-03,GI,Gibraltar,EURO,158,13243,0,101
2022-02-04,GI,Gibraltar,EURO,151,13394,0,101
2022-02-05,GI,Gibraltar,EURO,73,13467,0,101
2022-02-06,GI,Gibraltar,EURO,110,13577,0,101
2022-02-07,GI,Gibraltar,EURO,72,13649,0,101
.
61121c
2022-02-04,GH,Ghana,AFRO,300,157220,9,1404
2022-02-05,GH,Ghana,AFRO,0,157220,0,1404
2022-02-06,GH,Ghana,AFRO,321,157541,8,1412
2022-02-07,GH,Ghana,AFRO,0,157541,0,1412
.
60357a
2022-02-05,DE,Germany,EURO,217815,10889417,172,118676
2022-02-06,DE,Germany,EURO,133173,11022590,41,118717
2022-02-07,DE,Germany,EURO,95267,11117857,49,118766
.
59593a
2022-02-05,GE,Georgia,EURO,23134,1295505,33,15174
2022-02-06,GE,Georgia,EURO,19098,1314603,38,15212
2022-02-07,GE,Georgia,EURO,11235,1325838,34,15246
.
58829c
2022-02-04,GM,Gambia,AFRO,17,11880,0,364
2022-02-05,GM,Gambia,AFRO,0,11880,0,364
2022-02-06,GM,Gambia,AFRO,0,11880,0,364
2022-02-07,GM,Gambia,AFRO,0,11880,0,364
.
58065a
2022-02-05,GA,Gabon,AFRO,0,47148,0,301
2022-02-06,GA,Gabon,AFRO,0,47148,0,301
2022-02-07,GA,Gabon,AFRO,0,47148,0,301
.
57301a
2022-02-05,PF,French Polynesia,WPRO,0,49521,0,636
2022-02-06,PF,French Polynesia,WPRO,0,49521,0,636
2022-02-07,PF,French Polynesia,WPRO,0,49521,0,636
.
56537a
2022-02-05,GF,French Guiana,AMRO,110,76509,2,383
2022-02-06,GF,French Guiana,AMRO,0,76509,0,383
2022-02-07,GF,French Guiana,AMRO,0,76509,0,383
.
55773a
2022-02-05,FR,France,EURO,239755,19836091,353,129362
2022-02-06,FR,France,EURO,213366,20049457,170,129532
2022-02-07,FR,France,EURO,155489,20204946,129,129661
.
54611,55009c
2021-01-02,FI,Finland,EURO,158,36834,3,601
2021-01-03,FI,Finland,EURO,233,37067,4,605
2021-01-04,FI,Finland,EURO,204,37271,3,608
2021-01-05,FI,Finland,EURO,479,37750,7,615
2021-01-06,FI,Finland,EURO,277,38027,4,619
2021-01-07,FI,Finland,EURO,210,38237,3,622
2021-01-08,FI,Finland,EURO,339,38576,3,625
2021-01-09,FI,Finland,EURO,253,38829,4,629
2021-01-10,FI,Finland,EURO,196,39025,2,631
2021-01-11,FI,Finland,EURO,196,39221,3,634
2021-01-12,FI,Finland,EURO,388,39609,8,642
2021-01-13,FI,Finland,EURO,229,39838,9,651
2021-01-14,FI,Finland,EURO,259,40097,5,656
2021-01-15,FI,Finland,EURO,251,40348,5,661
2021-01-16,FI,Finland,EURO,267,40615,1,662
2021-01-17,FI,Finland,EURO,172,40787,1,663
2021-01-18,FI,Finland,EURO,201,40988,0,663
2021-01-19,FI,Finland,EURO,447,41435,1,664
2021-01-20,FI,Finland,EURO,344,41779,4,668
2021-01-21,FI,Finland,EURO,406,42185,12,680
2021-01-22,FI,Finland,EURO,379,42564,4,684
2021-01-23,FI,Finland,EURO,361,42925,2,686
2021-01-24,FI,Finland,EURO,168,43093,2,688
2021-01-25,FI,Finland,EURO,247,43340,2,690
2021-01-26,FI,Finland,EURO,605,43945,5,695
2021-01-27,FI,Finland,EURO,397,44342,3,698
2021-01-28,FI,Finland,EURO,382,44724,0,698
2021-01-29,FI,Finland,EURO,435,45159,1,699
2021-01-30,FI,Finland,EURO,379,45538,3,702
2021-01-31,FI,Finland,EURO,234,45772,1,703
2021-02-01,FI,Finland,EURO,282,46054,0,703
2021-02-02,FI,Finland,EURO,533,46587,6,709
2021-02-03,FI,Finland,EURO,396,46983,2,711
2021-02-04,FI,Finland,EURO,441,47424,3,714
2021-02-05,FI,Finland,EURO,373,47797,1,715
2021-02-06,FI,Finland,EURO,366,48163,2,717
2021-02-07,FI,Finland,EURO,237,48400,0,717
2021-02-08,FI,Finland,EURO,264,48664,2,719
2021-02-09,FI,Finland,EURO,461,49125,5,724
2021-02-10,FI,Finland,EURO,373,49498,0,724
2021-02-11,FI,Finland,EURO,382,49880,5,729
2021-02-12,FI,Finland,EURO,362,50242,2,731
2021-02-13,FI,Finland,EURO,417,50659,2,733
2021-02-14,FI,Finland,EURO,279,50938,4,737
2021-02-15,FI,Finland,EURO,281,51219,4,741
2021-02-16,FI,Finland,EURO,617,51836,1,742
2021-02-17,FI,Finland,EURO,514,52350,5,747
2021-02-18,FI,Finland,EURO,563,52913,2,749
2021-02-19,FI,Finland,EURO,614,53527,2,751
2021-02-20,FI,Finland,EURO,572,54099,3,754
2021-02-21,FI,Finland,EURO,318,54417,2,756
2021-02-22,FI,Finland,EURO,355,54772,1,757
2021-02-23,FI,Finland,EURO,623,55395,5,762
2021-02-24,FI,Finland,EURO,625,56020,9,771
2021-02-25,FI,Finland,EURO,600,56620,2,773
2021-02-26,FI,Finland,EURO,629,57249,7,780
2021-02-27,FI,Finland,EURO,689,57938,3,783
2021-02-28,FI,Finland,EURO,405,58343,1,784
2021-03-01,FI,Finland,EURO,422,58765,1,785
2021-03-02,FI,Finland,EURO,871,59636,7,792
2021-03-03,FI,Finland,EURO,756,60392,2,794
2021-03-04,FI,Finland,EURO,734,61126,1,795
2021-03-05,FI,Finland,EURO,638,61764,2,797
2021-03-06,FI,Finland,EURO,630,62394,3,800
2021-03-07,FI,Finland,EURO,432,62826,1,801
2021-03-08,FI,Finland,EURO,396,63222,2,803
2021-03-09,FI,Finland,EURO,834,64056,9,812
2021-03-10,FI,Finland,EURO,770,64826,4,816
2021-03-11,FI,Finland,EURO,822,65648,4,820
2021-03-12,FI,Finland,EURO,780,66428,4,824
2021-03-13,FI,Finland,EURO,808,67236,4,828
2021-03-14,FI,Finland,EURO,495,67731,4,832
2021-03-15,FI,Finland,EURO,435,68166,0,832
2021-03-16,FI,Finland,EURO,892,69058,1,833
2021-03-17,FI,Finland,EURO,767,69825,1,834
2021-03-18,FI,Finland,EURO,744,70569,3,837
2021-03-19,FI,Finland,EURO,739,71308,4,841
2021-03-20,FI,Finland,EURO,745,72053,7,848
2021-03-21,FI,Finland,EURO,404,72457,4,852
2021-03-22,FI,Finland,EURO,421,72878,0,852
2021-03-23,FI,Finland,EURO,768,73646,6,858
2021-03-24,FI,Finland,EURO,703,74349,5,863
2021-03-25,FI,Finland,EURO,695,75044,4,867
2021-03-26,FI,Finland,EURO,607,75651,2,869
2021-03-27,FI,Finland,EURO,689,76340,3,872
2021-03-28,FI,Finland,EURO,352,76692,4,876
2021-03-29,FI,Finland,EURO,375,77067,1,877
2021-03-30,FI,Finland,EURO,655,77722,3,880
2021-03-31,FI,Finland,EURO,572,78294,2,882
2021-04-01,FI,Finland,EURO,551,78845,1,883
2021-04-02,FI,Finland,EURO,487,79332,2,885
2021-04-03,FI,Finland,EURO,361,79693,2,887
2021-04-04,FI,Finland,EURO,324,80017,3,890
2021-04-05,FI,Finland,EURO,322,80339,1,891
2021-04-06,FI,Finland,EURO,360,80699,0,891
2021-04-07,FI,Finland,EURO,545,81244,1,892
2021-04-08,FI,Finland,EURO,425,81669,4,896
2021-04-09,FI,Finland,EURO,407,82076,1,897
2021-04-10,FI,Finland,EURO,352,82428,2,899
2021-04-11,FI,Finland,EURO,227,82655,2,901
2021-04-12,FI,Finland,EURO,240,82895,0,901
2021-04-13,FI,Finland,EURO,405,83300,1,902
2021-04-14,FI,Finland,EURO,323,83623,4,906
2021-04-15,FI,Finland,EURO,344,83967,1,907
2021-04-16,FI,Finland,EURO,274,84241,2,909
2021-04-17,FI,Finland,EURO,265,84506,5,914
2021-04-18,FI,Finland,EURO,172,84678,2,916
2021-04-19,FI,Finland,EURO,157,84835,0,916
2021-04-20,FI,Finland,EURO,286,85121,3,919
2021-04-21,FI,Finland,EURO,286,85407,1,920
2021-04-22,FI,Finland,EURO,233,85640,2,922
2021-04-23,FI,Finland,EURO,257,85897,0,922
2021-04-24,FI,Finland,EURO,255,86152,1,923
2021-04-25,FI,Finland,EURO,154,86306,1,924
2021-04-26,FI,Finland,EURO,140,86446,0,924
2021-04-27,FI,Finland,EURO,242,86688,3,927
2021-04-28,FI,Finland,EURO,229,86917,2,929
2021-04-29,FI,Finland,EURO,274,87191,2,931
2021-04-30,FI,Finland,EURO,201,87392,1,932
2021-05-01,FI,Finland,EURO,197,87589,2,934
2021-05-02,FI,Finland,EURO,109,87698,0,934
2021-05-03,FI,Finland,EURO,135,87833,2,936
2021-05-04,FI,Finland,EURO,316,88149,0,936
2021-05-05,FI,Finland,EURO,206,88355,0,936
2021-05-06,FI,Finland,EURO,265,88620,1,937
2021-05-07,FI,Finland,EURO,239,88859,2,939
2021-05-08,FI,Finland,EURO,214,89073,1,940
2021-05-09,FI,Finland,EURO,134,89207,0,940
2021-05-10,FI,Finland,EURO,130,89337,0,940
2021-05-11,FI,Finland,EURO,257,89594,1,941
2021-05-12,FI,Finland,EURO,215,89809,1,942
2021-05-13,FI,Finland,EURO,256,90065,2,944
2021-05-14,FI,Finland,EURO,157,90222,2,946
2021-05-15,FI,Finland,EURO,249,90471,5,951
2021-05-16,FI,Finland,EURO,164,90635,6,957
2021-05-17,FI,Finland,EURO,134,90769,2,959
2021-05-18,FI,Finland,EURO,284,91053,0,959
2021-05-19,FI,Finland,EURO,217,91270,3,962
2021-05-20,FI,Finland,EURO,231,91501,6,968
2021-05-21,FI,Finland,EURO,217,91718,0,968
2021-05-22,FI,Finland,EURO,169,91887,0,968
2021-05-23,FI,Finland,EURO,108,91995,2,970
2021-05-24,FI,Finland,EURO,93,92088,2,972
2021-05-25,FI,Finland,EURO,188,92276,0,972
2021-05-26,FI,Finland,EURO,153,92429,0,972
2021-05-27,FI,Finland,EURO,143,92572,1,973
2021-05-28,FI,Finland,EURO,127,92699,0,973
2021-05-29,FI,Finland,EURO,135,92834,0,973
2021-05-30,FI,Finland,EURO,64,92898,0,973
2021-05-31,FI,Finland,EURO,78,92976,2,975
2021-06-01,FI,Finland,EURO,151,93127,0,975
2021-06-02,FI,Finland,EURO,122,93249,1,976
2021-06-03,FI,Finland,EURO,119,93368,0,976
2021-06-04,FI,Finland,EURO,111,93479,0,976
2021-06-05,FI,Finland,EURO,102,93581,1,977
2021-06-06,FI,Finland,EURO,64,93645,0,977
2021-06-07,FI,Finland,EURO,60,93705,0,977
2021-06-08,FI,Finland,EURO,139,93844,1,978
2021-06-09,FI,Finland,EURO,101,93945,1,979
2021-06-10,FI,Finland,EURO,81,94026,0,979
2021-06-11,FI,Finland,EURO,73,94099,1,980
2021-06-12,FI,Finland,EURO,70,94169,0,980
2021-06-13,FI,Finland,EURO,46,94215,0,980
2021-06-14,FI,Finland,EURO,48,94263,0,980
2021-06-15,FI,Finland,EURO,93,94356,0,980
2021-06-16,FI,Finland,EURO,78,94434,2,982
2021-06-17,FI,Finland,EURO,64,94498,0,982
2021-06-18,FI,Finland,EURO,91,94589,0,982
2021-06-19,FI,Finland,EURO,81,94670,0,982
2021-06-20,FI,Finland,EURO,57,94727,0,982
2021-06-21,FI,Finland,EURO,80,94807,0,982
2021-06-22,FI,Finland,EURO,112,94919,1,983
2021-06-23,FI,Finland,EURO,109,95028,0,983
2021-06-24,FI,Finland,EURO,144,95172,1,984
2021-06-25,FI,Finland,EURO,162,95334,0,984
2021-06-26,FI,Finland,EURO,195,95529,0,984
2021-06-27,FI,Finland,EURO,131,95660,0,984
2021-06-28,FI,Finland,EURO,119,95779,0,984
2021-06-29,FI,Finland,EURO,230,96009,0,984
2021-06-30,FI,Finland,EURO,261,96270,0,984
2021-07-01,FI,Finland,EURO,196,96466,0,984
2021-07-02,FI,Finland,EURO,203,96669,0,984
2021-07-03,FI,Finland,EURO,167,96836,0,984
2021-07-04,FI,Finland,EURO,132,96968,0,984
2021-07-05,FI,Finland,EURO,108,97076,0,984
2021-07-06,FI,Finland,EURO,243,97319,1,985
2021-07-07,FI,Finland,EURO,261,97580,1,986
2021-07-08,FI,Finland,EURO,292,97872,0,986
2021-07-09,FI,Finland,EURO,284,98156,0,986
2021-07-10,FI,Finland,EURO,308,98464,0,986
2021-07-11,FI,Finland,EURO,149,98613,0,986
2021-07-12,FI,Finland,EURO,160,98773,2,988
2021-07-13,FI,Finland,EURO,330,99103,2,990
2021-07-14,FI,Finland,EURO,342,99445,1,991
2021-07-15,FI,Finland,EURO,381,99826,0,991
2021-07-16,FI,Finland,EURO,382,100208,0,991
2021-07-17,FI,Finland,EURO,355,100563,0,991
2021-07-18,FI,Finland,EURO,206,100769,0,991
2021-07-19,FI,Finland,EURO,249,101018,0,991
2021-07-20,FI,Finland,EURO,420,101438,0,991
2021-07-21,FI,Finland,EURO,424,101862,0,991
2021-07-22,FI,Finland,EURO,468,102330,2,993
2021-07-23,FI,Finland,EURO,487,102817,0,993
2021-07-24,FI,Finland,EURO,478,103295,2,995
2021-07-25,FI,Finland,EURO,301,103596,1,996
2021-07-26,FI,Finland,EURO,351,103947,1,997
2021-07-27,FI,Finland,EURO,771,104718,2,999
2021-07-28,FI,Finland,EURO,726,105444,1,1000
2021-07-29,FI,Finland,EURO,810,106254,1,1001
2021-07-30,FI,Finland,EURO,772,107026,4,1005
2021-07-31,FI,Finland,EURO,696,107722,0,1005
2021-08-01,FI,Finland,EURO,408,108130,1,1006
2021-08-02,FI,Finland,EURO,477,108607,0,1006
2021-08-03,FI,Finland,EURO,893,109500,3,1009
2021-08-04,FI,Finland,EURO,840,110340,3,1012
2021-08-05,FI,Finland,EURO,784,111124,4,1016
2021-08-06,FI,Finland,EURO,876,112000,1,1017
2021-08-07,FI,Finland,EURO,685,112685,2,1019
2021-08-08,FI,Finland,EURO,486,113171,4,1023
2021-08-09,FI,Finland,EURO,537,113708,0,1023
2021-08-10,FI,Finland,EURO,1037,114745,1,1024
2021-08-11,FI,Finland,EURO,826,115571,1,1025
2021-08-12,FI,Finland,EURO,923,116494,1,1026
2021-08-13,FI,Finland,EURO,789,117283,1,1027
2021-08-14,FI,Finland,EURO,740,118023,2,1029
2021-08-15,FI,Finland,EURO,426,118449,0,1029
2021-08-16,FI,Finland,EURO,445,118894,2,1031
2021-08-17,FI,Finland,EURO,768,119662,0,1031
2021-08-18,FI,Finland,EURO,741,120403,1,1032
2021-08-19,FI,Finland,EURO,708,121111,3,1035
2021-08-20,FI,Finland,EURO,670,121781,2,1037
2021-08-21,FI,Finland,EURO,655,122436,1,1038
2021-08-22,FI,Finland,EURO,397,122833,0,1038
2021-08-23,FI,Finland,EURO,457,123290,2,1040
2021-08-24,FI,Finland,EURO,682,123972,1,1041
2021-08-25,FI,Finland,EURO,608,124580,3,1044
2021-08-26,FI,Finland,EURO,699,125279,2,1046
2021-08-27,FI,Finland,EURO,610,125889,2,1048
2021-08-28,FI,Finland,EURO,704,126593,2,1050
2021-08-29,FI,Finland,EURO,439,127032,0,1050
2021-08-30,FI,Finland,EURO,464,127496,1,1051
2021-08-31,FI,Finland,EURO,744,128240,6,1057
2021-09-01,FI,Finland,EURO,651,128891,2,1059
2021-09-02,FI,Finland,EURO,648,129539,1,1060
2021-09-03,FI,Finland,EURO,650,130189,2,1062
2021-09-04,FI,Finland,EURO,520,130709,1,1063
2021-09-05,FI,Finland,EURO,336,131045,0,1063
2021-09-06,FI,Finland,EURO,346,131391,0,1063
2021-09-07,FI,Finland,EURO,581,131972,6,1069
2021-09-08,FI,Finland,EURO,522,132494,3,1072
2021-09-09,FI,Finland,EURO,482,132976,1,1073
2021-09-10,FI,Finland,EURO,461,133437,2,1075
2021-09-11,FI,Finland,EURO,496,133933,0,1075
2021-09-12,FI,Finland,EURO,331,134264,1,1076
2021-09-13,FI,Finland,EURO,283,134547,5,1081
2021-09-14,FI,Finland,EURO,534,135081,1,1082
2021-09-15,FI,Finland,EURO,480,135561,2,1084
2021-09-16,FI,Finland,EURO,454,136015,1,1085
2021-09-17,FI,Finland,EURO,437,136452,1,1086
2021-09-18,FI,Finland,EURO,389,136841,1,1087
2021-09-19,FI,Finland,EURO,240,137081,0,1087
2021-09-20,FI,Finland,EURO,285,137366,5,1092
2021-09-21,FI,Finland,EURO,489,137855,1,1093
2021-09-22,FI,Finland,EURO,489,138344,1,1094
2021-09-23,FI,Finland,EURO,483,138827,2,1096
2021-09-24,FI,Finland,EURO,481,139308,4,1100
2021-09-25,FI,Finland,EURO,425,139733,3,1103
2021-09-26,FI,Finland,EURO,299,140032,1,1104
2021-09-27,FI,Finland,EURO,355,140387,3,1107
2021-09-28,FI,Finland,EURO,684,141071,3,1110
2021-09-29,FI,Finland,EURO,645,141716,4,1114
2021-09-30,FI,Finland,EURO,669,142385,4,1118
2021-10-01,FI,Finland,EURO,619,143004,3,1121
2021-10-02,FI,Finland,EURO,532,143536,5,1126
2021-10-03,FI,Finland,EURO,356,143892,3,1129
2021-10-04,FI,Finland,EURO,383,144275,5,1134
2021-10-05,FI,Finland,EURO,746,145021,4,1138
2021-10-06,FI,Finland,EURO,726,145747,7,1145
2021-10-07,FI,Finland,EURO,747,146494,2,1147
2021-10-08,FI,Finland,EURO,611,147105,3,1150
2021-10-09,FI,Finland,EURO,596,147701,8,1158
2021-10-10,FI,Finland,EURO,425,148126,5,1163
2021-10-11,FI,Finland,EURO,399,148525,3,1166
2021-10-12,FI,Finland,EURO,691,149216,5,1171
2021-10-13,FI,Finland,EURO,610,149826,3,1174
2021-10-14,FI,Finland,EURO,639,150465,3,1177
2021-10-15,FI,Finland,EURO,559,151024,4,1181
2021-10-16,FI,Finland,EURO,563,151587,2,1183
2021-10-17,FI,Finland,EURO,344,151931,1,1184
2021-10-18,FI,Finland,EURO,319,152250,4,1188
2021-10-19,FI,Finland,EURO,661,152911,6,1194
2021-10-20,FI,Finland,EURO,550,153461,1,1195
2021-10-21,FI,Finland,EURO,516,153977,2,1197
2021-10-22,FI,Finland,EURO,623,154600,2,1199
2021-10-23,FI,Finland,EURO,580,155180,8,1207
2021-10-24,FI,Finland,EURO,376,155556,4,1211
2021-10-25,FI,Finland,EURO,392,155948,2,1213
2021-10-26,FI,Finland,EURO,798,156746,13,1226
2021-10-27,FI,Finland,EURO,681,157427,4,1230
2021-10-28,FI,Finland,EURO,640,158067,5,1235
2021-10-29,FI,Finland,EURO,592,158659,5,1240
2021-10-30,FI,Finland,EURO,655,159314,2,1242
2021-10-31,FI,Finland,EURO,405,159719,3,1245
2021-11-01,FI,Finland,EURO,439,160158,5,1250
2021-11-02,FI,Finland,EURO,973,161131,12,1262
2021-11-03,FI,Finland,EURO,754,161885,3,1265
2021-11-04,FI,Finland,EURO,771,162656,7,1272
2021-11-05,FI,Finland,EURO,802,163458,9,1281
2021-11-06,FI,Finland,EURO,842,164300,11,1292
2021-11-07,FI,Finland,EURO,514,164814,9,1301
2021-11-08,FI,Finland,EURO,506,165320,4,1305
2021-11-09,FI,Finland,EURO,1123,166443,12,1317
2021-11-10,FI,Finland,EURO,836,167279,9,1326
2021-11-11,FI,Finland,EURO,971,168250,4,1330
2021-11-12,FI,Finland,EURO,934,169184,6,1336
2021-11-13,FI,Finland,EURO,946,170130,5,1341
2021-11-14,FI,Finland,EURO,618,170748,3,1344
2021-11-15,FI,Finland,EURO,570,171318,6,1350
2021-11-16,FI,Finland,EURO,1252,172570,17,1367
2021-11-17,FI,Finland,EURO,1200,173770,9,1376
2021-11-18,FI,Finland,EURO,1172,174942,5,1381
2021-11-19,FI,Finland,EURO,1215,176157,4,1385
2021-11-20,FI,Finland,EURO,1275,177432,6,1391
2021-11-21,FI,Finland,EURO,708,178140,8,1399
2021-11-22,FI,Finland,EURO,675,178815,5,1404
2021-11-23,FI,Finland,EURO,1423,180238,10,1414
2021-11-24,FI,Finland,EURO,1338,181576,10,1424
2021-11-25,FI,Finland,EURO,1256,182832,10,1434
2021-11-26,FI,Finland,EURO,1276,184108,11,1445
2021-11-27,FI,Finland,EURO,1301,185409,8,1453
2021-11-28,FI,Finland,EURO,793,186202,8,1461
2021-11-29,FI,Finland,EURO,791,186993,3,1464
2021-11-30,FI,Finland,EURO,1702,188695,15,1479
2021-12-01,FI,Finland,EURO,1427,190122,7,1486
2021-12-02,FI,Finland,EURO,1443,191565,12,1498
2021-12-03,FI,Finland,EURO,1468,193033,5,1503
2021-12-04,FI,Finland,EURO,1529,194562,6,1509
2021-12-05,FI,Finland,EURO,972,195534,7,1516
2021-12-06,FI,Finland,EURO,1003,196537,5,1521
2021-12-07,FI,Finland,EURO,1078,197615,3,1524
2021-12-08,FI,Finland,EURO,1925,199540,7,1531
2021-12-09,FI,Finland,EURO,1734,201274,9,1540
2021-12-10,FI,Finland,EURO,1711,202985,7,1547
2021-12-11,FI,Finland,EURO,1801,204786,6,1553
2021-12-12,FI,Finland,EURO,1124,205910,7,1560
2021-12-13,FI,Finland,EURO,1270,207180,5,1565
2021-12-14,FI,Finland,EURO,2356,209536,7,1572
2021-12-15,FI,Finland,EURO,1833,211369,6,1578
2021-12-16,FI,Finland,EURO,2099,213468,8,1586
2021-12-17,FI,Finland,EURO,1989,215457,8,1594
2021-12-18,FI,Finland,EURO,2174,217631,8,1602
2021-12-19,FI,Finland,EURO,1614,219245,2,1604
2021-12-20,FI,Finland,EURO,1753,220998,5,1609
2021-12-21,FI,Finland,EURO,3041,224039,8,1617
2021-12-22,FI,Finland,EURO,3169,227208,7,1624
2021-12-23,FI,Finland,EURO,3538,230746,8,1632
2021-12-24,FI,Finland,EURO,3902,234648,10,1642
2021-12-25,FI,Finland,EURO,2274,236922,6,1648
2021-12-26,FI,Finland,EURO,2674,239596,5,1653
2021-12-27,FI,Finland,EURO,3309,242905,9,1662
2021-12-28,FI,Finland,EURO,6666,249571,17,1679
2021-12-29,FI,Finland,EURO,6872,256443,12,1691
2021-12-30,FI,Finland,EURO,7392,263835,14,1705
2021-12-31,FI,Finland,EURO,7331,271166,20,1725
2022-01-01,FI,Finland,EURO,6876,278042,20,1745
2022-01-02,FI,Finland,EURO,3994,282036,11,1756
2022-01-03,FI,Finland,EURO,4985,287021,13,1769
2022-01-04,FI,Finland,EURO,9525,296546,17,1786
2022-01-05,FI,Finland,EURO,9984,306530,20,1806
2022-01-06,FI,Finland,EURO,9727,316257,20,1826
2022-01-07,FI,Finland,EURO,7328,323585,15,1841
2022-01-08,FI,Finland,EURO,9028,332613,19,1860
2022-01-09,FI,Finland,EURO,5804,338417,18,1878
2022-01-10,FI,Finland,EURO,6643,345060,12,1890
2022-01-11,FI,Finland,EURO,10547,355607,19,1909
2022-01-12,FI,Finland,EURO,9206,364813,13,1922
2022-01-13,FI,Finland,EURO,8932,373745,15,1937
2022-01-14,FI,Finland,EURO,8272,382017,16,1953
2022-01-15,FI,Finland,EURO,8094,390111,14,1967
2022-01-16,FI,Finland,EURO,5707,395818,14,1981
2022-01-17,FI,Finland,EURO,6248,402066,13,1994
2022-01-18,FI,Finland,EURO,10135,412201,18,2012
2022-01-19,FI,Finland,EURO,9173,421374,7,2019
2022-01-20,FI,Finland,EURO,8531,429905,7,2026
2022-01-21,FI,Finland,EURO,8062,437967,12,2038
2022-01-22,FI,Finland,EURO,7399,445366,10,2048
2022-01-23,FI,Finland,EURO,4432,449798,9,2057
2022-01-24,FI,Finland,EURO,5054,454852,2,2059
2022-01-25,FI,Finland,EURO,9424,464276,10,2069
2022-01-26,FI,Finland,EURO,7900,472176,3,2072
2022-01-27,FI,Finland,EURO,6484,478660,5,2077
2022-01-28,FI,Finland,EURO,6544,485204,3,2080
2022-01-29,FI,Finland,EURO,6045,491249,8,2088
2022-01-30,FI,Finland,EURO,3932,495181,2,2090
2022-01-31,FI,Finland,EURO,4139,499320,1,2091
2022-02-01,FI,Finland,EURO,8141,507461,1,2092
2022-02-02,FI,Finland,EURO,6854,514315,1,2093
2022-02-03,FI,Finland,EURO,6441,520756,1,2094
2022-02-04,FI,Finland,EURO,5674,526430,1,2095
2022-02-05,FI,Finland,EURO,4191,530621,0,2095
2022-02-06,FI,Finland,EURO,2405,533026,0,2095
2022-02-07,FI,Finland,EURO,1763,534789,0,2095
.
54596,54603c
2020-12-18,FI,Finland,EURO,324,32941,1,548
2020-12-19,FI,Finland,EURO,394,33335,5,553
2020-12-20,FI,Finland,EURO,191,33526,3,556
2020-12-21,FI,Finland,EURO,244,33770,4,560
2020-12-22,FI,Finland,EURO,375,34145,4,564
2020-12-23,FI,Finland,EURO,332,34477,5,569
2020-12-24,FI,Finland,EURO,277,34754,3,572
2020-12-25,FI,Finland,EURO,139,34893,3,575
.
54245c
2022-02-04,FJ,Fiji,WPRO,59,63206,0,809
2022-02-05,FJ,Fiji,WPRO,68,63274,2,811
2022-02-06,FJ,Fiji,WPRO,0,63274,0,811
2022-02-07,FJ,Fiji,WPRO,0,63274,0,811
.
53481a
2022-02-05,FO,Faroe Islands,EURO,608,22908,1,20
2022-02-06,FO,Faroe Islands,EURO,677,23585,0,20
2022-02-07,FO,Faroe Islands,EURO,421,24006,0,20
.
52717a
2022-02-05,FK,Falkland Islands (Malvinas),AMRO,0,91,0,0
2022-02-06,FK,Falkland Islands (Malvinas),AMRO,0,91,0,0
2022-02-07,FK,Falkland Islands (Malvinas),AMRO,0,91,0,0
.
51953c
2022-02-04,ET,Ethiopia,AFRO,334,466126,7,7353
2022-02-05,ET,Ethiopia,AFRO,163,466289,2,7355
2022-02-06,ET,Ethiopia,AFRO,166,466455,1,7356
2022-02-07,ET,Ethiopia,AFRO,84,466539,7,7363
.
51189c
2022-02-04,SZ,Eswatini,AFRO,51,68505,0,1376
2022-02-05,SZ,Eswatini,AFRO,35,68540,1,1377
2022-02-06,SZ,Eswatini,AFRO,11,68551,0,1377
2022-02-07,SZ,Eswatini,AFRO,2,68553,1,1378
.
50425a
2022-02-05,EE,Estonia,EURO,7811,373900,3,2056
2022-02-06,EE,Estonia,EURO,7046,380946,3,2059
2022-02-07,EE,Estonia,EURO,4621,385567,6,2065
.
49661c
2022-02-04,ER,Eritrea,AFRO,21,9601,0,99
2022-02-05,ER,Eritrea,AFRO,18,9619,1,100
2022-02-06,ER,Eritrea,AFRO,12,9631,0,100
2022-02-07,ER,Eritrea,AFRO,6,9637,0,100
.
48897a
2022-02-05,GQ,Equatorial Guinea,AFRO,0,15828,0,182
2022-02-06,GQ,Equatorial Guinea,AFRO,17,15845,0,182
2022-02-07,GQ,Equatorial Guinea,AFRO,0,15845,0,182
.
48133a
2022-02-05,SV,El Salvador,AMRO,0,135109,6,3927
2022-02-06,SV,El Salvador,AMRO,0,135109,6,3933
2022-02-07,SV,El Salvador,AMRO,0,135109,9,3942
.
47369c
2022-02-04,EG,Egypt,EMRO,2281,432761,45,22780
2022-02-05,EG,Egypt,EMRO,2291,435052,39,22819
2022-02-06,EG,Egypt,EMRO,2298,437350,58,22877
2022-02-07,EG,Egypt,EMRO,2301,439651,59,22936
.
46605a
2022-02-05,EC,Ecuador,AMRO,0,739297,0,34572
2022-02-06,EC,Ecuador,AMRO,0,739297,0,34572
2022-02-07,EC,Ecuador,AMRO,27101,766398,158,34730
.
45841a
2022-02-05,DO,Dominican Republic,AMRO,0,558936,0,4315
2022-02-06,DO,Dominican Republic,AMRO,0,558936,0,4315
2022-02-07,DO,Dominican Republic,AMRO,2721,561657,7,4322
.
45077a
2022-02-05,DM,Dominica,AMRO,0,9032,0,51
2022-02-06,DM,Dominica,AMRO,968,10000,0,51
2022-02-07,DM,Dominica,AMRO,0,10000,0,51
.
44313c
2022-02-04,DJ,Djibouti,EMRO,17,15492,0,189
2022-02-05,DJ,Djibouti,EMRO,15,15507,0,189
2022-02-06,DJ,Djibouti,EMRO,3,15510,0,189
2022-02-07,DJ,Djibouti,EMRO,0,15510,0,189
.
43549a
2022-02-05,DK,Denmark,EURO,40179,1927340,17,3828
2022-02-06,DK,Denmark,EURO,39190,1966530,35,3863
2022-02-07,DK,Denmark,EURO,36512,2003042,18,3881
.
42785c
2022-02-04,CD,Democratic Republic of the Congo,AFRO,90,85600,0,1278
2022-02-05,CD,Democratic Republic of the Congo,AFRO,1,85601,0,1278
2022-02-06,CD,Democratic Republic of the Congo,AFRO,0,85601,0,1278
2022-02-07,CD,Democratic Republic of the Congo,AFRO,85,85686,38,1316
.
42021a
2022-02-05,KP,Democratic People's Republic of Korea,SEARO,0,0,0,0
2022-02-06,KP,Democratic People's Republic of Korea,SEARO,0,0,0,0
2022-02-07,KP,Democratic People's Republic of Korea,SEARO,0,0,0,0
.
41257a
2022-02-05,CZ,Czechia,EURO,28779,3210488,47,37410
2022-02-06,CZ,Czechia,EURO,24083,3234571,39,37449
2022-02-07,CZ,Czechia,EURO,9127,3243698,29,37478
.
40493c
2022-02-04,CY,Cyprus,EURO,3078,265945,2,738
2022-02-05,CY,Cyprus,EURO,2907,268852,2,740
2022-02-06,CY,Cyprus,EURO,539,269391,1,741
2022-02-07,CY,Cyprus,EURO,2214,271605,4,745
.
39729a
2022-02-05,CW,Curaçao,AMRO,100,37526,5,242
2022-02-06,CW,Curaçao,AMRO,0,37526,0,242
2022-02-07,CW,Curaçao,AMRO,0,37526,0,242
.
38965a
2022-02-05,CU,Cuba,AMRO,1434,1050840,-21,8399
2022-02-06,CU,Cuba,AMRO,1380,1052220,32,8431
2022-02-07,CU,Cuba,AMRO,1340,1053560,8,8439
.
38201a
2022-02-05,HR,Croatia,EURO,8094,971464,46,14035
2022-02-06,HR,Croatia,EURO,7536,979000,43,14078
2022-02-07,HR,Croatia,EURO,4780,983780,59,14137
.
37437c
2022-02-04,CI,Côte d’Ivoire,AFRO,38,80821,1,786
2022-02-05,CI,Côte d’Ivoire,AFRO,0,80821,0,786
2022-02-06,CI,Côte d’Ivoire,AFRO,80,80901,0,786
2022-02-07,CI,Côte d’Ivoire,AFRO,19,80920,0,786
.
36673a
2022-02-05,CR,Costa Rica,AMRO,7189,715749,16,7621
2022-02-06,CR,Costa Rica,AMRO,6222,721971,20,7641
2022-02-07,CR,Costa Rica,AMRO,0,721971,0,7641
.
35909a
2022-02-05,CK,Cook Islands,WPRO,0,0,0,0
2022-02-06,CK,Cook Islands,WPRO,0,0,0,0
2022-02-07,CK,Cook Islands,WPRO,0,0,0,0
.
35145c
2022-02-04,CG,Congo,AFRO,25,23730,4,375
2022-02-05,CG,Congo,AFRO,0,23730,0,375
2022-02-06,CG,Congo,AFRO,0,23730,0,375
2022-02-07,CG,Congo,AFRO,62,23792,0,375
.
34381c
2022-02-04,KM,Comoros,AFRO,12,7844,0,160
2022-02-05,KM,Comoros,AFRO,0,7844,0,160
2022-02-06,KM,Comoros,AFRO,84,7928,0,160
2022-02-07,KM,Comoros,AFRO,36,7964,0,160
.
33617a
2022-02-05,CO,Colombia,AMRO,13568,5930393,262,135043
2022-02-06,CO,Colombia,AMRO,13390,5943783,239,135282
2022-02-07,CO,Colombia,AMRO,12567,5956350,236,135518
.
32853a
2022-02-05,CN,China,WPRO,229,140120,0,5700
2022-02-06,CN,China,WPRO,466,140586,0,5700
2022-02-07,CN,China,WPRO,464,141050,0,5700
.
32089a
2022-02-05,CL,Chile,AMRO,38707,2296712,43,39867
2022-02-06,CL,Chile,AMRO,38322,2335034,63,39930
2022-02-07,CL,Chile,AMRO,36799,2371833,57,39987
.
31325c
2022-02-04,TD,Chad,AFRO,-2,7155,0,190
2022-02-05,TD,Chad,AFRO,2,7157,0,190
2022-02-06,TD,Chad,AFRO,0,7157,0,190
2022-02-07,TD,Chad,AFRO,0,7157,0,190
.
30561a
2022-02-05,CF,Central African Republic,AFRO,0,14023,0,110
2022-02-06,CF,Central African Republic,AFRO,0,14023,0,110
2022-02-07,CF,Central African Republic,AFRO,0,14023,0,110
.
29797a
2022-02-05,KY,Cayman Islands,AMRO,0,15934,0,16
2022-02-06,KY,Cayman Islands,AMRO,0,15934,0,16
2022-02-07,KY,Cayman Islands,AMRO,0,15934,0,16
.
29033a
2022-02-05,CA,Canada,AMRO,14217,3096217,169,34381
2022-02-06,CA,Canada,AMRO,0,3096217,0,34381
2022-02-07,CA,Canada,AMRO,0,3096217,0,34381
.
28269c
2022-02-04,CM,Cameroon,AFRO,958,117676,27,1907
2022-02-05,CM,Cameroon,AFRO,0,117676,0,1907
2022-02-06,CM,Cameroon,AFRO,0,117676,0,1907
2022-02-07,CM,Cameroon,AFRO,0,117676,0,1907
.
27505a
2022-02-05,KH,Cambodia,WPRO,66,121550,0,3015
2022-02-06,KH,Cambodia,WPRO,112,121662,0,3015
2022-02-07,KH,Cambodia,WPRO,111,121773,0,3015
.
26741c
2022-02-04,CV,Cabo Verde,AFRO,15,55754,0,396
2022-02-05,CV,Cabo Verde,AFRO,0,55754,0,396
2022-02-06,CV,Cabo Verde,AFRO,18,55772,0,396
2022-02-07,CV,Cabo Verde,AFRO,0,55772,0,396
.
25977c
2022-02-04,BI,Burundi,AFRO,56,37618,0,15
2022-02-05,BI,Burundi,AFRO,0,37618,0,15
2022-02-06,BI,Burundi,AFRO,0,37618,0,15
2022-02-07,BI,Burundi,AFRO,124,37742,0,15
.
25213c
2022-02-04,BF,Burkina Faso,AFRO,24,20673,1,372
2022-02-05,BF,Burkina Faso,AFRO,0,20673,0,372
2022-02-06,BF,Burkina Faso,AFRO,6,20679,0,372
2022-02-07,BF,Burkina Faso,AFRO,0,20679,0,372
.
24449a
2022-02-05,BG,Bulgaria,EURO,8116,988518,100,33688
2022-02-06,BG,Bulgaria,EURO,4737,993255,40,33728
2022-02-07,BG,Bulgaria,EURO,2181,995436,42,33770
.
23685a
2022-02-05,BN,Brunei Darussalam,WPRO,140,17031,0,59
2022-02-06,BN,Brunei Darussalam,WPRO,373,17404,0,59
2022-02-07,BN,Brunei Darussalam,WPRO,380,17784,0,59
.
22921a
2022-02-05,VG,British Virgin Islands,AMRO,0,5928,0,51
2022-02-06,VG,British Virgin Islands,AMRO,0,5928,0,51
2022-02-07,VG,British Virgin Islands,AMRO,0,5928,0,51
.
22157a
2022-02-05,BR,Brazil,AMRO,298408,26091520,1041,630001
2022-02-06,BR,Brazil,AMRO,184311,26275831,493,630494
2022-02-07,BR,Brazil,AMRO,197442,26473273,1308,631802
.
21393c
2022-02-04,BW,Botswana,AFRO,3005,256041,4,2585
2022-02-05,BW,Botswana,AFRO,0,256041,0,2585
2022-02-06,BW,Botswana,AFRO,0,256041,0,2585
2022-02-07,BW,Botswana,AFRO,0,256041,0,2585
.
20629a
2022-02-05,BA,Bosnia and Herzegovina,EURO,1188,354325,69,14672
2022-02-06,BA,Bosnia and Herzegovina,EURO,1594,355919,25,14697
2022-02-07,BA,Bosnia and Herzegovina,EURO,436,356355,25,14722
.
19865a
2022-02-05,XA,Bonaire,AMRO,11,6556,0,28
2022-02-06,XA,Bonaire,AMRO,0,6556,0,28
2022-02-07,XA,Bonaire,AMRO,0,6556,0,28
.
19101a
2022-02-05,BO,Bolivia (Plurinational State of),AMRO,3396,867071,28,21073
2022-02-06,BO,Bolivia (Plurinational State of),AMRO,2821,869892,29,21102
2022-02-07,BO,Bolivia (Plurinational State of),AMRO,1857,871749,27,21129
.
18337a
2022-02-05,BT,Bhutan,SEARO,214,5934,0,4
2022-02-06,BT,Bhutan,SEARO,158,6092,0,4
2022-02-07,BT,Bhutan,SEARO,208,6300,0,4
.
17573a
2022-02-05,BM,Bermuda,AMRO,42,10921,1,118
2022-02-06,BM,Bermuda,AMRO,0,10921,0,118
2022-02-07,BM,Bermuda,AMRO,0,10921,0,118
.
16809a
2022-02-05,BJ,Benin,AFRO,0,26498,0,163
2022-02-06,BJ,Benin,AFRO,0,26498,0,163
2022-02-07,BJ,Benin,AFRO,0,26498,0,163
.
16045a
2022-02-05,BZ,Belize,AMRO,423,53198,0,629
2022-02-06,BZ,Belize,AMRO,346,53544,0,629
2022-02-07,BZ,Belize,AMRO,0,53544,0,629
.
15183,15281c
2021-10-29,BE,Belgium,EURO,9193,1359378,18,26098
2021-10-30,BE,Belgium,EURO,9289,1368667,21,26119
2021-10-31,BE,Belgium,EURO,4969,1373636,16,26135
2021-11-01,BE,Belgium,EURO,3058,1376694,18,26153
2021-11-02,BE,Belgium,EURO,3581,1380275,25,26178
2021-11-03,BE,Belgium,EURO,11714,1391989,20,26198
2021-11-04,BE,Belgium,EURO,10706,1402695,17,26215
2021-11-05,BE,Belgium,EURO,10180,1412875,26,26241
2021-11-06,BE,Belgium,EURO,11139,1424014,25,26266
2021-11-07,BE,Belgium,EURO,6453,1430467,30,26296
2021-11-08,BE,Belgium,EURO,4071,1434538,15,26311
2021-11-09,BE,Belgium,EURO,15267,1449805,28,26339
2021-11-10,BE,Belgium,EURO,13017,1462822,27,26366
2021-11-11,BE,Belgium,EURO,12749,1475571,26,26392
2021-11-12,BE,Belgium,EURO,5054,1480625,32,26424
2021-11-13,BE,Belgium,EURO,13751,1494376,39,26463
2021-11-14,BE,Belgium,EURO,8360,1502736,20,26483
2021-11-15,BE,Belgium,EURO,5506,1508242,27,26510
2021-11-16,BE,Belgium,EURO,20836,1529078,46,26556
2021-11-17,BE,Belgium,EURO,18430,1547508,29,26585
2021-11-18,BE,Belgium,EURO,18144,1565652,42,26627
2021-11-19,BE,Belgium,EURO,18571,1584223,43,26670
2021-11-20,BE,Belgium,EURO,19147,1603370,33,26703
2021-11-21,BE,Belgium,EURO,11214,1614584,36,26739
2021-11-22,BE,Belgium,EURO,6754,1621338,36,26775
2021-11-23,BE,Belgium,EURO,25622,1646960,35,26810
2021-11-24,BE,Belgium,EURO,21135,1668095,38,26848
2021-11-25,BE,Belgium,EURO,20170,1688265,49,26897
2021-11-26,BE,Belgium,EURO,20228,1708493,44,26941
2021-11-27,BE,Belgium,EURO,20041,1728534,40,26981
2021-11-28,BE,Belgium,EURO,11588,1740122,48,27029
2021-11-29,BE,Belgium,EURO,7071,1747193,47,27076
2021-11-30,BE,Belgium,EURO,25203,1772396,45,27121
2021-12-01,BE,Belgium,EURO,20867,1793263,61,27182
2021-12-02,BE,Belgium,EURO,19664,1812927,43,27225
2021-12-03,BE,Belgium,EURO,18325,1831252,53,27278
2021-12-04,BE,Belgium,EURO,17764,1849016,48,27326
2021-12-05,BE,Belgium,EURO,9634,1858650,45,27371
2021-12-06,BE,Belgium,EURO,5974,1864624,57,27428
2021-12-07,BE,Belgium,EURO,20735,1885359,39,27467
2021-12-08,BE,Belgium,EURO,15660,1901019,49,27516
2021-12-09,BE,Belgium,EURO,15012,1916031,55,27571
2021-12-10,BE,Belgium,EURO,13435,1929466,35,27606
2021-12-11,BE,Belgium,EURO,13101,1942567,48,27654
2021-12-12,BE,Belgium,EURO,7115,1949682,45,27699
2021-12-13,BE,Belgium,EURO,3908,1953590,44,27743
2021-12-14,BE,Belgium,EURO,13883,1967473,43,27786
2021-12-15,BE,Belgium,EURO,10582,1978055,37,27823
2021-12-16,BE,Belgium,EURO,9279,1987334,41,27864
2021-12-17,BE,Belgium,EURO,8110,1995444,37,27901
2021-12-18,BE,Belgium,EURO,7741,2003185,26,27927
2021-12-19,BE,Belgium,EURO,4754,2007939,36,27963
2021-12-20,BE,Belgium,EURO,2850,2010789,38,28001
2021-12-21,BE,Belgium,EURO,9108,2019897,36,28037
2021-12-22,BE,Belgium,EURO,7372,2027269,36,28073
2021-12-23,BE,Belgium,EURO,7387,2034656,37,28110
2021-12-24,BE,Belgium,EURO,7522,2042178,36,28146
2021-12-25,BE,Belgium,EURO,6517,2048695,35,28181
2021-12-26,BE,Belgium,EURO,2817,2051512,20,28201
2021-12-27,BE,Belgium,EURO,4564,2056076,22,28223
2021-12-28,BE,Belgium,EURO,13289,2069365,28,28251
2021-12-29,BE,Belgium,EURO,12813,2082178,21,28272
2021-12-30,BE,Belgium,EURO,15038,2097216,34,28306
2021-12-31,BE,Belgium,EURO,16054,2113270,29,28335
2022-01-01,BE,Belgium,EURO,12281,2125551,16,28351
2022-01-02,BE,Belgium,EURO,4069,2129620,22,28373
2022-01-03,BE,Belgium,EURO,9082,2138702,15,28388
2022-01-04,BE,Belgium,EURO,27566,2166268,25,28413
2022-01-05,BE,Belgium,EURO,28108,2194376,17,28430
2022-01-06,BE,Belgium,EURO,26039,2220415,14,28444
2022-01-07,BE,Belgium,EURO,23627,2244042,19,28463
2022-01-08,BE,Belgium,EURO,23792,2267834,19,28482
2022-01-09,BE,Belgium,EURO,15339,2283173,17,28499
2022-01-10,BE,Belgium,EURO,11217,2294390,23,28522
2022-01-11,BE,Belgium,EURO,37735,2332125,25,28547
2022-01-12,BE,Belgium,EURO,31682,2363807,24,28571
2022-01-13,BE,Belgium,EURO,31130,2394937,23,28594
2022-01-14,BE,Belgium,EURO,30089,2425026,21,28615
2022-01-15,BE,Belgium,EURO,31773,2456799,17,28632
2022-01-16,BE,Belgium,EURO,21164,2477963,14,28646
2022-01-17,BE,Belgium,EURO,14981,2492944,20,28666
2022-01-18,BE,Belgium,EURO,62509,2555453,32,28698
2022-01-19,BE,Belgium,EURO,60679,2616132,28,28726
2022-01-20,BE,Belgium,EURO,60855,2676987,38,28764
2022-01-21,BE,Belgium,EURO,57230,2734217,17,28781
2022-01-22,BE,Belgium,EURO,56411,2790628,23,28804
2022-01-23,BE,Belgium,EURO,32755,2823383,26,28830
2022-01-24,BE,Belgium,EURO,20732,2844115,14,28844
2022-01-25,BE,Belgium,EURO,75906,2920021,26,28870
2022-01-26,BE,Belgium,EURO,62425,2982446,37,28907
2022-01-27,BE,Belgium,EURO,54706,3037152,32,28939
2022-01-28,BE,Belgium,EURO,47469,3084621,28,28967
2022-01-29,BE,Belgium,EURO,41381,3126002,43,29010
2022-01-30,BE,Belgium,EURO,23204,3149206,27,29037
2022-01-31,BE,Belgium,EURO,13197,3162403,37,29074
2022-02-01,BE,Belgium,EURO,49970,3212373,28,29102
2022-02-02,BE,Belgium,EURO,36641,3249014,40,29142
2022-02-03,BE,Belgium,EURO,30548,3279562,45,29187
2022-02-04,BE,Belgium,EURO,16458,3296020,32,29219
2022-02-05,BE,Belgium,EURO,18,3296038,8,29227
2022-02-06,BE,Belgium,EURO,0,3296038,0,29227
2022-02-07,BE,Belgium,EURO,0,3296038,0,29227
.
14517a
2022-02-05,BY,Belarus,EURO,7350,760845,17,6116
2022-02-06,BY,Belarus,EURO,8231,769076,16,6132
2022-02-07,BY,Belarus,EURO,8315,777391,15,6147
.
13753a
2022-02-05,BB,Barbados,AMRO,609,46506,1,283
2022-02-06,BB,Barbados,AMRO,618,47124,3,286
2022-02-07,BB,Barbados,AMRO,653,47777,0,286
.
12989a
2022-02-05,BD,Bangladesh,SEARO,8359,1853187,36,28560
2022-02-06,BD,Bangladesh,SEARO,8345,1861532,29,28589
2022-02-07,BD,Bangladesh,SEARO,9369,1870901,38,28627
.
12225c
2022-02-04,BH,Bahrain,EMRO,8064,398665,1,1410
2022-02-05,BH,Bahrain,EMRO,7273,405938,0,1410
2022-02-06,BH,Bahrain,EMRO,7434,413372,1,1411
2022-02-07,BH,Bahrain,EMRO,7709,421081,0,1411
.
11461a
2022-02-05,BS,Bahamas,AMRO,35,32680,0,748
2022-02-06,BS,Bahamas,AMRO,0,32680,0,748
2022-02-07,BS,Bahamas,AMRO,0,32680,0,748
.
10697a
2022-02-05,AZ,Azerbaijan,EURO,7050,683476,26,8823
2022-02-06,AZ,Azerbaijan,EURO,7704,691180,23,8846
2022-02-07,AZ,Azerbaijan,EURO,7474,698654,25,8871
.
9933a
2022-02-05,AT,Austria,EURO,37172,2006135,23,13694
2022-02-06,AT,Austria,EURO,34186,2040321,18,13712
2022-02-07,AT,Austria,EURO,29175,2069496,7,13719
.
9169c
2022-02-04,AU,Australia,WPRO,32817,2286810,85,3989
2022-02-05,AU,Australia,WPRO,28771,2315581,84,4073
2022-02-06,AU,Australia,WPRO,25413,2340994,83,4156
2022-02-07,AU,Australia,WPRO,23750,2364744,45,4201
.
8405a
2022-02-05,AW,Aruba,AMRO,54,33200,1,194
2022-02-06,AW,Aruba,AMRO,0,33200,0,194
2022-02-07,AW,Aruba,AMRO,0,33200,0,194
.
7641a
2022-02-05,AM,Armenia,EURO,4032,387490,6,8081
2022-02-06,AM,Armenia,EURO,2467,389957,5,8086
2022-02-07,AM,Armenia,EURO,1631,391588,11,8097
.
6877a
2022-02-05,AR,Argentina,AMRO,40094,8555379,287,122439
2022-02-06,AR,Argentina,AMRO,0,8555379,0,122439
2022-02-07,AR,Argentina,AMRO,34500,8589879,245,122684
.
6113a
2022-02-05,AG,Antigua and Barbuda,AMRO,0,6732,0,127
2022-02-06,AG,Antigua and Barbuda,AMRO,0,6732,0,127
2022-02-07,AG,Antigua and Barbuda,AMRO,0,6732,0,127
.
5349a
2022-02-05,AI,Anguilla,AMRO,23,2384,0,8
2022-02-06,AI,Anguilla,AMRO,0,2384,0,8
2022-02-07,AI,Anguilla,AMRO,0,2384,0,8
.
4585c
2022-02-04,AO,Angola,AFRO,52,98319,1,1896
2022-02-05,AO,Angola,AFRO,21,98340,0,1896
2022-02-06,AO,Angola,AFRO,11,98351,0,1896
2022-02-07,AO,Angola,AFRO,13,98364,0,1896
.
3821a
2022-02-05,AD,Andorra,EURO,129,36599,0,147
2022-02-06,AD,Andorra,EURO,0,36599,0,147
2022-02-07,AD,Andorra,EURO,0,36599,0,147
.
3057a
2022-02-05,AS,American Samoa,WPRO,0,18,0,0
2022-02-06,AS,American Samoa,WPRO,0,18,0,0
2022-02-07,AS,American Samoa,WPRO,0,18,0,0
.
2293c
2022-02-04,DZ,Algeria,AFRO,951,255836,14,6618
2022-02-05,DZ,Algeria,AFRO,970,256806,13,6631
2022-02-06,DZ,Algeria,AFRO,792,257598,9,6640
2022-02-07,DZ,Algeria,AFRO,378,257976,6,6646
.
1529c
2022-02-04,AL,Albania,EURO,1001,262241,7,3369
2022-02-05,AL,Albania,EURO,931,263172,2,3371
2022-02-06,AL,Albania,EURO,793,263965,5,3376
2022-02-07,AL,Albania,EURO,659,264624,4,3380
.
765a
2022-02-05,AF,Afghanistan,EMRO,631,165358,0,7420
2022-02-06,AF,Afghanistan,EMRO,354,165712,5,7425
2022-02-07,AF,Afghanistan,EMRO,479,166191,7,7432
.
w WHO-COVID-19-global-data.csv_2022-02-08_18:40:01
q

ed_heredoc
# 
# Dateiname: WHO-COVID-19-global-data.csv_2022-02-08_18:40:01 
# Zugriffsrechte -rw-r--r-- setzen 
  chmod 644 WHO-COVID-19-global-data.csv_2022-02-08_18:40:01 
# ctime war: - 
# atime auf    2022-06-24 00:58:56.488079000 +0200  setzen 
  touch -a -d '2022-06-24 00:58:56.488079000 +0200' WHO-COVID-19-global-data.csv_2022-02-08_18:40:01 
# mtime auf    2022-02-07 19:40:02.206382000 +0100  setzen 
  touch -m -d '2022-02-07 19:40:02.206382000 +0100' WHO-COVID-19-global-data.csv_2022-02-08_18:40:01 
