#!/bin/bash
#
#
# Dies ist ein Script um aus der Datei (Vorgaenger) 
#   WHO-COVID-19-global-data.csv_2022-02-10_18:50:01 
# die Datei 
#   WHO-COVID-19-global-data.csv_2022-02-11_20:20:01
# zu generieren. .
#
# Wenn  sich mehrere Dateien mit Endnug .diff.bash im Verz. befinden können 
# sie mit 
#   for datei in $(ls *.diff.bash) ;do ./${datei} ; done
# ausgeführt werden. Wichtig ist, das die Reihenfolge des Aufrufs stimmt 
# weil jedes Script auf das Ergebnis des Vorgängerscripts angewiesen ist. 
#
# Bekannter Fehler: wenn die Originaldatei keinen Zeilenumbruch am Dateiende 
# hatte hängt das ed-Script einen Zeilenumbruch an. 
#
/bin/ed WHO-COVID-19-global-data.csv_2022-02-10_18:50:01 <<ed_heredoc
182019,182254d
181485a
2022-02-10,ZM,Zambia,AFRO,414,308050,1,3934
.
180716a
2022-02-10,YE,Yemen,EMRO,25,11604,3,2093
.
179947a
2022-02-10,WF,Wallis and Futuna,WPRO,0,453,0,7
.
179178a
2022-02-10,VN,Viet Nam,WPRO,23956,2404651,93,38614
.
178409a
2022-02-10,VE,Venezuela (Bolivarian Republic of),AMRO,1560,499537,9,5504
.
177640a
2022-02-10,VU,Vanuatu,WPRO,0,7,0,0
.
176871a
2022-02-10,UZ,Uzbekistan,EURO,692,231871,3,1595
.
176102a
2022-02-10,UY,Uruguay,AMRO,8444,741454,20,6676
.
175333c
2022-02-09,VI,United States Virgin Islands,AMRO,53,15098,1,104
2022-02-10,VI,United States Virgin Islands,AMRO,30,15128,0,104
.
174564a
2022-02-10,US,United States of America,AMRO,193059,76448067,3521,902189
.
173795a
2022-02-10,TZ,United Republic of Tanzania,AFRO,0,33436,0,792
.
173026a
2022-02-10,AE,United Arab Emirates,EMRO,1538,862514,4,2273
.
172257a
2022-02-10,UA,Ukraine,EURO,41694,4421741,280,102167
.
171488a
2022-02-10,UG,Uganda,AFRO,49,162559,2,3572
.
170719a
2022-02-10,TV,Tuvalu,WPRO,0,0,0,0
.
169950a
2022-02-10,TC,Turks and Caicos Islands,AMRO,17,5806,0,35
.
169181a
2022-02-10,TM,Turkmenistan,EURO,0,0,0,0
.
168412a
2022-02-10,TR,Turkey,EURO,108563,12553783,266,89477
.
167643a
2022-02-10,TN,Tunisia,EMRO,4151,954726,65,26889
.
166874a
2022-02-10,TT,Trinidad and Tobago,AMRO,926,116769,19,3486
.
166097,166105c
2022-02-01,TO,Tonga,WPRO,1,2,0,0
2022-02-02,TO,Tonga,WPRO,3,5,0,0
2022-02-03,TO,Tonga,WPRO,1,6,0,0
2022-02-04,TO,Tonga,WPRO,1,7,0,0
2022-02-05,TO,Tonga,WPRO,1,8,0,0
2022-02-06,TO,Tonga,WPRO,3,11,0,0
2022-02-07,TO,Tonga,WPRO,10,21,0,0
2022-02-08,TO,Tonga,WPRO,13,34,0,0
2022-02-09,TO,Tonga,WPRO,14,48,0,0
2022-02-10,TO,Tonga,WPRO,18,66,0,0
.
165336a
2022-02-10,TK,Tokelau,WPRO,0,0,0,0
.
164567a
2022-02-10,TG,Togo,AFRO,0,36612,0,270
.
163798a
2022-02-10,TL,Timor-Leste,SEARO,216,21158,0,122
.
163029a
2022-02-10,GB,The United Kingdom,EURO,67316,18000123,276,158953
.
162260a
2022-02-10,TH,Thailand,SEARO,14822,2545873,20,22364
.
161491a
2022-02-10,TJ,Tajikistan,EURO,6,17759,0,125
.
160722a
2022-02-10,SY,Syrian Arab Republic,EMRO,124,52243,3,3017
.
159510,159953c
2020-11-23,CH,Switzerland,EURO,1871,300798,82,4196
2020-11-24,CH,Switzerland,EURO,5433,306231,98,4294
2020-11-25,CH,Switzerland,EURO,4432,310663,92,4386
2020-11-26,CH,Switzerland,EURO,4293,314956,93,4479
2020-11-27,CH,Switzerland,EURO,3951,318907,79,4558
2020-11-28,CH,Switzerland,EURO,4067,322974,87,4645
2020-11-29,CH,Switzerland,EURO,2311,325285,89,4734
2020-11-30,CH,Switzerland,EURO,1691,326976,84,4818
2020-12-01,CH,Switzerland,EURO,5268,332244,95,4913
2020-12-02,CH,Switzerland,EURO,4252,336496,88,5001
2020-12-03,CH,Switzerland,EURO,4423,340919,93,5094
2020-12-04,CH,Switzerland,EURO,4319,345238,81,5175
2020-12-05,CH,Switzerland,EURO,4558,349796,82,5257
2020-12-06,CH,Switzerland,EURO,2519,352315,96,5353
2020-12-07,CH,Switzerland,EURO,1938,354253,70,5423
2020-12-08,CH,Switzerland,EURO,5828,360081,80,5503
2020-12-09,CH,Switzerland,EURO,4671,364752,97,5600
2020-12-10,CH,Switzerland,EURO,5241,369993,87,5687
2020-12-11,CH,Switzerland,EURO,4638,374631,83,5770
2020-12-12,CH,Switzerland,EURO,4679,379310,90,5860
2020-12-13,CH,Switzerland,EURO,2864,382174,85,5945
2020-12-14,CH,Switzerland,EURO,2086,384260,85,6030
2020-12-15,CH,Switzerland,EURO,5914,390174,98,6128
2020-12-16,CH,Switzerland,EURO,5166,395340,91,6219
2020-12-17,CH,Switzerland,EURO,4819,400159,94,6313
2020-12-18,CH,Switzerland,EURO,4386,404545,88,6401
2020-12-19,CH,Switzerland,EURO,4345,408890,92,6493
2020-12-20,CH,Switzerland,EURO,2677,411567,80,6573
2020-12-21,CH,Switzerland,EURO,1955,413522,99,6672
2020-12-22,CH,Switzerland,EURO,5623,419145,89,6761
2020-12-23,CH,Switzerland,EURO,4606,423751,82,6843
2020-12-24,CH,Switzerland,EURO,4475,428226,81,6924
2020-12-25,CH,Switzerland,EURO,3048,431274,89,7013
2020-12-26,CH,Switzerland,EURO,1721,432995,63,7076
2020-12-27,CH,Switzerland,EURO,2357,435352,96,7172
2020-12-28,CH,Switzerland,EURO,2116,437468,92,7264
2020-12-29,CH,Switzerland,EURO,5035,442503,83,7347
2020-12-30,CH,Switzerland,EURO,4463,446966,78,7425
2020-12-31,CH,Switzerland,EURO,4210,451176,92,7517
2021-01-01,CH,Switzerland,EURO,3055,454231,82,7599
2021-01-02,CH,Switzerland,EURO,1684,455915,76,7675
2021-01-03,CH,Switzerland,EURO,2727,458642,70,7745
2021-01-04,CH,Switzerland,EURO,2225,460867,67,7812
2021-01-05,CH,Switzerland,EURO,5287,466154,51,7863
2021-01-06,CH,Switzerland,EURO,4178,470332,64,7927
2021-01-07,CH,Switzerland,EURO,3355,473687,63,7990
2021-01-08,CH,Switzerland,EURO,3177,476864,65,8055
2021-01-09,CH,Switzerland,EURO,3055,479919,49,8104
2021-01-10,CH,Switzerland,EURO,1686,481605,69,8173
2021-01-11,CH,Switzerland,EURO,1296,482901,58,8231
2021-01-12,CH,Switzerland,EURO,3468,486369,59,8290
2021-01-13,CH,Switzerland,EURO,2610,488979,55,8345
2021-01-14,CH,Switzerland,EURO,2491,491470,59,8404
2021-01-15,CH,Switzerland,EURO,2239,493709,49,8453
2021-01-16,CH,Switzerland,EURO,2159,495868,65,8518
2021-01-17,CH,Switzerland,EURO,1337,497205,51,8569
2021-01-18,CH,Switzerland,EURO,894,498099,37,8606
2021-01-19,CH,Switzerland,EURO,2944,501043,38,8644
2021-01-20,CH,Switzerland,EURO,2333,503376,62,8706
2021-01-21,CH,Switzerland,EURO,2278,505654,46,8752
2021-01-22,CH,Switzerland,EURO,2057,507711,47,8799
2021-01-23,CH,Switzerland,EURO,2041,509752,44,8843
2021-01-24,CH,Switzerland,EURO,1101,510853,46,8889
2021-01-25,CH,Switzerland,EURO,730,511583,49,8938
2021-01-26,CH,Switzerland,EURO,2493,514076,32,8970
2021-01-27,CH,Switzerland,EURO,1838,515914,41,9011
2021-01-28,CH,Switzerland,EURO,1875,517789,34,9045
2021-01-29,CH,Switzerland,EURO,1781,519570,42,9087
2021-01-30,CH,Switzerland,EURO,1766,521336,36,9123
2021-01-31,CH,Switzerland,EURO,1020,522356,30,9153
2021-02-01,CH,Switzerland,EURO,744,523100,27,9180
2021-02-02,CH,Switzerland,EURO,2164,525264,31,9211
2021-02-03,CH,Switzerland,EURO,1652,526916,24,9235
2021-02-04,CH,Switzerland,EURO,1733,528649,19,9254
2021-02-05,CH,Switzerland,EURO,1441,530090,24,9278
2021-02-06,CH,Switzerland,EURO,1505,531595,22,9300
2021-02-07,CH,Switzerland,EURO,887,532482,26,9326
2021-02-08,CH,Switzerland,EURO,673,533155,19,9345
2021-02-09,CH,Switzerland,EURO,1751,534906,20,9365
2021-02-10,CH,Switzerland,EURO,1349,536255,16,9381
2021-02-11,CH,Switzerland,EURO,1259,537514,23,9404
2021-02-12,CH,Switzerland,EURO,1171,538685,14,9418
2021-02-13,CH,Switzerland,EURO,1131,539816,15,9433
2021-02-14,CH,Switzerland,EURO,720,540536,18,9451
2021-02-15,CH,Switzerland,EURO,485,541021,22,9473
2021-02-16,CH,Switzerland,EURO,1303,542324,19,9492
2021-02-17,CH,Switzerland,EURO,1136,543460,8,9500
2021-02-18,CH,Switzerland,EURO,1215,544675,9,9509
2021-02-19,CH,Switzerland,EURO,1007,545682,10,9519
2021-02-20,CH,Switzerland,EURO,1094,546776,14,9533
2021-02-21,CH,Switzerland,EURO,691,547467,15,9548
2021-02-22,CH,Switzerland,EURO,527,547994,11,9559
2021-02-23,CH,Switzerland,EURO,1407,549401,9,9568
2021-02-24,CH,Switzerland,EURO,1258,550659,10,9578
2021-02-25,CH,Switzerland,EURO,1077,551736,8,9586
2021-02-26,CH,Switzerland,EURO,1119,552855,10,9596
2021-02-27,CH,Switzerland,EURO,1080,553935,9,9605
2021-02-28,CH,Switzerland,EURO,723,554658,10,9615
2021-03-01,CH,Switzerland,EURO,547,555205,7,9622
2021-03-02,CH,Switzerland,EURO,1419,556624,8,9630
2021-03-03,CH,Switzerland,EURO,1230,557854,11,9641
2021-03-04,CH,Switzerland,EURO,1240,559094,9,9650
2021-03-05,CH,Switzerland,EURO,1063,560157,9,9659
2021-03-06,CH,Switzerland,EURO,1278,561435,10,9669
2021-03-07,CH,Switzerland,EURO,765,562200,8,9677
2021-03-08,CH,Switzerland,EURO,582,562782,9,9686
2021-03-09,CH,Switzerland,EURO,1702,564484,10,9696
2021-03-10,CH,Switzerland,EURO,1388,565872,8,9704
2021-03-11,CH,Switzerland,EURO,1385,567257,12,9716
2021-03-12,CH,Switzerland,EURO,1340,568597,13,9729
2021-03-13,CH,Switzerland,EURO,1342,569939,9,9738
2021-03-14,CH,Switzerland,EURO,923,570862,14,9752
2021-03-15,CH,Switzerland,EURO,703,571565,9,9761
2021-03-16,CH,Switzerland,EURO,1923,573488,9,9770
2021-03-17,CH,Switzerland,EURO,1653,575141,11,9781
2021-03-18,CH,Switzerland,EURO,1824,576965,13,9794
2021-03-19,CH,Switzerland,EURO,1647,578612,9,9803
2021-03-20,CH,Switzerland,EURO,1544,580156,9,9812
2021-03-21,CH,Switzerland,EURO,1111,581267,4,9816
2021-03-22,CH,Switzerland,EURO,787,582054,7,9823
2021-03-23,CH,Switzerland,EURO,2263,584317,5,9828
2021-03-24,CH,Switzerland,EURO,1995,586312,12,9840
2021-03-25,CH,Switzerland,EURO,1931,588243,7,9847
2021-03-26,CH,Switzerland,EURO,2142,590385,13,9860
2021-03-27,CH,Switzerland,EURO,2000,592385,4,9864
2021-03-28,CH,Switzerland,EURO,1208,593593,10,9874
2021-03-29,CH,Switzerland,EURO,995,594588,9,9883
2021-03-30,CH,Switzerland,EURO,2532,597120,5,9888
2021-03-31,CH,Switzerland,EURO,2093,599213,12,9900
2021-04-01,CH,Switzerland,EURO,2132,601345,14,9914
2021-04-02,CH,Switzerland,EURO,1986,603331,12,9926
2021-04-03,CH,Switzerland,EURO,1205,604536,6,9932
2021-04-04,CH,Switzerland,EURO,1317,605853,12,9944
2021-04-05,CH,Switzerland,EURO,1022,606875,10,9954
2021-04-06,CH,Switzerland,EURO,1290,608165,17,9971
2021-04-07,CH,Switzerland,EURO,2690,610855,10,9981
2021-04-08,CH,Switzerland,EURO,2387,613242,10,9991
2021-04-09,CH,Switzerland,EURO,2490,615732,5,9996
2021-04-10,CH,Switzerland,EURO,2416,618148,8,10004
2021-04-11,CH,Switzerland,EURO,1682,619830,6,10010
2021-04-12,CH,Switzerland,EURO,1180,621010,7,10017
2021-04-13,CH,Switzerland,EURO,2742,623752,3,10020
2021-04-14,CH,Switzerland,EURO,2375,626127,10,10030
2021-04-15,CH,Switzerland,EURO,2214,628341,6,10036
2021-04-16,CH,Switzerland,EURO,2147,630488,4,10040
2021-04-17,CH,Switzerland,EURO,2121,632609,7,10047
2021-04-18,CH,Switzerland,EURO,1430,634039,9,10056
2021-04-19,CH,Switzerland,EURO,1048,635087,7,10063
2021-04-20,CH,Switzerland,EURO,2744,637831,8,10071
2021-04-21,CH,Switzerland,EURO,2391,640222,9,10080
2021-04-22,CH,Switzerland,EURO,2309,642531,5,10085
2021-04-23,CH,Switzerland,EURO,2266,644797,7,10092
2021-04-24,CH,Switzerland,EURO,2165,646962,10,10102
2021-04-25,CH,Switzerland,EURO,1456,648418,6,10108
2021-04-26,CH,Switzerland,EURO,1188,649606,9,10117
2021-04-27,CH,Switzerland,EURO,2441,652047,13,10130
2021-04-28,CH,Switzerland,EURO,2038,654085,11,10141
2021-04-29,CH,Switzerland,EURO,2009,656094,7,10148
2021-04-30,CH,Switzerland,EURO,1711,657805,8,10156
2021-05-01,CH,Switzerland,EURO,1677,659482,9,10165
2021-05-02,CH,Switzerland,EURO,1159,660641,12,10177
2021-05-03,CH,Switzerland,EURO,832,661473,8,10185
2021-05-04,CH,Switzerland,EURO,2019,663492,5,10190
2021-05-05,CH,Switzerland,EURO,1735,665227,4,10194
2021-05-06,CH,Switzerland,EURO,1649,666876,11,10205
2021-05-07,CH,Switzerland,EURO,1484,668360,4,10209
2021-05-08,CH,Switzerland,EURO,1573,669933,7,10216
2021-05-09,CH,Switzerland,EURO,1062,670995,5,10221
2021-05-10,CH,Switzerland,EURO,779,671774,5,10226
2021-05-11,CH,Switzerland,EURO,1718,673492,6,10232
2021-05-12,CH,Switzerland,EURO,1383,674875,4,10236
2021-05-13,CH,Switzerland,EURO,1441,676316,0,10236
2021-05-14,CH,Switzerland,EURO,672,676988,5,10241
2021-05-15,CH,Switzerland,EURO,1169,678157,4,10245
2021-05-16,CH,Switzerland,EURO,802,678959,2,10247
2021-05-17,CH,Switzerland,EURO,653,679612,9,10256
2021-05-18,CH,Switzerland,EURO,1671,681283,1,10257
2021-05-19,CH,Switzerland,EURO,1344,682627,3,10260
2021-05-20,CH,Switzerland,EURO,1212,683839,6,10266
2021-05-21,CH,Switzerland,EURO,1040,684879,3,10269
2021-05-22,CH,Switzerland,EURO,984,685863,10,10279
2021-05-23,CH,Switzerland,EURO,623,686486,5,10284
2021-05-24,CH,Switzerland,EURO,470,686956,5,10289
2021-05-25,CH,Switzerland,EURO,581,687537,4,10293
2021-05-26,CH,Switzerland,EURO,1148,688685,4,10297
2021-05-27,CH,Switzerland,EURO,923,689608,2,10299
2021-05-28,CH,Switzerland,EURO,849,690457,3,10302
2021-05-29,CH,Switzerland,EURO,751,691208,2,10304
2021-05-30,CH,Switzerland,EURO,500,691708,4,10308
2021-05-31,CH,Switzerland,EURO,357,692065,0,10308
2021-06-01,CH,Switzerland,EURO,855,692920,2,10310
2021-06-02,CH,Switzerland,EURO,652,693572,1,10311
2021-06-03,CH,Switzerland,EURO,551,694123,3,10314
2021-06-04,CH,Switzerland,EURO,468,694591,6,10320
2021-06-05,CH,Switzerland,EURO,491,695082,4,10324
2021-06-06,CH,Switzerland,EURO,313,695395,2,10326
2021-06-07,CH,Switzerland,EURO,187,695582,6,10332
2021-06-08,CH,Switzerland,EURO,584,696166,2,10334
2021-06-09,CH,Switzerland,EURO,417,696583,2,10336
2021-06-10,CH,Switzerland,EURO,375,696958,2,10338
2021-06-11,CH,Switzerland,EURO,304,697262,3,10341
2021-06-12,CH,Switzerland,EURO,318,697580,3,10344
2021-06-13,CH,Switzerland,EURO,194,697774,2,10346
2021-06-14,CH,Switzerland,EURO,121,697895,2,10348
2021-06-15,CH,Switzerland,EURO,328,698223,0,10348
2021-06-16,CH,Switzerland,EURO,233,698456,1,10349
2021-06-17,CH,Switzerland,EURO,191,698647,4,10353
2021-06-18,CH,Switzerland,EURO,156,698803,3,10356
2021-06-19,CH,Switzerland,EURO,149,698952,3,10359
2021-06-20,CH,Switzerland,EURO,103,699055,0,10359
2021-06-21,CH,Switzerland,EURO,78,699133,1,10360
2021-06-22,CH,Switzerland,EURO,165,699298,2,10362
2021-06-23,CH,Switzerland,EURO,122,699420,0,10362
2021-06-24,CH,Switzerland,EURO,127,699547,1,10363
2021-06-25,CH,Switzerland,EURO,113,699660,1,10364
2021-06-26,CH,Switzerland,EURO,98,699758,1,10365
2021-06-27,CH,Switzerland,EURO,60,699818,0,10365
2021-06-28,CH,Switzerland,EURO,59,699877,2,10367
2021-06-29,CH,Switzerland,EURO,150,700027,0,10367
2021-06-30,CH,Switzerland,EURO,115,700142,2,10369
2021-07-01,CH,Switzerland,EURO,159,700301,0,10369
2021-07-02,CH,Switzerland,EURO,169,700470,0,10369
2021-07-03,CH,Switzerland,EURO,165,700635,1,10370
2021-07-04,CH,Switzerland,EURO,129,700764,0,10370
2021-07-05,CH,Switzerland,EURO,139,700903,0,10370
2021-07-06,CH,Switzerland,EURO,310,701213,0,10370
2021-07-07,CH,Switzerland,EURO,289,701502,0,10370
2021-07-08,CH,Switzerland,EURO,320,701822,0,10370
2021-07-09,CH,Switzerland,EURO,316,702138,0,10370
2021-07-10,CH,Switzerland,EURO,327,702465,1,10371
2021-07-11,CH,Switzerland,EURO,255,702720,1,10372
2021-07-12,CH,Switzerland,EURO,230,702950,1,10373
2021-07-13,CH,Switzerland,EURO,571,703521,0,10373
2021-07-14,CH,Switzerland,EURO,522,704043,1,10374
2021-07-15,CH,Switzerland,EURO,590,704633,0,10374
2021-07-16,CH,Switzerland,EURO,623,705256,0,10374
2021-07-17,CH,Switzerland,EURO,645,705901,0,10374
2021-07-18,CH,Switzerland,EURO,454,706355,1,10375
2021-07-19,CH,Switzerland,EURO,394,706749,0,10375
2021-07-20,CH,Switzerland,EURO,857,707606,1,10376
2021-07-21,CH,Switzerland,EURO,737,708343,0,10376
2021-07-22,CH,Switzerland,EURO,873,709216,2,10378
2021-07-23,CH,Switzerland,EURO,724,709940,0,10378
2021-07-24,CH,Switzerland,EURO,743,710683,0,10378
2021-07-25,CH,Switzerland,EURO,539,711222,1,10379
2021-07-26,CH,Switzerland,EURO,480,711702,1,10380
2021-07-27,CH,Switzerland,EURO,951,712653,1,10381
2021-07-28,CH,Switzerland,EURO,740,713393,5,10386
2021-07-29,CH,Switzerland,EURO,785,714178,3,10389
2021-07-30,CH,Switzerland,EURO,783,714961,1,10390
2021-07-31,CH,Switzerland,EURO,803,715764,0,10390
2021-08-01,CH,Switzerland,EURO,656,716420,0,10390
2021-08-02,CH,Switzerland,EURO,535,716955,1,10391
2021-08-03,CH,Switzerland,EURO,1234,718189,1,10392
2021-08-04,CH,Switzerland,EURO,990,719179,1,10393
2021-08-05,CH,Switzerland,EURO,1070,720249,0,10393
2021-08-06,CH,Switzerland,EURO,1121,721370,0,10393
2021-08-07,CH,Switzerland,EURO,1152,722522,0,10393
2021-08-08,CH,Switzerland,EURO,1046,723568,0,10393
2021-08-09,CH,Switzerland,EURO,1008,724576,1,10394
2021-08-10,CH,Switzerland,EURO,2321,726897,2,10396
2021-08-11,CH,Switzerland,EURO,2031,728928,2,10398
2021-08-12,CH,Switzerland,EURO,2085,731013,3,10401
2021-08-13,CH,Switzerland,EURO,2167,733180,2,10403
2021-08-14,CH,Switzerland,EURO,2208,735388,1,10404
2021-08-15,CH,Switzerland,EURO,1679,737067,3,10407
2021-08-16,CH,Switzerland,EURO,1651,738718,2,10409
2021-08-17,CH,Switzerland,EURO,3951,742669,3,10412
2021-08-18,CH,Switzerland,EURO,2838,745507,4,10416
2021-08-19,CH,Switzerland,EURO,2710,748217,1,10417
2021-08-20,CH,Switzerland,EURO,2512,750729,4,10421
2021-08-21,CH,Switzerland,EURO,2561,753290,7,10428
2021-08-22,CH,Switzerland,EURO,1748,755038,3,10431
2021-08-23,CH,Switzerland,EURO,1633,756671,3,10434
2021-08-24,CH,Switzerland,EURO,3851,760522,6,10440
2021-08-25,CH,Switzerland,EURO,2916,763438,8,10448
2021-08-26,CH,Switzerland,EURO,2765,766203,4,10452
2021-08-27,CH,Switzerland,EURO,2693,768896,7,10459
2021-08-28,CH,Switzerland,EURO,2596,771492,4,10463
2021-08-29,CH,Switzerland,EURO,1677,773169,8,10471
2021-08-30,CH,Switzerland,EURO,1385,774554,5,10476
2021-08-31,CH,Switzerland,EURO,3562,778116,13,10489
2021-09-01,CH,Switzerland,EURO,2974,781090,4,10493
2021-09-02,CH,Switzerland,EURO,2942,784032,8,10501
2021-09-03,CH,Switzerland,EURO,3051,787083,4,10505
2021-09-04,CH,Switzerland,EURO,3077,790160,8,10513
2021-09-05,CH,Switzerland,EURO,1760,791920,6,10519
2021-09-06,CH,Switzerland,EURO,1399,793319,9,10528
2021-09-07,CH,Switzerland,EURO,3995,797314,8,10536
2021-09-08,CH,Switzerland,EURO,3044,800358,11,10547
2021-09-09,CH,Switzerland,EURO,3060,803418,7,10554
2021-09-10,CH,Switzerland,EURO,2769,806187,7,10561
2021-09-11,CH,Switzerland,EURO,2622,808809,5,10566
2021-09-12,CH,Switzerland,EURO,1551,810360,7,10573
2021-09-13,CH,Switzerland,EURO,1106,811466,10,10583
2021-09-14,CH,Switzerland,EURO,2764,814230,8,10591
2021-09-15,CH,Switzerland,EURO,2296,816526,3,10594
2021-09-16,CH,Switzerland,EURO,2242,818768,7,10601
2021-09-17,CH,Switzerland,EURO,1998,820766,3,10604
2021-09-18,CH,Switzerland,EURO,1691,822457,11,10615
2021-09-19,CH,Switzerland,EURO,1027,823484,4,10619
2021-09-20,CH,Switzerland,EURO,702,824186,6,10625
2021-09-21,CH,Switzerland,EURO,1880,826066,4,10629
2021-09-22,CH,Switzerland,EURO,1703,827769,4,10633
2021-09-23,CH,Switzerland,EURO,1531,829300,6,10639
2021-09-24,CH,Switzerland,EURO,1377,830677,7,10646
2021-09-25,CH,Switzerland,EURO,1343,832020,9,10655
2021-09-26,CH,Switzerland,EURO,886,832906,5,10660
2021-09-27,CH,Switzerland,EURO,607,833513,7,10667
2021-09-28,CH,Switzerland,EURO,1661,835174,3,10670
2021-09-29,CH,Switzerland,EURO,1208,836382,7,10677
2021-09-30,CH,Switzerland,EURO,1187,837569,11,10688
2021-10-01,CH,Switzerland,EURO,1195,838764,1,10689
2021-10-02,CH,Switzerland,EURO,1139,839903,5,10694
2021-10-03,CH,Switzerland,EURO,786,840689,5,10699
2021-10-04,CH,Switzerland,EURO,473,841162,3,10702
2021-10-05,CH,Switzerland,EURO,1278,842440,4,10706
2021-10-06,CH,Switzerland,EURO,1033,843473,6,10712
2021-10-07,CH,Switzerland,EURO,1008,844481,1,10713
2021-10-08,CH,Switzerland,EURO,1011,845492,8,10721
2021-10-09,CH,Switzerland,EURO,919,846411,3,10724
2021-10-10,CH,Switzerland,EURO,638,847049,5,10729
2021-10-11,CH,Switzerland,EURO,480,847529,4,10733
2021-10-12,CH,Switzerland,EURO,1172,848701,10,10743
2021-10-13,CH,Switzerland,EURO,965,849666,6,10749
2021-10-14,CH,Switzerland,EURO,963,850629,6,10755
2021-10-15,CH,Switzerland,EURO,958,851587,3,10758
2021-10-16,CH,Switzerland,EURO,985,852572,3,10761
2021-10-17,CH,Switzerland,EURO,700,853272,0,10761
2021-10-18,CH,Switzerland,EURO,680,853952,4,10765
2021-10-19,CH,Switzerland,EURO,1571,855523,2,10767
2021-10-20,CH,Switzerland,EURO,1289,856812,6,10773
2021-10-21,CH,Switzerland,EURO,1431,858243,9,10782
2021-10-22,CH,Switzerland,EURO,1371,859614,3,10785
2021-10-23,CH,Switzerland,EURO,1352,860966,5,10790
2021-10-24,CH,Switzerland,EURO,954,861920,4,10794
2021-10-25,CH,Switzerland,EURO,727,862647,4,10798
2021-10-26,CH,Switzerland,EURO,2024,864671,8,10806
2021-10-27,CH,Switzerland,EURO,1699,866370,5,10811
2021-10-28,CH,Switzerland,EURO,1807,868177,9,10820
2021-10-29,CH,Switzerland,EURO,1803,869980,7,10827
2021-10-30,CH,Switzerland,EURO,1864,871844,4,10831
2021-10-31,CH,Switzerland,EURO,1259,873103,6,10837
2021-11-01,CH,Switzerland,EURO,1081,874184,5,10842
2021-11-02,CH,Switzerland,EURO,2343,876527,5,10847
2021-11-03,CH,Switzerland,EURO,2983,879510,3,10850
2021-11-04,CH,Switzerland,EURO,2836,882346,3,10853
2021-11-05,CH,Switzerland,EURO,2843,885189,3,10856
2021-11-06,CH,Switzerland,EURO,2755,887944,7,10863
2021-11-07,CH,Switzerland,EURO,1931,889875,3,10866
2021-11-08,CH,Switzerland,EURO,1537,891412,10,10876
2021-11-09,CH,Switzerland,EURO,4204,895616,10,10886
2021-11-10,CH,Switzerland,EURO,3738,899354,11,10897
2021-11-11,CH,Switzerland,EURO,3970,903324,5,10902
2021-11-12,CH,Switzerland,EURO,3953,907277,13,10915
2021-11-13,CH,Switzerland,EURO,4144,911421,7,10922
2021-11-14,CH,Switzerland,EURO,2709,914130,7,10929
2021-11-15,CH,Switzerland,EURO,2165,916295,8,10937
2021-11-16,CH,Switzerland,EURO,6133,922428,8,10945
2021-11-17,CH,Switzerland,EURO,5626,928054,14,10959
2021-11-18,CH,Switzerland,EURO,6182,934236,13,10972
2021-11-19,CH,Switzerland,EURO,6055,940291,17,10989
2021-11-20,CH,Switzerland,EURO,6200,946491,6,10995
2021-11-21,CH,Switzerland,EURO,4141,950632,9,11004
2021-11-22,CH,Switzerland,EURO,3406,954038,13,11017
2021-11-23,CH,Switzerland,EURO,9167,963205,20,11037
2021-11-24,CH,Switzerland,EURO,8012,971217,18,11055
2021-11-25,CH,Switzerland,EURO,8468,979685,18,11073
2021-11-26,CH,Switzerland,EURO,7988,987673,8,11081
2021-11-27,CH,Switzerland,EURO,7968,995641,14,11095
2021-11-28,CH,Switzerland,EURO,5262,1000903,16,11111
2021-11-29,CH,Switzerland,EURO,4243,1005146,19,11130
2021-11-30,CH,Switzerland,EURO,11502,1016648,21,11151
2021-12-01,CH,Switzerland,EURO,10000,1026648,27,11178
2021-12-02,CH,Switzerland,EURO,10419,1037067,28,11206
2021-12-03,CH,Switzerland,EURO,10159,1047226,26,11232
2021-12-04,CH,Switzerland,EURO,9806,1057032,23,11255
2021-12-05,CH,Switzerland,EURO,6256,1063288,22,11277
2021-12-06,CH,Switzerland,EURO,4937,1068225,25,11302
2021-12-07,CH,Switzerland,EURO,12662,1080887,34,11336
2021-12-08,CH,Switzerland,EURO,11034,1091921,23,11359
2021-12-09,CH,Switzerland,EURO,9950,1101871,29,11388
2021-12-10,CH,Switzerland,EURO,10421,1112292,28,11416
2021-12-11,CH,Switzerland,EURO,9757,1122049,21,11437
2021-12-12,CH,Switzerland,EURO,6089,1128138,22,11459
2021-12-13,CH,Switzerland,EURO,4393,1132531,28,11487
2021-12-14,CH,Switzerland,EURO,12430,1144961,21,11508
2021-12-15,CH,Switzerland,EURO,10528,1155489,35,11543
2021-12-16,CH,Switzerland,EURO,9532,1165021,33,11576
2021-12-17,CH,Switzerland,EURO,9144,1174165,29,11605
2021-12-18,CH,Switzerland,EURO,8737,1182902,24,11629
2021-12-19,CH,Switzerland,EURO,5876,1188778,21,11650
2021-12-20,CH,Switzerland,EURO,4332,1193110,20,11670
2021-12-21,CH,Switzerland,EURO,11467,1204577,29,11699
2021-12-22,CH,Switzerland,EURO,10776,1215353,20,11719
2021-12-23,CH,Switzerland,EURO,11008,1226361,24,11743
2021-12-24,CH,Switzerland,EURO,11265,1237626,26,11769
2021-12-25,CH,Switzerland,EURO,9630,1247256,11,11780
2021-12-26,CH,Switzerland,EURO,6450,1253706,20,11800
2021-12-27,CH,Switzerland,EURO,7369,1261075,13,11813
2021-12-28,CH,Switzerland,EURO,17421,1278496,17,11830
2021-12-29,CH,Switzerland,EURO,17666,1296162,25,11855
2021-12-30,CH,Switzerland,EURO,18989,1315151,14,11869
2021-12-31,CH,Switzerland,EURO,19741,1334892,22,11891
2022-01-01,CH,Switzerland,EURO,16133,1351025,24,11915
2022-01-02,CH,Switzerland,EURO,9395,1360420,17,11932
2022-01-03,CH,Switzerland,EURO,12807,1373227,11,11943
2022-01-04,CH,Switzerland,EURO,32268,1405495,11,11954
2022-01-05,CH,Switzerland,EURO,33365,1438860,10,11964
2022-01-06,CH,Switzerland,EURO,30639,1469499,13,11977
2022-01-07,CH,Switzerland,EURO,26111,1495610,12,11989
2022-01-08,CH,Switzerland,EURO,27269,1522879,28,12017
2022-01-09,CH,Switzerland,EURO,17770,1540649,17,12034
2022-01-10,CH,Switzerland,EURO,13378,1554027,10,12044
2022-01-11,CH,Switzerland,EURO,34528,1588555,17,12061
2022-01-12,CH,Switzerland,EURO,30892,1619447,12,12073
2022-01-13,CH,Switzerland,EURO,29604,1649051,10,12083
2022-01-14,CH,Switzerland,EURO,28614,1677665,14,12097
2022-01-15,CH,Switzerland,EURO,27624,1705289,13,12110
2022-01-16,CH,Switzerland,EURO,19290,1724579,16,12126
2022-01-17,CH,Switzerland,EURO,14757,1739336,14,12140
2022-01-18,CH,Switzerland,EURO,41801,1781137,12,12152
2022-01-19,CH,Switzerland,EURO,39310,1820447,16,12168
2022-01-20,CH,Switzerland,EURO,39092,1859539,21,12189
2022-01-21,CH,Switzerland,EURO,37658,1897197,19,12208
2022-01-22,CH,Switzerland,EURO,36630,1933827,11,12219
2022-01-23,CH,Switzerland,EURO,24634,1958461,17,12236
2022-01-24,CH,Switzerland,EURO,18341,1976802,7,12243
2022-01-25,CH,Switzerland,EURO,48450,2025252,8,12251
2022-01-26,CH,Switzerland,EURO,44320,2069572,19,12270
2022-01-27,CH,Switzerland,EURO,41540,2111112,10,12280
2022-01-28,CH,Switzerland,EURO,37811,2148923,9,12289
2022-01-29,CH,Switzerland,EURO,35776,2184699,17,12306
2022-01-30,CH,Switzerland,EURO,23432,2208131,15,12321
2022-01-31,CH,Switzerland,EURO,18162,2226293,20,12341
2022-02-01,CH,Switzerland,EURO,43641,2269934,13,12354
2022-02-02,CH,Switzerland,EURO,36995,2306929,14,12368
2022-02-03,CH,Switzerland,EURO,34549,2341478,15,12383
2022-02-04,CH,Switzerland,EURO,29336,2370814,7,12390
2022-02-05,CH,Switzerland,EURO,26674,2397488,6,12396
2022-02-06,CH,Switzerland,EURO,18443,2415931,7,12403
2022-02-07,CH,Switzerland,EURO,14427,2430358,10,12413
2022-02-08,CH,Switzerland,EURO,31072,2461430,11,12424
2022-02-09,CH,Switzerland,EURO,17324,2478754,3,12427
2022-02-10,CH,Switzerland,EURO,164,2478918,0,12427
.
159184a
2022-02-10,SE,Sweden,EURO,18126,2372637,0,16358
.
158514,158782c
2020-04-10,SE,Sweden,EURO,654,8955,150,1014
2020-04-11,SE,Sweden,EURO,645,9600,86,1100
2020-04-12,SE,Sweden,EURO,454,10054,90,1190
2020-04-13,SE,Sweden,EURO,395,10449,102,1292
2020-04-14,SE,Sweden,EURO,464,10913,97,1389
2020-04-15,SE,Sweden,EURO,437,11350,84,1473
2020-04-16,SE,Sweden,EURO,479,11829,91,1564
2020-04-17,SE,Sweden,EURO,604,12433,115,1679
2020-04-18,SE,Sweden,EURO,623,13056,111,1790
2020-04-19,SE,Sweden,EURO,689,13745,83,1873
2020-04-20,SE,Sweden,EURO,532,14277,86,1959
2020-04-21,SE,Sweden,EURO,388,14665,87,2046
2020-04-22,SE,Sweden,EURO,461,15126,85,2131
2020-04-23,SE,Sweden,EURO,707,15833,62,2193
2020-04-24,SE,Sweden,EURO,723,16556,77,2270
2020-04-25,SE,Sweden,EURO,758,17314,86,2356
2020-04-26,SE,Sweden,EURO,781,18095,89,2445
2020-04-27,SE,Sweden,EURO,473,18568,73,2518
2020-04-28,SE,Sweden,EURO,300,18868,74,2592
2020-04-29,SE,Sweden,EURO,563,19431,74,2666
2020-04-30,SE,Sweden,EURO,742,20173,83,2749
2020-05-01,SE,Sweden,EURO,799,20972,83,2832
2020-05-02,SE,Sweden,EURO,636,21608,78,2910
2020-05-03,SE,Sweden,EURO,532,22140,78,2988
2020-05-04,SE,Sweden,EURO,299,22439,72,3060
2020-05-05,SE,Sweden,EURO,261,22700,75,3135
2020-05-06,SE,Sweden,EURO,477,23177,83,3218
2020-05-07,SE,Sweden,EURO,657,23834,72,3290
2020-05-08,SE,Sweden,EURO,745,24579,73,3363
2020-05-09,SE,Sweden,EURO,785,25364,80,3443
2020-05-10,SE,Sweden,EURO,701,26065,60,3503
2020-05-11,SE,Sweden,EURO,509,26574,68,3571
2020-05-12,SE,Sweden,EURO,279,26853,73,3644
2020-05-13,SE,Sweden,EURO,455,27308,65,3709
2020-05-14,SE,Sweden,EURO,754,28062,61,3770
2020-05-15,SE,Sweden,EURO,698,28760,50,3820
2020-05-16,SE,Sweden,EURO,657,29417,46,3866
2020-05-17,SE,Sweden,EURO,688,30105,58,3924
2020-05-18,SE,Sweden,EURO,358,30463,48,3972
2020-05-19,SE,Sweden,EURO,259,30722,52,4024
2020-05-20,SE,Sweden,EURO,430,31152,59,4083
2020-05-21,SE,Sweden,EURO,666,31818,41,4124
2020-05-22,SE,Sweden,EURO,808,32626,52,4176
2020-05-23,SE,Sweden,EURO,610,33236,53,4229
2020-05-24,SE,Sweden,EURO,532,33768,56,4285
2020-05-25,SE,Sweden,EURO,403,34171,55,4340
2020-05-26,SE,Sweden,EURO,210,34381,44,4384
2020-05-27,SE,Sweden,EURO,490,34871,42,4426
2020-05-28,SE,Sweden,EURO,746,35617,28,4454
2020-05-29,SE,Sweden,EURO,800,36417,38,4492
2020-05-30,SE,Sweden,EURO,774,37191,40,4532
2020-05-31,SE,Sweden,EURO,773,37964,40,4572
2020-06-01,SE,Sweden,EURO,432,38396,38,4610
2020-06-02,SE,Sweden,EURO,265,38661,46,4656
2020-06-03,SE,Sweden,EURO,648,39309,39,4695
2020-06-04,SE,Sweden,EURO,900,40209,36,4731
2020-06-05,SE,Sweden,EURO,1046,41255,28,4759
2020-06-06,SE,Sweden,EURO,1039,42294,44,4803
2020-06-07,SE,Sweden,EURO,1146,43440,37,4840
2020-06-08,SE,Sweden,EURO,780,44220,29,4869
2020-06-09,SE,Sweden,EURO,462,44682,33,4902
2020-06-10,SE,Sweden,EURO,677,45359,38,4940
2020-06-11,SE,Sweden,EURO,937,46296,33,4973
2020-06-12,SE,Sweden,EURO,1437,47733,39,5012
2020-06-13,SE,Sweden,EURO,1293,49026,35,5047
2020-06-14,SE,Sweden,EURO,1329,50355,29,5076
2020-06-15,SE,Sweden,EURO,1032,51387,33,5109
2020-06-16,SE,Sweden,EURO,418,51805,27,5136
2020-06-17,SE,Sweden,EURO,685,52490,30,5166
2020-06-18,SE,Sweden,EURO,1209,53699,28,5194
2020-06-19,SE,Sweden,EURO,1457,55156,32,5226
2020-06-20,SE,Sweden,EURO,1494,56650,29,5255
2020-06-21,SE,Sweden,EURO,1209,57859,30,5285
2020-06-22,SE,Sweden,EURO,698,58557,29,5314
2020-06-23,SE,Sweden,EURO,321,58878,22,5336
2020-06-24,SE,Sweden,EURO,800,59678,20,5356
2020-06-25,SE,Sweden,EURO,1309,60987,25,5381
2020-06-26,SE,Sweden,EURO,1696,62683,22,5403
2020-06-27,SE,Sweden,EURO,1276,63959,23,5426
2020-06-28,SE,Sweden,EURO,1204,65163,11,5437
2020-06-29,SE,Sweden,EURO,755,65918,14,5451
2020-06-30,SE,Sweden,EURO,415,66333,23,5474
2020-07-01,SE,Sweden,EURO,726,67059,16,5490
2020-07-02,SE,Sweden,EURO,808,67867,20,5510
2020-07-03,SE,Sweden,EURO,685,68552,15,5525
2020-07-04,SE,Sweden,EURO,687,69239,15,5540
2020-07-05,SE,Sweden,EURO,694,69933,8,5548
2020-07-06,SE,Sweden,EURO,364,70297,15,5563
2020-07-07,SE,Sweden,EURO,315,70612,9,5572
2020-07-08,SE,Sweden,EURO,251,70863,15,5587
2020-07-09,SE,Sweden,EURO,278,71141,12,5599
2020-07-10,SE,Sweden,EURO,533,71674,10,5609
2020-07-11,SE,Sweden,EURO,334,72008,15,5624
2020-07-12,SE,Sweden,EURO,369,72377,14,5638
2020-07-13,SE,Sweden,EURO,308,72685,10,5648
2020-07-14,SE,Sweden,EURO,106,72791,8,5656
2020-07-15,SE,Sweden,EURO,170,72961,12,5668
2020-07-16,SE,Sweden,EURO,312,73273,8,5676
2020-07-17,SE,Sweden,EURO,287,73560,6,5682
2020-07-18,SE,Sweden,EURO,268,73828,6,5688
2020-07-19,SE,Sweden,EURO,284,74112,7,5695
2020-07-20,SE,Sweden,EURO,191,74303,11,5706
2020-07-21,SE,Sweden,EURO,110,74413,7,5713
2020-07-22,SE,Sweden,EURO,131,74544,6,5719
2020-07-23,SE,Sweden,EURO,226,74770,7,5726
2020-07-24,SE,Sweden,EURO,297,75067,6,5732
2020-07-25,SE,Sweden,EURO,220,75287,5,5737
2020-07-26,SE,Sweden,EURO,262,75549,3,5740
2020-07-27,SE,Sweden,EURO,138,75687,1,5741
2020-07-28,SE,Sweden,EURO,42,75729,2,5743
2020-07-29,SE,Sweden,EURO,71,75800,6,5749
2020-07-30,SE,Sweden,EURO,283,76083,4,5753
2020-07-31,SE,Sweden,EURO,301,76384,1,5754
2020-08-01,SE,Sweden,EURO,302,76686,0,5754
2020-08-02,SE,Sweden,EURO,258,76944,2,5756
2020-08-03,SE,Sweden,EURO,303,77247,2,5758
2020-08-04,SE,Sweden,EURO,38,77285,3,5761
2020-08-05,SE,Sweden,EURO,165,77450,4,5765
2020-08-06,SE,Sweden,EURO,333,77783,2,5767
2020-08-07,SE,Sweden,EURO,425,78208,1,5768
2020-08-08,SE,Sweden,EURO,378,78586,4,5772
2020-08-09,SE,Sweden,EURO,380,78966,2,5774
2020-08-10,SE,Sweden,EURO,260,79226,1,5775
2020-08-11,SE,Sweden,EURO,73,79299,4,5779
2020-08-12,SE,Sweden,EURO,196,79495,2,5781
2020-08-13,SE,Sweden,EURO,417,79912,4,5785
2020-08-14,SE,Sweden,EURO,443,80355,3,5788
2020-08-15,SE,Sweden,EURO,363,80718,5,5793
2020-08-16,SE,Sweden,EURO,344,81062,1,5794
2020-08-17,SE,Sweden,EURO,226,81288,1,5795
2020-08-18,SE,Sweden,EURO,63,81351,0,5795
2020-08-19,SE,Sweden,EURO,174,81525,3,5798
2020-08-20,SE,Sweden,EURO,314,81839,4,5802
2020-08-21,SE,Sweden,EURO,351,82190,1,5803
2020-08-22,SE,Sweden,EURO,333,82523,2,5805
2020-08-23,SE,Sweden,EURO,298,82821,5,5810
2020-08-24,SE,Sweden,EURO,160,82981,1,5811
2020-08-25,SE,Sweden,EURO,57,83038,3,5814
2020-08-26,SE,Sweden,EURO,174,83212,1,5815
2020-08-27,SE,Sweden,EURO,222,83434,1,5816
2020-08-28,SE,Sweden,EURO,244,83678,2,5818
2020-08-29,SE,Sweden,EURO,202,83880,1,5819
2020-08-30,SE,Sweden,EURO,179,84059,1,5820
2020-08-31,SE,Sweden,EURO,131,84190,1,5821
2020-09-01,SE,Sweden,EURO,48,84238,3,5824
2020-09-02,SE,Sweden,EURO,162,84400,2,5826
2020-09-03,SE,Sweden,EURO,171,84571,3,5829
2020-09-04,SE,Sweden,EURO,213,84784,2,5831
2020-09-05,SE,Sweden,EURO,286,85070,2,5833
2020-09-06,SE,Sweden,EURO,262,85332,0,5833
2020-09-07,SE,Sweden,EURO,171,85503,0,5833
2020-09-08,SE,Sweden,EURO,67,85570,3,5836
2020-09-09,SE,Sweden,EURO,185,85755,1,5837
2020-09-10,SE,Sweden,EURO,236,85991,1,5838
2020-09-11,SE,Sweden,EURO,314,86305,2,5840
2020-09-12,SE,Sweden,EURO,254,86559,2,5842
2020-09-13,SE,Sweden,EURO,291,86850,4,5846
2020-09-14,SE,Sweden,EURO,206,87056,1,5847
2020-09-15,SE,Sweden,EURO,106,87162,2,5849
2020-09-16,SE,Sweden,EURO,220,87382,2,5851
2020-09-17,SE,Sweden,EURO,292,87674,1,5852
2020-09-18,SE,Sweden,EURO,330,88004,2,5854
2020-09-19,SE,Sweden,EURO,389,88393,1,5855
2020-09-20,SE,Sweden,EURO,437,88830,1,5856
2020-09-21,SE,Sweden,EURO,279,89109,1,5857
2020-09-22,SE,Sweden,EURO,133,89242,4,5861
2020-09-23,SE,Sweden,EURO,266,89508,2,5863
2020-09-24,SE,Sweden,EURO,438,89946,1,5864
2020-09-25,SE,Sweden,EURO,553,90499,0,5864
2020-09-26,SE,Sweden,EURO,540,91039,1,5865
2020-09-27,SE,Sweden,EURO,630,91669,4,5869
2020-09-28,SE,Sweden,EURO,325,91994,2,5871
2020-09-29,SE,Sweden,EURO,167,92161,1,5872
2020-09-30,SE,Sweden,EURO,378,92539,1,5873
2020-10-01,SE,Sweden,EURO,613,93152,2,5875
2020-10-02,SE,Sweden,EURO,689,93841,4,5879
2020-10-03,SE,Sweden,EURO,633,94474,1,5880
2020-10-04,SE,Sweden,EURO,712,95186,3,5883
2020-10-05,SE,Sweden,EURO,461,95647,3,5886
2020-10-06,SE,Sweden,EURO,156,95803,3,5889
2020-10-07,SE,Sweden,EURO,374,96177,2,5891
2020-10-08,SE,Sweden,EURO,786,96963,4,5895
2020-10-09,SE,Sweden,EURO,831,97794,3,5898
2020-10-10,SE,Sweden,EURO,834,98628,1,5899
2020-10-11,SE,Sweden,EURO,783,99411,5,5904
2020-10-12,SE,Sweden,EURO,509,99920,5,5909
2020-10-13,SE,Sweden,EURO,161,100081,2,5911
2020-10-14,SE,Sweden,EURO,637,100718,3,5914
2020-10-15,SE,Sweden,EURO,916,101634,1,5915
2020-10-16,SE,Sweden,EURO,968,102602,2,5917
2020-10-17,SE,Sweden,EURO,902,103504,3,5920
2020-10-18,SE,Sweden,EURO,1179,104683,2,5922
2020-10-19,SE,Sweden,EURO,697,105380,4,5926
2020-10-20,SE,Sweden,EURO,321,105701,1,5927
2020-10-21,SE,Sweden,EURO,771,106472,4,5931
2020-10-22,SE,Sweden,EURO,1289,107761,4,5935
2020-10-23,SE,Sweden,EURO,1571,109332,3,5938
2020-10-24,SE,Sweden,EURO,1666,110998,9,5947
2020-10-25,SE,Sweden,EURO,1867,112865,7,5954
2020-10-26,SE,Sweden,EURO,1477,114342,8,5962
2020-10-27,SE,Sweden,EURO,514,114856,8,5970
2020-10-28,SE,Sweden,EURO,1069,115925,11,5981
2020-10-29,SE,Sweden,EURO,2414,118339,9,5990
2020-10-30,SE,Sweden,EURO,3389,121728,9,5999
2020-10-31,SE,Sweden,EURO,3262,124990,9,6008
2020-11-01,SE,Sweden,EURO,4056,129046,9,6017
2020-11-02,SE,Sweden,EURO,2987,132033,13,6030
2020-11-03,SE,Sweden,EURO,1297,133330,22,6052
2020-11-04,SE,Sweden,EURO,1569,134899,20,6072
2020-11-05,SE,Sweden,EURO,3608,138507,20,6092
2020-11-06,SE,Sweden,EURO,4482,142989,21,6113
2020-11-07,SE,Sweden,EURO,4744,147733,22,6135
2020-11-08,SE,Sweden,EURO,4454,152187,25,6160
2020-11-09,SE,Sweden,EURO,4451,156638,27,6187
2020-11-10,SE,Sweden,EURO,2097,158735,22,6209
2020-11-11,SE,Sweden,EURO,3725,162460,35,6244
2020-11-12,SE,Sweden,EURO,4497,166957,35,6279
2020-11-13,SE,Sweden,EURO,5709,172666,27,6306
2020-11-14,SE,Sweden,EURO,5564,178230,28,6334
2020-11-15,SE,Sweden,EURO,6730,184960,33,6367
2020-11-16,SE,Sweden,EURO,3513,188473,38,6405
2020-11-17,SE,Sweden,EURO,1581,190054,39,6444
2020-11-18,SE,Sweden,EURO,2544,192598,37,6481
2020-11-19,SE,Sweden,EURO,4458,197056,44,6525
2020-11-20,SE,Sweden,EURO,4961,202017,50,6575
2020-11-21,SE,Sweden,EURO,7609,209626,46,6621
2020-11-22,SE,Sweden,EURO,5458,215084,45,6666
2020-11-23,SE,Sweden,EURO,4492,219576,51,6717
2020-11-24,SE,Sweden,EURO,2422,221998,59,6776
2020-11-25,SE,Sweden,EURO,3877,225875,55,6831
2020-11-26,SE,Sweden,EURO,5674,231549,68,6899
2020-11-27,SE,Sweden,EURO,6066,237615,69,6968
2020-11-28,SE,Sweden,EURO,6903,244518,60,7028
2020-11-29,SE,Sweden,EURO,6462,250980,65,7093
2020-11-30,SE,Sweden,EURO,3825,254805,50,7143
2020-12-01,SE,Sweden,EURO,2753,257558,50,7193
2020-12-02,SE,Sweden,EURO,3480,261038,67,7260
2020-12-03,SE,Sweden,EURO,5819,266857,67,7327
2020-12-04,SE,Sweden,EURO,6547,273404,71,7398
2020-12-05,SE,Sweden,EURO,6986,280390,77,7475
2020-12-06,SE,Sweden,EURO,7338,287728,70,7545
2020-12-07,SE,Sweden,EURO,4864,292592,43,7588
2020-12-08,SE,Sweden,EURO,1803,294395,81,7669
2020-12-09,SE,Sweden,EURO,3782,298177,58,7727
2020-12-10,SE,Sweden,EURO,7446,305623,54,7781
2020-12-11,SE,Sweden,EURO,8398,314021,75,7856
2020-12-12,SE,Sweden,EURO,6693,320714,86,7942
2020-12-13,SE,Sweden,EURO,7717,328431,89,8031
2020-12-14,SE,Sweden,EURO,6538,334969,68,8099
2020-12-15,SE,Sweden,EURO,3057,338026,71,8170
2020-12-16,SE,Sweden,EURO,3534,341560,94,8264
2020-12-17,SE,Sweden,EURO,7001,348561,88,8352
2020-12-18,SE,Sweden,EURO,8824,357385,102,8454
2020-12-19,SE,Sweden,EURO,9640,367025,116,8570
2020-12-20,SE,Sweden,EURO,7917,374942,71,8641
2020-12-21,SE,Sweden,EURO,5509,380451,80,8721
2020-12-22,SE,Sweden,EURO,3752,384203,94,8815
2020-12-23,SE,Sweden,EURO,5160,389363,76,8891
2020-12-24,SE,Sweden,EURO,6595,395958,93,8984
2020-12-25,SE,Sweden,EURO,11376,407334,87,9071
2020-12-26,SE,Sweden,EURO,5036,412370,88,9159
2020-12-27,SE,Sweden,EURO,2793,415163,106,9265
2020-12-28,SE,Sweden,EURO,2966,418129,94,9359
2020-12-29,SE,Sweden,EURO,3208,421337,99,9458
2020-12-30,SE,Sweden,EURO,7091,428428,121,9579
2020-12-31,SE,Sweden,EURO,8872,437300,73,9652
2021-01-01,SE,Sweden,EURO,10459,447759,90,9742
2021-01-02,SE,Sweden,EURO,6999,454758,110,9852
2021-01-03,SE,Sweden,EURO,2618,457376,87,9939
.
158485,158486c
2020-03-12,SE,Sweden,EURO,98,424,1,1
2020-03-13,SE,Sweden,EURO,196,620,0,1
.
158415a
2022-02-10,SR,Suriname,AMRO,350,76239,3,1288
.
157646c
2022-02-09,SD,Sudan,EMRO,110,59455,6,3764
2022-02-10,SD,Sudan,EMRO,0,59455,0,3764
.
156877a
2022-02-10,LK,Sri Lanka,SEARO,0,623248,0,15692
.
155426,156108c
2020-03-29,ES,Spain,EURO,12966,100065,959,6977
2020-03-30,ES,Spain,EURO,7096,107161,839,7816
2020-03-31,ES,Spain,EURO,5092,112253,811,8627
2020-04-01,ES,Spain,EURO,8008,120261,913,9540
2020-04-02,ES,Spain,EURO,7925,128186,899,10439
2020-04-03,ES,Spain,EURO,7058,135244,895,11334
2020-04-04,ES,Spain,EURO,6905,142149,858,12192
2020-04-05,ES,Spain,EURO,6821,148970,786,12978
2020-04-06,ES,Spain,EURO,4670,153640,740,13718
2020-04-07,ES,Spain,EURO,3147,156787,750,14468
2020-04-08,ES,Spain,EURO,5396,162183,766,15234
2020-04-09,ES,Spain,EURO,5324,167507,736,15970
2020-04-10,ES,Spain,EURO,5488,172995,749,16719
2020-04-11,ES,Spain,EURO,4609,177604,667,17386
2020-04-12,ES,Spain,EURO,4438,182042,676,18062
2020-04-13,ES,Spain,EURO,3075,185117,628,18690
2020-04-14,ES,Spain,EURO,2379,187496,544,19234
2020-04-15,ES,Spain,EURO,3127,190623,587,19821
2020-04-16,ES,Spain,EURO,3993,194616,607,20428
2020-04-17,ES,Spain,EURO,3702,198318,552,20980
2020-04-18,ES,Spain,EURO,3417,201735,487,21467
2020-04-19,ES,Spain,EURO,3462,205197,507,21974
2020-04-20,ES,Spain,EURO,2181,207378,435,22409
2020-04-21,ES,Spain,EURO,1446,208824,401,22810
2020-04-22,ES,Spain,EURO,2518,211342,387,23197
2020-04-23,ES,Spain,EURO,2728,214070,427,23624
2020-04-24,ES,Spain,EURO,2770,216840,344,23968
2020-04-25,ES,Spain,EURO,2222,219062,331,24299
2020-04-26,ES,Spain,EURO,2284,221346,330,24629
2020-04-27,ES,Spain,EURO,1292,222638,295,24924
2020-04-28,ES,Spain,EURO,818,223456,272,25196
2020-04-29,ES,Spain,EURO,1653,225109,258,25454
2020-04-30,ES,Spain,EURO,1736,226845,259,25713
2020-05-01,ES,Spain,EURO,1484,228329,236,25949
2020-05-02,ES,Spain,EURO,1438,229767,223,26172
2020-05-03,ES,Spain,EURO,792,230559,176,26348
2020-05-04,ES,Spain,EURO,566,231125,202,26550
2020-05-05,ES,Spain,EURO,452,231577,197,26747
2020-05-06,ES,Spain,EURO,1013,232590,186,26933
2020-05-07,ES,Spain,EURO,980,233570,183,27116
2020-05-08,ES,Spain,EURO,981,234551,153,27269
2020-05-09,ES,Spain,EURO,956,235507,166,27435
2020-05-10,ES,Spain,EURO,917,236424,146,27581
2020-05-11,ES,Spain,EURO,491,236915,125,27706
2020-05-12,ES,Spain,EURO,317,237232,110,27816
2020-05-13,ES,Spain,EURO,737,237969,122,27938
2020-05-14,ES,Spain,EURO,698,238667,113,28051
2020-05-15,ES,Spain,EURO,793,239460,87,28138
2020-05-16,ES,Spain,EURO,778,240238,86,28224
2020-05-17,ES,Spain,EURO,787,241025,77,28301
2020-05-18,ES,Spain,EURO,342,241367,63,28364
2020-05-19,ES,Spain,EURO,240,241607,61,28425
2020-05-20,ES,Spain,EURO,617,242224,72,28497
2020-05-21,ES,Spain,EURO,824,243048,70,28567
2020-05-22,ES,Spain,EURO,729,243777,57,28624
2020-05-23,ES,Spain,EURO,767,244544,70,28694
2020-05-24,ES,Spain,EURO,797,245341,71,28765
2020-05-25,ES,Spain,EURO,303,245644,60,28825
2020-05-26,ES,Spain,EURO,259,245903,55,28880
2020-05-27,ES,Spain,EURO,537,246440,68,28948
2020-05-28,ES,Spain,EURO,733,247173,55,29003
2020-05-29,ES,Spain,EURO,602,247775,45,29048
2020-05-30,ES,Spain,EURO,645,248420,41,29089
2020-05-31,ES,Spain,EURO,708,249128,45,29134
2020-06-01,ES,Spain,EURO,331,249459,43,29177
2020-06-02,ES,Spain,EURO,178,249637,40,29217
2020-06-03,ES,Spain,EURO,345,249982,35,29252
2020-06-04,ES,Spain,EURO,457,250439,47,29299
2020-06-05,ES,Spain,EURO,574,251013,39,29338
2020-06-06,ES,Spain,EURO,487,251500,48,29386
2020-06-07,ES,Spain,EURO,636,252136,23,29409
2020-06-08,ES,Spain,EURO,257,252393,29,29438
2020-06-09,ES,Spain,EURO,143,252536,21,29459
2020-06-10,ES,Spain,EURO,330,252866,29,29488
2020-06-11,ES,Spain,EURO,434,253300,15,29503
2020-06-12,ES,Spain,EURO,441,253741,31,29534
2020-06-13,ES,Spain,EURO,373,254114,24,29558
2020-06-14,ES,Spain,EURO,481,254595,19,29577
2020-06-15,ES,Spain,EURO,121,254716,23,29600
2020-06-16,ES,Spain,EURO,84,254800,20,29620
2020-06-17,ES,Spain,EURO,286,255086,20,29640
2020-06-18,ES,Spain,EURO,376,255462,11,29651
2020-06-19,ES,Spain,EURO,340,255802,25,29676
2020-06-20,ES,Spain,EURO,364,256166,12,29688
2020-06-21,ES,Spain,EURO,340,256506,18,29706
2020-06-22,ES,Spain,EURO,226,256732,14,29720
2020-06-23,ES,Spain,EURO,163,256895,15,29735
2020-06-24,ES,Spain,EURO,236,257131,7,29742
2020-06-25,ES,Spain,EURO,434,257565,8,29750
2020-06-26,ES,Spain,EURO,330,257895,12,29762
2020-06-27,ES,Spain,EURO,357,258252,11,29773
2020-06-28,ES,Spain,EURO,471,258723,9,29782
2020-06-29,ES,Spain,EURO,251,258974,3,29785
2020-06-30,ES,Spain,EURO,190,259164,12,29797
2020-07-01,ES,Spain,EURO,274,259438,11,29808
2020-07-02,ES,Spain,EURO,444,259882,11,29819
2020-07-03,ES,Spain,EURO,457,260339,10,29829
2020-07-04,ES,Spain,EURO,483,260822,1,29830
2020-07-05,ES,Spain,EURO,592,261414,5,29835
2020-07-06,ES,Spain,EURO,295,261709,7,29842
2020-07-07,ES,Spain,EURO,208,261917,1,29843
2020-07-08,ES,Spain,EURO,340,262257,3,29846
2020-07-09,ES,Spain,EURO,708,262965,6,29852
2020-07-10,ES,Spain,EURO,738,263703,4,29856
2020-07-11,ES,Spain,EURO,848,264551,1,29857
2020-07-12,ES,Spain,EURO,1147,265698,5,29862
2020-07-13,ES,Spain,EURO,614,266312,7,29869
2020-07-14,ES,Spain,EURO,387,266699,2,29871
2020-07-15,ES,Spain,EURO,852,267551,2,29873
2020-07-16,ES,Spain,EURO,1255,268806,3,29876
2020-07-17,ES,Spain,EURO,1557,270363,5,29881
2020-07-18,ES,Spain,EURO,1624,271987,2,29883
2020-07-19,ES,Spain,EURO,2071,274058,2,29885
2020-07-20,ES,Spain,EURO,1516,275574,4,29889
2020-07-21,ES,Spain,EURO,1149,276723,6,29895
2020-07-22,ES,Spain,EURO,1589,278312,8,29903
2020-07-23,ES,Spain,EURO,2320,280632,8,29911
2020-07-24,ES,Spain,EURO,2332,282964,4,29915
2020-07-25,ES,Spain,EURO,2363,285327,4,29919
2020-07-26,ES,Spain,EURO,2845,288172,8,29927
2020-07-27,ES,Spain,EURO,1714,289886,11,29938
2020-07-28,ES,Spain,EURO,1379,291265,7,29945
2020-07-29,ES,Spain,EURO,2039,293304,10,29955
2020-07-30,ES,Spain,EURO,2900,296204,13,29968
2020-07-31,ES,Spain,EURO,3150,299354,11,29979
2020-08-01,ES,Spain,EURO,3410,302764,12,29991
2020-08-02,ES,Spain,EURO,3822,306586,16,30007
2020-08-03,ES,Spain,EURO,3050,309636,12,30019
2020-08-04,ES,Spain,EURO,1841,311477,15,30034
2020-08-05,ES,Spain,EURO,2709,314186,12,30046
2020-08-06,ES,Spain,EURO,4405,318591,20,30066
2020-08-07,ES,Spain,EURO,4287,322878,13,30079
2020-08-08,ES,Spain,EURO,4816,327694,30,30109
2020-08-09,ES,Spain,EURO,5656,333350,23,30132
2020-08-10,ES,Spain,EURO,3498,336848,31,30163
2020-08-11,ES,Spain,EURO,2626,339474,18,30181
2020-08-12,ES,Spain,EURO,3848,343322,31,30212
2020-08-13,ES,Spain,EURO,5991,349313,31,30243
2020-08-14,ES,Spain,EURO,6393,355706,29,30272
2020-08-15,ES,Spain,EURO,7010,362716,25,30297
2020-08-16,ES,Spain,EURO,8329,371045,37,30334
2020-08-17,ES,Spain,EURO,4828,375873,30,30364
2020-08-18,ES,Spain,EURO,3296,379169,23,30387
2020-08-19,ES,Spain,EURO,4970,384139,31,30418
2020-08-20,ES,Spain,EURO,8463,392602,44,30462
2020-08-21,ES,Spain,EURO,8634,401236,47,30509
2020-08-22,ES,Spain,EURO,9021,410257,41,30550
2020-08-23,ES,Spain,EURO,10481,420738,44,30594
2020-08-24,ES,Spain,EURO,6054,426792,44,30638
2020-08-25,ES,Spain,EURO,4296,431088,55,30693
2020-08-26,ES,Spain,EURO,6035,437123,55,30748
2020-08-27,ES,Spain,EURO,10315,447438,44,30792
2020-08-28,ES,Spain,EURO,10297,457735,51,30843
2020-08-29,ES,Spain,EURO,10320,468055,49,30892
2020-08-30,ES,Spain,EURO,11956,480011,70,30962
2020-08-31,ES,Spain,EURO,6871,486882,53,31015
2020-09-01,ES,Spain,EURO,5181,492063,59,31074
2020-09-02,ES,Spain,EURO,6640,498703,65,31139
2020-09-03,ES,Spain,EURO,10471,509174,68,31207
2020-09-04,ES,Spain,EURO,10713,519887,79,31286
2020-09-05,ES,Spain,EURO,10959,530846,80,31366
2020-09-06,ES,Spain,EURO,13191,544037,80,31446
2020-09-07,ES,Spain,EURO,7881,551918,68,31514
2020-09-08,ES,Spain,EURO,5491,557409,61,31575
2020-09-09,ES,Spain,EURO,7037,564446,80,31655
2020-09-10,ES,Spain,EURO,11950,576396,84,31739
2020-09-11,ES,Spain,EURO,12788,589184,95,31834
2020-09-12,ES,Spain,EURO,12993,602177,96,31930
2020-09-13,ES,Spain,EURO,14409,616586,96,32026
2020-09-14,ES,Spain,EURO,8314,624900,102,32128
2020-09-15,ES,Spain,EURO,6402,631302,106,32234
2020-09-16,ES,Spain,EURO,8191,639493,109,32343
2020-09-17,ES,Spain,EURO,13807,653300,137,32480
2020-09-18,ES,Spain,EURO,14021,667321,109,32589
2020-09-19,ES,Spain,EURO,13783,681104,124,32713
2020-09-20,ES,Spain,EURO,16734,697838,115,32828
2020-09-21,ES,Spain,EURO,8328,706166,123,32951
2020-09-22,ES,Spain,EURO,5857,712023,103,33054
2020-09-23,ES,Spain,EURO,8023,720046,123,33177
2020-09-24,ES,Spain,EURO,12796,732842,127,33304
2020-09-25,ES,Spain,EURO,12747,745589,111,33415
2020-09-26,ES,Spain,EURO,12656,758245,133,33548
2020-09-27,ES,Spain,EURO,13533,771778,131,33679
2020-09-28,ES,Spain,EURO,7642,779420,116,33795
2020-09-29,ES,Spain,EURO,5045,784465,120,33915
2020-09-30,ES,Spain,EURO,7070,791535,141,34056
2020-10-01,ES,Spain,EURO,11323,802858,147,34203
2020-10-02,ES,Spain,EURO,11196,814054,153,34356
2020-10-03,ES,Spain,EURO,11055,825109,135,34491
2020-10-04,ES,Spain,EURO,12380,837489,132,34623
2020-10-05,ES,Spain,EURO,6884,844373,106,34729
2020-10-06,ES,Spain,EURO,5130,849503,96,34825
2020-10-07,ES,Spain,EURO,8875,858378,127,34952
2020-10-08,ES,Spain,EURO,12232,870610,132,35084
2020-10-09,ES,Spain,EURO,12408,883018,132,35216
2020-10-10,ES,Spain,EURO,13864,896882,134,35350
2020-10-11,ES,Spain,EURO,14787,911669,150,35500
2020-10-12,ES,Spain,EURO,8720,920389,137,35637
2020-10-13,ES,Spain,EURO,6762,927151,113,35750
2020-10-14,ES,Spain,EURO,6330,933481,128,35878
2020-10-15,ES,Spain,EURO,12373,945854,148,36026
2020-10-16,ES,Spain,EURO,16377,962231,141,36167
2020-10-17,ES,Spain,EURO,17520,979751,148,36315
2020-10-18,ES,Spain,EURO,18275,998026,150,36465
2020-10-19,ES,Spain,EURO,11946,1009972,132,36597
2020-10-20,ES,Spain,EURO,8249,1018221,152,36749
2020-10-21,ES,Spain,EURO,15678,1033899,175,36924
2020-10-22,ES,Spain,EURO,20918,1054817,188,37112
2020-10-23,ES,Spain,EURO,23234,1078051,176,37288
2020-10-24,ES,Spain,EURO,23829,1101880,209,37497
2020-10-25,ES,Spain,EURO,25023,1126903,216,37713
2020-10-26,ES,Spain,EURO,15445,1142348,192,37905
2020-10-27,ES,Spain,EURO,11276,1153624,195,38100
2020-10-28,ES,Spain,EURO,20005,1173629,218,38318
2020-10-29,ES,Spain,EURO,24345,1197974,242,38560
2020-10-30,ES,Spain,EURO,24640,1222614,247,38807
2020-10-31,ES,Spain,EURO,24207,1246821,254,39061
2020-11-01,ES,Spain,EURO,24953,1271774,263,39324
2020-11-02,ES,Spain,EURO,16086,1287860,269,39593
2020-11-03,ES,Spain,EURO,10977,1298837,268,39861
2020-11-04,ES,Spain,EURO,15514,1314351,304,40165
2020-11-05,ES,Spain,EURO,22053,1336404,325,40490
2020-11-06,ES,Spain,EURO,24143,1360547,356,40846
2020-11-07,ES,Spain,EURO,23564,1384111,331,41177
2020-11-08,ES,Spain,EURO,23520,1407631,355,41532
2020-11-09,ES,Spain,EURO,14582,1422213,287,41819
2020-11-10,ES,Spain,EURO,9847,1432060,319,42138
2020-11-11,ES,Spain,EURO,16535,1448595,320,42458
2020-11-12,ES,Spain,EURO,20589,1469184,350,42808
2020-11-13,ES,Spain,EURO,19993,1489177,362,43170
2020-11-14,ES,Spain,EURO,19166,1508343,359,43529
2020-11-15,ES,Spain,EURO,18425,1526768,357,43886
2020-11-16,ES,Spain,EURO,10587,1537355,302,44188
2020-11-17,ES,Spain,EURO,6664,1544019,287,44475
2020-11-18,ES,Spain,EURO,12800,1556819,326,44801
2020-11-19,ES,Spain,EURO,15866,1572685,377,45178
2020-11-20,ES,Spain,EURO,14808,1587493,296,45474
2020-11-21,ES,Spain,EURO,13179,1600672,315,45789
2020-11-22,ES,Spain,EURO,12633,1613305,323,46112
2020-11-23,ES,Spain,EURO,7238,1620543,283,46395
2020-11-24,ES,Spain,EURO,4609,1625152,252,46647
2020-11-25,ES,Spain,EURO,9131,1634283,297,46944
2020-11-26,ES,Spain,EURO,10939,1645222,244,47188
2020-11-27,ES,Spain,EURO,9981,1655203,294,47482
2020-11-28,ES,Spain,EURO,9633,1664836,293,47775
2020-11-29,ES,Spain,EURO,9922,1674758,269,48044
2020-11-30,ES,Spain,EURO,5509,1680267,221,48265
2020-12-01,ES,Spain,EURO,3418,1683685,222,48487
2020-12-02,ES,Spain,EURO,7420,1691105,229,48716
2020-12-03,ES,Spain,EURO,9505,1700610,231,48947
2020-12-04,ES,Spain,EURO,8880,1709490,221,49168
2020-12-05,ES,Spain,EURO,8136,1717626,238,49406
2020-12-06,ES,Spain,EURO,8422,1726048,233,49639
2020-12-07,ES,Spain,EURO,4956,1731004,195,49834
2020-12-08,ES,Spain,EURO,3275,1734279,173,50007
2020-12-09,ES,Spain,EURO,5223,1739502,203,50210
2020-12-10,ES,Spain,EURO,4033,1743535,169,50379
2020-12-11,ES,Spain,EURO,8409,1751944,224,50603
2020-12-12,ES,Spain,EURO,10750,1762694,187,50790
2020-12-13,ES,Spain,EURO,11315,1774009,211,51001
2020-12-14,ES,Spain,EURO,6588,1780597,185,51186
2020-12-15,ES,Spain,EURO,4240,1784837,162,51348
2020-12-16,ES,Spain,EURO,9895,1794732,165,51513
2020-12-17,ES,Spain,EURO,12165,1806897,186,51699
2020-12-18,ES,Spain,EURO,11732,1818629,150,51849
2020-12-19,ES,Spain,EURO,10966,1829595,177,52026
2020-12-20,ES,Spain,EURO,12202,1841797,176,52202
2020-12-21,ES,Spain,EURO,6914,1848711,141,52343
2020-12-22,ES,Spain,EURO,4391,1853102,156,52499
2020-12-23,ES,Spain,EURO,10992,1864094,148,52647
2020-12-24,ES,Spain,EURO,13394,1877488,184,52831
2020-12-25,ES,Spain,EURO,14499,1891987,195,53026
2020-12-26,ES,Spain,EURO,9984,1901971,157,53183
2020-12-27,ES,Spain,EURO,4822,1906793,146,53329
2020-12-28,ES,Spain,EURO,6398,1913191,176,53505
2020-12-29,ES,Spain,EURO,5987,1919178,166,53671
2020-12-30,ES,Spain,EURO,15082,1934260,195,53866
2020-12-31,ES,Spain,EURO,18897,1953157,166,54032
2021-01-01,ES,Spain,EURO,21121,1974278,200,54232
2021-01-02,ES,Spain,EURO,15591,1989869,192,54424
2021-01-03,ES,Spain,EURO,7651,1997520,174,54598
2021-01-04,ES,Spain,EURO,10462,2007982,188,54786
2021-01-05,ES,Spain,EURO,9965,2017947,179,54965
2021-01-06,ES,Spain,EURO,22130,2040077,192,55157
2021-01-07,ES,Spain,EURO,30733,2070810,243,55400
2021-01-08,ES,Spain,EURO,14582,2085392,180,55580
2021-01-09,ES,Spain,EURO,26781,2112173,238,55818
2021-01-10,ES,Spain,EURO,32855,2145028,242,56060
2021-01-11,ES,Spain,EURO,19300,2164328,230,56290
2021-01-12,ES,Spain,EURO,13905,2178233,243,56533
2021-01-13,ES,Spain,EURO,32464,2210697,286,56819
2021-01-14,ES,Spain,EURO,37344,2248041,284,57103
2021-01-15,ES,Spain,EURO,38956,2286997,292,57395
2021-01-16,ES,Spain,EURO,38360,2325357,319,57714
2021-01-17,ES,Spain,EURO,42922,2368279,393,58107
2021-01-18,ES,Spain,EURO,24999,2393278,366,58473
2021-01-19,ES,Spain,EURO,18623,2411901,367,58840
2021-01-20,ES,Spain,EURO,35727,2447628,412,59252
2021-01-21,ES,Spain,EURO,42387,2490015,490,59742
2021-01-22,ES,Spain,EURO,41863,2531878,459,60201
2021-01-23,ES,Spain,EURO,40796,2572674,491,60692
2021-01-24,ES,Spain,EURO,42178,2614852,568,61260
2021-01-25,ES,Spain,EURO,23812,2638664,453,61713
2021-01-26,ES,Spain,EURO,17326,2655990,518,62231
2021-01-27,ES,Spain,EURO,32759,2688749,529,62760
2021-01-28,ES,Spain,EURO,37441,2726190,550,63310
2021-01-29,ES,Spain,EURO,35843,2762033,595,63905
2021-01-30,ES,Spain,EURO,33347,2795380,576,64481
2021-01-31,ES,Spain,EURO,32344,2827724,533,65014
2021-02-01,ES,Spain,EURO,18173,2845897,515,65529
2021-02-02,ES,Spain,EURO,11711,2857608,486,66015
2021-02-03,ES,Spain,EURO,22499,2880107,544,66559
2021-02-04,ES,Spain,EURO,25993,2906100,493,67052
2021-02-05,ES,Spain,EURO,23804,2929904,492,67544
2021-02-06,ES,Spain,EURO,21115,2951019,464,68008
2021-02-07,ES,Spain,EURO,20168,2971187,462,68470
2021-02-08,ES,Spain,EURO,10323,2981510,408,68878
2021-02-09,ES,Spain,EURO,6098,2987608,382,69260
2021-02-10,ES,Spain,EURO,13791,3001399,411,69671
2021-02-11,ES,Spain,EURO,15358,3016757,386,70057
2021-02-12,ES,Spain,EURO,13338,3030095,408,70465
2021-02-13,ES,Spain,EURO,11856,3041951,355,70820
2021-02-14,ES,Spain,EURO,11692,3053643,340,71160
2021-02-15,ES,Spain,EURO,5744,3059387,289,71449
2021-02-16,ES,Spain,EURO,3584,3062971,244,71693
2021-02-17,ES,Spain,EURO,8857,3071828,285,71978
2021-02-18,ES,Spain,EURO,9862,3081690,298,72276
2021-02-19,ES,Spain,EURO,8618,3090308,260,72536
2021-02-20,ES,Spain,EURO,8180,3098488,242,72778
2021-02-21,ES,Spain,EURO,7975,3106463,225,73003
2021-02-22,ES,Spain,EURO,4014,3110477,185,73188
2021-02-23,ES,Spain,EURO,2669,3113146,183,73371
2021-02-24,ES,Spain,EURO,6836,3119982,226,73597
2021-02-25,ES,Spain,EURO,7375,3127357,190,73787
2021-02-26,ES,Spain,EURO,6477,3133834,207,73994
2021-02-27,ES,Spain,EURO,6178,3140012,197,74191
2021-02-28,ES,Spain,EURO,6464,3146476,176,74367
2021-03-01,ES,Spain,EURO,3212,3149688,162,74529
2021-03-02,ES,Spain,EURO,2242,3151930,149,74678
2021-03-03,ES,Spain,EURO,5383,3157313,134,74812
2021-03-04,ES,Spain,EURO,5892,3163205,154,74966
2021-03-05,ES,Spain,EURO,5952,3169157,142,75108
2021-03-06,ES,Spain,EURO,5605,3174762,136,75244
2021-03-07,ES,Spain,EURO,5730,3180492,131,75375
2021-03-08,ES,Spain,EURO,2860,3183352,126,75501
2021-03-09,ES,Spain,EURO,2050,3185402,98,75599
2021-03-10,ES,Spain,EURO,5121,3190523,119,75718
2021-03-11,ES,Spain,EURO,5672,3196195,117,75835
2021-03-12,ES,Spain,EURO,5526,3201721,102,75937
2021-03-13,ES,Spain,EURO,5369,3207090,97,76034
2021-03-14,ES,Spain,EURO,5823,3212913,107,76141
2021-03-15,ES,Spain,EURO,2833,3215746,85,76226
2021-03-16,ES,Spain,EURO,1973,3217719,78,76304
2021-03-17,ES,Spain,EURO,5585,3223304,100,76404
2021-03-18,ES,Spain,EURO,6112,3229416,112,76516
2021-03-19,ES,Spain,EURO,5831,3235247,96,76612
2021-03-20,ES,Spain,EURO,6382,3241629,70,76682
2021-03-21,ES,Spain,EURO,4696,3246325,67,76749
2021-03-22,ES,Spain,EURO,2914,3249239,67,76816
2021-03-23,ES,Spain,EURO,2315,3251554,67,76883
2021-03-24,ES,Spain,EURO,6152,3257706,74,76957
2021-03-25,ES,Spain,EURO,7379,3265085,90,77047
2021-03-26,ES,Spain,EURO,6952,3272037,54,77101
2021-03-27,ES,Spain,EURO,7342,3279379,67,77168
2021-03-28,ES,Spain,EURO,7672,3287051,86,77254
2021-03-29,ES,Spain,EURO,4124,3291175,65,77319
2021-03-30,ES,Spain,EURO,2943,3294118,71,77390
2021-03-31,ES,Spain,EURO,7419,3301537,88,77478
2021-04-01,ES,Spain,EURO,8213,3309750,85,77563
2021-04-02,ES,Spain,EURO,9021,3318771,76,77639
2021-04-03,ES,Spain,EURO,5713,3324484,74,77713
2021-04-04,ES,Spain,EURO,3856,3328340,70,77783
2021-04-05,ES,Spain,EURO,4592,3332932,78,77861
2021-04-06,ES,Spain,EURO,4274,3337206,58,77919
2021-04-07,ES,Spain,EURO,7724,3344930,73,77992
2021-04-08,ES,Spain,EURO,10888,3355818,80,78072
2021-04-09,ES,Spain,EURO,10626,3366444,92,78164
2021-04-10,ES,Spain,EURO,10392,3376836,83,78247
2021-04-11,ES,Spain,EURO,10551,3387387,81,78328
2021-04-12,ES,Spain,EURO,5666,3393053,90,78418
2021-04-13,ES,Spain,EURO,3943,3396996,52,78470
2021-04-14,ES,Spain,EURO,9043,3406039,95,78565
2021-04-15,ES,Spain,EURO,10198,3416237,81,78646
2021-04-16,ES,Spain,EURO,10400,3426637,90,78736
2021-04-17,ES,Spain,EURO,9739,3436376,73,78809
2021-04-18,ES,Spain,EURO,10066,3446442,81,78890
2021-04-19,ES,Spain,EURO,5344,3451786,76,78966
2021-04-20,ES,Spain,EURO,3938,3455724,59,79025
2021-04-21,ES,Spain,EURO,8738,3464462,85,79110
2021-04-22,ES,Spain,EURO,10714,3475176,80,79190
2021-04-23,ES,Spain,EURO,9758,3484934,64,79254
2021-04-24,ES,Spain,EURO,9840,3494774,72,79326
2021-04-25,ES,Spain,EURO,9953,3504727,78,79404
2021-04-26,ES,Spain,EURO,5052,3509779,74,79478
2021-04-27,ES,Spain,EURO,3868,3513647,64,79542
2021-04-28,ES,Spain,EURO,8959,3522606,67,79609
2021-04-29,ES,Spain,EURO,9783,3532389,66,79675
2021-04-30,ES,Spain,EURO,9332,3541721,66,79741
2021-05-01,ES,Spain,EURO,8902,3550623,60,79801
2021-05-02,ES,Spain,EURO,9065,3559688,65,79866
2021-05-03,ES,Spain,EURO,3922,3563610,55,79921
2021-05-04,ES,Spain,EURO,3111,3566721,51,79972
2021-05-05,ES,Spain,EURO,6080,3572801,73,80045
2021-05-06,ES,Spain,EURO,7524,3580325,68,80113
2021-05-07,ES,Spain,EURO,7945,3588270,68,80181
2021-05-08,ES,Spain,EURO,6950,3595220,60,80241
2021-05-09,ES,Spain,EURO,7553,3602773,69,80310
2021-05-10,ES,Spain,EURO,3444,3606217,52,80362
2021-05-11,ES,Spain,EURO,2430,3608647,50,80412
2021-05-12,ES,Spain,EURO,6060,3614707,53,80465
2021-05-13,ES,Spain,EURO,5965,3620672,50,80515
2021-05-14,ES,Spain,EURO,5904,3626576,54,80569
2021-05-15,ES,Spain,EURO,5730,3632306,54,80623
2021-05-16,ES,Spain,EURO,5922,3638228,45,80668
2021-05-17,ES,Spain,EURO,2855,3641083,42,80710
2021-05-18,ES,Spain,EURO,2205,3643288,40,80750
2021-05-19,ES,Spain,EURO,5190,3648478,35,80785
2021-05-20,ES,Spain,EURO,6000,3654478,35,80820
2021-05-21,ES,Spain,EURO,5378,3659856,48,80868
2021-05-22,ES,Spain,EURO,5466,3665322,33,80901
2021-05-23,ES,Spain,EURO,5645,3670967,43,80944
2021-05-24,ES,Spain,EURO,2695,3673662,34,80978
2021-05-25,ES,Spain,EURO,1986,3675648,32,81010
2021-05-26,ES,Spain,EURO,4553,3680201,36,81046
2021-05-27,ES,Spain,EURO,5413,3685614,23,81069
2021-05-28,ES,Spain,EURO,5301,3690915,38,81107
2021-05-29,ES,Spain,EURO,5359,3696274,16,81123
2021-05-30,ES,Spain,EURO,5356,3701630,21,81144
2021-05-31,ES,Spain,EURO,2898,3704528,21,81165
2021-06-01,ES,Spain,EURO,1945,3706473,28,81193
2021-06-02,ES,Spain,EURO,4855,3711328,38,81231
2021-06-03,ES,Spain,EURO,5126,3716454,24,81255
2021-06-04,ES,Spain,EURO,5113,3721567,33,81288
2021-06-05,ES,Spain,EURO,4464,3726031,28,81316
2021-06-06,ES,Spain,EURO,4569,3730600,32,81348
2021-06-07,ES,Spain,EURO,2436,3733036,24,81372
2021-06-08,ES,Spain,EURO,1706,3734742,26,81398
2021-06-09,ES,Spain,EURO,4155,3738897,19,81417
2021-06-10,ES,Spain,EURO,4135,3743032,27,81444
2021-06-11,ES,Spain,EURO,4094,3747126,18,81462
2021-06-12,ES,Spain,EURO,4117,3751243,25,81487
2021-06-13,ES,Spain,EURO,3988,3755231,12,81499
2021-06-14,ES,Spain,EURO,2199,3757430,20,81519
2021-06-15,ES,Spain,EURO,1544,3758974,19,81538
2021-06-16,ES,Spain,EURO,3615,3762589,16,81554
2021-06-17,ES,Spain,EURO,4064,3766653,23,81577
2021-06-18,ES,Spain,EURO,3971,3770624,21,81598
2021-06-19,ES,Spain,EURO,3977,3774601,21,81619
2021-06-20,ES,Spain,EURO,3998,3778599,16,81635
2021-06-21,ES,Spain,EURO,2257,3780856,8,81643
2021-06-22,ES,Spain,EURO,1665,3782521,15,81658
2021-06-23,ES,Spain,EURO,3854,3786375,19,81677
2021-06-24,ES,Spain,EURO,4416,3790791,17,81694
2021-06-25,ES,Spain,EURO,5015,3795806,17,81711
2021-06-26,ES,Spain,EURO,3876,3799682,14,81725
2021-06-27,ES,Spain,EURO,5662,3805344,13,81738
2021-06-28,ES,Spain,EURO,3743,3809087,13,81751
2021-06-29,ES,Spain,EURO,3118,3812205,19,81770
2021-06-30,ES,Spain,EURO,8107,3820312,14,81784
2021-07-01,ES,Spain,EURO,10703,3831015,14,81798
2021-07-02,ES,Spain,EURO,13062,3844077,13,81811
2021-07-03,ES,Spain,EURO,14016,3858093,15,81826
2021-07-04,ES,Spain,EURO,14922,3873015,6,81832
2021-07-05,ES,Spain,EURO,10269,3883284,15,81847
2021-07-06,ES,Spain,EURO,7631,3890915,9,81856
2021-07-07,ES,Spain,EURO,16881,3907796,10,81866
2021-07-08,ES,Spain,EURO,20437,3928233,13,81879
2021-07-09,ES,Spain,EURO,23012,3951245,9,81888
2021-07-10,ES,Spain,EURO,22704,3973949,7,81895
2021-07-11,ES,Spain,EURO,24507,3998456,14,81909
2021-07-12,ES,Spain,EURO,15000,4013456,18,81927
2021-07-13,ES,Spain,EURO,12265,4025721,15,81942
2021-07-14,ES,Spain,EURO,25784,4051505,17,81959
2021-07-15,ES,Spain,EURO,28359,4079864,20,81979
2021-07-16,ES,Spain,EURO,29818,4109682,21,82000
2021-07-17,ES,Spain,EURO,29461,4139143,20,82020
2021-07-18,ES,Spain,EURO,29649,4168792,37,82057
2021-07-19,ES,Spain,EURO,18508,4187300,18,82075
2021-07-20,ES,Spain,EURO,14453,4201753,20,82095
2021-07-21,ES,Spain,EURO,29781,4231534,32,82127
2021-07-22,ES,Spain,EURO,31767,4263301,46,82173
2021-07-23,ES,Spain,EURO,31819,4295120,49,82222
2021-07-24,ES,Spain,EURO,31006,4326126,45,82267
2021-07-25,ES,Spain,EURO,30070,4356196,45,82312
2021-07-26,ES,Spain,EURO,18123,4374319,78,82390
2021-07-27,ES,Spain,EURO,12628,4386947,51,82441
2021-07-28,ES,Spain,EURO,25688,4412635,59,82500
2021-07-29,ES,Spain,EURO,28848,4441483,78,82578
2021-07-30,ES,Spain,EURO,26939,4468422,64,82642
2021-07-31,ES,Spain,EURO,25565,4493987,67,82709
2021-08-01,ES,Spain,EURO,25704,4519691,87,82796
2021-08-02,ES,Spain,EURO,14740,4534431,83,82879
2021-08-03,ES,Spain,EURO,9575,4544006,75,82954
2021-08-04,ES,Spain,EURO,19814,4563820,91,83045
2021-08-05,ES,Spain,EURO,21551,4585371,90,83135
2021-08-06,ES,Spain,EURO,20552,4605923,112,83247
2021-08-07,ES,Spain,EURO,19546,4625469,89,83336
2021-08-08,ES,Spain,EURO,19122,4644591,96,83432
2021-08-09,ES,Spain,EURO,10980,4655571,80,83512
2021-08-10,ES,Spain,EURO,7235,4662806,75,83587
2021-08-11,ES,Spain,EURO,15022,4677828,104,83691
2021-08-12,ES,Spain,EURO,17205,4695033,99,83790
2021-08-13,ES,Spain,EURO,15786,4710819,102,83892
2021-08-14,ES,Spain,EURO,14853,4725672,123,84015
2021-08-15,ES,Spain,EURO,13841,4739513,101,84116
2021-08-16,ES,Spain,EURO,8024,4747537,103,84219
2021-08-17,ES,Spain,EURO,5559,4753096,113,84332
2021-08-18,ES,Spain,EURO,9581,4762677,107,84439
2021-08-19,ES,Spain,EURO,11980,4774657,123,84562
2021-08-20,ES,Spain,EURO,12581,4787238,103,84665
2021-08-21,ES,Spain,EURO,11741,4798979,93,84758
2021-08-22,ES,Spain,EURO,11717,4810696,92,84850
2021-08-23,ES,Spain,EURO,6495,4817191,82,84932
2021-08-24,ES,Spain,EURO,4092,4821283,72,85004
2021-08-25,ES,Spain,EURO,9804,4831087,94,85098
2021-08-26,ES,Spain,EURO,9821,4840908,84,85182
2021-08-27,ES,Spain,EURO,9043,4849951,104,85286
2021-08-28,ES,Spain,EURO,8166,4858117,77,85363
2021-08-29,ES,Spain,EURO,8105,4866222,85,85448
2021-08-30,ES,Spain,EURO,4017,4870239,71,85519
2021-08-31,ES,Spain,EURO,2679,4872918,72,85591
2021-09-01,ES,Spain,EURO,6221,4879139,89,85680
2021-09-02,ES,Spain,EURO,7126,4886265,80,85760
2021-09-03,ES,Spain,EURO,5926,4892191,85,85845
2021-09-04,ES,Spain,EURO,5253,4897444,71,85916
2021-09-05,ES,Spain,EURO,4881,4902325,75,85991
2021-09-06,ES,Spain,EURO,2699,4905024,53,86044
2021-09-07,ES,Spain,EURO,1897,4906921,55,86099
2021-09-08,ES,Spain,EURO,4209,4911130,65,86164
2021-09-09,ES,Spain,EURO,4706,4915836,58,86222
2021-09-10,ES,Spain,EURO,3720,4919556,66,86288
2021-09-11,ES,Spain,EURO,3714,4923270,58,86346
2021-09-12,ES,Spain,EURO,3763,4927033,52,86398
2021-09-13,ES,Spain,EURO,1716,4928749,42,86440
2021-09-14,ES,Spain,EURO,1267,4930016,54,86494
2021-09-15,ES,Spain,EURO,3364,4933380,41,86535
2021-09-16,ES,Spain,EURO,3408,4936788,55,86590
2021-09-17,ES,Spain,EURO,2875,4939663,56,86646
2021-09-18,ES,Spain,EURO,2881,4942544,49,86695
2021-09-19,ES,Spain,EURO,2947,4945491,45,86740
2021-09-20,ES,Spain,EURO,1367,4946858,41,86781
2021-09-21,ES,Spain,EURO,891,4947749,46,86827
2021-09-22,ES,Spain,EURO,2378,4950127,41,86868
2021-09-23,ES,Spain,EURO,2711,4952838,43,86911
2021-09-24,ES,Spain,EURO,2493,4955331,31,86942
2021-09-25,ES,Spain,EURO,2299,4957630,29,86971
2021-09-26,ES,Spain,EURO,2441,4960071,37,87008
2021-09-27,ES,Spain,EURO,1222,4961293,27,87035
2021-09-28,ES,Spain,EURO,810,4962103,19,87054
2021-09-29,ES,Spain,EURO,2448,4964551,21,87075
2021-09-30,ES,Spain,EURO,2209,4966760,21,87096
2021-10-01,ES,Spain,EURO,2061,4968821,25,87121
2021-10-02,ES,Spain,EURO,1831,4970652,32,87153
2021-10-03,ES,Spain,EURO,1874,4972526,27,87180
2021-10-04,ES,Spain,EURO,971,4973497,30,87210
2021-10-05,ES,Spain,EURO,676,4974173,19,87229
2021-10-06,ES,Spain,EURO,1875,4976048,27,87256
2021-10-07,ES,Spain,EURO,1790,4977838,11,87267
2021-10-08,ES,Spain,EURO,1760,4979598,23,87290
2021-10-09,ES,Spain,EURO,1667,4981265,27,87317
2021-10-10,ES,Spain,EURO,1818,4983083,17,87334
2021-10-11,ES,Spain,EURO,879,4983962,16,87350
2021-10-12,ES,Spain,EURO,519,4984481,16,87366
2021-10-13,ES,Spain,EURO,1963,4986444,19,87385
2021-10-14,ES,Spain,EURO,819,4987263,17,87402
2021-10-15,ES,Spain,EURO,1859,4989122,18,87420
2021-10-16,ES,Spain,EURO,2019,4991141,17,87437
2021-10-17,ES,Spain,EURO,2000,4993141,18,87455
2021-10-18,ES,Spain,EURO,1107,4994248,14,87469
2021-10-19,ES,Spain,EURO,766,4995014,13,87482
2021-10-20,ES,Spain,EURO,2108,4997122,16,87498
2021-10-21,ES,Spain,EURO,2067,4999189,17,87515
2021-10-22,ES,Spain,EURO,2086,5001275,23,87538
2021-10-23,ES,Spain,EURO,1973,5003248,21,87559
2021-10-24,ES,Spain,EURO,2087,5005335,14,87573
2021-10-25,ES,Spain,EURO,1122,5006457,15,87588
2021-10-26,ES,Spain,EURO,833,5007290,14,87602
2021-10-27,ES,Spain,EURO,2240,5009530,15,87617
2021-10-28,ES,Spain,EURO,2083,5011613,18,87635
2021-10-29,ES,Spain,EURO,2107,5013720,15,87650
2021-10-30,ES,Spain,EURO,2124,5015844,18,87668
2021-10-31,ES,Spain,EURO,2425,5018269,7,87675
2021-11-01,ES,Spain,EURO,1348,5019617,19,87694
2021-11-02,ES,Spain,EURO,937,5020554,11,87705
2021-11-03,ES,Spain,EURO,994,5021548,13,87718
2021-11-04,ES,Spain,EURO,2876,5024424,9,87727
2021-11-05,ES,Spain,EURO,2913,5027337,16,87743
2021-11-06,ES,Spain,EURO,2970,5030307,9,87752
2021-11-07,ES,Spain,EURO,3168,5033475,11,87763
2021-11-08,ES,Spain,EURO,1823,5035298,14,87777
2021-11-09,ES,Spain,EURO,1199,5036497,20,87797
2021-11-10,ES,Spain,EURO,3418,5039915,26,87823
2021-11-11,ES,Spain,EURO,3811,5043726,25,87848
2021-11-12,ES,Spain,EURO,3850,5047576,22,87870
2021-11-13,ES,Spain,EURO,4331,5051907,15,87885
2021-11-14,ES,Spain,EURO,4872,5056779,26,87911
2021-11-15,ES,Spain,EURO,2879,5059658,17,87928
2021-11-16,ES,Spain,EURO,2126,5061784,16,87944
2021-11-17,ES,Spain,EURO,5579,5067363,22,87966
2021-11-18,ES,Spain,EURO,6321,5073684,23,87989
2021-11-19,ES,Spain,EURO,6407,5080091,21,88010
2021-11-20,ES,Spain,EURO,6821,5086912,21,88031
2021-11-21,ES,Spain,EURO,7702,5094614,10,88041
2021-11-22,ES,Spain,EURO,4466,5099080,19,88060
2021-11-23,ES,Spain,EURO,3158,5102238,25,88085
2021-11-24,ES,Spain,EURO,8081,5110319,24,88109
2021-11-25,ES,Spain,EURO,9075,5119394,18,88127
2021-11-26,ES,Spain,EURO,9581,5128975,16,88143
2021-11-27,ES,Spain,EURO,9869,5138844,25,88168
2021-11-28,ES,Spain,EURO,11003,5149847,25,88193
2021-11-29,ES,Spain,EURO,6746,5156593,26,88219
2021-11-30,ES,Spain,EURO,4511,5161104,19,88238
2021-12-01,ES,Spain,EURO,11440,5172544,31,88269
2021-12-02,ES,Spain,EURO,13202,5185746,38,88307
2021-12-03,ES,Spain,EURO,14229,5199975,29,88336
2021-12-04,ES,Spain,EURO,15406,5215381,31,88367
2021-12-05,ES,Spain,EURO,15960,5231341,35,88402
2021-12-06,ES,Spain,EURO,10944,5242285,34,88436
2021-12-07,ES,Spain,EURO,7602,5249887,37,88473
2021-12-08,ES,Spain,EURO,7941,5257828,47,88520
2021-12-09,ES,Spain,EURO,18043,5275871,42,88562
2021-12-10,ES,Spain,EURO,11909,5287780,38,88600
2021-12-11,ES,Spain,EURO,20830,5308610,41,88641
2021-12-12,ES,Spain,EURO,25764,5334374,41,88682
2021-12-13,ES,Spain,EURO,16494,5350868,38,88720
2021-12-14,ES,Spain,EURO,12851,5363719,29,88749
2021-12-15,ES,Spain,EURO,27015,5390734,47,88796
2021-12-16,ES,Spain,EURO,31864,5422598,52,88848
2021-12-17,ES,Spain,EURO,36356,5458954,34,88882
2021-12-18,ES,Spain,EURO,38117,5497071,62,88944
2021-12-19,ES,Spain,EURO,43902,5540973,58,89002
2021-12-20,ES,Spain,EURO,26493,5567466,55,89057
2021-12-21,ES,Spain,EURO,22133,5589599,60,89117
2021-12-22,ES,Spain,EURO,54632,5644231,71,89188
2021-12-23,ES,Spain,EURO,73814,5718045,64,89252
2021-12-24,ES,Spain,EURO,85418,5803463,54,89306
2021-12-25,ES,Spain,EURO,95660,5899123,56,89362
2021-12-26,ES,Spain,EURO,74060,5973183,55,89417
2021-12-27,ES,Spain,EURO,46274,6019457,63,89480
2021-12-28,ES,Spain,EURO,51542,6070999,57,89537
2021-12-29,ES,Spain,EURO,114291,6185290,79,89616
2021-12-30,ES,Spain,EURO,135570,6320860,71,89687
2021-12-31,ES,Spain,EURO,147339,6468199,83,89770
2022-01-01,ES,Spain,EURO,144795,6612994,77,89847
2022-01-02,ES,Spain,EURO,102516,6715510,77,89924
2022-01-03,ES,Spain,EURO,57539,6773049,82,90006
2022-01-04,ES,Spain,EURO,69311,6842360,76,90082
2022-01-05,ES,Spain,EURO,142583,6984943,96,90178
2022-01-06,ES,Spain,EURO,163490,7148433,107,90285
2022-01-07,ES,Spain,EURO,158937,7307370,103,90388
2022-01-08,ES,Spain,EURO,73700,7381070,88,90476
2022-01-09,ES,Spain,EURO,146940,7528010,95,90571
2022-01-10,ES,Spain,EURO,89168,7617178,113,90684
2022-01-11,ES,Spain,EURO,89549,7706727,112,90796
2022-01-12,ES,Spain,EURO,170428,7877155,147,90943
2022-01-13,ES,Spain,EURO,167629,8044784,116,91059
2022-01-14,ES,Spain,EURO,156875,8201659,124,91183
2022-01-15,ES,Spain,EURO,145507,8347166,157,91340
2022-01-16,ES,Spain,EURO,130743,8477909,160,91500
2022-01-17,ES,Spain,EURO,83285,8561194,126,91626
2022-01-18,ES,Spain,EURO,73622,8634816,175,91801
2022-01-19,ES,Spain,EURO,152566,8787382,162,91963
2022-01-20,ES,Spain,EURO,145490,8932872,144,92107
2022-01-21,ES,Spain,EURO,138828,9071700,165,92272
2022-01-22,ES,Spain,EURO,129189,9200889,150,92422
2022-01-23,ES,Spain,EURO,124094,9324983,197,92619
2022-01-24,ES,Spain,EURO,70405,9395388,134,92753
2022-01-25,ES,Spain,EURO,64526,9459914,148,92901
2022-01-26,ES,Spain,EURO,128225,9588139,191,93092
2022-01-27,ES,Spain,EURO,115434,9703573,183,93275
2022-01-28,ES,Spain,EURO,107641,9811214,173,93448
2022-01-29,ES,Spain,EURO,91742,9902956,145,93593
2022-01-30,ES,Spain,EURO,82103,9985059,169,93762
2022-01-31,ES,Spain,EURO,45692,10030751,163,93925
2022-02-01,ES,Spain,EURO,38541,10069292,160,94085
2022-02-02,ES,Spain,EURO,78181,10147473,166,94251
2022-02-03,ES,Spain,EURO,69391,10216864,157,94408
2022-02-04,ES,Spain,EURO,63201,10280065,154,94562
2022-02-05,ES,Spain,EURO,55637,10335702,155,94717
2022-02-06,ES,Spain,EURO,50437,10386139,129,94846
2022-02-07,ES,Spain,EURO,25765,10411904,89,94935
2022-02-08,ES,Spain,EURO,21359,10433263,122,95057
2022-02-09,ES,Spain,EURO,42604,10475867,113,95170
2022-02-10,ES,Spain,EURO,26274,10502141,43,95213
.
155339a
2022-02-10,SS,South Sudan,AFRO,12,16873,0,137
.
154570a
2022-02-10,ZA,South Africa,AFRO,3628,3631642,213,96502
.
153801a
2022-02-10,SO,Somalia,EMRO,0,26203,0,1340
.
153032c
2022-02-09,SB,Solomon Islands,WPRO,339,3657,3,40
2022-02-10,SB,Solomon Islands,WPRO,138,3795,0,40
.
152251,152263c
2022-01-28,SI,Slovenia,EURO,14226,656767,16,6386
2022-01-29,SI,Slovenia,EURO,16896,673663,8,6394
2022-01-30,SI,Slovenia,EURO,14902,688565,17,6411
2022-01-31,SI,Slovenia,EURO,13868,702433,19,6430
2022-02-01,SI,Slovenia,EURO,8582,711015,12,6442
2022-02-02,SI,Slovenia,EURO,11729,722744,12,6454
2022-02-03,SI,Slovenia,EURO,24178,746922,10,6464
2022-02-04,SI,Slovenia,EURO,16739,763661,9,6473
2022-02-05,SI,Slovenia,EURO,11733,775394,15,6488
2022-02-06,SI,Slovenia,EURO,11695,787089,6,6494
2022-02-07,SI,Slovenia,EURO,7490,794579,12,6506
2022-02-08,SI,Slovenia,EURO,5526,800105,4,6510
2022-02-09,SI,Slovenia,EURO,11118,811223,3,6513
2022-02-10,SI,Slovenia,EURO,5076,816299,2,6515
.
151494a
2022-02-10,SK,Slovakia,EURO,20160,1187002,26,18040
.
150725a
2022-02-10,SX,Sint Maarten,AMRO,32,9439,0,82
.
149956a
2022-02-10,XB,Sint Eustatius,AMRO,6,415,1,3
.
149187a
2022-02-10,SG,Singapore,WPRO,10314,428954,4,881
.
148418a
2022-02-10,SL,Sierra Leone,AFRO,0,7628,0,125
.
147649a
2022-02-10,SC,Seychelles,AFRO,0,38293,0,150
.
146880a
2022-02-10,RS,Serbia,EURO,12532,1806086,58,14171
.
146111a
2022-02-10,SN,Senegal,AFRO,26,85282,0,1956
.
145342a
2022-02-10,SA,Saudi Arabia,EMRO,3162,719136,3,8962
.
144573a
2022-02-10,ST,Sao Tome and Principe,AFRO,1,5913,0,71
.
143804a
2022-02-10,SM,San Marino,EURO,64,13852,1,110
.
143035a
2022-02-10,WS,Samoa,WPRO,0,33,0,0
.
142266a
2022-02-10,VC,Saint Vincent and the Grenadines,AMRO,0,8144,0,99
.
141497a
2022-02-10,PM,Saint Pierre and Miquelon,AMRO,0,921,0,1
.
140728a
2022-02-10,MF,Saint Martin,AMRO,0,9433,0,42
.
139959a
2022-02-10,LC,Saint Lucia,AMRO,33,21768,1,342
.
139190a
2022-02-10,KN,Saint Kitts and Nevis,AMRO,4,5488,0,38
.
138421a
2022-02-10,SH,Saint Helena,AFRO,0,0,0,0
.
137652a
2022-02-10,BL,Saint Barthélemy,AMRO,0,3427,0,4
.
136883a
2022-02-10,XC,Saba,AMRO,0,200,0,0
.
136114a
2022-02-10,RW,Rwanda,AFRO,33,129210,2,1449
.
135345a
2022-02-10,RU,Russian Federation,EURO,197076,13527845,701,338091
.
134576a
2022-02-10,RO,Romania,EURO,27346,2482394,176,61092
.
133807a
2022-02-10,RE,Réunion,AFRO,0,256787,0,565
.
133038a
2022-02-10,MD,Republic of Moldova,EURO,2871,477419,29,10866
.
132269a
2022-02-10,KR,Republic of Korea,WPRO,54122,1185361,20,6963
.
131500a
2022-02-10,QA,Qatar,EMRO,776,348141,0,653
.
130731a
2022-02-10,PR,Puerto Rico,AMRO,471,465809,24,3984
.
129962a
2022-02-10,PT,Portugal,EURO,34023,2997770,52,20354
.
129174,129193c
2022-01-21,PL,Poland,EURO,36665,4443218,248,103626
2022-01-22,PL,Poland,EURO,40876,4484094,193,103819
2022-01-23,PL,Poland,EURO,34088,4518182,25,103844
2022-01-24,PL,Poland,EURO,29100,4547282,4,103848
2022-01-25,PL,Poland,EURO,36995,4584277,252,104100
2022-01-26,PL,Poland,EURO,53420,4637697,276,104376
2022-01-27,PL,Poland,EURO,57659,4695356,262,104638
2022-01-28,PL,Poland,EURO,57262,4752618,271,104909
2022-01-29,PL,Poland,EURO,51695,4804313,231,105140
2022-01-30,PL,Poland,EURO,48251,4852564,23,105163
2022-01-31,PL,Poland,EURO,33480,4886044,33,105196
2022-02-01,PL,Poland,EURO,39114,4925158,239,105435
2022-02-02,PL,Poland,EURO,56051,4981209,318,105753
2022-02-03,PL,Poland,EURO,54477,5035686,307,106060
2022-02-04,PL,Poland,EURO,47534,5083220,246,106306
2022-02-05,PL,Poland,EURO,45749,5128969,272,106578
2022-02-06,PL,Poland,EURO,34703,5163672,19,106597
2022-02-07,PL,Poland,EURO,24512,5188184,10,106607
2022-02-08,PL,Poland,EURO,35960,5224144,287,106894
2022-02-09,PL,Poland,EURO,46175,5270319,310,107204
2022-02-10,PL,Poland,EURO,42095,5312414,262,107466
.
128424a
2022-02-10,PN,Pitcairn Islands,WPRO,0,0,0,0
.
127655c
2022-02-09,PH,Philippines,WPRO,3466,3619525,83,54621
2022-02-10,PH,Philippines,WPRO,3651,3623176,69,54690
.
126886a
2022-02-10,PE,Peru,AMRO,11651,3384546,198,207312
.
126117a
2022-02-10,PY,Paraguay,AMRO,2686,612893,51,17704
.
125348c
2022-02-09,PG,Papua New Guinea,WPRO,195,37983,8,605
2022-02-10,PG,Papua New Guinea,WPRO,239,38222,5,610
.
124579a
2022-02-10,PA,Panama,AMRO,3180,732207,26,7886
.
123810a
2022-02-10,PW,Palau,WPRO,113,2956,0,0
.
123041a
2022-02-10,PK,Pakistan,EMRO,4251,1470161,48,29601
.
122272a
2022-02-10, ,Other,Other,0,764,0,13
.
121503a
2022-02-10,OM,Oman,EMRO,2356,359256,2,4190
.
120734a
2022-02-10,PS,"occupied Palestinian territory, including east Jerusalem",EMRO,6091,600128,19,5215
.
119965a
2022-02-10,NO,Norway,EURO,4039,937312,0,1512
.
119196a
2022-02-10,MP,Northern Mariana Islands (Commonwealth of the),WPRO,221,6784,0,23
.
118420,118427c
2022-02-02,MK,North Macedonia,EURO,1997,270886,25,8461
2022-02-03,MK,North Macedonia,EURO,1543,272429,22,8483
2022-02-04,MK,North Macedonia,EURO,1715,274144,23,8506
2022-02-05,MK,North Macedonia,EURO,1493,275637,40,8546
2022-02-06,MK,North Macedonia,EURO,1499,277136,20,8566
2022-02-07,MK,North Macedonia,EURO,1045,278181,26,8592
2022-02-08,MK,North Macedonia,EURO,690,278871,19,8611
2022-02-09,MK,North Macedonia,EURO,1722,280593,25,8636
2022-02-10,MK,North Macedonia,EURO,1554,282147,22,8658
.
117658a
2022-02-10,NU,Niue,WPRO,0,0,0,0
.
116889a
2022-02-10,NG,Nigeria,AFRO,37,253875,0,3139
.
116120a
2022-02-10,NE,Niger,AFRO,4,8700,0,303
.
115351a
2022-02-10,NI,Nicaragua,AMRO,0,13792,0,222
.
114582c
2022-02-09,NZ,New Zealand,WPRO,248,18124,0,53
2022-02-10,NZ,New Zealand,WPRO,336,18460,0,53
.
113813a
2022-02-10,NC,New Caledonia,WPRO,1914,33031,0,284
.
113007,113044c
2022-01-03,NL,Netherlands,EURO,17426,3164832,6,20954
2022-01-04,NL,Netherlands,EURO,14494,3179326,14,20968
2022-01-05,NL,Netherlands,EURO,18508,3197834,19,20987
2022-01-06,NL,Netherlands,EURO,24439,3222273,38,21025
2022-01-07,NL,Netherlands,EURO,24527,3246800,12,21037
2022-01-08,NL,Netherlands,EURO,34730,3281530,24,21061
2022-01-09,NL,Netherlands,EURO,27789,3309319,8,21069
2022-01-10,NL,Netherlands,EURO,32338,3341657,7,21076
2022-01-11,NL,Netherlands,EURO,27741,3369398,7,21083
2022-01-12,NL,Netherlands,EURO,28855,3398253,18,21101
2022-01-13,NL,Netherlands,EURO,31911,3430164,8,21109
2022-01-14,NL,Netherlands,EURO,33152,3463316,13,21122
2022-01-15,NL,Netherlands,EURO,35200,3498516,16,21138
2022-01-16,NL,Netherlands,EURO,31630,3530146,6,21144
2022-01-17,NL,Netherlands,EURO,35774,3565920,7,21151
2022-01-18,NL,Netherlands,EURO,41774,3607694,3,21154
2022-01-19,NL,Netherlands,EURO,31024,3638718,10,21164
2022-01-20,NL,Netherlands,EURO,37985,3676703,10,21174
2022-01-21,NL,Netherlands,EURO,39729,3716432,10,21184
2022-01-22,NL,Netherlands,EURO,57193,3773625,11,21195
2022-01-23,NL,Netherlands,EURO,45767,3819392,8,21203
2022-01-24,NL,Netherlands,EURO,64668,3884060,1,21204
2022-01-25,NL,Netherlands,EURO,64094,3948154,8,21212
2022-01-26,NL,Netherlands,EURO,53488,4001642,7,21219
2022-01-27,NL,Netherlands,EURO,57893,4059535,11,21230
2022-01-28,NL,Netherlands,EURO,64024,4123559,14,21244
2022-01-29,NL,Netherlands,EURO,73158,4196717,8,21252
2022-01-30,NL,Netherlands,EURO,38924,4235641,8,21260
2022-01-31,NL,Netherlands,EURO,74525,4310166,2,21262
2022-02-01,NL,Netherlands,EURO,110849,4421015,5,21267
2022-02-02,NL,Netherlands,EURO,104674,4525689,15,21282
2022-02-03,NL,Netherlands,EURO,66120,4591809,10,21292
2022-02-04,NL,Netherlands,EURO,81095,4672904,10,21302
2022-02-05,NL,Netherlands,EURO,71344,4744248,5,21307
2022-02-06,NL,Netherlands,EURO,53005,4797253,10,21317
2022-02-07,NL,Netherlands,EURO,80047,4877300,7,21324
2022-02-08,NL,Netherlands,EURO,77997,4955297,4,21328
2022-02-09,NL,Netherlands,EURO,394674,5349971,8,21336
2022-02-10,NL,Netherlands,EURO,86604,5436575,7,21343
.
112275a
2022-02-10,NP,Nepal,SEARO,1013,971475,12,11864
.
111506a
2022-02-10,NR,Nauru,WPRO,0,0,0,0
.
110737a
2022-02-10,NA,Namibia,AFRO,0,156482,0,3982
.
109968a
2022-02-10,MM,Myanmar,SEARO,0,540597,0,19310
.
109199a
2022-02-10,MZ,Mozambique,AFRO,60,224494,1,2186
.
108430a
2022-02-10,MA,Morocco,EMRO,1499,1151081,41,15698
.
107661a
2022-02-10,MS,Montserrat,AMRO,0,163,1,2
.
106886,106892c
2022-02-03,ME,Montenegro,EURO,613,221260,4,2568
2022-02-04,ME,Montenegro,EURO,693,221953,14,2582
2022-02-05,ME,Montenegro,EURO,524,222477,9,2591
2022-02-06,ME,Montenegro,EURO,530,223007,5,2596
2022-02-07,ME,Montenegro,EURO,509,223516,3,2599
2022-02-08,ME,Montenegro,EURO,294,223810,2,2601
2022-02-09,ME,Montenegro,EURO,579,224389,9,2610
2022-02-10,ME,Montenegro,EURO,399,224788,3,2613
.
106123a
2022-02-10,MN,Mongolia,WPRO,1192,864564,3,2062
.
106107,106120c
2022-01-24,MN,Mongolia,WPRO,5228,794908,0,2020
2022-01-25,MN,Mongolia,WPRO,4871,799779,1,2021
2022-01-26,MN,Mongolia,WPRO,12310,812089,4,2025
2022-01-27,MN,Mongolia,WPRO,7768,819857,2,2027
2022-01-28,MN,Mongolia,WPRO,7896,827753,2,2029
2022-01-29,MN,Mongolia,WPRO,6646,834399,2,2031
2022-01-30,MN,Mongolia,WPRO,2725,837124,0,2031
2022-01-31,MN,Mongolia,WPRO,4724,841848,3,2034
2022-02-01,MN,Mongolia,WPRO,5092,846940,2,2036
2022-02-02,MN,Mongolia,WPRO,2728,849668,4,2040
2022-02-03,MN,Mongolia,WPRO,3472,853140,2,2042
2022-02-04,MN,Mongolia,WPRO,1939,855079,1,2043
2022-02-05,MN,Mongolia,WPRO,3297,858376,2,2045
2022-02-06,MN,Mongolia,WPRO,1740,860116,7,2052
.
106082,106105c
2021-12-30,MN,Mongolia,WPRO,242,692028,0,1981
2021-12-31,MN,Mongolia,WPRO,593,692621,4,1985
2022-01-01,MN,Mongolia,WPRO,498,693119,1,1986
2022-01-02,MN,Mongolia,WPRO,427,693546,0,1986
2022-01-03,MN,Mongolia,WPRO,303,693849,1,1987
2022-01-04,MN,Mongolia,WPRO,1347,695196,0,1987
2022-01-05,MN,Mongolia,WPRO,745,695941,2,1989
2022-01-06,MN,Mongolia,WPRO,1869,697810,3,1992
2022-01-07,MN,Mongolia,WPRO,2001,699811,2,1994
2022-01-08,MN,Mongolia,WPRO,2353,702164,1,1995
2022-01-09,MN,Mongolia,WPRO,1428,703592,2,1997
2022-01-10,MN,Mongolia,WPRO,2394,705986,0,1997
2022-01-11,MN,Mongolia,WPRO,3443,709429,4,2001
2022-01-12,MN,Mongolia,WPRO,3222,712651,0,2001
2022-01-13,MN,Mongolia,WPRO,2610,715261,2,2003
2022-01-14,MN,Mongolia,WPRO,6280,721541,3,2006
2022-01-15,MN,Mongolia,WPRO,8348,729889,3,2009
2022-01-16,MN,Mongolia,WPRO,7089,736978,2,2011
2022-01-17,MN,Mongolia,WPRO,4704,741682,1,2012
2022-01-18,MN,Mongolia,WPRO,5640,747322,1,2013
2022-01-19,MN,Mongolia,WPRO,9071,756393,3,2016
2022-01-20,MN,Mongolia,WPRO,4441,760834,0,2016
2022-01-21,MN,Mongolia,WPRO,11059,771893,3,2019
2022-01-22,MN,Mongolia,WPRO,8269,780162,1,2020
.
105810,106078c
2021-04-02,MN,Mongolia,WPRO,486,9327,1,9
2021-04-03,MN,Mongolia,WPRO,271,9598,3,12
2021-04-04,MN,Mongolia,WPRO,620,10218,0,12
2021-04-05,MN,Mongolia,WPRO,602,10820,0,12
2021-04-06,MN,Mongolia,WPRO,831,11651,2,14
2021-04-07,MN,Mongolia,WPRO,575,12226,1,15
2021-04-08,MN,Mongolia,WPRO,554,12780,3,18
2021-04-09,MN,Mongolia,WPRO,714,13494,1,19
2021-04-10,MN,Mongolia,WPRO,689,14183,1,20
2021-04-11,MN,Mongolia,WPRO,831,15014,1,21
2021-04-12,MN,Mongolia,WPRO,704,15718,2,23
2021-04-13,MN,Mongolia,WPRO,885,16603,3,26
2021-04-14,MN,Mongolia,WPRO,1220,17823,1,27
2021-04-15,MN,Mongolia,WPRO,742,18565,4,31
2021-04-16,MN,Mongolia,WPRO,1107,19672,5,36
2021-04-17,MN,Mongolia,WPRO,983,20655,5,41
2021-04-18,MN,Mongolia,WPRO,1340,21995,2,43
2021-04-19,MN,Mongolia,WPRO,889,22884,6,49
2021-04-20,MN,Mongolia,WPRO,1311,24195,1,50
2021-04-21,MN,Mongolia,WPRO,1169,25364,5,55
2021-04-22,MN,Mongolia,WPRO,1328,26692,5,60
2021-04-23,MN,Mongolia,WPRO,1264,27956,7,67
2021-04-24,MN,Mongolia,WPRO,1263,29219,8,75
2021-04-25,MN,Mongolia,WPRO,1264,30483,5,80
2021-04-26,MN,Mongolia,WPRO,856,31339,3,83
2021-04-27,MN,Mongolia,WPRO,1098,32437,11,94
2021-04-28,MN,Mongolia,WPRO,1171,33608,5,99
2021-04-29,MN,Mongolia,WPRO,1015,34623,5,104
2021-04-30,MN,Mongolia,WPRO,1356,35979,8,112
2021-05-01,MN,Mongolia,WPRO,1306,37285,6,118
2021-05-02,MN,Mongolia,WPRO,1185,38470,3,121
2021-05-03,MN,Mongolia,WPRO,911,39381,4,125
2021-05-04,MN,Mongolia,WPRO,1015,40396,6,131
2021-05-05,MN,Mongolia,WPRO,1128,41524,6,137
2021-05-06,MN,Mongolia,WPRO,940,42464,5,142
2021-05-07,MN,Mongolia,WPRO,737,43201,3,145
2021-05-08,MN,Mongolia,WPRO,815,44016,5,150
2021-05-09,MN,Mongolia,WPRO,804,44820,3,153
2021-05-10,MN,Mongolia,WPRO,639,45459,5,158
2021-05-11,MN,Mongolia,WPRO,477,45936,7,165
2021-05-12,MN,Mongolia,WPRO,512,46448,2,167
2021-05-13,MN,Mongolia,WPRO,585,47033,12,179
2021-05-14,MN,Mongolia,WPRO,515,47548,6,185
2021-05-15,MN,Mongolia,WPRO,553,48101,2,187
2021-05-16,MN,Mongolia,WPRO,541,48642,5,192
2021-05-17,MN,Mongolia,WPRO,533,49175,3,195
2021-05-18,MN,Mongolia,WPRO,349,49524,7,202
2021-05-19,MN,Mongolia,WPRO,575,50099,3,205
2021-05-20,MN,Mongolia,WPRO,519,50618,1,206
2021-05-21,MN,Mongolia,WPRO,629,51247,3,209
2021-05-22,MN,Mongolia,WPRO,684,51931,5,214
2021-05-23,MN,Mongolia,WPRO,539,52470,4,218
2021-05-24,MN,Mongolia,WPRO,630,53100,3,221
2021-05-25,MN,Mongolia,WPRO,634,53734,2,223
2021-05-26,MN,Mongolia,WPRO,680,54414,2,225
2021-05-27,MN,Mongolia,WPRO,653,55067,3,228
2021-05-28,MN,Mongolia,WPRO,785,55852,2,230
2021-05-29,MN,Mongolia,WPRO,769,56621,11,241
2021-05-30,MN,Mongolia,WPRO,891,57512,2,243
2021-05-31,MN,Mongolia,WPRO,927,58439,4,247
2021-06-01,MN,Mongolia,WPRO,790,59229,6,253
2021-06-02,MN,Mongolia,WPRO,1143,60372,4,257
2021-06-03,MN,Mongolia,WPRO,1024,61396,5,262
2021-06-04,MN,Mongolia,WPRO,1189,62585,9,271
2021-06-05,MN,Mongolia,WPRO,1393,63978,3,274
2021-06-06,MN,Mongolia,WPRO,1288,65266,3,277
2021-06-07,MN,Mongolia,WPRO,1177,66443,4,281
2021-06-08,MN,Mongolia,WPRO,1267,67710,7,288
2021-06-09,MN,Mongolia,WPRO,1312,69022,9,297
2021-06-10,MN,Mongolia,WPRO,1460,70482,6,303
2021-06-11,MN,Mongolia,WPRO,1622,72104,10,313
2021-06-12,MN,Mongolia,WPRO,1792,73896,15,328
2021-06-13,MN,Mongolia,WPRO,2188,76084,4,332
2021-06-14,MN,Mongolia,WPRO,2263,78347,6,338
2021-06-15,MN,Mongolia,WPRO,2386,80733,7,345
2021-06-16,MN,Mongolia,WPRO,2395,83128,10,355
2021-06-17,MN,Mongolia,WPRO,2642,85770,14,369
2021-06-18,MN,Mongolia,WPRO,2746,88516,11,380
2021-06-19,MN,Mongolia,WPRO,2635,91151,10,390
2021-06-20,MN,Mongolia,WPRO,2400,93551,10,400
2021-06-21,MN,Mongolia,WPRO,2268,95819,5,405
2021-06-22,MN,Mongolia,WPRO,2231,98050,14,419
2021-06-23,MN,Mongolia,WPRO,2213,100263,11,430
2021-06-24,MN,Mongolia,WPRO,2366,102629,8,438
2021-06-25,MN,Mongolia,WPRO,2271,104900,15,453
2021-06-26,MN,Mongolia,WPRO,2362,107262,9,462
2021-06-27,MN,Mongolia,WPRO,2432,109694,15,477
2021-06-28,MN,Mongolia,WPRO,1811,111505,1,478
2021-06-29,MN,Mongolia,WPRO,1727,113232,1,479
2021-06-30,MN,Mongolia,WPRO,2246,115478,5,484
2021-07-01,MN,Mongolia,WPRO,2485,117963,12,496
2021-07-02,MN,Mongolia,WPRO,2376,120339,12,508
2021-07-03,MN,Mongolia,WPRO,2401,122740,15,523
2021-07-04,MN,Mongolia,WPRO,2520,125260,8,531
2021-07-05,MN,Mongolia,WPRO,1551,126811,14,545
2021-07-06,MN,Mongolia,WPRO,1643,128454,3,548
2021-07-07,MN,Mongolia,WPRO,1998,130452,5,553
2021-07-08,MN,Mongolia,WPRO,1510,131962,8,561
2021-07-09,MN,Mongolia,WPRO,2308,134270,9,570
2021-07-10,MN,Mongolia,WPRO,1783,136053,14,584
2021-07-11,MN,Mongolia,WPRO,1735,137788,8,592
2021-07-12,MN,Mongolia,WPRO,1496,139284,5,597
2021-07-13,MN,Mongolia,WPRO,1246,140530,8,605
2021-07-14,MN,Mongolia,WPRO,1159,141689,1,606
2021-07-15,MN,Mongolia,WPRO,1439,143128,0,606
2021-07-16,MN,Mongolia,WPRO,1364,144492,10,616
2021-07-17,MN,Mongolia,WPRO,1295,145787,7,623
2021-07-18,MN,Mongolia,WPRO,1466,147253,2,625
2021-07-19,MN,Mongolia,WPRO,2480,149733,8,633
2021-07-20,MN,Mongolia,WPRO,1497,151230,4,637
2021-07-21,MN,Mongolia,WPRO,1309,152539,8,645
2021-07-22,MN,Mongolia,WPRO,0,152539,10,655
2021-07-23,MN,Mongolia,WPRO,1243,153782,4,659
2021-07-24,MN,Mongolia,WPRO,1442,155224,11,670
2021-07-25,MN,Mongolia,WPRO,1501,156725,5,675
2021-07-26,MN,Mongolia,WPRO,1249,157974,5,680
2021-07-27,MN,Mongolia,WPRO,1127,159101,8,688
2021-07-28,MN,Mongolia,WPRO,1243,160344,5,693
2021-07-29,MN,Mongolia,WPRO,2525,162869,8,701
2021-07-30,MN,Mongolia,WPRO,1286,164155,5,706
2021-07-31,MN,Mongolia,WPRO,992,165147,5,711
2021-08-01,MN,Mongolia,WPRO,1063,166210,2,713
2021-08-02,MN,Mongolia,WPRO,1019,167229,3,716
2021-08-03,MN,Mongolia,WPRO,1444,168673,6,722
2021-08-04,MN,Mongolia,WPRO,1178,169851,3,725
2021-08-05,MN,Mongolia,WPRO,1246,171097,2,727
2021-08-06,MN,Mongolia,WPRO,972,172069,8,735
2021-08-07,MN,Mongolia,WPRO,1463,173532,3,738
2021-08-08,MN,Mongolia,WPRO,1071,174603,8,746
2021-08-09,MN,Mongolia,WPRO,957,175560,3,749
2021-08-10,MN,Mongolia,WPRO,1433,176993,4,753
2021-08-11,MN,Mongolia,WPRO,1443,178436,2,755
2021-08-12,MN,Mongolia,WPRO,0,178436,3,758
2021-08-13,MN,Mongolia,WPRO,1453,179889,2,760
2021-08-14,MN,Mongolia,WPRO,1402,181291,3,763
2021-08-15,MN,Mongolia,WPRO,1300,182591,5,768
2021-08-16,MN,Mongolia,WPRO,1061,183652,3,771
2021-08-17,MN,Mongolia,WPRO,1298,184950,5,776
2021-08-18,MN,Mongolia,WPRO,1582,186532,1,777
2021-08-19,MN,Mongolia,WPRO,1875,188407,5,782
2021-08-20,MN,Mongolia,WPRO,1841,190248,2,784
2021-08-21,MN,Mongolia,WPRO,1651,191899,0,784
2021-08-22,MN,Mongolia,WPRO,1780,193679,5,789
2021-08-23,MN,Mongolia,WPRO,1566,195245,8,797
2021-08-24,MN,Mongolia,WPRO,1596,196841,5,802
2021-08-25,MN,Mongolia,WPRO,2433,199274,4,806
2021-08-26,MN,Mongolia,WPRO,2467,201741,3,809
2021-08-27,MN,Mongolia,WPRO,2489,204230,2,811
2021-08-28,MN,Mongolia,WPRO,2422,206652,6,817
2021-08-29,MN,Mongolia,WPRO,2414,209066,2,819
2021-08-30,MN,Mongolia,WPRO,2209,211275,6,825
2021-08-31,MN,Mongolia,WPRO,2740,214015,10,835
2021-09-01,MN,Mongolia,WPRO,3726,217741,1,836
2021-09-02,MN,Mongolia,WPRO,3805,221546,3,839
2021-09-03,MN,Mongolia,WPRO,3638,225184,10,849
2021-09-04,MN,Mongolia,WPRO,3696,228880,7,856
2021-09-05,MN,Mongolia,WPRO,3628,232508,7,863
2021-09-06,MN,Mongolia,WPRO,3766,236274,13,876
2021-09-07,MN,Mongolia,WPRO,4664,240938,9,885
2021-09-08,MN,Mongolia,WPRO,6203,247141,9,894
2021-09-09,MN,Mongolia,WPRO,6273,253414,14,908
2021-09-10,MN,Mongolia,WPRO,3393,256807,11,919
2021-09-11,MN,Mongolia,WPRO,4405,261212,15,934
2021-09-12,MN,Mongolia,WPRO,4366,265578,14,948
2021-09-13,MN,Mongolia,WPRO,3405,268983,15,963
2021-09-14,MN,Mongolia,WPRO,4370,273353,10,973
2021-09-15,MN,Mongolia,WPRO,4976,278329,10,983
2021-09-16,MN,Mongolia,WPRO,5166,283495,10,993
2021-09-17,MN,Mongolia,WPRO,5239,288734,8,1001
2021-09-18,MN,Mongolia,WPRO,8127,296861,9,1010
2021-09-19,MN,Mongolia,WPRO,5508,302369,13,1023
2021-09-20,MN,Mongolia,WPRO,5509,307878,12,1035
2021-09-21,MN,Mongolia,WPRO,8777,316655,11,1046
2021-09-22,MN,Mongolia,WPRO,9255,325910,13,1059
2021-09-23,MN,Mongolia,WPRO,8084,333994,14,1073
2021-09-24,MN,Mongolia,WPRO,7380,341374,13,1086
2021-09-25,MN,Mongolia,WPRO,7925,349299,12,1098
2021-09-26,MN,Mongolia,WPRO,5084,354383,18,1116
2021-09-27,MN,Mongolia,WPRO,4284,358667,17,1133
2021-09-28,MN,Mongolia,WPRO,8400,367067,19,1152
2021-09-29,MN,Mongolia,WPRO,7797,374864,17,1169
2021-09-30,MN,Mongolia,WPRO,7633,382497,16,1185
2021-10-01,MN,Mongolia,WPRO,7490,389987,19,1204
2021-10-02,MN,Mongolia,WPRO,7224,397211,18,1222
2021-10-03,MN,Mongolia,WPRO,4732,401943,19,1241
2021-10-04,MN,Mongolia,WPRO,3422,405365,19,1260
2021-10-05,MN,Mongolia,WPRO,7589,412954,14,1274
2021-10-06,MN,Mongolia,WPRO,7696,420650,15,1289
2021-10-07,MN,Mongolia,WPRO,7549,428199,14,1303
2021-10-08,MN,Mongolia,WPRO,7870,436069,15,1318
2021-10-09,MN,Mongolia,WPRO,7345,443414,13,1331
2021-10-10,MN,Mongolia,WPRO,4927,448341,15,1346
2021-10-11,MN,Mongolia,WPRO,4012,452353,17,1363
2021-10-12,MN,Mongolia,WPRO,7720,460073,14,1377
2021-10-13,MN,Mongolia,WPRO,8002,468075,15,1392
2021-10-14,MN,Mongolia,WPRO,7183,475258,17,1409
2021-10-15,MN,Mongolia,WPRO,7009,482267,15,1424
2021-10-16,MN,Mongolia,WPRO,6076,488343,16,1440
2021-10-17,MN,Mongolia,WPRO,6867,495210,14,1454
2021-10-18,MN,Mongolia,WPRO,3693,498903,15,1469
2021-10-19,MN,Mongolia,WPRO,6634,505537,14,1483
2021-10-20,MN,Mongolia,WPRO,7332,512869,18,1501
2021-10-21,MN,Mongolia,WPRO,6390,519259,17,1518
2021-10-22,MN,Mongolia,WPRO,6186,525445,16,1534
2021-10-23,MN,Mongolia,WPRO,6580,532025,19,1553
2021-10-24,MN,Mongolia,WPRO,3921,535946,17,1570
2021-10-25,MN,Mongolia,WPRO,3251,539197,17,1587
2021-10-26,MN,Mongolia,WPRO,5597,544794,6,1593
2021-10-27,MN,Mongolia,WPRO,6151,550945,11,1604
2021-10-28,MN,Mongolia,WPRO,5388,556333,12,1616
2021-10-29,MN,Mongolia,WPRO,5190,561523,10,1626
2021-10-30,MN,Mongolia,WPRO,4721,566244,12,1638
2021-10-31,MN,Mongolia,WPRO,24556,590800,11,1649
2021-11-01,MN,Mongolia,WPRO,2194,592994,12,1661
2021-11-02,MN,Mongolia,WPRO,3744,596738,11,1672
2021-11-03,MN,Mongolia,WPRO,6293,603031,10,1682
2021-11-04,MN,Mongolia,WPRO,5926,608957,12,1694
2021-11-05,MN,Mongolia,WPRO,3944,612901,10,1704
2021-11-06,MN,Mongolia,WPRO,3372,616273,11,1715
2021-11-07,MN,Mongolia,WPRO,1781,618054,9,1724
2021-11-08,MN,Mongolia,WPRO,1969,620023,12,1736
2021-11-09,MN,Mongolia,WPRO,2183,622206,8,1744
2021-11-10,MN,Mongolia,WPRO,3862,626068,12,1756
2021-11-11,MN,Mongolia,WPRO,3204,629272,11,1767
2021-11-12,MN,Mongolia,WPRO,2888,632160,10,1777
2021-11-13,MN,Mongolia,WPRO,2477,634637,9,1786
2021-11-14,MN,Mongolia,WPRO,2457,637094,10,1796
2021-11-15,MN,Mongolia,WPRO,1423,638517,9,1805
2021-11-16,MN,Mongolia,WPRO,1747,640264,10,1815
2021-11-17,MN,Mongolia,WPRO,2968,643232,11,1826
2021-11-18,MN,Mongolia,WPRO,3588,646820,10,1836
2021-11-19,MN,Mongolia,WPRO,2911,649731,10,1846
2021-11-20,MN,Mongolia,WPRO,2220,651951,6,1852
2021-11-21,MN,Mongolia,WPRO,1714,653665,8,1860
2021-11-22,MN,Mongolia,WPRO,1162,654827,7,1867
2021-11-23,MN,Mongolia,WPRO,1685,656512,8,1875
2021-11-24,MN,Mongolia,WPRO,2585,659097,10,1885
2021-11-25,MN,Mongolia,WPRO,1788,660885,11,1896
2021-11-26,MN,Mongolia,WPRO,2389,663274,7,1903
2021-11-27,MN,Mongolia,WPRO,1830,665104,5,1908
2021-11-28,MN,Mongolia,WPRO,1189,666293,4,1912
2021-11-29,MN,Mongolia,WPRO,1068,667361,5,1917
2021-11-30,MN,Mongolia,WPRO,1041,668402,5,1922
2021-12-01,MN,Mongolia,WPRO,1979,670381,8,1930
2021-12-02,MN,Mongolia,WPRO,1803,672184,2,1932
2021-12-03,MN,Mongolia,WPRO,1845,674029,3,1935
2021-12-04,MN,Mongolia,WPRO,922,674951,3,1938
2021-12-05,MN,Mongolia,WPRO,1111,676062,2,1940
2021-12-06,MN,Mongolia,WPRO,797,676859,3,1943
2021-12-07,MN,Mongolia,WPRO,1000,677859,1,1944
2021-12-08,MN,Mongolia,WPRO,1091,678950,3,1947
2021-12-09,MN,Mongolia,WPRO,995,679945,3,1950
2021-12-10,MN,Mongolia,WPRO,946,680891,3,1953
2021-12-11,MN,Mongolia,WPRO,869,681760,0,1953
2021-12-12,MN,Mongolia,WPRO,566,682326,2,1955
2021-12-13,MN,Mongolia,WPRO,401,682727,5,1960
2021-12-14,MN,Mongolia,WPRO,606,683333,3,1963
2021-12-15,MN,Mongolia,WPRO,917,684250,2,1965
2021-12-16,MN,Mongolia,WPRO,864,685114,1,1966
2021-12-17,MN,Mongolia,WPRO,684,685798,2,1968
2021-12-18,MN,Mongolia,WPRO,702,686500,0,1968
2021-12-19,MN,Mongolia,WPRO,623,687123,2,1970
2021-12-20,MN,Mongolia,WPRO,309,687432,0,1970
2021-12-21,MN,Mongolia,WPRO,617,688049,2,1972
2021-12-22,MN,Mongolia,WPRO,818,688867,2,1974
2021-12-23,MN,Mongolia,WPRO,565,689432,3,1977
2021-12-24,MN,Mongolia,WPRO,230,689662,1,1978
2021-12-25,MN,Mongolia,WPRO,310,689972,2,1980
2021-12-26,MN,Mongolia,WPRO,705,690677,1,1981
.
105803,105805c
2021-03-26,MN,Mongolia,WPRO,437,6332,1,6
2021-03-27,MN,Mongolia,WPRO,361,6693,0,6
2021-03-28,MN,Mongolia,WPRO,321,7014,0,6
.
105796,105798c
2021-03-19,MN,Mongolia,WPRO,160,4658,1,5
2021-03-20,MN,Mongolia,WPRO,148,4806,0,5
2021-03-21,MN,Mongolia,WPRO,170,4976,0,5
.
105788,105789c
2021-03-11,MN,Mongolia,WPRO,80,3561,1,4
2021-03-12,MN,Mongolia,WPRO,103,3664,0,4
.
105785,105786c
2021-03-08,MN,Mongolia,WPRO,108,3336,1,3
2021-03-09,MN,Mongolia,WPRO,36,3372,0,3
.
105741,105742c
2021-01-23,MN,Mongolia,WPRO,19,1611,1,2
2021-01-24,MN,Mongolia,WPRO,16,1627,0,2
.
105705,105724c
2020-12-18,MN,Mongolia,WPRO,5,923,1,1
2020-12-19,MN,Mongolia,WPRO,18,941,0,1
2020-12-20,MN,Mongolia,WPRO,12,953,0,1
2020-12-21,MN,Mongolia,WPRO,8,961,0,1
2020-12-22,MN,Mongolia,WPRO,32,993,0,1
2020-12-23,MN,Mongolia,WPRO,13,1006,0,1
2020-12-24,MN,Mongolia,WPRO,57,1063,0,1
2020-12-25,MN,Mongolia,WPRO,6,1069,0,1
2020-12-26,MN,Mongolia,WPRO,6,1075,0,1
2020-12-27,MN,Mongolia,WPRO,7,1082,0,1
2020-12-28,MN,Mongolia,WPRO,39,1121,0,1
2020-12-29,MN,Mongolia,WPRO,16,1137,0,1
2020-12-30,MN,Mongolia,WPRO,38,1175,0,1
2020-12-31,MN,Mongolia,WPRO,20,1195,0,1
2021-01-01,MN,Mongolia,WPRO,25,1220,0,1
2021-01-02,MN,Mongolia,WPRO,22,1242,0,1
2021-01-03,MN,Mongolia,WPRO,21,1263,0,1
2021-01-04,MN,Mongolia,WPRO,23,1286,0,1
2021-01-05,MN,Mongolia,WPRO,22,1308,0,1
2021-01-06,MN,Mongolia,WPRO,41,1349,0,1
.
105354a
2022-02-10,MC,Monaco,EURO,42,8922,1,49
.
104585a
2022-02-10,FM,Micronesia (Federated States of),WPRO,0,0,0,0
.
103816a
2022-02-10,MX,Mexico,AMRO,6343,5167110,132,309884
.
103047a
2022-02-10,YT,Mayotte,AFRO,0,36556,0,187
.
102278a
2022-02-10,MU,Mauritius,AFRO,0,70862,0,786
.
101509a
2022-02-10,MR,Mauritania,AFRO,19,58527,2,971
.
100740a
2022-02-10,MQ,Martinique,AMRO,2993,102746,11,856
.
99971a
2022-02-10,MH,Marshall Islands,WPRO,0,4,0,0
.
99202a
2022-02-10,MT,Malta,EURO,172,69530,1,572
.
98433a
2022-02-10,ML,Mali,AFRO,0,30228,0,715
.
97664a
2022-02-10,MV,Maldives,SEARO,0,154511,0,286
.
96895a
2022-02-10,MY,Malaysia,WPRO,17134,2956332,9,32065
.
96126a
2022-02-10,MW,Malawi,AFRO,39,84915,5,2580
.
95357a
2022-02-10,MG,Madagascar,AFRO,0,61434,0,1307
.
94588a
2022-02-10,LU,Luxembourg,EURO,1352,171452,0,966
.
93819a
2022-02-10,LT,Lithuania,EURO,10758,787552,15,8046
.
93048,93050c
2022-02-07,LI,Liechtenstein,EURO,109,9961,0,70
2022-02-08,LI,Liechtenstein,EURO,163,10124,0,70
2022-02-09,LI,Liechtenstein,EURO,130,10254,0,70
2022-02-10,LI,Liechtenstein,EURO,0,10254,0,70
.
93044,93045c
2022-02-03,LI,Liechtenstein,EURO,113,9517,0,70
2022-02-04,LI,Liechtenstein,EURO,145,9662,0,70
.
92281a
2022-02-10,LY,Libya,EMRO,3272,459548,9,6096
.
91512a
2022-02-10,LR,Liberia,AFRO,12,7358,0,290
.
90743a
2022-02-10,LS,Lesotho,AFRO,0,32350,0,695
.
89974a
2022-02-10,LB,Lebanon,EMRO,8488,993095,19,9769
.
89205a
2022-02-10,LV,Latvia,EURO,11835,476730,9,4978
.
88436a
2022-02-10,LA,Lao People's Democratic Republic,WPRO,513,137616,6,583
.
87667a
2022-02-10,KG,Kyrgyzstan,EURO,107,199821,4,2917
.
86898a
2022-02-10,KW,Kuwait,EMRO,3463,590565,1,2514
.
86129a
2022-02-10,XK,Kosovo[1],EURO,1140,220166,5,3048
.
85360a
2022-02-10,KI,Kiribati,WPRO,222,2173,0,1
.
84591a
2022-02-10,KE,Kenya,AFRO,60,322274,1,5622
.
83822a
2022-02-10,KZ,Kazakhstan,EURO,3412,1370466,23,18716
.
83053a
2022-02-10,JO,Jordan,EMRO,21977,1396430,27,13409
.
82284a
2022-02-10,JE,Jersey,EURO,247,33414,0,106
.
81515a
2022-02-10,JP,Japan,WPRO,97946,3566188,155,19742
.
80746a
2022-02-10,JM,Jamaica,AMRO,87,126437,7,2706
.
79977a
2022-02-10,IT,Italy,EURO,81669,11847436,384,149896
.
78889,79208c
2021-03-27,IL,Israel,EURO,541,831991,11,6164
2021-03-28,IL,Israel,EURO,239,832230,6,6170
2021-03-29,IL,Israel,EURO,132,832362,13,6183
2021-03-30,IL,Israel,EURO,379,832741,11,6194
2021-03-31,IL,Israel,EURO,451,833192,13,6207
2021-04-01,IL,Israel,EURO,498,833690,14,6221
2021-04-02,IL,Israel,EURO,334,834024,8,6229
2021-04-03,IL,Israel,EURO,419,834443,15,6244
2021-04-04,IL,Israel,EURO,124,834567,7,6251
2021-04-05,IL,Israel,EURO,197,834764,8,6259
2021-04-06,IL,Israel,EURO,383,835147,6,6265
2021-04-07,IL,Israel,EURO,307,835454,8,6273
2021-04-08,IL,Israel,EURO,274,835728,9,6282
2021-04-09,IL,Israel,EURO,212,835940,9,6291
2021-04-10,IL,Israel,EURO,226,836166,10,6301
2021-04-11,IL,Israel,EURO,86,836252,9,6310
2021-04-12,IL,Israel,EURO,141,836393,6,6316
2021-04-13,IL,Israel,EURO,224,836617,6,6322
2021-04-14,IL,Israel,EURO,198,836815,13,6335
2021-04-15,IL,Israel,EURO,195,837010,3,6338
2021-04-16,IL,Israel,EURO,95,837105,3,6341
2021-04-17,IL,Israel,EURO,110,837215,5,6346
2021-04-18,IL,Israel,EURO,87,837302,7,6353
2021-04-19,IL,Israel,EURO,186,837488,4,6357
2021-04-20,IL,Israel,EURO,144,837632,3,6360
2021-04-21,IL,Israel,EURO,170,837802,4,6364
2021-04-22,IL,Israel,EURO,115,837917,2,6366
2021-04-23,IL,Israel,EURO,151,838068,2,6368
2021-04-24,IL,Israel,EURO,112,838180,5,6373
2021-04-25,IL,Israel,EURO,36,838216,4,6377
2021-04-26,IL,Israel,EURO,80,838296,1,6378
2021-04-27,IL,Israel,EURO,102,838398,3,6381
2021-04-28,IL,Israel,EURO,108,838506,6,6387
2021-04-29,IL,Israel,EURO,106,838612,0,6387
2021-04-30,IL,Israel,EURO,97,838709,2,6389
2021-05-01,IL,Israel,EURO,79,838788,2,6391
2021-05-02,IL,Israel,EURO,15,838803,2,6393
2021-05-03,IL,Israel,EURO,56,838859,1,6394
2021-05-04,IL,Israel,EURO,82,838941,3,6397
2021-05-05,IL,Israel,EURO,65,839006,2,6399
2021-05-06,IL,Israel,EURO,73,839079,2,6401
2021-05-07,IL,Israel,EURO,54,839133,2,6403
2021-05-08,IL,Israel,EURO,34,839167,2,6405
2021-05-09,IL,Israel,EURO,16,839183,1,6406
2021-05-10,IL,Israel,EURO,33,839216,1,6407
2021-05-11,IL,Israel,EURO,62,839278,2,6409
2021-05-12,IL,Israel,EURO,39,839317,1,6410
2021-05-13,IL,Israel,EURO,29,839346,1,6411
2021-05-14,IL,Israel,EURO,33,839379,2,6413
2021-05-15,IL,Israel,EURO,27,839406,0,6413
2021-05-16,IL,Israel,EURO,20,839426,1,6414
2021-05-17,IL,Israel,EURO,36,839462,1,6415
2021-05-18,IL,Israel,EURO,15,839477,3,6418
2021-05-19,IL,Israel,EURO,23,839500,0,6418
2021-05-20,IL,Israel,EURO,56,839556,0,6418
2021-05-21,IL,Israel,EURO,35,839591,0,6418
2021-05-22,IL,Israel,EURO,22,839613,2,6420
2021-05-23,IL,Israel,EURO,12,839625,0,6420
2021-05-24,IL,Israel,EURO,28,839653,1,6421
2021-05-25,IL,Israel,EURO,30,839683,1,6422
2021-05-26,IL,Israel,EURO,22,839705,1,6423
2021-05-27,IL,Israel,EURO,16,839721,0,6423
2021-05-28,IL,Israel,EURO,16,839737,2,6425
2021-05-29,IL,Israel,EURO,18,839755,1,6426
2021-05-30,IL,Israel,EURO,13,839768,0,6426
2021-05-31,IL,Israel,EURO,3,839771,0,6426
2021-06-01,IL,Israel,EURO,14,839785,0,6426
2021-06-02,IL,Israel,EURO,35,839820,2,6428
2021-06-03,IL,Israel,EURO,13,839833,0,6428
2021-06-04,IL,Israel,EURO,11,839844,1,6429
2021-06-05,IL,Israel,EURO,31,839875,0,6429
2021-06-06,IL,Israel,EURO,6,839881,1,6430
2021-06-07,IL,Israel,EURO,4,839885,0,6430
2021-06-08,IL,Israel,EURO,7,839892,1,6431
2021-06-09,IL,Israel,EURO,30,839922,1,6432
2021-06-10,IL,Israel,EURO,8,839930,1,6433
2021-06-11,IL,Israel,EURO,18,839948,0,6433
2021-06-12,IL,Israel,EURO,18,839966,0,6433
2021-06-13,IL,Israel,EURO,5,839971,0,6433
2021-06-14,IL,Israel,EURO,3,839974,1,6434
2021-06-15,IL,Israel,EURO,26,840000,0,6434
2021-06-16,IL,Israel,EURO,27,840027,0,6434
2021-06-17,IL,Israel,EURO,14,840041,1,6435
2021-06-18,IL,Israel,EURO,29,840070,0,6435
2021-06-19,IL,Israel,EURO,35,840105,0,6435
2021-06-20,IL,Israel,EURO,47,840152,1,6436
2021-06-21,IL,Israel,EURO,51,840203,0,6436
2021-06-22,IL,Israel,EURO,125,840328,0,6436
2021-06-23,IL,Israel,EURO,113,840441,0,6436
2021-06-24,IL,Israel,EURO,151,840592,0,6436
2021-06-25,IL,Israel,EURO,244,840836,0,6436
2021-06-26,IL,Israel,EURO,234,841070,1,6437
2021-06-27,IL,Israel,EURO,119,841189,0,6437
2021-06-28,IL,Israel,EURO,145,841334,0,6437
2021-06-29,IL,Israel,EURO,289,841623,0,6437
2021-06-30,IL,Israel,EURO,302,841925,0,6437
2021-07-01,IL,Israel,EURO,337,842262,0,6437
2021-07-02,IL,Israel,EURO,299,842561,0,6437
2021-07-03,IL,Israel,EURO,363,842924,0,6437
2021-07-04,IL,Israel,EURO,189,843113,0,6437
2021-07-05,IL,Israel,EURO,350,843463,0,6437
2021-07-06,IL,Israel,EURO,504,843967,0,6437
2021-07-07,IL,Israel,EURO,539,844506,0,6437
2021-07-08,IL,Israel,EURO,527,845033,1,6438
2021-07-09,IL,Israel,EURO,472,845505,2,6440
2021-07-10,IL,Israel,EURO,542,846047,0,6440
2021-07-11,IL,Israel,EURO,261,846308,2,6442
2021-07-12,IL,Israel,EURO,443,846751,3,6445
2021-07-13,IL,Israel,EURO,765,847516,2,6447
2021-07-14,IL,Israel,EURO,749,848265,0,6447
2021-07-15,IL,Israel,EURO,774,849039,3,6450
2021-07-16,IL,Israel,EURO,874,849913,1,6451
2021-07-17,IL,Israel,EURO,1146,851059,1,6452
2021-07-18,IL,Israel,EURO,439,851498,2,6454
2021-07-19,IL,Israel,EURO,838,852336,3,6457
2021-07-20,IL,Israel,EURO,1396,853732,2,6459
2021-07-21,IL,Israel,EURO,1413,855145,2,6461
2021-07-22,IL,Israel,EURO,1369,856514,3,6464
2021-07-23,IL,Israel,EURO,1289,857803,1,6465
2021-07-24,IL,Israel,EURO,1442,859245,0,6465
2021-07-25,IL,Israel,EURO,973,860218,3,6468
2021-07-26,IL,Israel,EURO,1431,861649,4,6472
2021-07-27,IL,Israel,EURO,2135,863784,1,6473
2021-07-28,IL,Israel,EURO,2301,866085,1,6474
2021-07-29,IL,Israel,EURO,2198,868283,6,6480
2021-07-30,IL,Israel,EURO,2180,870463,6,6486
2021-07-31,IL,Israel,EURO,2463,872926,2,6488
2021-08-01,IL,Israel,EURO,2104,875030,5,6493
2021-08-02,IL,Israel,EURO,2126,877156,9,6502
2021-08-03,IL,Israel,EURO,3862,881018,9,6511
2021-08-04,IL,Israel,EURO,3312,884330,10,6521
2021-08-05,IL,Israel,EURO,3510,887840,5,6526
2021-08-06,IL,Israel,EURO,3887,891727,16,6542
2021-08-07,IL,Israel,EURO,3890,895617,14,6556
2021-08-08,IL,Israel,EURO,2936,898553,12,6568
2021-08-09,IL,Israel,EURO,3447,902000,19,6587
2021-08-10,IL,Israel,EURO,6382,908382,11,6598
2021-08-11,IL,Israel,EURO,5860,914242,17,6615
2021-08-12,IL,Israel,EURO,6027,920269,16,6631
2021-08-13,IL,Israel,EURO,6154,926423,19,6650
2021-08-14,IL,Israel,EURO,5976,932399,24,6674
2021-08-15,IL,Israel,EURO,4233,936632,18,6692
2021-08-16,IL,Israel,EURO,5199,941831,20,6712
2021-08-17,IL,Israel,EURO,8798,950629,28,6740
2021-08-18,IL,Israel,EURO,7993,958622,20,6760
2021-08-19,IL,Israel,EURO,8037,966659,22,6782
2021-08-20,IL,Israel,EURO,7842,974501,24,6806
2021-08-21,IL,Israel,EURO,7908,982409,24,6830
2021-08-22,IL,Israel,EURO,5416,987825,25,6855
2021-08-23,IL,Israel,EURO,6594,994419,33,6888
2021-08-24,IL,Israel,EURO,10116,1004535,20,6908
2021-08-25,IL,Israel,EURO,10086,1014621,31,6939
2021-08-26,IL,Israel,EURO,9245,1023866,28,6967
2021-08-27,IL,Israel,EURO,9124,1032990,32,6999
2021-08-28,IL,Israel,EURO,8700,1041690,25,7024
2021-08-29,IL,Israel,EURO,7280,1048970,23,7047
2021-08-30,IL,Israel,EURO,6792,1055762,29,7076
2021-08-31,IL,Israel,EURO,11158,1066920,26,7102
2021-09-01,IL,Israel,EURO,10447,1077367,31,7133
2021-09-02,IL,Israel,EURO,11304,1088671,31,7164
2021-09-03,IL,Israel,EURO,11346,1100017,31,7195
2021-09-04,IL,Israel,EURO,9913,1109930,34,7229
2021-09-05,IL,Israel,EURO,5067,1114997,26,7255
2021-09-06,IL,Israel,EURO,5868,1120865,26,7281
2021-09-07,IL,Israel,EURO,10871,1131736,23,7304
2021-09-08,IL,Israel,EURO,6866,1138602,27,7331
2021-09-09,IL,Israel,EURO,3320,1141922,29,7360
2021-09-10,IL,Israel,EURO,7962,1149884,22,7382
2021-09-11,IL,Israel,EURO,9901,1159785,17,7399
2021-09-12,IL,Israel,EURO,10292,1170077,27,7426
2021-09-13,IL,Israel,EURO,7808,1177885,22,7448
2021-09-14,IL,Israel,EURO,10955,1188840,20,7468
2021-09-15,IL,Israel,EURO,9859,1198699,29,7497
2021-09-16,IL,Israel,EURO,8865,1207564,20,7517
2021-09-17,IL,Israel,EURO,3286,1210850,21,7538
2021-09-18,IL,Israel,EURO,5024,1215874,17,7555
2021-09-19,IL,Israel,EURO,8617,1224491,17,7572
2021-09-20,IL,Israel,EURO,6553,1231044,28,7600
2021-09-21,IL,Israel,EURO,8828,1239872,15,7615
2021-09-22,IL,Israel,EURO,4828,1244700,17,7632
2021-09-23,IL,Israel,EURO,6026,1250726,19,7651
2021-09-24,IL,Israel,EURO,6453,1257179,19,7670
2021-09-25,IL,Israel,EURO,4990,1262169,21,7691
2021-09-26,IL,Israel,EURO,2653,1264822,24,7715
2021-09-27,IL,Israel,EURO,3874,1268696,14,7729
2021-09-28,IL,Israel,EURO,5246,1273942,17,7746
2021-09-29,IL,Israel,EURO,2441,1276383,21,7767
2021-09-30,IL,Israel,EURO,3636,1280019,23,7790
2021-10-01,IL,Israel,EURO,4398,1284417,14,7804
2021-10-02,IL,Israel,EURO,3622,1288039,22,7826
2021-10-03,IL,Israel,EURO,1739,1289778,18,7844
2021-10-04,IL,Israel,EURO,2700,1292478,23,7867
2021-10-05,IL,Israel,EURO,3278,1295756,11,7878
2021-10-06,IL,Israel,EURO,2556,1298312,15,7893
2021-10-07,IL,Israel,EURO,2429,1300741,15,7908
2021-10-08,IL,Israel,EURO,2120,1302861,17,7925
2021-10-09,IL,Israel,EURO,2024,1304885,6,7931
2021-10-10,IL,Israel,EURO,1040,1305925,14,7945
2021-10-11,IL,Israel,EURO,1490,1307415,14,7959
2021-10-12,IL,Israel,EURO,2343,1309758,13,7972
2021-10-13,IL,Israel,EURO,1816,1311574,10,7982
2021-10-14,IL,Israel,EURO,1772,1313346,11,7993
2021-10-15,IL,Israel,EURO,1345,1314691,14,8007
2021-10-16,IL,Israel,EURO,1575,1316266,10,8017
2021-10-17,IL,Israel,EURO,740,1317006,9,8026
2021-10-18,IL,Israel,EURO,1221,1318227,6,8032
2021-10-19,IL,Israel,EURO,1508,1319735,9,8041
2021-10-20,IL,Israel,EURO,1150,1320885,3,8044
2021-10-21,IL,Israel,EURO,1036,1321921,8,8052
2021-10-22,IL,Israel,EURO,993,1322914,7,8059
2021-10-23,IL,Israel,EURO,982,1323896,4,8063
2021-10-24,IL,Israel,EURO,332,1324228,8,8071
2021-10-25,IL,Israel,EURO,842,1325070,6,8077
2021-10-26,IL,Israel,EURO,929,1325999,11,8088
2021-10-27,IL,Israel,EURO,729,1326728,9,8097
2021-10-28,IL,Israel,EURO,648,1327376,5,8102
2021-10-29,IL,Israel,EURO,661,1328037,7,8109
2021-10-30,IL,Israel,EURO,617,1328654,6,8115
2021-10-31,IL,Israel,EURO,225,1328879,3,8118
2021-11-01,IL,Israel,EURO,528,1329407,2,8120
2021-11-02,IL,Israel,EURO,691,1330098,4,8124
2021-11-03,IL,Israel,EURO,667,1330765,3,8127
2021-11-04,IL,Israel,EURO,616,1331381,5,8132
2021-11-05,IL,Israel,EURO,519,1331900,6,8138
2021-11-06,IL,Israel,EURO,558,1332458,1,8139
2021-11-07,IL,Israel,EURO,199,1332657,1,8140
2021-11-08,IL,Israel,EURO,502,1333159,4,8144
2021-11-09,IL,Israel,EURO,566,1333725,3,8147
2021-11-10,IL,Israel,EURO,473,1334198,6,8153
2021-11-11,IL,Israel,EURO,498,1334696,5,8158
2021-11-12,IL,Israel,EURO,393,1335089,3,8161
2021-11-13,IL,Israel,EURO,448,1335537,2,8163
2021-11-14,IL,Israel,EURO,225,1335762,2,8165
2021-11-15,IL,Israel,EURO,397,1336159,0,8165
2021-11-16,IL,Israel,EURO,535,1336694,5,8170
2021-11-17,IL,Israel,EURO,558,1337252,4,8174
2021-11-18,IL,Israel,EURO,483,1337735,1,8175
2021-11-19,IL,Israel,EURO,469,1338204,3,8178
2021-11-20,IL,Israel,EURO,508,1338712,3,8181
2021-11-21,IL,Israel,EURO,237,1338949,6,8187
2021-11-22,IL,Israel,EURO,453,1339402,1,8188
2021-11-23,IL,Israel,EURO,715,1340117,2,8190
2021-11-24,IL,Israel,EURO,604,1340721,0,8190
2021-11-25,IL,Israel,EURO,543,1341264,3,8193
2021-11-26,IL,Israel,EURO,540,1341804,3,8196
2021-11-27,IL,Israel,EURO,540,1342344,2,8198
2021-11-28,IL,Israel,EURO,169,1342513,1,8199
2021-11-29,IL,Israel,EURO,543,1343056,3,8202
2021-11-30,IL,Israel,EURO,698,1343754,3,8205
2021-12-01,IL,Israel,EURO,577,1344331,3,8208
2021-12-02,IL,Israel,EURO,563,1344894,1,8209
2021-12-03,IL,Israel,EURO,520,1345414,2,8211
2021-12-04,IL,Israel,EURO,486,1345900,1,8212
2021-12-05,IL,Israel,EURO,248,1346148,2,8214
2021-12-06,IL,Israel,EURO,539,1346687,1,8215
2021-12-07,IL,Israel,EURO,739,1347426,2,8217
2021-12-08,IL,Israel,EURO,813,1348239,3,8220
2021-12-09,IL,Israel,EURO,714,1348953,6,8226
2021-12-10,IL,Israel,EURO,647,1349600,1,8227
2021-12-11,IL,Israel,EURO,607,1350207,2,8229
2021-12-12,IL,Israel,EURO,236,1350443,1,8230
2021-12-13,IL,Israel,EURO,492,1350935,2,8232
2021-12-14,IL,Israel,EURO,771,1351706,4,8236
2021-12-15,IL,Israel,EURO,702,1352408,1,8237
2021-12-16,IL,Israel,EURO,789,1353197,1,8238
2021-12-17,IL,Israel,EURO,863,1354060,1,8239
2021-12-18,IL,Israel,EURO,877,1354937,2,8241
2021-12-19,IL,Israel,EURO,393,1355330,2,8243
2021-12-20,IL,Israel,EURO,1021,1356351,2,8245
2021-12-21,IL,Israel,EURO,1329,1357680,2,8247
2021-12-22,IL,Israel,EURO,1200,1358880,0,8247
2021-12-23,IL,Israel,EURO,1417,1360297,0,8247
2021-12-24,IL,Israel,EURO,1514,1361811,1,8248
2021-12-25,IL,Israel,EURO,1789,1363600,1,8249
2021-12-26,IL,Israel,EURO,806,1364406,0,8249
2021-12-27,IL,Israel,EURO,1806,1366212,2,8251
2021-12-28,IL,Israel,EURO,2974,1369186,3,8254
2021-12-29,IL,Israel,EURO,3246,1372432,1,8255
2021-12-30,IL,Israel,EURO,4073,1376505,2,8257
2021-12-31,IL,Israel,EURO,5081,1381586,0,8257
2022-01-01,IL,Israel,EURO,5493,1387079,1,8258
2022-01-02,IL,Israel,EURO,4231,1391310,2,8260
2022-01-03,IL,Israel,EURO,6615,1397925,5,8265
2022-01-04,IL,Israel,EURO,10954,1408879,4,8269
2022-01-05,IL,Israel,EURO,12640,1421519,1,8270
2022-01-06,IL,Israel,EURO,18546,1440065,4,8274
2022-01-07,IL,Israel,EURO,19039,1459104,2,8276
2022-01-08,IL,Israel,EURO,21992,1481096,3,8279
2022-01-09,IL,Israel,EURO,22874,1503970,5,8284
2022-01-10,IL,Israel,EURO,31152,1535122,7,8291
2022-01-11,IL,Israel,EURO,41415,1576537,9,8300
2022-01-12,IL,Israel,EURO,46789,1623326,7,8307
2022-01-13,IL,Israel,EURO,48611,1671937,7,8314
2022-01-14,IL,Israel,EURO,49267,1721204,9,8323
2022-01-15,IL,Israel,EURO,45861,1767065,10,8333
2022-01-16,IL,Israel,EURO,45065,1812130,17,8350
2022-01-17,IL,Israel,EURO,64732,1876862,17,8367
2022-01-18,IL,Israel,EURO,72009,1948871,20,8387
2022-01-19,IL,Israel,EURO,73785,2022656,17,8404
2022-01-20,IL,Israel,EURO,74966,2097622,23,8427
2022-01-21,IL,Israel,EURO,75057,2172679,24,8451
2022-01-22,IL,Israel,EURO,65597,2238276,33,8484
2022-01-23,IL,Israel,EURO,67893,2306169,40,8524
2022-01-24,IL,Israel,EURO,85175,2391344,39,8563
2022-01-25,IL,Israel,EURO,83678,2475022,54,8617
2022-01-26,IL,Israel,EURO,76306,2551328,42,8659
2022-01-27,IL,Israel,EURO,67860,2619188,51,8710
2022-01-28,IL,Israel,EURO,57675,2676863,37,8747
2022-01-29,IL,Israel,EURO,53318,2730181,51,8798
2022-01-30,IL,Israel,EURO,49466,2779647,52,8850
2022-01-31,IL,Israel,EURO,74401,2854048,56,8906
2022-02-01,IL,Israel,EURO,67879,2921927,51,8957
2022-02-02,IL,Israel,EURO,60551,2982478,60,9017
2022-02-03,IL,Israel,EURO,60910,3043388,60,9077
2022-02-04,IL,Israel,EURO,46742,3090130,57,9134
2022-02-05,IL,Israel,EURO,38150,3128280,38,9172
2022-02-06,IL,Israel,EURO,33490,3161770,47,9219
2022-02-07,IL,Israel,EURO,52720,3214490,43,9262
2022-02-08,IL,Israel,EURO,44021,3258511,56,9318
2022-02-09,IL,Israel,EURO,37699,3296210,38,9356
2022-02-10,IL,Israel,EURO,36835,3333045,14,9370
.
78870,78886c
2021-03-08,IL,Israel,EURO,2364,802867,16,5892
2021-03-09,IL,Israel,EURO,3796,806663,21,5913
2021-03-10,IL,Israel,EURO,3127,809790,15,5928
2021-03-11,IL,Israel,EURO,2843,812633,17,5945
2021-03-12,IL,Israel,EURO,2553,815186,18,5963
2021-03-13,IL,Israel,EURO,2414,817600,12,5975
2021-03-14,IL,Israel,EURO,787,818387,16,5991
2021-03-15,IL,Israel,EURO,1410,819797,26,6017
2021-03-16,IL,Israel,EURO,2130,821927,17,6034
2021-03-17,IL,Israel,EURO,1566,823493,16,6050
2021-03-18,IL,Israel,EURO,1541,825034,14,6064
2021-03-19,IL,Israel,EURO,1254,826288,9,6073
2021-03-20,IL,Israel,EURO,1085,827373,12,6085
2021-03-21,IL,Israel,EURO,351,827724,7,6092
2021-03-22,IL,Israel,EURO,681,828405,14,6106
2021-03-23,IL,Israel,EURO,987,829392,14,6120
2021-03-24,IL,Israel,EURO,694,830086,14,6134
.
78802,78846c
2020-12-30,IL,Israel,EURO,5631,413900,25,3321
2020-12-31,IL,Israel,EURO,5871,419771,16,3337
2021-01-01,IL,Israel,EURO,5866,425637,36,3373
2021-01-02,IL,Israel,EURO,6014,431651,34,3407
2021-01-03,IL,Israel,EURO,4212,435863,27,3434
2021-01-04,IL,Israel,EURO,5232,441095,26,3460
2021-01-05,IL,Israel,EURO,8424,449519,38,3498
2021-01-06,IL,Israel,EURO,8232,457751,23,3521
2021-01-07,IL,Israel,EURO,7884,465635,43,3564
2021-01-08,IL,Israel,EURO,7664,473299,48,3612
2021-01-09,IL,Israel,EURO,8162,481461,46,3658
2021-01-10,IL,Israel,EURO,5165,486626,20,3678
2021-01-11,IL,Israel,EURO,6956,493582,43,3721
2021-01-12,IL,Israel,EURO,9730,503312,28,3749
2021-01-13,IL,Israel,EURO,9298,512610,55,3804
2021-01-14,IL,Israel,EURO,9474,522084,57,3861
2021-01-15,IL,Israel,EURO,9301,531385,59,3920
2021-01-16,IL,Israel,EURO,8431,539816,52,3972
2021-01-17,IL,Israel,EURO,5086,544902,47,4019
2021-01-18,IL,Israel,EURO,5661,550563,56,4075
2021-01-19,IL,Israel,EURO,10123,560686,46,4121
2021-01-20,IL,Israel,EURO,8633,569319,43,4164
2021-01-21,IL,Israel,EURO,8361,577680,56,4220
2021-01-22,IL,Israel,EURO,7269,584949,47,4267
2021-01-23,IL,Israel,EURO,7387,592336,66,4333
2021-01-24,IL,Israel,EURO,2447,594783,52,4385
2021-01-25,IL,Israel,EURO,4938,599721,75,4460
2021-01-26,IL,Israel,EURO,8718,608439,60,4520
2021-01-27,IL,Israel,EURO,7817,616256,53,4573
2021-01-28,IL,Israel,EURO,7750,624006,61,4634
2021-01-29,IL,Israel,EURO,7196,631202,49,4683
2021-01-30,IL,Israel,EURO,6776,637978,45,4728
2021-01-31,IL,Israel,EURO,2628,640606,38,4766
2021-02-01,IL,Israel,EURO,5240,645846,51,4817
2021-02-02,IL,Israel,EURO,8931,654777,46,4863
2021-02-03,IL,Israel,EURO,8024,662801,61,4924
2021-02-04,IL,Israel,EURO,7462,670263,57,4981
2021-02-05,IL,Israel,EURO,7262,677525,48,5029
2021-02-06,IL,Israel,EURO,6600,684125,34,5063
2021-02-07,IL,Israel,EURO,2660,686785,51,5114
2021-02-08,IL,Israel,EURO,4605,691390,44,5158
2021-02-09,IL,Israel,EURO,7856,699246,30,5188
2021-02-10,IL,Israel,EURO,6169,705415,42,5230
2021-02-11,IL,Israel,EURO,5678,711093,32,5262
2021-02-12,IL,Israel,EURO,5058,716151,30,5292
.
78630,78685c
2020-07-11,IL,Israel,EURO,1406,36904,4,370
2020-07-12,IL,Israel,EURO,1168,38072,5,375
2020-07-13,IL,Israel,EURO,1236,39308,7,382
2020-07-14,IL,Israel,EURO,1717,41025,4,386
2020-07-15,IL,Israel,EURO,1601,42626,7,393
2020-07-16,IL,Israel,EURO,1873,44499,6,399
2020-07-17,IL,Israel,EURO,1936,46435,9,408
2020-07-18,IL,Israel,EURO,1601,48036,12,420
2020-07-19,IL,Israel,EURO,1444,49480,8,428
2020-07-20,IL,Israel,EURO,1016,50496,10,438
2020-07-21,IL,Israel,EURO,1886,52382,12,450
2020-07-22,IL,Israel,EURO,2004,54386,9,459
2020-07-23,IL,Israel,EURO,2041,56427,6,465
2020-07-24,IL,Israel,EURO,1987,58414,16,481
2020-07-25,IL,Israel,EURO,1824,60238,8,489
2020-07-26,IL,Israel,EURO,1110,61348,7,496
2020-07-27,IL,Israel,EURO,1040,62388,11,507
2020-07-28,IL,Israel,EURO,2048,64436,7,514
2020-07-29,IL,Israel,EURO,2120,66556,8,522
2020-07-30,IL,Israel,EURO,1957,68513,15,537
2020-07-31,IL,Israel,EURO,1786,70299,15,552
2020-08-01,IL,Israel,EURO,1359,71658,14,566
2020-08-02,IL,Israel,EURO,623,72281,14,580
2020-08-03,IL,Israel,EURO,708,72989,12,592
2020-08-04,IL,Israel,EURO,1799,74788,15,607
2020-08-05,IL,Israel,EURO,1726,76514,11,618
2020-08-06,IL,Israel,EURO,1686,78200,10,628
2020-08-07,IL,Israel,EURO,1675,79875,9,637
2020-08-08,IL,Israel,EURO,1761,81636,12,649
2020-08-09,IL,Israel,EURO,755,82391,13,662
2020-08-10,IL,Israel,EURO,922,83313,8,670
2020-08-11,IL,Israel,EURO,1697,85010,15,685
2020-08-12,IL,Israel,EURO,1823,86833,11,696
2020-08-13,IL,Israel,EURO,1617,88450,16,712
2020-08-14,IL,Israel,EURO,1640,90090,16,728
2020-08-15,IL,Israel,EURO,1390,91480,12,740
2020-08-16,IL,Israel,EURO,754,92234,10,750
2020-08-17,IL,Israel,EURO,1069,93303,20,770
2020-08-18,IL,Israel,EURO,1649,94952,4,774
2020-08-19,IL,Israel,EURO,1647,96599,14,788
2020-08-20,IL,Israel,EURO,1639,98238,12,800
2020-08-21,IL,Israel,EURO,1485,99723,14,814
2020-08-22,IL,Israel,EURO,1491,101214,13,827
2020-08-23,IL,Israel,EURO,710,101924,10,837
2020-08-24,IL,Israel,EURO,964,102888,13,850
2020-08-25,IL,Israel,EURO,1901,104789,16,866
2020-08-26,IL,Israel,EURO,1958,106747,19,885
2020-08-27,IL,Israel,EURO,1984,108731,11,896
2020-08-28,IL,Israel,EURO,2106,110837,11,907
2020-08-29,IL,Israel,EURO,1833,112670,13,920
2020-08-30,IL,Israel,EURO,909,113579,5,925
2020-08-31,IL,Israel,EURO,1100,114679,14,939
2020-09-01,IL,Israel,EURO,2171,116850,23,962
2020-09-02,IL,Israel,EURO,2255,119105,15,977
2020-09-03,IL,Israel,EURO,3194,122299,13,990
2020-09-04,IL,Israel,EURO,2666,124965,16,1006
.
78439a
2022-02-10,IM,Isle of Man,EURO,31,21951,0,73
.
77670a
2022-02-10,IE,Ireland,EURO,5677,1230539,63,6291
.
76901a
2022-02-10,IQ,Iraq,EMRO,4681,2263525,30,24600
.
76132a
2022-02-10,IR,Iran (Islamic Republic of),EMRO,39085,6696927,116,133164
.
75363a
2022-02-10,ID,Indonesia,SEARO,40618,4667554,74,144858
.
74594a
2022-02-10,IN,India,SEARO,67084,42478060,1241,506520
.
73825a
2022-02-10,IS,Iceland,EURO,1961,83942,2,52
.
73056a
2022-02-10,HU,Hungary,EURO,12885,1684432,99,42269
.
72287c
2022-02-09,HN,Honduras,AMRO,2293,401193,6,10557
2022-02-10,HN,Honduras,AMRO,1136,402329,2,10559
.
71518a
2022-02-10,VA,Holy See,EURO,0,26,0,0
.
70749a
2022-02-10,HT,Haiti,AMRO,0,29549,0,804
.
69980a
2022-02-10,GY,Guyana,AMRO,118,61734,3,1185
.
69211a
2022-02-10,GW,Guinea-Bissau,AFRO,11,7813,0,158
.
68442a
2022-02-10,GN,Guinea,AFRO,16,36297,0,432
.
67671,67673c
2022-02-07,GG,Guernsey,EURO,72,11849,0,31
2022-02-08,GG,Guernsey,EURO,66,11915,0,31
2022-02-09,GG,Guernsey,EURO,146,12061,0,31
2022-02-10,GG,Guernsey,EURO,103,12164,0,31
.
66903,66904c
2022-02-08,GT,Guatemala,AMRO,1166,711076,6,16501
2022-02-09,GT,Guatemala,AMRO,981,712057,8,16509
2022-02-10,GT,Guatemala,AMRO,4025,716082,18,16527
.
66900,66901c
2022-02-05,GT,Guatemala,AMRO,3925,702310,25,16446
2022-02-06,GT,Guatemala,AMRO,3304,705614,24,16470
.
66135a
2022-02-10,GU,Guam,WPRO,0,30914,4,303
.
65366a
2022-02-10,GP,Guadeloupe,AMRO,0,104179,0,855
.
64597a
2022-02-10,GD,Grenada,AMRO,155,13041,1,212
.
63828a
2022-02-10,GL,Greenland,EURO,33,11333,0,7
.
63059a
2022-02-10,GR,Greece,EURO,19616,2109999,88,24410
.
62290a
2022-02-10,GI,Gibraltar,EURO,127,14039,0,101
.
61521a
2022-02-10,GH,Ghana,AFRO,0,157751,0,1419
.
60752a
2022-02-10,DE,Germany,EURO,247862,11769540,238,119453
.
59983a
2022-02-10,GE,Georgia,EURO,22444,1398059,53,15404
.
59214a
2022-02-10,GM,Gambia,AFRO,0,11911,0,365
.
58445a
2022-02-10,GA,Gabon,AFRO,37,47399,0,302
.
57676a
2022-02-10,PF,French Polynesia,WPRO,0,51723,0,636
.
56907a
2022-02-10,GF,French Guiana,AMRO,120,76893,0,383
.
56138a
2022-02-10,FR,France,EURO,0,20451810,0,130732
.
55025,55369c
2021-03-02,FI,Finland,EURO,870,59635,7,792
2021-03-03,FI,Finland,EURO,756,60391,2,794
2021-03-04,FI,Finland,EURO,734,61125,1,795
2021-03-05,FI,Finland,EURO,638,61763,2,797
2021-03-06,FI,Finland,EURO,630,62393,3,800
2021-03-07,FI,Finland,EURO,432,62825,1,801
2021-03-08,FI,Finland,EURO,396,63221,2,803
2021-03-09,FI,Finland,EURO,834,64055,9,812
2021-03-10,FI,Finland,EURO,770,64825,4,816
2021-03-11,FI,Finland,EURO,822,65647,4,820
2021-03-12,FI,Finland,EURO,780,66427,4,824
2021-03-13,FI,Finland,EURO,808,67235,4,828
2021-03-14,FI,Finland,EURO,495,67730,4,832
2021-03-15,FI,Finland,EURO,435,68165,0,832
2021-03-16,FI,Finland,EURO,892,69057,1,833
2021-03-17,FI,Finland,EURO,767,69824,1,834
2021-03-18,FI,Finland,EURO,744,70568,3,837
2021-03-19,FI,Finland,EURO,739,71307,4,841
2021-03-20,FI,Finland,EURO,745,72052,7,848
2021-03-21,FI,Finland,EURO,403,72455,4,852
2021-03-22,FI,Finland,EURO,421,72876,0,852
2021-03-23,FI,Finland,EURO,768,73644,6,858
2021-03-24,FI,Finland,EURO,703,74347,5,863
2021-03-25,FI,Finland,EURO,695,75042,4,867
2021-03-26,FI,Finland,EURO,607,75649,2,869
2021-03-27,FI,Finland,EURO,689,76338,3,872
2021-03-28,FI,Finland,EURO,352,76690,4,876
2021-03-29,FI,Finland,EURO,375,77065,1,877
2021-03-30,FI,Finland,EURO,655,77720,3,880
2021-03-31,FI,Finland,EURO,572,78292,2,882
2021-04-01,FI,Finland,EURO,551,78843,1,883
2021-04-02,FI,Finland,EURO,487,79330,2,885
2021-04-03,FI,Finland,EURO,361,79691,2,887
2021-04-04,FI,Finland,EURO,324,80015,3,890
2021-04-05,FI,Finland,EURO,322,80337,1,891
2021-04-06,FI,Finland,EURO,360,80697,0,891
2021-04-07,FI,Finland,EURO,545,81242,1,892
2021-04-08,FI,Finland,EURO,425,81667,4,896
2021-04-09,FI,Finland,EURO,407,82074,1,897
2021-04-10,FI,Finland,EURO,352,82426,2,899
2021-04-11,FI,Finland,EURO,227,82653,2,901
2021-04-12,FI,Finland,EURO,240,82893,0,901
2021-04-13,FI,Finland,EURO,405,83298,1,902
2021-04-14,FI,Finland,EURO,323,83621,4,906
2021-04-15,FI,Finland,EURO,344,83965,1,907
2021-04-16,FI,Finland,EURO,274,84239,2,909
2021-04-17,FI,Finland,EURO,265,84504,5,914
2021-04-18,FI,Finland,EURO,172,84676,2,916
2021-04-19,FI,Finland,EURO,157,84833,0,916
2021-04-20,FI,Finland,EURO,286,85119,3,919
2021-04-21,FI,Finland,EURO,286,85405,1,920
2021-04-22,FI,Finland,EURO,233,85638,2,922
2021-04-23,FI,Finland,EURO,257,85895,0,922
2021-04-24,FI,Finland,EURO,255,86150,1,923
2021-04-25,FI,Finland,EURO,154,86304,1,924
2021-04-26,FI,Finland,EURO,140,86444,0,924
2021-04-27,FI,Finland,EURO,242,86686,3,927
2021-04-28,FI,Finland,EURO,229,86915,2,929
2021-04-29,FI,Finland,EURO,275,87190,2,931
2021-04-30,FI,Finland,EURO,201,87391,1,932
2021-05-01,FI,Finland,EURO,197,87588,2,934
2021-05-02,FI,Finland,EURO,109,87697,0,934
2021-05-03,FI,Finland,EURO,135,87832,2,936
2021-05-04,FI,Finland,EURO,316,88148,0,936
2021-05-05,FI,Finland,EURO,206,88354,0,936
2021-05-06,FI,Finland,EURO,265,88619,1,937
2021-05-07,FI,Finland,EURO,239,88858,2,939
2021-05-08,FI,Finland,EURO,214,89072,1,940
2021-05-09,FI,Finland,EURO,134,89206,0,940
2021-05-10,FI,Finland,EURO,130,89336,0,940
2021-05-11,FI,Finland,EURO,257,89593,1,941
2021-05-12,FI,Finland,EURO,215,89808,1,942
2021-05-13,FI,Finland,EURO,256,90064,2,944
2021-05-14,FI,Finland,EURO,157,90221,2,946
2021-05-15,FI,Finland,EURO,249,90470,5,951
2021-05-16,FI,Finland,EURO,164,90634,6,957
2021-05-17,FI,Finland,EURO,134,90768,2,959
2021-05-18,FI,Finland,EURO,284,91052,0,959
2021-05-19,FI,Finland,EURO,217,91269,3,962
2021-05-20,FI,Finland,EURO,231,91500,6,968
2021-05-21,FI,Finland,EURO,217,91717,0,968
2021-05-22,FI,Finland,EURO,169,91886,0,968
2021-05-23,FI,Finland,EURO,108,91994,2,970
2021-05-24,FI,Finland,EURO,93,92087,2,972
2021-05-25,FI,Finland,EURO,188,92275,0,972
2021-05-26,FI,Finland,EURO,153,92428,0,972
2021-05-27,FI,Finland,EURO,143,92571,1,973
2021-05-28,FI,Finland,EURO,127,92698,0,973
2021-05-29,FI,Finland,EURO,135,92833,0,973
2021-05-30,FI,Finland,EURO,64,92897,0,973
2021-05-31,FI,Finland,EURO,78,92975,2,975
2021-06-01,FI,Finland,EURO,150,93125,0,975
2021-06-02,FI,Finland,EURO,122,93247,1,976
2021-06-03,FI,Finland,EURO,119,93366,0,976
2021-06-04,FI,Finland,EURO,111,93477,0,976
2021-06-05,FI,Finland,EURO,102,93579,1,977
2021-06-06,FI,Finland,EURO,64,93643,0,977
2021-06-07,FI,Finland,EURO,60,93703,0,977
2021-06-08,FI,Finland,EURO,139,93842,1,978
2021-06-09,FI,Finland,EURO,101,93943,1,979
2021-06-10,FI,Finland,EURO,81,94024,0,979
2021-06-11,FI,Finland,EURO,73,94097,1,980
2021-06-12,FI,Finland,EURO,70,94167,0,980
2021-06-13,FI,Finland,EURO,46,94213,0,980
2021-06-14,FI,Finland,EURO,48,94261,0,980
2021-06-15,FI,Finland,EURO,93,94354,0,980
2021-06-16,FI,Finland,EURO,78,94432,2,982
2021-06-17,FI,Finland,EURO,64,94496,0,982
2021-06-18,FI,Finland,EURO,91,94587,0,982
2021-06-19,FI,Finland,EURO,81,94668,0,982
2021-06-20,FI,Finland,EURO,57,94725,0,982
2021-06-21,FI,Finland,EURO,80,94805,0,982
2021-06-22,FI,Finland,EURO,112,94917,1,983
2021-06-23,FI,Finland,EURO,109,95026,0,983
2021-06-24,FI,Finland,EURO,143,95169,1,984
2021-06-25,FI,Finland,EURO,162,95331,0,984
2021-06-26,FI,Finland,EURO,195,95526,0,984
2021-06-27,FI,Finland,EURO,131,95657,0,984
2021-06-28,FI,Finland,EURO,119,95776,0,984
2021-06-29,FI,Finland,EURO,230,96006,0,984
2021-06-30,FI,Finland,EURO,261,96267,0,984
2021-07-01,FI,Finland,EURO,196,96463,0,984
2021-07-02,FI,Finland,EURO,203,96666,0,984
2021-07-03,FI,Finland,EURO,167,96833,0,984
2021-07-04,FI,Finland,EURO,132,96965,0,984
2021-07-05,FI,Finland,EURO,108,97073,0,984
2021-07-06,FI,Finland,EURO,243,97316,1,985
2021-07-07,FI,Finland,EURO,261,97577,1,986
2021-07-08,FI,Finland,EURO,292,97869,0,986
2021-07-09,FI,Finland,EURO,284,98153,0,986
2021-07-10,FI,Finland,EURO,308,98461,0,986
2021-07-11,FI,Finland,EURO,149,98610,0,986
2021-07-12,FI,Finland,EURO,160,98770,2,988
2021-07-13,FI,Finland,EURO,330,99100,2,990
2021-07-14,FI,Finland,EURO,342,99442,1,991
2021-07-15,FI,Finland,EURO,381,99823,0,991
2021-07-16,FI,Finland,EURO,382,100205,0,991
2021-07-17,FI,Finland,EURO,355,100560,0,991
2021-07-18,FI,Finland,EURO,206,100766,0,991
2021-07-19,FI,Finland,EURO,249,101015,0,991
2021-07-20,FI,Finland,EURO,420,101435,0,991
2021-07-21,FI,Finland,EURO,424,101859,0,991
2021-07-22,FI,Finland,EURO,468,102327,2,993
2021-07-23,FI,Finland,EURO,487,102814,0,993
2021-07-24,FI,Finland,EURO,478,103292,2,995
2021-07-25,FI,Finland,EURO,301,103593,1,996
2021-07-26,FI,Finland,EURO,351,103944,1,997
2021-07-27,FI,Finland,EURO,771,104715,2,999
2021-07-28,FI,Finland,EURO,726,105441,1,1000
2021-07-29,FI,Finland,EURO,810,106251,1,1001
2021-07-30,FI,Finland,EURO,772,107023,4,1005
2021-07-31,FI,Finland,EURO,696,107719,0,1005
2021-08-01,FI,Finland,EURO,408,108127,1,1006
2021-08-02,FI,Finland,EURO,477,108604,0,1006
2021-08-03,FI,Finland,EURO,893,109497,3,1009
2021-08-04,FI,Finland,EURO,840,110337,3,1012
2021-08-05,FI,Finland,EURO,784,111121,4,1016
2021-08-06,FI,Finland,EURO,876,111997,1,1017
2021-08-07,FI,Finland,EURO,685,112682,2,1019
2021-08-08,FI,Finland,EURO,486,113168,4,1023
2021-08-09,FI,Finland,EURO,537,113705,0,1023
2021-08-10,FI,Finland,EURO,1037,114742,1,1024
2021-08-11,FI,Finland,EURO,826,115568,1,1025
2021-08-12,FI,Finland,EURO,923,116491,1,1026
2021-08-13,FI,Finland,EURO,789,117280,1,1027
2021-08-14,FI,Finland,EURO,740,118020,2,1029
2021-08-15,FI,Finland,EURO,426,118446,0,1029
2021-08-16,FI,Finland,EURO,445,118891,2,1031
2021-08-17,FI,Finland,EURO,768,119659,0,1031
2021-08-18,FI,Finland,EURO,741,120400,1,1032
2021-08-19,FI,Finland,EURO,708,121108,3,1035
2021-08-20,FI,Finland,EURO,670,121778,2,1037
2021-08-21,FI,Finland,EURO,655,122433,1,1038
2021-08-22,FI,Finland,EURO,397,122830,0,1038
2021-08-23,FI,Finland,EURO,457,123287,2,1040
2021-08-24,FI,Finland,EURO,682,123969,1,1041
2021-08-25,FI,Finland,EURO,608,124577,3,1044
2021-08-26,FI,Finland,EURO,699,125276,2,1046
2021-08-27,FI,Finland,EURO,610,125886,2,1048
2021-08-28,FI,Finland,EURO,704,126590,2,1050
2021-08-29,FI,Finland,EURO,439,127029,0,1050
2021-08-30,FI,Finland,EURO,464,127493,1,1051
2021-08-31,FI,Finland,EURO,744,128237,6,1057
2021-09-01,FI,Finland,EURO,651,128888,2,1059
2021-09-02,FI,Finland,EURO,648,129536,1,1060
2021-09-03,FI,Finland,EURO,650,130186,2,1062
2021-09-04,FI,Finland,EURO,520,130706,1,1063
2021-09-05,FI,Finland,EURO,336,131042,0,1063
2021-09-06,FI,Finland,EURO,346,131388,0,1063
2021-09-07,FI,Finland,EURO,581,131969,6,1069
2021-09-08,FI,Finland,EURO,521,132490,3,1072
2021-09-09,FI,Finland,EURO,482,132972,1,1073
2021-09-10,FI,Finland,EURO,461,133433,2,1075
2021-09-11,FI,Finland,EURO,496,133929,0,1075
2021-09-12,FI,Finland,EURO,331,134260,1,1076
2021-09-13,FI,Finland,EURO,283,134543,5,1081
2021-09-14,FI,Finland,EURO,534,135077,1,1082
2021-09-15,FI,Finland,EURO,480,135557,2,1084
2021-09-16,FI,Finland,EURO,454,136011,1,1085
2021-09-17,FI,Finland,EURO,437,136448,1,1086
2021-09-18,FI,Finland,EURO,389,136837,1,1087
2021-09-19,FI,Finland,EURO,240,137077,0,1087
2021-09-20,FI,Finland,EURO,285,137362,5,1092
2021-09-21,FI,Finland,EURO,489,137851,1,1093
2021-09-22,FI,Finland,EURO,489,138340,1,1094
2021-09-23,FI,Finland,EURO,483,138823,2,1096
2021-09-24,FI,Finland,EURO,481,139304,4,1100
2021-09-25,FI,Finland,EURO,425,139729,3,1103
2021-09-26,FI,Finland,EURO,299,140028,1,1104
2021-09-27,FI,Finland,EURO,355,140383,3,1107
2021-09-28,FI,Finland,EURO,684,141067,3,1110
2021-09-29,FI,Finland,EURO,645,141712,4,1114
2021-09-30,FI,Finland,EURO,669,142381,4,1118
2021-10-01,FI,Finland,EURO,619,143000,3,1121
2021-10-02,FI,Finland,EURO,532,143532,5,1126
2021-10-03,FI,Finland,EURO,356,143888,3,1129
2021-10-04,FI,Finland,EURO,383,144271,5,1134
2021-10-05,FI,Finland,EURO,746,145017,4,1138
2021-10-06,FI,Finland,EURO,726,145743,7,1145
2021-10-07,FI,Finland,EURO,747,146490,2,1147
2021-10-08,FI,Finland,EURO,611,147101,3,1150
2021-10-09,FI,Finland,EURO,596,147697,8,1158
2021-10-10,FI,Finland,EURO,425,148122,5,1163
2021-10-11,FI,Finland,EURO,399,148521,3,1166
2021-10-12,FI,Finland,EURO,691,149212,5,1171
2021-10-13,FI,Finland,EURO,610,149822,3,1174
2021-10-14,FI,Finland,EURO,639,150461,3,1177
2021-10-15,FI,Finland,EURO,559,151020,4,1181
2021-10-16,FI,Finland,EURO,563,151583,2,1183
2021-10-17,FI,Finland,EURO,344,151927,1,1184
2021-10-18,FI,Finland,EURO,319,152246,4,1188
2021-10-19,FI,Finland,EURO,661,152907,6,1194
2021-10-20,FI,Finland,EURO,550,153457,1,1195
2021-10-21,FI,Finland,EURO,516,153973,2,1197
2021-10-22,FI,Finland,EURO,623,154596,2,1199
2021-10-23,FI,Finland,EURO,580,155176,8,1207
2021-10-24,FI,Finland,EURO,376,155552,4,1211
2021-10-25,FI,Finland,EURO,392,155944,2,1213
2021-10-26,FI,Finland,EURO,798,156742,13,1226
2021-10-27,FI,Finland,EURO,681,157423,4,1230
2021-10-28,FI,Finland,EURO,640,158063,5,1235
2021-10-29,FI,Finland,EURO,593,158656,5,1240
2021-10-30,FI,Finland,EURO,655,159311,2,1242
2021-10-31,FI,Finland,EURO,405,159716,3,1245
2021-11-01,FI,Finland,EURO,439,160155,5,1250
2021-11-02,FI,Finland,EURO,973,161128,12,1262
2021-11-03,FI,Finland,EURO,755,161883,3,1265
2021-11-04,FI,Finland,EURO,771,162654,7,1272
2021-11-05,FI,Finland,EURO,802,163456,9,1281
2021-11-06,FI,Finland,EURO,842,164298,11,1292
2021-11-07,FI,Finland,EURO,514,164812,9,1301
2021-11-08,FI,Finland,EURO,506,165318,4,1305
2021-11-09,FI,Finland,EURO,1123,166441,12,1317
2021-11-10,FI,Finland,EURO,836,167277,9,1326
2021-11-11,FI,Finland,EURO,971,168248,4,1330
2021-11-12,FI,Finland,EURO,934,169182,6,1336
2021-11-13,FI,Finland,EURO,946,170128,5,1341
2021-11-14,FI,Finland,EURO,618,170746,3,1344
2021-11-15,FI,Finland,EURO,570,171316,6,1350
2021-11-16,FI,Finland,EURO,1252,172568,17,1367
2021-11-17,FI,Finland,EURO,1200,173768,9,1376
2021-11-18,FI,Finland,EURO,1172,174940,5,1381
2021-11-19,FI,Finland,EURO,1215,176155,4,1385
2021-11-20,FI,Finland,EURO,1275,177430,6,1391
2021-11-21,FI,Finland,EURO,709,178139,8,1399
2021-11-22,FI,Finland,EURO,674,178813,5,1404
2021-11-23,FI,Finland,EURO,1424,180237,10,1414
2021-11-24,FI,Finland,EURO,1337,181574,10,1424
2021-11-25,FI,Finland,EURO,1257,182831,10,1434
2021-11-26,FI,Finland,EURO,1276,184107,11,1445
2021-11-27,FI,Finland,EURO,1301,185408,8,1453
2021-11-28,FI,Finland,EURO,793,186201,8,1461
2021-11-29,FI,Finland,EURO,791,186992,3,1464
2021-11-30,FI,Finland,EURO,1702,188694,15,1479
2021-12-01,FI,Finland,EURO,1427,190121,7,1486
2021-12-02,FI,Finland,EURO,1443,191564,12,1498
2021-12-03,FI,Finland,EURO,1468,193032,5,1503
2021-12-04,FI,Finland,EURO,1530,194562,6,1509
2021-12-05,FI,Finland,EURO,972,195534,7,1516
2021-12-06,FI,Finland,EURO,1003,196537,5,1521
2021-12-07,FI,Finland,EURO,1078,197615,3,1524
2021-12-08,FI,Finland,EURO,1924,199539,7,1531
2021-12-09,FI,Finland,EURO,1733,201272,9,1540
2021-12-10,FI,Finland,EURO,1711,202983,7,1547
2021-12-11,FI,Finland,EURO,1801,204784,6,1553
2021-12-12,FI,Finland,EURO,1124,205908,7,1560
2021-12-13,FI,Finland,EURO,1270,207178,5,1565
2021-12-14,FI,Finland,EURO,2357,209535,7,1572
2021-12-15,FI,Finland,EURO,1833,211368,6,1578
2021-12-16,FI,Finland,EURO,2100,213468,8,1586
2021-12-17,FI,Finland,EURO,1989,215457,8,1594
2021-12-18,FI,Finland,EURO,2174,217631,8,1602
2021-12-19,FI,Finland,EURO,1614,219245,2,1604
2021-12-20,FI,Finland,EURO,1753,220998,5,1609
2021-12-21,FI,Finland,EURO,3041,224039,8,1617
2021-12-22,FI,Finland,EURO,3168,227207,7,1624
2021-12-23,FI,Finland,EURO,3538,230745,8,1632
2021-12-24,FI,Finland,EURO,3901,234646,10,1642
2021-12-25,FI,Finland,EURO,2273,236919,6,1648
2021-12-26,FI,Finland,EURO,2674,239593,5,1653
2021-12-27,FI,Finland,EURO,3307,242900,9,1662
2021-12-28,FI,Finland,EURO,6664,249564,17,1679
2021-12-29,FI,Finland,EURO,6872,256436,12,1691
2021-12-30,FI,Finland,EURO,7389,263825,14,1705
2021-12-31,FI,Finland,EURO,7326,271151,20,1725
2022-01-01,FI,Finland,EURO,6870,278021,20,1745
2022-01-02,FI,Finland,EURO,3981,282002,11,1756
2022-01-03,FI,Finland,EURO,4973,286975,13,1769
2022-01-04,FI,Finland,EURO,9490,296465,17,1786
2022-01-05,FI,Finland,EURO,9943,306408,22,1808
2022-01-06,FI,Finland,EURO,9747,316155,20,1828
2022-01-07,FI,Finland,EURO,7397,323552,15,1843
2022-01-08,FI,Finland,EURO,9554,333106,19,1862
2022-01-09,FI,Finland,EURO,5981,339087,18,1880
2022-01-10,FI,Finland,EURO,6840,345927,13,1893
2022-01-11,FI,Finland,EURO,11087,357014,23,1916
2022-01-12,FI,Finland,EURO,9721,366735,14,1930
2022-01-13,FI,Finland,EURO,9434,376169,16,1946
2022-01-14,FI,Finland,EURO,8668,384837,18,1964
2022-01-15,FI,Finland,EURO,8660,393497,14,1978
2022-01-16,FI,Finland,EURO,5862,399359,14,1992
2022-01-17,FI,Finland,EURO,6454,405813,17,2009
2022-01-18,FI,Finland,EURO,10919,416732,19,2028
2022-01-19,FI,Finland,EURO,9657,426389,9,2037
2022-01-20,FI,Finland,EURO,9096,435485,8,2045
2022-01-21,FI,Finland,EURO,8709,444194,13,2058
2022-01-22,FI,Finland,EURO,7887,452081,10,2068
2022-01-23,FI,Finland,EURO,4622,456703,10,2078
2022-01-24,FI,Finland,EURO,5100,461803,4,2082
2022-01-25,FI,Finland,EURO,9430,471233,10,2092
2022-01-26,FI,Finland,EURO,7904,479137,5,2097
2022-01-27,FI,Finland,EURO,6493,485630,9,2106
2022-01-28,FI,Finland,EURO,6548,492178,5,2111
2022-01-29,FI,Finland,EURO,6052,498230,10,2121
2022-01-30,FI,Finland,EURO,3970,502200,4,2125
2022-01-31,FI,Finland,EURO,4198,506398,2,2127
2022-02-01,FI,Finland,EURO,8270,514668,3,2130
2022-02-02,FI,Finland,EURO,6962,521630,2,2132
2022-02-03,FI,Finland,EURO,6566,528196,4,2136
2022-02-04,FI,Finland,EURO,6018,534214,5,2141
2022-02-05,FI,Finland,EURO,5615,539829,0,2141
2022-02-06,FI,Finland,EURO,3320,543149,0,2141
2022-02-07,FI,Finland,EURO,4015,547164,0,2141
2022-02-08,FI,Finland,EURO,7760,554924,0,2141
2022-02-09,FI,Finland,EURO,4642,559566,0,2141
2022-02-10,FI,Finland,EURO,21,559587,0,2141
.
54600c
2022-02-09,FJ,Fiji,WPRO,6,63362,0,813
2022-02-10,FJ,Fiji,WPRO,36,63398,3,816
.
53831a
2022-02-10,FO,Faroe Islands,EURO,663,26288,2,22
.
53062a
2022-02-10,FK,Falkland Islands (Malvinas),AMRO,0,91,0,0
.
52293a
2022-02-10,ET,Ethiopia,AFRO,161,467001,12,7397
.
51524a
2022-02-10,SZ,Eswatini,AFRO,41,68702,1,1381
.
50755a
2022-02-10,EE,Estonia,EURO,6582,405101,7,2095
.
49986a
2022-02-10,ER,Eritrea,AFRO,1,9652,1,102
.
49217a
2022-02-10,GQ,Equatorial Guinea,AFRO,0,15845,0,182
.
48448a
2022-02-10,SV,El Salvador,AMRO,0,135109,7,3967
.
47679a
2022-02-10,EG,Egypt,EMRO,2191,446308,57,23110
.
46910a
2022-02-10,EC,Ecuador,AMRO,0,769149,0,34739
.
46141a
2022-02-10,DO,Dominican Republic,AMRO,1395,565862,4,4336
.
45372a
2022-02-10,DM,Dominica,AMRO,0,10000,0,51
.
44603a
2022-02-10,DJ,Djibouti,EMRO,2,15527,0,189
.
43834a
2022-02-10,DK,Denmark,EURO,55120,2142809,20,3948
.
43065a
2022-02-10,CD,Democratic Republic of the Congo,AFRO,35,85743,0,1316
.
42296a
2022-02-10,KP,Democratic People's Republic of Korea,SEARO,0,0,0,0
.
40882,41527c
2020-05-05,CZ,Czechia,EURO,39,7839,5,259
2020-05-06,CZ,Czechia,EURO,77,7916,3,262
2020-05-07,CZ,Czechia,EURO,79,7995,3,265
2020-05-08,CZ,Czechia,EURO,59,8054,4,269
2020-05-09,CZ,Czechia,EURO,46,8100,5,274
2020-05-10,CZ,Czechia,EURO,18,8118,3,277
2020-05-11,CZ,Czechia,EURO,28,8146,3,280
2020-05-12,CZ,Czechia,EURO,58,8204,2,282
2020-05-13,CZ,Czechia,EURO,45,8249,3,285
2020-05-14,CZ,Czechia,EURO,50,8299,4,289
2020-05-15,CZ,Czechia,EURO,82,8381,3,292
2020-05-16,CZ,Czechia,EURO,55,8436,2,294
2020-05-17,CZ,Czechia,EURO,51,8487,1,295
2020-05-18,CZ,Czechia,EURO,20,8507,2,297
2020-05-19,CZ,Czechia,EURO,114,8621,3,300
2020-05-20,CZ,Czechia,EURO,63,8684,2,302
2020-05-21,CZ,Czechia,EURO,74,8758,5,307
2020-05-22,CZ,Czechia,EURO,35,8793,3,310
2020-05-23,CZ,Czechia,EURO,61,8854,2,312
2020-05-24,CZ,Czechia,EURO,77,8931,1,313
2020-05-25,CZ,Czechia,EURO,65,8996,1,314
2020-05-26,CZ,Czechia,EURO,47,9043,1,315
2020-05-27,CZ,Czechia,EURO,51,9094,1,316
2020-05-28,CZ,Czechia,EURO,37,9131,0,316
2020-05-29,CZ,Czechia,EURO,54,9185,2,318
2020-05-30,CZ,Czechia,EURO,57,9242,0,318
2020-05-31,CZ,Czechia,EURO,34,9276,0,318
2020-06-01,CZ,Czechia,EURO,38,9314,0,318
2020-06-02,CZ,Czechia,EURO,34,9348,2,320
2020-06-03,CZ,Czechia,EURO,64,9412,1,321
2020-06-04,CZ,Czechia,EURO,74,9486,1,322
2020-06-05,CZ,Czechia,EURO,64,9550,3,325
2020-06-06,CZ,Czechia,EURO,35,9585,0,325
2020-06-07,CZ,Czechia,EURO,38,9623,0,325
2020-06-08,CZ,Czechia,EURO,61,9684,1,326
2020-06-09,CZ,Czechia,EURO,69,9753,0,326
2020-06-10,CZ,Czechia,EURO,55,9808,1,327
2020-06-11,CZ,Czechia,EURO,74,9882,1,328
2020-06-12,CZ,Czechia,EURO,64,9946,1,329
2020-06-13,CZ,Czechia,EURO,52,9998,1,330
2020-06-14,CZ,Czechia,EURO,53,10051,0,330
2020-06-15,CZ,Czechia,EURO,33,10084,1,331
2020-06-16,CZ,Czechia,EURO,40,10124,1,332
2020-06-17,CZ,Czechia,EURO,47,10171,1,333
2020-06-18,CZ,Czechia,EURO,51,10222,1,334
2020-06-19,CZ,Czechia,EURO,118,10340,2,336
2020-06-20,CZ,Czechia,EURO,126,10466,1,337
2020-06-21,CZ,Czechia,EURO,43,10509,1,338
2020-06-22,CZ,Czechia,EURO,50,10559,1,339
2020-06-23,CZ,Czechia,EURO,64,10623,1,340
2020-06-24,CZ,Czechia,EURO,89,10712,0,340
2020-06-25,CZ,Czechia,EURO,127,10839,4,344
2020-06-26,CZ,Czechia,EURO,93,10932,0,344
2020-06-27,CZ,Czechia,EURO,168,11100,1,345
2020-06-28,CZ,Czechia,EURO,260,11360,1,346
2020-06-29,CZ,Czechia,EURO,305,11665,0,346
2020-06-30,CZ,Czechia,EURO,201,11866,0,346
2020-07-01,CZ,Czechia,EURO,149,12015,1,347
2020-07-02,CZ,Czechia,EURO,91,12106,0,347
2020-07-03,CZ,Czechia,EURO,133,12239,1,348
2020-07-04,CZ,Czechia,EURO,140,12379,0,348
2020-07-05,CZ,Czechia,EURO,121,12500,2,350
2020-07-06,CZ,Czechia,EURO,75,12575,2,352
2020-07-07,CZ,Czechia,EURO,51,12626,1,353
2020-07-08,CZ,Czechia,EURO,118,12744,0,353
2020-07-09,CZ,Czechia,EURO,129,12873,0,353
2020-07-10,CZ,Czechia,EURO,105,12978,1,354
2020-07-11,CZ,Czechia,EURO,141,13119,0,354
2020-07-12,CZ,Czechia,EURO,53,13172,0,354
2020-07-13,CZ,Czechia,EURO,59,13231,1,355
2020-07-14,CZ,Czechia,EURO,64,13295,1,356
2020-07-15,CZ,Czechia,EURO,105,13400,2,358
2020-07-16,CZ,Czechia,EURO,135,13535,0,358
2020-07-17,CZ,Czechia,EURO,137,13672,0,358
2020-07-18,CZ,Czechia,EURO,128,13800,2,360
2020-07-19,CZ,Czechia,EURO,112,13912,0,360
2020-07-20,CZ,Czechia,EURO,91,14003,1,361
2020-07-21,CZ,Czechia,EURO,168,14171,0,361
2020-07-22,CZ,Czechia,EURO,208,14379,2,363
2020-07-23,CZ,Czechia,EURO,245,14624,2,365
2020-07-24,CZ,Czechia,EURO,231,14855,1,366
2020-07-25,CZ,Czechia,EURO,278,15133,3,369
2020-07-26,CZ,Czechia,EURO,132,15265,2,371
2020-07-27,CZ,Czechia,EURO,114,15379,1,372
2020-07-28,CZ,Czechia,EURO,194,15573,2,374
2020-07-29,CZ,Czechia,EURO,276,15849,2,376
2020-07-30,CZ,Czechia,EURO,274,16123,2,378
2020-07-31,CZ,Czechia,EURO,254,16377,2,380
2020-08-01,CZ,Czechia,EURO,231,16608,2,382
2020-08-02,CZ,Czechia,EURO,124,16732,2,384
2020-08-03,CZ,Czechia,EURO,101,16833,2,386
2020-08-04,CZ,Czechia,EURO,208,17041,2,388
2020-08-05,CZ,Czechia,EURO,287,17328,2,390
2020-08-06,CZ,Czechia,EURO,241,17569,1,391
2020-08-07,CZ,Czechia,EURO,214,17783,1,392
2020-08-08,CZ,Czechia,EURO,322,18105,0,392
2020-08-09,CZ,Czechia,EURO,173,18278,0,392
2020-08-10,CZ,Czechia,EURO,122,18400,1,393
2020-08-11,CZ,Czechia,EURO,141,18541,0,393
2020-08-12,CZ,Czechia,EURO,289,18830,2,395
2020-08-13,CZ,Czechia,EURO,289,19119,0,395
2020-08-14,CZ,Czechia,EURO,330,19449,1,396
2020-08-15,CZ,Czechia,EURO,291,19740,2,398
2020-08-16,CZ,Czechia,EURO,197,19937,2,400
2020-08-17,CZ,Czechia,EURO,121,20058,2,402
2020-08-18,CZ,Czechia,EURO,191,20249,4,406
2020-08-19,CZ,Czechia,EURO,281,20530,0,406
2020-08-20,CZ,Czechia,EURO,313,20843,3,409
2020-08-21,CZ,Czechia,EURO,246,21089,3,412
2020-08-22,CZ,Czechia,EURO,506,21595,3,415
2020-08-23,CZ,Czechia,EURO,234,21829,0,415
2020-08-24,CZ,Czechia,EURO,136,21965,3,418
2020-08-25,CZ,Czechia,EURO,259,22224,1,419
2020-08-26,CZ,Czechia,EURO,364,22588,2,421
2020-08-27,CZ,Czechia,EURO,396,22984,1,422
2020-08-28,CZ,Czechia,EURO,350,23334,0,422
2020-08-29,CZ,Czechia,EURO,485,23819,0,422
2020-08-30,CZ,Czechia,EURO,320,24139,3,425
2020-08-31,CZ,Czechia,EURO,275,24414,1,426
2020-09-01,CZ,Czechia,EURO,256,24670,1,427
2020-09-02,CZ,Czechia,EURO,497,25167,1,428
2020-09-03,CZ,Czechia,EURO,645,25812,0,428
2020-09-04,CZ,Czechia,EURO,675,26487,4,432
2020-09-05,CZ,Czechia,EURO,797,27284,3,435
2020-09-06,CZ,Czechia,EURO,504,27788,5,440
2020-09-07,CZ,Czechia,EURO,410,28198,3,443
2020-09-08,CZ,Czechia,EURO,561,28759,2,445
2020-09-09,CZ,Czechia,EURO,1161,29920,5,450
2020-09-10,CZ,Czechia,EURO,1158,31078,3,453
2020-09-11,CZ,Czechia,EURO,1383,32461,5,458
2020-09-12,CZ,Czechia,EURO,1442,33903,3,461
2020-09-13,CZ,Czechia,EURO,1537,35440,6,467
2020-09-14,CZ,Czechia,EURO,791,36231,5,472
2020-09-15,CZ,Czechia,EURO,1028,37259,6,478
2020-09-16,CZ,Czechia,EURO,1676,38935,10,488
2020-09-17,CZ,Czechia,EURO,2133,41068,7,495
2020-09-18,CZ,Czechia,EURO,3125,44193,7,502
2020-09-19,CZ,Czechia,EURO,2108,46301,12,514
2020-09-20,CZ,Czechia,EURO,2045,48346,8,522
2020-09-21,CZ,Czechia,EURO,984,49330,6,528
2020-09-22,CZ,Czechia,EURO,1477,50807,15,543
2020-09-23,CZ,Czechia,EURO,2387,53194,10,553
2020-09-24,CZ,Czechia,EURO,2305,55499,22,575
2020-09-25,CZ,Czechia,EURO,2906,58405,10,585
2020-09-26,CZ,Czechia,EURO,2945,61350,10,595
2020-09-27,CZ,Czechia,EURO,1981,63331,16,611
2020-09-28,CZ,Czechia,EURO,1305,64636,16,627
2020-09-29,CZ,Czechia,EURO,1284,65920,11,638
2020-09-30,CZ,Czechia,EURO,1962,67882,21,659
2020-10-01,CZ,Czechia,EURO,2925,70807,16,675
2020-10-02,CZ,Czechia,EURO,3503,74310,29,704
2020-10-03,CZ,Czechia,EURO,3795,78105,21,725
2020-10-04,CZ,Czechia,EURO,2554,80659,13,738
2020-10-05,CZ,Czechia,EURO,1841,82500,35,773
2020-10-06,CZ,Czechia,EURO,3117,85617,29,802
2020-10-07,CZ,Czechia,EURO,4458,90075,38,840
2020-10-08,CZ,Czechia,EURO,5336,95411,51,891
2020-10-09,CZ,Czechia,EURO,5394,100805,26,917
2020-10-10,CZ,Czechia,EURO,8618,109423,61,978
2020-10-11,CZ,Czechia,EURO,4637,114060,53,1031
2020-10-12,CZ,Czechia,EURO,3104,117164,43,1074
2020-10-13,CZ,Czechia,EURO,4307,121471,70,1144
2020-10-14,CZ,Czechia,EURO,8324,129795,53,1197
2020-10-15,CZ,Czechia,EURO,9544,139339,67,1264
2020-10-16,CZ,Czechia,EURO,9724,149063,63,1327
2020-10-17,CZ,Czechia,EURO,11104,160167,80,1407
2020-10-18,CZ,Czechia,EURO,8713,168880,81,1488
2020-10-19,CZ,Czechia,EURO,5059,173939,82,1570
2020-10-20,CZ,Czechia,EURO,8078,182017,110,1680
2020-10-21,CZ,Czechia,EURO,11985,194002,109,1789
2020-10-22,CZ,Czechia,EURO,14971,208973,131,1920
2020-10-23,CZ,Czechia,EURO,14158,223131,127,2047
2020-10-24,CZ,Czechia,EURO,15248,238379,125,2172
2020-10-25,CZ,Czechia,EURO,12473,250852,143,2315
2020-10-26,CZ,Czechia,EURO,7300,258152,154,2469
2020-10-27,CZ,Czechia,EURO,10273,268425,163,2632
2020-10-28,CZ,Czechia,EURO,15667,284092,195,2827
2020-10-29,CZ,Czechia,EURO,12977,297069,168,2995
2020-10-30,CZ,Czechia,EURO,13050,310119,199,3194
2020-10-31,CZ,Czechia,EURO,13605,323724,217,3411
2020-11-01,CZ,Czechia,EURO,11428,335152,193,3604
2020-11-02,CZ,Czechia,EURO,6551,341703,224,3828
2020-11-03,CZ,Czechia,EURO,9241,350944,223,4051
2020-11-04,CZ,Czechia,EURO,12090,363034,261,4312
2020-11-05,CZ,Czechia,EURO,15726,378760,228,4540
2020-11-06,CZ,Czechia,EURO,13237,391997,196,4736
2020-11-07,CZ,Czechia,EURO,11546,403543,217,4953
2020-11-08,CZ,Czechia,EURO,7721,411264,203,5156
2020-11-09,CZ,Czechia,EURO,3611,414875,206,5362
2020-11-10,CZ,Czechia,EURO,6048,420923,186,5548
2020-11-11,CZ,Czechia,EURO,9057,429980,215,5763
2020-11-12,CZ,Czechia,EURO,8919,438899,184,5947
2020-11-13,CZ,Czechia,EURO,7874,446773,174,6121
2020-11-14,CZ,Czechia,EURO,7358,454131,181,6302
2020-11-15,CZ,Czechia,EURO,4196,458327,185,6487
2020-11-16,CZ,Czechia,EURO,1891,460218,152,6639
2020-11-17,CZ,Czechia,EURO,5419,465637,173,6812
2020-11-18,CZ,Czechia,EURO,4246,469883,139,6951
2020-11-19,CZ,Czechia,EURO,5514,475397,155,7106
2020-11-20,CZ,Czechia,EURO,6470,481867,134,7240
2020-11-21,CZ,Czechia,EURO,5809,487676,117,7357
2020-11-22,CZ,Czechia,EURO,3191,490867,132,7489
2020-11-23,CZ,Czechia,EURO,1508,492375,126,7615
2020-11-24,CZ,Czechia,EURO,4379,496754,129,7744
2020-11-25,CZ,Czechia,EURO,5861,502615,136,7880
2020-11-26,CZ,Czechia,EURO,4929,507544,123,8003
2020-11-27,CZ,Czechia,EURO,4049,511593,130,8133
2020-11-28,CZ,Czechia,EURO,4463,516056,138,8271
2020-11-29,CZ,Czechia,EURO,2668,518724,117,8388
2020-11-30,CZ,Czechia,EURO,1074,519798,95,8483
2020-12-01,CZ,Czechia,EURO,3573,523371,126,8609
2020-12-02,CZ,Czechia,EURO,5181,528552,100,8709
2020-12-03,CZ,Czechia,EURO,4561,533113,116,8825
2020-12-04,CZ,Czechia,EURO,4624,537737,102,8927
2020-12-05,CZ,Czechia,EURO,4747,542484,92,9019
2020-12-06,CZ,Czechia,EURO,3313,545797,129,9148
2020-12-07,CZ,Czechia,EURO,1112,546909,91,9239
2020-12-08,CZ,Czechia,EURO,4251,551160,94,9333
2020-12-09,CZ,Czechia,EURO,5855,557015,95,9428
2020-12-10,CZ,Czechia,EURO,6417,563432,82,9510
2020-12-11,CZ,Czechia,EURO,5876,569308,116,9626
2020-12-12,CZ,Czechia,EURO,6210,575518,105,9731
2020-12-13,CZ,Czechia,EURO,3655,579173,97,9828
2020-12-14,CZ,Czechia,EURO,1998,581171,108,9936
2020-12-15,CZ,Czechia,EURO,5179,586350,130,10066
2020-12-16,CZ,Czechia,EURO,7914,594264,105,10171
2020-12-17,CZ,Czechia,EURO,8263,602527,114,10285
2020-12-18,CZ,Czechia,EURO,7617,610144,106,10391
2020-12-19,CZ,Czechia,EURO,8856,619000,100,10491
2020-12-20,CZ,Czechia,EURO,5353,624353,114,10605
2020-12-21,CZ,Czechia,EURO,3419,627772,98,10703
2020-12-22,CZ,Czechia,EURO,7975,635747,104,10807
2020-12-23,CZ,Czechia,EURO,10950,646697,102,10909
2020-12-24,CZ,Czechia,EURO,14171,660868,115,11024
2020-12-25,CZ,Czechia,EURO,4381,665249,111,11135
2020-12-26,CZ,Czechia,EURO,2680,667929,106,11241
2020-12-27,CZ,Czechia,EURO,3042,670971,125,11366
2020-12-28,CZ,Czechia,EURO,3798,674769,108,11474
2020-12-29,CZ,Czechia,EURO,10996,685765,131,11605
2020-12-30,CZ,Czechia,EURO,16533,702298,132,11737
2020-12-31,CZ,Czechia,EURO,17119,719417,150,11887
2021-01-01,CZ,Czechia,EURO,13335,732752,129,12016
2021-01-02,CZ,Czechia,EURO,3458,736210,152,12168
2021-01-03,CZ,Czechia,EURO,5000,741210,152,12320
2021-01-04,CZ,Czechia,EURO,6286,747496,141,12461
2021-01-05,CZ,Czechia,EURO,13000,760496,152,12613
2021-01-06,CZ,Czechia,EURO,17457,777953,181,12794
2021-01-07,CZ,Czechia,EURO,17861,795814,162,12956
2021-01-08,CZ,Czechia,EURO,14980,810794,187,13143
2021-01-09,CZ,Czechia,EURO,13155,823949,197,13340
2021-01-10,CZ,Czechia,EURO,8478,832427,165,13505
2021-01-11,CZ,Czechia,EURO,4336,836763,184,13689
2021-01-12,CZ,Czechia,EURO,9438,846201,163,13852
2021-01-13,CZ,Czechia,EURO,10832,857033,177,14029
2021-01-14,CZ,Czechia,EURO,10952,867985,164,14193
2021-01-15,CZ,Czechia,EURO,8124,876109,181,14374
2021-01-16,CZ,Czechia,EURO,9344,885453,165,14539
2021-01-17,CZ,Czechia,EURO,5252,890705,156,14695
2021-01-18,CZ,Czechia,EURO,2652,893357,158,14853
2021-01-19,CZ,Czechia,EURO,7697,901054,160,15013
2021-01-20,CZ,Czechia,EURO,9634,910688,157,15170
2021-01-21,CZ,Czechia,EURO,8244,918932,148,15318
2021-01-22,CZ,Czechia,EURO,7580,926512,152,15470
2021-01-23,CZ,Czechia,EURO,8494,935006,136,15606
2021-01-24,CZ,Czechia,EURO,4247,939253,143,15749
2021-01-25,CZ,Czechia,EURO,2409,941662,145,15894
2021-01-26,CZ,Czechia,EURO,7009,948671,140,16034
2021-01-27,CZ,Czechia,EURO,9213,957884,143,16177
2021-01-28,CZ,Czechia,EURO,8546,966430,160,16337
2021-01-29,CZ,Czechia,EURO,8034,974464,135,16472
2021-01-30,CZ,Czechia,EURO,8069,982533,152,16624
2021-01-31,CZ,Czechia,EURO,4066,986599,126,16750
2021-02-01,CZ,Czechia,EURO,2584,989183,120,16870
2021-02-02,CZ,Czechia,EURO,7257,996440,133,17003
2021-02-03,CZ,Czechia,EURO,9168,1005608,135,17138
2021-02-04,CZ,Czechia,EURO,9686,1015294,137,17275
2021-02-05,CZ,Czechia,EURO,8121,1023415,129,17404
2021-02-06,CZ,Czechia,EURO,8640,1032055,127,17531
2021-02-07,CZ,Czechia,EURO,4826,1036881,128,17659
2021-02-08,CZ,Czechia,EURO,2459,1039340,131,17790
2021-02-09,CZ,Czechia,EURO,7815,1047155,139,17929
2021-02-10,CZ,Czechia,EURO,10308,1057463,133,18062
2021-02-11,CZ,Czechia,EURO,9572,1067035,133,18195
2021-02-12,CZ,Czechia,EURO,9046,1076081,130,18325
2021-02-13,CZ,Czechia,EURO,8848,1084929,144,18469
2021-02-14,CZ,Czechia,EURO,5149,1090078,117,18586
2021-02-15,CZ,Czechia,EURO,2884,1092962,150,18736
2021-02-16,CZ,Czechia,EURO,8924,1101886,130,18866
2021-02-17,CZ,Czechia,EURO,12625,1114511,150,19016
2021-02-18,CZ,Czechia,EURO,10959,1125470,132,19148
2021-02-19,CZ,Czechia,EURO,11725,1137195,173,19321
2021-02-20,CZ,Czechia,EURO,11303,1148498,181,19502
2021-02-21,CZ,Czechia,EURO,6780,1155278,177,19679
2021-02-22,CZ,Czechia,EURO,4074,1159352,148,19827
2021-02-23,CZ,Czechia,EURO,11452,1170804,165,19992
2021-02-24,CZ,Czechia,EURO,15867,1186671,148,20140
2021-02-25,CZ,Czechia,EURO,13824,1200495,143,20283
2021-02-26,CZ,Czechia,EURO,14613,1215108,182,20465
2021-02-27,CZ,Czechia,EURO,14824,1229932,191,20656
2021-02-28,CZ,Czechia,EURO,7868,1237800,193,20849
2021-03-01,CZ,Czechia,EURO,4600,1242400,183,21032
2021-03-02,CZ,Czechia,EURO,12366,1254766,205,21237
2021-03-03,CZ,Czechia,EURO,16820,1271586,192,21429
2021-03-04,CZ,Czechia,EURO,15268,1286854,201,21630
2021-03-05,CZ,Czechia,EURO,14675,1301529,218,21848
2021-03-06,CZ,Czechia,EURO,13187,1314716,186,22034
2021-03-07,CZ,Czechia,EURO,9137,1323853,209,22243
2021-03-08,CZ,Czechia,EURO,4004,1327857,204,22447
2021-03-09,CZ,Czechia,EURO,10699,1338556,236,22683
2021-03-10,CZ,Czechia,EURO,15399,1353955,231,22914
2021-03-11,CZ,Czechia,EURO,14586,1368541,229,23143
2021-03-12,CZ,Czechia,EURO,11283,1379824,229,23372
2021-03-13,CZ,Czechia,EURO,14993,1394817,213,23585
2021-03-14,CZ,Czechia,EURO,7051,1401868,178,23763
2021-03-15,CZ,Czechia,EURO,3353,1405221,229,23992
2021-03-16,CZ,Czechia,EURO,10659,1415880,238,24230
2021-03-17,CZ,Czechia,EURO,14075,1429955,219,24449
2021-03-18,CZ,Czechia,EURO,12080,1442035,199,24648
2021-03-19,CZ,Czechia,EURO,10720,1452755,214,24862
2021-03-20,CZ,Czechia,EURO,9751,1462506,173,25035
2021-03-21,CZ,Czechia,EURO,5513,1468019,185,25220
2021-03-22,CZ,Czechia,EURO,2400,1470419,193,25413
2021-03-23,CZ,Czechia,EURO,8262,1478681,210,25623
2021-03-24,CZ,Czechia,EURO,10999,1489680,193,25816
2021-03-25,CZ,Czechia,EURO,8878,1498558,185,26001
2021-03-26,CZ,Czechia,EURO,7951,1506509,161,26162
2021-03-27,CZ,Czechia,EURO,7749,1514258,155,26317
2021-03-28,CZ,Czechia,EURO,3982,1518240,181,26498
2021-03-29,CZ,Czechia,EURO,1747,1519987,117,26615
2021-03-30,CZ,Czechia,EURO,6956,1526943,181,26796
2021-03-31,CZ,Czechia,EURO,8653,1535596,171,26967
2021-04-01,CZ,Czechia,EURO,7279,1542875,153,27120
2021-04-02,CZ,Czechia,EURO,6259,1549134,152,27272
2021-04-03,CZ,Czechia,EURO,3852,1552986,104,27376
2021-04-04,CZ,Czechia,EURO,2162,1555148,126,27502
2021-04-05,CZ,Czechia,EURO,1933,1557081,146,27648
2021-04-06,CZ,Czechia,EURO,1434,1558515,124,27772
2021-04-07,CZ,Czechia,EURO,5601,1564116,114,27886
2021-04-08,CZ,Czechia,EURO,7064,1571180,121,28007
2021-04-09,CZ,Czechia,EURO,5302,1576482,122,28129
2021-04-10,CZ,Czechia,EURO,4846,1581328,107,28236
2021-04-11,CZ,Czechia,EURO,2221,1583549,110,28346
2021-04-12,CZ,Czechia,EURO,987,1584536,93,28439
2021-04-13,CZ,Czechia,EURO,3883,1588419,84,28523
2021-04-14,CZ,Czechia,EURO,5092,1593511,91,28614
2021-04-15,CZ,Czechia,EURO,3726,1597237,90,28704
2021-04-16,CZ,Czechia,EURO,3285,1600522,86,28790
2021-04-17,CZ,Czechia,EURO,3229,1603751,66,28856
2021-04-18,CZ,Czechia,EURO,1546,1605297,74,28930
2021-04-19,CZ,Czechia,EURO,842,1606139,78,29008
2021-04-20,CZ,Czechia,EURO,3351,1609490,72,29080
2021-04-21,CZ,Czechia,EURO,3821,1613311,64,29144
2021-04-22,CZ,Czechia,EURO,2966,1616277,64,29208
2021-04-23,CZ,Czechia,EURO,2639,1618916,56,29264
2021-04-24,CZ,Czechia,EURO,2614,1621530,54,29318
2021-04-25,CZ,Czechia,EURO,1315,1622845,57,29375
2021-04-26,CZ,Czechia,EURO,830,1623675,53,29428
2021-04-27,CZ,Czechia,EURO,2605,1626280,58,29486
2021-04-28,CZ,Czechia,EURO,3256,1629536,51,29537
2021-04-29,CZ,Czechia,EURO,2497,1632033,67,29604
2021-04-30,CZ,Czechia,EURO,2238,1634271,42,29646
2021-05-01,CZ,Czechia,EURO,2183,1636454,49,29695
2021-05-02,CZ,Czechia,EURO,1177,1637631,33,29728
2021-05-03,CZ,Czechia,EURO,513,1638144,34,29762
2021-05-04,CZ,Czechia,EURO,2226,1640370,39,29801
2021-05-05,CZ,Czechia,EURO,2425,1642795,44,29845
2021-05-06,CZ,Czechia,EURO,1885,1644680,37,29882
2021-05-07,CZ,Czechia,EURO,1581,1646261,43,29925
2021-05-08,CZ,Czechia,EURO,1647,1647908,28,29953
2021-05-09,CZ,Czechia,EURO,730,1648638,31,29984
2021-05-10,CZ,Czechia,EURO,388,1649026,34,30018
2021-05-11,CZ,Czechia,EURO,1556,1650582,33,30051
2021-05-12,CZ,Czechia,EURO,1701,1652283,33,30084
2021-05-13,CZ,Czechia,EURO,1273,1653556,33,30117
2021-05-14,CZ,Czechia,EURO,1232,1654788,21,30138
2021-05-15,CZ,Czechia,EURO,1058,1655846,18,30156
2021-05-16,CZ,Czechia,EURO,598,1656444,16,30172
2021-05-17,CZ,Czechia,EURO,258,1656702,13,30185
2021-05-18,CZ,Czechia,EURO,1142,1657844,23,30208
2021-05-19,CZ,Czechia,EURO,1207,1659051,14,30222
2021-05-20,CZ,Czechia,EURO,785,1659836,16,30238
2021-05-21,CZ,Czechia,EURO,689,1660525,17,30255
2021-05-22,CZ,Czechia,EURO,679,1661204,13,30268
2021-05-23,CZ,Czechia,EURO,336,1661540,11,30279
2021-05-24,CZ,Czechia,EURO,198,1661738,12,30291
2021-05-25,CZ,Czechia,EURO,703,1662441,6,30297
2021-05-26,CZ,Czechia,EURO,667,1663108,8,30305
2021-05-27,CZ,Czechia,EURO,545,1663653,10,30315
2021-05-28,CZ,Czechia,EURO,516,1664169,15,30330
2021-05-29,CZ,Czechia,EURO,457,1664626,7,30337
2021-05-30,CZ,Czechia,EURO,222,1664848,6,30343
2021-05-31,CZ,Czechia,EURO,113,1664961,4,30347
2021-06-01,CZ,Czechia,EURO,522,1665483,10,30357
2021-06-02,CZ,Czechia,EURO,482,1665965,6,30363
2021-06-03,CZ,Czechia,EURO,357,1666322,5,30368
2021-06-04,CZ,Czechia,EURO,435,1666757,3,30371
2021-06-05,CZ,Czechia,EURO,330,1667087,7,30378
2021-06-06,CZ,Czechia,EURO,153,1667240,2,30380
2021-06-07,CZ,Czechia,EURO,99,1667339,4,30384
2021-06-08,CZ,Czechia,EURO,299,1667638,4,30388
2021-06-09,CZ,Czechia,EURO,387,1668025,6,30394
2021-06-10,CZ,Czechia,EURO,259,1668284,2,30396
2021-06-11,CZ,Czechia,EURO,194,1668478,6,30402
2021-06-12,CZ,Czechia,EURO,182,1668660,2,30404
2021-06-13,CZ,Czechia,EURO,77,1668737,4,30408
2021-06-14,CZ,Czechia,EURO,42,1668779,3,30411
2021-06-15,CZ,Czechia,EURO,178,1668957,0,30411
2021-06-16,CZ,Czechia,EURO,211,1669168,4,30415
2021-06-17,CZ,Czechia,EURO,132,1669300,1,30416
2021-06-18,CZ,Czechia,EURO,162,1669462,4,30420
2021-06-19,CZ,Czechia,EURO,150,1669612,3,30423
2021-06-20,CZ,Czechia,EURO,64,1669676,0,30423
2021-06-21,CZ,Czechia,EURO,58,1669734,1,30424
2021-06-22,CZ,Czechia,EURO,121,1669855,1,30425
2021-06-23,CZ,Czechia,EURO,113,1669968,3,30428
2021-06-24,CZ,Czechia,EURO,111,1670079,0,30428
2021-06-25,CZ,Czechia,EURO,98,1670177,4,30432
2021-06-26,CZ,Czechia,EURO,132,1670309,1,30433
2021-06-27,CZ,Czechia,EURO,68,1670377,2,30435
2021-06-28,CZ,Czechia,EURO,59,1670436,0,30435
2021-06-29,CZ,Czechia,EURO,153,1670589,0,30435
2021-06-30,CZ,Czechia,EURO,161,1670750,0,30435
2021-07-01,CZ,Czechia,EURO,139,1670889,2,30437
2021-07-02,CZ,Czechia,EURO,170,1671059,1,30438
2021-07-03,CZ,Czechia,EURO,167,1671226,2,30440
2021-07-04,CZ,Czechia,EURO,126,1671352,0,30440
2021-07-05,CZ,Czechia,EURO,109,1671461,2,30442
2021-07-06,CZ,Czechia,EURO,130,1671591,0,30442
2021-07-07,CZ,Czechia,EURO,110,1671701,0,30442
2021-07-08,CZ,Czechia,EURO,281,1671982,1,30443
2021-07-09,CZ,Czechia,EURO,253,1672235,0,30443
2021-07-10,CZ,Czechia,EURO,287,1672522,0,30443
2021-07-11,CZ,Czechia,EURO,157,1672679,0,30443
2021-07-12,CZ,Czechia,EURO,149,1672828,2,30445
2021-07-13,CZ,Czechia,EURO,245,1673073,0,30445
2021-07-14,CZ,Czechia,EURO,323,1673396,0,30445
2021-07-15,CZ,Czechia,EURO,262,1673658,0,30445
2021-07-16,CZ,Czechia,EURO,228,1673886,0,30445
2021-07-17,CZ,Czechia,EURO,244,1674130,2,30447
2021-07-18,CZ,Czechia,EURO,197,1674327,0,30447
2021-07-19,CZ,Czechia,EURO,116,1674443,1,30448
2021-07-20,CZ,Czechia,EURO,221,1674664,2,30450
2021-07-21,CZ,Czechia,EURO,300,1674964,0,30450
2021-07-22,CZ,Czechia,EURO,233,1675197,1,30451
2021-07-23,CZ,Czechia,EURO,210,1675407,0,30451
2021-07-24,CZ,Czechia,EURO,189,1675596,0,30451
2021-07-25,CZ,Czechia,EURO,126,1675722,0,30451
2021-07-26,CZ,Czechia,EURO,81,1675803,0,30451
2021-07-27,CZ,Czechia,EURO,200,1676003,0,30451
2021-07-28,CZ,Czechia,EURO,256,1676259,0,30451
2021-07-29,CZ,Czechia,EURO,201,1676460,0,30451
2021-07-30,CZ,Czechia,EURO,207,1676667,0,30451
2021-07-31,CZ,Czechia,EURO,140,1676807,0,30451
2021-08-01,CZ,Czechia,EURO,117,1676924,2,30453
2021-08-02,CZ,Czechia,EURO,77,1677001,2,30455
2021-08-03,CZ,Czechia,EURO,153,1677154,1,30456
2021-08-04,CZ,Czechia,EURO,242,1677396,0,30456
2021-08-05,CZ,Czechia,EURO,209,1677605,0,30456
2021-08-06,CZ,Czechia,EURO,165,1677770,1,30457
2021-08-07,CZ,Czechia,EURO,178,1677948,2,30459
2021-08-08,CZ,Czechia,EURO,154,1678102,0,30459
2021-08-09,CZ,Czechia,EURO,107,1678209,0,30459
2021-08-10,CZ,Czechia,EURO,175,1678384,1,30460
2021-08-11,CZ,Czechia,EURO,261,1678645,0,30460
2021-08-12,CZ,Czechia,EURO,220,1678865,1,30461
2021-08-13,CZ,Czechia,EURO,190,1679055,0,30461
2021-08-14,CZ,Czechia,EURO,223,1679278,0,30461
2021-08-15,CZ,Czechia,EURO,142,1679420,0,30461
2021-08-16,CZ,Czechia,EURO,77,1679497,3,30464
2021-08-17,CZ,Czechia,EURO,216,1679713,3,30467
2021-08-18,CZ,Czechia,EURO,300,1680013,1,30468
2021-08-19,CZ,Czechia,EURO,209,1680222,2,30470
2021-08-20,CZ,Czechia,EURO,166,1680388,2,30472
2021-08-21,CZ,Czechia,EURO,171,1680559,1,30473
2021-08-22,CZ,Czechia,EURO,135,1680694,0,30473
2021-08-23,CZ,Czechia,EURO,107,1680801,0,30473
2021-08-24,CZ,Czechia,EURO,213,1681014,1,30474
2021-08-25,CZ,Czechia,EURO,252,1681266,1,30475
2021-08-26,CZ,Czechia,EURO,249,1681515,2,30477
2021-08-27,CZ,Czechia,EURO,214,1681729,0,30477
2021-08-28,CZ,Czechia,EURO,183,1681912,1,30478
2021-08-29,CZ,Czechia,EURO,133,1682045,2,30480
2021-08-30,CZ,Czechia,EURO,81,1682126,1,30481
2021-08-31,CZ,Czechia,EURO,241,1682367,0,30481
2021-09-01,CZ,Czechia,EURO,291,1682658,0,30481
2021-09-02,CZ,Czechia,EURO,262,1682920,0,30481
2021-09-03,CZ,Czechia,EURO,306,1683226,2,30483
2021-09-04,CZ,Czechia,EURO,310,1683536,0,30483
2021-09-05,CZ,Czechia,EURO,207,1683743,0,30483
2021-09-06,CZ,Czechia,EURO,141,1683884,0,30483
2021-09-07,CZ,Czechia,EURO,393,1684277,1,30484
2021-09-08,CZ,Czechia,EURO,583,1684860,2,30486
2021-09-09,CZ,Czechia,EURO,382,1685242,1,30487
2021-09-10,CZ,Czechia,EURO,420,1685662,0,30487
2021-09-11,CZ,Czechia,EURO,445,1686107,0,30487
2021-09-12,CZ,Czechia,EURO,250,1686357,0,30487
2021-09-13,CZ,Czechia,EURO,136,1686493,2,30489
2021-09-14,CZ,Czechia,EURO,495,1686988,0,30489
2021-09-15,CZ,Czechia,EURO,557,1687545,3,30492
2021-09-16,CZ,Czechia,EURO,524,1688069,3,30495
2021-09-17,CZ,Czechia,EURO,562,1688631,0,30495
2021-09-18,CZ,Czechia,EURO,448,1689079,2,30497
2021-09-19,CZ,Czechia,EURO,302,1689381,5,30502
2021-09-20,CZ,Czechia,EURO,188,1689569,2,30504
2021-09-21,CZ,Czechia,EURO,481,1690050,4,30508
2021-09-22,CZ,Czechia,EURO,597,1690647,2,30510
2021-09-23,CZ,Czechia,EURO,523,1691170,2,30512
2021-09-24,CZ,Czechia,EURO,484,1691654,3,30515
2021-09-25,CZ,Czechia,EURO,529,1692183,0,30515
2021-09-26,CZ,Czechia,EURO,417,1692600,2,30517
2021-09-27,CZ,Czechia,EURO,251,1692851,0,30517
2021-09-28,CZ,Czechia,EURO,677,1693528,0,30517
2021-09-29,CZ,Czechia,EURO,474,1694002,3,30520
2021-09-30,CZ,Czechia,EURO,734,1694736,5,30525
2021-10-01,CZ,Czechia,EURO,922,1695658,1,30526
2021-10-02,CZ,Czechia,EURO,829,1696487,1,30527
2021-10-03,CZ,Czechia,EURO,552,1697039,1,30528
2021-10-04,CZ,Czechia,EURO,318,1697357,4,30532
2021-10-05,CZ,Czechia,EURO,822,1698179,4,30536
2021-10-06,CZ,Czechia,EURO,1131,1699310,3,30539
2021-10-07,CZ,Czechia,EURO,1048,1700358,5,30544
2021-10-08,CZ,Czechia,EURO,992,1701350,3,30547
2021-10-09,CZ,Czechia,EURO,1019,1702369,4,30551
2021-10-10,CZ,Czechia,EURO,668,1703037,3,30554
2021-10-11,CZ,Czechia,EURO,338,1703375,4,30558
2021-10-12,CZ,Czechia,EURO,1345,1704720,5,30563
2021-10-13,CZ,Czechia,EURO,1508,1706228,7,30570
2021-10-14,CZ,Czechia,EURO,1500,1707728,6,30576
2021-10-15,CZ,Czechia,EURO,1540,1709268,6,30582
2021-10-16,CZ,Czechia,EURO,1782,1711050,10,30592
2021-10-17,CZ,Czechia,EURO,1158,1712208,8,30600
2021-10-18,CZ,Czechia,EURO,796,1713004,11,30611
2021-10-19,CZ,Czechia,EURO,2539,1715543,12,30623
2021-10-20,CZ,Czechia,EURO,3249,1718792,10,30633
2021-10-21,CZ,Czechia,EURO,3280,1722072,7,30640
2021-10-22,CZ,Czechia,EURO,3646,1725718,10,30650
2021-10-23,CZ,Czechia,EURO,4239,1729957,14,30664
2021-10-24,CZ,Czechia,EURO,2756,1732713,13,30677
2021-10-25,CZ,Czechia,EURO,1840,1734553,21,30698
2021-10-26,CZ,Czechia,EURO,4287,1738840,20,30718
2021-10-27,CZ,Czechia,EURO,6291,1745131,16,30734
2021-10-28,CZ,Czechia,EURO,5866,1750997,21,30755
2021-10-29,CZ,Czechia,EURO,4357,1755354,26,30781
2021-10-30,CZ,Czechia,EURO,5759,1761113,26,30807
2021-10-31,CZ,Czechia,EURO,5061,1766174,24,30831
2021-11-01,CZ,Czechia,EURO,2792,1768966,31,30862
2021-11-02,CZ,Czechia,EURO,7617,1776583,31,30893
2021-11-03,CZ,Czechia,EURO,9941,1786524,36,30929
2021-11-04,CZ,Czechia,EURO,9483,1796007,45,30974
2021-11-05,CZ,Czechia,EURO,8494,1804501,45,31019
2021-11-06,CZ,Czechia,EURO,9256,1813757,57,31076
2021-11-07,CZ,Czechia,EURO,5744,1819501,52,31128
2021-11-08,CZ,Czechia,EURO,3012,1822513,39,31167
2021-11-09,CZ,Czechia,EURO,9289,1831802,48,31215
2021-11-10,CZ,Czechia,EURO,14583,1846385,63,31278
2021-11-11,CZ,Czechia,EURO,13571,1859956,75,31353
2021-11-12,CZ,Czechia,EURO,10454,1870410,71,31424
2021-11-13,CZ,Czechia,EURO,14260,1884670,68,31492
2021-11-14,CZ,Czechia,EURO,9183,1893853,74,31566
2021-11-15,CZ,Czechia,EURO,5698,1899551,62,31628
2021-11-16,CZ,Czechia,EURO,11562,1911113,93,31721
2021-11-17,CZ,Czechia,EURO,22540,1933653,70,31791
2021-11-18,CZ,Czechia,EURO,14197,1947850,82,31873
2021-11-19,CZ,Czechia,EURO,13518,1961368,120,31993
2021-11-20,CZ,Czechia,EURO,22972,1984340,113,32106
2021-11-21,CZ,Czechia,EURO,14414,1998754,96,32202
2021-11-22,CZ,Czechia,EURO,8278,2007032,113,32315
2021-11-23,CZ,Czechia,EURO,14518,2021550,111,32426
2021-11-24,CZ,Czechia,EURO,25912,2047462,115,32541
2021-11-25,CZ,Czechia,EURO,18046,2065508,93,32634
2021-11-26,CZ,Czechia,EURO,27937,2093445,114,32748
2021-11-27,CZ,Czechia,EURO,20382,2113827,118,32866
2021-11-28,CZ,Czechia,EURO,12528,2126355,95,32961
2021-11-29,CZ,Czechia,EURO,9307,2135662,120,33081
2021-11-30,CZ,Czechia,EURO,17617,2153279,108,33189
2021-12-01,CZ,Czechia,EURO,22024,2175303,120,33309
2021-12-02,CZ,Czechia,EURO,21153,2196456,140,33449
2021-12-03,CZ,Czechia,EURO,18623,2215079,125,33574
2021-12-04,CZ,Czechia,EURO,17685,2232764,119,33693
2021-12-05,CZ,Czechia,EURO,10982,2243746,109,33802
2021-12-06,CZ,Czechia,EURO,6334,2250080,110,33912
2021-12-07,CZ,Czechia,EURO,15580,2265660,123,34035
2021-12-08,CZ,Czechia,EURO,19533,2285193,110,34145
2021-12-09,CZ,Czechia,EURO,16209,2301402,113,34258
2021-12-10,CZ,Czechia,EURO,14264,2315666,114,34372
2021-12-11,CZ,Czechia,EURO,12400,2328066,120,34492
2021-12-12,CZ,Czechia,EURO,9085,2337151,100,34592
2021-12-13,CZ,Czechia,EURO,4129,2341280,123,34715
2021-12-14,CZ,Czechia,EURO,11905,2353185,114,34829
2021-12-15,CZ,Czechia,EURO,16707,2369892,114,34943
2021-12-16,CZ,Czechia,EURO,11617,2381509,124,35067
2021-12-17,CZ,Czechia,EURO,9499,2391008,97,35164
2021-12-18,CZ,Czechia,EURO,8962,2399970,88,35252
2021-12-19,CZ,Czechia,EURO,5985,2405955,103,35355
2021-12-20,CZ,Czechia,EURO,3744,2409699,68,35423
2021-12-21,CZ,Czechia,EURO,8599,2418298,79,35502
2021-12-22,CZ,Czechia,EURO,11845,2430143,81,35583
2021-12-23,CZ,Czechia,EURO,7696,2437839,84,35667
2021-12-24,CZ,Czechia,EURO,7360,2445199,58,35725
2021-12-25,CZ,Czechia,EURO,2045,2447244,78,35803
2021-12-26,CZ,Czechia,EURO,1090,2448334,68,35871
2021-12-27,CZ,Czechia,EURO,2015,2450349,84,35955
2021-12-28,CZ,Czechia,EURO,6862,2457211,51,36006
2021-12-29,CZ,Czechia,EURO,9078,2466289,72,36078
2021-12-30,CZ,Czechia,EURO,6159,2472448,75,36153
2021-12-31,CZ,Czechia,EURO,5756,2478204,58,36211
2022-01-01,CZ,Czechia,EURO,4997,2483201,55,36266
2022-01-02,CZ,Czechia,EURO,1093,2484294,46,36312
2022-01-03,CZ,Czechia,EURO,1931,2486225,51,36363
2022-01-04,CZ,Czechia,EURO,9358,2495583,61,36424
2022-01-05,CZ,Czechia,EURO,10179,2505762,61,36485
2022-01-06,CZ,Czechia,EURO,7388,2513150,39,36524
2022-01-07,CZ,Czechia,EURO,6640,2519790,58,36582
2022-01-08,CZ,Czechia,EURO,6672,2526462,45,36627
2022-01-09,CZ,Czechia,EURO,3963,2530425,43,36670
2022-01-10,CZ,Czechia,EURO,2764,2533189,23,36693
2022-01-11,CZ,Czechia,EURO,7355,2540544,44,36737
2022-01-12,CZ,Czechia,EURO,12376,2552920,38,36775
2022-01-13,CZ,Czechia,EURO,11466,2564386,41,36816
2022-01-14,CZ,Czechia,EURO,11692,2576078,32,36848
2022-01-15,CZ,Czechia,EURO,13224,2589302,32,36880
2022-01-16,CZ,Czechia,EURO,9293,2598595,25,36905
2022-01-17,CZ,Czechia,EURO,7246,2605841,30,36935
2022-01-18,CZ,Czechia,EURO,20305,2626146,26,36961
2022-01-19,CZ,Czechia,EURO,28501,2654647,25,36986
2022-01-20,CZ,Czechia,EURO,26014,2680661,27,37013
2022-01-21,CZ,Czechia,EURO,26938,2707599,19,37032
2022-01-22,CZ,Czechia,EURO,26610,2734209,21,37053
2022-01-23,CZ,Czechia,EURO,18353,2752562,22,37075
2022-01-24,CZ,Czechia,EURO,12897,2765459,18,37093
2022-01-25,CZ,Czechia,EURO,30386,2795845,22,37115
2022-01-26,CZ,Czechia,EURO,39633,2835478,14,37129
2022-01-27,CZ,Czechia,EURO,54691,2890169,19,37148
2022-01-28,CZ,Czechia,EURO,34806,2924975,26,37174
2022-01-29,CZ,Czechia,EURO,47264,2972239,20,37194
2022-01-30,CZ,Czechia,EURO,18281,2990520,26,37220
2022-01-31,CZ,Czechia,EURO,23934,3014454,28,37248
2022-02-01,CZ,Czechia,EURO,29547,3044001,34,37282
2022-02-02,CZ,Czechia,EURO,57232,3101233,43,37325
2022-02-03,CZ,Czechia,EURO,43326,3144559,39,37364
2022-02-04,CZ,Czechia,EURO,37682,3182241,37,37401
2022-02-05,CZ,Czechia,EURO,28699,3210940,51,37452
2022-02-06,CZ,Czechia,EURO,24001,3234941,45,37497
2022-02-07,CZ,Czechia,EURO,9068,3244009,43,37540
2022-02-08,CZ,Czechia,EURO,29610,3273619,56,37596
2022-02-09,CZ,Czechia,EURO,37640,3311259,46,37642
2022-02-10,CZ,Czechia,EURO,29059,3340318,18,37660
.
40758a
2022-02-10,CY,Cyprus,EURO,2779,280643,5,761
.
39989a
2022-02-10,CW,Curaçao,AMRO,112,37966,0,247
.
39220a
2022-02-10,CU,Cuba,AMRO,0,1055927,3,8450
.
38451a
2022-02-10,HR,Croatia,EURO,7868,998463,37,14281
.
37682a
2022-02-10,CI,Côte d’Ivoire,AFRO,29,81005,0,787
.
36913a
2022-02-10,CR,Costa Rica,AMRO,6136,739844,18,7712
.
36144a
2022-02-10,CK,Cook Islands,WPRO,0,0,0,0
.
35375a
2022-02-10,CG,Congo,AFRO,6,23860,0,375
.
34606a
2022-02-10,KM,Comoros,AFRO,13,7978,0,160
.
33837a
2022-02-10,CO,Colombia,AMRO,9730,5985516,205,136197
.
33068a
2022-02-10,CN,China,WPRO,1244,143843,2,5702
.
32299a
2022-02-10,CL,Chile,AMRO,34253,2466098,24,40111
.
31530a
2022-02-10,TD,Chad,AFRO,0,7216,0,190
.
30761a
2022-02-10,CF,Central African Republic,AFRO,0,14110,0,110
.
29992a
2022-02-10,KY,Cayman Islands,AMRO,0,15934,0,16
.
29223a
2022-02-10,CA,Canada,AMRO,8853,3148878,122,34969
.
28454a
2022-02-10,CM,Cameroon,AFRO,0,117676,0,1907
.
27685a
2022-02-10,KH,Cambodia,WPRO,223,122206,0,3015
.
26916a
2022-02-10,CV,Cabo Verde,AFRO,0,55811,0,398
.
26147a
2022-02-10,BI,Burundi,AFRO,60,37816,0,15
.
25378a
2022-02-10,BF,Burkina Faso,AFRO,11,20696,0,375
.
24609a
2022-02-10,BG,Bulgaria,EURO,7263,1018851,108,34152
.
23840a
2022-02-10,BN,Brunei Darussalam,WPRO,441,18845,0,59
.
23071a
2022-02-10,VG,British Virgin Islands,AMRO,0,5928,0,58
.
22302a
2022-02-10,BR,Brazil,AMRO,177027,26776620,1189,633810
.
21533a
2022-02-10,BW,Botswana,AFRO,0,257167,0,2593
.
20764a
2022-02-10,BA,Bosnia and Herzegovina,EURO,1478,359876,41,14897
.
19995a
2022-02-10,XA,Bonaire,AMRO,28,6683,0,28
.
19226a
2022-02-10,BO,Bolivia (Plurinational State of),AMRO,2233,877139,28,21199
.
18457a
2022-02-10,BT,Bhutan,SEARO,131,6779,1,5
.
17688a
2022-02-10,BM,Bermuda,AMRO,0,11058,0,119
.
16919a
2022-02-10,BJ,Benin,AFRO,0,26498,0,163
.
16150a
2022-02-10,BZ,Belize,AMRO,337,54516,1,631
.
15210,15381c
2021-08-22,BE,Belgium,EURO,1285,1160002,7,25490
2021-08-23,BE,Belgium,EURO,956,1160958,7,25497
2021-08-24,BE,Belgium,EURO,2654,1163612,3,25500
2021-08-25,BE,Belgium,EURO,2460,1166072,6,25506
2021-08-26,BE,Belgium,EURO,2395,1168467,7,25513
2021-08-27,BE,Belgium,EURO,2186,1170653,6,25519
2021-08-28,BE,Belgium,EURO,2217,1172870,5,25524
2021-08-29,BE,Belgium,EURO,1372,1174242,4,25528
2021-08-30,BE,Belgium,EURO,832,1175074,4,25532
2021-08-31,BE,Belgium,EURO,2943,1178017,5,25537
2021-09-01,BE,Belgium,EURO,2357,1180374,4,25541
2021-09-02,BE,Belgium,EURO,2222,1182596,7,25548
2021-09-03,BE,Belgium,EURO,2113,1184709,6,25554
2021-09-04,BE,Belgium,EURO,2155,1186864,6,25560
2021-09-05,BE,Belgium,EURO,1240,1188104,10,25570
2021-09-06,BE,Belgium,EURO,733,1188837,8,25578
2021-09-07,BE,Belgium,EURO,2800,1191637,7,25585
2021-09-08,BE,Belgium,EURO,2361,1193998,9,25594
2021-09-09,BE,Belgium,EURO,2190,1196188,9,25603
2021-09-10,BE,Belgium,EURO,2105,1198293,6,25609
2021-09-11,BE,Belgium,EURO,2323,1200616,7,25616
2021-09-12,BE,Belgium,EURO,1306,1201922,7,25623
2021-09-13,BE,Belgium,EURO,679,1202601,7,25630
2021-09-14,BE,Belgium,EURO,2930,1205531,7,25637
2021-09-15,BE,Belgium,EURO,2496,1208027,8,25645
2021-09-16,BE,Belgium,EURO,2322,1210349,7,25652
2021-09-17,BE,Belgium,EURO,2426,1212775,1,25653
2021-09-18,BE,Belgium,EURO,2390,1215165,5,25658
2021-09-19,BE,Belgium,EURO,1260,1216425,9,25667
2021-09-20,BE,Belgium,EURO,652,1217077,7,25674
2021-09-21,BE,Belgium,EURO,2939,1220016,6,25680
2021-09-22,BE,Belgium,EURO,2268,1222284,5,25685
2021-09-23,BE,Belgium,EURO,2171,1224455,11,25696
2021-09-24,BE,Belgium,EURO,2080,1226535,11,25707
2021-09-25,BE,Belgium,EURO,2253,1228788,7,25714
2021-09-26,BE,Belgium,EURO,1216,1230004,7,25721
2021-09-27,BE,Belgium,EURO,723,1230727,7,25728
2021-09-28,BE,Belgium,EURO,2628,1233355,13,25741
2021-09-29,BE,Belgium,EURO,2391,1235746,7,25748
2021-09-30,BE,Belgium,EURO,2166,1237912,7,25755
2021-10-01,BE,Belgium,EURO,2163,1240075,11,25766
2021-10-02,BE,Belgium,EURO,2148,1242223,6,25772
2021-10-03,BE,Belgium,EURO,1147,1243370,8,25780
2021-10-04,BE,Belgium,EURO,678,1244048,8,25788
2021-10-05,BE,Belgium,EURO,2791,1246839,5,25793
2021-10-06,BE,Belgium,EURO,2290,1249129,14,25807
2021-10-07,BE,Belgium,EURO,2545,1251674,13,25820
2021-10-08,BE,Belgium,EURO,2516,1254190,11,25831
2021-10-09,BE,Belgium,EURO,2543,1256733,7,25838
2021-10-10,BE,Belgium,EURO,1423,1258156,11,25849
2021-10-11,BE,Belgium,EURO,820,1258976,4,25853
2021-10-12,BE,Belgium,EURO,3924,1262900,18,25871
2021-10-13,BE,Belgium,EURO,3435,1266335,13,25884
2021-10-14,BE,Belgium,EURO,3595,1269930,8,25892
2021-10-15,BE,Belgium,EURO,3890,1273820,10,25902
2021-10-16,BE,Belgium,EURO,4168,1277988,18,25920
2021-10-17,BE,Belgium,EURO,2376,1280364,14,25934
2021-10-18,BE,Belgium,EURO,1490,1281854,10,25944
2021-10-19,BE,Belgium,EURO,6570,1288424,19,25963
2021-10-20,BE,Belgium,EURO,6295,1294719,13,25976
2021-10-21,BE,Belgium,EURO,6552,1301271,14,25990
2021-10-22,BE,Belgium,EURO,6905,1308176,10,26000
2021-10-23,BE,Belgium,EURO,7147,1315323,18,26018
2021-10-24,BE,Belgium,EURO,4090,1319413,20,26038
2021-10-25,BE,Belgium,EURO,2450,1321863,16,26054
2021-10-26,BE,Belgium,EURO,9703,1331566,18,26072
2021-10-27,BE,Belgium,EURO,9400,1340966,27,26099
2021-10-28,BE,Belgium,EURO,9224,1350190,33,26132
2021-10-29,BE,Belgium,EURO,9193,1359383,18,26150
2021-10-30,BE,Belgium,EURO,9289,1368672,21,26171
2021-10-31,BE,Belgium,EURO,4971,1373643,16,26187
2021-11-01,BE,Belgium,EURO,3058,1376701,18,26205
2021-11-02,BE,Belgium,EURO,3581,1380282,25,26230
2021-11-03,BE,Belgium,EURO,11714,1391996,20,26250
2021-11-04,BE,Belgium,EURO,10706,1402702,17,26267
2021-11-05,BE,Belgium,EURO,10180,1412882,26,26293
2021-11-06,BE,Belgium,EURO,11139,1424021,25,26318
2021-11-07,BE,Belgium,EURO,6453,1430474,30,26348
2021-11-08,BE,Belgium,EURO,4071,1434545,15,26363
2021-11-09,BE,Belgium,EURO,15267,1449812,28,26391
2021-11-10,BE,Belgium,EURO,13017,1462829,27,26418
2021-11-11,BE,Belgium,EURO,12750,1475579,26,26444
2021-11-12,BE,Belgium,EURO,5054,1480633,32,26476
2021-11-13,BE,Belgium,EURO,13751,1494384,39,26515
2021-11-14,BE,Belgium,EURO,8361,1502745,20,26535
2021-11-15,BE,Belgium,EURO,5506,1508251,27,26562
2021-11-16,BE,Belgium,EURO,20836,1529087,46,26608
2021-11-17,BE,Belgium,EURO,18431,1547518,29,26637
2021-11-18,BE,Belgium,EURO,18145,1565663,42,26679
2021-11-19,BE,Belgium,EURO,18572,1584235,43,26722
2021-11-20,BE,Belgium,EURO,19147,1603382,33,26755
2021-11-21,BE,Belgium,EURO,11215,1614597,36,26791
2021-11-22,BE,Belgium,EURO,6754,1621351,36,26827
2021-11-23,BE,Belgium,EURO,25622,1646973,35,26862
2021-11-24,BE,Belgium,EURO,21138,1668111,38,26900
2021-11-25,BE,Belgium,EURO,20171,1688282,49,26949
2021-11-26,BE,Belgium,EURO,20228,1708510,44,26993
2021-11-27,BE,Belgium,EURO,20041,1728551,40,27033
2021-11-28,BE,Belgium,EURO,11588,1740139,48,27081
2021-11-29,BE,Belgium,EURO,7072,1747211,47,27128
2021-11-30,BE,Belgium,EURO,25204,1772415,45,27173
2021-12-01,BE,Belgium,EURO,20868,1793283,61,27234
2021-12-02,BE,Belgium,EURO,19664,1812947,43,27277
2021-12-03,BE,Belgium,EURO,18325,1831272,53,27330
2021-12-04,BE,Belgium,EURO,17764,1849036,48,27378
2021-12-05,BE,Belgium,EURO,9634,1858670,45,27423
2021-12-06,BE,Belgium,EURO,5975,1864645,57,27480
2021-12-07,BE,Belgium,EURO,20736,1885381,39,27519
2021-12-08,BE,Belgium,EURO,15660,1901041,49,27568
2021-12-09,BE,Belgium,EURO,15013,1916054,55,27623
2021-12-10,BE,Belgium,EURO,13435,1929489,35,27658
2021-12-11,BE,Belgium,EURO,13101,1942590,48,27706
2021-12-12,BE,Belgium,EURO,7115,1949705,45,27751
2021-12-13,BE,Belgium,EURO,3908,1953613,44,27795
2021-12-14,BE,Belgium,EURO,13883,1967496,43,27838
2021-12-15,BE,Belgium,EURO,10582,1978078,37,27875
2021-12-16,BE,Belgium,EURO,9280,1987358,41,27916
2021-12-17,BE,Belgium,EURO,8110,1995468,37,27953
2021-12-18,BE,Belgium,EURO,7741,2003209,26,27979
2021-12-19,BE,Belgium,EURO,4754,2007963,36,28015
2021-12-20,BE,Belgium,EURO,2850,2010813,38,28053
2021-12-21,BE,Belgium,EURO,9108,2019921,36,28089
2021-12-22,BE,Belgium,EURO,7372,2027293,36,28125
2021-12-23,BE,Belgium,EURO,7387,2034680,37,28162
2021-12-24,BE,Belgium,EURO,7522,2042202,36,28198
2021-12-25,BE,Belgium,EURO,6518,2048720,35,28233
2021-12-26,BE,Belgium,EURO,2817,2051537,20,28253
2021-12-27,BE,Belgium,EURO,4565,2056102,22,28275
2021-12-28,BE,Belgium,EURO,13292,2069394,28,28303
2021-12-29,BE,Belgium,EURO,12817,2082211,21,28324
2021-12-30,BE,Belgium,EURO,15039,2097250,34,28358
2021-12-31,BE,Belgium,EURO,16056,2113306,29,28387
2022-01-01,BE,Belgium,EURO,12285,2125591,16,28403
2022-01-02,BE,Belgium,EURO,4069,2129660,22,28425
2022-01-03,BE,Belgium,EURO,9082,2138742,15,28440
2022-01-04,BE,Belgium,EURO,27571,2166313,25,28465
2022-01-05,BE,Belgium,EURO,28112,2194425,17,28482
2022-01-06,BE,Belgium,EURO,26041,2220466,14,28496
2022-01-07,BE,Belgium,EURO,23627,2244093,19,28515
2022-01-08,BE,Belgium,EURO,23794,2267887,19,28534
2022-01-09,BE,Belgium,EURO,15339,2283226,17,28551
2022-01-10,BE,Belgium,EURO,11220,2294446,23,28574
2022-01-11,BE,Belgium,EURO,37739,2332185,25,28599
2022-01-12,BE,Belgium,EURO,31684,2363869,24,28623
2022-01-13,BE,Belgium,EURO,31134,2395003,23,28646
2022-01-14,BE,Belgium,EURO,30095,2425098,21,28667
2022-01-15,BE,Belgium,EURO,31796,2456894,17,28684
2022-01-16,BE,Belgium,EURO,21166,2478060,14,28698
2022-01-17,BE,Belgium,EURO,14987,2493047,20,28718
2022-01-18,BE,Belgium,EURO,62618,2555665,32,28750
2022-01-19,BE,Belgium,EURO,60693,2616358,28,28778
2022-01-20,BE,Belgium,EURO,60871,2677229,38,28816
2022-01-21,BE,Belgium,EURO,57243,2734472,17,28833
2022-01-22,BE,Belgium,EURO,56421,2790893,23,28856
2022-01-23,BE,Belgium,EURO,32762,2823655,26,28882
2022-01-24,BE,Belgium,EURO,20736,2844391,16,28898
2022-01-25,BE,Belgium,EURO,75927,2920318,26,28924
2022-01-26,BE,Belgium,EURO,62459,2982777,37,28961
2022-01-27,BE,Belgium,EURO,54718,3037495,32,28993
2022-01-28,BE,Belgium,EURO,47479,3084974,28,29021
2022-01-29,BE,Belgium,EURO,41387,3126361,45,29066
2022-01-30,BE,Belgium,EURO,23209,3149570,27,29093
2022-01-31,BE,Belgium,EURO,13199,3162769,37,29130
2022-02-01,BE,Belgium,EURO,49986,3212755,29,29159
2022-02-02,BE,Belgium,EURO,36697,3249452,40,29199
2022-02-03,BE,Belgium,EURO,30751,3280203,49,29248
2022-02-04,BE,Belgium,EURO,25698,3305901,43,29291
2022-02-05,BE,Belgium,EURO,22348,3328249,58,29349
2022-02-06,BE,Belgium,EURO,12443,3340692,33,29382
2022-02-07,BE,Belgium,EURO,7254,3347946,35,29417
2022-02-08,BE,Belgium,EURO,27142,3375088,35,29452
2022-02-09,BE,Belgium,EURO,11122,3386210,39,29491
2022-02-10,BE,Belgium,EURO,13,3386223,6,29497
.
14612a
2022-02-10,BY,Belarus,EURO,8254,797188,15,6190
.
13843a
2022-02-10,BB,Barbados,AMRO,714,49372,2,288
.
13074a
2022-02-10,BD,Bangladesh,SEARO,7264,1894535,41,28744
.
12305a
2022-02-10,BH,Bahrain,EMRO,6581,441825,2,1418
.
11536a
2022-02-10,BS,Bahamas,AMRO,0,32802,0,753
.
10767a
2022-02-10,AZ,Azerbaijan,EURO,7779,718145,28,8948
.
9998a
2022-02-10,AT,Austria,EURO,39647,2164139,26,13773
.
9229c
2022-02-09,AU,Australia,WPRO,24547,2405592,56,4303
2022-02-10,AU,Australia,WPRO,31064,2436656,63,4366
.
8460a
2022-02-10,AW,Aruba,AMRO,49,33377,1,196
.
7691a
2022-02-10,AM,Armenia,EURO,2842,399727,6,8114
.
6922a
2022-02-10,AR,Argentina,AMRO,32790,8648075,284,123227
.
6153a
2022-02-10,AG,Antigua and Barbuda,AMRO,0,6853,0,131
.
5384a
2022-02-10,AI,Anguilla,AMRO,0,2436,0,9
.
4615a
2022-02-10,AO,Angola,AFRO,29,98453,0,1896
.
3846a
2022-02-10,AD,Andorra,EURO,181,36989,1,148
.
3077a
2022-02-10,AS,American Samoa,WPRO,0,57,0,0
.
2308a
2022-02-10,DZ,Algeria,AFRO,585,259673,11,6678
.
1539a
2022-02-10,AL,Albania,EURO,700,266416,6,3399
.
770a
2022-02-10,AF,Afghanistan,EMRO,811,168550,11,7465
.
w WHO-COVID-19-global-data.csv_2022-02-11_20:20:01
q

ed_heredoc
# 
# Dateiname: WHO-COVID-19-global-data.csv_2022-02-11_20:20:01 
# Zugriffsrechte -rw-r--r-- setzen 
  chmod 644 WHO-COVID-19-global-data.csv_2022-02-11_20:20:01 
# ctime war: - 
# atime auf    2022-06-24 00:58:45.644079000 +0200  setzen 
  touch -a -d '2022-06-24 00:58:45.644079000 +0200' WHO-COVID-19-global-data.csv_2022-02-11_20:20:01 
# mtime auf    2022-02-10 18:50:01.994207000 +0100  setzen 
  touch -m -d '2022-02-10 18:50:01.994207000 +0100' WHO-COVID-19-global-data.csv_2022-02-11_20:20:01 
