#!/bin/bash
#
#
# Dies ist ein Script um aus der Datei (Vorgaenger) 
#   WHO-COVID-19-global-data.csv_2022-02-14_20:30:01 
# die Datei 
#   WHO-COVID-19-global-data.csv_2022-02-15_19:40:02
# zu generieren. .
#
# Wenn  sich mehrere Dateien mit Endnug .diff.bash im Verz. befinden können 
# sie mit 
#   for datei in $(ls *.diff.bash) ;do ./${datei} ; done
# ausgeführt werden. Wichtig ist, das die Reihenfolge des Aufrufs stimmt 
# weil jedes Script auf das Ergebnis des Vorgängerscripts angewiesen ist. 
#
# Bekannter Fehler: wenn die Originaldatei keinen Zeilenumbruch am Dateiende 
# hatte hängt das ed-Script einen Zeilenumbruch an. 
#
/bin/ed WHO-COVID-19-global-data.csv_2022-02-14_20:30:01 <<ed_heredoc
182728a
2022-02-12,ZW,Zimbabwe,AFRO,174,231214,1,5374
2022-02-13,ZW,Zimbabwe,AFRO,85,231299,0,5374
2022-02-14,ZW,Zimbabwe,AFRO,82,231381,0,5374
.
181957a
2022-02-12,ZM,Zambia,AFRO,457,309013,1,3936
2022-02-13,ZM,Zambia,AFRO,280,309293,1,3937
2022-02-14,ZM,Zambia,AFRO,209,309502,0,3937
.
181186c
2022-02-11,YE,Yemen,EMRO,36,11640,5,2098
2022-02-12,YE,Yemen,EMRO,19,11659,2,2100
2022-02-13,YE,Yemen,EMRO,5,11664,2,2102
2022-02-14,YE,Yemen,EMRO,7,11671,1,2103
.
180415a
2022-02-12,WF,Wallis and Futuna,WPRO,0,453,0,7
2022-02-13,WF,Wallis and Futuna,WPRO,0,453,0,7
2022-02-14,WF,Wallis and Futuna,WPRO,0,453,0,7
.
179644a
2022-02-12,VN,Viet Nam,WPRO,26487,2457170,96,38784
2022-02-13,VN,Viet Nam,WPRO,27311,2484481,78,38862
2022-02-14,VN,Viet Nam,WPRO,26379,2510860,84,38946
.
178873a
2022-02-12,VE,Venezuela (Bolivarian Republic of),AMRO,1041,501586,10,5521
2022-02-13,VE,Venezuela (Bolivarian Republic of),AMRO,1576,503162,8,5529
2022-02-14,VE,Venezuela (Bolivarian Republic of),AMRO,1557,504719,9,5538
.
178102a
2022-02-12,VU,Vanuatu,WPRO,0,7,0,0
2022-02-13,VU,Vanuatu,WPRO,0,7,0,0
2022-02-14,VU,Vanuatu,WPRO,0,7,0,0
.
177331a
2022-02-12,UZ,Uzbekistan,EURO,504,233000,2,1599
2022-02-13,UZ,Uzbekistan,EURO,439,233439,2,1601
2022-02-14,UZ,Uzbekistan,EURO,322,233761,3,1604
.
176560a
2022-02-12,UY,Uruguay,AMRO,8812,758366,14,6710
2022-02-13,UY,Uruguay,AMRO,7594,765960,19,6729
2022-02-14,UY,Uruguay,AMRO,6797,772757,15,6744
.
175789a
2022-02-12,VI,United States Virgin Islands,AMRO,43,15171,1,105
2022-02-13,VI,United States Virgin Islands,AMRO,0,15171,0,105
2022-02-14,VI,United States Virgin Islands,AMRO,0,15171,0,105
.
175018a
2022-02-12,US,United States of America,AMRO,163685,76813431,2357,908314
2022-02-13,US,United States of America,AMRO,0,76813431,0,908314
2022-02-14,US,United States of America,AMRO,169757,76983188,2668,910982
.
174247a
2022-02-12,TZ,United Republic of Tanzania,AFRO,0,33436,0,792
2022-02-13,TZ,United Republic of Tanzania,AFRO,0,33436,0,792
2022-02-14,TZ,United Republic of Tanzania,AFRO,0,33436,0,792
.
173476a
2022-02-12,AE,United Arab Emirates,EMRO,1474,865576,5,2283
2022-02-13,AE,United Arab Emirates,EMRO,1395,866971,1,2284
2022-02-14,AE,United Arab Emirates,EMRO,1266,868237,1,2285
.
172705a
2022-02-12,UA,Ukraine,EURO,38212,4501182,265,102668
2022-02-13,UA,Ukraine,EURO,24518,4525700,140,102808
2022-02-14,UA,Ukraine,EURO,16993,4542693,142,102950
.
171934a
2022-02-12,UG,Uganda,AFRO,0,162639,0,3575
2022-02-13,UG,Uganda,AFRO,124,162763,2,3577
2022-02-14,UG,Uganda,AFRO,59,162822,2,3579
.
171163a
2022-02-12,TV,Tuvalu,WPRO,0,0,0,0
2022-02-13,TV,Tuvalu,WPRO,0,0,0,0
2022-02-14,TV,Tuvalu,WPRO,0,0,0,0
.
170392a
2022-02-12,TC,Turks and Caicos Islands,AMRO,7,5813,0,35
2022-02-13,TC,Turks and Caicos Islands,AMRO,10,5823,0,35
2022-02-14,TC,Turks and Caicos Islands,AMRO,5,5828,0,35
.
169621a
2022-02-12,TM,Turkmenistan,EURO,0,0,0,0
2022-02-13,TM,Turkmenistan,EURO,0,0,0,0
2022-02-14,TM,Turkmenistan,EURO,0,0,0,0
.
168850a
2022-02-12,TR,Turkey,EURO,95065,12747450,253,89994
2022-02-13,TR,Turkey,EURO,86193,12833643,272,90266
2022-02-14,TR,Turkey,EURO,73787,12907430,276,90542
.
168079c
2022-02-11,TN,Tunisia,EMRO,3823,958549,52,26941
2022-02-12,TN,Tunisia,EMRO,3328,961877,63,27004
2022-02-13,TN,Tunisia,EMRO,3080,964957,61,27065
2022-02-14,TN,Tunisia,EMRO,2095,967052,54,27119
.
167308a
2022-02-12,TT,Trinidad and Tobago,AMRO,738,118263,6,3501
2022-02-13,TT,Trinidad and Tobago,AMRO,963,119226,6,3507
2022-02-14,TT,Trinidad and Tobago,AMRO,777,120003,12,3519
.
166537a
2022-02-12,TO,Tonga,WPRO,0,73,0,0
2022-02-13,TO,Tonga,WPRO,0,73,0,0
2022-02-14,TO,Tonga,WPRO,68,141,0,0
.
165766a
2022-02-12,TK,Tokelau,WPRO,0,0,0,0
2022-02-13,TK,Tokelau,WPRO,0,0,0,0
2022-02-14,TK,Tokelau,WPRO,0,0,0,0
.
164995a
2022-02-12,TG,Togo,AFRO,0,36630,0,270
2022-02-13,TG,Togo,AFRO,4,36634,0,270
2022-02-14,TG,Togo,AFRO,26,36660,1,271
.
164224a
2022-02-12,TL,Timor-Leste,SEARO,155,21556,0,123
2022-02-13,TL,Timor-Leste,SEARO,75,21631,1,124
2022-02-14,TL,Timor-Leste,SEARO,117,21748,0,124
.
163453a
2022-02-12,GB,The United Kingdom,EURO,58316,18220519,193,159351
2022-02-13,GB,The United Kingdom,EURO,45500,18266019,167,159518
2022-02-14,GB,The United Kingdom,EURO,40844,18306863,52,159570
.
162682a
2022-02-12,TH,Thailand,SEARO,16330,2577445,25,22412
2022-02-13,TH,Thailand,SEARO,15882,2593327,24,22436
2022-02-14,TH,Thailand,SEARO,14900,2608227,26,22462
.
161911a
2022-02-12,TJ,Tajikistan,EURO,2,17767,0,125
2022-02-13,TJ,Tajikistan,EURO,6,17773,0,125
2022-02-14,TJ,Tajikistan,EURO,0,17773,0,125
.
161140c
2022-02-11,SY,Syrian Arab Republic,EMRO,135,52378,3,3020
2022-02-12,SY,Syrian Arab Republic,EMRO,126,52504,3,3023
2022-02-13,SY,Syrian Arab Republic,EMRO,122,52626,3,3026
2022-02-14,SY,Syrian Arab Republic,EMRO,125,52751,3,3029
.
160331,160369c
2022-01-04,CH,Switzerland,EURO,32266,1405502,11,11955
2022-01-05,CH,Switzerland,EURO,33365,1438867,10,11965
2022-01-06,CH,Switzerland,EURO,30642,1469509,13,11978
2022-01-07,CH,Switzerland,EURO,26114,1495623,12,11990
2022-01-08,CH,Switzerland,EURO,27270,1522893,28,12018
2022-01-09,CH,Switzerland,EURO,17771,1540664,17,12035
2022-01-10,CH,Switzerland,EURO,13377,1554041,10,12045
2022-01-11,CH,Switzerland,EURO,34527,1588568,17,12062
2022-01-12,CH,Switzerland,EURO,30897,1619465,12,12074
2022-01-13,CH,Switzerland,EURO,29604,1649069,10,12084
2022-01-14,CH,Switzerland,EURO,28616,1677685,14,12098
2022-01-15,CH,Switzerland,EURO,27624,1705309,13,12111
2022-01-16,CH,Switzerland,EURO,19292,1724601,16,12127
2022-01-17,CH,Switzerland,EURO,14759,1739360,14,12141
2022-01-18,CH,Switzerland,EURO,41803,1781163,12,12153
2022-01-19,CH,Switzerland,EURO,39313,1820476,16,12169
2022-01-20,CH,Switzerland,EURO,39095,1859571,21,12190
2022-01-21,CH,Switzerland,EURO,37657,1897228,19,12209
2022-01-22,CH,Switzerland,EURO,36630,1933858,11,12220
2022-01-23,CH,Switzerland,EURO,24632,1958490,17,12237
2022-01-24,CH,Switzerland,EURO,18339,1976829,7,12244
2022-01-25,CH,Switzerland,EURO,48419,2025248,8,12252
2022-01-26,CH,Switzerland,EURO,44287,2069535,19,12271
2022-01-27,CH,Switzerland,EURO,41553,2111088,10,12281
2022-01-28,CH,Switzerland,EURO,37818,2148906,10,12291
2022-01-29,CH,Switzerland,EURO,35739,2184645,17,12308
2022-01-30,CH,Switzerland,EURO,23397,2208042,15,12323
2022-01-31,CH,Switzerland,EURO,18126,2226168,21,12344
2022-02-01,CH,Switzerland,EURO,43567,2269735,13,12357
2022-02-02,CH,Switzerland,EURO,36908,2306643,15,12372
2022-02-03,CH,Switzerland,EURO,34426,2341069,15,12387
2022-02-04,CH,Switzerland,EURO,29240,2370309,8,12395
2022-02-05,CH,Switzerland,EURO,26617,2396926,7,12402
2022-02-06,CH,Switzerland,EURO,18339,2415265,10,12412
2022-02-07,CH,Switzerland,EURO,14517,2429782,11,12423
2022-02-08,CH,Switzerland,EURO,32261,2462043,15,12438
2022-02-09,CH,Switzerland,EURO,26793,2488836,11,12449
2022-02-10,CH,Switzerland,EURO,24125,2512961,11,12460
2022-02-11,CH,Switzerland,EURO,14173,2527134,5,12465
2022-02-12,CH,Switzerland,EURO,80,2527214,0,12465
2022-02-13,CH,Switzerland,EURO,0,2527214,0,12465
2022-02-14,CH,Switzerland,EURO,0,2527214,0,12465
.
160003,160328c
2021-02-10,CH,Switzerland,EURO,1350,536257,16,9381
2021-02-11,CH,Switzerland,EURO,1259,537516,23,9404
2021-02-12,CH,Switzerland,EURO,1171,538687,14,9418
2021-02-13,CH,Switzerland,EURO,1131,539818,15,9433
2021-02-14,CH,Switzerland,EURO,720,540538,18,9451
2021-02-15,CH,Switzerland,EURO,485,541023,22,9473
2021-02-16,CH,Switzerland,EURO,1303,542326,19,9492
2021-02-17,CH,Switzerland,EURO,1136,543462,8,9500
2021-02-18,CH,Switzerland,EURO,1215,544677,9,9509
2021-02-19,CH,Switzerland,EURO,1007,545684,10,9519
2021-02-20,CH,Switzerland,EURO,1094,546778,14,9533
2021-02-21,CH,Switzerland,EURO,691,547469,15,9548
2021-02-22,CH,Switzerland,EURO,527,547996,11,9559
2021-02-23,CH,Switzerland,EURO,1407,549403,9,9568
2021-02-24,CH,Switzerland,EURO,1258,550661,10,9578
2021-02-25,CH,Switzerland,EURO,1077,551738,8,9586
2021-02-26,CH,Switzerland,EURO,1119,552857,10,9596
2021-02-27,CH,Switzerland,EURO,1080,553937,9,9605
2021-02-28,CH,Switzerland,EURO,723,554660,10,9615
2021-03-01,CH,Switzerland,EURO,547,555207,7,9622
2021-03-02,CH,Switzerland,EURO,1419,556626,8,9630
2021-03-03,CH,Switzerland,EURO,1230,557856,11,9641
2021-03-04,CH,Switzerland,EURO,1240,559096,9,9650
2021-03-05,CH,Switzerland,EURO,1063,560159,9,9659
2021-03-06,CH,Switzerland,EURO,1278,561437,10,9669
2021-03-07,CH,Switzerland,EURO,765,562202,8,9677
2021-03-08,CH,Switzerland,EURO,582,562784,9,9686
2021-03-09,CH,Switzerland,EURO,1702,564486,10,9696
2021-03-10,CH,Switzerland,EURO,1388,565874,8,9704
2021-03-11,CH,Switzerland,EURO,1385,567259,12,9716
2021-03-12,CH,Switzerland,EURO,1341,568600,13,9729
2021-03-13,CH,Switzerland,EURO,1342,569942,9,9738
2021-03-14,CH,Switzerland,EURO,923,570865,14,9752
2021-03-15,CH,Switzerland,EURO,703,571568,9,9761
2021-03-16,CH,Switzerland,EURO,1923,573491,9,9770
2021-03-17,CH,Switzerland,EURO,1653,575144,11,9781
2021-03-18,CH,Switzerland,EURO,1824,576968,13,9794
2021-03-19,CH,Switzerland,EURO,1647,578615,9,9803
2021-03-20,CH,Switzerland,EURO,1545,580160,9,9812
2021-03-21,CH,Switzerland,EURO,1111,581271,4,9816
2021-03-22,CH,Switzerland,EURO,787,582058,7,9823
2021-03-23,CH,Switzerland,EURO,2263,584321,5,9828
2021-03-24,CH,Switzerland,EURO,1995,586316,12,9840
2021-03-25,CH,Switzerland,EURO,1931,588247,7,9847
2021-03-26,CH,Switzerland,EURO,2142,590389,13,9860
2021-03-27,CH,Switzerland,EURO,2000,592389,4,9864
2021-03-28,CH,Switzerland,EURO,1208,593597,10,9874
2021-03-29,CH,Switzerland,EURO,995,594592,9,9883
2021-03-30,CH,Switzerland,EURO,2532,597124,5,9888
2021-03-31,CH,Switzerland,EURO,2093,599217,12,9900
2021-04-01,CH,Switzerland,EURO,2132,601349,14,9914
2021-04-02,CH,Switzerland,EURO,1985,603334,12,9926
2021-04-03,CH,Switzerland,EURO,1205,604539,6,9932
2021-04-04,CH,Switzerland,EURO,1317,605856,12,9944
2021-04-05,CH,Switzerland,EURO,1022,606878,10,9954
2021-04-06,CH,Switzerland,EURO,1290,608168,17,9971
2021-04-07,CH,Switzerland,EURO,2690,610858,10,9981
2021-04-08,CH,Switzerland,EURO,2387,613245,10,9991
2021-04-09,CH,Switzerland,EURO,2490,615735,5,9996
2021-04-10,CH,Switzerland,EURO,2416,618151,8,10004
2021-04-11,CH,Switzerland,EURO,1682,619833,6,10010
2021-04-12,CH,Switzerland,EURO,1180,621013,7,10017
2021-04-13,CH,Switzerland,EURO,2742,623755,3,10020
2021-04-14,CH,Switzerland,EURO,2375,626130,10,10030
2021-04-15,CH,Switzerland,EURO,2214,628344,6,10036
2021-04-16,CH,Switzerland,EURO,2147,630491,4,10040
2021-04-17,CH,Switzerland,EURO,2121,632612,7,10047
2021-04-18,CH,Switzerland,EURO,1430,634042,9,10056
2021-04-19,CH,Switzerland,EURO,1048,635090,7,10063
2021-04-20,CH,Switzerland,EURO,2744,637834,8,10071
2021-04-21,CH,Switzerland,EURO,2391,640225,9,10080
2021-04-22,CH,Switzerland,EURO,2309,642534,5,10085
2021-04-23,CH,Switzerland,EURO,2266,644800,7,10092
2021-04-24,CH,Switzerland,EURO,2165,646965,10,10102
2021-04-25,CH,Switzerland,EURO,1456,648421,6,10108
2021-04-26,CH,Switzerland,EURO,1188,649609,9,10117
2021-04-27,CH,Switzerland,EURO,2441,652050,13,10130
2021-04-28,CH,Switzerland,EURO,2038,654088,11,10141
2021-04-29,CH,Switzerland,EURO,2009,656097,7,10148
2021-04-30,CH,Switzerland,EURO,1711,657808,8,10156
2021-05-01,CH,Switzerland,EURO,1677,659485,9,10165
2021-05-02,CH,Switzerland,EURO,1159,660644,12,10177
2021-05-03,CH,Switzerland,EURO,832,661476,8,10185
2021-05-04,CH,Switzerland,EURO,2019,663495,5,10190
2021-05-05,CH,Switzerland,EURO,1735,665230,4,10194
2021-05-06,CH,Switzerland,EURO,1649,666879,11,10205
2021-05-07,CH,Switzerland,EURO,1484,668363,4,10209
2021-05-08,CH,Switzerland,EURO,1573,669936,7,10216
2021-05-09,CH,Switzerland,EURO,1062,670998,5,10221
2021-05-10,CH,Switzerland,EURO,779,671777,5,10226
2021-05-11,CH,Switzerland,EURO,1718,673495,6,10232
2021-05-12,CH,Switzerland,EURO,1383,674878,4,10236
2021-05-13,CH,Switzerland,EURO,1441,676319,0,10236
2021-05-14,CH,Switzerland,EURO,672,676991,5,10241
2021-05-15,CH,Switzerland,EURO,1169,678160,4,10245
2021-05-16,CH,Switzerland,EURO,802,678962,2,10247
2021-05-17,CH,Switzerland,EURO,653,679615,9,10256
2021-05-18,CH,Switzerland,EURO,1671,681286,1,10257
2021-05-19,CH,Switzerland,EURO,1344,682630,3,10260
2021-05-20,CH,Switzerland,EURO,1212,683842,6,10266
2021-05-21,CH,Switzerland,EURO,1040,684882,3,10269
2021-05-22,CH,Switzerland,EURO,984,685866,10,10279
2021-05-23,CH,Switzerland,EURO,623,686489,5,10284
2021-05-24,CH,Switzerland,EURO,470,686959,5,10289
2021-05-25,CH,Switzerland,EURO,581,687540,4,10293
2021-05-26,CH,Switzerland,EURO,1148,688688,4,10297
2021-05-27,CH,Switzerland,EURO,923,689611,2,10299
2021-05-28,CH,Switzerland,EURO,849,690460,3,10302
2021-05-29,CH,Switzerland,EURO,751,691211,2,10304
2021-05-30,CH,Switzerland,EURO,500,691711,4,10308
2021-05-31,CH,Switzerland,EURO,357,692068,0,10308
2021-06-01,CH,Switzerland,EURO,854,692922,2,10310
2021-06-02,CH,Switzerland,EURO,652,693574,1,10311
2021-06-03,CH,Switzerland,EURO,551,694125,3,10314
2021-06-04,CH,Switzerland,EURO,468,694593,6,10320
2021-06-05,CH,Switzerland,EURO,491,695084,4,10324
2021-06-06,CH,Switzerland,EURO,313,695397,2,10326
2021-06-07,CH,Switzerland,EURO,187,695584,6,10332
2021-06-08,CH,Switzerland,EURO,584,696168,2,10334
2021-06-09,CH,Switzerland,EURO,417,696585,2,10336
2021-06-10,CH,Switzerland,EURO,375,696960,2,10338
2021-06-11,CH,Switzerland,EURO,304,697264,3,10341
2021-06-12,CH,Switzerland,EURO,318,697582,3,10344
2021-06-13,CH,Switzerland,EURO,194,697776,2,10346
2021-06-14,CH,Switzerland,EURO,121,697897,2,10348
2021-06-15,CH,Switzerland,EURO,328,698225,0,10348
2021-06-16,CH,Switzerland,EURO,233,698458,1,10349
2021-06-17,CH,Switzerland,EURO,191,698649,4,10353
2021-06-18,CH,Switzerland,EURO,156,698805,3,10356
2021-06-19,CH,Switzerland,EURO,149,698954,3,10359
2021-06-20,CH,Switzerland,EURO,103,699057,0,10359
2021-06-21,CH,Switzerland,EURO,78,699135,1,10360
2021-06-22,CH,Switzerland,EURO,165,699300,2,10362
2021-06-23,CH,Switzerland,EURO,122,699422,0,10362
2021-06-24,CH,Switzerland,EURO,127,699549,1,10363
2021-06-25,CH,Switzerland,EURO,113,699662,1,10364
2021-06-26,CH,Switzerland,EURO,98,699760,1,10365
2021-06-27,CH,Switzerland,EURO,60,699820,0,10365
2021-06-28,CH,Switzerland,EURO,59,699879,2,10367
2021-06-29,CH,Switzerland,EURO,150,700029,0,10367
2021-06-30,CH,Switzerland,EURO,115,700144,2,10369
2021-07-01,CH,Switzerland,EURO,159,700303,0,10369
2021-07-02,CH,Switzerland,EURO,169,700472,0,10369
2021-07-03,CH,Switzerland,EURO,165,700637,1,10370
2021-07-04,CH,Switzerland,EURO,129,700766,0,10370
2021-07-05,CH,Switzerland,EURO,139,700905,0,10370
2021-07-06,CH,Switzerland,EURO,310,701215,0,10370
2021-07-07,CH,Switzerland,EURO,289,701504,0,10370
2021-07-08,CH,Switzerland,EURO,320,701824,0,10370
2021-07-09,CH,Switzerland,EURO,316,702140,0,10370
2021-07-10,CH,Switzerland,EURO,327,702467,1,10371
2021-07-11,CH,Switzerland,EURO,255,702722,1,10372
2021-07-12,CH,Switzerland,EURO,230,702952,1,10373
2021-07-13,CH,Switzerland,EURO,571,703523,0,10373
2021-07-14,CH,Switzerland,EURO,522,704045,1,10374
2021-07-15,CH,Switzerland,EURO,590,704635,0,10374
2021-07-16,CH,Switzerland,EURO,623,705258,0,10374
2021-07-17,CH,Switzerland,EURO,645,705903,0,10374
2021-07-18,CH,Switzerland,EURO,454,706357,1,10375
2021-07-19,CH,Switzerland,EURO,394,706751,0,10375
2021-07-20,CH,Switzerland,EURO,857,707608,1,10376
2021-07-21,CH,Switzerland,EURO,737,708345,0,10376
2021-07-22,CH,Switzerland,EURO,873,709218,2,10378
2021-07-23,CH,Switzerland,EURO,724,709942,0,10378
2021-07-24,CH,Switzerland,EURO,743,710685,0,10378
2021-07-25,CH,Switzerland,EURO,539,711224,1,10379
2021-07-26,CH,Switzerland,EURO,480,711704,1,10380
2021-07-27,CH,Switzerland,EURO,951,712655,1,10381
2021-07-28,CH,Switzerland,EURO,740,713395,5,10386
2021-07-29,CH,Switzerland,EURO,785,714180,3,10389
2021-07-30,CH,Switzerland,EURO,783,714963,1,10390
2021-07-31,CH,Switzerland,EURO,803,715766,0,10390
2021-08-01,CH,Switzerland,EURO,656,716422,0,10390
2021-08-02,CH,Switzerland,EURO,535,716957,1,10391
2021-08-03,CH,Switzerland,EURO,1234,718191,1,10392
2021-08-04,CH,Switzerland,EURO,990,719181,1,10393
2021-08-05,CH,Switzerland,EURO,1070,720251,0,10393
2021-08-06,CH,Switzerland,EURO,1121,721372,0,10393
2021-08-07,CH,Switzerland,EURO,1152,722524,0,10393
2021-08-08,CH,Switzerland,EURO,1046,723570,0,10393
2021-08-09,CH,Switzerland,EURO,1008,724578,1,10394
2021-08-10,CH,Switzerland,EURO,2321,726899,2,10396
2021-08-11,CH,Switzerland,EURO,2031,728930,2,10398
2021-08-12,CH,Switzerland,EURO,2085,731015,3,10401
2021-08-13,CH,Switzerland,EURO,2167,733182,2,10403
2021-08-14,CH,Switzerland,EURO,2209,735391,1,10404
2021-08-15,CH,Switzerland,EURO,1679,737070,3,10407
2021-08-16,CH,Switzerland,EURO,1651,738721,2,10409
2021-08-17,CH,Switzerland,EURO,3951,742672,3,10412
2021-08-18,CH,Switzerland,EURO,2838,745510,4,10416
2021-08-19,CH,Switzerland,EURO,2710,748220,1,10417
2021-08-20,CH,Switzerland,EURO,2512,750732,4,10421
2021-08-21,CH,Switzerland,EURO,2561,753293,7,10428
2021-08-22,CH,Switzerland,EURO,1748,755041,3,10431
2021-08-23,CH,Switzerland,EURO,1633,756674,3,10434
2021-08-24,CH,Switzerland,EURO,3851,760525,6,10440
2021-08-25,CH,Switzerland,EURO,2916,763441,8,10448
2021-08-26,CH,Switzerland,EURO,2765,766206,4,10452
2021-08-27,CH,Switzerland,EURO,2693,768899,7,10459
2021-08-28,CH,Switzerland,EURO,2596,771495,4,10463
2021-08-29,CH,Switzerland,EURO,1677,773172,8,10471
2021-08-30,CH,Switzerland,EURO,1385,774557,5,10476
2021-08-31,CH,Switzerland,EURO,3562,778119,13,10489
2021-09-01,CH,Switzerland,EURO,2974,781093,4,10493
2021-09-02,CH,Switzerland,EURO,2942,784035,8,10501
2021-09-03,CH,Switzerland,EURO,3051,787086,4,10505
2021-09-04,CH,Switzerland,EURO,3077,790163,8,10513
2021-09-05,CH,Switzerland,EURO,1760,791923,6,10519
2021-09-06,CH,Switzerland,EURO,1399,793322,9,10528
2021-09-07,CH,Switzerland,EURO,3995,797317,8,10536
2021-09-08,CH,Switzerland,EURO,3044,800361,11,10547
2021-09-09,CH,Switzerland,EURO,3060,803421,7,10554
2021-09-10,CH,Switzerland,EURO,2769,806190,7,10561
2021-09-11,CH,Switzerland,EURO,2622,808812,5,10566
2021-09-12,CH,Switzerland,EURO,1551,810363,7,10573
2021-09-13,CH,Switzerland,EURO,1106,811469,10,10583
2021-09-14,CH,Switzerland,EURO,2764,814233,8,10591
2021-09-15,CH,Switzerland,EURO,2296,816529,3,10594
2021-09-16,CH,Switzerland,EURO,2242,818771,7,10601
2021-09-17,CH,Switzerland,EURO,1998,820769,3,10604
2021-09-18,CH,Switzerland,EURO,1691,822460,11,10615
2021-09-19,CH,Switzerland,EURO,1027,823487,4,10619
2021-09-20,CH,Switzerland,EURO,702,824189,6,10625
2021-09-21,CH,Switzerland,EURO,1880,826069,4,10629
2021-09-22,CH,Switzerland,EURO,1703,827772,4,10633
2021-09-23,CH,Switzerland,EURO,1531,829303,6,10639
2021-09-24,CH,Switzerland,EURO,1377,830680,7,10646
2021-09-25,CH,Switzerland,EURO,1343,832023,9,10655
2021-09-26,CH,Switzerland,EURO,886,832909,5,10660
2021-09-27,CH,Switzerland,EURO,607,833516,7,10667
2021-09-28,CH,Switzerland,EURO,1661,835177,3,10670
2021-09-29,CH,Switzerland,EURO,1208,836385,7,10677
2021-09-30,CH,Switzerland,EURO,1187,837572,11,10688
2021-10-01,CH,Switzerland,EURO,1195,838767,1,10689
2021-10-02,CH,Switzerland,EURO,1139,839906,5,10694
2021-10-03,CH,Switzerland,EURO,786,840692,5,10699
2021-10-04,CH,Switzerland,EURO,473,841165,3,10702
2021-10-05,CH,Switzerland,EURO,1278,842443,4,10706
2021-10-06,CH,Switzerland,EURO,1033,843476,6,10712
2021-10-07,CH,Switzerland,EURO,1008,844484,1,10713
2021-10-08,CH,Switzerland,EURO,1011,845495,8,10721
2021-10-09,CH,Switzerland,EURO,919,846414,3,10724
2021-10-10,CH,Switzerland,EURO,638,847052,5,10729
2021-10-11,CH,Switzerland,EURO,480,847532,4,10733
2021-10-12,CH,Switzerland,EURO,1172,848704,10,10743
2021-10-13,CH,Switzerland,EURO,965,849669,6,10749
2021-10-14,CH,Switzerland,EURO,963,850632,6,10755
2021-10-15,CH,Switzerland,EURO,958,851590,3,10758
2021-10-16,CH,Switzerland,EURO,985,852575,3,10761
2021-10-17,CH,Switzerland,EURO,700,853275,0,10761
2021-10-18,CH,Switzerland,EURO,680,853955,4,10765
2021-10-19,CH,Switzerland,EURO,1571,855526,2,10767
2021-10-20,CH,Switzerland,EURO,1289,856815,6,10773
2021-10-21,CH,Switzerland,EURO,1431,858246,9,10782
2021-10-22,CH,Switzerland,EURO,1371,859617,3,10785
2021-10-23,CH,Switzerland,EURO,1352,860969,5,10790
2021-10-24,CH,Switzerland,EURO,954,861923,4,10794
2021-10-25,CH,Switzerland,EURO,727,862650,4,10798
2021-10-26,CH,Switzerland,EURO,2024,864674,8,10806
2021-10-27,CH,Switzerland,EURO,1699,866373,5,10811
2021-10-28,CH,Switzerland,EURO,1807,868180,9,10820
2021-10-29,CH,Switzerland,EURO,1803,869983,7,10827
2021-10-30,CH,Switzerland,EURO,1864,871847,4,10831
2021-10-31,CH,Switzerland,EURO,1259,873106,6,10837
2021-11-01,CH,Switzerland,EURO,1081,874187,5,10842
2021-11-02,CH,Switzerland,EURO,2343,876530,5,10847
2021-11-03,CH,Switzerland,EURO,2983,879513,3,10850
2021-11-04,CH,Switzerland,EURO,2836,882349,3,10853
2021-11-05,CH,Switzerland,EURO,2843,885192,3,10856
2021-11-06,CH,Switzerland,EURO,2755,887947,7,10863
2021-11-07,CH,Switzerland,EURO,1931,889878,3,10866
2021-11-08,CH,Switzerland,EURO,1537,891415,10,10876
2021-11-09,CH,Switzerland,EURO,4204,895619,10,10886
2021-11-10,CH,Switzerland,EURO,3738,899357,11,10897
2021-11-11,CH,Switzerland,EURO,3970,903327,5,10902
2021-11-12,CH,Switzerland,EURO,3953,907280,13,10915
2021-11-13,CH,Switzerland,EURO,4144,911424,7,10922
2021-11-14,CH,Switzerland,EURO,2709,914133,7,10929
2021-11-15,CH,Switzerland,EURO,2165,916298,8,10937
2021-11-16,CH,Switzerland,EURO,6133,922431,8,10945
2021-11-17,CH,Switzerland,EURO,5626,928057,14,10959
2021-11-18,CH,Switzerland,EURO,6183,934240,13,10972
2021-11-19,CH,Switzerland,EURO,6056,940296,17,10989
2021-11-20,CH,Switzerland,EURO,6200,946496,6,10995
2021-11-21,CH,Switzerland,EURO,4141,950637,9,11004
2021-11-22,CH,Switzerland,EURO,3406,954043,13,11017
2021-11-23,CH,Switzerland,EURO,9167,963210,20,11037
2021-11-24,CH,Switzerland,EURO,8012,971222,18,11055
2021-11-25,CH,Switzerland,EURO,8468,979690,18,11073
2021-11-26,CH,Switzerland,EURO,7988,987678,8,11081
2021-11-27,CH,Switzerland,EURO,7968,995646,14,11095
2021-11-28,CH,Switzerland,EURO,5262,1000908,16,11111
2021-11-29,CH,Switzerland,EURO,4243,1005151,19,11130
2021-11-30,CH,Switzerland,EURO,11502,1016653,21,11151
2021-12-01,CH,Switzerland,EURO,10000,1026653,27,11178
2021-12-02,CH,Switzerland,EURO,10419,1037072,28,11206
2021-12-03,CH,Switzerland,EURO,10159,1047231,26,11232
2021-12-04,CH,Switzerland,EURO,9806,1057037,23,11255
2021-12-05,CH,Switzerland,EURO,6257,1063294,22,11277
2021-12-06,CH,Switzerland,EURO,4937,1068231,25,11302
2021-12-07,CH,Switzerland,EURO,12662,1080893,34,11336
2021-12-08,CH,Switzerland,EURO,11035,1091928,23,11359
2021-12-09,CH,Switzerland,EURO,9951,1101879,29,11388
2021-12-10,CH,Switzerland,EURO,10421,1112300,28,11416
2021-12-11,CH,Switzerland,EURO,9757,1122057,21,11437
2021-12-12,CH,Switzerland,EURO,6089,1128146,22,11459
2021-12-13,CH,Switzerland,EURO,4393,1132539,28,11487
2021-12-14,CH,Switzerland,EURO,12430,1144969,21,11508
2021-12-15,CH,Switzerland,EURO,10528,1155497,35,11543
2021-12-16,CH,Switzerland,EURO,9532,1165029,33,11576
2021-12-17,CH,Switzerland,EURO,9144,1174173,29,11605
2021-12-18,CH,Switzerland,EURO,8737,1182910,24,11629
2021-12-19,CH,Switzerland,EURO,5876,1188786,21,11650
2021-12-20,CH,Switzerland,EURO,4331,1193117,20,11670
2021-12-21,CH,Switzerland,EURO,11467,1204584,29,11699
2021-12-22,CH,Switzerland,EURO,10776,1215360,20,11719
2021-12-23,CH,Switzerland,EURO,11008,1226368,24,11743
2021-12-24,CH,Switzerland,EURO,11266,1237634,26,11769
2021-12-25,CH,Switzerland,EURO,9630,1247264,11,11780
2021-12-26,CH,Switzerland,EURO,6450,1253714,20,11800
2021-12-27,CH,Switzerland,EURO,7369,1261083,13,11813
2021-12-28,CH,Switzerland,EURO,17421,1278504,17,11830
2021-12-29,CH,Switzerland,EURO,17666,1296170,25,11855
2021-12-30,CH,Switzerland,EURO,18991,1315161,14,11869
2021-12-31,CH,Switzerland,EURO,19741,1334902,22,11891
2022-01-01,CH,Switzerland,EURO,16132,1351034,24,11915
.
159887,159925c
2020-10-17,CH,Switzerland,EURO,3680,80228,10,1893
2020-10-18,CH,Switzerland,EURO,2379,82607,7,1900
2020-10-19,CH,Switzerland,EURO,1784,84391,8,1908
2020-10-20,CH,Switzerland,EURO,5397,89788,17,1925
2020-10-21,CH,Switzerland,EURO,5679,95467,12,1937
2020-10-22,CH,Switzerland,EURO,6456,101923,18,1955
2020-10-23,CH,Switzerland,EURO,6772,108695,25,1980
2020-10-24,CH,Switzerland,EURO,7502,116197,26,2006
2020-10-25,CH,Switzerland,EURO,4662,120859,26,2032
2020-10-26,CH,Switzerland,EURO,3210,124069,22,2054
2020-10-27,CH,Switzerland,EURO,10129,134198,20,2074
2020-10-28,CH,Switzerland,EURO,9746,143944,42,2116
2020-10-29,CH,Switzerland,EURO,9279,153223,44,2160
2020-10-30,CH,Switzerland,EURO,8975,162198,57,2217
2020-10-31,CH,Switzerland,EURO,8943,171141,42,2259
2020-11-01,CH,Switzerland,EURO,5128,176269,61,2320
2020-11-02,CH,Switzerland,EURO,3627,179896,61,2381
2020-11-03,CH,Switzerland,EURO,10517,190413,61,2442
2020-11-04,CH,Switzerland,EURO,9597,200010,80,2522
2020-11-05,CH,Switzerland,EURO,8712,208722,83,2605
2020-11-06,CH,Switzerland,EURO,7826,216548,81,2686
2020-11-07,CH,Switzerland,EURO,7379,223927,94,2780
2020-11-08,CH,Switzerland,EURO,4187,228114,71,2851
2020-11-09,CH,Switzerland,EURO,2979,231093,89,2940
2020-11-10,CH,Switzerland,EURO,8679,239772,87,3027
2020-11-11,CH,Switzerland,EURO,7390,247162,87,3114
2020-11-12,CH,Switzerland,EURO,6359,253521,93,3207
2020-11-13,CH,Switzerland,EURO,5963,259484,108,3315
2020-11-14,CH,Switzerland,EURO,5681,265165,87,3402
2020-11-15,CH,Switzerland,EURO,3204,268369,82,3484
2020-11-16,CH,Switzerland,EURO,2315,270684,85,3569
2020-11-17,CH,Switzerland,EURO,6578,277262,94,3663
2020-11-18,CH,Switzerland,EURO,5419,282681,94,3757
2020-11-19,CH,Switzerland,EURO,4854,287535,108,3865
2020-11-20,CH,Switzerland,EURO,4490,292025,83,3948
2020-11-21,CH,Switzerland,EURO,4328,296353,84,4032
2020-11-22,CH,Switzerland,EURO,2573,298926,82,4114
2020-11-23,CH,Switzerland,EURO,1872,300798,82,4196
2020-11-24,CH,Switzerland,EURO,5434,306232,98,4294
.
158926,159598c
2020-04-10,SE,Sweden,EURO,654,8955,151,1015
2020-04-11,SE,Sweden,EURO,645,9600,86,1101
2020-04-12,SE,Sweden,EURO,454,10054,90,1191
2020-04-13,SE,Sweden,EURO,395,10449,102,1293
2020-04-14,SE,Sweden,EURO,464,10913,97,1390
2020-04-15,SE,Sweden,EURO,437,11350,84,1474
2020-04-16,SE,Sweden,EURO,479,11829,91,1565
2020-04-17,SE,Sweden,EURO,604,12433,115,1680
2020-04-18,SE,Sweden,EURO,623,13056,111,1791
2020-04-19,SE,Sweden,EURO,689,13745,83,1874
2020-04-20,SE,Sweden,EURO,532,14277,86,1960
2020-04-21,SE,Sweden,EURO,388,14665,87,2047
2020-04-22,SE,Sweden,EURO,461,15126,85,2132
2020-04-23,SE,Sweden,EURO,707,15833,62,2194
2020-04-24,SE,Sweden,EURO,723,16556,77,2271
2020-04-25,SE,Sweden,EURO,758,17314,86,2357
2020-04-26,SE,Sweden,EURO,781,18095,89,2446
2020-04-27,SE,Sweden,EURO,473,18568,73,2519
2020-04-28,SE,Sweden,EURO,300,18868,74,2593
2020-04-29,SE,Sweden,EURO,563,19431,74,2667
2020-04-30,SE,Sweden,EURO,742,20173,83,2750
2020-05-01,SE,Sweden,EURO,799,20972,83,2833
2020-05-02,SE,Sweden,EURO,636,21608,78,2911
2020-05-03,SE,Sweden,EURO,532,22140,78,2989
2020-05-04,SE,Sweden,EURO,299,22439,72,3061
2020-05-05,SE,Sweden,EURO,261,22700,75,3136
2020-05-06,SE,Sweden,EURO,477,23177,83,3219
2020-05-07,SE,Sweden,EURO,657,23834,72,3291
2020-05-08,SE,Sweden,EURO,745,24579,73,3364
2020-05-09,SE,Sweden,EURO,785,25364,80,3444
2020-05-10,SE,Sweden,EURO,701,26065,60,3504
2020-05-11,SE,Sweden,EURO,509,26574,68,3572
2020-05-12,SE,Sweden,EURO,279,26853,73,3645
2020-05-13,SE,Sweden,EURO,455,27308,65,3710
2020-05-14,SE,Sweden,EURO,754,28062,61,3771
2020-05-15,SE,Sweden,EURO,698,28760,50,3821
2020-05-16,SE,Sweden,EURO,657,29417,46,3867
2020-05-17,SE,Sweden,EURO,688,30105,58,3925
2020-05-18,SE,Sweden,EURO,358,30463,48,3973
2020-05-19,SE,Sweden,EURO,259,30722,52,4025
2020-05-20,SE,Sweden,EURO,430,31152,59,4084
2020-05-21,SE,Sweden,EURO,666,31818,41,4125
2020-05-22,SE,Sweden,EURO,808,32626,52,4177
2020-05-23,SE,Sweden,EURO,610,33236,53,4230
2020-05-24,SE,Sweden,EURO,532,33768,56,4286
2020-05-25,SE,Sweden,EURO,403,34171,55,4341
2020-05-26,SE,Sweden,EURO,210,34381,44,4385
2020-05-27,SE,Sweden,EURO,490,34871,42,4427
2020-05-28,SE,Sweden,EURO,746,35617,28,4455
2020-05-29,SE,Sweden,EURO,800,36417,38,4493
2020-05-30,SE,Sweden,EURO,774,37191,40,4533
2020-05-31,SE,Sweden,EURO,773,37964,40,4573
2020-06-01,SE,Sweden,EURO,432,38396,38,4611
2020-06-02,SE,Sweden,EURO,265,38661,46,4657
2020-06-03,SE,Sweden,EURO,648,39309,39,4696
2020-06-04,SE,Sweden,EURO,900,40209,36,4732
2020-06-05,SE,Sweden,EURO,1046,41255,28,4760
2020-06-06,SE,Sweden,EURO,1039,42294,44,4804
2020-06-07,SE,Sweden,EURO,1146,43440,37,4841
2020-06-08,SE,Sweden,EURO,780,44220,29,4870
2020-06-09,SE,Sweden,EURO,462,44682,33,4903
2020-06-10,SE,Sweden,EURO,677,45359,38,4941
2020-06-11,SE,Sweden,EURO,937,46296,33,4974
2020-06-12,SE,Sweden,EURO,1437,47733,39,5013
2020-06-13,SE,Sweden,EURO,1293,49026,35,5048
2020-06-14,SE,Sweden,EURO,1329,50355,29,5077
2020-06-15,SE,Sweden,EURO,1032,51387,33,5110
2020-06-16,SE,Sweden,EURO,418,51805,27,5137
2020-06-17,SE,Sweden,EURO,685,52490,30,5167
2020-06-18,SE,Sweden,EURO,1209,53699,28,5195
2020-06-19,SE,Sweden,EURO,1457,55156,32,5227
2020-06-20,SE,Sweden,EURO,1494,56650,29,5256
2020-06-21,SE,Sweden,EURO,1209,57859,30,5286
2020-06-22,SE,Sweden,EURO,698,58557,29,5315
2020-06-23,SE,Sweden,EURO,321,58878,22,5337
2020-06-24,SE,Sweden,EURO,800,59678,20,5357
2020-06-25,SE,Sweden,EURO,1309,60987,25,5382
2020-06-26,SE,Sweden,EURO,1696,62683,22,5404
2020-06-27,SE,Sweden,EURO,1276,63959,23,5427
2020-06-28,SE,Sweden,EURO,1204,65163,11,5438
2020-06-29,SE,Sweden,EURO,755,65918,14,5452
2020-06-30,SE,Sweden,EURO,415,66333,23,5475
2020-07-01,SE,Sweden,EURO,726,67059,16,5491
2020-07-02,SE,Sweden,EURO,808,67867,20,5511
2020-07-03,SE,Sweden,EURO,685,68552,15,5526
2020-07-04,SE,Sweden,EURO,687,69239,15,5541
2020-07-05,SE,Sweden,EURO,694,69933,8,5549
2020-07-06,SE,Sweden,EURO,364,70297,15,5564
2020-07-07,SE,Sweden,EURO,315,70612,9,5573
2020-07-08,SE,Sweden,EURO,251,70863,15,5588
2020-07-09,SE,Sweden,EURO,278,71141,12,5600
2020-07-10,SE,Sweden,EURO,533,71674,10,5610
2020-07-11,SE,Sweden,EURO,334,72008,15,5625
2020-07-12,SE,Sweden,EURO,369,72377,14,5639
2020-07-13,SE,Sweden,EURO,308,72685,10,5649
2020-07-14,SE,Sweden,EURO,106,72791,8,5657
2020-07-15,SE,Sweden,EURO,170,72961,12,5669
2020-07-16,SE,Sweden,EURO,312,73273,8,5677
2020-07-17,SE,Sweden,EURO,287,73560,6,5683
2020-07-18,SE,Sweden,EURO,268,73828,6,5689
2020-07-19,SE,Sweden,EURO,284,74112,7,5696
2020-07-20,SE,Sweden,EURO,191,74303,11,5707
2020-07-21,SE,Sweden,EURO,110,74413,7,5714
2020-07-22,SE,Sweden,EURO,131,74544,6,5720
2020-07-23,SE,Sweden,EURO,226,74770,7,5727
2020-07-24,SE,Sweden,EURO,297,75067,6,5733
2020-07-25,SE,Sweden,EURO,220,75287,5,5738
2020-07-26,SE,Sweden,EURO,262,75549,3,5741
2020-07-27,SE,Sweden,EURO,138,75687,1,5742
2020-07-28,SE,Sweden,EURO,42,75729,2,5744
2020-07-29,SE,Sweden,EURO,71,75800,6,5750
2020-07-30,SE,Sweden,EURO,283,76083,4,5754
2020-07-31,SE,Sweden,EURO,301,76384,1,5755
2020-08-01,SE,Sweden,EURO,302,76686,0,5755
2020-08-02,SE,Sweden,EURO,258,76944,2,5757
2020-08-03,SE,Sweden,EURO,303,77247,2,5759
2020-08-04,SE,Sweden,EURO,38,77285,3,5762
2020-08-05,SE,Sweden,EURO,165,77450,4,5766
2020-08-06,SE,Sweden,EURO,333,77783,2,5768
2020-08-07,SE,Sweden,EURO,425,78208,1,5769
2020-08-08,SE,Sweden,EURO,378,78586,4,5773
2020-08-09,SE,Sweden,EURO,380,78966,2,5775
2020-08-10,SE,Sweden,EURO,260,79226,1,5776
2020-08-11,SE,Sweden,EURO,73,79299,4,5780
2020-08-12,SE,Sweden,EURO,196,79495,2,5782
2020-08-13,SE,Sweden,EURO,417,79912,4,5786
2020-08-14,SE,Sweden,EURO,443,80355,3,5789
2020-08-15,SE,Sweden,EURO,363,80718,5,5794
2020-08-16,SE,Sweden,EURO,344,81062,1,5795
2020-08-17,SE,Sweden,EURO,226,81288,1,5796
2020-08-18,SE,Sweden,EURO,63,81351,0,5796
2020-08-19,SE,Sweden,EURO,174,81525,3,5799
2020-08-20,SE,Sweden,EURO,314,81839,4,5803
2020-08-21,SE,Sweden,EURO,351,82190,1,5804
2020-08-22,SE,Sweden,EURO,333,82523,2,5806
2020-08-23,SE,Sweden,EURO,298,82821,5,5811
2020-08-24,SE,Sweden,EURO,160,82981,1,5812
2020-08-25,SE,Sweden,EURO,57,83038,3,5815
2020-08-26,SE,Sweden,EURO,174,83212,1,5816
2020-08-27,SE,Sweden,EURO,222,83434,1,5817
2020-08-28,SE,Sweden,EURO,244,83678,2,5819
2020-08-29,SE,Sweden,EURO,202,83880,1,5820
2020-08-30,SE,Sweden,EURO,179,84059,1,5821
2020-08-31,SE,Sweden,EURO,131,84190,1,5822
2020-09-01,SE,Sweden,EURO,48,84238,3,5825
2020-09-02,SE,Sweden,EURO,162,84400,2,5827
2020-09-03,SE,Sweden,EURO,171,84571,3,5830
2020-09-04,SE,Sweden,EURO,213,84784,2,5832
2020-09-05,SE,Sweden,EURO,286,85070,2,5834
2020-09-06,SE,Sweden,EURO,262,85332,0,5834
2020-09-07,SE,Sweden,EURO,171,85503,0,5834
2020-09-08,SE,Sweden,EURO,67,85570,3,5837
2020-09-09,SE,Sweden,EURO,185,85755,1,5838
2020-09-10,SE,Sweden,EURO,236,85991,1,5839
2020-09-11,SE,Sweden,EURO,314,86305,2,5841
2020-09-12,SE,Sweden,EURO,254,86559,2,5843
2020-09-13,SE,Sweden,EURO,291,86850,4,5847
2020-09-14,SE,Sweden,EURO,206,87056,1,5848
2020-09-15,SE,Sweden,EURO,106,87162,2,5850
2020-09-16,SE,Sweden,EURO,220,87382,2,5852
2020-09-17,SE,Sweden,EURO,292,87674,1,5853
2020-09-18,SE,Sweden,EURO,330,88004,2,5855
2020-09-19,SE,Sweden,EURO,389,88393,1,5856
2020-09-20,SE,Sweden,EURO,437,88830,1,5857
2020-09-21,SE,Sweden,EURO,279,89109,1,5858
2020-09-22,SE,Sweden,EURO,133,89242,4,5862
2020-09-23,SE,Sweden,EURO,266,89508,2,5864
2020-09-24,SE,Sweden,EURO,438,89946,1,5865
2020-09-25,SE,Sweden,EURO,553,90499,0,5865
2020-09-26,SE,Sweden,EURO,540,91039,1,5866
2020-09-27,SE,Sweden,EURO,630,91669,4,5870
2020-09-28,SE,Sweden,EURO,325,91994,2,5872
2020-09-29,SE,Sweden,EURO,167,92161,1,5873
2020-09-30,SE,Sweden,EURO,378,92539,1,5874
2020-10-01,SE,Sweden,EURO,613,93152,2,5876
2020-10-02,SE,Sweden,EURO,689,93841,4,5880
2020-10-03,SE,Sweden,EURO,633,94474,1,5881
2020-10-04,SE,Sweden,EURO,712,95186,3,5884
2020-10-05,SE,Sweden,EURO,461,95647,3,5887
2020-10-06,SE,Sweden,EURO,156,95803,3,5890
2020-10-07,SE,Sweden,EURO,374,96177,2,5892
2020-10-08,SE,Sweden,EURO,786,96963,4,5896
2020-10-09,SE,Sweden,EURO,831,97794,3,5899
2020-10-10,SE,Sweden,EURO,834,98628,1,5900
2020-10-11,SE,Sweden,EURO,783,99411,5,5905
2020-10-12,SE,Sweden,EURO,509,99920,5,5910
2020-10-13,SE,Sweden,EURO,161,100081,2,5912
2020-10-14,SE,Sweden,EURO,637,100718,3,5915
2020-10-15,SE,Sweden,EURO,916,101634,1,5916
2020-10-16,SE,Sweden,EURO,968,102602,2,5918
2020-10-17,SE,Sweden,EURO,902,103504,3,5921
2020-10-18,SE,Sweden,EURO,1179,104683,2,5923
2020-10-19,SE,Sweden,EURO,697,105380,4,5927
2020-10-20,SE,Sweden,EURO,321,105701,1,5928
2020-10-21,SE,Sweden,EURO,771,106472,4,5932
2020-10-22,SE,Sweden,EURO,1289,107761,4,5936
2020-10-23,SE,Sweden,EURO,1571,109332,3,5939
2020-10-24,SE,Sweden,EURO,1666,110998,9,5948
2020-10-25,SE,Sweden,EURO,1867,112865,7,5955
2020-10-26,SE,Sweden,EURO,1477,114342,8,5963
2020-10-27,SE,Sweden,EURO,514,114856,8,5971
2020-10-28,SE,Sweden,EURO,1069,115925,11,5982
2020-10-29,SE,Sweden,EURO,2414,118339,9,5991
2020-10-30,SE,Sweden,EURO,3389,121728,9,6000
2020-10-31,SE,Sweden,EURO,3262,124990,9,6009
2020-11-01,SE,Sweden,EURO,4056,129046,9,6018
2020-11-02,SE,Sweden,EURO,2987,132033,13,6031
2020-11-03,SE,Sweden,EURO,1297,133330,22,6053
2020-11-04,SE,Sweden,EURO,1569,134899,20,6073
2020-11-05,SE,Sweden,EURO,3608,138507,20,6093
2020-11-06,SE,Sweden,EURO,4482,142989,21,6114
2020-11-07,SE,Sweden,EURO,4744,147733,22,6136
2020-11-08,SE,Sweden,EURO,4454,152187,25,6161
2020-11-09,SE,Sweden,EURO,4451,156638,27,6188
2020-11-10,SE,Sweden,EURO,2097,158735,22,6210
2020-11-11,SE,Sweden,EURO,3725,162460,35,6245
2020-11-12,SE,Sweden,EURO,4497,166957,35,6280
2020-11-13,SE,Sweden,EURO,5709,172666,27,6307
2020-11-14,SE,Sweden,EURO,5564,178230,28,6335
2020-11-15,SE,Sweden,EURO,6730,184960,33,6368
2020-11-16,SE,Sweden,EURO,3513,188473,38,6406
2020-11-17,SE,Sweden,EURO,1581,190054,39,6445
2020-11-18,SE,Sweden,EURO,2544,192598,37,6482
2020-11-19,SE,Sweden,EURO,4458,197056,44,6526
2020-11-20,SE,Sweden,EURO,4961,202017,50,6576
2020-11-21,SE,Sweden,EURO,7609,209626,46,6622
2020-11-22,SE,Sweden,EURO,5458,215084,45,6667
2020-11-23,SE,Sweden,EURO,4492,219576,51,6718
2020-11-24,SE,Sweden,EURO,2422,221998,59,6777
2020-11-25,SE,Sweden,EURO,3877,225875,55,6832
2020-11-26,SE,Sweden,EURO,5674,231549,68,6900
2020-11-27,SE,Sweden,EURO,6066,237615,69,6969
2020-11-28,SE,Sweden,EURO,6903,244518,60,7029
2020-11-29,SE,Sweden,EURO,6462,250980,65,7094
2020-11-30,SE,Sweden,EURO,3825,254805,50,7144
2020-12-01,SE,Sweden,EURO,2753,257558,50,7194
2020-12-02,SE,Sweden,EURO,3480,261038,67,7261
2020-12-03,SE,Sweden,EURO,5819,266857,67,7328
2020-12-04,SE,Sweden,EURO,6547,273404,71,7399
2020-12-05,SE,Sweden,EURO,6986,280390,77,7476
2020-12-06,SE,Sweden,EURO,7338,287728,70,7546
2020-12-07,SE,Sweden,EURO,4864,292592,43,7589
2020-12-08,SE,Sweden,EURO,1803,294395,81,7670
2020-12-09,SE,Sweden,EURO,3782,298177,58,7728
2020-12-10,SE,Sweden,EURO,7446,305623,54,7782
2020-12-11,SE,Sweden,EURO,8398,314021,75,7857
2020-12-12,SE,Sweden,EURO,6693,320714,86,7943
2020-12-13,SE,Sweden,EURO,7717,328431,89,8032
2020-12-14,SE,Sweden,EURO,6538,334969,68,8100
2020-12-15,SE,Sweden,EURO,3057,338026,71,8171
2020-12-16,SE,Sweden,EURO,3534,341560,94,8265
2020-12-17,SE,Sweden,EURO,7001,348561,88,8353
2020-12-18,SE,Sweden,EURO,8824,357385,102,8455
2020-12-19,SE,Sweden,EURO,9640,367025,116,8571
2020-12-20,SE,Sweden,EURO,7917,374942,71,8642
2020-12-21,SE,Sweden,EURO,5509,380451,80,8722
2020-12-22,SE,Sweden,EURO,3752,384203,94,8816
2020-12-23,SE,Sweden,EURO,5160,389363,76,8892
2020-12-24,SE,Sweden,EURO,6595,395958,93,8985
2020-12-25,SE,Sweden,EURO,11376,407334,87,9072
2020-12-26,SE,Sweden,EURO,5036,412370,88,9160
2020-12-27,SE,Sweden,EURO,2793,415163,106,9266
2020-12-28,SE,Sweden,EURO,2966,418129,94,9360
2020-12-29,SE,Sweden,EURO,3208,421337,99,9459
2020-12-30,SE,Sweden,EURO,7091,428428,121,9580
2020-12-31,SE,Sweden,EURO,8872,437300,73,9653
2021-01-01,SE,Sweden,EURO,10459,447759,90,9743
2021-01-02,SE,Sweden,EURO,6999,454758,110,9853
2021-01-03,SE,Sweden,EURO,2618,457376,87,9940
2021-01-04,SE,Sweden,EURO,2530,459906,99,10039
2021-01-05,SE,Sweden,EURO,2754,462660,83,10122
2021-01-06,SE,Sweden,EURO,6983,469643,86,10208
2021-01-07,SE,Sweden,EURO,7546,477189,93,10301
2021-01-08,SE,Sweden,EURO,5029,482218,82,10383
2021-01-09,SE,Sweden,EURO,7149,489367,103,10486
2021-01-10,SE,Sweden,EURO,5692,495059,99,10585
2021-01-11,SE,Sweden,EURO,4736,499795,89,10674
2021-01-12,SE,Sweden,EURO,2317,502112,92,10766
2021-01-13,SE,Sweden,EURO,4648,506760,89,10855
2021-01-14,SE,Sweden,EURO,5338,512098,89,10944
2021-01-15,SE,Sweden,EURO,6595,518693,91,11035
2021-01-16,SE,Sweden,EURO,4743,523436,95,11130
2021-01-17,SE,Sweden,EURO,4205,527641,90,11220
2021-01-18,SE,Sweden,EURO,2160,529801,83,11303
2021-01-19,SE,Sweden,EURO,1250,531051,61,11364
2021-01-20,SE,Sweden,EURO,2112,533163,72,11436
2021-01-21,SE,Sweden,EURO,4732,537895,92,11528
2021-01-22,SE,Sweden,EURO,4947,542842,87,11615
2021-01-23,SE,Sweden,EURO,4198,547040,88,11703
2021-01-24,SE,Sweden,EURO,3722,550762,59,11762
2021-01-25,SE,Sweden,EURO,2368,553130,64,11826
2021-01-26,SE,Sweden,EURO,1147,554277,51,11877
2021-01-27,SE,Sweden,EURO,1884,556161,59,11936
2021-01-28,SE,Sweden,EURO,4186,560347,67,12003
2021-01-29,SE,Sweden,EURO,4106,564453,54,12057
2021-01-30,SE,Sweden,EURO,2368,566821,55,12112
2021-01-31,SE,Sweden,EURO,4252,571073,58,12170
2021-02-01,SE,Sweden,EURO,2695,573768,57,12227
2021-02-02,SE,Sweden,EURO,1164,574932,39,12266
2021-02-03,SE,Sweden,EURO,1552,576484,46,12312
2021-02-04,SE,Sweden,EURO,4315,580799,43,12355
2021-02-05,SE,Sweden,EURO,3737,584536,52,12407
2021-02-06,SE,Sweden,EURO,3396,587932,30,12437
2021-02-07,SE,Sweden,EURO,3260,591192,36,12473
2021-02-08,SE,Sweden,EURO,2333,593525,33,12506
2021-02-09,SE,Sweden,EURO,1013,594538,29,12535
2021-02-10,SE,Sweden,EURO,1505,596043,39,12574
2021-02-11,SE,Sweden,EURO,4069,600112,25,12599
2021-02-12,SE,Sweden,EURO,4353,604465,27,12626
2021-02-13,SE,Sweden,EURO,3805,608270,33,12659
2021-02-14,SE,Sweden,EURO,3569,611839,28,12687
2021-02-15,SE,Sweden,EURO,2771,614610,25,12712
2021-02-16,SE,Sweden,EURO,1211,615821,28,12740
2021-02-17,SE,Sweden,EURO,1902,617723,23,12763
2021-02-18,SE,Sweden,EURO,4206,621929,22,12785
2021-02-19,SE,Sweden,EURO,4965,626894,34,12819
2021-02-20,SE,Sweden,EURO,4134,631028,18,12837
2021-02-21,SE,Sweden,EURO,4028,635056,25,12862
2021-02-22,SE,Sweden,EURO,2781,637837,29,12891
2021-02-23,SE,Sweden,EURO,1599,639436,21,12912
2021-02-24,SE,Sweden,EURO,2542,641978,25,12937
2021-02-25,SE,Sweden,EURO,5407,647385,13,12950
2021-02-26,SE,Sweden,EURO,4977,652362,26,12976
2021-02-27,SE,Sweden,EURO,4831,657193,20,12996
2021-02-28,SE,Sweden,EURO,4583,661776,18,13014
2021-03-01,SE,Sweden,EURO,3107,664883,19,13033
2021-03-02,SE,Sweden,EURO,1242,666125,25,13058
2021-03-03,SE,Sweden,EURO,2827,668952,24,13082
2021-03-04,SE,Sweden,EURO,6189,675141,23,13105
2021-03-05,SE,Sweden,EURO,4871,680012,19,13124
2021-03-06,SE,Sweden,EURO,4883,684895,19,13143
2021-03-07,SE,Sweden,EURO,4069,688964,15,13158
2021-03-08,SE,Sweden,EURO,3454,692418,12,13170
2021-03-09,SE,Sweden,EURO,1451,693869,17,13187
2021-03-10,SE,Sweden,EURO,1982,695851,24,13211
2021-03-11,SE,Sweden,EURO,5928,701779,20,13231
2021-03-12,SE,Sweden,EURO,5328,707107,21,13252
2021-03-13,SE,Sweden,EURO,5332,712439,16,13268
2021-03-14,SE,Sweden,EURO,4995,717434,19,13287
2021-03-15,SE,Sweden,EURO,3953,721387,19,13306
2021-03-16,SE,Sweden,EURO,1040,722427,22,13328
2021-03-17,SE,Sweden,EURO,2715,725142,21,13349
2021-03-18,SE,Sweden,EURO,6787,731929,16,13365
2021-03-19,SE,Sweden,EURO,6431,738360,19,13384
2021-03-20,SE,Sweden,EURO,5736,744096,18,13402
2021-03-21,SE,Sweden,EURO,5406,749502,11,13413
2021-03-22,SE,Sweden,EURO,4380,753882,25,13438
2021-03-23,SE,Sweden,EURO,1579,755461,18,13456
2021-03-24,SE,Sweden,EURO,2687,758148,16,13472
2021-03-25,SE,Sweden,EURO,7652,765800,14,13486
2021-03-26,SE,Sweden,EURO,7706,773506,16,13502
2021-03-27,SE,Sweden,EURO,6365,779871,22,13524
2021-03-28,SE,Sweden,EURO,6294,786165,22,13546
2021-03-29,SE,Sweden,EURO,5196,791361,19,13565
2021-03-30,SE,Sweden,EURO,1980,793341,17,13582
2021-03-31,SE,Sweden,EURO,2962,796303,23,13605
2021-04-01,SE,Sweden,EURO,8468,804771,16,13621
2021-04-02,SE,Sweden,EURO,8292,813063,24,13645
2021-04-03,SE,Sweden,EURO,6976,820039,25,13670
2021-04-04,SE,Sweden,EURO,6837,826876,22,13692
2021-04-05,SE,Sweden,EURO,3403,830279,18,13710
2021-04-06,SE,Sweden,EURO,1449,831728,14,13724
2021-04-07,SE,Sweden,EURO,3103,834831,24,13748
2021-04-08,SE,Sweden,EURO,6813,841644,13,13761
2021-04-09,SE,Sweden,EURO,7824,849468,22,13783
2021-04-10,SE,Sweden,EURO,7760,857228,22,13805
2021-04-11,SE,Sweden,EURO,7629,864857,24,13829
2021-04-12,SE,Sweden,EURO,5626,870483,11,13840
2021-04-13,SE,Sweden,EURO,2390,872873,17,13857
2021-04-14,SE,Sweden,EURO,3472,876345,16,13873
2021-04-15,SE,Sweden,EURO,8870,885215,21,13894
2021-04-16,SE,Sweden,EURO,7093,892308,28,13922
2021-04-17,SE,Sweden,EURO,7665,899973,25,13947
2021-04-18,SE,Sweden,EURO,6440,906413,15,13962
2021-04-19,SE,Sweden,EURO,4983,911396,20,13982
2021-04-20,SE,Sweden,EURO,2514,913910,16,13998
2021-04-21,SE,Sweden,EURO,2713,916623,15,14013
2021-04-22,SE,Sweden,EURO,7538,924161,26,14039
2021-04-23,SE,Sweden,EURO,7706,931867,24,14063
2021-04-24,SE,Sweden,EURO,6250,938117,16,14079
2021-04-25,SE,Sweden,EURO,5501,943618,17,14096
2021-04-26,SE,Sweden,EURO,4568,948186,13,14109
2021-04-27,SE,Sweden,EURO,1756,949942,20,14129
2021-04-28,SE,Sweden,EURO,3069,953011,11,14140
2021-04-29,SE,Sweden,EURO,7267,960278,23,14163
2021-04-30,SE,Sweden,EURO,7144,967422,21,14184
2021-05-01,SE,Sweden,EURO,5931,973353,19,14203
2021-05-02,SE,Sweden,EURO,5424,978777,17,14220
2021-05-03,SE,Sweden,EURO,4753,983530,12,14232
2021-05-04,SE,Sweden,EURO,1718,985248,12,14244
2021-05-05,SE,Sweden,EURO,3069,988317,19,14263
2021-05-06,SE,Sweden,EURO,7035,995352,13,14276
2021-05-07,SE,Sweden,EURO,6482,1001834,17,14293
2021-05-08,SE,Sweden,EURO,5716,1007550,10,14303
2021-05-09,SE,Sweden,EURO,5245,1012795,13,14316
2021-05-10,SE,Sweden,EURO,4476,1017271,19,14335
2021-05-11,SE,Sweden,EURO,1657,1018928,16,14351
2021-05-12,SE,Sweden,EURO,2460,1021388,22,14373
2021-05-13,SE,Sweden,EURO,6311,1027699,10,14383
2021-05-14,SE,Sweden,EURO,5269,1032968,11,14394
2021-05-15,SE,Sweden,EURO,3918,1036886,19,14413
2021-05-16,SE,Sweden,EURO,2579,1039465,24,14437
2021-05-17,SE,Sweden,EURO,3969,1043434,12,14449
2021-05-18,SE,Sweden,EURO,1408,1044842,13,14462
2021-05-19,SE,Sweden,EURO,2106,1046948,9,14471
2021-05-20,SE,Sweden,EURO,4642,1051590,9,14480
2021-05-21,SE,Sweden,EURO,3410,1055000,7,14487
2021-05-22,SE,Sweden,EURO,3166,1058166,12,14499
2021-05-23,SE,Sweden,EURO,2317,1060483,12,14511
2021-05-24,SE,Sweden,EURO,1909,1062392,10,14521
2021-05-25,SE,Sweden,EURO,620,1063012,11,14532
2021-05-26,SE,Sweden,EURO,1195,1064207,4,14536
2021-05-27,SE,Sweden,EURO,2739,1066946,8,14544
2021-05-28,SE,Sweden,EURO,1418,1068364,9,14553
2021-05-29,SE,Sweden,EURO,92,1068456,7,14560
2021-05-30,SE,Sweden,EURO,297,1068753,8,14568
2021-05-31,SE,Sweden,EURO,285,1069038,3,14571
2021-06-01,SE,Sweden,EURO,1948,1070986,8,14579
2021-06-02,SE,Sweden,EURO,1898,1072884,6,14585
2021-06-03,SE,Sweden,EURO,2783,1075667,1,14586
2021-06-04,SE,Sweden,EURO,1364,1077031,6,14592
2021-06-05,SE,Sweden,EURO,1080,1078111,6,14598
2021-06-06,SE,Sweden,EURO,989,1079100,14,14612
2021-06-07,SE,Sweden,EURO,758,1079858,3,14615
2021-06-08,SE,Sweden,EURO,222,1080080,3,14618
2021-06-09,SE,Sweden,EURO,490,1080570,5,14623
2021-06-10,SE,Sweden,EURO,1183,1081753,4,14627
2021-06-11,SE,Sweden,EURO,825,1082578,7,14634
2021-06-12,SE,Sweden,EURO,729,1083307,3,14637
2021-06-13,SE,Sweden,EURO,484,1083791,1,14638
2021-06-14,SE,Sweden,EURO,524,1084315,2,14640
2021-06-15,SE,Sweden,EURO,159,1084474,0,14640
2021-06-16,SE,Sweden,EURO,0,1084474,4,14644
2021-06-17,SE,Sweden,EURO,1,1084475,2,14646
2021-06-18,SE,Sweden,EURO,36,1084511,2,14648
2021-06-19,SE,Sweden,EURO,2190,1086701,1,14649
2021-06-20,SE,Sweden,EURO,601,1087302,3,14652
2021-06-21,SE,Sweden,EURO,19,1087321,2,14654
2021-06-22,SE,Sweden,EURO,1,1087322,3,14657
2021-06-23,SE,Sweden,EURO,678,1088000,2,14659
2021-06-24,SE,Sweden,EURO,506,1088506,3,14662
2021-06-25,SE,Sweden,EURO,379,1088885,0,14662
2021-06-26,SE,Sweden,EURO,373,1089258,2,14664
2021-06-27,SE,Sweden,EURO,31,1089289,2,14666
2021-06-28,SE,Sweden,EURO,8,1089297,0,14666
2021-06-29,SE,Sweden,EURO,8,1089305,0,14666
2021-06-30,SE,Sweden,EURO,444,1089749,2,14668
2021-07-01,SE,Sweden,EURO,251,1090000,1,14669
2021-07-02,SE,Sweden,EURO,560,1090560,1,14670
2021-07-03,SE,Sweden,EURO,284,1090844,1,14671
2021-07-04,SE,Sweden,EURO,326,1091170,1,14672
2021-07-05,SE,Sweden,EURO,3,1091173,2,14674
2021-07-06,SE,Sweden,EURO,2,1091175,0,14674
2021-07-07,SE,Sweden,EURO,415,1091590,0,14674
2021-07-08,SE,Sweden,EURO,369,1091959,2,14676
2021-07-09,SE,Sweden,EURO,258,1092217,0,14676
2021-07-10,SE,Sweden,EURO,237,1092454,0,14676
2021-07-11,SE,Sweden,EURO,228,1092682,0,14676
2021-07-12,SE,Sweden,EURO,7,1092689,0,14676
2021-07-13,SE,Sweden,EURO,0,1092689,1,14677
2021-07-14,SE,Sweden,EURO,443,1093132,0,14677
2021-07-15,SE,Sweden,EURO,370,1093502,0,14677
2021-07-16,SE,Sweden,EURO,350,1093852,0,14677
2021-07-17,SE,Sweden,EURO,366,1094218,1,14678
2021-07-18,SE,Sweden,EURO,337,1094555,0,14678
2021-07-19,SE,Sweden,EURO,11,1094566,1,14679
2021-07-20,SE,Sweden,EURO,6,1094572,0,14679
2021-07-21,SE,Sweden,EURO,628,1095200,0,14679
2021-07-22,SE,Sweden,EURO,517,1095717,0,14679
2021-07-23,SE,Sweden,EURO,582,1096299,1,14680
2021-07-24,SE,Sweden,EURO,477,1096776,1,14681
2021-07-25,SE,Sweden,EURO,444,1097220,1,14682
2021-07-26,SE,Sweden,EURO,11,1097231,0,14682
2021-07-27,SE,Sweden,EURO,2,1097233,0,14682
2021-07-28,SE,Sweden,EURO,839,1098072,0,14682
2021-07-29,SE,Sweden,EURO,653,1098725,0,14682
2021-07-30,SE,Sweden,EURO,656,1099381,1,14683
2021-07-31,SE,Sweden,EURO,621,1100002,2,14685
2021-08-01,SE,Sweden,EURO,686,1100688,1,14686
2021-08-02,SE,Sweden,EURO,4,1100692,0,14686
2021-08-03,SE,Sweden,EURO,1,1100693,0,14686
2021-08-04,SE,Sweden,EURO,1151,1101844,0,14686
2021-08-05,SE,Sweden,EURO,959,1102803,0,14686
2021-08-06,SE,Sweden,EURO,852,1103655,0,14686
2021-08-07,SE,Sweden,EURO,819,1104474,2,14688
2021-08-08,SE,Sweden,EURO,818,1105292,3,14691
2021-08-09,SE,Sweden,EURO,6,1105298,0,14691
2021-08-10,SE,Sweden,EURO,3,1105301,2,14693
2021-08-11,SE,Sweden,EURO,1485,1106786,0,14693
2021-08-12,SE,Sweden,EURO,1201,1107987,1,14694
2021-08-13,SE,Sweden,EURO,1057,1109044,0,14694
2021-08-14,SE,Sweden,EURO,1040,1110084,1,14695
2021-08-15,SE,Sweden,EURO,1016,1111100,2,14697
2021-08-16,SE,Sweden,EURO,8,1111108,1,14698
2021-08-17,SE,Sweden,EURO,10,1111118,1,14699
2021-08-18,SE,Sweden,EURO,1781,1112899,0,14699
2021-08-19,SE,Sweden,EURO,1330,1114229,3,14702
2021-08-20,SE,Sweden,EURO,1275,1115504,1,14703
2021-08-21,SE,Sweden,EURO,1028,1116532,2,14705
2021-08-22,SE,Sweden,EURO,1047,1117579,2,14707
2021-08-23,SE,Sweden,EURO,1,1117580,1,14708
2021-08-24,SE,Sweden,EURO,3,1117583,2,14710
2021-08-25,SE,Sweden,EURO,1708,1119291,5,14715
2021-08-26,SE,Sweden,EURO,1270,1120561,5,14720
2021-08-27,SE,Sweden,EURO,1515,1122076,3,14723
2021-08-28,SE,Sweden,EURO,1271,1123347,1,14724
2021-08-29,SE,Sweden,EURO,917,1124264,0,14724
2021-08-30,SE,Sweden,EURO,3,1124267,1,14725
2021-08-31,SE,Sweden,EURO,5,1124272,5,14730
2021-09-01,SE,Sweden,EURO,2354,1126626,3,14733
2021-09-02,SE,Sweden,EURO,1022,1127648,2,14735
2021-09-03,SE,Sweden,EURO,1103,1128751,2,14737
2021-09-04,SE,Sweden,EURO,1425,1130176,6,14743
2021-09-05,SE,Sweden,EURO,1323,1131499,3,14746
2021-09-06,SE,Sweden,EURO,1,1131500,3,14749
2021-09-07,SE,Sweden,EURO,10,1131510,6,14755
2021-09-08,SE,Sweden,EURO,2179,1133689,4,14759
2021-09-09,SE,Sweden,EURO,1399,1135088,4,14763
2021-09-10,SE,Sweden,EURO,1395,1136483,10,14773
2021-09-11,SE,Sweden,EURO,1479,1137962,8,14781
2021-09-12,SE,Sweden,EURO,1515,1139477,11,14792
2021-09-13,SE,Sweden,EURO,2,1139479,4,14796
2021-09-14,SE,Sweden,EURO,0,1139479,8,14804
2021-09-15,SE,Sweden,EURO,2137,1141616,8,14812
2021-09-16,SE,Sweden,EURO,1114,1142730,7,14819
2021-09-17,SE,Sweden,EURO,1184,1143914,8,14827
2021-09-18,SE,Sweden,EURO,994,1144908,12,14839
2021-09-19,SE,Sweden,EURO,830,1145738,7,14846
2021-09-20,SE,Sweden,EURO,1,1145739,3,14849
2021-09-21,SE,Sweden,EURO,0,1145739,6,14855
2021-09-22,SE,Sweden,EURO,1178,1146917,4,14859
2021-09-23,SE,Sweden,EURO,891,1147808,7,14866
2021-09-24,SE,Sweden,EURO,742,1148550,10,14876
2021-09-25,SE,Sweden,EURO,771,1149321,6,14882
2021-09-26,SE,Sweden,EURO,715,1150036,6,14888
2021-09-27,SE,Sweden,EURO,1,1150037,4,14892
2021-09-28,SE,Sweden,EURO,6,1150043,6,14898
2021-09-29,SE,Sweden,EURO,1069,1151112,3,14901
2021-09-30,SE,Sweden,EURO,845,1151957,4,14905
2021-10-01,SE,Sweden,EURO,852,1152809,7,14912
2021-10-02,SE,Sweden,EURO,766,1153575,5,14917
2021-10-03,SE,Sweden,EURO,698,1154273,5,14922
2021-10-04,SE,Sweden,EURO,2,1154275,6,14928
2021-10-05,SE,Sweden,EURO,0,1154275,9,14937
2021-10-06,SE,Sweden,EURO,1192,1155467,5,14942
2021-10-07,SE,Sweden,EURO,738,1156205,6,14948
2021-10-08,SE,Sweden,EURO,842,1157047,11,14959
2021-10-09,SE,Sweden,EURO,741,1157788,8,14967
2021-10-10,SE,Sweden,EURO,599,1158387,8,14975
2021-10-11,SE,Sweden,EURO,16,1158403,6,14981
2021-10-12,SE,Sweden,EURO,9,1158412,5,14986
2021-10-13,SE,Sweden,EURO,1121,1159533,5,14991
2021-10-14,SE,Sweden,EURO,905,1160438,4,14995
2021-10-15,SE,Sweden,EURO,796,1161234,7,15002
2021-10-16,SE,Sweden,EURO,668,1161902,4,15006
2021-10-17,SE,Sweden,EURO,565,1162467,1,15007
2021-10-18,SE,Sweden,EURO,14,1162481,6,15013
2021-10-19,SE,Sweden,EURO,0,1162481,5,15018
2021-10-20,SE,Sweden,EURO,1078,1163559,6,15024
2021-10-21,SE,Sweden,EURO,818,1164377,3,15027
2021-10-22,SE,Sweden,EURO,786,1165163,3,15030
2021-10-23,SE,Sweden,EURO,777,1165940,4,15034
2021-10-24,SE,Sweden,EURO,891,1166831,3,15037
2021-10-25,SE,Sweden,EURO,525,1167356,3,15040
2021-10-26,SE,Sweden,EURO,319,1167675,1,15041
2021-10-27,SE,Sweden,EURO,540,1168215,6,15047
2021-10-28,SE,Sweden,EURO,1262,1169477,4,15051
2021-10-29,SE,Sweden,EURO,891,1170368,4,15055
2021-10-30,SE,Sweden,EURO,1079,1171447,6,15061
2021-10-31,SE,Sweden,EURO,977,1172424,4,15065
2021-11-01,SE,Sweden,EURO,861,1173285,2,15067
2021-11-02,SE,Sweden,EURO,301,1173586,4,15071
2021-11-03,SE,Sweden,EURO,629,1174215,2,15073
2021-11-04,SE,Sweden,EURO,1162,1175377,5,15078
2021-11-05,SE,Sweden,EURO,837,1176214,10,15088
2021-11-06,SE,Sweden,EURO,826,1177040,2,15090
2021-11-07,SE,Sweden,EURO,731,1177771,4,15094
2021-11-08,SE,Sweden,EURO,597,1178368,7,15101
2021-11-09,SE,Sweden,EURO,278,1178646,3,15104
2021-11-10,SE,Sweden,EURO,502,1179148,2,15106
2021-11-11,SE,Sweden,EURO,1321,1180469,8,15114
2021-11-12,SE,Sweden,EURO,1020,1181489,2,15116
2021-11-13,SE,Sweden,EURO,925,1182414,8,15124
2021-11-14,SE,Sweden,EURO,911,1183325,6,15130
2021-11-15,SE,Sweden,EURO,829,1184154,2,15132
2021-11-16,SE,Sweden,EURO,311,1184465,3,15135
2021-11-17,SE,Sweden,EURO,574,1185039,6,15141
2021-11-18,SE,Sweden,EURO,1296,1186335,5,15146
2021-11-19,SE,Sweden,EURO,1206,1187541,4,15150
2021-11-20,SE,Sweden,EURO,1130,1188671,4,15154
2021-11-21,SE,Sweden,EURO,1314,1189985,6,15160
2021-11-22,SE,Sweden,EURO,1092,1191077,2,15162
2021-11-23,SE,Sweden,EURO,482,1191559,3,15165
2021-11-24,SE,Sweden,EURO,952,1192511,3,15168
2021-11-25,SE,Sweden,EURO,2077,1194588,4,15172
2021-11-26,SE,Sweden,EURO,2107,1196695,2,15174
2021-11-27,SE,Sweden,EURO,2114,1198809,0,15174
2021-11-28,SE,Sweden,EURO,2025,1200834,2,15176
2021-11-29,SE,Sweden,EURO,1759,1202593,2,15178
2021-11-30,SE,Sweden,EURO,880,1203473,2,15180
2021-12-01,SE,Sweden,EURO,1347,1204820,6,15186
2021-12-02,SE,Sweden,EURO,2657,1207477,5,15191
2021-12-03,SE,Sweden,EURO,2424,1209901,2,15193
2021-12-04,SE,Sweden,EURO,2208,1212109,4,15197
2021-12-05,SE,Sweden,EURO,2154,1214263,2,15199
2021-12-06,SE,Sweden,EURO,2084,1216347,4,15203
2021-12-07,SE,Sweden,EURO,927,1217274,6,15209
2021-12-08,SE,Sweden,EURO,2254,1219528,5,15214
2021-12-09,SE,Sweden,EURO,3333,1222861,8,15222
2021-12-10,SE,Sweden,EURO,3255,1226116,5,15227
2021-12-11,SE,Sweden,EURO,3072,1229188,6,15233
2021-12-12,SE,Sweden,EURO,2866,1232054,3,15236
2021-12-13,SE,Sweden,EURO,2395,1234449,8,15244
2021-12-14,SE,Sweden,EURO,1475,1235924,3,15247
2021-12-15,SE,Sweden,EURO,2712,1238636,6,15253
2021-12-16,SE,Sweden,EURO,4064,1242700,3,15256
2021-12-17,SE,Sweden,EURO,4009,1246709,5,15261
2021-12-18,SE,Sweden,EURO,4116,1250825,10,15271
2021-12-19,SE,Sweden,EURO,4180,1255005,7,15278
2021-12-20,SE,Sweden,EURO,3390,1258395,11,15289
2021-12-21,SE,Sweden,EURO,2019,1260414,6,15295
2021-12-22,SE,Sweden,EURO,3037,1263451,7,15302
2021-12-23,SE,Sweden,EURO,4668,1268119,6,15308
2021-12-24,SE,Sweden,EURO,5108,1273227,4,15312
2021-12-25,SE,Sweden,EURO,5128,1278355,7,15319
2021-12-26,SE,Sweden,EURO,5815,1284170,8,15327
2021-12-27,SE,Sweden,EURO,2364,1286534,8,15335
2021-12-28,SE,Sweden,EURO,1791,1288325,4,15339
2021-12-29,SE,Sweden,EURO,6126,1294451,11,15350
2021-12-30,SE,Sweden,EURO,9232,1303683,11,15361
2021-12-31,SE,Sweden,EURO,10926,1314609,7,15368
2022-01-01,SE,Sweden,EURO,11465,1326074,10,15378
2022-01-02,SE,Sweden,EURO,10599,1336673,7,15385
2022-01-03,SE,Sweden,EURO,5271,1341944,11,15396
2022-01-04,SE,Sweden,EURO,5727,1347671,12,15408
2022-01-05,SE,Sweden,EURO,9981,1357652,19,15427
2022-01-06,SE,Sweden,EURO,17576,1375228,18,15445
2022-01-07,SE,Sweden,EURO,24085,1399313,17,15462
2022-01-08,SE,Sweden,EURO,17707,1417020,20,15482
2022-01-09,SE,Sweden,EURO,19924,1436944,17,15499
2022-01-10,SE,Sweden,EURO,19500,1456444,21,15520
2022-01-11,SE,Sweden,EURO,16512,1472956,17,15537
2022-01-12,SE,Sweden,EURO,15079,1488035,11,15548
2022-01-13,SE,Sweden,EURO,22926,1510961,30,15578
2022-01-14,SE,Sweden,EURO,26558,1537519,20,15598
2022-01-15,SE,Sweden,EURO,26074,1563593,20,15618
2022-01-16,SE,Sweden,EURO,26179,1589772,29,15647
2022-01-17,SE,Sweden,EURO,25789,1615561,23,15670
2022-01-18,SE,Sweden,EURO,22077,1637638,36,15706
2022-01-19,SE,Sweden,EURO,24201,1661839,33,15739
2022-01-20,SE,Sweden,EURO,39320,1701159,32,15771
2022-01-21,SE,Sweden,EURO,40622,1741781,32,15803
2022-01-22,SE,Sweden,EURO,43718,1785499,29,15832
2022-01-23,SE,Sweden,EURO,39810,1825309,39,15871
2022-01-24,SE,Sweden,EURO,37705,1863014,32,15903
2022-01-25,SE,Sweden,EURO,30984,1893998,34,15937
2022-01-26,SE,Sweden,EURO,33910,1927908,38,15975
2022-01-27,SE,Sweden,EURO,46670,1974578,38,16013
2022-01-28,SE,Sweden,EURO,41681,2016259,47,16060
2022-01-29,SE,Sweden,EURO,53895,2070154,30,16090
2022-01-30,SE,Sweden,EURO,39517,2109671,45,16135
2022-01-31,SE,Sweden,EURO,34331,2144002,37,16172
2022-02-01,SE,Sweden,EURO,15069,2159071,38,16210
2022-02-02,SE,Sweden,EURO,24802,2183873,38,16248
2022-02-03,SE,Sweden,EURO,40934,2224807,46,16294
2022-02-04,SE,Sweden,EURO,35945,2260752,40,16334
2022-02-05,SE,Sweden,EURO,28314,2289066,41,16375
2022-02-06,SE,Sweden,EURO,25717,2314783,28,16403
2022-02-07,SE,Sweden,EURO,19991,2334774,29,16432
2022-02-08,SE,Sweden,EURO,10076,2344850,25,16457
2022-02-09,SE,Sweden,EURO,9671,2354521,20,16477
2022-02-10,SE,Sweden,EURO,19610,2374131,17,16494
2022-02-11,SE,Sweden,EURO,15831,2389962,6,16500
2022-02-12,SE,Sweden,EURO,7368,2397330,1,16501
2022-02-13,SE,Sweden,EURO,0,2397330,0,16501
2022-02-14,SE,Sweden,EURO,0,2397330,0,16501
.
158827a
2022-02-12,SR,Suriname,AMRO,205,76703,3,1294
2022-02-13,SR,Suriname,AMRO,173,76876,4,1298
2022-02-14,SR,Suriname,AMRO,99,76975,0,1298
.
158055,158056c
2022-02-10,SD,Sudan,EMRO,70,59525,0,3764
2022-02-11,SD,Sudan,EMRO,121,59646,7,3771
2022-02-12,SD,Sudan,EMRO,28,59674,0,3771
2022-02-13,SD,Sudan,EMRO,226,59900,48,3819
2022-02-14,SD,Sudan,EMRO,3,59903,1,3820
.
157285c
2022-02-11,LK,Sri Lanka,SEARO,1259,625804,0,15723
2022-02-12,LK,Sri Lanka,SEARO,1162,626966,54,15777
2022-02-13,LK,Sri Lanka,SEARO,1150,628116,31,15808
2022-02-14,LK,Sri Lanka,SEARO,0,628116,0,15808
.
155830,156514c
2020-03-29,ES,Spain,EURO,14792,101891,1094,7112
2020-03-30,ES,Spain,EURO,7096,108987,839,7951
2020-03-31,ES,Spain,EURO,5092,114079,811,8762
2020-04-01,ES,Spain,EURO,8008,122087,913,9675
2020-04-02,ES,Spain,EURO,7925,130012,899,10574
2020-04-03,ES,Spain,EURO,7058,137070,895,11469
2020-04-04,ES,Spain,EURO,6905,143975,858,12327
2020-04-05,ES,Spain,EURO,6821,150796,786,13113
2020-04-06,ES,Spain,EURO,4670,155466,740,13853
2020-04-07,ES,Spain,EURO,3147,158613,750,14603
2020-04-08,ES,Spain,EURO,5396,164009,766,15369
2020-04-09,ES,Spain,EURO,5324,169333,736,16105
2020-04-10,ES,Spain,EURO,5488,174821,749,16854
2020-04-11,ES,Spain,EURO,4609,179430,667,17521
2020-04-12,ES,Spain,EURO,4438,183868,676,18197
2020-04-13,ES,Spain,EURO,3075,186943,628,18825
2020-04-14,ES,Spain,EURO,2379,189322,544,19369
2020-04-15,ES,Spain,EURO,3127,192449,587,19956
2020-04-16,ES,Spain,EURO,3993,196442,607,20563
2020-04-17,ES,Spain,EURO,3702,200144,552,21115
2020-04-18,ES,Spain,EURO,3417,203561,487,21602
2020-04-19,ES,Spain,EURO,3462,207023,507,22109
2020-04-20,ES,Spain,EURO,2181,209204,435,22544
2020-04-21,ES,Spain,EURO,1446,210650,401,22945
2020-04-22,ES,Spain,EURO,2518,213168,387,23332
2020-04-23,ES,Spain,EURO,2728,215896,427,23759
2020-04-24,ES,Spain,EURO,2770,218666,344,24103
2020-04-25,ES,Spain,EURO,2222,220888,331,24434
2020-04-26,ES,Spain,EURO,2284,223172,330,24764
2020-04-27,ES,Spain,EURO,1292,224464,295,25059
2020-04-28,ES,Spain,EURO,818,225282,272,25331
2020-04-29,ES,Spain,EURO,1653,226935,258,25589
2020-04-30,ES,Spain,EURO,1736,228671,259,25848
2020-05-01,ES,Spain,EURO,1484,230155,236,26084
2020-05-02,ES,Spain,EURO,1438,231593,223,26307
2020-05-03,ES,Spain,EURO,792,232385,176,26483
2020-05-04,ES,Spain,EURO,566,232951,202,26685
2020-05-05,ES,Spain,EURO,452,233403,197,26882
2020-05-06,ES,Spain,EURO,1013,234416,186,27068
2020-05-07,ES,Spain,EURO,980,235396,183,27251
2020-05-08,ES,Spain,EURO,981,236377,153,27404
2020-05-09,ES,Spain,EURO,956,237333,166,27570
2020-05-10,ES,Spain,EURO,917,238250,146,27716
2020-05-11,ES,Spain,EURO,491,238741,125,27841
2020-05-12,ES,Spain,EURO,317,239058,110,27951
2020-05-13,ES,Spain,EURO,737,239795,122,28073
2020-05-14,ES,Spain,EURO,698,240493,113,28186
2020-05-15,ES,Spain,EURO,793,241286,87,28273
2020-05-16,ES,Spain,EURO,778,242064,86,28359
2020-05-17,ES,Spain,EURO,788,242852,77,28436
2020-05-18,ES,Spain,EURO,342,243194,63,28499
2020-05-19,ES,Spain,EURO,240,243434,61,28560
2020-05-20,ES,Spain,EURO,617,244051,72,28632
2020-05-21,ES,Spain,EURO,824,244875,70,28702
2020-05-22,ES,Spain,EURO,729,245604,57,28759
2020-05-23,ES,Spain,EURO,767,246371,70,28829
2020-05-24,ES,Spain,EURO,797,247168,71,28900
2020-05-25,ES,Spain,EURO,303,247471,60,28960
2020-05-26,ES,Spain,EURO,259,247730,55,29015
2020-05-27,ES,Spain,EURO,537,248267,68,29083
2020-05-28,ES,Spain,EURO,733,249000,55,29138
2020-05-29,ES,Spain,EURO,602,249602,45,29183
2020-05-30,ES,Spain,EURO,645,250247,41,29224
2020-05-31,ES,Spain,EURO,708,250955,45,29269
2020-06-01,ES,Spain,EURO,331,251286,43,29312
2020-06-02,ES,Spain,EURO,178,251464,40,29352
2020-06-03,ES,Spain,EURO,345,251809,35,29387
2020-06-04,ES,Spain,EURO,457,252266,47,29434
2020-06-05,ES,Spain,EURO,574,252840,39,29473
2020-06-06,ES,Spain,EURO,487,253327,48,29521
2020-06-07,ES,Spain,EURO,636,253963,23,29544
2020-06-08,ES,Spain,EURO,257,254220,29,29573
2020-06-09,ES,Spain,EURO,143,254363,21,29594
2020-06-10,ES,Spain,EURO,330,254693,29,29623
2020-06-11,ES,Spain,EURO,434,255127,15,29638
2020-06-12,ES,Spain,EURO,441,255568,31,29669
2020-06-13,ES,Spain,EURO,373,255941,24,29693
2020-06-14,ES,Spain,EURO,481,256422,19,29712
2020-06-15,ES,Spain,EURO,121,256543,23,29735
2020-06-16,ES,Spain,EURO,84,256627,20,29755
2020-06-17,ES,Spain,EURO,286,256913,20,29775
2020-06-18,ES,Spain,EURO,376,257289,11,29786
2020-06-19,ES,Spain,EURO,340,257629,25,29811
2020-06-20,ES,Spain,EURO,364,257993,12,29823
2020-06-21,ES,Spain,EURO,340,258333,18,29841
2020-06-22,ES,Spain,EURO,226,258559,14,29855
2020-06-23,ES,Spain,EURO,163,258722,15,29870
2020-06-24,ES,Spain,EURO,237,258959,7,29877
2020-06-25,ES,Spain,EURO,434,259393,8,29885
2020-06-26,ES,Spain,EURO,330,259723,12,29897
2020-06-27,ES,Spain,EURO,357,260080,11,29908
2020-06-28,ES,Spain,EURO,471,260551,9,29917
2020-06-29,ES,Spain,EURO,251,260802,3,29920
2020-06-30,ES,Spain,EURO,190,260992,12,29932
2020-07-01,ES,Spain,EURO,274,261266,11,29943
2020-07-02,ES,Spain,EURO,444,261710,11,29954
2020-07-03,ES,Spain,EURO,457,262167,10,29964
2020-07-04,ES,Spain,EURO,483,262650,1,29965
2020-07-05,ES,Spain,EURO,592,263242,5,29970
2020-07-06,ES,Spain,EURO,295,263537,7,29977
2020-07-07,ES,Spain,EURO,208,263745,1,29978
2020-07-08,ES,Spain,EURO,340,264085,3,29981
2020-07-09,ES,Spain,EURO,708,264793,6,29987
2020-07-10,ES,Spain,EURO,738,265531,4,29991
2020-07-11,ES,Spain,EURO,848,266379,1,29992
2020-07-12,ES,Spain,EURO,1147,267526,5,29997
2020-07-13,ES,Spain,EURO,614,268140,7,30004
2020-07-14,ES,Spain,EURO,387,268527,2,30006
2020-07-15,ES,Spain,EURO,852,269379,2,30008
2020-07-16,ES,Spain,EURO,1255,270634,3,30011
2020-07-17,ES,Spain,EURO,1557,272191,5,30016
2020-07-18,ES,Spain,EURO,1624,273815,2,30018
2020-07-19,ES,Spain,EURO,2071,275886,2,30020
2020-07-20,ES,Spain,EURO,1516,277402,4,30024
2020-07-21,ES,Spain,EURO,1149,278551,6,30030
2020-07-22,ES,Spain,EURO,1589,280140,8,30038
2020-07-23,ES,Spain,EURO,2320,282460,8,30046
2020-07-24,ES,Spain,EURO,2332,284792,4,30050
2020-07-25,ES,Spain,EURO,2363,287155,4,30054
2020-07-26,ES,Spain,EURO,2845,290000,8,30062
2020-07-27,ES,Spain,EURO,1714,291714,11,30073
2020-07-28,ES,Spain,EURO,1379,293093,7,30080
2020-07-29,ES,Spain,EURO,2039,295132,10,30090
2020-07-30,ES,Spain,EURO,2900,298032,13,30103
2020-07-31,ES,Spain,EURO,3150,301182,11,30114
2020-08-01,ES,Spain,EURO,3410,304592,12,30126
2020-08-02,ES,Spain,EURO,3823,308415,16,30142
2020-08-03,ES,Spain,EURO,3050,311465,12,30154
2020-08-04,ES,Spain,EURO,1841,313306,15,30169
2020-08-05,ES,Spain,EURO,2709,316015,12,30181
2020-08-06,ES,Spain,EURO,4405,320420,20,30201
2020-08-07,ES,Spain,EURO,4287,324707,13,30214
2020-08-08,ES,Spain,EURO,4816,329523,30,30244
2020-08-09,ES,Spain,EURO,5656,335179,23,30267
2020-08-10,ES,Spain,EURO,3498,338677,31,30298
2020-08-11,ES,Spain,EURO,2626,341303,18,30316
2020-08-12,ES,Spain,EURO,3848,345151,31,30347
2020-08-13,ES,Spain,EURO,5991,351142,31,30378
2020-08-14,ES,Spain,EURO,6393,357535,29,30407
2020-08-15,ES,Spain,EURO,7010,364545,25,30432
2020-08-16,ES,Spain,EURO,8329,372874,37,30469
2020-08-17,ES,Spain,EURO,4828,377702,30,30499
2020-08-18,ES,Spain,EURO,3296,380998,23,30522
2020-08-19,ES,Spain,EURO,4970,385968,31,30553
2020-08-20,ES,Spain,EURO,8463,394431,44,30597
2020-08-21,ES,Spain,EURO,8634,403065,47,30644
2020-08-22,ES,Spain,EURO,9021,412086,41,30685
2020-08-23,ES,Spain,EURO,10481,422567,44,30729
2020-08-24,ES,Spain,EURO,6054,428621,44,30773
2020-08-25,ES,Spain,EURO,4296,432917,55,30828
2020-08-26,ES,Spain,EURO,6035,438952,55,30883
2020-08-27,ES,Spain,EURO,10316,449268,44,30927
2020-08-28,ES,Spain,EURO,10297,459565,51,30978
2020-08-29,ES,Spain,EURO,10320,469885,49,31027
2020-08-30,ES,Spain,EURO,11956,481841,70,31097
2020-08-31,ES,Spain,EURO,6872,488713,53,31150
2020-09-01,ES,Spain,EURO,5181,493894,59,31209
2020-09-02,ES,Spain,EURO,6640,500534,65,31274
2020-09-03,ES,Spain,EURO,10471,511005,68,31342
2020-09-04,ES,Spain,EURO,10713,521718,79,31421
2020-09-05,ES,Spain,EURO,10959,532677,80,31501
2020-09-06,ES,Spain,EURO,13191,545868,80,31581
2020-09-07,ES,Spain,EURO,7881,553749,68,31649
2020-09-08,ES,Spain,EURO,5491,559240,61,31710
2020-09-09,ES,Spain,EURO,7037,566277,80,31790
2020-09-10,ES,Spain,EURO,11950,578227,84,31874
2020-09-11,ES,Spain,EURO,12788,591015,95,31969
2020-09-12,ES,Spain,EURO,12993,604008,96,32065
2020-09-13,ES,Spain,EURO,14409,618417,96,32161
2020-09-14,ES,Spain,EURO,8314,626731,102,32263
2020-09-15,ES,Spain,EURO,6402,633133,106,32369
2020-09-16,ES,Spain,EURO,8191,641324,109,32478
2020-09-17,ES,Spain,EURO,13807,655131,137,32615
2020-09-18,ES,Spain,EURO,14021,669152,109,32724
2020-09-19,ES,Spain,EURO,13783,682935,124,32848
2020-09-20,ES,Spain,EURO,16734,699669,115,32963
2020-09-21,ES,Spain,EURO,8328,707997,123,33086
2020-09-22,ES,Spain,EURO,5857,713854,103,33189
2020-09-23,ES,Spain,EURO,8023,721877,123,33312
2020-09-24,ES,Spain,EURO,12796,734673,127,33439
2020-09-25,ES,Spain,EURO,12748,747421,111,33550
2020-09-26,ES,Spain,EURO,12656,760077,133,33683
2020-09-27,ES,Spain,EURO,13533,773610,131,33814
2020-09-28,ES,Spain,EURO,7642,781252,116,33930
2020-09-29,ES,Spain,EURO,5045,786297,120,34050
2020-09-30,ES,Spain,EURO,7070,793367,141,34191
2020-10-01,ES,Spain,EURO,11323,804690,147,34338
2020-10-02,ES,Spain,EURO,11196,815886,153,34491
2020-10-03,ES,Spain,EURO,11055,826941,135,34626
2020-10-04,ES,Spain,EURO,12380,839321,132,34758
2020-10-05,ES,Spain,EURO,6884,846205,106,34864
2020-10-06,ES,Spain,EURO,5130,851335,96,34960
2020-10-07,ES,Spain,EURO,8875,860210,127,35087
2020-10-08,ES,Spain,EURO,12232,872442,132,35219
2020-10-09,ES,Spain,EURO,12408,884850,132,35351
2020-10-10,ES,Spain,EURO,13864,898714,134,35485
2020-10-11,ES,Spain,EURO,14788,913502,150,35635
2020-10-12,ES,Spain,EURO,8720,922222,137,35772
2020-10-13,ES,Spain,EURO,6762,928984,113,35885
2020-10-14,ES,Spain,EURO,6330,935314,128,36013
2020-10-15,ES,Spain,EURO,12373,947687,148,36161
2020-10-16,ES,Spain,EURO,16377,964064,141,36302
2020-10-17,ES,Spain,EURO,17520,981584,148,36450
2020-10-18,ES,Spain,EURO,18275,999859,150,36600
2020-10-19,ES,Spain,EURO,11946,1011805,132,36732
2020-10-20,ES,Spain,EURO,8249,1020054,152,36884
2020-10-21,ES,Spain,EURO,15679,1035733,175,37059
2020-10-22,ES,Spain,EURO,20919,1056652,188,37247
2020-10-23,ES,Spain,EURO,23234,1079886,176,37423
2020-10-24,ES,Spain,EURO,23830,1103716,209,37632
2020-10-25,ES,Spain,EURO,25023,1128739,216,37848
2020-10-26,ES,Spain,EURO,15446,1144185,192,38040
2020-10-27,ES,Spain,EURO,11276,1155461,195,38235
2020-10-28,ES,Spain,EURO,20005,1175466,218,38453
2020-10-29,ES,Spain,EURO,24346,1199812,242,38695
2020-10-30,ES,Spain,EURO,24640,1224452,247,38942
2020-10-31,ES,Spain,EURO,24208,1248660,254,39196
2020-11-01,ES,Spain,EURO,24954,1273614,263,39459
2020-11-02,ES,Spain,EURO,16086,1289700,269,39728
2020-11-03,ES,Spain,EURO,10977,1300677,268,39996
2020-11-04,ES,Spain,EURO,15514,1316191,304,40300
2020-11-05,ES,Spain,EURO,22053,1338244,325,40625
2020-11-06,ES,Spain,EURO,24143,1362387,356,40981
2020-11-07,ES,Spain,EURO,23564,1385951,331,41312
2020-11-08,ES,Spain,EURO,23520,1409471,355,41667
2020-11-09,ES,Spain,EURO,14582,1424053,287,41954
2020-11-10,ES,Spain,EURO,9847,1433900,319,42273
2020-11-11,ES,Spain,EURO,16535,1450435,320,42593
2020-11-12,ES,Spain,EURO,20589,1471024,350,42943
2020-11-13,ES,Spain,EURO,19993,1491017,362,43305
2020-11-14,ES,Spain,EURO,19166,1510183,359,43664
2020-11-15,ES,Spain,EURO,18425,1528608,357,44021
2020-11-16,ES,Spain,EURO,10587,1539195,302,44323
2020-11-17,ES,Spain,EURO,6664,1545859,287,44610
2020-11-18,ES,Spain,EURO,12801,1558660,326,44936
2020-11-19,ES,Spain,EURO,15866,1574526,377,45313
2020-11-20,ES,Spain,EURO,14808,1589334,296,45609
2020-11-21,ES,Spain,EURO,13179,1602513,315,45924
2020-11-22,ES,Spain,EURO,12633,1615146,323,46247
2020-11-23,ES,Spain,EURO,7238,1622384,283,46530
2020-11-24,ES,Spain,EURO,4609,1626993,252,46782
2020-11-25,ES,Spain,EURO,9131,1636124,297,47079
2020-11-26,ES,Spain,EURO,10939,1647063,244,47323
2020-11-27,ES,Spain,EURO,9981,1657044,294,47617
2020-11-28,ES,Spain,EURO,9633,1666677,293,47910
2020-11-29,ES,Spain,EURO,9922,1676599,269,48179
2020-11-30,ES,Spain,EURO,5509,1682108,221,48400
2020-12-01,ES,Spain,EURO,3418,1685526,222,48622
2020-12-02,ES,Spain,EURO,7420,1692946,229,48851
2020-12-03,ES,Spain,EURO,9505,1702451,231,49082
2020-12-04,ES,Spain,EURO,8880,1711331,221,49303
2020-12-05,ES,Spain,EURO,8136,1719467,238,49541
2020-12-06,ES,Spain,EURO,8422,1727889,233,49774
2020-12-07,ES,Spain,EURO,4956,1732845,195,49969
2020-12-08,ES,Spain,EURO,3275,1736120,173,50142
2020-12-09,ES,Spain,EURO,5223,1741343,203,50345
2020-12-10,ES,Spain,EURO,4033,1745376,169,50514
2020-12-11,ES,Spain,EURO,8409,1753785,224,50738
2020-12-12,ES,Spain,EURO,10750,1764535,187,50925
2020-12-13,ES,Spain,EURO,11315,1775850,211,51136
2020-12-14,ES,Spain,EURO,6588,1782438,185,51321
2020-12-15,ES,Spain,EURO,4240,1786678,162,51483
2020-12-16,ES,Spain,EURO,9895,1796573,165,51648
2020-12-17,ES,Spain,EURO,12165,1808738,186,51834
2020-12-18,ES,Spain,EURO,11732,1820470,150,51984
2020-12-19,ES,Spain,EURO,10966,1831436,177,52161
2020-12-20,ES,Spain,EURO,12202,1843638,176,52337
2020-12-21,ES,Spain,EURO,6914,1850552,141,52478
2020-12-22,ES,Spain,EURO,4391,1854943,156,52634
2020-12-23,ES,Spain,EURO,10992,1865935,148,52782
2020-12-24,ES,Spain,EURO,13394,1879329,184,52966
2020-12-25,ES,Spain,EURO,14499,1893828,195,53161
2020-12-26,ES,Spain,EURO,9984,1903812,157,53318
2020-12-27,ES,Spain,EURO,4822,1908634,146,53464
2020-12-28,ES,Spain,EURO,6399,1915033,176,53640
2020-12-29,ES,Spain,EURO,5987,1921020,166,53806
2020-12-30,ES,Spain,EURO,15082,1936102,195,54001
2020-12-31,ES,Spain,EURO,18897,1954999,166,54167
2021-01-01,ES,Spain,EURO,21122,1976121,200,54367
2021-01-02,ES,Spain,EURO,15591,1991712,192,54559
2021-01-03,ES,Spain,EURO,7651,1999363,174,54733
2021-01-04,ES,Spain,EURO,10462,2009825,188,54921
2021-01-05,ES,Spain,EURO,9965,2019790,179,55100
2021-01-06,ES,Spain,EURO,22130,2041920,192,55292
2021-01-07,ES,Spain,EURO,30734,2072654,243,55535
2021-01-08,ES,Spain,EURO,14582,2087236,180,55715
2021-01-09,ES,Spain,EURO,26781,2114017,238,55953
2021-01-10,ES,Spain,EURO,32857,2146874,242,56195
2021-01-11,ES,Spain,EURO,19300,2166174,230,56425
2021-01-12,ES,Spain,EURO,13905,2180079,243,56668
2021-01-13,ES,Spain,EURO,32464,2212543,286,56954
2021-01-14,ES,Spain,EURO,37344,2249887,284,57238
2021-01-15,ES,Spain,EURO,38957,2288844,292,57530
2021-01-16,ES,Spain,EURO,38361,2327205,319,57849
2021-01-17,ES,Spain,EURO,42922,2370127,393,58242
2021-01-18,ES,Spain,EURO,24999,2395126,366,58608
2021-01-19,ES,Spain,EURO,18623,2413749,367,58975
2021-01-20,ES,Spain,EURO,35727,2449476,412,59387
2021-01-21,ES,Spain,EURO,42389,2491865,490,59877
2021-01-22,ES,Spain,EURO,41863,2533728,459,60336
2021-01-23,ES,Spain,EURO,40796,2574524,491,60827
2021-01-24,ES,Spain,EURO,42178,2616702,568,61395
2021-01-25,ES,Spain,EURO,23812,2640514,453,61848
2021-01-26,ES,Spain,EURO,17326,2657840,518,62366
2021-01-27,ES,Spain,EURO,32760,2690600,529,62895
2021-01-28,ES,Spain,EURO,37441,2728041,550,63445
2021-01-29,ES,Spain,EURO,35843,2763884,595,64040
2021-01-30,ES,Spain,EURO,33347,2797231,576,64616
2021-01-31,ES,Spain,EURO,32344,2829575,533,65149
2021-02-01,ES,Spain,EURO,18173,2847748,515,65664
2021-02-02,ES,Spain,EURO,11711,2859459,486,66150
2021-02-03,ES,Spain,EURO,22499,2881958,544,66694
2021-02-04,ES,Spain,EURO,25993,2907951,493,67187
2021-02-05,ES,Spain,EURO,23804,2931755,492,67679
2021-02-06,ES,Spain,EURO,21115,2952870,464,68143
2021-02-07,ES,Spain,EURO,20168,2973038,462,68605
2021-02-08,ES,Spain,EURO,10323,2983361,408,69013
2021-02-09,ES,Spain,EURO,6098,2989459,382,69395
2021-02-10,ES,Spain,EURO,13791,3003250,411,69806
2021-02-11,ES,Spain,EURO,15358,3018608,386,70192
2021-02-12,ES,Spain,EURO,13338,3031946,408,70600
2021-02-13,ES,Spain,EURO,11857,3043803,355,70955
2021-02-14,ES,Spain,EURO,11693,3055496,340,71295
2021-02-15,ES,Spain,EURO,5744,3061240,289,71584
2021-02-16,ES,Spain,EURO,3584,3064824,244,71828
2021-02-17,ES,Spain,EURO,8857,3073681,285,72113
2021-02-18,ES,Spain,EURO,9862,3083543,298,72411
2021-02-19,ES,Spain,EURO,8618,3092161,260,72671
2021-02-20,ES,Spain,EURO,8180,3100341,242,72913
2021-02-21,ES,Spain,EURO,7975,3108316,225,73138
2021-02-22,ES,Spain,EURO,4014,3112330,185,73323
2021-02-23,ES,Spain,EURO,2669,3114999,183,73506
2021-02-24,ES,Spain,EURO,6836,3121835,226,73732
2021-02-25,ES,Spain,EURO,7375,3129210,190,73922
2021-02-26,ES,Spain,EURO,6477,3135687,207,74129
2021-02-27,ES,Spain,EURO,6178,3141865,197,74326
2021-02-28,ES,Spain,EURO,6464,3148329,176,74502
2021-03-01,ES,Spain,EURO,3212,3151541,162,74664
2021-03-02,ES,Spain,EURO,2242,3153783,149,74813
2021-03-03,ES,Spain,EURO,5383,3159166,134,74947
2021-03-04,ES,Spain,EURO,5892,3165058,154,75101
2021-03-05,ES,Spain,EURO,5952,3171010,142,75243
2021-03-06,ES,Spain,EURO,5605,3176615,136,75379
2021-03-07,ES,Spain,EURO,5730,3182345,131,75510
2021-03-08,ES,Spain,EURO,2861,3185206,126,75636
2021-03-09,ES,Spain,EURO,2050,3187256,98,75734
2021-03-10,ES,Spain,EURO,5121,3192377,119,75853
2021-03-11,ES,Spain,EURO,5672,3198049,117,75970
2021-03-12,ES,Spain,EURO,5526,3203575,102,76072
2021-03-13,ES,Spain,EURO,5369,3208944,97,76169
2021-03-14,ES,Spain,EURO,5823,3214767,107,76276
2021-03-15,ES,Spain,EURO,2833,3217600,85,76361
2021-03-16,ES,Spain,EURO,1973,3219573,78,76439
2021-03-17,ES,Spain,EURO,5585,3225158,100,76539
2021-03-18,ES,Spain,EURO,6112,3231270,112,76651
2021-03-19,ES,Spain,EURO,5831,3237101,96,76747
2021-03-20,ES,Spain,EURO,6382,3243483,70,76817
2021-03-21,ES,Spain,EURO,4696,3248179,67,76884
2021-03-22,ES,Spain,EURO,2914,3251093,67,76951
2021-03-23,ES,Spain,EURO,2315,3253408,67,77018
2021-03-24,ES,Spain,EURO,6152,3259560,74,77092
2021-03-25,ES,Spain,EURO,7379,3266939,90,77182
2021-03-26,ES,Spain,EURO,6952,3273891,54,77236
2021-03-27,ES,Spain,EURO,7342,3281233,67,77303
2021-03-28,ES,Spain,EURO,7672,3288905,86,77389
2021-03-29,ES,Spain,EURO,4124,3293029,65,77454
2021-03-30,ES,Spain,EURO,2943,3295972,71,77525
2021-03-31,ES,Spain,EURO,7419,3303391,88,77613
2021-04-01,ES,Spain,EURO,8213,3311604,85,77698
2021-04-02,ES,Spain,EURO,9021,3320625,76,77774
2021-04-03,ES,Spain,EURO,5713,3326338,74,77848
2021-04-04,ES,Spain,EURO,3856,3330194,70,77918
2021-04-05,ES,Spain,EURO,4592,3334786,78,77996
2021-04-06,ES,Spain,EURO,4274,3339060,58,78054
2021-04-07,ES,Spain,EURO,7724,3346784,73,78127
2021-04-08,ES,Spain,EURO,10888,3357672,80,78207
2021-04-09,ES,Spain,EURO,10626,3368298,92,78299
2021-04-10,ES,Spain,EURO,10392,3378690,83,78382
2021-04-11,ES,Spain,EURO,10551,3389241,81,78463
2021-04-12,ES,Spain,EURO,5666,3394907,90,78553
2021-04-13,ES,Spain,EURO,3943,3398850,52,78605
2021-04-14,ES,Spain,EURO,9043,3407893,95,78700
2021-04-15,ES,Spain,EURO,10198,3418091,81,78781
2021-04-16,ES,Spain,EURO,10400,3428491,90,78871
2021-04-17,ES,Spain,EURO,9739,3438230,73,78944
2021-04-18,ES,Spain,EURO,10066,3448296,81,79025
2021-04-19,ES,Spain,EURO,5344,3453640,76,79101
2021-04-20,ES,Spain,EURO,3938,3457578,59,79160
2021-04-21,ES,Spain,EURO,8738,3466316,85,79245
2021-04-22,ES,Spain,EURO,10714,3477030,80,79325
2021-04-23,ES,Spain,EURO,9759,3486789,64,79389
2021-04-24,ES,Spain,EURO,9840,3496629,72,79461
2021-04-25,ES,Spain,EURO,9953,3506582,78,79539
2021-04-26,ES,Spain,EURO,5052,3511634,74,79613
2021-04-27,ES,Spain,EURO,3868,3515502,64,79677
2021-04-28,ES,Spain,EURO,8959,3524461,67,79744
2021-04-29,ES,Spain,EURO,9783,3534244,66,79810
2021-04-30,ES,Spain,EURO,9332,3543576,66,79876
2021-05-01,ES,Spain,EURO,8902,3552478,60,79936
2021-05-02,ES,Spain,EURO,9065,3561543,65,80001
2021-05-03,ES,Spain,EURO,3922,3565465,55,80056
2021-05-04,ES,Spain,EURO,3111,3568576,51,80107
2021-05-05,ES,Spain,EURO,6080,3574656,73,80180
2021-05-06,ES,Spain,EURO,7524,3582180,68,80248
2021-05-07,ES,Spain,EURO,7945,3590125,68,80316
2021-05-08,ES,Spain,EURO,6950,3597075,60,80376
2021-05-09,ES,Spain,EURO,7553,3604628,69,80445
2021-05-10,ES,Spain,EURO,3444,3608072,52,80497
2021-05-11,ES,Spain,EURO,2430,3610502,50,80547
2021-05-12,ES,Spain,EURO,6060,3616562,53,80600
2021-05-13,ES,Spain,EURO,5965,3622527,50,80650
2021-05-14,ES,Spain,EURO,5904,3628431,54,80704
2021-05-15,ES,Spain,EURO,5730,3634161,54,80758
2021-05-16,ES,Spain,EURO,5922,3640083,45,80803
2021-05-17,ES,Spain,EURO,2855,3642938,42,80845
2021-05-18,ES,Spain,EURO,2205,3645143,40,80885
2021-05-19,ES,Spain,EURO,5190,3650333,35,80920
2021-05-20,ES,Spain,EURO,6001,3656334,35,80955
2021-05-21,ES,Spain,EURO,5378,3661712,48,81003
2021-05-22,ES,Spain,EURO,5466,3667178,33,81036
2021-05-23,ES,Spain,EURO,5645,3672823,43,81079
2021-05-24,ES,Spain,EURO,2695,3675518,34,81113
2021-05-25,ES,Spain,EURO,1986,3677504,32,81145
2021-05-26,ES,Spain,EURO,4554,3682058,36,81181
2021-05-27,ES,Spain,EURO,5413,3687471,23,81204
2021-05-28,ES,Spain,EURO,5301,3692772,38,81242
2021-05-29,ES,Spain,EURO,5359,3698131,16,81258
2021-05-30,ES,Spain,EURO,5356,3703487,21,81279
2021-05-31,ES,Spain,EURO,2898,3706385,21,81300
2021-06-01,ES,Spain,EURO,1945,3708330,28,81328
2021-06-02,ES,Spain,EURO,4855,3713185,38,81366
2021-06-03,ES,Spain,EURO,5126,3718311,24,81390
2021-06-04,ES,Spain,EURO,5113,3723424,33,81423
2021-06-05,ES,Spain,EURO,4464,3727888,28,81451
2021-06-06,ES,Spain,EURO,4569,3732457,32,81483
2021-06-07,ES,Spain,EURO,2436,3734893,24,81507
2021-06-08,ES,Spain,EURO,1706,3736599,26,81533
2021-06-09,ES,Spain,EURO,4155,3740754,19,81552
2021-06-10,ES,Spain,EURO,4135,3744889,27,81579
2021-06-11,ES,Spain,EURO,4094,3748983,18,81597
2021-06-12,ES,Spain,EURO,4117,3753100,25,81622
2021-06-13,ES,Spain,EURO,3988,3757088,12,81634
2021-06-14,ES,Spain,EURO,2199,3759287,20,81654
2021-06-15,ES,Spain,EURO,1544,3760831,19,81673
2021-06-16,ES,Spain,EURO,3615,3764446,16,81689
2021-06-17,ES,Spain,EURO,4064,3768510,23,81712
2021-06-18,ES,Spain,EURO,3971,3772481,21,81733
2021-06-19,ES,Spain,EURO,3977,3776458,21,81754
2021-06-20,ES,Spain,EURO,3998,3780456,16,81770
2021-06-21,ES,Spain,EURO,2257,3782713,8,81778
2021-06-22,ES,Spain,EURO,1665,3784378,15,81793
2021-06-23,ES,Spain,EURO,3854,3788232,19,81812
2021-06-24,ES,Spain,EURO,4416,3792648,17,81829
2021-06-25,ES,Spain,EURO,5015,3797663,17,81846
2021-06-26,ES,Spain,EURO,3876,3801539,14,81860
2021-06-27,ES,Spain,EURO,5662,3807201,13,81873
2021-06-28,ES,Spain,EURO,3743,3810944,13,81886
2021-06-29,ES,Spain,EURO,3118,3814062,19,81905
2021-06-30,ES,Spain,EURO,8107,3822169,14,81919
2021-07-01,ES,Spain,EURO,10703,3832872,14,81933
2021-07-02,ES,Spain,EURO,13062,3845934,13,81946
2021-07-03,ES,Spain,EURO,14016,3859950,15,81961
2021-07-04,ES,Spain,EURO,14922,3874872,6,81967
2021-07-05,ES,Spain,EURO,10269,3885141,15,81982
2021-07-06,ES,Spain,EURO,7631,3892772,9,81991
2021-07-07,ES,Spain,EURO,16881,3909653,10,82001
2021-07-08,ES,Spain,EURO,20437,3930090,13,82014
2021-07-09,ES,Spain,EURO,23012,3953102,9,82023
2021-07-10,ES,Spain,EURO,22704,3975806,7,82030
2021-07-11,ES,Spain,EURO,24507,4000313,14,82044
2021-07-12,ES,Spain,EURO,15000,4015313,18,82062
2021-07-13,ES,Spain,EURO,12265,4027578,15,82077
2021-07-14,ES,Spain,EURO,25784,4053362,17,82094
2021-07-15,ES,Spain,EURO,28359,4081721,20,82114
2021-07-16,ES,Spain,EURO,29818,4111539,21,82135
2021-07-17,ES,Spain,EURO,29461,4141000,20,82155
2021-07-18,ES,Spain,EURO,29649,4170649,37,82192
2021-07-19,ES,Spain,EURO,18508,4189157,18,82210
2021-07-20,ES,Spain,EURO,14453,4203610,20,82230
2021-07-21,ES,Spain,EURO,29781,4233391,32,82262
2021-07-22,ES,Spain,EURO,31767,4265158,46,82308
2021-07-23,ES,Spain,EURO,31820,4296978,49,82357
2021-07-24,ES,Spain,EURO,31007,4327985,45,82402
2021-07-25,ES,Spain,EURO,30070,4358055,45,82447
2021-07-26,ES,Spain,EURO,18123,4376178,78,82525
2021-07-27,ES,Spain,EURO,12628,4388806,51,82576
2021-07-28,ES,Spain,EURO,25689,4414495,59,82635
2021-07-29,ES,Spain,EURO,28848,4443343,78,82713
2021-07-30,ES,Spain,EURO,26939,4470282,64,82777
2021-07-31,ES,Spain,EURO,25565,4495847,67,82844
2021-08-01,ES,Spain,EURO,25705,4521552,87,82931
2021-08-02,ES,Spain,EURO,14740,4536292,83,83014
2021-08-03,ES,Spain,EURO,9575,4545867,75,83089
2021-08-04,ES,Spain,EURO,19814,4565681,91,83180
2021-08-05,ES,Spain,EURO,21551,4587232,90,83270
2021-08-06,ES,Spain,EURO,20552,4607784,112,83382
2021-08-07,ES,Spain,EURO,19546,4627330,89,83471
2021-08-08,ES,Spain,EURO,19123,4646453,96,83567
2021-08-09,ES,Spain,EURO,10980,4657433,80,83647
2021-08-10,ES,Spain,EURO,7235,4664668,75,83722
2021-08-11,ES,Spain,EURO,15022,4679690,104,83826
2021-08-12,ES,Spain,EURO,17206,4696896,99,83925
2021-08-13,ES,Spain,EURO,15786,4712682,102,84027
2021-08-14,ES,Spain,EURO,14853,4727535,123,84150
2021-08-15,ES,Spain,EURO,13841,4741376,101,84251
2021-08-16,ES,Spain,EURO,8024,4749400,103,84354
2021-08-17,ES,Spain,EURO,5559,4754959,113,84467
2021-08-18,ES,Spain,EURO,9581,4764540,107,84574
2021-08-19,ES,Spain,EURO,11980,4776520,123,84697
2021-08-20,ES,Spain,EURO,12581,4789101,103,84800
2021-08-21,ES,Spain,EURO,11741,4800842,93,84893
2021-08-22,ES,Spain,EURO,11717,4812559,92,84985
2021-08-23,ES,Spain,EURO,6496,4819055,82,85067
2021-08-24,ES,Spain,EURO,4092,4823147,72,85139
2021-08-25,ES,Spain,EURO,9804,4832951,94,85233
2021-08-26,ES,Spain,EURO,9821,4842772,84,85317
2021-08-27,ES,Spain,EURO,9043,4851815,104,85421
2021-08-28,ES,Spain,EURO,8166,4859981,77,85498
2021-08-29,ES,Spain,EURO,8105,4868086,85,85583
2021-08-30,ES,Spain,EURO,4017,4872103,71,85654
2021-08-31,ES,Spain,EURO,2679,4874782,72,85726
2021-09-01,ES,Spain,EURO,6221,4881003,89,85815
2021-09-02,ES,Spain,EURO,7126,4888129,80,85895
2021-09-03,ES,Spain,EURO,5926,4894055,85,85980
2021-09-04,ES,Spain,EURO,5253,4899308,71,86051
2021-09-05,ES,Spain,EURO,4881,4904189,75,86126
2021-09-06,ES,Spain,EURO,2699,4906888,53,86179
2021-09-07,ES,Spain,EURO,1897,4908785,55,86234
2021-09-08,ES,Spain,EURO,4209,4912994,65,86299
2021-09-09,ES,Spain,EURO,4706,4917700,58,86357
2021-09-10,ES,Spain,EURO,3720,4921420,66,86423
2021-09-11,ES,Spain,EURO,3714,4925134,58,86481
2021-09-12,ES,Spain,EURO,3763,4928897,52,86533
2021-09-13,ES,Spain,EURO,1716,4930613,42,86575
2021-09-14,ES,Spain,EURO,1267,4931880,54,86629
2021-09-15,ES,Spain,EURO,3364,4935244,41,86670
2021-09-16,ES,Spain,EURO,3408,4938652,55,86725
2021-09-17,ES,Spain,EURO,2875,4941527,56,86781
2021-09-18,ES,Spain,EURO,2881,4944408,49,86830
2021-09-19,ES,Spain,EURO,2947,4947355,45,86875
2021-09-20,ES,Spain,EURO,1367,4948722,41,86916
2021-09-21,ES,Spain,EURO,891,4949613,46,86962
2021-09-22,ES,Spain,EURO,2378,4951991,41,87003
2021-09-23,ES,Spain,EURO,2711,4954702,43,87046
2021-09-24,ES,Spain,EURO,2493,4957195,31,87077
2021-09-25,ES,Spain,EURO,2299,4959494,29,87106
2021-09-26,ES,Spain,EURO,2441,4961935,37,87143
2021-09-27,ES,Spain,EURO,1222,4963157,27,87170
2021-09-28,ES,Spain,EURO,810,4963967,19,87189
2021-09-29,ES,Spain,EURO,2448,4966415,21,87210
2021-09-30,ES,Spain,EURO,2209,4968624,21,87231
2021-10-01,ES,Spain,EURO,2061,4970685,25,87256
2021-10-02,ES,Spain,EURO,1831,4972516,32,87288
2021-10-03,ES,Spain,EURO,1874,4974390,27,87315
2021-10-04,ES,Spain,EURO,971,4975361,30,87345
2021-10-05,ES,Spain,EURO,676,4976037,19,87364
2021-10-06,ES,Spain,EURO,1875,4977912,27,87391
2021-10-07,ES,Spain,EURO,1790,4979702,11,87402
2021-10-08,ES,Spain,EURO,1760,4981462,23,87425
2021-10-09,ES,Spain,EURO,1667,4983129,27,87452
2021-10-10,ES,Spain,EURO,1818,4984947,17,87469
2021-10-11,ES,Spain,EURO,879,4985826,16,87485
2021-10-12,ES,Spain,EURO,519,4986345,16,87501
2021-10-13,ES,Spain,EURO,1963,4988308,19,87520
2021-10-14,ES,Spain,EURO,819,4989127,17,87537
2021-10-15,ES,Spain,EURO,1859,4990986,18,87555
2021-10-16,ES,Spain,EURO,2019,4993005,17,87572
2021-10-17,ES,Spain,EURO,2000,4995005,18,87590
2021-10-18,ES,Spain,EURO,1107,4996112,14,87604
2021-10-19,ES,Spain,EURO,766,4996878,13,87617
2021-10-20,ES,Spain,EURO,2108,4998986,16,87633
2021-10-21,ES,Spain,EURO,2067,5001053,17,87650
2021-10-22,ES,Spain,EURO,2086,5003139,23,87673
2021-10-23,ES,Spain,EURO,1973,5005112,21,87694
2021-10-24,ES,Spain,EURO,2087,5007199,14,87708
2021-10-25,ES,Spain,EURO,1122,5008321,15,87723
2021-10-26,ES,Spain,EURO,833,5009154,14,87737
2021-10-27,ES,Spain,EURO,2240,5011394,15,87752
2021-10-28,ES,Spain,EURO,2083,5013477,18,87770
2021-10-29,ES,Spain,EURO,2107,5015584,15,87785
2021-10-30,ES,Spain,EURO,2124,5017708,18,87803
2021-10-31,ES,Spain,EURO,2425,5020133,7,87810
2021-11-01,ES,Spain,EURO,1348,5021481,19,87829
2021-11-02,ES,Spain,EURO,937,5022418,11,87840
2021-11-03,ES,Spain,EURO,994,5023412,13,87853
2021-11-04,ES,Spain,EURO,2876,5026288,9,87862
2021-11-05,ES,Spain,EURO,2913,5029201,16,87878
2021-11-06,ES,Spain,EURO,2970,5032171,9,87887
2021-11-07,ES,Spain,EURO,3168,5035339,11,87898
2021-11-08,ES,Spain,EURO,1823,5037162,14,87912
2021-11-09,ES,Spain,EURO,1199,5038361,20,87932
2021-11-10,ES,Spain,EURO,3419,5041780,26,87958
2021-11-11,ES,Spain,EURO,3811,5045591,25,87983
2021-11-12,ES,Spain,EURO,3850,5049441,22,88005
2021-11-13,ES,Spain,EURO,4332,5053773,15,88020
2021-11-14,ES,Spain,EURO,4873,5058646,26,88046
2021-11-15,ES,Spain,EURO,2879,5061525,17,88063
2021-11-16,ES,Spain,EURO,2126,5063651,16,88079
2021-11-17,ES,Spain,EURO,5579,5069230,22,88101
2021-11-18,ES,Spain,EURO,6321,5075551,23,88124
2021-11-19,ES,Spain,EURO,6407,5081958,21,88145
2021-11-20,ES,Spain,EURO,6821,5088779,21,88166
2021-11-21,ES,Spain,EURO,7702,5096481,10,88176
2021-11-22,ES,Spain,EURO,4466,5100947,19,88195
2021-11-23,ES,Spain,EURO,3158,5104105,25,88220
2021-11-24,ES,Spain,EURO,8081,5112186,24,88244
2021-11-25,ES,Spain,EURO,9075,5121261,18,88262
2021-11-26,ES,Spain,EURO,9581,5130842,16,88278
2021-11-27,ES,Spain,EURO,9869,5140711,25,88303
2021-11-28,ES,Spain,EURO,11003,5151714,25,88328
2021-11-29,ES,Spain,EURO,6746,5158460,26,88354
2021-11-30,ES,Spain,EURO,4511,5162971,19,88373
2021-12-01,ES,Spain,EURO,11440,5174411,31,88404
2021-12-02,ES,Spain,EURO,13202,5187613,38,88442
2021-12-03,ES,Spain,EURO,14229,5201842,29,88471
2021-12-04,ES,Spain,EURO,15406,5217248,31,88502
2021-12-05,ES,Spain,EURO,15960,5233208,35,88537
2021-12-06,ES,Spain,EURO,10944,5244152,34,88571
2021-12-07,ES,Spain,EURO,7602,5251754,37,88608
2021-12-08,ES,Spain,EURO,7941,5259695,47,88655
2021-12-09,ES,Spain,EURO,18043,5277738,42,88697
2021-12-10,ES,Spain,EURO,11909,5289647,38,88735
2021-12-11,ES,Spain,EURO,20830,5310477,41,88776
2021-12-12,ES,Spain,EURO,25764,5336241,41,88817
2021-12-13,ES,Spain,EURO,16495,5352736,38,88855
2021-12-14,ES,Spain,EURO,12852,5365588,29,88884
2021-12-15,ES,Spain,EURO,27015,5392603,47,88931
2021-12-16,ES,Spain,EURO,31864,5424467,52,88983
2021-12-17,ES,Spain,EURO,36356,5460823,34,89017
2021-12-18,ES,Spain,EURO,38118,5498941,62,89079
2021-12-19,ES,Spain,EURO,43902,5542843,58,89137
2021-12-20,ES,Spain,EURO,26493,5569336,55,89192
2021-12-21,ES,Spain,EURO,22134,5591470,60,89252
2021-12-22,ES,Spain,EURO,54633,5646103,71,89323
2021-12-23,ES,Spain,EURO,73814,5719917,64,89387
2021-12-24,ES,Spain,EURO,85420,5805337,54,89441
2021-12-25,ES,Spain,EURO,95662,5900999,56,89497
2021-12-26,ES,Spain,EURO,74062,5975061,55,89552
2021-12-27,ES,Spain,EURO,46274,6021335,63,89615
2021-12-28,ES,Spain,EURO,51546,6072881,57,89672
2021-12-29,ES,Spain,EURO,114294,6187175,79,89751
2021-12-30,ES,Spain,EURO,135572,6322747,71,89822
2021-12-31,ES,Spain,EURO,147344,6470091,83,89905
2022-01-01,ES,Spain,EURO,144798,6614889,77,89982
2022-01-02,ES,Spain,EURO,102522,6717411,77,90059
2022-01-03,ES,Spain,EURO,57589,6775000,82,90141
2022-01-04,ES,Spain,EURO,69377,6844377,76,90217
2022-01-05,ES,Spain,EURO,142838,6987215,97,90314
2022-01-06,ES,Spain,EURO,163775,7150990,107,90421
2022-01-07,ES,Spain,EURO,159198,7310188,104,90525
2022-01-08,ES,Spain,EURO,73856,7384044,89,90614
2022-01-09,ES,Spain,EURO,147214,7531258,99,90713
2022-01-10,ES,Spain,EURO,89313,7620571,113,90826
2022-01-11,ES,Spain,EURO,89643,7710214,113,90939
2022-01-12,ES,Spain,EURO,170548,7880762,150,91089
2022-01-13,ES,Spain,EURO,167732,8048494,121,91210
2022-01-14,ES,Spain,EURO,157009,8205503,127,91337
2022-01-15,ES,Spain,EURO,145738,8351241,160,91497
2022-01-16,ES,Spain,EURO,130912,8482153,165,91662
2022-01-17,ES,Spain,EURO,83342,8565495,136,91798
2022-01-18,ES,Spain,EURO,73665,8639160,179,91977
2022-01-19,ES,Spain,EURO,152737,8791897,167,92144
2022-01-20,ES,Spain,EURO,145596,8937493,147,92291
2022-01-21,ES,Spain,EURO,138917,9076410,167,92458
2022-01-22,ES,Spain,EURO,129369,9205779,155,92613
2022-01-23,ES,Spain,EURO,124230,9330009,200,92813
2022-01-24,ES,Spain,EURO,70517,9400526,136,92949
2022-01-25,ES,Spain,EURO,64594,9465120,153,93102
2022-01-26,ES,Spain,EURO,128322,9593442,202,93304
2022-01-27,ES,Spain,EURO,115536,9708978,185,93489
2022-01-28,ES,Spain,EURO,107763,9816741,182,93671
2022-01-29,ES,Spain,EURO,91944,9908685,153,93824
2022-01-30,ES,Spain,EURO,82329,9991014,176,94000
2022-01-31,ES,Spain,EURO,45863,10036877,176,94176
2022-02-01,ES,Spain,EURO,38669,10075546,169,94345
2022-02-02,ES,Spain,EURO,78479,10154025,178,94523
2022-02-03,ES,Spain,EURO,69641,10223666,164,94687
2022-02-04,ES,Spain,EURO,63649,10287315,159,94846
2022-02-05,ES,Spain,EURO,56081,10343396,156,95002
2022-02-06,ES,Spain,EURO,51164,10394560,132,95134
2022-02-07,ES,Spain,EURO,26436,10420996,87,95221
2022-02-08,ES,Spain,EURO,22185,10443181,132,95353
2022-02-09,ES,Spain,EURO,48289,10491470,127,95480
2022-02-10,ES,Spain,EURO,40422,10531892,101,95581
2022-02-11,ES,Spain,EURO,23305,10555197,25,95606
2022-02-12,ES,Spain,EURO,0,10555197,0,95606
2022-02-13,ES,Spain,EURO,0,10555197,0,95606
2022-02-14,ES,Spain,EURO,0,10555197,0,95606
.
155743a
2022-02-12,SS,South Sudan,AFRO,0,16880,0,137
2022-02-13,SS,South Sudan,AFRO,16,16896,0,137
2022-02-14,SS,South Sudan,AFRO,1,16897,0,137
.
154972a
2022-02-12,ZA,South Africa,AFRO,2862,3637673,146,96851
2022-02-13,ZA,South Africa,AFRO,2489,3640162,134,96985
2022-02-14,ZA,South Africa,AFRO,1649,3641811,8,96993
.
154201a
2022-02-12,SO,Somalia,EMRO,0,26203,0,1340
2022-02-13,SO,Somalia,EMRO,0,26203,0,1340
2022-02-14,SO,Somalia,EMRO,0,26203,0,1340
.
153430a
2022-02-12,SB,Solomon Islands,WPRO,99,4302,3,53
2022-02-13,SB,Solomon Islands,WPRO,0,4302,0,53
2022-02-14,SB,Solomon Islands,WPRO,187,4489,5,58
.
152255,152659c
2021-01-03,SI,Slovenia,EURO,399,124433,35,3060
2021-01-04,SI,Slovenia,EURO,762,125195,35,3095
2021-01-05,SI,Slovenia,EURO,766,125961,34,3129
2021-01-06,SI,Slovenia,EURO,2605,128566,30,3159
2021-01-07,SI,Slovenia,EURO,3428,131994,37,3196
2021-01-08,SI,Slovenia,EURO,2697,134691,24,3220
2021-01-09,SI,Slovenia,EURO,2084,136775,29,3249
2021-01-10,SI,Slovenia,EURO,1862,138637,28,3277
2021-01-11,SI,Slovenia,EURO,764,139401,33,3310
2021-01-12,SI,Slovenia,EURO,426,139827,20,3330
2021-01-13,SI,Slovenia,EURO,1910,141737,29,3359
2021-01-14,SI,Slovenia,EURO,2105,143842,23,3382
2021-01-15,SI,Slovenia,EURO,1808,145650,19,3401
2021-01-16,SI,Slovenia,EURO,1501,147151,25,3426
2021-01-17,SI,Slovenia,EURO,1549,148700,30,3456
2021-01-18,SI,Slovenia,EURO,575,149275,34,3490
2021-01-19,SI,Slovenia,EURO,300,149575,31,3521
2021-01-20,SI,Slovenia,EURO,1707,151282,28,3549
2021-01-21,SI,Slovenia,EURO,1718,153000,25,3574
2021-01-22,SI,Slovenia,EURO,1458,154458,29,3603
2021-01-23,SI,Slovenia,EURO,1461,155919,24,3627
2021-01-24,SI,Slovenia,EURO,1521,157440,27,3654
2021-01-25,SI,Slovenia,EURO,541,157981,30,3684
2021-01-26,SI,Slovenia,EURO,297,158278,24,3708
2021-01-27,SI,Slovenia,EURO,1682,159960,23,3731
2021-01-28,SI,Slovenia,EURO,1877,161837,24,3755
2021-01-29,SI,Slovenia,EURO,1541,163378,16,3771
2021-01-30,SI,Slovenia,EURO,1305,164683,26,3797
2021-01-31,SI,Slovenia,EURO,1302,165985,22,3819
2021-02-01,SI,Slovenia,EURO,587,166572,17,3836
2021-02-02,SI,Slovenia,EURO,348,166920,21,3857
2021-02-03,SI,Slovenia,EURO,1516,168436,16,3873
2021-02-04,SI,Slovenia,EURO,1567,170003,24,3897
2021-02-05,SI,Slovenia,EURO,1267,171270,25,3922
2021-02-06,SI,Slovenia,EURO,960,172230,16,3938
2021-02-07,SI,Slovenia,EURO,984,173214,13,3951
2021-02-08,SI,Slovenia,EURO,498,173712,17,3968
2021-02-09,SI,Slovenia,EURO,308,174020,8,3976
2021-02-10,SI,Slovenia,EURO,338,174358,18,3994
2021-02-11,SI,Slovenia,EURO,1369,175727,12,4006
2021-02-12,SI,Slovenia,EURO,1338,177065,10,4016
2021-02-13,SI,Slovenia,EURO,1047,178112,17,4033
2021-02-14,SI,Slovenia,EURO,993,179105,15,4048
2021-02-15,SI,Slovenia,EURO,387,179492,9,4057
2021-02-16,SI,Slovenia,EURO,244,179736,10,4067
2021-02-17,SI,Slovenia,EURO,747,180483,6,4073
2021-02-18,SI,Slovenia,EURO,1100,181583,6,4079
2021-02-19,SI,Slovenia,EURO,875,182458,8,4087
2021-02-20,SI,Slovenia,EURO,911,183369,5,4092
2021-02-21,SI,Slovenia,EURO,960,184329,7,4099
2021-02-22,SI,Slovenia,EURO,419,184748,4,4103
2021-02-23,SI,Slovenia,EURO,250,184998,5,4108
2021-02-24,SI,Slovenia,EURO,903,185901,6,4114
2021-02-25,SI,Slovenia,EURO,1095,186996,10,4124
2021-02-26,SI,Slovenia,EURO,859,187855,7,4131
2021-02-27,SI,Slovenia,EURO,920,188775,12,4143
2021-02-28,SI,Slovenia,EURO,949,189724,10,4153
2021-03-01,SI,Slovenia,EURO,455,190179,10,4163
2021-03-02,SI,Slovenia,EURO,246,190425,11,4174
2021-03-03,SI,Slovenia,EURO,730,191155,6,4180
2021-03-04,SI,Slovenia,EURO,1212,192367,7,4187
2021-03-05,SI,Slovenia,EURO,1022,193389,9,4196
2021-03-06,SI,Slovenia,EURO,885,194274,7,4203
2021-03-07,SI,Slovenia,EURO,926,195200,2,4205
2021-03-08,SI,Slovenia,EURO,384,195584,4,4209
2021-03-09,SI,Slovenia,EURO,211,195795,3,4212
2021-03-10,SI,Slovenia,EURO,743,196538,7,4219
2021-03-11,SI,Slovenia,EURO,960,197498,7,4226
2021-03-12,SI,Slovenia,EURO,862,198360,12,4238
2021-03-13,SI,Slovenia,EURO,772,199132,7,4245
2021-03-14,SI,Slovenia,EURO,852,199984,5,4250
2021-03-15,SI,Slovenia,EURO,482,200466,4,4254
2021-03-16,SI,Slovenia,EURO,205,200671,4,4258
2021-03-17,SI,Slovenia,EURO,921,201592,4,4262
2021-03-18,SI,Slovenia,EURO,1114,202706,8,4270
2021-03-19,SI,Slovenia,EURO,976,203682,3,4273
2021-03-20,SI,Slovenia,EURO,944,204626,10,4283
2021-03-21,SI,Slovenia,EURO,1034,205660,10,4293
2021-03-22,SI,Slovenia,EURO,518,206178,6,4299
2021-03-23,SI,Slovenia,EURO,290,206468,8,4307
2021-03-24,SI,Slovenia,EURO,988,207456,8,4315
2021-03-25,SI,Slovenia,EURO,1289,208745,12,4327
2021-03-26,SI,Slovenia,EURO,1163,209908,6,4333
2021-03-27,SI,Slovenia,EURO,1037,210945,9,4342
2021-03-28,SI,Slovenia,EURO,1252,212197,6,4348
2021-03-29,SI,Slovenia,EURO,641,212838,6,4354
2021-03-30,SI,Slovenia,EURO,289,213127,6,4360
2021-03-31,SI,Slovenia,EURO,1084,214211,11,4371
2021-04-01,SI,Slovenia,EURO,1572,215783,12,4383
2021-04-02,SI,Slovenia,EURO,1340,217123,7,4390
2021-04-03,SI,Slovenia,EURO,1172,218295,11,4401
2021-04-04,SI,Slovenia,EURO,1300,219595,6,4407
2021-04-05,SI,Slovenia,EURO,721,220316,9,4416
2021-04-06,SI,Slovenia,EURO,283,220599,5,4421
2021-04-07,SI,Slovenia,EURO,273,220872,9,4430
2021-04-08,SI,Slovenia,EURO,1193,222065,6,4436
2021-04-09,SI,Slovenia,EURO,1531,223596,5,4441
2021-04-10,SI,Slovenia,EURO,1284,224880,3,4444
2021-04-11,SI,Slovenia,EURO,1257,226137,12,4456
2021-04-12,SI,Slovenia,EURO,549,226686,4,4460
2021-04-13,SI,Slovenia,EURO,291,226977,5,4465
2021-04-14,SI,Slovenia,EURO,1050,228027,7,4472
2021-04-15,SI,Slovenia,EURO,1236,229263,6,4478
2021-04-16,SI,Slovenia,EURO,894,230157,4,4482
2021-04-17,SI,Slovenia,EURO,862,231019,9,4491
2021-04-18,SI,Slovenia,EURO,772,231791,7,4498
2021-04-19,SI,Slovenia,EURO,476,232267,4,4502
2021-04-20,SI,Slovenia,EURO,233,232500,9,4511
2021-04-21,SI,Slovenia,EURO,726,233226,8,4519
2021-04-22,SI,Slovenia,EURO,1040,234266,5,4524
2021-04-23,SI,Slovenia,EURO,744,235010,14,4538
2021-04-24,SI,Slovenia,EURO,901,235911,2,4540
2021-04-25,SI,Slovenia,EURO,831,236742,9,4549
2021-04-26,SI,Slovenia,EURO,417,237159,8,4557
2021-04-27,SI,Slovenia,EURO,192,237351,9,4566
2021-04-28,SI,Slovenia,EURO,810,238161,2,4568
2021-04-29,SI,Slovenia,EURO,404,238565,12,4580
2021-04-30,SI,Slovenia,EURO,921,239486,9,4589
2021-05-01,SI,Slovenia,EURO,949,240435,8,4597
2021-05-02,SI,Slovenia,EURO,1019,241454,9,4606
2021-05-03,SI,Slovenia,EURO,367,241821,4,4610
2021-05-04,SI,Slovenia,EURO,210,242031,8,4618
2021-05-05,SI,Slovenia,EURO,893,242924,3,4621
2021-05-06,SI,Slovenia,EURO,930,243854,9,4630
2021-05-07,SI,Slovenia,EURO,777,244631,2,4632
2021-05-08,SI,Slovenia,EURO,609,245240,3,4635
2021-05-09,SI,Slovenia,EURO,634,245874,0,4635
2021-05-10,SI,Slovenia,EURO,291,246165,7,4642
2021-05-11,SI,Slovenia,EURO,146,246311,7,4649
2021-05-12,SI,Slovenia,EURO,491,246802,2,4651
2021-05-13,SI,Slovenia,EURO,730,247532,5,4656
2021-05-14,SI,Slovenia,EURO,599,248131,5,4661
2021-05-15,SI,Slovenia,EURO,472,248603,7,4668
2021-05-16,SI,Slovenia,EURO,496,249099,2,4670
2021-05-17,SI,Slovenia,EURO,293,249392,3,4673
2021-05-18,SI,Slovenia,EURO,115,249507,5,4678
2021-05-19,SI,Slovenia,EURO,497,250004,4,4682
2021-05-20,SI,Slovenia,EURO,538,250542,4,4686
2021-05-21,SI,Slovenia,EURO,358,250900,5,4691
2021-05-22,SI,Slovenia,EURO,334,251234,2,4693
2021-05-23,SI,Slovenia,EURO,382,251616,2,4695
2021-05-24,SI,Slovenia,EURO,158,251774,1,4696
2021-05-25,SI,Slovenia,EURO,84,251858,2,4698
2021-05-26,SI,Slovenia,EURO,323,252181,1,4699
2021-05-27,SI,Slovenia,EURO,391,252572,4,4703
2021-05-28,SI,Slovenia,EURO,367,252939,1,4704
2021-05-29,SI,Slovenia,EURO,289,253228,3,4707
2021-05-30,SI,Slovenia,EURO,356,253584,3,4710
2021-05-31,SI,Slovenia,EURO,137,253721,4,4714
2021-06-01,SI,Slovenia,EURO,92,253813,2,4716
2021-06-02,SI,Slovenia,EURO,323,254136,1,4717
2021-06-03,SI,Slovenia,EURO,373,254509,3,4720
2021-06-04,SI,Slovenia,EURO,273,254782,2,4722
2021-06-05,SI,Slovenia,EURO,280,255062,3,4725
2021-06-06,SI,Slovenia,EURO,247,255309,1,4726
2021-06-07,SI,Slovenia,EURO,157,255466,2,4728
2021-06-08,SI,Slovenia,EURO,58,255524,2,4730
2021-06-09,SI,Slovenia,EURO,220,255744,3,4733
2021-06-10,SI,Slovenia,EURO,254,255998,0,4733
2021-06-11,SI,Slovenia,EURO,195,256193,3,4736
2021-06-12,SI,Slovenia,EURO,123,256316,3,4739
2021-06-13,SI,Slovenia,EURO,126,256442,3,4742
2021-06-14,SI,Slovenia,EURO,91,256533,5,4747
2021-06-15,SI,Slovenia,EURO,24,256557,3,4750
2021-06-16,SI,Slovenia,EURO,113,256670,3,4753
2021-06-17,SI,Slovenia,EURO,117,256787,1,4754
2021-06-18,SI,Slovenia,EURO,84,256871,0,4754
2021-06-19,SI,Slovenia,EURO,89,256960,1,4755
2021-06-20,SI,Slovenia,EURO,84,257044,0,4755
2021-06-21,SI,Slovenia,EURO,26,257070,2,4757
2021-06-22,SI,Slovenia,EURO,19,257089,2,4759
2021-06-23,SI,Slovenia,EURO,67,257156,2,4761
2021-06-24,SI,Slovenia,EURO,54,257210,0,4761
2021-06-25,SI,Slovenia,EURO,43,257253,1,4762
2021-06-26,SI,Slovenia,EURO,46,257299,1,4763
2021-06-27,SI,Slovenia,EURO,11,257310,2,4765
2021-06-28,SI,Slovenia,EURO,19,257329,0,4765
2021-06-29,SI,Slovenia,EURO,11,257340,0,4765
2021-06-30,SI,Slovenia,EURO,36,257376,0,4765
2021-07-01,SI,Slovenia,EURO,47,257423,0,4765
2021-07-02,SI,Slovenia,EURO,23,257446,0,4765
2021-07-03,SI,Slovenia,EURO,24,257470,0,4765
2021-07-04,SI,Slovenia,EURO,30,257500,0,4765
2021-07-05,SI,Slovenia,EURO,9,257509,0,4765
2021-07-06,SI,Slovenia,EURO,8,257517,1,4766
2021-07-07,SI,Slovenia,EURO,48,257565,1,4767
2021-07-08,SI,Slovenia,EURO,73,257638,3,4770
2021-07-09,SI,Slovenia,EURO,69,257707,0,4770
2021-07-10,SI,Slovenia,EURO,81,257788,2,4772
2021-07-11,SI,Slovenia,EURO,81,257869,0,4772
2021-07-12,SI,Slovenia,EURO,24,257893,0,4772
2021-07-13,SI,Slovenia,EURO,11,257904,1,4773
2021-07-14,SI,Slovenia,EURO,84,257988,0,4773
2021-07-15,SI,Slovenia,EURO,83,258071,0,4773
2021-07-16,SI,Slovenia,EURO,56,258127,0,4773
2021-07-17,SI,Slovenia,EURO,63,258190,0,4773
2021-07-18,SI,Slovenia,EURO,61,258251,0,4773
2021-07-19,SI,Slovenia,EURO,21,258272,0,4773
2021-07-20,SI,Slovenia,EURO,9,258281,0,4773
2021-07-21,SI,Slovenia,EURO,89,258370,0,4773
2021-07-22,SI,Slovenia,EURO,110,258480,0,4773
2021-07-23,SI,Slovenia,EURO,70,258550,0,4773
2021-07-24,SI,Slovenia,EURO,58,258608,0,4773
2021-07-25,SI,Slovenia,EURO,93,258701,1,4774
2021-07-26,SI,Slovenia,EURO,32,258733,0,4774
2021-07-27,SI,Slovenia,EURO,21,258754,0,4774
2021-07-28,SI,Slovenia,EURO,106,258860,0,4774
2021-07-29,SI,Slovenia,EURO,85,258945,0,4774
2021-07-30,SI,Slovenia,EURO,99,259044,0,4774
2021-07-31,SI,Slovenia,EURO,117,259161,0,4774
2021-08-01,SI,Slovenia,EURO,135,259296,1,4775
2021-08-02,SI,Slovenia,EURO,58,259354,0,4775
2021-08-03,SI,Slovenia,EURO,31,259385,0,4775
2021-08-04,SI,Slovenia,EURO,181,259566,0,4775
2021-08-05,SI,Slovenia,EURO,139,259705,0,4775
2021-08-06,SI,Slovenia,EURO,139,259844,0,4775
2021-08-07,SI,Slovenia,EURO,143,259987,1,4776
2021-08-08,SI,Slovenia,EURO,134,260121,0,4776
2021-08-09,SI,Slovenia,EURO,67,260188,0,4776
2021-08-10,SI,Slovenia,EURO,46,260234,0,4776
2021-08-11,SI,Slovenia,EURO,219,260453,0,4776
2021-08-12,SI,Slovenia,EURO,247,260700,0,4776
2021-08-13,SI,Slovenia,EURO,250,260950,0,4776
2021-08-14,SI,Slovenia,EURO,199,261149,0,4776
2021-08-15,SI,Slovenia,EURO,264,261413,0,4776
2021-08-16,SI,Slovenia,EURO,97,261510,0,4776
2021-08-17,SI,Slovenia,EURO,57,261567,0,4776
2021-08-18,SI,Slovenia,EURO,318,261885,0,4776
2021-08-19,SI,Slovenia,EURO,387,262272,2,4778
2021-08-20,SI,Slovenia,EURO,382,262654,4,4782
2021-08-21,SI,Slovenia,EURO,335,262989,0,4782
2021-08-22,SI,Slovenia,EURO,388,263377,0,4782
2021-08-23,SI,Slovenia,EURO,246,263623,2,4784
2021-08-24,SI,Slovenia,EURO,117,263740,1,4785
2021-08-25,SI,Slovenia,EURO,476,264216,3,4788
2021-08-26,SI,Slovenia,EURO,509,264725,1,4789
2021-08-27,SI,Slovenia,EURO,511,265236,1,4790
2021-08-28,SI,Slovenia,EURO,544,265780,3,4793
2021-08-29,SI,Slovenia,EURO,540,266320,2,4795
2021-08-30,SI,Slovenia,EURO,277,266597,0,4795
2021-08-31,SI,Slovenia,EURO,144,266741,0,4795
2021-09-01,SI,Slovenia,EURO,541,267282,2,4797
2021-09-02,SI,Slovenia,EURO,772,268054,2,4799
2021-09-03,SI,Slovenia,EURO,668,268722,1,4800
2021-09-04,SI,Slovenia,EURO,611,269333,1,4801
2021-09-05,SI,Slovenia,EURO,743,270076,2,4803
2021-09-06,SI,Slovenia,EURO,318,270394,0,4803
2021-09-07,SI,Slovenia,EURO,236,270630,0,4803
2021-09-08,SI,Slovenia,EURO,881,271511,3,4806
2021-09-09,SI,Slovenia,EURO,1095,272606,5,4811
2021-09-10,SI,Slovenia,EURO,1019,273625,2,4813
2021-09-11,SI,Slovenia,EURO,999,274624,3,4816
2021-09-12,SI,Slovenia,EURO,1088,275712,5,4821
2021-09-13,SI,Slovenia,EURO,560,276272,0,4821
2021-09-14,SI,Slovenia,EURO,285,276557,3,4824
2021-09-15,SI,Slovenia,EURO,1394,277951,4,4828
2021-09-16,SI,Slovenia,EURO,1365,279316,5,4833
2021-09-17,SI,Slovenia,EURO,1327,280643,8,4841
2021-09-18,SI,Slovenia,EURO,1145,281788,4,4845
2021-09-19,SI,Slovenia,EURO,1253,283041,6,4851
2021-09-20,SI,Slovenia,EURO,545,283586,3,4854
2021-09-21,SI,Slovenia,EURO,292,283878,6,4860
2021-09-22,SI,Slovenia,EURO,1308,285186,5,4865
2021-09-23,SI,Slovenia,EURO,1189,286375,7,4872
2021-09-24,SI,Slovenia,EURO,1012,287387,4,4876
2021-09-25,SI,Slovenia,EURO,941,288328,7,4883
2021-09-26,SI,Slovenia,EURO,1007,289335,8,4891
2021-09-27,SI,Slovenia,EURO,447,289782,7,4898
2021-09-28,SI,Slovenia,EURO,286,290068,7,4905
2021-09-29,SI,Slovenia,EURO,1041,291109,13,4918
2021-09-30,SI,Slovenia,EURO,1342,292451,4,4922
2021-10-01,SI,Slovenia,EURO,1028,293479,9,4931
2021-10-02,SI,Slovenia,EURO,973,294452,5,4936
2021-10-03,SI,Slovenia,EURO,993,295445,9,4945
2021-10-04,SI,Slovenia,EURO,533,295978,7,4952
2021-10-05,SI,Slovenia,EURO,225,296203,7,4959
2021-10-06,SI,Slovenia,EURO,980,297183,7,4966
2021-10-07,SI,Slovenia,EURO,1209,298392,11,4977
2021-10-08,SI,Slovenia,EURO,969,299361,4,4981
2021-10-09,SI,Slovenia,EURO,842,300203,3,4984
2021-10-10,SI,Slovenia,EURO,883,301086,10,4994
2021-10-11,SI,Slovenia,EURO,489,301575,9,5003
2021-10-12,SI,Slovenia,EURO,188,301763,6,5009
2021-10-13,SI,Slovenia,EURO,1005,302768,2,5011
2021-10-14,SI,Slovenia,EURO,1229,303997,4,5015
2021-10-15,SI,Slovenia,EURO,1082,305079,9,5024
2021-10-16,SI,Slovenia,EURO,1105,306184,5,5029
2021-10-17,SI,Slovenia,EURO,1438,307622,4,5033
2021-10-18,SI,Slovenia,EURO,632,308254,4,5037
2021-10-19,SI,Slovenia,EURO,364,308618,7,5044
2021-10-20,SI,Slovenia,EURO,1673,310291,5,5049
2021-10-21,SI,Slovenia,EURO,2155,312446,7,5056
2021-10-22,SI,Slovenia,EURO,1852,314298,11,5067
2021-10-23,SI,Slovenia,EURO,1969,316267,4,5071
2021-10-24,SI,Slovenia,EURO,2272,318539,11,5082
2021-10-25,SI,Slovenia,EURO,1498,320037,5,5087
2021-10-26,SI,Slovenia,EURO,708,320745,9,5096
2021-10-27,SI,Slovenia,EURO,2296,323041,10,5106
2021-10-28,SI,Slovenia,EURO,3138,326179,11,5117
2021-10-29,SI,Slovenia,EURO,2632,328811,11,5128
2021-10-30,SI,Slovenia,EURO,2517,331328,15,5143
2021-10-31,SI,Slovenia,EURO,2991,334319,7,5150
2021-11-01,SI,Slovenia,EURO,1664,335983,8,5158
2021-11-02,SI,Slovenia,EURO,1258,337241,12,5170
2021-11-03,SI,Slovenia,EURO,1136,338377,10,5180
2021-11-04,SI,Slovenia,EURO,3462,341839,19,5199
2021-11-05,SI,Slovenia,EURO,4518,346357,12,5211
2021-11-06,SI,Slovenia,EURO,3779,350136,17,5228
2021-11-07,SI,Slovenia,EURO,3664,353800,12,5240
2021-11-08,SI,Slovenia,EURO,2325,356125,15,5255
2021-11-09,SI,Slovenia,EURO,1288,357413,20,5275
2021-11-10,SI,Slovenia,EURO,3348,360761,13,5288
2021-11-11,SI,Slovenia,EURO,4483,365244,20,5308
2021-11-12,SI,Slovenia,EURO,3573,368817,12,5320
2021-11-13,SI,Slovenia,EURO,3435,372252,12,5332
2021-11-14,SI,Slovenia,EURO,3667,375919,24,5356
2021-11-15,SI,Slovenia,EURO,2369,378288,24,5380
2021-11-16,SI,Slovenia,EURO,1820,380108,23,5403
2021-11-17,SI,Slovenia,EURO,3771,383879,9,5412
2021-11-18,SI,Slovenia,EURO,4283,388162,15,5427
2021-11-19,SI,Slovenia,EURO,3667,391829,26,5453
2021-11-20,SI,Slovenia,EURO,3518,395347,25,5478
2021-11-21,SI,Slovenia,EURO,3239,398586,20,5498
2021-11-22,SI,Slovenia,EURO,2248,400834,27,5525
2021-11-23,SI,Slovenia,EURO,1390,402224,18,5543
2021-11-24,SI,Slovenia,EURO,3400,405624,19,5562
2021-11-25,SI,Slovenia,EURO,3143,408767,19,5581
2021-11-26,SI,Slovenia,EURO,2670,411437,14,5595
2021-11-27,SI,Slovenia,EURO,2367,413804,18,5613
2021-11-28,SI,Slovenia,EURO,2227,416031,25,5638
2021-11-29,SI,Slovenia,EURO,1481,417512,31,5669
2021-11-30,SI,Slovenia,EURO,1039,418551,21,5690
2021-12-01,SI,Slovenia,EURO,2484,421035,19,5709
2021-12-02,SI,Slovenia,EURO,2258,423293,23,5732
2021-12-03,SI,Slovenia,EURO,2128,425421,20,5752
2021-12-04,SI,Slovenia,EURO,1739,427160,20,5772
2021-12-05,SI,Slovenia,EURO,1908,429068,22,5794
2021-12-06,SI,Slovenia,EURO,1116,430184,20,5814
2021-12-07,SI,Slovenia,EURO,775,430959,11,5825
2021-12-08,SI,Slovenia,EURO,1955,432914,18,5843
2021-12-09,SI,Slovenia,EURO,1852,434766,17,5860
2021-12-10,SI,Slovenia,EURO,1688,436454,14,5874
2021-12-11,SI,Slovenia,EURO,1324,437778,19,5893
2021-12-12,SI,Slovenia,EURO,1480,439258,15,5908
2021-12-13,SI,Slovenia,EURO,786,440044,12,5920
2021-12-14,SI,Slovenia,EURO,677,440721,19,5939
2021-12-15,SI,Slovenia,EURO,1716,442437,16,5955
2021-12-16,SI,Slovenia,EURO,1530,443967,14,5969
2021-12-17,SI,Slovenia,EURO,1347,445314,7,5976
2021-12-18,SI,Slovenia,EURO,1281,446595,11,5987
2021-12-19,SI,Slovenia,EURO,1288,447883,16,6003
2021-12-20,SI,Slovenia,EURO,769,448652,12,6015
2021-12-21,SI,Slovenia,EURO,586,449238,8,6023
2021-12-22,SI,Slovenia,EURO,1558,450796,10,6033
2021-12-23,SI,Slovenia,EURO,1255,452051,9,6042
2021-12-24,SI,Slovenia,EURO,1124,453175,8,6050
2021-12-25,SI,Slovenia,EURO,1207,454382,9,6059
2021-12-26,SI,Slovenia,EURO,1091,455473,4,6063
2021-12-27,SI,Slovenia,EURO,666,456139,11,6074
2021-12-28,SI,Slovenia,EURO,701,456840,9,6083
2021-12-29,SI,Slovenia,EURO,1819,458659,11,6094
2021-12-30,SI,Slovenia,EURO,1871,460530,17,6111
2021-12-31,SI,Slovenia,EURO,1691,462221,7,6118
2022-01-01,SI,Slovenia,EURO,1898,464119,5,6123
2022-01-02,SI,Slovenia,EURO,1668,465787,7,6130
2022-01-03,SI,Slovenia,EURO,835,466622,8,6138
2022-01-04,SI,Slovenia,EURO,1010,467632,9,6147
2022-01-05,SI,Slovenia,EURO,3403,471035,10,6157
2022-01-06,SI,Slovenia,EURO,4084,475119,8,6165
2022-01-07,SI,Slovenia,EURO,3848,478967,7,6172
2022-01-08,SI,Slovenia,EURO,4085,483052,11,6183
2022-01-09,SI,Slovenia,EURO,4492,487544,5,6188
2022-01-10,SI,Slovenia,EURO,3360,490904,6,6194
2022-01-11,SI,Slovenia,EURO,2530,493434,8,6202
2022-01-12,SI,Slovenia,EURO,5174,498608,4,6206
2022-01-13,SI,Slovenia,EURO,7436,506044,12,6218
2022-01-14,SI,Slovenia,EURO,6879,512923,9,6227
2022-01-15,SI,Slovenia,EURO,6941,519864,9,6236
2022-01-16,SI,Slovenia,EURO,7603,527467,6,6242
2022-01-17,SI,Slovenia,EURO,6022,533489,4,6246
2022-01-18,SI,Slovenia,EURO,4979,538468,7,6253
2022-01-19,SI,Slovenia,EURO,8694,547162,10,6263
2022-01-20,SI,Slovenia,EURO,12302,559464,14,6277
2022-01-21,SI,Slovenia,EURO,10305,569769,5,6282
2022-01-22,SI,Slovenia,EURO,9866,579635,11,6293
2022-01-23,SI,Slovenia,EURO,9960,589595,13,6306
2022-01-24,SI,Slovenia,EURO,14191,603786,17,6323
2022-01-25,SI,Slovenia,EURO,8414,612200,13,6336
2022-01-26,SI,Slovenia,EURO,12839,625039,15,6351
2022-01-27,SI,Slovenia,EURO,17513,642552,22,6373
2022-01-28,SI,Slovenia,EURO,14227,656779,16,6389
2022-01-29,SI,Slovenia,EURO,16897,673676,10,6399
2022-01-30,SI,Slovenia,EURO,14903,688579,18,6417
2022-01-31,SI,Slovenia,EURO,13867,702446,20,6437
2022-02-01,SI,Slovenia,EURO,8583,711029,18,6455
2022-02-02,SI,Slovenia,EURO,11730,722759,18,6473
2022-02-03,SI,Slovenia,EURO,24196,746955,19,6492
2022-02-04,SI,Slovenia,EURO,16757,763712,19,6511
2022-02-05,SI,Slovenia,EURO,11742,775454,23,6534
2022-02-06,SI,Slovenia,EURO,11713,787167,15,6549
2022-02-07,SI,Slovenia,EURO,7509,794676,20,6569
2022-02-08,SI,Slovenia,EURO,5529,800205,12,6581
2022-02-09,SI,Slovenia,EURO,11159,811364,7,6588
2022-02-10,SI,Slovenia,EURO,5107,816471,9,6597
2022-02-11,SI,Slovenia,EURO,12167,828638,3,6600
2022-02-12,SI,Slovenia,EURO,7548,836186,5,6605
2022-02-13,SI,Slovenia,EURO,7334,843520,1,6606
2022-02-14,SI,Slovenia,EURO,4257,847777,1,6607
.
151888a
2022-02-12,SK,Slovakia,EURO,19872,1226925,17,18081
2022-02-13,SK,Slovakia,EURO,14196,1241121,14,18095
2022-02-14,SK,Slovakia,EURO,8552,1249673,10,18105
.
151117a
2022-02-12,SX,Sint Maarten,AMRO,20,9469,0,83
2022-02-13,SX,Sint Maarten,AMRO,0,9469,0,83
2022-02-14,SX,Sint Maarten,AMRO,0,9469,0,83
.
150346a
2022-02-12,XB,Sint Eustatius,AMRO,1,422,0,3
2022-02-13,XB,Sint Eustatius,AMRO,0,422,0,3
2022-02-14,XB,Sint Eustatius,AMRO,0,422,0,3
.
149575a
2022-02-12,SG,Singapore,WPRO,9930,449570,3,885
2022-02-13,SG,Singapore,WPRO,10505,460075,8,893
2022-02-14,SG,Singapore,WPRO,9420,469495,4,897
.
148804a
2022-02-12,SL,Sierra Leone,AFRO,10,7638,0,125
2022-02-13,SL,Sierra Leone,AFRO,10,7648,0,125
2022-02-14,SL,Sierra Leone,AFRO,0,7648,0,125
.
148033a
2022-02-12,SC,Seychelles,AFRO,0,38395,0,150
2022-02-13,SC,Seychelles,AFRO,0,38395,0,150
2022-02-14,SC,Seychelles,AFRO,264,38659,0,150
.
147262a
2022-02-12,RS,Serbia,EURO,9580,1826787,65,14299
2022-02-13,RS,Serbia,EURO,8187,1834974,67,14366
2022-02-14,RS,Serbia,EURO,6036,1841010,61,14427
.
146491a
2022-02-12,SN,Senegal,AFRO,38,85346,0,1956
2022-02-13,SN,Senegal,AFRO,24,85370,0,1956
2022-02-14,SN,Senegal,AFRO,42,85412,1,1957
.
145720a
2022-02-12,SA,Saudi Arabia,EMRO,2523,724525,4,8969
2022-02-13,SA,Saudi Arabia,EMRO,1726,726251,2,8971
2022-02-14,SA,Saudi Arabia,EMRO,2136,728387,2,8973
.
144949a
2022-02-12,ST,Sao Tome and Principe,AFRO,3,5919,0,71
2022-02-13,ST,Sao Tome and Principe,AFRO,1,5920,0,71
2022-02-14,ST,Sao Tome and Principe,AFRO,0,5920,0,71
.
144136,144178c
2021-12-31,SM,San Marino,EURO,154,8223,1,99
2022-01-01,SM,San Marino,EURO,167,8390,1,100
2022-01-02,SM,San Marino,EURO,6,8396,0,100
2022-01-03,SM,San Marino,EURO,124,8520,0,100
2022-01-04,SM,San Marino,EURO,194,8714,2,102
2022-01-05,SM,San Marino,EURO,173,8887,0,102
2022-01-06,SM,San Marino,EURO,250,9137,1,103
2022-01-07,SM,San Marino,EURO,18,9155,0,103
2022-01-08,SM,San Marino,EURO,259,9414,0,103
2022-01-09,SM,San Marino,EURO,164,9578,0,103
2022-01-10,SM,San Marino,EURO,14,9592,0,103
2022-01-11,SM,San Marino,EURO,273,9865,0,103
2022-01-12,SM,San Marino,EURO,219,10084,0,103
2022-01-13,SM,San Marino,EURO,176,10260,0,103
2022-01-14,SM,San Marino,EURO,148,10408,0,103
2022-01-15,SM,San Marino,EURO,147,10555,0,103
2022-01-16,SM,San Marino,EURO,128,10683,0,103
2022-01-17,SM,San Marino,EURO,6,10689,0,103
2022-01-18,SM,San Marino,EURO,223,10912,0,103
2022-01-19,SM,San Marino,EURO,216,11128,0,103
2022-01-20,SM,San Marino,EURO,210,11338,2,105
2022-01-21,SM,San Marino,EURO,178,11516,1,106
2022-01-22,SM,San Marino,EURO,172,11688,1,107
2022-01-23,SM,San Marino,EURO,141,11829,0,107
2022-01-24,SM,San Marino,EURO,14,11843,1,108
2022-01-25,SM,San Marino,EURO,210,12053,0,108
2022-01-26,SM,San Marino,EURO,237,12290,1,109
2022-01-27,SM,San Marino,EURO,230,12520,0,109
2022-01-28,SM,San Marino,EURO,166,12686,0,109
2022-01-29,SM,San Marino,EURO,143,12829,0,109
2022-01-30,SM,San Marino,EURO,109,12938,0,109
2022-01-31,SM,San Marino,EURO,13,12951,0,109
2022-02-01,SM,San Marino,EURO,193,13144,0,109
2022-02-02,SM,San Marino,EURO,129,13273,0,109
2022-02-03,SM,San Marino,EURO,103,13376,0,109
2022-02-04,SM,San Marino,EURO,102,13478,0,109
2022-02-05,SM,San Marino,EURO,94,13572,0,109
2022-02-06,SM,San Marino,EURO,13,13585,0,109
2022-02-07,SM,San Marino,EURO,17,13602,0,109
2022-02-08,SM,San Marino,EURO,133,13735,0,109
2022-02-09,SM,San Marino,EURO,62,13797,0,109
2022-02-10,SM,San Marino,EURO,65,13862,1,110
2022-02-11,SM,San Marino,EURO,52,13914,0,110
2022-02-12,SM,San Marino,EURO,37,13951,0,110
2022-02-13,SM,San Marino,EURO,35,13986,0,110
2022-02-14,SM,San Marino,EURO,2,13988,0,110
.
143407a
2022-02-12,WS,Samoa,WPRO,0,33,0,0
2022-02-13,WS,Samoa,WPRO,0,33,0,0
2022-02-14,WS,Samoa,WPRO,0,33,0,0
.
142635,142636c
2022-02-10,VC,Saint Vincent and the Grenadines,AMRO,15,8159,2,101
2022-02-11,VC,Saint Vincent and the Grenadines,AMRO,9,8168,0,101
2022-02-12,VC,Saint Vincent and the Grenadines,AMRO,12,8180,0,101
2022-02-13,VC,Saint Vincent and the Grenadines,AMRO,50,8230,1,102
2022-02-14,VC,Saint Vincent and the Grenadines,AMRO,16,8246,0,102
.
141865a
2022-02-12,PM,Saint Pierre and Miquelon,AMRO,0,921,0,1
2022-02-13,PM,Saint Pierre and Miquelon,AMRO,0,921,0,1
2022-02-14,PM,Saint Pierre and Miquelon,AMRO,0,921,0,1
.
141094a
2022-02-12,MF,Saint Martin,AMRO,0,9606,0,43
2022-02-13,MF,Saint Martin,AMRO,0,9606,0,43
2022-02-14,MF,Saint Martin,AMRO,0,9606,0,43
.
140323a
2022-02-12,LC,Saint Lucia,AMRO,42,21873,4,346
2022-02-13,LC,Saint Lucia,AMRO,59,21932,1,347
2022-02-14,LC,Saint Lucia,AMRO,116,22048,0,347
.
139552a
2022-02-12,KN,Saint Kitts and Nevis,AMRO,3,5495,0,39
2022-02-13,KN,Saint Kitts and Nevis,AMRO,0,5495,0,39
2022-02-14,KN,Saint Kitts and Nevis,AMRO,0,5495,0,39
.
138781a
2022-02-12,SH,Saint Helena,AFRO,0,0,0,0
2022-02-13,SH,Saint Helena,AFRO,0,0,0,0
2022-02-14,SH,Saint Helena,AFRO,0,0,0,0
.
138010a
2022-02-12,BL,Saint Barthélemy,AMRO,0,3542,0,4
2022-02-13,BL,Saint Barthélemy,AMRO,0,3542,0,4
2022-02-14,BL,Saint Barthélemy,AMRO,0,3542,0,4
.
137239a
2022-02-12,XC,Saba,AMRO,0,200,0,0
2022-02-13,XC,Saba,AMRO,0,200,0,0
2022-02-14,XC,Saba,AMRO,0,200,0,0
.
136468a
2022-02-12,RW,Rwanda,AFRO,44,129278,0,1449
2022-02-13,RW,Rwanda,AFRO,17,129295,1,1450
2022-02-14,RW,Rwanda,AFRO,0,129295,0,1450
.
135697a
2022-02-12,RU,Russian Federation,EURO,203766,13935560,729,339542
2022-02-13,RU,Russian Federation,EURO,197949,14133509,706,340248
2022-02-14,RU,Russian Federation,EURO,180456,14313965,683,340931
.
134926a
2022-02-12,RO,Romania,EURO,22737,2531597,132,61363
2022-02-13,RO,Romania,EURO,18751,2550348,157,61520
2022-02-14,RO,Romania,EURO,11967,2562315,81,61601
.
134155a
2022-02-12,RE,Réunion,AFRO,0,256787,0,565
2022-02-13,RE,Réunion,AFRO,0,256787,0,565
2022-02-14,RE,Réunion,AFRO,0,256787,0,565
.
133384a
2022-02-12,MD,Republic of Moldova,EURO,2553,482842,31,10924
2022-02-13,MD,Republic of Moldova,EURO,1674,484516,16,10940
2022-02-14,MD,Republic of Moldova,EURO,1047,485563,22,10962
.
132613a
2022-02-12,KR,Republic of Korea,WPRO,54912,1294199,33,7045
2022-02-13,KR,Republic of Korea,WPRO,56428,1350627,36,7081
2022-02-14,KR,Republic of Korea,WPRO,54619,1405246,21,7102
.
131842a
2022-02-12,QA,Qatar,EMRO,657,349581,1,656
2022-02-13,QA,Qatar,EMRO,607,350188,0,656
2022-02-14,QA,Qatar,EMRO,613,350801,0,656
.
131071a
2022-02-12,PR,Puerto Rico,AMRO,726,467604,14,4008
2022-02-13,PR,Puerto Rico,AMRO,567,468171,17,4025
2022-02-14,PR,Puerto Rico,AMRO,680,468851,5,4030
.
130300a
2022-02-12,PT,Portugal,EURO,24271,3049692,41,20442
2022-02-13,PT,Portugal,EURO,19436,3069128,50,20492
2022-02-14,PT,Portugal,EURO,16132,3085260,38,20530
.
129529a
2022-02-12,PL,Poland,EURO,31316,5379498,332,108089
2022-02-13,PL,Poland,EURO,28056,5407554,31,108120
2022-02-14,PL,Poland,EURO,7460,5415014,17,108137
.
128758a
2022-02-12,PN,Pitcairn Islands,WPRO,0,0,0,0
2022-02-13,PN,Pitcairn Islands,WPRO,0,0,0,0
2022-02-14,PN,Pitcairn Islands,WPRO,0,0,0,0
.
127987c
2022-02-11,PH,Philippines,WPRO,3849,3626849,93,54783
2022-02-12,PH,Philippines,WPRO,3727,3630576,71,54854
2022-02-13,PH,Philippines,WPRO,3654,3634230,76,54930
2022-02-14,PH,Philippines,WPRO,3050,3637280,0,54930
.
127216a
2022-02-12,PE,Peru,AMRO,13564,3411201,201,207737
2022-02-13,PE,Peru,AMRO,13693,3424894,228,207965
2022-02-14,PE,Peru,AMRO,10859,3435753,155,208120
.
126445a
2022-02-12,PY,Paraguay,AMRO,2904,618815,50,17801
2022-02-13,PY,Paraguay,AMRO,1893,620708,43,17844
2022-02-14,PY,Paraguay,AMRO,1877,622585,38,17882
.
125674c
2022-02-11,PG,Papua New Guinea,WPRO,107,38329,0,610
2022-02-12,PG,Papua New Guinea,WPRO,152,38481,0,610
2022-02-13,PG,Papua New Guinea,WPRO,0,38481,0,610
2022-02-14,PG,Papua New Guinea,WPRO,0,38481,0,610
.
124903a
2022-02-12,PA,Panama,AMRO,2424,737659,11,7909
2022-02-13,PA,Panama,AMRO,2111,739770,17,7926
2022-02-14,PA,Panama,AMRO,1881,741651,12,7938
.
124132a
2022-02-12,PW,Palau,WPRO,0,3045,0,0
2022-02-13,PW,Palau,WPRO,0,3045,0,0
2022-02-14,PW,Palau,WPRO,88,3133,1,1
.
123361a
2022-02-12,PK,Pakistan,EMRO,3498,1477573,39,29687
2022-02-13,PK,Pakistan,EMRO,3019,1480592,44,29731
2022-02-14,PK,Pakistan,EMRO,3206,1483798,41,29772
.
122590a
2022-02-12, ,Other,Other,0,764,0,13
2022-02-13, ,Other,Other,0,764,0,13
2022-02-14, ,Other,Other,0,764,0,13
.
121819a
2022-02-12,OM,Oman,EMRO,2064,363063,0,4195
2022-02-13,OM,Oman,EMRO,1295,364358,0,4195
2022-02-14,OM,Oman,EMRO,1342,365700,13,4208
.
121048c
2022-02-11,PS,"occupied Palestinian territory, including east Jerusalem",EMRO,5219,605347,20,5235
2022-02-12,PS,"occupied Palestinian territory, including east Jerusalem",EMRO,4040,609387,17,5252
2022-02-13,PS,"occupied Palestinian territory, including east Jerusalem",EMRO,1871,611258,13,5265
2022-02-14,PS,"occupied Palestinian territory, including east Jerusalem",EMRO,2588,613846,18,5283
.
120277a
2022-02-12,NO,Norway,EURO,4208,986851,0,1513
2022-02-13,NO,Norway,EURO,0,986851,0,1513
2022-02-14,NO,Norway,EURO,0,986851,0,1513
.
119506a
2022-02-12,MP,Northern Mariana Islands (Commonwealth of the),WPRO,189,7199,0,23
2022-02-13,MP,Northern Mariana Islands (Commonwealth of the),WPRO,154,7353,0,23
2022-02-14,MP,Northern Mariana Islands (Commonwealth of the),WPRO,177,7530,0,23
.
118735a
2022-02-12,MK,North Macedonia,EURO,1328,284875,19,8705
2022-02-13,MK,North Macedonia,EURO,1221,286096,31,8736
2022-02-14,MK,North Macedonia,EURO,920,287016,11,8747
.
117964a
2022-02-12,NU,Niue,WPRO,0,0,0,0
2022-02-13,NU,Niue,WPRO,0,0,0,0
2022-02-14,NU,Niue,WPRO,0,0,0,0
.
117193a
2022-02-12,NG,Nigeria,AFRO,0,253875,0,3139
2022-02-13,NG,Nigeria,AFRO,95,253970,1,3140
2022-02-14,NG,Nigeria,AFRO,46,254016,1,3141
.
116422a
2022-02-12,NE,Niger,AFRO,4,8707,0,303
2022-02-13,NE,Niger,AFRO,2,8709,0,303
2022-02-14,NE,Niger,AFRO,2,8711,0,303
.
115651a
2022-02-12,NI,Nicaragua,AMRO,0,13792,0,222
2022-02-13,NI,Nicaragua,AMRO,0,13792,0,222
2022-02-14,NI,Nicaragua,AMRO,0,13792,0,222
.
114880c
2022-02-11,NZ,New Zealand,WPRO,476,18934,0,53
2022-02-12,NZ,New Zealand,WPRO,466,19400,0,53
2022-02-13,NZ,New Zealand,WPRO,789,20189,0,53
2022-02-14,NZ,New Zealand,WPRO,1006,21195,0,53
.
114109a
2022-02-12,NC,New Caledonia,WPRO,0,34132,0,284
2022-02-13,NC,New Caledonia,WPRO,0,34132,0,284
2022-02-14,NC,New Caledonia,WPRO,1047,35179,0,284
.
112954,113338c
2021-01-23,NL,Netherlands,EURO,5744,937582,82,13406
2021-01-24,NL,Netherlands,EURO,5446,943028,83,13489
2021-01-25,NL,Netherlands,EURO,4881,947909,35,13524
2021-01-26,NL,Netherlands,EURO,4089,951998,45,13569
2021-01-27,NL,Netherlands,EURO,3959,955957,80,13649
2021-01-28,NL,Netherlands,EURO,4725,960682,72,13721
2021-01-29,NL,Netherlands,EURO,4691,965373,76,13797
2021-01-30,NL,Netherlands,EURO,4397,969770,66,13863
2021-01-31,NL,Netherlands,EURO,4172,973942,79,13942
2021-02-01,NL,Netherlands,EURO,3677,977619,39,13981
2021-02-02,NL,Netherlands,EURO,3238,980857,38,14019
2021-02-03,NL,Netherlands,EURO,3548,984405,77,14096
2021-02-04,NL,Netherlands,EURO,4018,988423,60,14156
2021-02-05,NL,Netherlands,EURO,4199,992622,65,14221
2021-02-06,NL,Netherlands,EURO,4317,996939,62,14283
2021-02-07,NL,Netherlands,EURO,4088,1001027,60,14343
2021-02-08,NL,Netherlands,EURO,3918,1004945,45,14388
2021-02-09,NL,Netherlands,EURO,2257,1007202,30,14418
2021-02-10,NL,Netherlands,EURO,1759,1008961,87,14505
2021-02-11,NL,Netherlands,EURO,3173,1012134,82,14587
2021-02-12,NL,Netherlands,EURO,4427,1016561,65,14652
2021-02-13,NL,Netherlands,EURO,4327,1020888,80,14732
2021-02-14,NL,Netherlands,EURO,4172,1025060,48,14780
2021-02-15,NL,Netherlands,EURO,3425,1028485,28,14808
2021-02-16,NL,Netherlands,EURO,2842,1031327,23,14831
2021-02-17,NL,Netherlands,EURO,2690,1034017,93,14924
2021-02-18,NL,Netherlands,EURO,3368,1037385,94,15018
2021-02-19,NL,Netherlands,EURO,4558,1041943,67,15085
2021-02-20,NL,Netherlands,EURO,4676,1046619,46,15131
2021-02-21,NL,Netherlands,EURO,4539,1051158,62,15193
2021-02-22,NL,Netherlands,EURO,4669,1055827,20,15213
2021-02-23,NL,Netherlands,EURO,4179,1060006,33,15246
2021-02-24,NL,Netherlands,EURO,3809,1063815,93,15339
2021-02-25,NL,Netherlands,EURO,4368,1068183,63,15402
2021-02-26,NL,Netherlands,EURO,4985,1073168,29,15431
2021-02-27,NL,Netherlands,EURO,5089,1078257,71,15502
2021-02-28,NL,Netherlands,EURO,4922,1083179,37,15539
2021-03-01,NL,Netherlands,EURO,4634,1087813,17,15556
2021-03-02,NL,Netherlands,EURO,3749,1091562,21,15577
2021-03-03,NL,Netherlands,EURO,3965,1095527,66,15643
2021-03-04,NL,Netherlands,EURO,5022,1100549,49,15692
2021-03-05,NL,Netherlands,EURO,4092,1104641,31,15723
2021-03-06,NL,Netherlands,EURO,4662,1109303,31,15754
2021-03-07,NL,Netherlands,EURO,5312,1114615,41,15795
2021-03-08,NL,Netherlands,EURO,4508,1119123,29,15824
2021-03-09,NL,Netherlands,EURO,3884,1123007,36,15860
2021-03-10,NL,Netherlands,EURO,4286,1127293,53,15913
2021-03-11,NL,Netherlands,EURO,5258,1132551,26,15939
2021-03-12,NL,Netherlands,EURO,5297,1137848,48,15987
2021-03-13,NL,Netherlands,EURO,5975,1143823,30,16017
2021-03-14,NL,Netherlands,EURO,6375,1150198,19,16036
2021-03-15,NL,Netherlands,EURO,5953,1156151,24,16060
2021-03-16,NL,Netherlands,EURO,5502,1161653,22,16082
2021-03-17,NL,Netherlands,EURO,4942,1166595,30,16112
2021-03-18,NL,Netherlands,EURO,5908,1172503,47,16159
2021-03-19,NL,Netherlands,EURO,6131,1178634,34,16193
2021-03-20,NL,Netherlands,EURO,7348,1185982,41,16234
2021-03-21,NL,Netherlands,EURO,7602,1193584,18,16252
2021-03-22,NL,Netherlands,EURO,6970,1200554,16,16268
2021-03-23,NL,Netherlands,EURO,6300,1206854,15,16283
2021-03-24,NL,Netherlands,EURO,5608,1212462,53,16336
2021-03-25,NL,Netherlands,EURO,7556,1220018,27,16363
2021-03-26,NL,Netherlands,EURO,7688,1227706,26,16389
2021-03-27,NL,Netherlands,EURO,7557,1235263,22,16411
2021-03-28,NL,Netherlands,EURO,8782,1244045,29,16440
2021-03-29,NL,Netherlands,EURO,7470,1251515,14,16454
2021-03-30,NL,Netherlands,EURO,6781,1258296,13,16467
2021-03-31,NL,Netherlands,EURO,5855,1264151,35,16502
2021-04-01,NL,Netherlands,EURO,7629,1271780,31,16533
2021-04-02,NL,Netherlands,EURO,7819,1279599,19,16552
2021-04-03,NL,Netherlands,EURO,7214,1286813,16,16568
2021-04-04,NL,Netherlands,EURO,7597,1294410,30,16598
2021-04-05,NL,Netherlands,EURO,6862,1301272,15,16613
2021-04-06,NL,Netherlands,EURO,5334,1306606,8,16621
2021-04-07,NL,Netherlands,EURO,5559,1312165,23,16644
2021-04-08,NL,Netherlands,EURO,6368,1318533,23,16667
2021-04-09,NL,Netherlands,EURO,7761,1326294,21,16688
2021-04-10,NL,Netherlands,EURO,7660,1333954,41,16729
2021-04-11,NL,Netherlands,EURO,7659,1341613,21,16750
2021-04-12,NL,Netherlands,EURO,8142,1349755,14,16764
2021-04-13,NL,Netherlands,EURO,6658,1356413,19,16783
2021-04-14,NL,Netherlands,EURO,6722,1363135,34,16817
2021-04-15,NL,Netherlands,EURO,5440,1368575,26,16843
2021-04-16,NL,Netherlands,EURO,8694,1377269,12,16855
2021-04-17,NL,Netherlands,EURO,8890,1386159,18,16873
2021-04-18,NL,Netherlands,EURO,8253,1394412,26,16899
2021-04-19,NL,Netherlands,EURO,8522,1402934,13,16912
2021-04-20,NL,Netherlands,EURO,7158,1410092,22,16934
2021-04-21,NL,Netherlands,EURO,6821,1416913,26,16960
2021-04-22,NL,Netherlands,EURO,8472,1425385,18,16978
2021-04-23,NL,Netherlands,EURO,9579,1434964,19,16997
2021-04-24,NL,Netherlands,EURO,9235,1444199,18,17015
2021-04-25,NL,Netherlands,EURO,8062,1452261,17,17032
2021-04-26,NL,Netherlands,EURO,8020,1460281,14,17046
2021-04-27,NL,Netherlands,EURO,6226,1466507,14,17060
2021-04-28,NL,Netherlands,EURO,5305,1471812,27,17087
2021-04-29,NL,Netherlands,EURO,8651,1480463,16,17103
2021-04-30,NL,Netherlands,EURO,7283,1487746,16,17119
2021-05-01,NL,Netherlands,EURO,7764,1495510,26,17145
2021-05-02,NL,Netherlands,EURO,5783,1501293,18,17163
2021-05-03,NL,Netherlands,EURO,5461,1506754,3,17166
2021-05-04,NL,Netherlands,EURO,9186,1515940,21,17187
2021-05-05,NL,Netherlands,EURO,7758,1523698,29,17216
2021-05-06,NL,Netherlands,EURO,7246,1530944,30,17246
2021-05-07,NL,Netherlands,EURO,6753,1537697,18,17264
2021-05-08,NL,Netherlands,EURO,7459,1545156,25,17289
2021-05-09,NL,Netherlands,EURO,7424,1552580,27,17316
2021-05-10,NL,Netherlands,EURO,6636,1559216,2,17318
2021-05-11,NL,Netherlands,EURO,5861,1565077,19,17337
2021-05-12,NL,Netherlands,EURO,5525,1570602,43,17380
2021-05-13,NL,Netherlands,EURO,6341,1576943,18,17398
2021-05-14,NL,Netherlands,EURO,6012,1582955,11,17409
2021-05-15,NL,Netherlands,EURO,5543,1588498,11,17420
2021-05-16,NL,Netherlands,EURO,4472,1592970,13,17433
2021-05-17,NL,Netherlands,EURO,4424,1597394,15,17448
2021-05-18,NL,Netherlands,EURO,2858,1600252,7,17455
2021-05-19,NL,Netherlands,EURO,5325,1605577,13,17468
2021-05-20,NL,Netherlands,EURO,4548,1610125,16,17484
2021-05-21,NL,Netherlands,EURO,4616,1614741,19,17503
2021-05-22,NL,Netherlands,EURO,4138,1618879,11,17514
2021-05-23,NL,Netherlands,EURO,3173,1622052,20,17534
2021-05-24,NL,Netherlands,EURO,3423,1625475,6,17540
2021-05-25,NL,Netherlands,EURO,2728,1628203,13,17553
2021-05-26,NL,Netherlands,EURO,2484,1630687,15,17568
2021-05-27,NL,Netherlands,EURO,2738,1633425,6,17574
2021-05-28,NL,Netherlands,EURO,3375,1636800,18,17592
2021-05-29,NL,Netherlands,EURO,3838,1640638,15,17607
2021-05-30,NL,Netherlands,EURO,3345,1643983,7,17614
2021-05-31,NL,Netherlands,EURO,2622,1646605,7,17621
2021-06-01,NL,Netherlands,EURO,2020,1648625,2,17623
2021-06-02,NL,Netherlands,EURO,2480,1651105,8,17631
2021-06-03,NL,Netherlands,EURO,2559,1653664,11,17642
2021-06-04,NL,Netherlands,EURO,2761,1656425,13,17655
2021-06-05,NL,Netherlands,EURO,2395,1658820,10,17665
2021-06-06,NL,Netherlands,EURO,2118,1660938,6,17671
2021-06-07,NL,Netherlands,EURO,1568,1662506,3,17674
2021-06-08,NL,Netherlands,EURO,1468,1663974,4,17678
2021-06-09,NL,Netherlands,EURO,1436,1665410,13,17691
2021-06-10,NL,Netherlands,EURO,1751,1667161,6,17697
2021-06-11,NL,Netherlands,EURO,1577,1668738,4,17701
2021-06-12,NL,Netherlands,EURO,1387,1670125,3,17704
2021-06-13,NL,Netherlands,EURO,1239,1671364,1,17705
2021-06-14,NL,Netherlands,EURO,1041,1672405,3,17708
2021-06-15,NL,Netherlands,EURO,879,1673284,3,17711
2021-06-16,NL,Netherlands,EURO,1040,1674324,1,17712
2021-06-17,NL,Netherlands,EURO,1024,1675348,4,17716
2021-06-18,NL,Netherlands,EURO,1059,1676407,4,17720
2021-06-19,NL,Netherlands,EURO,890,1677297,3,17723
2021-06-20,NL,Netherlands,EURO,692,1677989,1,17724
2021-06-21,NL,Netherlands,EURO,710,1678699,1,17725
2021-06-22,NL,Netherlands,EURO,569,1679268,1,17726
2021-06-23,NL,Netherlands,EURO,698,1679966,6,17732
2021-06-24,NL,Netherlands,EURO,665,1680631,1,17733
2021-06-25,NL,Netherlands,EURO,696,1681327,1,17734
2021-06-26,NL,Netherlands,EURO,646,1681973,5,17739
2021-06-27,NL,Netherlands,EURO,555,1682528,0,17739
2021-06-28,NL,Netherlands,EURO,501,1683029,1,17740
2021-06-29,NL,Netherlands,EURO,567,1683596,0,17740
2021-06-30,NL,Netherlands,EURO,528,1684124,4,17744
2021-07-01,NL,Netherlands,EURO,636,1684760,0,17744
2021-07-02,NL,Netherlands,EURO,822,1685582,4,17748
2021-07-03,NL,Netherlands,EURO,940,1686522,6,17754
2021-07-04,NL,Netherlands,EURO,1120,1687642,1,17755
2021-07-05,NL,Netherlands,EURO,1200,1688842,0,17755
2021-07-06,NL,Netherlands,EURO,1512,1690354,1,17756
2021-07-07,NL,Netherlands,EURO,2192,1692546,1,17757
2021-07-08,NL,Netherlands,EURO,3601,1696147,2,17759
2021-07-09,NL,Netherlands,EURO,5393,1701540,2,17761
2021-07-10,NL,Netherlands,EURO,6882,1708422,2,17763
2021-07-11,NL,Netherlands,EURO,10224,1718646,1,17764
2021-07-12,NL,Netherlands,EURO,9303,1727949,1,17765
2021-07-13,NL,Netherlands,EURO,8431,1736380,0,17765
2021-07-14,NL,Netherlands,EURO,7802,1744182,3,17768
2021-07-15,NL,Netherlands,EURO,10405,1754587,1,17769
2021-07-16,NL,Netherlands,EURO,10978,1765565,3,17772
2021-07-17,NL,Netherlands,EURO,11258,1776823,2,17774
2021-07-18,NL,Netherlands,EURO,11050,1787873,0,17774
2021-07-19,NL,Netherlands,EURO,10183,1798056,1,17775
2021-07-20,NL,Netherlands,EURO,8874,1806930,2,17777
2021-07-21,NL,Netherlands,EURO,6776,1813706,5,17782
2021-07-22,NL,Netherlands,EURO,6856,1820562,3,17785
2021-07-23,NL,Netherlands,EURO,6233,1826795,3,17788
2021-07-24,NL,Netherlands,EURO,6370,1833165,3,17791
2021-07-25,NL,Netherlands,EURO,5259,1838424,4,17795
2021-07-26,NL,Netherlands,EURO,4607,1843031,4,17799
2021-07-27,NL,Netherlands,EURO,3834,1846865,1,17800
2021-07-28,NL,Netherlands,EURO,3979,1850844,3,17803
2021-07-29,NL,Netherlands,EURO,3444,1854288,8,17811
2021-07-30,NL,Netherlands,EURO,4452,1858740,3,17814
2021-07-31,NL,Netherlands,EURO,3432,1862172,6,17820
2021-08-01,NL,Netherlands,EURO,2942,1865114,6,17826
2021-08-02,NL,Netherlands,EURO,2313,1867427,2,17828
2021-08-03,NL,Netherlands,EURO,2099,1869526,0,17828
2021-08-04,NL,Netherlands,EURO,2209,1871735,3,17831
2021-08-05,NL,Netherlands,EURO,2792,1874527,7,17838
2021-08-06,NL,Netherlands,EURO,3331,1877858,11,17849
2021-08-07,NL,Netherlands,EURO,2901,1880759,8,17857
2021-08-08,NL,Netherlands,EURO,2396,1883155,9,17866
2021-08-09,NL,Netherlands,EURO,2307,1885462,2,17868
2021-08-10,NL,Netherlands,EURO,2037,1887499,2,17870
2021-08-11,NL,Netherlands,EURO,2162,1889661,7,17877
2021-08-12,NL,Netherlands,EURO,2119,1891780,9,17886
2021-08-13,NL,Netherlands,EURO,2566,1894346,7,17893
2021-08-14,NL,Netherlands,EURO,2664,1897010,6,17899
2021-08-15,NL,Netherlands,EURO,2304,1899314,6,17905
2021-08-16,NL,Netherlands,EURO,2260,1901574,3,17908
2021-08-17,NL,Netherlands,EURO,2236,1903810,6,17914
2021-08-18,NL,Netherlands,EURO,2304,1906114,5,17919
2021-08-19,NL,Netherlands,EURO,2785,1908899,7,17926
2021-08-20,NL,Netherlands,EURO,2484,1911383,6,17932
2021-08-21,NL,Netherlands,EURO,2208,1913591,6,17938
2021-08-22,NL,Netherlands,EURO,2440,1916031,8,17946
2021-08-23,NL,Netherlands,EURO,2461,1918492,6,17952
2021-08-24,NL,Netherlands,EURO,2382,1920874,4,17956
2021-08-25,NL,Netherlands,EURO,2460,1923334,11,17967
2021-08-26,NL,Netherlands,EURO,2816,1926150,7,17974
2021-08-27,NL,Netherlands,EURO,2613,1928763,7,17981
2021-08-28,NL,Netherlands,EURO,2798,1931561,4,17985
2021-08-29,NL,Netherlands,EURO,2450,1934011,9,17994
2021-08-30,NL,Netherlands,EURO,2311,1936322,2,17996
2021-08-31,NL,Netherlands,EURO,2171,1938493,2,17998
2021-09-01,NL,Netherlands,EURO,2274,1940767,12,18010
2021-09-02,NL,Netherlands,EURO,2788,1943555,2,18012
2021-09-03,NL,Netherlands,EURO,2789,1946344,5,18017
2021-09-04,NL,Netherlands,EURO,2530,1948874,9,18026
2021-09-05,NL,Netherlands,EURO,2748,1951622,9,18035
2021-09-06,NL,Netherlands,EURO,2358,1953980,2,18037
2021-09-07,NL,Netherlands,EURO,2114,1956094,3,18040
2021-09-08,NL,Netherlands,EURO,2472,1958566,8,18048
2021-09-09,NL,Netherlands,EURO,2794,1961360,7,18055
2021-09-10,NL,Netherlands,EURO,2357,1963717,3,18058
2021-09-11,NL,Netherlands,EURO,2676,1966393,4,18062
2021-09-12,NL,Netherlands,EURO,2208,1968601,6,18068
2021-09-13,NL,Netherlands,EURO,2095,1970696,1,18069
2021-09-14,NL,Netherlands,EURO,1752,1972448,4,18073
2021-09-15,NL,Netherlands,EURO,2001,1974449,10,18083
2021-09-16,NL,Netherlands,EURO,2375,1976824,7,18090
2021-09-17,NL,Netherlands,EURO,2090,1978914,7,18097
2021-09-18,NL,Netherlands,EURO,2126,1981040,10,18107
2021-09-19,NL,Netherlands,EURO,2014,1983054,4,18111
2021-09-20,NL,Netherlands,EURO,1664,1984718,3,18114
2021-09-21,NL,Netherlands,EURO,1353,1986071,9,18123
2021-09-22,NL,Netherlands,EURO,1663,1987734,5,18128
2021-09-23,NL,Netherlands,EURO,1894,1989628,4,18132
2021-09-24,NL,Netherlands,EURO,1810,1991438,12,18144
2021-09-25,NL,Netherlands,EURO,1693,1993131,3,18147
2021-09-26,NL,Netherlands,EURO,1600,1994731,2,18149
2021-09-27,NL,Netherlands,EURO,1599,1996330,1,18150
2021-09-28,NL,Netherlands,EURO,1386,1997716,4,18154
2021-09-29,NL,Netherlands,EURO,1717,1999433,8,18162
2021-09-30,NL,Netherlands,EURO,1751,2001184,6,18168
2021-10-01,NL,Netherlands,EURO,1701,2002885,2,18170
2021-10-02,NL,Netherlands,EURO,1717,2004602,6,18176
2021-10-03,NL,Netherlands,EURO,1669,2006271,5,18181
2021-10-04,NL,Netherlands,EURO,1602,2007873,1,18182
2021-10-05,NL,Netherlands,EURO,1610,2009483,2,18184
2021-10-06,NL,Netherlands,EURO,1899,2011382,7,18191
2021-10-07,NL,Netherlands,EURO,1904,2013286,3,18194
2021-10-08,NL,Netherlands,EURO,2733,2016019,6,18200
2021-10-09,NL,Netherlands,EURO,2769,2018788,2,18202
2021-10-10,NL,Netherlands,EURO,2483,2021271,2,18204
2021-10-11,NL,Netherlands,EURO,2735,2024006,0,18204
2021-10-12,NL,Netherlands,EURO,2249,2026255,5,18209
2021-10-13,NL,Netherlands,EURO,2883,2029138,6,18215
2021-10-14,NL,Netherlands,EURO,3718,2032856,12,18227
2021-10-15,NL,Netherlands,EURO,3635,2036491,4,18231
2021-10-16,NL,Netherlands,EURO,3695,2040186,6,18237
2021-10-17,NL,Netherlands,EURO,3691,2043877,5,18242
2021-10-18,NL,Netherlands,EURO,3659,2047536,6,18248
2021-10-19,NL,Netherlands,EURO,3348,2050884,1,18249
2021-10-20,NL,Netherlands,EURO,3914,2054798,13,18262
2021-10-21,NL,Netherlands,EURO,4582,2059380,9,18271
2021-10-22,NL,Netherlands,EURO,5177,2064557,7,18278
2021-10-23,NL,Netherlands,EURO,5836,2070393,10,18288
2021-10-24,NL,Netherlands,EURO,5671,2076064,25,18313
2021-10-25,NL,Netherlands,EURO,6303,2082367,1,18314
2021-10-26,NL,Netherlands,EURO,5298,2087665,6,18320
2021-10-27,NL,Netherlands,EURO,5754,2093419,19,18339
2021-10-28,NL,Netherlands,EURO,7262,2100681,17,18356
2021-10-29,NL,Netherlands,EURO,7666,2108347,15,18371
2021-10-30,NL,Netherlands,EURO,7387,2115734,13,18384
2021-10-31,NL,Netherlands,EURO,7941,2123675,13,18397
2021-11-01,NL,Netherlands,EURO,8151,2131826,14,18411
2021-11-02,NL,Netherlands,EURO,7690,2139516,11,18422
2021-11-03,NL,Netherlands,EURO,7692,2147208,18,18440
2021-11-04,NL,Netherlands,EURO,9146,2156354,33,18473
2021-11-05,NL,Netherlands,EURO,10204,2166558,24,18497
2021-11-06,NL,Netherlands,EURO,10874,2177432,20,18517
2021-11-07,NL,Netherlands,EURO,11970,2189402,36,18553
2021-11-08,NL,Netherlands,EURO,11340,2200742,8,18561
2021-11-09,NL,Netherlands,EURO,11757,2212499,22,18583
2021-11-10,NL,Netherlands,EURO,11284,2223783,28,18611
2021-11-11,NL,Netherlands,EURO,12645,2236428,25,18636
2021-11-12,NL,Netherlands,EURO,16249,2252677,25,18661
2021-11-13,NL,Netherlands,EURO,16051,2268728,31,18692
2021-11-14,NL,Netherlands,EURO,13801,2282529,32,18724
2021-11-15,NL,Netherlands,EURO,11976,2294505,7,18731
2021-11-16,NL,Netherlands,EURO,19192,2313697,16,18747
2021-11-17,NL,Netherlands,EURO,20143,2333840,35,18782
2021-11-18,NL,Netherlands,EURO,20705,2354545,44,18826
2021-11-19,NL,Netherlands,EURO,23563,2378108,34,18860
2021-11-20,NL,Netherlands,EURO,20973,2399081,39,18899
2021-11-21,NL,Netherlands,EURO,21758,2420839,55,18954
2021-11-22,NL,Netherlands,EURO,20632,2441471,11,18965
2021-11-23,NL,Netherlands,EURO,22986,2464457,29,18994
2021-11-24,NL,Netherlands,EURO,22949,2487406,53,19047
2021-11-25,NL,Netherlands,EURO,23700,2511106,50,19097
2021-11-26,NL,Netherlands,EURO,22174,2533280,61,19158
2021-11-27,NL,Netherlands,EURO,21264,2554544,59,19217
2021-11-28,NL,Netherlands,EURO,21990,2576534,54,19271
2021-11-29,NL,Netherlands,EURO,22067,2598601,43,19314
2021-11-30,NL,Netherlands,EURO,21454,2620055,33,19347
2021-12-01,NL,Netherlands,EURO,22058,2642113,65,19412
2021-12-02,NL,Netherlands,EURO,18497,2660610,43,19455
2021-12-03,NL,Netherlands,EURO,23031,2683641,65,19520
2021-12-04,NL,Netherlands,EURO,21480,2705121,62,19582
2021-12-05,NL,Netherlands,EURO,22600,2727721,56,19638
2021-12-06,NL,Netherlands,EURO,23051,2750772,26,19664
2021-12-07,NL,Netherlands,EURO,20977,2771749,34,19698
2021-12-08,NL,Netherlands,EURO,17942,2789691,68,19766
2021-12-09,NL,Netherlands,EURO,18055,2807746,71,19837
2021-12-10,NL,Netherlands,EURO,19731,2827477,78,19915
2021-12-11,NL,Netherlands,EURO,17445,2844922,84,19999
2021-12-12,NL,Netherlands,EURO,17746,2862668,69,20068
2021-12-13,NL,Netherlands,EURO,16604,2879272,39,20107
2021-12-14,NL,Netherlands,EURO,13790,2893062,28,20135
2021-12-15,NL,Netherlands,EURO,12796,2905858,74,20209
2021-12-16,NL,Netherlands,EURO,13496,2919354,41,20250
2021-12-17,NL,Netherlands,EURO,16348,2935702,54,20304
2021-12-18,NL,Netherlands,EURO,15338,2951040,59,20363
2021-12-19,NL,Netherlands,EURO,14661,2965701,50,20413
2021-12-20,NL,Netherlands,EURO,13256,2978957,48,20461
2021-12-21,NL,Netherlands,EURO,12141,2991098,35,20496
2021-12-22,NL,Netherlands,EURO,9392,3000490,31,20527
2021-12-23,NL,Netherlands,EURO,13397,3013887,48,20575
2021-12-24,NL,Netherlands,EURO,13315,3027202,40,20615
2021-12-25,NL,Netherlands,EURO,12468,3039670,40,20655
2021-12-26,NL,Netherlands,EURO,12555,3052225,45,20700
2021-12-27,NL,Netherlands,EURO,11893,3064118,11,20711
2021-12-28,NL,Netherlands,EURO,11429,3075547,12,20723
2021-12-29,NL,Netherlands,EURO,9134,3084681,75,20798
2021-12-30,NL,Netherlands,EURO,15696,3100377,50,20848
2021-12-31,NL,Netherlands,EURO,14760,3115137,40,20888
2022-01-01,NL,Netherlands,EURO,16681,3131818,33,20921
2022-01-02,NL,Netherlands,EURO,15582,3147400,27,20948
2022-01-03,NL,Netherlands,EURO,17424,3164824,6,20954
2022-01-04,NL,Netherlands,EURO,14493,3179317,14,20968
2022-01-05,NL,Netherlands,EURO,18505,3197822,19,20987
2022-01-06,NL,Netherlands,EURO,24439,3222261,38,21025
2022-01-07,NL,Netherlands,EURO,24524,3246785,12,21037
2022-01-08,NL,Netherlands,EURO,34727,3281512,24,21061
2022-01-09,NL,Netherlands,EURO,27783,3309295,8,21069
2022-01-10,NL,Netherlands,EURO,32332,3341627,7,21076
2022-01-11,NL,Netherlands,EURO,27739,3369366,7,21083
2022-01-12,NL,Netherlands,EURO,28851,3398217,18,21101
2022-01-13,NL,Netherlands,EURO,31906,3430123,8,21109
2022-01-14,NL,Netherlands,EURO,33147,3463270,13,21122
2022-01-15,NL,Netherlands,EURO,35196,3498466,16,21138
2022-01-16,NL,Netherlands,EURO,31630,3530096,6,21144
2022-01-17,NL,Netherlands,EURO,35773,3565869,7,21151
2022-01-18,NL,Netherlands,EURO,41773,3607642,3,21154
2022-01-19,NL,Netherlands,EURO,31023,3638665,10,21164
2022-01-20,NL,Netherlands,EURO,37985,3676650,10,21174
2022-01-21,NL,Netherlands,EURO,39727,3716377,10,21184
2022-01-22,NL,Netherlands,EURO,57192,3773569,11,21195
2022-01-23,NL,Netherlands,EURO,45766,3819335,8,21203
2022-01-24,NL,Netherlands,EURO,64664,3883999,1,21204
2022-01-25,NL,Netherlands,EURO,64094,3948093,8,21212
2022-01-26,NL,Netherlands,EURO,53485,4001578,7,21219
2022-01-27,NL,Netherlands,EURO,57886,4059464,11,21230
2022-01-28,NL,Netherlands,EURO,64018,4123482,14,21244
2022-01-29,NL,Netherlands,EURO,73150,4196632,8,21252
2022-01-30,NL,Netherlands,EURO,38920,4235552,8,21260
2022-01-31,NL,Netherlands,EURO,74515,4310067,2,21262
2022-02-01,NL,Netherlands,EURO,110839,4420906,5,21267
2022-02-02,NL,Netherlands,EURO,104662,4525568,15,21282
2022-02-03,NL,Netherlands,EURO,66109,4591677,10,21292
2022-02-04,NL,Netherlands,EURO,81101,4672778,10,21302
2022-02-05,NL,Netherlands,EURO,71331,4744109,5,21307
2022-02-06,NL,Netherlands,EURO,52982,4797091,10,21317
2022-02-07,NL,Netherlands,EURO,80009,4877100,7,21324
2022-02-08,NL,Netherlands,EURO,78496,4955596,4,21328
2022-02-09,NL,Netherlands,EURO,394325,5349921,8,21336
2022-02-10,NL,Netherlands,EURO,86547,5436468,7,21343
2022-02-11,NL,Netherlands,EURO,86760,5523228,15,21358
2022-02-12,NL,Netherlands,EURO,80669,5603897,19,21377
2022-02-13,NL,Netherlands,EURO,70348,5674245,12,21389
2022-02-14,NL,Netherlands,EURO,60227,5734472,7,21396
.
112567a
2022-02-12,NP,Nepal,SEARO,491,972632,4,11882
2022-02-13,NP,Nepal,SEARO,427,973059,10,11892
2022-02-14,NP,Nepal,SEARO,482,973541,8,11900
.
111796a
2022-02-12,NR,Nauru,WPRO,0,0,0,0
2022-02-13,NR,Nauru,WPRO,0,0,0,0
2022-02-14,NR,Nauru,WPRO,0,0,0,0
.
111025a
2022-02-12,NA,Namibia,AFRO,41,156604,3,3991
2022-02-13,NA,Namibia,AFRO,0,156604,0,3991
2022-02-14,NA,Namibia,AFRO,0,156604,0,3991
.
110254c
2022-02-11,MM,Myanmar,SEARO,1607,543511,0,19310
2022-02-12,MM,Myanmar,SEARO,1787,545298,0,19310
2022-02-13,MM,Myanmar,SEARO,1473,546771,0,19310
2022-02-14,MM,Myanmar,SEARO,0,546771,0,19310
.
109483a
2022-02-12,MZ,Mozambique,AFRO,44,224603,0,2188
2022-02-13,MZ,Mozambique,AFRO,50,224653,1,2189
2022-02-14,MZ,Mozambique,AFRO,50,224703,0,2189
.
108712c
2022-02-11,MA,Morocco,EMRO,1333,1152414,29,15727
2022-02-12,MA,Morocco,EMRO,1148,1153562,20,15747
2022-02-13,MA,Morocco,EMRO,969,1154531,19,15766
2022-02-14,MA,Morocco,EMRO,634,1155165,15,15781
.
107941a
2022-02-12,MS,Montserrat,AMRO,0,163,0,2
2022-02-13,MS,Montserrat,AMRO,0,163,0,2
2022-02-14,MS,Montserrat,AMRO,0,163,0,2
.
107160,107170c
2022-02-01,ME,Montenegro,EURO,470,219836,3,2555
2022-02-02,ME,Montenegro,EURO,811,220647,9,2564
2022-02-03,ME,Montenegro,EURO,613,221260,4,2568
2022-02-04,ME,Montenegro,EURO,693,221953,14,2582
2022-02-05,ME,Montenegro,EURO,531,222484,9,2591
2022-02-06,ME,Montenegro,EURO,535,223019,5,2596
2022-02-07,ME,Montenegro,EURO,511,223530,3,2599
2022-02-08,ME,Montenegro,EURO,294,223824,2,2601
2022-02-09,ME,Montenegro,EURO,579,224403,9,2610
2022-02-10,ME,Montenegro,EURO,410,224813,3,2613
2022-02-11,ME,Montenegro,EURO,450,225263,9,2622
2022-02-12,ME,Montenegro,EURO,480,225743,2,2624
2022-02-13,ME,Montenegro,EURO,394,226137,8,2632
2022-02-14,ME,Montenegro,EURO,325,226462,2,2634
.
107098,107099c
2021-12-01,ME,Montenegro,EURO,282,157385,15,2308
2021-12-02,ME,Montenegro,EURO,243,157628,-1,2307
.
106393,106399c
2022-02-05,MN,Mongolia,WPRO,902,855981,4,2049
2022-02-06,MN,Mongolia,WPRO,3032,859013,3,2052
2022-02-07,MN,Mongolia,WPRO,1963,860976,3,2055
2022-02-08,MN,Mongolia,WPRO,2396,863372,0,2055
2022-02-09,MN,Mongolia,WPRO,5795,869167,4,2059
2022-02-10,MN,Mongolia,WPRO,3771,872938,3,2062
2022-02-11,MN,Mongolia,WPRO,3799,876737,3,2065
2022-02-12,MN,Mongolia,WPRO,4157,880894,2,2067
2022-02-13,MN,Mongolia,WPRO,2771,883665,5,2072
2022-02-14,MN,Mongolia,WPRO,1889,885554,2,2074
.
105628a
2022-02-12,MC,Monaco,EURO,32,8988,0,49
2022-02-13,MC,Monaco,EURO,32,9020,1,50
2022-02-14,MC,Monaco,EURO,1,9021,0,50
.
104857a
2022-02-12,FM,Micronesia (Federated States of),WPRO,0,0,0,0
2022-02-13,FM,Micronesia (Federated States of),WPRO,0,0,0,0
2022-02-14,FM,Micronesia (Federated States of),WPRO,0,0,0,0
.
104086a
2022-02-12,MX,Mexico,AMRO,34261,5226269,927,311554
2022-02-13,MX,Mexico,AMRO,31336,5257605,564,312118
2022-02-14,MX,Mexico,AMRO,26247,5283852,579,312697
.
103315a
2022-02-12,YT,Mayotte,AFRO,0,36572,0,187
2022-02-13,YT,Mayotte,AFRO,0,36572,0,187
2022-02-14,YT,Mayotte,AFRO,0,36572,0,187
.
102544a
2022-02-12,MU,Mauritius,AFRO,0,70862,0,786
2022-02-13,MU,Mauritius,AFRO,0,70862,0,786
2022-02-14,MU,Mauritius,AFRO,0,70862,0,786
.
101773a
2022-02-12,MR,Mauritania,AFRO,15,58557,0,971
2022-02-13,MR,Mauritania,AFRO,6,58563,1,972
2022-02-14,MR,Mauritania,AFRO,6,58569,0,972
.
101002a
2022-02-12,MQ,Martinique,AMRO,1314,104060,0,856
2022-02-13,MQ,Martinique,AMRO,1037,105097,1,857
2022-02-14,MQ,Martinique,AMRO,0,105097,0,857
.
100231a
2022-02-12,MH,Marshall Islands,WPRO,0,4,0,0
2022-02-13,MH,Marshall Islands,WPRO,0,4,0,0
2022-02-14,MH,Marshall Islands,WPRO,0,4,0,0
.
99460a
2022-02-12,MT,Malta,EURO,143,69791,3,579
2022-02-13,MT,Malta,EURO,107,69898,6,585
2022-02-14,MT,Malta,EURO,116,70014,4,589
.
98689a
2022-02-12,ML,Mali,AFRO,24,30252,0,715
2022-02-13,ML,Mali,AFRO,0,30252,0,715
2022-02-14,ML,Mali,AFRO,14,30266,1,716
.
97918c
2022-02-11,MV,Maldives,SEARO,986,156903,0,287
2022-02-12,MV,Maldives,SEARO,1128,158031,1,288
2022-02-13,MV,Maldives,SEARO,1030,159061,1,289
2022-02-14,MV,Maldives,SEARO,0,159061,0,289
.
97147a
2022-02-12,MY,Malaysia,WPRO,20939,2996361,24,32099
2022-02-13,MY,Malaysia,WPRO,22802,3019163,15,32114
2022-02-14,MY,Malaysia,WPRO,21072,3040235,11,32125
.
96376a
2022-02-12,MW,Malawi,AFRO,38,84974,5,2591
2022-02-13,MW,Malawi,AFRO,35,85009,3,2594
2022-02-14,MW,Malawi,AFRO,16,85025,2,2596
.
95605a
2022-02-12,MG,Madagascar,AFRO,0,61434,0,1307
2022-02-13,MG,Madagascar,AFRO,1410,62844,28,1335
2022-02-14,MG,Madagascar,AFRO,0,62844,0,1335
.
94834a
2022-02-12,LU,Luxembourg,EURO,917,173419,1,969
2022-02-13,LU,Luxembourg,EURO,0,173419,0,969
2022-02-14,LU,Luxembourg,EURO,0,173419,0,969
.
94063a
2022-02-12,LT,Lithuania,EURO,10369,807861,28,8090
2022-02-13,LT,Lithuania,EURO,8000,815861,24,8114
2022-02-14,LT,Lithuania,EURO,4270,820131,20,8134
.
93291,93292c
2022-02-10,LI,Liechtenstein,EURO,143,10419,0,70
2022-02-11,LI,Liechtenstein,EURO,101,10520,0,70
2022-02-12,LI,Liechtenstein,EURO,0,10520,0,70
2022-02-13,LI,Liechtenstein,EURO,0,10520,0,70
2022-02-14,LI,Liechtenstein,EURO,0,10520,0,70
.
92810,92848c
2020-10-17,LI,Liechtenstein,EURO,19,221,0,1
2020-10-18,LI,Liechtenstein,EURO,6,227,0,1
2020-10-19,LI,Liechtenstein,EURO,2,229,0,1
2020-10-20,LI,Liechtenstein,EURO,30,259,0,1
2020-10-21,LI,Liechtenstein,EURO,31,290,0,1
2020-10-22,LI,Liechtenstein,EURO,37,327,0,1
2020-10-23,LI,Liechtenstein,EURO,26,353,0,1
2020-10-24,LI,Liechtenstein,EURO,23,376,0,1
2020-10-25,LI,Liechtenstein,EURO,37,413,0,1
2020-10-26,LI,Liechtenstein,EURO,23,436,0,1
2020-10-27,LI,Liechtenstein,EURO,26,462,0,1
2020-10-28,LI,Liechtenstein,EURO,23,485,0,1
2020-10-29,LI,Liechtenstein,EURO,36,521,0,1
2020-10-30,LI,Liechtenstein,EURO,27,548,1,2
2020-10-31,LI,Liechtenstein,EURO,29,577,1,3
2020-11-01,LI,Liechtenstein,EURO,25,602,0,3
2020-11-02,LI,Liechtenstein,EURO,22,624,0,3
2020-11-03,LI,Liechtenstein,EURO,45,669,0,3
2020-11-04,LI,Liechtenstein,EURO,35,704,0,3
2020-11-05,LI,Liechtenstein,EURO,39,743,0,3
2020-11-06,LI,Liechtenstein,EURO,39,782,0,3
2020-11-07,LI,Liechtenstein,EURO,22,804,0,3
2020-11-08,LI,Liechtenstein,EURO,15,819,0,3
2020-11-09,LI,Liechtenstein,EURO,22,841,1,4
2020-11-10,LI,Liechtenstein,EURO,49,890,0,4
2020-11-11,LI,Liechtenstein,EURO,35,925,0,4
2020-11-12,LI,Liechtenstein,EURO,23,948,0,4
2020-11-13,LI,Liechtenstein,EURO,21,969,1,5
2020-11-14,LI,Liechtenstein,EURO,25,994,0,5
2020-11-15,LI,Liechtenstein,EURO,18,1012,1,6
2020-11-16,LI,Liechtenstein,EURO,11,1023,2,8
2020-11-17,LI,Liechtenstein,EURO,26,1049,1,9
2020-11-18,LI,Liechtenstein,EURO,35,1084,0,9
2020-11-19,LI,Liechtenstein,EURO,19,1103,0,9
2020-11-20,LI,Liechtenstein,EURO,19,1122,0,9
2020-11-21,LI,Liechtenstein,EURO,16,1138,0,9
2020-11-22,LI,Liechtenstein,EURO,14,1152,1,10
2020-11-23,LI,Liechtenstein,EURO,31,1183,3,13
2020-11-24,LI,Liechtenstein,EURO,27,1210,1,14
.
92521a
2022-02-12,LY,Libya,EMRO,3345,466666,6,6113
2022-02-13,LY,Libya,EMRO,0,466666,0,6113
2022-02-14,LY,Libya,EMRO,3648,470314,12,6125
.
91750a
2022-02-12,LR,Liberia,AFRO,0,7358,0,290
2022-02-13,LR,Liberia,AFRO,0,7358,0,290
2022-02-14,LR,Liberia,AFRO,1,7359,0,290
.
90979a
2022-02-12,LS,Lesotho,AFRO,0,32372,0,696
2022-02-13,LS,Lesotho,AFRO,0,32372,0,696
2022-02-14,LS,Lesotho,AFRO,0,32372,0,696
.
90208c
2022-02-11,LB,Lebanon,EMRO,6060,999155,20,9789
2022-02-12,LB,Lebanon,EMRO,6954,1006109,18,9807
2022-02-13,LB,Lebanon,EMRO,5935,1012044,17,9824
2022-02-14,LB,Lebanon,EMRO,4443,1016487,16,9840
.
89437a
2022-02-12,LV,Latvia,EURO,11797,500126,20,5007
2022-02-13,LV,Latvia,EURO,10707,510833,13,5020
2022-02-14,LV,Latvia,EURO,7789,518622,4,5024
.
88666a
2022-02-12,LA,Lao People's Democratic Republic,WPRO,424,138431,4,588
2022-02-13,LA,Lao People's Democratic Republic,WPRO,334,138765,3,591
2022-02-14,LA,Lao People's Democratic Republic,WPRO,263,139028,3,594
.
87895a
2022-02-12,KG,Kyrgyzstan,EURO,81,199971,4,2924
2022-02-13,KG,Kyrgyzstan,EURO,49,200020,3,2927
2022-02-14,KG,Kyrgyzstan,EURO,46,200066,3,2930
.
87124a
2022-02-12,KW,Kuwait,EMRO,2896,596785,1,2518
2022-02-13,KW,Kuwait,EMRO,2254,599039,1,2519
2022-02-14,KW,Kuwait,EMRO,2268,601307,1,2520
.
86353a
2022-02-12,XK,Kosovo[1],EURO,770,221653,2,3054
2022-02-13,XK,Kosovo[1],EURO,643,222296,4,3058
2022-02-14,XK,Kosovo[1],EURO,602,222898,6,3064
.
85582a
2022-02-12,KI,Kiribati,WPRO,0,2235,0,2
2022-02-13,KI,Kiribati,WPRO,0,2235,0,2
2022-02-14,KI,Kiribati,WPRO,313,2548,1,3
.
84811a
2022-02-12,KE,Kenya,AFRO,54,322388,0,5626
2022-02-13,KE,Kenya,AFRO,48,322436,3,5629
2022-02-14,KE,Kenya,AFRO,37,322473,2,5631
.
84040a
2022-02-12,KZ,Kazakhstan,EURO,2386,1375433,20,18756
2022-02-13,KZ,Kazakhstan,EURO,2027,1377460,15,18771
2022-02-14,KZ,Kazakhstan,EURO,1335,1378795,10,18781
.
83269a
2022-02-12,JO,Jordan,EMRO,18872,1436762,25,13456
2022-02-13,JO,Jordan,EMRO,14048,1450810,21,13477
2022-02-14,JO,Jordan,EMRO,17550,1468360,31,13508
.
82498a
2022-02-12,JE,Jersey,EURO,251,33969,0,106
2022-02-13,JE,Jersey,EURO,0,33969,0,106
2022-02-14,JE,Jersey,EURO,0,33969,0,106
.
81727a
2022-02-12,JP,Japan,WPRO,98173,3764458,142,20059
2022-02-13,JP,Japan,WPRO,67506,3831964,143,20202
2022-02-14,JP,Japan,WPRO,80234,3912198,157,20359
.
80956a
2022-02-12,JM,Jamaica,AMRO,143,126732,12,2720
2022-02-13,JM,Jamaica,AMRO,154,126886,18,2738
2022-02-14,JM,Jamaica,AMRO,0,126886,0,2738
.
80185a
2022-02-12,IT,Italy,EURO,67478,11991109,334,150555
2022-02-13,IT,Italy,EURO,62221,12053330,269,150824
2022-02-14,IT,Italy,EURO,52345,12105675,191,151015
.
79116,79414c
2021-04-19,IL,Israel,EURO,188,837490,4,6356
2021-04-20,IL,Israel,EURO,144,837634,3,6359
2021-04-21,IL,Israel,EURO,170,837804,4,6363
2021-04-22,IL,Israel,EURO,117,837921,2,6365
2021-04-23,IL,Israel,EURO,154,838075,2,6367
2021-04-24,IL,Israel,EURO,112,838187,5,6372
2021-04-25,IL,Israel,EURO,36,838223,4,6376
2021-04-26,IL,Israel,EURO,82,838305,1,6377
2021-04-27,IL,Israel,EURO,103,838408,3,6380
2021-04-28,IL,Israel,EURO,112,838520,6,6386
2021-04-29,IL,Israel,EURO,106,838626,0,6386
2021-04-30,IL,Israel,EURO,97,838723,2,6388
2021-05-01,IL,Israel,EURO,79,838802,2,6390
2021-05-02,IL,Israel,EURO,15,838817,2,6392
2021-05-03,IL,Israel,EURO,56,838873,1,6393
2021-05-04,IL,Israel,EURO,82,838955,3,6396
2021-05-05,IL,Israel,EURO,65,839020,2,6398
2021-05-06,IL,Israel,EURO,73,839093,2,6400
2021-05-07,IL,Israel,EURO,54,839147,2,6402
2021-05-08,IL,Israel,EURO,34,839181,2,6404
2021-05-09,IL,Israel,EURO,16,839197,1,6405
2021-05-10,IL,Israel,EURO,33,839230,1,6406
2021-05-11,IL,Israel,EURO,66,839296,2,6408
2021-05-12,IL,Israel,EURO,40,839336,1,6409
2021-05-13,IL,Israel,EURO,29,839365,1,6410
2021-05-14,IL,Israel,EURO,34,839399,2,6412
2021-05-15,IL,Israel,EURO,27,839426,0,6412
2021-05-16,IL,Israel,EURO,20,839446,1,6413
2021-05-17,IL,Israel,EURO,36,839482,1,6414
2021-05-18,IL,Israel,EURO,15,839497,3,6417
2021-05-19,IL,Israel,EURO,23,839520,0,6417
2021-05-20,IL,Israel,EURO,56,839576,0,6417
2021-05-21,IL,Israel,EURO,35,839611,0,6417
2021-05-22,IL,Israel,EURO,22,839633,2,6419
2021-05-23,IL,Israel,EURO,12,839645,0,6419
2021-05-24,IL,Israel,EURO,28,839673,1,6420
2021-05-25,IL,Israel,EURO,30,839703,1,6421
2021-05-26,IL,Israel,EURO,23,839726,1,6422
2021-05-27,IL,Israel,EURO,16,839742,0,6422
2021-05-28,IL,Israel,EURO,16,839758,2,6424
2021-05-29,IL,Israel,EURO,18,839776,1,6425
2021-05-30,IL,Israel,EURO,13,839789,0,6425
2021-05-31,IL,Israel,EURO,4,839793,0,6425
2021-06-01,IL,Israel,EURO,14,839807,0,6425
2021-06-02,IL,Israel,EURO,35,839842,2,6427
2021-06-03,IL,Israel,EURO,13,839855,0,6427
2021-06-04,IL,Israel,EURO,11,839866,1,6428
2021-06-05,IL,Israel,EURO,31,839897,0,6428
2021-06-06,IL,Israel,EURO,6,839903,1,6429
2021-06-07,IL,Israel,EURO,4,839907,0,6429
2021-06-08,IL,Israel,EURO,7,839914,1,6430
2021-06-09,IL,Israel,EURO,30,839944,1,6431
2021-06-10,IL,Israel,EURO,9,839953,1,6432
2021-06-11,IL,Israel,EURO,18,839971,0,6432
2021-06-12,IL,Israel,EURO,18,839989,0,6432
2021-06-13,IL,Israel,EURO,5,839994,0,6432
2021-06-14,IL,Israel,EURO,3,839997,1,6433
2021-06-15,IL,Israel,EURO,26,840023,0,6433
2021-06-16,IL,Israel,EURO,27,840050,0,6433
2021-06-17,IL,Israel,EURO,14,840064,1,6434
2021-06-18,IL,Israel,EURO,29,840093,0,6434
2021-06-19,IL,Israel,EURO,35,840128,0,6434
2021-06-20,IL,Israel,EURO,47,840175,1,6435
2021-06-21,IL,Israel,EURO,51,840226,0,6435
2021-06-22,IL,Israel,EURO,125,840351,0,6435
2021-06-23,IL,Israel,EURO,113,840464,0,6435
2021-06-24,IL,Israel,EURO,151,840615,0,6435
2021-06-25,IL,Israel,EURO,245,840860,0,6435
2021-06-26,IL,Israel,EURO,235,841095,1,6436
2021-06-27,IL,Israel,EURO,121,841216,0,6436
2021-06-28,IL,Israel,EURO,145,841361,0,6436
2021-06-29,IL,Israel,EURO,289,841650,0,6436
2021-06-30,IL,Israel,EURO,303,841953,0,6436
2021-07-01,IL,Israel,EURO,340,842293,0,6436
2021-07-02,IL,Israel,EURO,299,842592,0,6436
2021-07-03,IL,Israel,EURO,366,842958,0,6436
2021-07-04,IL,Israel,EURO,189,843147,0,6436
2021-07-05,IL,Israel,EURO,350,843497,0,6436
2021-07-06,IL,Israel,EURO,504,844001,0,6436
2021-07-07,IL,Israel,EURO,543,844544,0,6436
2021-07-08,IL,Israel,EURO,527,845071,1,6437
2021-07-09,IL,Israel,EURO,472,845543,2,6439
2021-07-10,IL,Israel,EURO,542,846085,0,6439
2021-07-11,IL,Israel,EURO,261,846346,2,6441
2021-07-12,IL,Israel,EURO,443,846789,3,6444
2021-07-13,IL,Israel,EURO,765,847554,2,6446
2021-07-14,IL,Israel,EURO,749,848303,0,6446
2021-07-15,IL,Israel,EURO,774,849077,3,6449
2021-07-16,IL,Israel,EURO,875,849952,1,6450
2021-07-17,IL,Israel,EURO,1147,851099,1,6451
2021-07-18,IL,Israel,EURO,439,851538,2,6453
2021-07-19,IL,Israel,EURO,838,852376,3,6456
2021-07-20,IL,Israel,EURO,1398,853774,2,6458
2021-07-21,IL,Israel,EURO,1413,855187,2,6460
2021-07-22,IL,Israel,EURO,1370,856557,3,6463
2021-07-23,IL,Israel,EURO,1289,857846,1,6464
2021-07-24,IL,Israel,EURO,1442,859288,0,6464
2021-07-25,IL,Israel,EURO,973,860261,3,6467
2021-07-26,IL,Israel,EURO,1433,861694,4,6471
2021-07-27,IL,Israel,EURO,2135,863829,1,6472
2021-07-28,IL,Israel,EURO,2302,866131,1,6473
2021-07-29,IL,Israel,EURO,2198,868329,6,6479
2021-07-30,IL,Israel,EURO,2180,870509,6,6485
2021-07-31,IL,Israel,EURO,2463,872972,2,6487
2021-08-01,IL,Israel,EURO,2104,875076,5,6492
2021-08-02,IL,Israel,EURO,2126,877202,9,6501
2021-08-03,IL,Israel,EURO,3862,881064,9,6510
2021-08-04,IL,Israel,EURO,3312,884376,10,6520
2021-08-05,IL,Israel,EURO,3510,887886,5,6525
2021-08-06,IL,Israel,EURO,3887,891773,16,6541
2021-08-07,IL,Israel,EURO,3890,895663,14,6555
2021-08-08,IL,Israel,EURO,2936,898599,12,6567
2021-08-09,IL,Israel,EURO,3447,902046,19,6586
2021-08-10,IL,Israel,EURO,6382,908428,11,6597
2021-08-11,IL,Israel,EURO,5860,914288,17,6614
2021-08-12,IL,Israel,EURO,6027,920315,16,6630
2021-08-13,IL,Israel,EURO,6154,926469,19,6649
2021-08-14,IL,Israel,EURO,5975,932444,24,6673
2021-08-15,IL,Israel,EURO,4233,936677,18,6691
2021-08-16,IL,Israel,EURO,5199,941876,20,6711
2021-08-17,IL,Israel,EURO,8798,950674,28,6739
2021-08-18,IL,Israel,EURO,7993,958667,20,6759
2021-08-19,IL,Israel,EURO,8037,966704,22,6781
2021-08-20,IL,Israel,EURO,7842,974546,24,6805
2021-08-21,IL,Israel,EURO,7908,982454,24,6829
2021-08-22,IL,Israel,EURO,5416,987870,25,6854
2021-08-23,IL,Israel,EURO,6594,994464,33,6887
2021-08-24,IL,Israel,EURO,10116,1004580,20,6907
2021-08-25,IL,Israel,EURO,10087,1014667,31,6938
2021-08-26,IL,Israel,EURO,9245,1023912,28,6966
2021-08-27,IL,Israel,EURO,9124,1033036,32,6998
2021-08-28,IL,Israel,EURO,8700,1041736,25,7023
2021-08-29,IL,Israel,EURO,7279,1049015,23,7046
2021-08-30,IL,Israel,EURO,6792,1055807,29,7075
2021-08-31,IL,Israel,EURO,11158,1066965,26,7101
2021-09-01,IL,Israel,EURO,10447,1077412,31,7132
2021-09-02,IL,Israel,EURO,11303,1088715,31,7163
2021-09-03,IL,Israel,EURO,11346,1100061,31,7194
2021-09-04,IL,Israel,EURO,9913,1109974,34,7228
2021-09-05,IL,Israel,EURO,5067,1115041,26,7254
2021-09-06,IL,Israel,EURO,5868,1120909,26,7280
2021-09-07,IL,Israel,EURO,10871,1131780,23,7303
2021-09-08,IL,Israel,EURO,6866,1138646,27,7330
2021-09-09,IL,Israel,EURO,3320,1141966,29,7359
2021-09-10,IL,Israel,EURO,7962,1149928,22,7381
2021-09-11,IL,Israel,EURO,9901,1159829,17,7398
2021-09-12,IL,Israel,EURO,10292,1170121,27,7425
2021-09-13,IL,Israel,EURO,7808,1177929,22,7447
2021-09-14,IL,Israel,EURO,10955,1188884,20,7467
2021-09-15,IL,Israel,EURO,9859,1198743,29,7496
2021-09-16,IL,Israel,EURO,8865,1207608,20,7516
2021-09-17,IL,Israel,EURO,3286,1210894,21,7537
2021-09-18,IL,Israel,EURO,5024,1215918,17,7554
2021-09-19,IL,Israel,EURO,8617,1224535,17,7571
2021-09-20,IL,Israel,EURO,6553,1231088,28,7599
2021-09-21,IL,Israel,EURO,8828,1239916,15,7614
2021-09-22,IL,Israel,EURO,4828,1244744,17,7631
2021-09-23,IL,Israel,EURO,6026,1250770,19,7650
2021-09-24,IL,Israel,EURO,6453,1257223,19,7669
2021-09-25,IL,Israel,EURO,4990,1262213,21,7690
2021-09-26,IL,Israel,EURO,2653,1264866,24,7714
2021-09-27,IL,Israel,EURO,3874,1268740,14,7728
2021-09-28,IL,Israel,EURO,5246,1273986,17,7745
2021-09-29,IL,Israel,EURO,2441,1276427,21,7766
2021-09-30,IL,Israel,EURO,3636,1280063,23,7789
2021-10-01,IL,Israel,EURO,4398,1284461,14,7803
2021-10-02,IL,Israel,EURO,3622,1288083,22,7825
2021-10-03,IL,Israel,EURO,1739,1289822,18,7843
2021-10-04,IL,Israel,EURO,2700,1292522,23,7866
2021-10-05,IL,Israel,EURO,3278,1295800,11,7877
2021-10-06,IL,Israel,EURO,2556,1298356,15,7892
2021-10-07,IL,Israel,EURO,2428,1300784,15,7907
2021-10-08,IL,Israel,EURO,2120,1302904,17,7924
2021-10-09,IL,Israel,EURO,2024,1304928,6,7930
2021-10-10,IL,Israel,EURO,1040,1305968,14,7944
2021-10-11,IL,Israel,EURO,1490,1307458,14,7958
2021-10-12,IL,Israel,EURO,2343,1309801,13,7971
2021-10-13,IL,Israel,EURO,1816,1311617,10,7981
2021-10-14,IL,Israel,EURO,1772,1313389,11,7992
2021-10-15,IL,Israel,EURO,1345,1314734,14,8006
2021-10-16,IL,Israel,EURO,1575,1316309,10,8016
2021-10-17,IL,Israel,EURO,740,1317049,9,8025
2021-10-18,IL,Israel,EURO,1221,1318270,6,8031
2021-10-19,IL,Israel,EURO,1508,1319778,9,8040
2021-10-20,IL,Israel,EURO,1150,1320928,3,8043
2021-10-21,IL,Israel,EURO,1036,1321964,8,8051
2021-10-22,IL,Israel,EURO,993,1322957,7,8058
2021-10-23,IL,Israel,EURO,983,1323940,4,8062
2021-10-24,IL,Israel,EURO,332,1324272,8,8070
2021-10-25,IL,Israel,EURO,842,1325114,6,8076
2021-10-26,IL,Israel,EURO,930,1326044,11,8087
2021-10-27,IL,Israel,EURO,729,1326773,9,8096
2021-10-28,IL,Israel,EURO,648,1327421,5,8101
2021-10-29,IL,Israel,EURO,661,1328082,7,8108
2021-10-30,IL,Israel,EURO,617,1328699,6,8114
2021-10-31,IL,Israel,EURO,225,1328924,3,8117
2021-11-01,IL,Israel,EURO,528,1329452,2,8119
2021-11-02,IL,Israel,EURO,691,1330143,4,8123
2021-11-03,IL,Israel,EURO,667,1330810,3,8126
2021-11-04,IL,Israel,EURO,616,1331426,5,8131
2021-11-05,IL,Israel,EURO,519,1331945,6,8137
2021-11-06,IL,Israel,EURO,558,1332503,1,8138
2021-11-07,IL,Israel,EURO,199,1332702,1,8139
2021-11-08,IL,Israel,EURO,502,1333204,4,8143
2021-11-09,IL,Israel,EURO,566,1333770,3,8146
2021-11-10,IL,Israel,EURO,473,1334243,6,8152
2021-11-11,IL,Israel,EURO,498,1334741,5,8157
2021-11-12,IL,Israel,EURO,393,1335134,3,8160
2021-11-13,IL,Israel,EURO,448,1335582,2,8162
2021-11-14,IL,Israel,EURO,225,1335807,2,8164
2021-11-15,IL,Israel,EURO,397,1336204,0,8164
2021-11-16,IL,Israel,EURO,535,1336739,5,8169
2021-11-17,IL,Israel,EURO,558,1337297,4,8173
2021-11-18,IL,Israel,EURO,483,1337780,1,8174
2021-11-19,IL,Israel,EURO,469,1338249,3,8177
2021-11-20,IL,Israel,EURO,508,1338757,3,8180
2021-11-21,IL,Israel,EURO,237,1338994,6,8186
2021-11-22,IL,Israel,EURO,453,1339447,1,8187
2021-11-23,IL,Israel,EURO,715,1340162,2,8189
2021-11-24,IL,Israel,EURO,604,1340766,0,8189
2021-11-25,IL,Israel,EURO,543,1341309,3,8192
2021-11-26,IL,Israel,EURO,540,1341849,3,8195
2021-11-27,IL,Israel,EURO,540,1342389,2,8197
2021-11-28,IL,Israel,EURO,169,1342558,1,8198
2021-11-29,IL,Israel,EURO,544,1343102,3,8201
2021-11-30,IL,Israel,EURO,697,1343799,3,8204
2021-12-01,IL,Israel,EURO,577,1344376,3,8207
2021-12-02,IL,Israel,EURO,563,1344939,1,8208
2021-12-03,IL,Israel,EURO,519,1345458,2,8210
2021-12-04,IL,Israel,EURO,486,1345944,1,8211
2021-12-05,IL,Israel,EURO,248,1346192,2,8213
2021-12-06,IL,Israel,EURO,539,1346731,1,8214
2021-12-07,IL,Israel,EURO,739,1347470,2,8216
2021-12-08,IL,Israel,EURO,813,1348283,3,8219
2021-12-09,IL,Israel,EURO,714,1348997,6,8225
2021-12-10,IL,Israel,EURO,647,1349644,1,8226
2021-12-11,IL,Israel,EURO,607,1350251,2,8228
2021-12-12,IL,Israel,EURO,236,1350487,1,8229
2021-12-13,IL,Israel,EURO,492,1350979,2,8231
2021-12-14,IL,Israel,EURO,771,1351750,4,8235
2021-12-15,IL,Israel,EURO,702,1352452,1,8236
2021-12-16,IL,Israel,EURO,789,1353241,1,8237
2021-12-17,IL,Israel,EURO,863,1354104,1,8238
2021-12-18,IL,Israel,EURO,877,1354981,2,8240
2021-12-19,IL,Israel,EURO,393,1355374,2,8242
2021-12-20,IL,Israel,EURO,1021,1356395,2,8244
2021-12-21,IL,Israel,EURO,1329,1357724,2,8246
2021-12-22,IL,Israel,EURO,1200,1358924,0,8246
2021-12-23,IL,Israel,EURO,1417,1360341,0,8246
2021-12-24,IL,Israel,EURO,1514,1361855,1,8247
2021-12-25,IL,Israel,EURO,1789,1363644,1,8248
2021-12-26,IL,Israel,EURO,806,1364450,0,8248
2021-12-27,IL,Israel,EURO,1806,1366256,2,8250
2021-12-28,IL,Israel,EURO,2974,1369230,3,8253
2021-12-29,IL,Israel,EURO,3245,1372475,1,8254
2021-12-30,IL,Israel,EURO,4075,1376550,2,8256
2021-12-31,IL,Israel,EURO,5081,1381631,0,8256
2022-01-01,IL,Israel,EURO,5493,1387124,1,8257
2022-01-02,IL,Israel,EURO,4231,1391355,2,8259
2022-01-03,IL,Israel,EURO,6615,1397970,5,8264
2022-01-04,IL,Israel,EURO,10953,1408923,4,8268
2022-01-05,IL,Israel,EURO,12641,1421564,1,8269
2022-01-06,IL,Israel,EURO,18552,1440116,4,8273
2022-01-07,IL,Israel,EURO,19043,1459159,2,8275
2022-01-08,IL,Israel,EURO,21992,1481151,3,8278
2022-01-09,IL,Israel,EURO,22877,1504028,5,8283
2022-01-10,IL,Israel,EURO,31158,1535186,7,8290
2022-01-11,IL,Israel,EURO,41419,1576605,9,8299
2022-01-12,IL,Israel,EURO,46795,1623400,7,8306
2022-01-13,IL,Israel,EURO,48620,1672020,7,8313
2022-01-14,IL,Israel,EURO,49277,1721297,9,8322
2022-01-15,IL,Israel,EURO,45866,1767163,10,8332
2022-01-16,IL,Israel,EURO,45069,1812232,16,8348
2022-01-17,IL,Israel,EURO,64738,1876970,17,8365
2022-01-18,IL,Israel,EURO,72019,1948989,20,8385
2022-01-19,IL,Israel,EURO,73797,2022786,17,8402
2022-01-20,IL,Israel,EURO,74977,2097763,24,8426
2022-01-21,IL,Israel,EURO,75069,2172832,25,8451
2022-01-22,IL,Israel,EURO,65602,2238434,38,8489
2022-01-23,IL,Israel,EURO,67900,2306334,37,8526
2022-01-24,IL,Israel,EURO,85186,2391520,40,8566
2022-01-25,IL,Israel,EURO,83684,2475204,54,8620
2022-01-26,IL,Israel,EURO,76311,2551515,43,8663
2022-01-27,IL,Israel,EURO,67862,2619377,51,8714
2022-01-28,IL,Israel,EURO,57678,2677055,36,8750
2022-01-29,IL,Israel,EURO,53327,2730382,51,8801
2022-01-30,IL,Israel,EURO,49468,2779850,53,8854
2022-01-31,IL,Israel,EURO,74411,2854261,55,8909
2022-02-01,IL,Israel,EURO,67881,2922142,54,8963
2022-02-02,IL,Israel,EURO,60553,2982695,62,9025
2022-02-03,IL,Israel,EURO,60906,3043601,63,9088
2022-02-04,IL,Israel,EURO,46748,3090349,61,9149
2022-02-05,IL,Israel,EURO,38158,3128507,41,9190
2022-02-06,IL,Israel,EURO,33644,3162151,50,9240
2022-02-07,IL,Israel,EURO,52707,3214858,48,9288
2022-02-08,IL,Israel,EURO,44015,3258873,60,9348
2022-02-09,IL,Israel,EURO,38153,3297026,44,9392
2022-02-10,IL,Israel,EURO,37279,3334305,37,9429
2022-02-11,IL,Israel,EURO,27902,3362207,48,9477
2022-02-12,IL,Israel,EURO,22461,3384668,40,9517
2022-02-13,IL,Israel,EURO,18042,3402710,32,9549
2022-02-14,IL,Israel,EURO,31187,3433897,23,9572
.
78732,79097c
2020-03-31,IL,Israel,EURO,550,4981,1,17
2020-04-01,IL,Israel,EURO,738,5719,4,21
2020-04-02,IL,Israel,EURO,693,6412,8,29
2020-04-03,IL,Israel,EURO,724,7136,9,38
2020-04-04,IL,Israel,EURO,600,7736,5,43
2020-04-05,IL,Israel,EURO,427,8163,6,49
2020-04-06,IL,Israel,EURO,584,8747,7,56
2020-04-07,IL,Israel,EURO,449,9196,8,64
2020-04-08,IL,Israel,EURO,376,9572,8,72
2020-04-09,IL,Israel,EURO,340,9912,8,80
2020-04-10,IL,Israel,EURO,340,10252,9,89
2020-04-11,IL,Israel,EURO,355,10607,8,97
2020-04-12,IL,Israel,EURO,342,10949,6,103
2020-04-13,IL,Israel,EURO,551,11500,6,109
2020-04-14,IL,Israel,EURO,437,11937,9,118
2020-04-15,IL,Israel,EURO,394,12331,8,126
2020-04-16,IL,Israel,EURO,305,12636,13,139
2020-04-17,IL,Israel,EURO,296,12932,7,146
2020-04-18,IL,Israel,EURO,297,13229,9,155
2020-04-19,IL,Israel,EURO,288,13517,11,166
2020-04-20,IL,Israel,EURO,274,13791,8,174
2020-04-21,IL,Israel,EURO,297,14088,6,180
2020-04-22,IL,Israel,EURO,279,14367,10,190
2020-04-23,IL,Israel,EURO,226,14593,3,193
2020-04-24,IL,Israel,EURO,275,14868,4,197
2020-04-25,IL,Israel,EURO,250,15118,3,200
2020-04-26,IL,Israel,EURO,159,15277,3,203
2020-04-27,IL,Israel,EURO,82,15359,2,205
2020-04-28,IL,Israel,EURO,127,15486,4,209
2020-04-29,IL,Israel,EURO,161,15647,5,214
2020-04-30,IL,Israel,EURO,82,15729,6,220
2020-05-01,IL,Israel,EURO,143,15872,6,226
2020-05-02,IL,Israel,EURO,116,15988,4,230
2020-05-03,IL,Israel,EURO,57,16045,3,233
2020-05-04,IL,Israel,EURO,26,16071,3,236
2020-05-05,IL,Israel,EURO,55,16126,3,239
2020-05-06,IL,Israel,EURO,33,16159,2,241
2020-05-07,IL,Israel,EURO,65,16224,1,242
2020-05-08,IL,Israel,EURO,61,16285,1,243
2020-05-09,IL,Israel,EURO,33,16318,6,249
2020-05-10,IL,Israel,EURO,20,16338,3,252
2020-05-11,IL,Israel,EURO,29,16367,4,256
2020-05-12,IL,Israel,EURO,39,16406,5,261
2020-05-13,IL,Israel,EURO,23,16429,3,264
2020-05-14,IL,Israel,EURO,39,16468,3,267
2020-05-15,IL,Israel,EURO,22,16490,3,270
2020-05-16,IL,Israel,EURO,12,16502,0,270
2020-05-17,IL,Israel,EURO,5,16507,3,273
2020-05-18,IL,Israel,EURO,15,16522,4,277
2020-05-19,IL,Israel,EURO,27,16549,3,280
2020-05-20,IL,Israel,EURO,22,16571,2,282
2020-05-21,IL,Israel,EURO,15,16586,1,283
2020-05-22,IL,Israel,EURO,18,16604,0,283
2020-05-23,IL,Israel,EURO,19,16623,0,283
2020-05-24,IL,Israel,EURO,5,16628,0,283
2020-05-25,IL,Israel,EURO,13,16641,1,284
2020-05-26,IL,Israel,EURO,22,16663,2,286
2020-05-27,IL,Israel,EURO,50,16713,0,286
2020-05-28,IL,Israel,EURO,40,16753,2,288
2020-05-29,IL,Israel,EURO,77,16830,1,289
2020-05-30,IL,Israel,EURO,113,16943,0,289
2020-05-31,IL,Israel,EURO,29,16972,0,289
2020-06-01,IL,Israel,EURO,87,17059,0,289
2020-06-02,IL,Israel,EURO,100,17159,3,292
2020-06-03,IL,Israel,EURO,122,17281,2,294
2020-06-04,IL,Israel,EURO,96,17377,1,295
2020-06-05,IL,Israel,EURO,142,17519,0,295
2020-06-06,IL,Israel,EURO,127,17646,1,296
2020-06-07,IL,Israel,EURO,78,17724,4,300
2020-06-08,IL,Israel,EURO,140,17864,2,302
2020-06-09,IL,Israel,EURO,179,18043,0,302
2020-06-10,IL,Israel,EURO,174,18217,1,303
2020-06-11,IL,Israel,EURO,241,18458,1,304
2020-06-12,IL,Israel,EURO,193,18651,0,304
2020-06-13,IL,Israel,EURO,184,18835,0,304
2020-06-14,IL,Israel,EURO,149,18984,1,305
2020-06-15,IL,Israel,EURO,137,19121,2,307
2020-06-16,IL,Israel,EURO,200,19321,0,307
2020-06-17,IL,Israel,EURO,298,19619,1,308
2020-06-18,IL,Israel,EURO,268,19887,0,308
2020-06-19,IL,Israel,EURO,303,20190,0,308
2020-06-20,IL,Israel,EURO,311,20501,1,309
2020-06-21,IL,Israel,EURO,161,20662,1,310
2020-06-22,IL,Israel,EURO,174,20836,0,310
2020-06-23,IL,Israel,EURO,344,21180,1,311
2020-06-24,IL,Israel,EURO,452,21632,2,313
2020-06-25,IL,Israel,EURO,485,22117,3,316
2020-06-26,IL,Israel,EURO,516,22633,4,320
2020-06-27,IL,Israel,EURO,464,23097,3,323
2020-06-28,IL,Israel,EURO,397,23494,3,326
2020-06-29,IL,Israel,EURO,383,23877,2,328
2020-06-30,IL,Israel,EURO,759,24636,0,328
2020-07-01,IL,Israel,EURO,789,25425,1,329
2020-07-02,IL,Israel,EURO,968,26393,3,332
2020-07-03,IL,Israel,EURO,1154,27547,1,333
2020-07-04,IL,Israel,EURO,941,28488,3,336
2020-07-05,IL,Israel,EURO,821,29309,5,341
2020-07-06,IL,Israel,EURO,825,30134,2,343
2020-07-07,IL,Israel,EURO,1128,31262,8,351
2020-07-08,IL,Israel,EURO,1384,32646,5,356
2020-07-09,IL,Israel,EURO,1330,33976,5,361
2020-07-10,IL,Israel,EURO,1521,35497,5,366
2020-07-11,IL,Israel,EURO,1406,36903,4,370
2020-07-12,IL,Israel,EURO,1168,38071,5,375
2020-07-13,IL,Israel,EURO,1236,39307,7,382
2020-07-14,IL,Israel,EURO,1717,41024,4,386
2020-07-15,IL,Israel,EURO,1601,42625,7,393
2020-07-16,IL,Israel,EURO,1873,44498,6,399
2020-07-17,IL,Israel,EURO,1936,46434,9,408
2020-07-18,IL,Israel,EURO,1601,48035,12,420
2020-07-19,IL,Israel,EURO,1444,49479,8,428
2020-07-20,IL,Israel,EURO,1016,50495,10,438
2020-07-21,IL,Israel,EURO,1886,52381,12,450
2020-07-22,IL,Israel,EURO,2004,54385,9,459
2020-07-23,IL,Israel,EURO,2041,56426,6,465
2020-07-24,IL,Israel,EURO,1987,58413,16,481
2020-07-25,IL,Israel,EURO,1824,60237,8,489
2020-07-26,IL,Israel,EURO,1110,61347,7,496
2020-07-27,IL,Israel,EURO,1040,62387,11,507
2020-07-28,IL,Israel,EURO,2048,64435,7,514
2020-07-29,IL,Israel,EURO,2120,66555,8,522
2020-07-30,IL,Israel,EURO,1957,68512,15,537
2020-07-31,IL,Israel,EURO,1786,70298,15,552
2020-08-01,IL,Israel,EURO,1359,71657,14,566
2020-08-02,IL,Israel,EURO,623,72280,14,580
2020-08-03,IL,Israel,EURO,708,72988,12,592
2020-08-04,IL,Israel,EURO,1799,74787,15,607
2020-08-05,IL,Israel,EURO,1726,76513,11,618
2020-08-06,IL,Israel,EURO,1686,78199,10,628
2020-08-07,IL,Israel,EURO,1675,79874,9,637
2020-08-08,IL,Israel,EURO,1761,81635,12,649
2020-08-09,IL,Israel,EURO,755,82390,13,662
2020-08-10,IL,Israel,EURO,922,83312,8,670
2020-08-11,IL,Israel,EURO,1697,85009,15,685
2020-08-12,IL,Israel,EURO,1823,86832,11,696
2020-08-13,IL,Israel,EURO,1617,88449,16,712
2020-08-14,IL,Israel,EURO,1640,90089,16,728
2020-08-15,IL,Israel,EURO,1389,91478,12,740
2020-08-16,IL,Israel,EURO,754,92232,10,750
2020-08-17,IL,Israel,EURO,1069,93301,20,770
2020-08-18,IL,Israel,EURO,1649,94950,4,774
2020-08-19,IL,Israel,EURO,1647,96597,14,788
2020-08-20,IL,Israel,EURO,1639,98236,12,800
2020-08-21,IL,Israel,EURO,1485,99721,14,814
2020-08-22,IL,Israel,EURO,1491,101212,13,827
2020-08-23,IL,Israel,EURO,710,101922,10,837
2020-08-24,IL,Israel,EURO,964,102886,13,850
2020-08-25,IL,Israel,EURO,1901,104787,16,866
2020-08-26,IL,Israel,EURO,1958,106745,19,885
2020-08-27,IL,Israel,EURO,1984,108729,11,896
2020-08-28,IL,Israel,EURO,2106,110835,11,907
2020-08-29,IL,Israel,EURO,1833,112668,13,920
2020-08-30,IL,Israel,EURO,908,113576,5,925
2020-08-31,IL,Israel,EURO,1100,114676,14,939
2020-09-01,IL,Israel,EURO,2171,116847,23,962
2020-09-02,IL,Israel,EURO,2255,119102,15,977
2020-09-03,IL,Israel,EURO,3194,122296,13,990
2020-09-04,IL,Israel,EURO,2666,124962,16,1006
2020-09-05,IL,Israel,EURO,2623,127585,12,1018
2020-09-06,IL,Israel,EURO,1504,129089,15,1033
2020-09-07,IL,Israel,EURO,2175,131264,12,1045
2020-09-08,IL,Israel,EURO,3386,134650,17,1062
2020-09-09,IL,Israel,EURO,3488,138138,20,1082
2020-09-10,IL,Israel,EURO,3991,142129,15,1097
2020-09-11,IL,Israel,EURO,4154,146283,14,1111
2020-09-12,IL,Israel,EURO,3974,150257,20,1131
2020-09-13,IL,Israel,EURO,2718,152975,15,1146
2020-09-14,IL,Israel,EURO,3172,156147,17,1163
2020-09-15,IL,Israel,EURO,4803,160950,20,1183
2020-09-16,IL,Israel,EURO,5529,166479,16,1199
2020-09-17,IL,Israel,EURO,4568,171047,26,1225
2020-09-18,IL,Israel,EURO,5378,176425,17,1242
2020-09-19,IL,Israel,EURO,5333,181758,21,1263
2020-09-20,IL,Israel,EURO,3809,185567,28,1291
2020-09-21,IL,Israel,EURO,2576,188143,21,1312
2020-09-22,IL,Israel,EURO,3870,192013,32,1344
2020-09-23,IL,Israel,EURO,7017,199030,25,1369
2020-09-24,IL,Israel,EURO,7142,206172,25,1394
2020-09-25,IL,Israel,EURO,8259,214431,31,1425
2020-09-26,IL,Israel,EURO,8388,222819,29,1454
2020-09-27,IL,Israel,EURO,5880,228699,27,1481
2020-09-28,IL,Israel,EURO,3436,232135,31,1512
2020-09-29,IL,Israel,EURO,1154,233289,29,1541
2020-09-30,IL,Israel,EURO,4989,238278,35,1576
2020-10-01,IL,Israel,EURO,9051,247329,37,1613
2020-10-02,IL,Israel,EURO,7720,255049,46,1659
2020-10-03,IL,Israel,EURO,7053,262102,25,1684
2020-10-04,IL,Israel,EURO,2593,264695,38,1722
2020-10-05,IL,Israel,EURO,2932,267627,37,1759
2020-10-06,IL,Israel,EURO,5702,273329,27,1786
2020-10-07,IL,Israel,EURO,4718,278047,45,1831
2020-10-08,IL,Israel,EURO,4153,282200,26,1857
2020-10-09,IL,Israel,EURO,3752,285952,47,1904
2020-10-10,IL,Israel,EURO,2954,288906,40,1944
2020-10-11,IL,Israel,EURO,916,289822,35,1979
2020-10-12,IL,Israel,EURO,1638,291460,45,2024
2020-10-13,IL,Israel,EURO,3154,294614,30,2054
2020-10-14,IL,Israel,EURO,2335,296949,37,2091
2020-10-15,IL,Israel,EURO,2118,299067,34,2125
2020-10-16,IL,Israel,EURO,1609,300676,32,2157
2020-10-17,IL,Israel,EURO,1496,302172,35,2192
2020-10-18,IL,Israel,EURO,410,302582,32,2224
2020-10-19,IL,Israel,EURO,923,303505,33,2257
2020-10-20,IL,Israel,EURO,1516,305021,31,2288
2020-10-21,IL,Israel,EURO,1192,306213,20,2308
2020-10-22,IL,Israel,EURO,1170,307383,25,2333
2020-10-23,IL,Israel,EURO,1031,308414,29,2362
2020-10-24,IL,Israel,EURO,848,309262,26,2388
2020-10-25,IL,Israel,EURO,247,309509,26,2414
2020-10-26,IL,Israel,EURO,604,310113,34,2448
2020-10-27,IL,Israel,EURO,884,310997,28,2476
2020-10-28,IL,Israel,EURO,885,311882,28,2504
2020-10-29,IL,Israel,EURO,724,312606,10,2514
2020-10-30,IL,Israel,EURO,647,313253,19,2533
2020-10-31,IL,Israel,EURO,681,313934,12,2545
2020-11-01,IL,Israel,EURO,228,314162,25,2570
2020-11-02,IL,Israel,EURO,657,314819,19,2589
2020-11-03,IL,Israel,EURO,792,315611,15,2604
2020-11-04,IL,Israel,EURO,843,316454,26,2630
2020-11-05,IL,Israel,EURO,769,317223,15,2645
2020-11-06,IL,Israel,EURO,568,317791,14,2659
2020-11-07,IL,Israel,EURO,689,318480,16,2675
2020-11-08,IL,Israel,EURO,212,318692,8,2683
2020-11-09,IL,Israel,EURO,535,319227,7,2690
2020-11-10,IL,Israel,EURO,723,319950,8,2698
2020-11-11,IL,Israel,EURO,673,320623,10,2708
2020-11-12,IL,Israel,EURO,768,321391,7,2715
2020-11-13,IL,Israel,EURO,837,322228,12,2727
2020-11-14,IL,Israel,EURO,761,322989,5,2732
2020-11-15,IL,Israel,EURO,292,323281,11,2743
2020-11-16,IL,Israel,EURO,627,323908,14,2757
2020-11-17,IL,Israel,EURO,874,324782,9,2766
2020-11-18,IL,Israel,EURO,830,325612,12,2778
2020-11-19,IL,Israel,EURO,797,326409,7,2785
2020-11-20,IL,Israel,EURO,771,327180,8,2793
2020-11-21,IL,Israel,EURO,772,327952,6,2799
2020-11-22,IL,Israel,EURO,423,328375,12,2811
2020-11-23,IL,Israel,EURO,763,329138,16,2827
2020-11-24,IL,Israel,EURO,961,330099,7,2834
2020-11-25,IL,Israel,EURO,859,330958,5,2839
2020-11-26,IL,Israel,EURO,1081,332039,5,2844
2020-11-27,IL,Israel,EURO,1086,333125,9,2853
2020-11-28,IL,Israel,EURO,1033,334158,7,2860
2020-11-29,IL,Israel,EURO,583,334741,9,2869
2020-11-30,IL,Israel,EURO,1026,335767,10,2879
2020-12-01,IL,Israel,EURO,1257,337024,6,2885
2020-12-02,IL,Israel,EURO,1200,338224,10,2895
2020-12-03,IL,Israel,EURO,1588,339812,5,2900
2020-12-04,IL,Israel,EURO,1450,341262,10,2910
2020-12-05,IL,Israel,EURO,1515,342777,9,2919
2020-12-06,IL,Israel,EURO,1000,343777,10,2929
2020-12-07,IL,Israel,EURO,1359,345136,8,2937
2020-12-08,IL,Israel,EURO,1863,346999,7,2944
2020-12-09,IL,Israel,EURO,1770,348769,12,2956
2020-12-10,IL,Israel,EURO,1869,350638,13,2969
2020-12-11,IL,Israel,EURO,2008,352646,13,2982
2020-12-12,IL,Israel,EURO,1835,354481,11,2993
2020-12-13,IL,Israel,EURO,1298,355779,16,3009
2020-12-14,IL,Israel,EURO,1727,357506,9,3018
2020-12-15,IL,Israel,EURO,2322,359828,11,3029
2020-12-16,IL,Israel,EURO,2893,362721,15,3044
2020-12-17,IL,Israel,EURO,2860,365581,15,3059
2020-12-18,IL,Israel,EURO,2847,368428,17,3076
2020-12-19,IL,Israel,EURO,2793,371221,16,3092
2020-12-20,IL,Israel,EURO,1889,373110,20,3112
2020-12-21,IL,Israel,EURO,3096,376206,18,3130
2020-12-22,IL,Israel,EURO,3860,380066,16,3146
2020-12-23,IL,Israel,EURO,4381,384447,13,3159
2020-12-24,IL,Israel,EURO,4039,388486,25,3184
2020-12-25,IL,Israel,EURO,4050,392536,15,3199
2020-12-26,IL,Israel,EURO,4006,396542,21,3220
2020-12-27,IL,Israel,EURO,2660,399202,23,3243
2020-12-28,IL,Israel,EURO,3534,402736,21,3264
2020-12-29,IL,Israel,EURO,5525,408261,32,3296
2020-12-30,IL,Israel,EURO,5631,413892,25,3321
2020-12-31,IL,Israel,EURO,5871,419763,16,3337
2021-01-01,IL,Israel,EURO,5866,425629,36,3373
2021-01-02,IL,Israel,EURO,6014,431643,34,3407
2021-01-03,IL,Israel,EURO,4212,435855,27,3434
2021-01-04,IL,Israel,EURO,5232,441087,26,3460
2021-01-05,IL,Israel,EURO,8424,449511,38,3498
2021-01-06,IL,Israel,EURO,8230,457741,23,3521
2021-01-07,IL,Israel,EURO,7884,465625,43,3564
2021-01-08,IL,Israel,EURO,7664,473289,48,3612
2021-01-09,IL,Israel,EURO,8162,481451,46,3658
2021-01-10,IL,Israel,EURO,5165,486616,20,3678
2021-01-11,IL,Israel,EURO,6956,493572,43,3721
2021-01-12,IL,Israel,EURO,9730,503302,28,3749
2021-01-13,IL,Israel,EURO,9297,512599,55,3804
2021-01-14,IL,Israel,EURO,9474,522073,57,3861
2021-01-15,IL,Israel,EURO,9300,531373,59,3920
2021-01-16,IL,Israel,EURO,8431,539804,52,3972
2021-01-17,IL,Israel,EURO,5086,544890,47,4019
2021-01-18,IL,Israel,EURO,5660,550550,56,4075
2021-01-19,IL,Israel,EURO,10123,560673,46,4121
2021-01-20,IL,Israel,EURO,8633,569306,43,4164
2021-01-21,IL,Israel,EURO,8361,577667,56,4220
2021-01-22,IL,Israel,EURO,7269,584936,47,4267
2021-01-23,IL,Israel,EURO,7387,592323,65,4332
2021-01-24,IL,Israel,EURO,2447,594770,52,4384
2021-01-25,IL,Israel,EURO,4937,599707,75,4459
2021-01-26,IL,Israel,EURO,8718,608425,60,4519
2021-01-27,IL,Israel,EURO,7817,616242,53,4572
2021-01-28,IL,Israel,EURO,7750,623992,61,4633
2021-01-29,IL,Israel,EURO,7196,631188,49,4682
2021-01-30,IL,Israel,EURO,6776,637964,45,4727
2021-01-31,IL,Israel,EURO,2628,640592,38,4765
2021-02-01,IL,Israel,EURO,5240,645832,51,4816
2021-02-02,IL,Israel,EURO,8930,654762,46,4862
2021-02-03,IL,Israel,EURO,8024,662786,61,4923
2021-02-04,IL,Israel,EURO,7462,670248,57,4980
2021-02-05,IL,Israel,EURO,7262,677510,48,5028
2021-02-06,IL,Israel,EURO,6600,684110,34,5062
2021-02-07,IL,Israel,EURO,2660,686770,51,5113
2021-02-08,IL,Israel,EURO,4606,691376,44,5157
2021-02-09,IL,Israel,EURO,7856,699232,30,5187
2021-02-10,IL,Israel,EURO,6169,705401,42,5229
2021-02-11,IL,Israel,EURO,5676,711077,32,5261
2021-02-12,IL,Israel,EURO,5064,716141,30,5291
2021-02-13,IL,Israel,EURO,4674,720815,41,5332
2021-02-14,IL,Israel,EURO,1890,722705,29,5361
2021-02-15,IL,Israel,EURO,3489,726194,37,5398
2021-02-16,IL,Israel,EURO,5200,731394,16,5414
2021-02-17,IL,Israel,EURO,4583,735977,42,5456
2021-02-18,IL,Israel,EURO,4168,740145,27,5483
2021-02-19,IL,Israel,EURO,3338,743483,35,5518
2021-02-20,IL,Israel,EURO,3794,747277,22,5540
2021-02-21,IL,Israel,EURO,1255,748532,26,5566
2021-02-22,IL,Israel,EURO,3114,751646,25,5591
2021-02-23,IL,Israel,EURO,4812,756458,15,5606
2021-02-24,IL,Israel,EURO,4443,760901,35,5641
2021-02-25,IL,Israel,EURO,4375,765276,27,5668
2021-02-26,IL,Israel,EURO,3820,769096,23,5691
2021-02-27,IL,Israel,EURO,3819,772915,22,5713
2021-02-28,IL,Israel,EURO,1443,774358,30,5743
2021-03-01,IL,Israel,EURO,3030,777388,21,5764
2021-03-02,IL,Israel,EURO,4849,782237,18,5782
2021-03-03,IL,Israel,EURO,4392,786629,21,5803
2021-03-04,IL,Israel,EURO,4669,791298,17,5820
2021-03-05,IL,Israel,EURO,3658,794956,17,5837
2021-03-06,IL,Israel,EURO,3695,798651,18,5855
2021-03-07,IL,Israel,EURO,1843,800494,20,5875
2021-03-08,IL,Israel,EURO,2365,802859,16,5891
2021-03-09,IL,Israel,EURO,3796,806655,21,5912
2021-03-10,IL,Israel,EURO,3127,809782,15,5927
2021-03-11,IL,Israel,EURO,2843,812625,17,5944
2021-03-12,IL,Israel,EURO,2553,815178,18,5962
2021-03-13,IL,Israel,EURO,2414,817592,12,5974
2021-03-14,IL,Israel,EURO,787,818379,16,5990
2021-03-15,IL,Israel,EURO,1411,819790,26,6016
2021-03-16,IL,Israel,EURO,2130,821920,17,6033
2021-03-17,IL,Israel,EURO,1566,823486,16,6049
2021-03-18,IL,Israel,EURO,1541,825027,14,6063
2021-03-19,IL,Israel,EURO,1254,826281,9,6072
2021-03-20,IL,Israel,EURO,1086,827367,12,6084
2021-03-21,IL,Israel,EURO,351,827718,7,6091
2021-03-22,IL,Israel,EURO,681,828399,14,6105
2021-03-23,IL,Israel,EURO,987,829386,14,6119
2021-03-24,IL,Israel,EURO,694,830080,14,6133
2021-03-25,IL,Israel,EURO,479,830559,10,6143
2021-03-26,IL,Israel,EURO,889,831448,9,6152
2021-03-27,IL,Israel,EURO,541,831989,11,6163
2021-03-28,IL,Israel,EURO,239,832228,6,6169
2021-03-29,IL,Israel,EURO,132,832360,13,6182
2021-03-30,IL,Israel,EURO,380,832740,11,6193
2021-03-31,IL,Israel,EURO,452,833192,13,6206
.
78643a
2022-02-12,IM,Isle of Man,EURO,39,22028,0,77
2022-02-13,IM,Isle of Man,EURO,28,22056,0,77
2022-02-14,IM,Isle of Man,EURO,20,22076,0,77
.
77872a
2022-02-12,IE,Ireland,EURO,6618,1242806,0,6291
2022-02-13,IE,Ireland,EURO,0,1242806,0,6291
2022-02-14,IE,Ireland,EURO,0,1242806,0,6291
.
77101a
2022-02-12,IQ,Iraq,EMRO,3776,2271521,29,24655
2022-02-13,IQ,Iraq,EMRO,2014,2273535,23,24678
2022-02-14,IQ,Iraq,EMRO,2036,2275571,26,24704
.
76330c
2022-02-11,IR,Iran (Islamic Republic of),EMRO,33681,6730608,130,133294
2022-02-12,IR,Iran (Islamic Republic of),EMRO,31247,6761855,143,133437
2022-02-13,IR,Iran (Islamic Republic of),EMRO,18598,6780453,133,133570
2022-02-14,IR,Iran (Islamic Republic of),EMRO,25812,6806265,148,133718
.
75559a
2022-02-12,ID,Indonesia,SEARO,55209,4763252,107,145065
2022-02-13,ID,Indonesia,SEARO,44526,4807778,111,145176
2022-02-14,ID,Indonesia,SEARO,36501,4844279,145,145321
.
74788a
2022-02-12,IN,India,SEARO,50407,42586544,804,507981
2022-02-13,IN,India,SEARO,44877,42631421,684,508665
2022-02-14,IN,India,SEARO,34113,42665534,346,509011
.
74010,74017c
2022-02-04,IS,Iceland,EURO,1253,73035,2,49
2022-02-05,IS,Iceland,EURO,1883,74918,0,49
2022-02-06,IS,Iceland,EURO,1455,76373,0,49
2022-02-07,IS,Iceland,EURO,1501,77874,1,50
2022-02-08,IS,Iceland,EURO,1352,79226,0,50
2022-02-09,IS,Iceland,EURO,2274,81500,0,50
2022-02-10,IS,Iceland,EURO,2169,83669,2,52
2022-02-11,IS,Iceland,EURO,1880,85549,2,54
2022-02-12,IS,Iceland,EURO,2326,87875,0,54
2022-02-13,IS,Iceland,EURO,2300,90175,1,55
2022-02-14,IS,Iceland,EURO,1952,92127,0,55
.
73246a
2022-02-12,HU,Hungary,EURO,0,1695991,0,42360
2022-02-13,HU,Hungary,EURO,0,1695991,0,42360
2022-02-14,HU,Hungary,EURO,21081,1717072,271,42631
.
72475a
2022-02-12,HN,Honduras,AMRO,835,403976,8,10595
2022-02-13,HN,Honduras,AMRO,0,403976,0,10595
2022-02-14,HN,Honduras,AMRO,0,403976,0,10595
.
71704a
2022-02-12,VA,Holy See,EURO,0,26,0,0
2022-02-13,VA,Holy See,EURO,0,26,0,0
2022-02-14,VA,Holy See,EURO,0,26,0,0
.
70933a
2022-02-12,HT,Haiti,AMRO,358,29907,3,807
2022-02-13,HT,Haiti,AMRO,0,29907,0,807
2022-02-14,HT,Haiti,AMRO,0,29907,0,807
.
70560,70569c
2021-02-03,HT,Haiti,AMRO,18182,29715,559,804
2021-02-04,HT,Haiti,AMRO,64,29779,-559,245
2021-02-05,HT,Haiti,AMRO,53,29832,0,245
2021-02-06,HT,Haiti,AMRO,16,29848,0,245
2021-02-07,HT,Haiti,AMRO,31,29879,561,806
2021-02-08,HT,Haiti,AMRO,9,29888,-560,246
2021-02-09,HT,Haiti,AMRO,19,29907,561,807
2021-02-10,HT,Haiti,AMRO,0,29907,0,807
2021-02-11,HT,Haiti,AMRO,0,29907,0,807
2021-02-12,HT,Haiti,AMRO,-17891,12016,-561,246
.
70162a
2022-02-12,GY,Guyana,AMRO,160,62061,0,1188
2022-02-13,GY,Guyana,AMRO,95,62156,2,1190
2022-02-14,GY,Guyana,AMRO,0,62156,0,1190
.
69391a
2022-02-12,GW,Guinea-Bissau,AFRO,0,7820,0,158
2022-02-13,GW,Guinea-Bissau,AFRO,29,7849,3,161
2022-02-14,GW,Guinea-Bissau,AFRO,0,7849,3,164
.
68620a
2022-02-12,GN,Guinea,AFRO,0,36314,0,434
2022-02-13,GN,Guinea,AFRO,0,36314,0,434
2022-02-14,GN,Guinea,AFRO,15,36329,2,436
.
67849a
2022-02-12,GG,Guernsey,EURO,97,12397,0,31
2022-02-13,GG,Guernsey,EURO,0,12397,0,31
2022-02-14,GG,Guernsey,EURO,0,12397,0,31
.
67078a
2022-02-12,GT,Guatemala,AMRO,4899,725701,35,16577
2022-02-13,GT,Guatemala,AMRO,4276,729977,34,16611
2022-02-14,GT,Guatemala,AMRO,3983,733960,16,16627
.
66307a
2022-02-12,GU,Guam,WPRO,0,32735,0,305
2022-02-13,GU,Guam,WPRO,0,32735,0,305
2022-02-14,GU,Guam,WPRO,549,33284,1,306
.
65536a
2022-02-12,GP,Guadeloupe,AMRO,0,112668,0,873
2022-02-13,GP,Guadeloupe,AMRO,0,112668,0,873
2022-02-14,GP,Guadeloupe,AMRO,0,112668,0,873
.
64765a
2022-02-12,GD,Grenada,AMRO,70,13172,1,213
2022-02-13,GD,Grenada,AMRO,70,13242,0,213
2022-02-14,GD,Grenada,AMRO,13,13255,0,213
.
63994a
2022-02-12,GL,Greenland,EURO,19,11428,0,7
2022-02-13,GL,Greenland,EURO,0,11428,0,7
2022-02-14,GL,Greenland,EURO,0,11428,0,7
.
63223a
2022-02-12,GR,Greece,EURO,17645,2146798,102,24609
2022-02-13,GR,Greece,EURO,16442,2163240,70,24679
2022-02-14,GR,Greece,EURO,10853,2174093,75,24754
.
62452a
2022-02-12,GI,Gibraltar,EURO,116,14284,0,101
2022-02-13,GI,Gibraltar,EURO,61,14345,0,101
2022-02-14,GI,Gibraltar,EURO,0,14345,0,101
.
61681a
2022-02-12,GH,Ghana,AFRO,0,157751,0,1419
2022-02-13,GH,Ghana,AFRO,0,157751,0,1419
2022-02-14,GH,Ghana,AFRO,0,157751,0,1419
.
60910a
2022-02-12,DE,Germany,EURO,209789,12219501,198,119877
2022-02-13,DE,Germany,EURO,125160,12344661,58,119935
2022-02-14,DE,Germany,EURO,76465,12421126,42,119977
.
60139a
2022-02-12,GE,Georgia,EURO,20326,1438353,57,15516
2022-02-13,GE,Georgia,EURO,15712,1454065,40,15556
2022-02-14,GE,Georgia,EURO,4028,1458093,21,15577
.
59368a
2022-02-12,GM,Gambia,AFRO,0,11911,0,365
2022-02-13,GM,Gambia,AFRO,0,11911,0,365
2022-02-14,GM,Gambia,AFRO,0,11911,0,365
.
58597a
2022-02-12,GA,Gabon,AFRO,0,47399,0,302
2022-02-13,GA,Gabon,AFRO,0,47399,0,302
2022-02-14,GA,Gabon,AFRO,0,47399,0,302
.
57826a
2022-02-12,PF,French Polynesia,WPRO,0,53853,0,637
2022-02-13,PF,French Polynesia,WPRO,0,53853,0,637
2022-02-14,PF,French Polynesia,WPRO,2805,56658,0,637
.
57055a
2022-02-12,GF,French Guiana,AMRO,271,77164,1,384
2022-02-13,GF,French Guiana,AMRO,0,77164,0,384
2022-02-14,GF,French Guiana,AMRO,0,77164,0,384
.
56284a
2022-02-12,FR,France,EURO,129791,20902334,268,131623
2022-02-13,FR,France,EURO,117574,21019908,160,131783
2022-02-14,FR,France,EURO,86562,21106470,107,131890
.
55356,55513c
2021-09-07,FI,Finland,EURO,580,131973,6,1069
2021-09-08,FI,Finland,EURO,521,132494,3,1072
2021-09-09,FI,Finland,EURO,482,132976,1,1073
2021-09-10,FI,Finland,EURO,461,133437,2,1075
2021-09-11,FI,Finland,EURO,496,133933,0,1075
2021-09-12,FI,Finland,EURO,331,134264,1,1076
2021-09-13,FI,Finland,EURO,283,134547,5,1081
2021-09-14,FI,Finland,EURO,534,135081,1,1082
2021-09-15,FI,Finland,EURO,480,135561,2,1084
2021-09-16,FI,Finland,EURO,454,136015,1,1085
2021-09-17,FI,Finland,EURO,437,136452,1,1086
2021-09-18,FI,Finland,EURO,389,136841,1,1087
2021-09-19,FI,Finland,EURO,240,137081,0,1087
2021-09-20,FI,Finland,EURO,285,137366,5,1092
2021-09-21,FI,Finland,EURO,489,137855,1,1093
2021-09-22,FI,Finland,EURO,489,138344,1,1094
2021-09-23,FI,Finland,EURO,483,138827,2,1096
2021-09-24,FI,Finland,EURO,481,139308,4,1100
2021-09-25,FI,Finland,EURO,425,139733,3,1103
2021-09-26,FI,Finland,EURO,299,140032,1,1104
2021-09-27,FI,Finland,EURO,355,140387,3,1107
2021-09-28,FI,Finland,EURO,684,141071,3,1110
2021-09-29,FI,Finland,EURO,645,141716,4,1114
2021-09-30,FI,Finland,EURO,669,142385,4,1118
2021-10-01,FI,Finland,EURO,619,143004,3,1121
2021-10-02,FI,Finland,EURO,532,143536,5,1126
2021-10-03,FI,Finland,EURO,356,143892,3,1129
2021-10-04,FI,Finland,EURO,383,144275,5,1134
2021-10-05,FI,Finland,EURO,746,145021,4,1138
2021-10-06,FI,Finland,EURO,727,145748,7,1145
2021-10-07,FI,Finland,EURO,747,146495,2,1147
2021-10-08,FI,Finland,EURO,611,147106,3,1150
2021-10-09,FI,Finland,EURO,596,147702,8,1158
2021-10-10,FI,Finland,EURO,425,148127,5,1163
2021-10-11,FI,Finland,EURO,399,148526,3,1166
2021-10-12,FI,Finland,EURO,691,149217,5,1171
2021-10-13,FI,Finland,EURO,610,149827,3,1174
2021-10-14,FI,Finland,EURO,639,150466,3,1177
2021-10-15,FI,Finland,EURO,559,151025,4,1181
2021-10-16,FI,Finland,EURO,563,151588,2,1183
2021-10-17,FI,Finland,EURO,345,151933,1,1184
2021-10-18,FI,Finland,EURO,319,152252,4,1188
2021-10-19,FI,Finland,EURO,661,152913,6,1194
2021-10-20,FI,Finland,EURO,550,153463,1,1195
2021-10-21,FI,Finland,EURO,516,153979,2,1197
2021-10-22,FI,Finland,EURO,622,154601,2,1199
2021-10-23,FI,Finland,EURO,580,155181,8,1207
2021-10-24,FI,Finland,EURO,376,155557,4,1211
2021-10-25,FI,Finland,EURO,392,155949,2,1213
2021-10-26,FI,Finland,EURO,798,156747,13,1226
2021-10-27,FI,Finland,EURO,680,157427,4,1230
2021-10-28,FI,Finland,EURO,640,158067,5,1235
2021-10-29,FI,Finland,EURO,593,158660,5,1240
2021-10-30,FI,Finland,EURO,655,159315,2,1242
2021-10-31,FI,Finland,EURO,405,159720,3,1245
2021-11-01,FI,Finland,EURO,439,160159,5,1250
2021-11-02,FI,Finland,EURO,973,161132,12,1262
2021-11-03,FI,Finland,EURO,754,161886,3,1265
2021-11-04,FI,Finland,EURO,771,162657,7,1272
2021-11-05,FI,Finland,EURO,802,163459,9,1281
2021-11-06,FI,Finland,EURO,842,164301,11,1292
2021-11-07,FI,Finland,EURO,514,164815,9,1301
2021-11-08,FI,Finland,EURO,506,165321,4,1305
2021-11-09,FI,Finland,EURO,1123,166444,12,1317
2021-11-10,FI,Finland,EURO,836,167280,9,1326
2021-11-11,FI,Finland,EURO,971,168251,4,1330
2021-11-12,FI,Finland,EURO,934,169185,6,1336
2021-11-13,FI,Finland,EURO,946,170131,5,1341
2021-11-14,FI,Finland,EURO,618,170749,3,1344
2021-11-15,FI,Finland,EURO,570,171319,6,1350
2021-11-16,FI,Finland,EURO,1252,172571,17,1367
2021-11-17,FI,Finland,EURO,1200,173771,9,1376
2021-11-18,FI,Finland,EURO,1172,174943,5,1381
2021-11-19,FI,Finland,EURO,1214,176157,4,1385
2021-11-20,FI,Finland,EURO,1275,177432,6,1391
2021-11-21,FI,Finland,EURO,709,178141,8,1399
2021-11-22,FI,Finland,EURO,674,178815,5,1404
2021-11-23,FI,Finland,EURO,1424,180239,10,1414
2021-11-24,FI,Finland,EURO,1337,181576,10,1424
2021-11-25,FI,Finland,EURO,1257,182833,10,1434
2021-11-26,FI,Finland,EURO,1276,184109,11,1445
2021-11-27,FI,Finland,EURO,1301,185410,8,1453
2021-11-28,FI,Finland,EURO,793,186203,8,1461
2021-11-29,FI,Finland,EURO,791,186994,3,1464
2021-11-30,FI,Finland,EURO,1702,188696,15,1479
2021-12-01,FI,Finland,EURO,1427,190123,7,1486
2021-12-02,FI,Finland,EURO,1443,191566,12,1498
2021-12-03,FI,Finland,EURO,1468,193034,5,1503
2021-12-04,FI,Finland,EURO,1530,194564,6,1509
2021-12-05,FI,Finland,EURO,971,195535,7,1516
2021-12-06,FI,Finland,EURO,1003,196538,5,1521
2021-12-07,FI,Finland,EURO,1078,197616,3,1524
2021-12-08,FI,Finland,EURO,1924,199540,7,1531
2021-12-09,FI,Finland,EURO,1733,201273,9,1540
2021-12-10,FI,Finland,EURO,1711,202984,7,1547
2021-12-11,FI,Finland,EURO,1801,204785,6,1553
2021-12-12,FI,Finland,EURO,1124,205909,7,1560
2021-12-13,FI,Finland,EURO,1270,207179,5,1565
2021-12-14,FI,Finland,EURO,2357,209536,7,1572
2021-12-15,FI,Finland,EURO,1833,211369,6,1578
2021-12-16,FI,Finland,EURO,2100,213469,8,1586
2021-12-17,FI,Finland,EURO,1990,215459,8,1594
2021-12-18,FI,Finland,EURO,2174,217633,8,1602
2021-12-19,FI,Finland,EURO,1614,219247,2,1604
2021-12-20,FI,Finland,EURO,1753,221000,5,1609
2021-12-21,FI,Finland,EURO,3041,224041,8,1617
2021-12-22,FI,Finland,EURO,3168,227209,7,1624
2021-12-23,FI,Finland,EURO,3538,230747,8,1632
2021-12-24,FI,Finland,EURO,3901,234648,10,1642
2021-12-25,FI,Finland,EURO,2273,236921,6,1648
2021-12-26,FI,Finland,EURO,2674,239595,5,1653
2021-12-27,FI,Finland,EURO,3307,242902,9,1662
2021-12-28,FI,Finland,EURO,6663,249565,17,1679
2021-12-29,FI,Finland,EURO,6872,256437,12,1691
2021-12-30,FI,Finland,EURO,7389,263826,14,1705
2021-12-31,FI,Finland,EURO,7325,271151,20,1725
2022-01-01,FI,Finland,EURO,6870,278021,20,1745
2022-01-02,FI,Finland,EURO,3988,282009,11,1756
2022-01-03,FI,Finland,EURO,4973,286982,13,1769
2022-01-04,FI,Finland,EURO,9490,296472,17,1786
2022-01-05,FI,Finland,EURO,9946,306418,22,1808
2022-01-06,FI,Finland,EURO,9748,316166,20,1828
2022-01-07,FI,Finland,EURO,7399,323565,15,1843
2022-01-08,FI,Finland,EURO,9558,333123,19,1862
2022-01-09,FI,Finland,EURO,5984,339107,19,1881
2022-01-10,FI,Finland,EURO,6844,345951,13,1894
2022-01-11,FI,Finland,EURO,11083,357034,25,1919
2022-01-12,FI,Finland,EURO,9723,366757,14,1933
2022-01-13,FI,Finland,EURO,9441,376198,19,1952
2022-01-14,FI,Finland,EURO,8673,384871,19,1971
2022-01-15,FI,Finland,EURO,8672,393543,14,1985
2022-01-16,FI,Finland,EURO,5868,399411,16,2001
2022-01-17,FI,Finland,EURO,6460,405871,18,2019
2022-01-18,FI,Finland,EURO,10929,416800,23,2042
2022-01-19,FI,Finland,EURO,9670,426470,12,2054
2022-01-20,FI,Finland,EURO,9104,435574,12,2066
2022-01-21,FI,Finland,EURO,8701,444275,13,2079
2022-01-22,FI,Finland,EURO,7901,452176,12,2091
2022-01-23,FI,Finland,EURO,4643,456819,11,2102
2022-01-24,FI,Finland,EURO,5127,461946,7,2109
2022-01-25,FI,Finland,EURO,9433,471379,20,2129
2022-01-26,FI,Finland,EURO,7924,479303,8,2137
2022-01-27,FI,Finland,EURO,6490,485793,12,2149
2022-01-28,FI,Finland,EURO,6549,492342,9,2158
2022-01-29,FI,Finland,EURO,6051,498393,10,2168
2022-01-30,FI,Finland,EURO,3973,502366,6,2174
2022-01-31,FI,Finland,EURO,4199,506565,2,2176
2022-02-01,FI,Finland,EURO,8270,514835,9,2185
2022-02-02,FI,Finland,EURO,6977,521812,4,2189
2022-02-03,FI,Finland,EURO,6613,528425,7,2196
2022-02-04,FI,Finland,EURO,6063,534488,9,2205
2022-02-05,FI,Finland,EURO,5703,540191,2,2207
2022-02-06,FI,Finland,EURO,3381,543572,4,2211
2022-02-07,FI,Finland,EURO,4099,547671,2,2213
2022-02-08,FI,Finland,EURO,8558,556229,0,2213
2022-02-09,FI,Finland,EURO,7113,563342,0,2213
2022-02-10,FI,Finland,EURO,6233,569575,1,2214
2022-02-11,FI,Finland,EURO,5583,575158,0,2214
2022-02-12,FI,Finland,EURO,4286,579444,0,2214
2022-02-13,FI,Finland,EURO,2317,581761,0,2214
2022-02-14,FI,Finland,EURO,622,582383,0,2214
.
54742c
2022-02-11,FJ,Fiji,WPRO,61,63459,0,816
2022-02-12,FJ,Fiji,WPRO,17,63476,3,819
2022-02-13,FJ,Fiji,WPRO,0,63476,0,819
2022-02-14,FJ,Fiji,WPRO,0,63476,0,819
.
53971a
2022-02-12,FO,Faroe Islands,EURO,701,27701,0,22
2022-02-13,FO,Faroe Islands,EURO,719,28420,0,22
2022-02-14,FO,Faroe Islands,EURO,305,28725,1,23
.
53200a
2022-02-12,FK,Falkland Islands (Malvinas),AMRO,0,98,0,0
2022-02-13,FK,Falkland Islands (Malvinas),AMRO,0,98,0,0
2022-02-14,FK,Falkland Islands (Malvinas),AMRO,0,98,0,0
.
52429a
2022-02-12,ET,Ethiopia,AFRO,135,467288,10,7417
2022-02-13,ET,Ethiopia,AFRO,111,467399,4,7421
2022-02-14,ET,Ethiopia,AFRO,99,467498,3,7424
.
51658a
2022-02-12,SZ,Eswatini,AFRO,35,68762,1,1382
2022-02-13,SZ,Eswatini,AFRO,19,68781,1,1383
2022-02-14,SZ,Eswatini,AFRO,14,68795,0,1383
.
50887a
2022-02-12,EE,Estonia,EURO,5784,415994,6,2106
2022-02-13,EE,Estonia,EURO,4610,420604,7,2113
2022-02-14,EE,Estonia,EURO,2895,423499,2,2115
.
50116a
2022-02-12,ER,Eritrea,AFRO,2,9662,0,102
2022-02-13,ER,Eritrea,AFRO,2,9664,1,103
2022-02-14,ER,Eritrea,AFRO,4,9668,0,103
.
49345a
2022-02-12,GQ,Equatorial Guinea,AFRO,0,15853,0,182
2022-02-13,GQ,Equatorial Guinea,AFRO,0,15853,0,182
2022-02-14,GQ,Equatorial Guinea,AFRO,0,15853,0,182
.
48574a
2022-02-12,SV,El Salvador,AMRO,0,135109,7,3982
2022-02-13,SV,El Salvador,AMRO,0,135109,7,3989
2022-02-14,SV,El Salvador,AMRO,0,135109,5,3994
.
47803c
2022-02-11,EG,Egypt,EMRO,2189,448497,62,23172
2022-02-12,EG,Egypt,EMRO,2179,450676,61,23233
2022-02-13,EG,Egypt,EMRO,2145,452821,59,23292
2022-02-14,EG,Egypt,EMRO,2131,454952,57,23349
.
47032a
2022-02-12,EC,Ecuador,AMRO,0,781470,0,34854
2022-02-13,EC,Ecuador,AMRO,0,781470,0,34854
2022-02-14,EC,Ecuador,AMRO,0,781470,0,34854
.
47029,47031c
2022-02-08,EC,Ecuador,AMRO,2751,769149,9,34739
2022-02-09,EC,Ecuador,AMRO,2416,771565,1,34740
2022-02-10,EC,Ecuador,AMRO,6034,777599,64,34804
.
46261a
2022-02-12,DO,Dominican Republic,AMRO,810,567895,2,4341
2022-02-13,DO,Dominican Republic,AMRO,1129,569024,2,4343
2022-02-14,DO,Dominican Republic,AMRO,0,569024,0,4343
.
45490a
2022-02-12,DM,Dominica,AMRO,311,10311,2,53
2022-02-13,DM,Dominica,AMRO,0,10311,0,53
2022-02-14,DM,Dominica,AMRO,0,10311,0,53
.
44719c
2022-02-11,DJ,Djibouti,EMRO,2,15529,0,189
2022-02-12,DJ,Djibouti,EMRO,1,15530,0,189
2022-02-13,DJ,Djibouti,EMRO,1,15531,0,189
2022-02-14,DJ,Djibouti,EMRO,3,15534,0,189
.
43948a
2022-02-12,DK,Denmark,EURO,48170,2244726,24,4001
2022-02-13,DK,Denmark,EURO,44350,2289076,37,4038
2022-02-14,DK,Denmark,EURO,38323,2327399,30,4068
.
43177a
2022-02-12,CD,Democratic Republic of the Congo,AFRO,17,85793,0,1316
2022-02-13,CD,Democratic Republic of the Congo,AFRO,0,85793,0,1316
2022-02-14,CD,Democratic Republic of the Congo,AFRO,0,85793,0,1316
.
42406a
2022-02-12,KP,Democratic People's Republic of Korea,SEARO,0,0,0,0
2022-02-13,KP,Democratic People's Republic of Korea,SEARO,0,0,0,0
2022-02-14,KP,Democratic People's Republic of Korea,SEARO,0,0,0,0
.
40984,41635c
2020-05-01,CZ,Czechia,EURO,107,7701,8,242
2020-05-02,CZ,Czechia,EURO,56,7757,8,250
2020-05-03,CZ,Czechia,EURO,18,7775,1,251
2020-05-04,CZ,Czechia,EURO,26,7801,3,254
2020-05-05,CZ,Czechia,EURO,39,7840,5,259
2020-05-06,CZ,Czechia,EURO,77,7917,3,262
2020-05-07,CZ,Czechia,EURO,79,7996,3,265
2020-05-08,CZ,Czechia,EURO,59,8055,4,269
2020-05-09,CZ,Czechia,EURO,46,8101,5,274
2020-05-10,CZ,Czechia,EURO,18,8119,3,277
2020-05-11,CZ,Czechia,EURO,28,8147,3,280
2020-05-12,CZ,Czechia,EURO,58,8205,2,282
2020-05-13,CZ,Czechia,EURO,45,8250,3,285
2020-05-14,CZ,Czechia,EURO,50,8300,4,289
2020-05-15,CZ,Czechia,EURO,82,8382,3,292
2020-05-16,CZ,Czechia,EURO,55,8437,2,294
2020-05-17,CZ,Czechia,EURO,51,8488,1,295
2020-05-18,CZ,Czechia,EURO,20,8508,2,297
2020-05-19,CZ,Czechia,EURO,114,8622,3,300
2020-05-20,CZ,Czechia,EURO,63,8685,2,302
2020-05-21,CZ,Czechia,EURO,74,8759,5,307
2020-05-22,CZ,Czechia,EURO,35,8794,3,310
2020-05-23,CZ,Czechia,EURO,61,8855,2,312
2020-05-24,CZ,Czechia,EURO,77,8932,1,313
2020-05-25,CZ,Czechia,EURO,65,8997,1,314
2020-05-26,CZ,Czechia,EURO,47,9044,1,315
2020-05-27,CZ,Czechia,EURO,51,9095,1,316
2020-05-28,CZ,Czechia,EURO,37,9132,0,316
2020-05-29,CZ,Czechia,EURO,54,9186,2,318
2020-05-30,CZ,Czechia,EURO,57,9243,0,318
2020-05-31,CZ,Czechia,EURO,34,9277,0,318
2020-06-01,CZ,Czechia,EURO,38,9315,0,318
2020-06-02,CZ,Czechia,EURO,34,9349,2,320
2020-06-03,CZ,Czechia,EURO,64,9413,1,321
2020-06-04,CZ,Czechia,EURO,74,9487,1,322
2020-06-05,CZ,Czechia,EURO,64,9551,3,325
2020-06-06,CZ,Czechia,EURO,35,9586,0,325
2020-06-07,CZ,Czechia,EURO,38,9624,0,325
2020-06-08,CZ,Czechia,EURO,61,9685,1,326
2020-06-09,CZ,Czechia,EURO,69,9754,0,326
2020-06-10,CZ,Czechia,EURO,55,9809,1,327
2020-06-11,CZ,Czechia,EURO,74,9883,1,328
2020-06-12,CZ,Czechia,EURO,64,9947,1,329
2020-06-13,CZ,Czechia,EURO,52,9999,1,330
2020-06-14,CZ,Czechia,EURO,53,10052,0,330
2020-06-15,CZ,Czechia,EURO,33,10085,1,331
2020-06-16,CZ,Czechia,EURO,40,10125,1,332
2020-06-17,CZ,Czechia,EURO,47,10172,1,333
2020-06-18,CZ,Czechia,EURO,51,10223,1,334
2020-06-19,CZ,Czechia,EURO,118,10341,2,336
2020-06-20,CZ,Czechia,EURO,126,10467,1,337
2020-06-21,CZ,Czechia,EURO,43,10510,1,338
2020-06-22,CZ,Czechia,EURO,50,10560,1,339
2020-06-23,CZ,Czechia,EURO,64,10624,1,340
2020-06-24,CZ,Czechia,EURO,89,10713,0,340
2020-06-25,CZ,Czechia,EURO,127,10840,4,344
2020-06-26,CZ,Czechia,EURO,93,10933,0,344
2020-06-27,CZ,Czechia,EURO,168,11101,1,345
2020-06-28,CZ,Czechia,EURO,260,11361,1,346
2020-06-29,CZ,Czechia,EURO,305,11666,0,346
2020-06-30,CZ,Czechia,EURO,201,11867,0,346
2020-07-01,CZ,Czechia,EURO,149,12016,1,347
2020-07-02,CZ,Czechia,EURO,91,12107,0,347
2020-07-03,CZ,Czechia,EURO,133,12240,1,348
2020-07-04,CZ,Czechia,EURO,140,12380,0,348
2020-07-05,CZ,Czechia,EURO,121,12501,2,350
2020-07-06,CZ,Czechia,EURO,75,12576,2,352
2020-07-07,CZ,Czechia,EURO,51,12627,1,353
2020-07-08,CZ,Czechia,EURO,118,12745,0,353
2020-07-09,CZ,Czechia,EURO,129,12874,0,353
2020-07-10,CZ,Czechia,EURO,105,12979,1,354
2020-07-11,CZ,Czechia,EURO,141,13120,0,354
2020-07-12,CZ,Czechia,EURO,53,13173,0,354
2020-07-13,CZ,Czechia,EURO,59,13232,1,355
2020-07-14,CZ,Czechia,EURO,64,13296,1,356
2020-07-15,CZ,Czechia,EURO,105,13401,2,358
2020-07-16,CZ,Czechia,EURO,135,13536,0,358
2020-07-17,CZ,Czechia,EURO,137,13673,0,358
2020-07-18,CZ,Czechia,EURO,128,13801,2,360
2020-07-19,CZ,Czechia,EURO,112,13913,0,360
2020-07-20,CZ,Czechia,EURO,91,14004,1,361
2020-07-21,CZ,Czechia,EURO,168,14172,0,361
2020-07-22,CZ,Czechia,EURO,208,14380,2,363
2020-07-23,CZ,Czechia,EURO,245,14625,2,365
2020-07-24,CZ,Czechia,EURO,231,14856,1,366
2020-07-25,CZ,Czechia,EURO,278,15134,3,369
2020-07-26,CZ,Czechia,EURO,132,15266,2,371
2020-07-27,CZ,Czechia,EURO,114,15380,1,372
2020-07-28,CZ,Czechia,EURO,194,15574,2,374
2020-07-29,CZ,Czechia,EURO,276,15850,2,376
2020-07-30,CZ,Czechia,EURO,274,16124,2,378
2020-07-31,CZ,Czechia,EURO,254,16378,2,380
2020-08-01,CZ,Czechia,EURO,231,16609,2,382
2020-08-02,CZ,Czechia,EURO,124,16733,2,384
2020-08-03,CZ,Czechia,EURO,101,16834,2,386
2020-08-04,CZ,Czechia,EURO,208,17042,2,388
2020-08-05,CZ,Czechia,EURO,287,17329,2,390
2020-08-06,CZ,Czechia,EURO,241,17570,1,391
2020-08-07,CZ,Czechia,EURO,214,17784,1,392
2020-08-08,CZ,Czechia,EURO,322,18106,0,392
2020-08-09,CZ,Czechia,EURO,173,18279,0,392
2020-08-10,CZ,Czechia,EURO,122,18401,1,393
2020-08-11,CZ,Czechia,EURO,141,18542,0,393
2020-08-12,CZ,Czechia,EURO,289,18831,2,395
2020-08-13,CZ,Czechia,EURO,289,19120,0,395
2020-08-14,CZ,Czechia,EURO,330,19450,1,396
2020-08-15,CZ,Czechia,EURO,291,19741,2,398
2020-08-16,CZ,Czechia,EURO,197,19938,2,400
2020-08-17,CZ,Czechia,EURO,121,20059,2,402
2020-08-18,CZ,Czechia,EURO,191,20250,4,406
2020-08-19,CZ,Czechia,EURO,281,20531,0,406
2020-08-20,CZ,Czechia,EURO,313,20844,3,409
2020-08-21,CZ,Czechia,EURO,246,21090,3,412
2020-08-22,CZ,Czechia,EURO,506,21596,3,415
2020-08-23,CZ,Czechia,EURO,234,21830,0,415
2020-08-24,CZ,Czechia,EURO,136,21966,3,418
2020-08-25,CZ,Czechia,EURO,259,22225,1,419
2020-08-26,CZ,Czechia,EURO,364,22589,2,421
2020-08-27,CZ,Czechia,EURO,396,22985,1,422
2020-08-28,CZ,Czechia,EURO,350,23335,0,422
2020-08-29,CZ,Czechia,EURO,485,23820,0,422
2020-08-30,CZ,Czechia,EURO,320,24140,3,425
2020-08-31,CZ,Czechia,EURO,275,24415,1,426
2020-09-01,CZ,Czechia,EURO,256,24671,1,427
2020-09-02,CZ,Czechia,EURO,497,25168,1,428
2020-09-03,CZ,Czechia,EURO,645,25813,0,428
2020-09-04,CZ,Czechia,EURO,675,26488,4,432
2020-09-05,CZ,Czechia,EURO,797,27285,3,435
2020-09-06,CZ,Czechia,EURO,504,27789,5,440
2020-09-07,CZ,Czechia,EURO,410,28199,3,443
2020-09-08,CZ,Czechia,EURO,561,28760,2,445
2020-09-09,CZ,Czechia,EURO,1161,29921,5,450
2020-09-10,CZ,Czechia,EURO,1158,31079,3,453
2020-09-11,CZ,Czechia,EURO,1383,32462,5,458
2020-09-12,CZ,Czechia,EURO,1442,33904,3,461
2020-09-13,CZ,Czechia,EURO,1537,35441,6,467
2020-09-14,CZ,Czechia,EURO,791,36232,5,472
2020-09-15,CZ,Czechia,EURO,1028,37260,6,478
2020-09-16,CZ,Czechia,EURO,1676,38936,10,488
2020-09-17,CZ,Czechia,EURO,2133,41069,7,495
2020-09-18,CZ,Czechia,EURO,3125,44194,7,502
2020-09-19,CZ,Czechia,EURO,2108,46302,12,514
2020-09-20,CZ,Czechia,EURO,2045,48347,8,522
2020-09-21,CZ,Czechia,EURO,984,49331,6,528
2020-09-22,CZ,Czechia,EURO,1477,50808,15,543
2020-09-23,CZ,Czechia,EURO,2387,53195,10,553
2020-09-24,CZ,Czechia,EURO,2305,55500,22,575
2020-09-25,CZ,Czechia,EURO,2906,58406,10,585
2020-09-26,CZ,Czechia,EURO,2945,61351,10,595
2020-09-27,CZ,Czechia,EURO,1981,63332,16,611
2020-09-28,CZ,Czechia,EURO,1305,64637,16,627
2020-09-29,CZ,Czechia,EURO,1284,65921,11,638
2020-09-30,CZ,Czechia,EURO,1962,67883,21,659
2020-10-01,CZ,Czechia,EURO,2925,70808,16,675
2020-10-02,CZ,Czechia,EURO,3503,74311,29,704
2020-10-03,CZ,Czechia,EURO,3795,78106,21,725
2020-10-04,CZ,Czechia,EURO,2554,80660,13,738
2020-10-05,CZ,Czechia,EURO,1841,82501,35,773
2020-10-06,CZ,Czechia,EURO,3117,85618,29,802
2020-10-07,CZ,Czechia,EURO,4458,90076,38,840
2020-10-08,CZ,Czechia,EURO,5336,95412,51,891
2020-10-09,CZ,Czechia,EURO,5394,100806,26,917
2020-10-10,CZ,Czechia,EURO,8618,109424,61,978
2020-10-11,CZ,Czechia,EURO,4637,114061,53,1031
2020-10-12,CZ,Czechia,EURO,3104,117165,43,1074
2020-10-13,CZ,Czechia,EURO,4307,121472,70,1144
2020-10-14,CZ,Czechia,EURO,8324,129796,53,1197
2020-10-15,CZ,Czechia,EURO,9544,139340,67,1264
2020-10-16,CZ,Czechia,EURO,9724,149064,63,1327
2020-10-17,CZ,Czechia,EURO,11104,160168,80,1407
2020-10-18,CZ,Czechia,EURO,8713,168881,81,1488
2020-10-19,CZ,Czechia,EURO,5059,173940,82,1570
2020-10-20,CZ,Czechia,EURO,8078,182018,110,1680
2020-10-21,CZ,Czechia,EURO,11985,194003,109,1789
2020-10-22,CZ,Czechia,EURO,14971,208974,131,1920
2020-10-23,CZ,Czechia,EURO,14158,223132,127,2047
2020-10-24,CZ,Czechia,EURO,15248,238380,125,2172
2020-10-25,CZ,Czechia,EURO,12473,250853,143,2315
2020-10-26,CZ,Czechia,EURO,7300,258153,154,2469
2020-10-27,CZ,Czechia,EURO,10273,268426,163,2632
2020-10-28,CZ,Czechia,EURO,15667,284093,195,2827
2020-10-29,CZ,Czechia,EURO,12977,297070,168,2995
2020-10-30,CZ,Czechia,EURO,13050,310120,199,3194
2020-10-31,CZ,Czechia,EURO,13605,323725,217,3411
2020-11-01,CZ,Czechia,EURO,11428,335153,193,3604
2020-11-02,CZ,Czechia,EURO,6551,341704,224,3828
2020-11-03,CZ,Czechia,EURO,9241,350945,223,4051
2020-11-04,CZ,Czechia,EURO,12090,363035,261,4312
2020-11-05,CZ,Czechia,EURO,15726,378761,228,4540
2020-11-06,CZ,Czechia,EURO,13237,391998,196,4736
2020-11-07,CZ,Czechia,EURO,11546,403544,217,4953
2020-11-08,CZ,Czechia,EURO,7721,411265,203,5156
2020-11-09,CZ,Czechia,EURO,3611,414876,206,5362
2020-11-10,CZ,Czechia,EURO,6048,420924,186,5548
2020-11-11,CZ,Czechia,EURO,9057,429981,215,5763
2020-11-12,CZ,Czechia,EURO,8919,438900,184,5947
2020-11-13,CZ,Czechia,EURO,7874,446774,174,6121
2020-11-14,CZ,Czechia,EURO,7358,454132,181,6302
2020-11-15,CZ,Czechia,EURO,4196,458328,185,6487
2020-11-16,CZ,Czechia,EURO,1891,460219,152,6639
2020-11-17,CZ,Czechia,EURO,5420,465639,173,6812
2020-11-18,CZ,Czechia,EURO,4246,469885,139,6951
2020-11-19,CZ,Czechia,EURO,5514,475399,155,7106
2020-11-20,CZ,Czechia,EURO,6470,481869,134,7240
2020-11-21,CZ,Czechia,EURO,5809,487678,117,7357
2020-11-22,CZ,Czechia,EURO,3191,490869,132,7489
2020-11-23,CZ,Czechia,EURO,1508,492377,126,7615
2020-11-24,CZ,Czechia,EURO,4379,496756,129,7744
2020-11-25,CZ,Czechia,EURO,5861,502617,136,7880
2020-11-26,CZ,Czechia,EURO,4929,507546,123,8003
2020-11-27,CZ,Czechia,EURO,4049,511595,130,8133
2020-11-28,CZ,Czechia,EURO,4463,516058,138,8271
2020-11-29,CZ,Czechia,EURO,2668,518726,117,8388
2020-11-30,CZ,Czechia,EURO,1074,519800,95,8483
2020-12-01,CZ,Czechia,EURO,3573,523373,126,8609
2020-12-02,CZ,Czechia,EURO,5181,528554,100,8709
2020-12-03,CZ,Czechia,EURO,4561,533115,116,8825
2020-12-04,CZ,Czechia,EURO,4624,537739,102,8927
2020-12-05,CZ,Czechia,EURO,4747,542486,92,9019
2020-12-06,CZ,Czechia,EURO,3313,545799,129,9148
2020-12-07,CZ,Czechia,EURO,1112,546911,91,9239
2020-12-08,CZ,Czechia,EURO,4251,551162,94,9333
2020-12-09,CZ,Czechia,EURO,5855,557017,95,9428
2020-12-10,CZ,Czechia,EURO,6417,563434,82,9510
2020-12-11,CZ,Czechia,EURO,5876,569310,116,9626
2020-12-12,CZ,Czechia,EURO,6210,575520,105,9731
2020-12-13,CZ,Czechia,EURO,3655,579175,97,9828
2020-12-14,CZ,Czechia,EURO,1998,581173,108,9936
2020-12-15,CZ,Czechia,EURO,5179,586352,130,10066
2020-12-16,CZ,Czechia,EURO,7914,594266,105,10171
2020-12-17,CZ,Czechia,EURO,8263,602529,114,10285
2020-12-18,CZ,Czechia,EURO,7617,610146,106,10391
2020-12-19,CZ,Czechia,EURO,8856,619002,100,10491
2020-12-20,CZ,Czechia,EURO,5354,624356,114,10605
2020-12-21,CZ,Czechia,EURO,3419,627775,98,10703
2020-12-22,CZ,Czechia,EURO,7975,635750,104,10807
2020-12-23,CZ,Czechia,EURO,10950,646700,102,10909
2020-12-24,CZ,Czechia,EURO,14172,660872,115,11024
2020-12-25,CZ,Czechia,EURO,4381,665253,111,11135
2020-12-26,CZ,Czechia,EURO,2680,667933,106,11241
2020-12-27,CZ,Czechia,EURO,3044,670977,125,11366
2020-12-28,CZ,Czechia,EURO,3798,674775,108,11474
2020-12-29,CZ,Czechia,EURO,11001,685776,131,11605
2020-12-30,CZ,Czechia,EURO,16538,702314,132,11737
2020-12-31,CZ,Czechia,EURO,17120,719434,150,11887
2021-01-01,CZ,Czechia,EURO,13337,732771,129,12016
2021-01-02,CZ,Czechia,EURO,3459,736230,152,12168
2021-01-03,CZ,Czechia,EURO,5001,741231,152,12320
2021-01-04,CZ,Czechia,EURO,6289,747520,141,12461
2021-01-05,CZ,Czechia,EURO,13002,760522,152,12613
2021-01-06,CZ,Czechia,EURO,17462,777984,181,12794
2021-01-07,CZ,Czechia,EURO,17866,795850,162,12956
2021-01-08,CZ,Czechia,EURO,14983,810833,187,13143
2021-01-09,CZ,Czechia,EURO,13160,823993,197,13340
2021-01-10,CZ,Czechia,EURO,8480,832473,165,13505
2021-01-11,CZ,Czechia,EURO,4337,836810,184,13689
2021-01-12,CZ,Czechia,EURO,9440,846250,163,13852
2021-01-13,CZ,Czechia,EURO,10832,857082,177,14029
2021-01-14,CZ,Czechia,EURO,10953,868035,164,14193
2021-01-15,CZ,Czechia,EURO,8125,876160,181,14374
2021-01-16,CZ,Czechia,EURO,9345,885505,165,14539
2021-01-17,CZ,Czechia,EURO,5254,890759,156,14695
2021-01-18,CZ,Czechia,EURO,2652,893411,158,14853
2021-01-19,CZ,Czechia,EURO,7697,901108,160,15013
2021-01-20,CZ,Czechia,EURO,9635,910743,157,15170
2021-01-21,CZ,Czechia,EURO,8244,918987,148,15318
2021-01-22,CZ,Czechia,EURO,7582,926569,152,15470
2021-01-23,CZ,Czechia,EURO,8494,935063,136,15606
2021-01-24,CZ,Czechia,EURO,4247,939310,143,15749
2021-01-25,CZ,Czechia,EURO,2411,941721,145,15894
2021-01-26,CZ,Czechia,EURO,7010,948731,140,16034
2021-01-27,CZ,Czechia,EURO,9215,957946,143,16177
2021-01-28,CZ,Czechia,EURO,8548,966494,160,16337
2021-01-29,CZ,Czechia,EURO,8039,974533,135,16472
2021-01-30,CZ,Czechia,EURO,8069,982602,152,16624
2021-01-31,CZ,Czechia,EURO,4067,986669,126,16750
2021-02-01,CZ,Czechia,EURO,2586,989255,120,16870
2021-02-02,CZ,Czechia,EURO,7258,996513,133,17003
2021-02-03,CZ,Czechia,EURO,9169,1005682,135,17138
2021-02-04,CZ,Czechia,EURO,9687,1015369,137,17275
2021-02-05,CZ,Czechia,EURO,8121,1023490,129,17404
2021-02-06,CZ,Czechia,EURO,8641,1032131,127,17531
2021-02-07,CZ,Czechia,EURO,4826,1036957,128,17659
2021-02-08,CZ,Czechia,EURO,2459,1039416,131,17790
2021-02-09,CZ,Czechia,EURO,7819,1047235,139,17929
2021-02-10,CZ,Czechia,EURO,10309,1057544,133,18062
2021-02-11,CZ,Czechia,EURO,9575,1067119,133,18195
2021-02-12,CZ,Czechia,EURO,9046,1076165,130,18325
2021-02-13,CZ,Czechia,EURO,8849,1085014,144,18469
2021-02-14,CZ,Czechia,EURO,5150,1090164,117,18586
2021-02-15,CZ,Czechia,EURO,2885,1093049,150,18736
2021-02-16,CZ,Czechia,EURO,8925,1101974,130,18866
2021-02-17,CZ,Czechia,EURO,12626,1114600,150,19016
2021-02-18,CZ,Czechia,EURO,10959,1125559,132,19148
2021-02-19,CZ,Czechia,EURO,11726,1137285,173,19321
2021-02-20,CZ,Czechia,EURO,11304,1148589,181,19502
2021-02-21,CZ,Czechia,EURO,6782,1155371,177,19679
2021-02-22,CZ,Czechia,EURO,4074,1159445,148,19827
2021-02-23,CZ,Czechia,EURO,11453,1170898,165,19992
2021-02-24,CZ,Czechia,EURO,15869,1186767,148,20140
2021-02-25,CZ,Czechia,EURO,13826,1200593,143,20283
2021-02-26,CZ,Czechia,EURO,14614,1215207,182,20465
2021-02-27,CZ,Czechia,EURO,14829,1230036,191,20656
2021-02-28,CZ,Czechia,EURO,7868,1237904,193,20849
2021-03-01,CZ,Czechia,EURO,4601,1242505,183,21032
2021-03-02,CZ,Czechia,EURO,12366,1254871,205,21237
2021-03-03,CZ,Czechia,EURO,16820,1271691,192,21429
2021-03-04,CZ,Czechia,EURO,15268,1286959,201,21630
2021-03-05,CZ,Czechia,EURO,14676,1301635,218,21848
2021-03-06,CZ,Czechia,EURO,13189,1314824,186,22034
2021-03-07,CZ,Czechia,EURO,9138,1323962,209,22243
2021-03-08,CZ,Czechia,EURO,4005,1327967,204,22447
2021-03-09,CZ,Czechia,EURO,10700,1338667,236,22683
2021-03-10,CZ,Czechia,EURO,15402,1354069,231,22914
2021-03-11,CZ,Czechia,EURO,14587,1368656,229,23143
2021-03-12,CZ,Czechia,EURO,11283,1379939,229,23372
2021-03-13,CZ,Czechia,EURO,14994,1394933,213,23585
2021-03-14,CZ,Czechia,EURO,7052,1401985,178,23763
2021-03-15,CZ,Czechia,EURO,3353,1405338,229,23992
2021-03-16,CZ,Czechia,EURO,10661,1415999,238,24230
2021-03-17,CZ,Czechia,EURO,14076,1430075,219,24449
2021-03-18,CZ,Czechia,EURO,12082,1442157,199,24648
2021-03-19,CZ,Czechia,EURO,10721,1452878,214,24862
2021-03-20,CZ,Czechia,EURO,9751,1462629,173,25035
2021-03-21,CZ,Czechia,EURO,5514,1468143,185,25220
2021-03-22,CZ,Czechia,EURO,2400,1470543,193,25413
2021-03-23,CZ,Czechia,EURO,8263,1478806,210,25623
2021-03-24,CZ,Czechia,EURO,11001,1489807,193,25816
2021-03-25,CZ,Czechia,EURO,8882,1498689,185,26001
2021-03-26,CZ,Czechia,EURO,7952,1506641,161,26162
2021-03-27,CZ,Czechia,EURO,7750,1514391,155,26317
2021-03-28,CZ,Czechia,EURO,3982,1518373,181,26498
2021-03-29,CZ,Czechia,EURO,1747,1520120,117,26615
2021-03-30,CZ,Czechia,EURO,6956,1527076,181,26796
2021-03-31,CZ,Czechia,EURO,8653,1535729,171,26967
2021-04-01,CZ,Czechia,EURO,7280,1543009,153,27120
2021-04-02,CZ,Czechia,EURO,6259,1549268,152,27272
2021-04-03,CZ,Czechia,EURO,3853,1553121,104,27376
2021-04-04,CZ,Czechia,EURO,2162,1555283,126,27502
2021-04-05,CZ,Czechia,EURO,1933,1557216,146,27648
2021-04-06,CZ,Czechia,EURO,1435,1558651,124,27772
2021-04-07,CZ,Czechia,EURO,5601,1564252,114,27886
2021-04-08,CZ,Czechia,EURO,7064,1571316,121,28007
2021-04-09,CZ,Czechia,EURO,5303,1576619,122,28129
2021-04-10,CZ,Czechia,EURO,4848,1581467,107,28236
2021-04-11,CZ,Czechia,EURO,2221,1583688,110,28346
2021-04-12,CZ,Czechia,EURO,987,1584675,93,28439
2021-04-13,CZ,Czechia,EURO,3884,1588559,84,28523
2021-04-14,CZ,Czechia,EURO,5093,1593652,91,28614
2021-04-15,CZ,Czechia,EURO,3727,1597379,90,28704
2021-04-16,CZ,Czechia,EURO,3285,1600664,86,28790
2021-04-17,CZ,Czechia,EURO,3229,1603893,66,28856
2021-04-18,CZ,Czechia,EURO,1546,1605439,74,28930
2021-04-19,CZ,Czechia,EURO,842,1606281,78,29008
2021-04-20,CZ,Czechia,EURO,3351,1609632,72,29080
2021-04-21,CZ,Czechia,EURO,3821,1613453,64,29144
2021-04-22,CZ,Czechia,EURO,2966,1616419,64,29208
2021-04-23,CZ,Czechia,EURO,2639,1619058,56,29264
2021-04-24,CZ,Czechia,EURO,2615,1621673,54,29318
2021-04-25,CZ,Czechia,EURO,1317,1622990,57,29375
2021-04-26,CZ,Czechia,EURO,830,1623820,53,29428
2021-04-27,CZ,Czechia,EURO,2605,1626425,58,29486
2021-04-28,CZ,Czechia,EURO,3256,1629681,51,29537
2021-04-29,CZ,Czechia,EURO,2497,1632178,67,29604
2021-04-30,CZ,Czechia,EURO,2238,1634416,42,29646
2021-05-01,CZ,Czechia,EURO,2184,1636600,49,29695
2021-05-02,CZ,Czechia,EURO,1177,1637777,33,29728
2021-05-03,CZ,Czechia,EURO,514,1638291,34,29762
2021-05-04,CZ,Czechia,EURO,2226,1640517,39,29801
2021-05-05,CZ,Czechia,EURO,2426,1642943,44,29845
2021-05-06,CZ,Czechia,EURO,1885,1644828,37,29882
2021-05-07,CZ,Czechia,EURO,1582,1646410,43,29925
2021-05-08,CZ,Czechia,EURO,1649,1648059,28,29953
2021-05-09,CZ,Czechia,EURO,730,1648789,31,29984
2021-05-10,CZ,Czechia,EURO,388,1649177,34,30018
2021-05-11,CZ,Czechia,EURO,1556,1650733,33,30051
2021-05-12,CZ,Czechia,EURO,1701,1652434,33,30084
2021-05-13,CZ,Czechia,EURO,1273,1653707,33,30117
2021-05-14,CZ,Czechia,EURO,1232,1654939,21,30138
2021-05-15,CZ,Czechia,EURO,1058,1655997,18,30156
2021-05-16,CZ,Czechia,EURO,598,1656595,16,30172
2021-05-17,CZ,Czechia,EURO,258,1656853,13,30185
2021-05-18,CZ,Czechia,EURO,1143,1657996,23,30208
2021-05-19,CZ,Czechia,EURO,1208,1659204,14,30222
2021-05-20,CZ,Czechia,EURO,785,1659989,16,30238
2021-05-21,CZ,Czechia,EURO,689,1660678,17,30255
2021-05-22,CZ,Czechia,EURO,679,1661357,13,30268
2021-05-23,CZ,Czechia,EURO,336,1661693,11,30279
2021-05-24,CZ,Czechia,EURO,198,1661891,12,30291
2021-05-25,CZ,Czechia,EURO,703,1662594,6,30297
2021-05-26,CZ,Czechia,EURO,667,1663261,8,30305
2021-05-27,CZ,Czechia,EURO,545,1663806,10,30315
2021-05-28,CZ,Czechia,EURO,516,1664322,15,30330
2021-05-29,CZ,Czechia,EURO,457,1664779,7,30337
2021-05-30,CZ,Czechia,EURO,222,1665001,6,30343
2021-05-31,CZ,Czechia,EURO,113,1665114,4,30347
2021-06-01,CZ,Czechia,EURO,522,1665636,10,30357
2021-06-02,CZ,Czechia,EURO,483,1666119,6,30363
2021-06-03,CZ,Czechia,EURO,357,1666476,5,30368
2021-06-04,CZ,Czechia,EURO,435,1666911,3,30371
2021-06-05,CZ,Czechia,EURO,330,1667241,7,30378
2021-06-06,CZ,Czechia,EURO,153,1667394,2,30380
2021-06-07,CZ,Czechia,EURO,99,1667493,4,30384
2021-06-08,CZ,Czechia,EURO,299,1667792,4,30388
2021-06-09,CZ,Czechia,EURO,387,1668179,6,30394
2021-06-10,CZ,Czechia,EURO,259,1668438,2,30396
2021-06-11,CZ,Czechia,EURO,194,1668632,6,30402
2021-06-12,CZ,Czechia,EURO,182,1668814,2,30404
2021-06-13,CZ,Czechia,EURO,77,1668891,4,30408
2021-06-14,CZ,Czechia,EURO,42,1668933,3,30411
2021-06-15,CZ,Czechia,EURO,178,1669111,0,30411
2021-06-16,CZ,Czechia,EURO,211,1669322,4,30415
2021-06-17,CZ,Czechia,EURO,132,1669454,1,30416
2021-06-18,CZ,Czechia,EURO,163,1669617,4,30420
2021-06-19,CZ,Czechia,EURO,149,1669766,3,30423
2021-06-20,CZ,Czechia,EURO,64,1669830,0,30423
2021-06-21,CZ,Czechia,EURO,58,1669888,1,30424
2021-06-22,CZ,Czechia,EURO,122,1670010,1,30425
2021-06-23,CZ,Czechia,EURO,112,1670122,3,30428
2021-06-24,CZ,Czechia,EURO,111,1670233,0,30428
2021-06-25,CZ,Czechia,EURO,98,1670331,4,30432
2021-06-26,CZ,Czechia,EURO,133,1670464,1,30433
2021-06-27,CZ,Czechia,EURO,67,1670531,2,30435
2021-06-28,CZ,Czechia,EURO,59,1670590,0,30435
2021-06-29,CZ,Czechia,EURO,156,1670746,0,30435
2021-06-30,CZ,Czechia,EURO,162,1670908,0,30435
2021-07-01,CZ,Czechia,EURO,138,1671046,2,30437
2021-07-02,CZ,Czechia,EURO,170,1671216,1,30438
2021-07-03,CZ,Czechia,EURO,167,1671383,2,30440
2021-07-04,CZ,Czechia,EURO,125,1671508,0,30440
2021-07-05,CZ,Czechia,EURO,109,1671617,2,30442
2021-07-06,CZ,Czechia,EURO,130,1671747,0,30442
2021-07-07,CZ,Czechia,EURO,111,1671858,0,30442
2021-07-08,CZ,Czechia,EURO,280,1672138,1,30443
2021-07-09,CZ,Czechia,EURO,259,1672397,0,30443
2021-07-10,CZ,Czechia,EURO,285,1672682,0,30443
2021-07-11,CZ,Czechia,EURO,163,1672845,0,30443
2021-07-12,CZ,Czechia,EURO,158,1673003,2,30445
2021-07-13,CZ,Czechia,EURO,241,1673244,0,30445
2021-07-14,CZ,Czechia,EURO,323,1673567,0,30445
2021-07-15,CZ,Czechia,EURO,257,1673824,0,30445
2021-07-16,CZ,Czechia,EURO,220,1674044,0,30445
2021-07-17,CZ,Czechia,EURO,244,1674288,2,30447
2021-07-18,CZ,Czechia,EURO,197,1674485,0,30447
2021-07-19,CZ,Czechia,EURO,117,1674602,1,30448
2021-07-20,CZ,Czechia,EURO,221,1674823,2,30450
2021-07-21,CZ,Czechia,EURO,300,1675123,0,30450
2021-07-22,CZ,Czechia,EURO,233,1675356,1,30451
2021-07-23,CZ,Czechia,EURO,210,1675566,0,30451
2021-07-24,CZ,Czechia,EURO,189,1675755,0,30451
2021-07-25,CZ,Czechia,EURO,126,1675881,0,30451
2021-07-26,CZ,Czechia,EURO,81,1675962,0,30451
2021-07-27,CZ,Czechia,EURO,200,1676162,0,30451
2021-07-28,CZ,Czechia,EURO,256,1676418,0,30451
2021-07-29,CZ,Czechia,EURO,201,1676619,0,30451
2021-07-30,CZ,Czechia,EURO,207,1676826,0,30451
2021-07-31,CZ,Czechia,EURO,140,1676966,0,30451
2021-08-01,CZ,Czechia,EURO,117,1677083,2,30453
2021-08-02,CZ,Czechia,EURO,77,1677160,2,30455
2021-08-03,CZ,Czechia,EURO,153,1677313,1,30456
2021-08-04,CZ,Czechia,EURO,242,1677555,0,30456
2021-08-05,CZ,Czechia,EURO,209,1677764,0,30456
2021-08-06,CZ,Czechia,EURO,165,1677929,1,30457
2021-08-07,CZ,Czechia,EURO,178,1678107,2,30459
2021-08-08,CZ,Czechia,EURO,154,1678261,0,30459
2021-08-09,CZ,Czechia,EURO,107,1678368,0,30459
2021-08-10,CZ,Czechia,EURO,175,1678543,1,30460
2021-08-11,CZ,Czechia,EURO,261,1678804,0,30460
2021-08-12,CZ,Czechia,EURO,220,1679024,1,30461
2021-08-13,CZ,Czechia,EURO,190,1679214,0,30461
2021-08-14,CZ,Czechia,EURO,223,1679437,0,30461
2021-08-15,CZ,Czechia,EURO,142,1679579,0,30461
2021-08-16,CZ,Czechia,EURO,77,1679656,3,30464
2021-08-17,CZ,Czechia,EURO,216,1679872,3,30467
2021-08-18,CZ,Czechia,EURO,300,1680172,1,30468
2021-08-19,CZ,Czechia,EURO,209,1680381,2,30470
2021-08-20,CZ,Czechia,EURO,166,1680547,2,30472
2021-08-21,CZ,Czechia,EURO,171,1680718,1,30473
2021-08-22,CZ,Czechia,EURO,135,1680853,0,30473
2021-08-23,CZ,Czechia,EURO,107,1680960,0,30473
2021-08-24,CZ,Czechia,EURO,213,1681173,1,30474
2021-08-25,CZ,Czechia,EURO,252,1681425,1,30475
2021-08-26,CZ,Czechia,EURO,249,1681674,2,30477
2021-08-27,CZ,Czechia,EURO,214,1681888,0,30477
2021-08-28,CZ,Czechia,EURO,183,1682071,1,30478
2021-08-29,CZ,Czechia,EURO,133,1682204,2,30480
2021-08-30,CZ,Czechia,EURO,81,1682285,1,30481
2021-08-31,CZ,Czechia,EURO,241,1682526,0,30481
2021-09-01,CZ,Czechia,EURO,291,1682817,0,30481
2021-09-02,CZ,Czechia,EURO,262,1683079,0,30481
2021-09-03,CZ,Czechia,EURO,306,1683385,2,30483
2021-09-04,CZ,Czechia,EURO,310,1683695,0,30483
2021-09-05,CZ,Czechia,EURO,207,1683902,0,30483
2021-09-06,CZ,Czechia,EURO,141,1684043,0,30483
2021-09-07,CZ,Czechia,EURO,393,1684436,1,30484
2021-09-08,CZ,Czechia,EURO,583,1685019,2,30486
2021-09-09,CZ,Czechia,EURO,382,1685401,1,30487
2021-09-10,CZ,Czechia,EURO,420,1685821,0,30487
2021-09-11,CZ,Czechia,EURO,445,1686266,0,30487
2021-09-12,CZ,Czechia,EURO,250,1686516,0,30487
2021-09-13,CZ,Czechia,EURO,136,1686652,2,30489
2021-09-14,CZ,Czechia,EURO,495,1687147,0,30489
2021-09-15,CZ,Czechia,EURO,557,1687704,3,30492
2021-09-16,CZ,Czechia,EURO,524,1688228,3,30495
2021-09-17,CZ,Czechia,EURO,562,1688790,0,30495
2021-09-18,CZ,Czechia,EURO,448,1689238,2,30497
2021-09-19,CZ,Czechia,EURO,302,1689540,5,30502
2021-09-20,CZ,Czechia,EURO,188,1689728,2,30504
2021-09-21,CZ,Czechia,EURO,481,1690209,4,30508
2021-09-22,CZ,Czechia,EURO,597,1690806,2,30510
2021-09-23,CZ,Czechia,EURO,523,1691329,2,30512
2021-09-24,CZ,Czechia,EURO,484,1691813,3,30515
2021-09-25,CZ,Czechia,EURO,531,1692344,0,30515
2021-09-26,CZ,Czechia,EURO,418,1692762,2,30517
2021-09-27,CZ,Czechia,EURO,251,1693013,0,30517
2021-09-28,CZ,Czechia,EURO,677,1693690,0,30517
2021-09-29,CZ,Czechia,EURO,474,1694164,3,30520
2021-09-30,CZ,Czechia,EURO,734,1694898,5,30525
2021-10-01,CZ,Czechia,EURO,922,1695820,1,30526
2021-10-02,CZ,Czechia,EURO,829,1696649,1,30527
2021-10-03,CZ,Czechia,EURO,552,1697201,1,30528
2021-10-04,CZ,Czechia,EURO,318,1697519,4,30532
2021-10-05,CZ,Czechia,EURO,823,1698342,4,30536
2021-10-06,CZ,Czechia,EURO,1131,1699473,3,30539
2021-10-07,CZ,Czechia,EURO,1048,1700521,5,30544
2021-10-08,CZ,Czechia,EURO,992,1701513,3,30547
2021-10-09,CZ,Czechia,EURO,1019,1702532,4,30551
2021-10-10,CZ,Czechia,EURO,668,1703200,3,30554
2021-10-11,CZ,Czechia,EURO,338,1703538,4,30558
2021-10-12,CZ,Czechia,EURO,1346,1704884,5,30563
2021-10-13,CZ,Czechia,EURO,1508,1706392,7,30570
2021-10-14,CZ,Czechia,EURO,1500,1707892,6,30576
2021-10-15,CZ,Czechia,EURO,1540,1709432,6,30582
2021-10-16,CZ,Czechia,EURO,1782,1711214,10,30592
2021-10-17,CZ,Czechia,EURO,1158,1712372,8,30600
2021-10-18,CZ,Czechia,EURO,796,1713168,11,30611
2021-10-19,CZ,Czechia,EURO,2539,1715707,12,30623
2021-10-20,CZ,Czechia,EURO,3249,1718956,10,30633
2021-10-21,CZ,Czechia,EURO,3281,1722237,7,30640
2021-10-22,CZ,Czechia,EURO,3646,1725883,10,30650
2021-10-23,CZ,Czechia,EURO,4239,1730122,14,30664
2021-10-24,CZ,Czechia,EURO,2756,1732878,13,30677
2021-10-25,CZ,Czechia,EURO,1840,1734718,21,30698
2021-10-26,CZ,Czechia,EURO,4287,1739005,20,30718
2021-10-27,CZ,Czechia,EURO,6291,1745296,16,30734
2021-10-28,CZ,Czechia,EURO,5866,1751162,21,30755
2021-10-29,CZ,Czechia,EURO,4357,1755519,26,30781
2021-10-30,CZ,Czechia,EURO,5759,1761278,26,30807
2021-10-31,CZ,Czechia,EURO,5061,1766339,24,30831
2021-11-01,CZ,Czechia,EURO,2792,1769131,31,30862
2021-11-02,CZ,Czechia,EURO,7617,1776748,31,30893
2021-11-03,CZ,Czechia,EURO,9941,1786689,36,30929
2021-11-04,CZ,Czechia,EURO,9483,1796172,45,30974
2021-11-05,CZ,Czechia,EURO,8494,1804666,45,31019
2021-11-06,CZ,Czechia,EURO,9256,1813922,57,31076
2021-11-07,CZ,Czechia,EURO,5744,1819666,52,31128
2021-11-08,CZ,Czechia,EURO,3012,1822678,39,31167
2021-11-09,CZ,Czechia,EURO,9289,1831967,48,31215
2021-11-10,CZ,Czechia,EURO,14583,1846550,63,31278
2021-11-11,CZ,Czechia,EURO,13571,1860121,75,31353
2021-11-12,CZ,Czechia,EURO,10454,1870575,71,31424
2021-11-13,CZ,Czechia,EURO,14260,1884835,68,31492
2021-11-14,CZ,Czechia,EURO,9183,1894018,74,31566
2021-11-15,CZ,Czechia,EURO,5698,1899716,62,31628
2021-11-16,CZ,Czechia,EURO,11562,1911278,93,31721
2021-11-17,CZ,Czechia,EURO,22540,1933818,70,31791
2021-11-18,CZ,Czechia,EURO,14198,1948016,82,31873
2021-11-19,CZ,Czechia,EURO,13518,1961534,120,31993
2021-11-20,CZ,Czechia,EURO,22972,1984506,113,32106
2021-11-21,CZ,Czechia,EURO,14414,1998920,96,32202
2021-11-22,CZ,Czechia,EURO,8278,2007198,113,32315
2021-11-23,CZ,Czechia,EURO,14518,2021716,111,32426
2021-11-24,CZ,Czechia,EURO,25912,2047628,115,32541
2021-11-25,CZ,Czechia,EURO,18046,2065674,93,32634
2021-11-26,CZ,Czechia,EURO,27937,2093611,114,32748
2021-11-27,CZ,Czechia,EURO,20383,2113994,118,32866
2021-11-28,CZ,Czechia,EURO,12528,2126522,95,32961
2021-11-29,CZ,Czechia,EURO,9307,2135829,120,33081
2021-11-30,CZ,Czechia,EURO,17617,2153446,108,33189
2021-12-01,CZ,Czechia,EURO,22024,2175470,120,33309
2021-12-02,CZ,Czechia,EURO,21154,2196624,140,33449
2021-12-03,CZ,Czechia,EURO,18623,2215247,125,33574
2021-12-04,CZ,Czechia,EURO,17685,2232932,119,33693
2021-12-05,CZ,Czechia,EURO,10982,2243914,109,33802
2021-12-06,CZ,Czechia,EURO,6334,2250248,110,33912
2021-12-07,CZ,Czechia,EURO,15580,2265828,123,34035
2021-12-08,CZ,Czechia,EURO,19533,2285361,110,34145
2021-12-09,CZ,Czechia,EURO,16209,2301570,113,34258
2021-12-10,CZ,Czechia,EURO,14265,2315835,114,34372
2021-12-11,CZ,Czechia,EURO,12400,2328235,120,34492
2021-12-12,CZ,Czechia,EURO,9086,2337321,100,34592
2021-12-13,CZ,Czechia,EURO,4129,2341450,123,34715
2021-12-14,CZ,Czechia,EURO,11905,2353355,114,34829
2021-12-15,CZ,Czechia,EURO,16707,2370062,114,34943
2021-12-16,CZ,Czechia,EURO,11617,2381679,124,35067
2021-12-17,CZ,Czechia,EURO,9499,2391178,97,35164
2021-12-18,CZ,Czechia,EURO,8962,2400140,88,35252
2021-12-19,CZ,Czechia,EURO,5985,2406125,103,35355
2021-12-20,CZ,Czechia,EURO,3744,2409869,68,35423
2021-12-21,CZ,Czechia,EURO,8599,2418468,79,35502
2021-12-22,CZ,Czechia,EURO,11846,2430314,81,35583
2021-12-23,CZ,Czechia,EURO,7696,2438010,84,35667
2021-12-24,CZ,Czechia,EURO,7360,2445370,58,35725
2021-12-25,CZ,Czechia,EURO,2045,2447415,78,35803
2021-12-26,CZ,Czechia,EURO,1090,2448505,68,35871
2021-12-27,CZ,Czechia,EURO,2015,2450520,84,35955
2021-12-28,CZ,Czechia,EURO,6863,2457383,51,36006
2021-12-29,CZ,Czechia,EURO,9077,2466460,72,36078
2021-12-30,CZ,Czechia,EURO,6160,2472620,75,36153
2021-12-31,CZ,Czechia,EURO,5756,2478376,58,36211
2022-01-01,CZ,Czechia,EURO,4997,2483373,55,36266
2022-01-02,CZ,Czechia,EURO,1093,2484466,46,36312
2022-01-03,CZ,Czechia,EURO,1931,2486397,51,36363
2022-01-04,CZ,Czechia,EURO,9357,2495754,61,36424
2022-01-05,CZ,Czechia,EURO,10180,2505934,61,36485
2022-01-06,CZ,Czechia,EURO,7388,2513322,39,36524
2022-01-07,CZ,Czechia,EURO,6641,2519963,58,36582
2022-01-08,CZ,Czechia,EURO,6672,2526635,45,36627
2022-01-09,CZ,Czechia,EURO,3963,2530598,43,36670
2022-01-10,CZ,Czechia,EURO,2764,2533362,23,36693
2022-01-11,CZ,Czechia,EURO,7355,2540717,44,36737
2022-01-12,CZ,Czechia,EURO,12377,2553094,38,36775
2022-01-13,CZ,Czechia,EURO,11467,2564561,41,36816
2022-01-14,CZ,Czechia,EURO,11692,2576253,32,36848
2022-01-15,CZ,Czechia,EURO,13224,2589477,33,36881
2022-01-16,CZ,Czechia,EURO,9293,2598770,25,36906
2022-01-17,CZ,Czechia,EURO,7246,2606016,30,36936
2022-01-18,CZ,Czechia,EURO,20306,2626322,27,36963
2022-01-19,CZ,Czechia,EURO,28502,2654824,25,36988
2022-01-20,CZ,Czechia,EURO,26015,2680839,27,37015
2022-01-21,CZ,Czechia,EURO,26938,2707777,19,37034
2022-01-22,CZ,Czechia,EURO,26616,2734393,21,37055
2022-01-23,CZ,Czechia,EURO,18355,2752748,22,37077
2022-01-24,CZ,Czechia,EURO,12898,2765646,18,37095
2022-01-25,CZ,Czechia,EURO,30391,2796037,22,37117
2022-01-26,CZ,Czechia,EURO,39633,2835670,14,37131
2022-01-27,CZ,Czechia,EURO,54696,2890366,20,37151
2022-01-28,CZ,Czechia,EURO,34810,2925176,26,37177
2022-01-29,CZ,Czechia,EURO,47264,2972440,20,37197
2022-01-30,CZ,Czechia,EURO,18281,2990721,26,37223
2022-01-31,CZ,Czechia,EURO,23936,3014657,28,37251
2022-02-01,CZ,Czechia,EURO,29547,3044204,34,37285
2022-02-02,CZ,Czechia,EURO,57233,3101437,43,37328
2022-02-03,CZ,Czechia,EURO,43327,3144764,39,37367
2022-02-04,CZ,Czechia,EURO,37683,3182447,37,37404
2022-02-05,CZ,Czechia,EURO,28700,3211147,52,37456
2022-02-06,CZ,Czechia,EURO,24001,3235148,46,37502
2022-02-07,CZ,Czechia,EURO,9069,3244217,44,37546
2022-02-08,CZ,Czechia,EURO,29612,3273829,59,37605
2022-02-09,CZ,Czechia,EURO,37646,3311475,51,37656
2022-02-10,CZ,Czechia,EURO,29052,3340527,44,37700
2022-02-11,CZ,Czechia,EURO,22668,3363195,48,37748
2022-02-12,CZ,Czechia,EURO,22129,3385324,52,37800
2022-02-13,CZ,Czechia,EURO,10952,3396276,45,37845
2022-02-14,CZ,Czechia,EURO,7193,3403469,28,37873
.
40864a
2022-02-12,CY,Cyprus,EURO,2485,285943,4,780
2022-02-13,CY,Cyprus,EURO,2120,288063,5,785
2022-02-14,CY,Cyprus,EURO,2047,290110,0,785
.
40093a
2022-02-12,CW,Curaçao,AMRO,99,38172,1,249
2022-02-13,CW,Curaçao,AMRO,0,38172,0,249
2022-02-14,CW,Curaçao,AMRO,0,38172,0,249
.
39322a
2022-02-12,CU,Cuba,AMRO,1149,1058946,6,8460
2022-02-13,CU,Cuba,AMRO,888,1059834,7,8467
2022-02-14,CU,Cuba,AMRO,898,1060732,5,8472
.
38551a
2022-02-12,HR,Croatia,EURO,5169,1009973,44,14373
2022-02-13,HR,Croatia,EURO,2730,1012703,51,14424
2022-02-14,HR,Croatia,EURO,5212,1017915,49,14473
.
37780a
2022-02-12,CI,Côte d’Ivoire,AFRO,69,81109,0,789
2022-02-13,CI,Côte d’Ivoire,AFRO,9,81118,0,789
2022-02-14,CI,Côte d’Ivoire,AFRO,0,81118,0,789
.
37009a
2022-02-12,CR,Costa Rica,AMRO,5656,751605,22,7752
2022-02-13,CR,Costa Rica,AMRO,5488,757093,20,7772
2022-02-14,CR,Costa Rica,AMRO,0,757093,0,7772
.
36238a
2022-02-12,CK,Cook Islands,WPRO,0,0,0,0
2022-02-13,CK,Cook Islands,WPRO,0,0,0,0
2022-02-14,CK,Cook Islands,WPRO,0,0,0,0
.
35467a
2022-02-12,CG,Congo,AFRO,0,23860,0,375
2022-02-13,CG,Congo,AFRO,0,23860,0,375
2022-02-14,CG,Congo,AFRO,14,23874,0,375
.
34696a
2022-02-12,KM,Comoros,AFRO,0,7978,0,160
2022-02-13,KM,Comoros,AFRO,0,7978,0,160
2022-02-14,KM,Comoros,AFRO,27,8005,0,160
.
33925a
2022-02-12,CO,Colombia,AMRO,8269,6002570,179,136583
2022-02-13,CO,Colombia,AMRO,5421,6007991,181,136764
2022-02-14,CO,Colombia,AMRO,6572,6014563,189,136953
.
33154a
2022-02-12,CN,China,WPRO,1503,146516,0,5703
2022-02-13,CN,China,WPRO,1641,148157,3,5706
2022-02-14,CN,China,WPRO,1483,149640,0,5706
.
32383a
2022-02-12,CL,Chile,AMRO,41651,2545819,97,40370
2022-02-13,CL,Chile,AMRO,37115,2582934,94,40464
2022-02-14,CL,Chile,AMRO,38493,2621427,94,40558
.
31612a
2022-02-12,TD,Chad,AFRO,0,7216,0,190
2022-02-13,TD,Chad,AFRO,0,7216,0,190
2022-02-14,TD,Chad,AFRO,0,7216,0,190
.
30841a
2022-02-12,CF,Central African Republic,AFRO,0,14154,0,111
2022-02-13,CF,Central African Republic,AFRO,0,14154,0,111
2022-02-14,CF,Central African Republic,AFRO,33,14187,2,113
.
30070a
2022-02-12,KY,Cayman Islands,AMRO,1753,17687,0,16
2022-02-13,KY,Cayman Islands,AMRO,0,17687,0,16
2022-02-14,KY,Cayman Islands,AMRO,0,17687,0,16
.
29299a
2022-02-12,CA,Canada,AMRO,10632,3170649,113,35231
2022-02-13,CA,Canada,AMRO,0,3170649,0,35231
2022-02-14,CA,Canada,AMRO,0,3170649,0,35231
.
28528a
2022-02-12,CM,Cameroon,AFRO,0,118675,0,1915
2022-02-13,CM,Cameroon,AFRO,0,118675,0,1915
2022-02-14,CM,Cameroon,AFRO,0,118675,0,1915
.
27757a
2022-02-12,KH,Cambodia,WPRO,274,122742,0,3015
2022-02-13,KH,Cambodia,WPRO,300,123042,0,3015
2022-02-14,KH,Cambodia,WPRO,401,123443,0,3015
.
26986a
2022-02-12,CV,Cabo Verde,AFRO,0,55820,0,398
2022-02-13,CV,Cabo Verde,AFRO,0,55820,0,398
2022-02-14,CV,Cabo Verde,AFRO,22,55842,2,400
.
26215a
2022-02-12,BI,Burundi,AFRO,27,37883,0,15
2022-02-13,BI,Burundi,AFRO,0,37883,0,15
2022-02-14,BI,Burundi,AFRO,19,37902,0,15
.
25444a
2022-02-12,BF,Burkina Faso,AFRO,3,20699,0,375
2022-02-13,BF,Burkina Faso,AFRO,6,20705,0,375
2022-02-14,BF,Burkina Faso,AFRO,11,20716,0,375
.
24673a
2022-02-12,BG,Bulgaria,EURO,6531,1031660,86,34314
2022-02-13,BG,Bulgaria,EURO,3625,1035285,45,34359
2022-02-14,BG,Bulgaria,EURO,1539,1036824,45,34404
.
23902a
2022-02-12,BN,Brunei Darussalam,WPRO,981,20454,0,59
2022-02-13,BN,Brunei Darussalam,WPRO,1125,21579,0,59
2022-02-14,BN,Brunei Darussalam,WPRO,936,22515,0,59
.
23131c
2022-02-11,VG,British Virgin Islands,AMRO,69,5997,3,61
2022-02-12,VG,British Virgin Islands,AMRO,0,5997,0,61
2022-02-13,VG,British Virgin Islands,AMRO,0,5997,0,61
2022-02-14,VG,British Virgin Islands,AMRO,0,5997,0,61
.
22360a
2022-02-12,BR,Brazil,AMRO,164066,27119500,943,636017
2022-02-13,BR,Brazil,AMRO,166009,27285509,1135,637152
2022-02-14,BR,Brazil,AMRO,140234,27425743,896,638048
.
21589a
2022-02-12,BW,Botswana,AFRO,0,259655,0,2597
2022-02-13,BW,Botswana,AFRO,0,259655,0,2597
2022-02-14,BW,Botswana,AFRO,0,259655,0,2597
.
20818a
2022-02-12,BA,Bosnia and Herzegovina,EURO,1338,362527,46,14984
2022-02-13,BA,Bosnia and Herzegovina,EURO,1289,363816,29,15013
2022-02-14,BA,Bosnia and Herzegovina,EURO,177,363993,18,15031
.
20047a
2022-02-12,XA,Bonaire,AMRO,32,6752,0,28
2022-02-13,XA,Bonaire,AMRO,0,6752,0,28
2022-02-14,XA,Bonaire,AMRO,0,6752,0,28
.
19276a
2022-02-12,BO,Bolivia (Plurinational State of),AMRO,1969,880891,21,21240
2022-02-13,BO,Bolivia (Plurinational State of),AMRO,0,880891,0,21240
2022-02-14,BO,Bolivia (Plurinational State of),AMRO,2491,883382,44,21284
.
18505a
2022-02-12,BT,Bhutan,SEARO,235,7199,0,5
2022-02-13,BT,Bhutan,SEARO,230,7429,0,5
2022-02-14,BT,Bhutan,SEARO,237,7666,0,5
.
17734a
2022-02-12,BM,Bermuda,AMRO,38,11146,0,120
2022-02-13,BM,Bermuda,AMRO,0,11146,0,120
2022-02-14,BM,Bermuda,AMRO,0,11146,0,120
.
16963a
2022-02-12,BJ,Benin,AFRO,0,26552,0,163
2022-02-13,BJ,Benin,AFRO,0,26552,0,163
2022-02-14,BJ,Benin,AFRO,0,26552,0,163
.
16192a
2022-02-12,BZ,Belize,AMRO,215,54973,0,631
2022-02-13,BZ,Belize,AMRO,210,55183,0,631
2022-02-14,BZ,Belize,AMRO,0,55183,0,631
.
15106,15421c
2021-04-02,BE,Belgium,EURO,4687,891295,40,23255
2021-04-03,BE,Belgium,EURO,4894,896189,46,23301
2021-04-04,BE,Belgium,EURO,2701,898890,40,23341
2021-04-05,BE,Belgium,EURO,1513,900403,36,23377
2021-04-06,BE,Belgium,EURO,1562,901965,49,23426
2021-04-07,BE,Belgium,EURO,5259,907224,46,23472
2021-04-08,BE,Belgium,EURO,4741,911965,43,23515
2021-04-09,BE,Belgium,EURO,4466,916431,43,23558
2021-04-10,BE,Belgium,EURO,4496,920927,44,23602
2021-04-11,BE,Belgium,EURO,2361,923288,46,23648
2021-04-12,BE,Belgium,EURO,1305,924593,22,23670
2021-04-13,BE,Belgium,EURO,4729,929322,44,23714
2021-04-14,BE,Belgium,EURO,4281,933603,37,23751
2021-04-15,BE,Belgium,EURO,3899,937502,39,23790
2021-04-16,BE,Belgium,EURO,3807,941309,42,23832
2021-04-17,BE,Belgium,EURO,4021,945330,45,23877
2021-04-18,BE,Belgium,EURO,2322,947652,30,23907
2021-04-19,BE,Belgium,EURO,1312,948964,35,23942
2021-04-20,BE,Belgium,EURO,5433,954397,50,23992
2021-04-21,BE,Belgium,EURO,4458,958855,36,24028
2021-04-22,BE,Belgium,EURO,4068,962923,36,24064
2021-04-23,BE,Belgium,EURO,3801,966724,43,24107
2021-04-24,BE,Belgium,EURO,3636,970360,42,24149
2021-04-25,BE,Belgium,EURO,1889,972249,36,24185
2021-04-26,BE,Belgium,EURO,1138,973387,39,24224
2021-04-27,BE,Belgium,EURO,4270,977657,44,24268
2021-04-28,BE,Belgium,EURO,3760,981417,26,24294
2021-04-29,BE,Belgium,EURO,3448,984865,49,24343
2021-04-30,BE,Belgium,EURO,3347,988212,46,24389
2021-05-01,BE,Belgium,EURO,3487,991699,33,24422
2021-05-02,BE,Belgium,EURO,1335,993034,28,24450
2021-05-03,BE,Belgium,EURO,1137,994171,34,24484
2021-05-04,BE,Belgium,EURO,4331,998502,43,24527
2021-05-05,BE,Belgium,EURO,3651,1002153,40,24567
2021-05-06,BE,Belgium,EURO,3615,1005768,38,24605
2021-05-07,BE,Belgium,EURO,3515,1009283,38,24643
2021-05-08,BE,Belgium,EURO,3294,1012577,26,24669
2021-05-09,BE,Belgium,EURO,1714,1014291,42,24711
2021-05-10,BE,Belgium,EURO,855,1015146,32,24743
2021-05-11,BE,Belgium,EURO,3362,1018508,28,24771
2021-05-12,BE,Belgium,EURO,2989,1021497,17,24788
2021-05-13,BE,Belgium,EURO,2807,1024304,19,24807
2021-05-14,BE,Belgium,EURO,943,1025247,21,24828
2021-05-15,BE,Belgium,EURO,2557,1027804,20,24848
2021-05-16,BE,Belgium,EURO,1254,1029058,22,24870
2021-05-17,BE,Belgium,EURO,735,1029793,17,24887
2021-05-18,BE,Belgium,EURO,3576,1033369,24,24911
2021-05-19,BE,Belgium,EURO,3265,1036634,17,24928
2021-05-20,BE,Belgium,EURO,3118,1039752,25,24953
2021-05-21,BE,Belgium,EURO,2409,1042161,16,24969
2021-05-22,BE,Belgium,EURO,2425,1044586,19,24988
2021-05-23,BE,Belgium,EURO,1434,1046020,18,25006
2021-05-24,BE,Belgium,EURO,773,1046793,11,25017
2021-05-25,BE,Belgium,EURO,899,1047692,19,25036
2021-05-26,BE,Belgium,EURO,2789,1050481,16,25052
2021-05-27,BE,Belgium,EURO,2534,1053015,14,25066
2021-05-28,BE,Belgium,EURO,2215,1055230,6,25072
2021-05-29,BE,Belgium,EURO,2023,1057253,11,25083
2021-05-30,BE,Belgium,EURO,1116,1058369,16,25099
2021-05-31,BE,Belgium,EURO,603,1058972,18,25117
2021-06-01,BE,Belgium,EURO,2026,1060998,14,25131
2021-06-02,BE,Belgium,EURO,1682,1062680,11,25142
2021-06-03,BE,Belgium,EURO,1498,1064178,16,25158
2021-06-04,BE,Belgium,EURO,1466,1065644,15,25173
2021-06-05,BE,Belgium,EURO,1349,1066993,10,25183
2021-06-06,BE,Belgium,EURO,647,1067640,13,25196
2021-06-07,BE,Belgium,EURO,399,1068039,7,25203
2021-06-08,BE,Belgium,EURO,1237,1069276,5,25208
2021-06-09,BE,Belgium,EURO,1041,1070317,13,25221
2021-06-10,BE,Belgium,EURO,841,1071158,6,25227
2021-06-11,BE,Belgium,EURO,764,1071922,7,25234
2021-06-12,BE,Belgium,EURO,779,1072701,9,25243
2021-06-13,BE,Belgium,EURO,390,1073091,6,25249
2021-06-14,BE,Belgium,EURO,209,1073300,4,25253
2021-06-15,BE,Belgium,EURO,765,1074065,6,25259
2021-06-16,BE,Belgium,EURO,535,1074600,6,25265
2021-06-17,BE,Belgium,EURO,419,1075019,6,25271
2021-06-18,BE,Belgium,EURO,450,1075469,7,25278
2021-06-19,BE,Belgium,EURO,424,1075893,9,25287
2021-06-20,BE,Belgium,EURO,274,1076167,6,25293
2021-06-21,BE,Belgium,EURO,139,1076306,3,25296
2021-06-22,BE,Belgium,EURO,482,1076788,5,25301
2021-06-23,BE,Belgium,EURO,365,1077153,3,25304
2021-06-24,BE,Belgium,EURO,396,1077549,5,25309
2021-06-25,BE,Belgium,EURO,339,1077888,5,25314
2021-06-26,BE,Belgium,EURO,398,1078286,5,25319
2021-06-27,BE,Belgium,EURO,259,1078545,2,25321
2021-06-28,BE,Belgium,EURO,177,1078722,3,25324
2021-06-29,BE,Belgium,EURO,598,1079320,2,25326
2021-06-30,BE,Belgium,EURO,557,1079877,5,25331
2021-07-01,BE,Belgium,EURO,628,1080505,2,25333
2021-07-02,BE,Belgium,EURO,676,1081181,5,25338
2021-07-03,BE,Belgium,EURO,724,1081905,3,25341
2021-07-04,BE,Belgium,EURO,521,1082426,3,25344
2021-07-05,BE,Belgium,EURO,366,1082792,2,25346
2021-07-06,BE,Belgium,EURO,998,1083790,3,25349
2021-07-07,BE,Belgium,EURO,1042,1084832,1,25350
2021-07-08,BE,Belgium,EURO,1173,1086005,0,25350
2021-07-09,BE,Belgium,EURO,1227,1087232,2,25352
2021-07-10,BE,Belgium,EURO,1289,1088521,2,25354
2021-07-11,BE,Belgium,EURO,1004,1089525,5,25359
2021-07-12,BE,Belgium,EURO,781,1090306,0,25359
2021-07-13,BE,Belgium,EURO,1764,1092070,2,25361
2021-07-14,BE,Belgium,EURO,1429,1093499,0,25361
2021-07-15,BE,Belgium,EURO,1446,1094945,1,25362
2021-07-16,BE,Belgium,EURO,1390,1096335,2,25364
2021-07-17,BE,Belgium,EURO,1570,1097905,2,25366
2021-07-18,BE,Belgium,EURO,1104,1099009,0,25366
2021-07-19,BE,Belgium,EURO,838,1099847,2,25368
2021-07-20,BE,Belgium,EURO,2133,1101980,0,25368
2021-07-21,BE,Belgium,EURO,1955,1103935,0,25368
2021-07-22,BE,Belgium,EURO,790,1104725,3,25371
2021-07-23,BE,Belgium,EURO,1914,1106639,4,25375
2021-07-24,BE,Belgium,EURO,1656,1108295,2,25377
2021-07-25,BE,Belgium,EURO,1158,1109453,3,25380
2021-07-26,BE,Belgium,EURO,784,1110237,2,25382
2021-07-27,BE,Belgium,EURO,2112,1112349,1,25383
2021-07-28,BE,Belgium,EURO,1600,1113949,4,25387
2021-07-29,BE,Belgium,EURO,1752,1115701,1,25388
2021-07-30,BE,Belgium,EURO,1782,1117483,6,25394
2021-07-31,BE,Belgium,EURO,1797,1119280,6,25400
2021-08-01,BE,Belgium,EURO,1186,1120466,3,25403
2021-08-02,BE,Belgium,EURO,1056,1121522,1,25404
2021-08-03,BE,Belgium,EURO,2251,1123773,5,25409
2021-08-04,BE,Belgium,EURO,1950,1125723,5,25414
2021-08-05,BE,Belgium,EURO,1875,1127598,4,25418
2021-08-06,BE,Belgium,EURO,1836,1129434,3,25421
2021-08-07,BE,Belgium,EURO,2133,1131567,3,25424
2021-08-08,BE,Belgium,EURO,1275,1132842,3,25427
2021-08-09,BE,Belgium,EURO,922,1133764,3,25430
2021-08-10,BE,Belgium,EURO,2597,1136361,5,25435
2021-08-11,BE,Belgium,EURO,2218,1138579,2,25437
2021-08-12,BE,Belgium,EURO,1992,1140571,2,25439
2021-08-13,BE,Belgium,EURO,2158,1142729,3,25442
2021-08-14,BE,Belgium,EURO,2273,1145002,5,25447
2021-08-15,BE,Belgium,EURO,1352,1146354,4,25451
2021-08-16,BE,Belgium,EURO,766,1147120,2,25453
2021-08-17,BE,Belgium,EURO,2829,1149949,5,25458
2021-08-18,BE,Belgium,EURO,2247,1152196,3,25461
2021-08-19,BE,Belgium,EURO,2265,1154461,4,25465
2021-08-20,BE,Belgium,EURO,2007,1156468,9,25474
2021-08-21,BE,Belgium,EURO,2245,1158713,9,25483
2021-08-22,BE,Belgium,EURO,1285,1159998,7,25490
2021-08-23,BE,Belgium,EURO,956,1160954,7,25497
2021-08-24,BE,Belgium,EURO,2654,1163608,3,25500
2021-08-25,BE,Belgium,EURO,2460,1166068,6,25506
2021-08-26,BE,Belgium,EURO,2395,1168463,7,25513
2021-08-27,BE,Belgium,EURO,2186,1170649,6,25519
2021-08-28,BE,Belgium,EURO,2217,1172866,5,25524
2021-08-29,BE,Belgium,EURO,1372,1174238,4,25528
2021-08-30,BE,Belgium,EURO,832,1175070,4,25532
2021-08-31,BE,Belgium,EURO,2943,1178013,5,25537
2021-09-01,BE,Belgium,EURO,2357,1180370,4,25541
2021-09-02,BE,Belgium,EURO,2222,1182592,7,25548
2021-09-03,BE,Belgium,EURO,2113,1184705,6,25554
2021-09-04,BE,Belgium,EURO,2155,1186860,6,25560
2021-09-05,BE,Belgium,EURO,1243,1188103,10,25570
2021-09-06,BE,Belgium,EURO,733,1188836,8,25578
2021-09-07,BE,Belgium,EURO,2800,1191636,7,25585
2021-09-08,BE,Belgium,EURO,2361,1193997,9,25594
2021-09-09,BE,Belgium,EURO,2190,1196187,9,25603
2021-09-10,BE,Belgium,EURO,2105,1198292,6,25609
2021-09-11,BE,Belgium,EURO,2323,1200615,7,25616
2021-09-12,BE,Belgium,EURO,1306,1201921,7,25623
2021-09-13,BE,Belgium,EURO,679,1202600,7,25630
2021-09-14,BE,Belgium,EURO,2930,1205530,7,25637
2021-09-15,BE,Belgium,EURO,2496,1208026,8,25645
2021-09-16,BE,Belgium,EURO,2322,1210348,7,25652
2021-09-17,BE,Belgium,EURO,2426,1212774,1,25653
2021-09-18,BE,Belgium,EURO,2390,1215164,5,25658
2021-09-19,BE,Belgium,EURO,1260,1216424,9,25667
2021-09-20,BE,Belgium,EURO,652,1217076,7,25674
2021-09-21,BE,Belgium,EURO,2940,1220016,6,25680
2021-09-22,BE,Belgium,EURO,2269,1222285,5,25685
2021-09-23,BE,Belgium,EURO,2171,1224456,11,25696
2021-09-24,BE,Belgium,EURO,2080,1226536,11,25707
2021-09-25,BE,Belgium,EURO,2253,1228789,7,25714
2021-09-26,BE,Belgium,EURO,1216,1230005,7,25721
2021-09-27,BE,Belgium,EURO,723,1230728,7,25728
2021-09-28,BE,Belgium,EURO,2628,1233356,13,25741
2021-09-29,BE,Belgium,EURO,2391,1235747,7,25748
2021-09-30,BE,Belgium,EURO,2166,1237913,7,25755
2021-10-01,BE,Belgium,EURO,2163,1240076,11,25766
2021-10-02,BE,Belgium,EURO,2148,1242224,6,25772
2021-10-03,BE,Belgium,EURO,1147,1243371,8,25780
2021-10-04,BE,Belgium,EURO,679,1244050,8,25788
2021-10-05,BE,Belgium,EURO,2792,1246842,5,25793
2021-10-06,BE,Belgium,EURO,2290,1249132,14,25807
2021-10-07,BE,Belgium,EURO,2545,1251677,13,25820
2021-10-08,BE,Belgium,EURO,2516,1254193,11,25831
2021-10-09,BE,Belgium,EURO,2543,1256736,7,25838
2021-10-10,BE,Belgium,EURO,1423,1258159,11,25849
2021-10-11,BE,Belgium,EURO,820,1258979,4,25853
2021-10-12,BE,Belgium,EURO,3924,1262903,18,25871
2021-10-13,BE,Belgium,EURO,3435,1266338,13,25884
2021-10-14,BE,Belgium,EURO,3595,1269933,8,25892
2021-10-15,BE,Belgium,EURO,3890,1273823,10,25902
2021-10-16,BE,Belgium,EURO,4168,1277991,18,25920
2021-10-17,BE,Belgium,EURO,2376,1280367,14,25934
2021-10-18,BE,Belgium,EURO,1490,1281857,10,25944
2021-10-19,BE,Belgium,EURO,6570,1288427,19,25963
2021-10-20,BE,Belgium,EURO,6295,1294722,13,25976
2021-10-21,BE,Belgium,EURO,6552,1301274,14,25990
2021-10-22,BE,Belgium,EURO,6905,1308179,10,26000
2021-10-23,BE,Belgium,EURO,7147,1315326,18,26018
2021-10-24,BE,Belgium,EURO,4090,1319416,20,26038
2021-10-25,BE,Belgium,EURO,2450,1321866,16,26054
2021-10-26,BE,Belgium,EURO,9703,1331569,18,26072
2021-10-27,BE,Belgium,EURO,9400,1340969,27,26099
2021-10-28,BE,Belgium,EURO,9224,1350193,33,26132
2021-10-29,BE,Belgium,EURO,9193,1359386,18,26150
2021-10-30,BE,Belgium,EURO,9289,1368675,21,26171
2021-10-31,BE,Belgium,EURO,4971,1373646,16,26187
2021-11-01,BE,Belgium,EURO,3058,1376704,18,26205
2021-11-02,BE,Belgium,EURO,3581,1380285,25,26230
2021-11-03,BE,Belgium,EURO,11714,1391999,20,26250
2021-11-04,BE,Belgium,EURO,10706,1402705,17,26267
2021-11-05,BE,Belgium,EURO,10180,1412885,26,26293
2021-11-06,BE,Belgium,EURO,11140,1424025,25,26318
2021-11-07,BE,Belgium,EURO,6453,1430478,30,26348
2021-11-08,BE,Belgium,EURO,4071,1434549,15,26363
2021-11-09,BE,Belgium,EURO,15267,1449816,28,26391
2021-11-10,BE,Belgium,EURO,13017,1462833,27,26418
2021-11-11,BE,Belgium,EURO,12750,1475583,26,26444
2021-11-12,BE,Belgium,EURO,5054,1480637,32,26476
2021-11-13,BE,Belgium,EURO,13751,1494388,39,26515
2021-11-14,BE,Belgium,EURO,8361,1502749,20,26535
2021-11-15,BE,Belgium,EURO,5506,1508255,27,26562
2021-11-16,BE,Belgium,EURO,20836,1529091,46,26608
2021-11-17,BE,Belgium,EURO,18431,1547522,29,26637
2021-11-18,BE,Belgium,EURO,18145,1565667,42,26679
2021-11-19,BE,Belgium,EURO,18572,1584239,43,26722
2021-11-20,BE,Belgium,EURO,19148,1603387,33,26755
2021-11-21,BE,Belgium,EURO,11215,1614602,36,26791
2021-11-22,BE,Belgium,EURO,6754,1621356,36,26827
2021-11-23,BE,Belgium,EURO,25623,1646979,35,26862
2021-11-24,BE,Belgium,EURO,21138,1668117,38,26900
2021-11-25,BE,Belgium,EURO,20171,1688288,49,26949
2021-11-26,BE,Belgium,EURO,20229,1708517,44,26993
2021-11-27,BE,Belgium,EURO,20041,1728558,40,27033
2021-11-28,BE,Belgium,EURO,11588,1740146,48,27081
2021-11-29,BE,Belgium,EURO,7072,1747218,47,27128
2021-11-30,BE,Belgium,EURO,25204,1772422,45,27173
2021-12-01,BE,Belgium,EURO,20868,1793290,61,27234
2021-12-02,BE,Belgium,EURO,19667,1812957,43,27277
2021-12-03,BE,Belgium,EURO,18327,1831284,53,27330
2021-12-04,BE,Belgium,EURO,17766,1849050,48,27378
2021-12-05,BE,Belgium,EURO,9635,1858685,45,27423
2021-12-06,BE,Belgium,EURO,5977,1864662,57,27480
2021-12-07,BE,Belgium,EURO,20737,1885399,39,27519
2021-12-08,BE,Belgium,EURO,15660,1901059,49,27568
2021-12-09,BE,Belgium,EURO,15014,1916073,55,27623
2021-12-10,BE,Belgium,EURO,13435,1929508,35,27658
2021-12-11,BE,Belgium,EURO,13101,1942609,48,27706
2021-12-12,BE,Belgium,EURO,7115,1949724,45,27751
2021-12-13,BE,Belgium,EURO,3908,1953632,44,27795
2021-12-14,BE,Belgium,EURO,13883,1967515,43,27838
2021-12-15,BE,Belgium,EURO,10582,1978097,37,27875
2021-12-16,BE,Belgium,EURO,9280,1987377,41,27916
2021-12-17,BE,Belgium,EURO,8110,1995487,37,27953
2021-12-18,BE,Belgium,EURO,7741,2003228,26,27979
2021-12-19,BE,Belgium,EURO,4754,2007982,36,28015
2021-12-20,BE,Belgium,EURO,2850,2010832,38,28053
2021-12-21,BE,Belgium,EURO,9108,2019940,36,28089
2021-12-22,BE,Belgium,EURO,7372,2027312,36,28125
2021-12-23,BE,Belgium,EURO,7388,2034700,37,28162
2021-12-24,BE,Belgium,EURO,7523,2042223,36,28198
2021-12-25,BE,Belgium,EURO,6518,2048741,35,28233
2021-12-26,BE,Belgium,EURO,2817,2051558,20,28253
2021-12-27,BE,Belgium,EURO,4565,2056123,22,28275
2021-12-28,BE,Belgium,EURO,13294,2069417,28,28303
2021-12-29,BE,Belgium,EURO,12817,2082234,21,28324
2021-12-30,BE,Belgium,EURO,15040,2097274,34,28358
2021-12-31,BE,Belgium,EURO,16057,2113331,29,28387
2022-01-01,BE,Belgium,EURO,12286,2125617,16,28403
2022-01-02,BE,Belgium,EURO,4069,2129686,22,28425
2022-01-03,BE,Belgium,EURO,9082,2138768,15,28440
2022-01-04,BE,Belgium,EURO,27576,2166344,25,28465
2022-01-05,BE,Belgium,EURO,28113,2194457,17,28482
2022-01-06,BE,Belgium,EURO,26043,2220500,14,28496
2022-01-07,BE,Belgium,EURO,23629,2244129,19,28515
2022-01-08,BE,Belgium,EURO,23796,2267925,19,28534
2022-01-09,BE,Belgium,EURO,15339,2283264,17,28551
2022-01-10,BE,Belgium,EURO,11220,2294484,23,28574
2022-01-11,BE,Belgium,EURO,37742,2332226,25,28599
2022-01-12,BE,Belgium,EURO,31688,2363914,24,28623
2022-01-13,BE,Belgium,EURO,31141,2395055,23,28646
2022-01-14,BE,Belgium,EURO,30097,2425152,21,28667
2022-01-15,BE,Belgium,EURO,31809,2456961,17,28684
2022-01-16,BE,Belgium,EURO,21166,2478127,14,28698
2022-01-17,BE,Belgium,EURO,14990,2493117,20,28718
2022-01-18,BE,Belgium,EURO,62629,2555746,32,28750
2022-01-19,BE,Belgium,EURO,60696,2616442,28,28778
2022-01-20,BE,Belgium,EURO,60881,2677323,38,28816
2022-01-21,BE,Belgium,EURO,57244,2734567,17,28833
2022-01-22,BE,Belgium,EURO,56427,2790994,23,28856
2022-01-23,BE,Belgium,EURO,32771,2823765,26,28882
2022-01-24,BE,Belgium,EURO,20739,2844504,16,28898
2022-01-25,BE,Belgium,EURO,75931,2920435,26,28924
2022-01-26,BE,Belgium,EURO,62467,2982902,37,28961
2022-01-27,BE,Belgium,EURO,54724,3037626,32,28993
2022-01-28,BE,Belgium,EURO,47488,3085114,28,29021
2022-01-29,BE,Belgium,EURO,41393,3126507,45,29066
2022-01-30,BE,Belgium,EURO,23210,3149717,27,29093
2022-01-31,BE,Belgium,EURO,13201,3162918,37,29130
2022-02-01,BE,Belgium,EURO,49993,3212911,29,29159
2022-02-02,BE,Belgium,EURO,36700,3249611,40,29199
2022-02-03,BE,Belgium,EURO,30804,3280415,49,29248
2022-02-04,BE,Belgium,EURO,25748,3306163,45,29293
2022-02-05,BE,Belgium,EURO,22362,3328525,61,29354
2022-02-06,BE,Belgium,EURO,12454,3340979,36,29390
2022-02-07,BE,Belgium,EURO,7267,3348246,39,29429
2022-02-08,BE,Belgium,EURO,27356,3375602,36,29465
2022-02-09,BE,Belgium,EURO,19352,3394954,43,29508
2022-02-10,BE,Belgium,EURO,16685,3411639,51,29559
2022-02-11,BE,Belgium,EURO,9421,3421060,58,29617
2022-02-12,BE,Belgium,EURO,21,3421081,7,29624
2022-02-13,BE,Belgium,EURO,0,3421081,0,29624
2022-02-14,BE,Belgium,EURO,0,3421081,0,29624
.
14650a
2022-02-12,BY,Belarus,EURO,8611,814262,17,6221
2022-02-13,BY,Belarus,EURO,8783,823045,16,6237
2022-02-14,BY,Belarus,EURO,8921,831966,16,6253
.
13879a
2022-02-12,BB,Barbados,AMRO,922,50880,2,291
2022-02-13,BB,Barbados,AMRO,431,51311,4,295
2022-02-14,BB,Barbados,AMRO,0,51311,0,295
.
13108a
2022-02-12,BD,Bangladesh,SEARO,5023,1904826,20,28791
2022-02-13,BD,Bangladesh,SEARO,4838,1909664,28,28819
2022-02-14,BD,Bangladesh,SEARO,4692,1914356,19,28838
.
12337c
2022-02-11,BH,Bahrain,EMRO,6341,448166,1,1419
2022-02-12,BH,Bahrain,EMRO,5750,453916,2,1421
2022-02-13,BH,Bahrain,EMRO,4623,458539,4,1425
2022-02-14,BH,Bahrain,EMRO,5266,463805,2,1427
.
11566a
2022-02-12,BS,Bahamas,AMRO,32,32903,1,757
2022-02-13,BS,Bahamas,AMRO,0,32903,0,757
2022-02-14,BS,Bahamas,AMRO,0,32903,0,757
.
10795a
2022-02-12,AZ,Azerbaijan,EURO,6603,732380,26,8998
2022-02-13,AZ,Azerbaijan,EURO,5948,738328,29,9027
2022-02-14,AZ,Azerbaijan,EURO,6841,745169,23,9050
.
10024a
2022-02-12,AT,Austria,EURO,30260,2230924,23,13814
2022-02-13,AT,Austria,EURO,31707,2262631,19,13833
2022-02-14,AT,Austria,EURO,26113,2288744,12,13845
.
9253c
2022-02-11,AU,Australia,WPRO,25880,2459158,65,4431
2022-02-12,AU,Australia,WPRO,24031,2483189,48,4479
2022-02-13,AU,Australia,WPRO,19884,2503073,67,4546
2022-02-14,AU,Australia,WPRO,24039,2527112,47,4593
.
8482a
2022-02-12,AW,Aruba,AMRO,30,33436,0,196
2022-02-13,AW,Aruba,AMRO,0,33436,0,196
2022-02-14,AW,Aruba,AMRO,0,33436,0,196
.
7711a
2022-02-12,AM,Armenia,EURO,2402,404805,12,8157
2022-02-13,AM,Armenia,EURO,1574,406379,10,8167
2022-02-14,AM,Armenia,EURO,0,406379,0,8167
.
6940a
2022-02-12,AR,Argentina,AMRO,0,8700437,0,123707
2022-02-13,AR,Argentina,AMRO,16503,8716940,152,123859
2022-02-14,AR,Argentina,AMRO,11322,8728262,128,123987
.
6169a
2022-02-12,AG,Antigua and Barbuda,AMRO,10,7331,0,134
2022-02-13,AG,Antigua and Barbuda,AMRO,0,7331,0,134
2022-02-14,AG,Antigua and Barbuda,AMRO,0,7331,0,134
.
5398a
2022-02-12,AI,Anguilla,AMRO,0,2458,0,9
2022-02-13,AI,Anguilla,AMRO,0,2458,0,9
2022-02-14,AI,Anguilla,AMRO,0,2458,0,9
.
4627a
2022-02-12,AO,Angola,AFRO,27,98501,1,1898
2022-02-13,AO,Angola,AFRO,13,98514,0,1898
2022-02-14,AO,Angola,AFRO,0,98514,0,1898
.
3856a
2022-02-12,AD,Andorra,EURO,66,37140,0,148
2022-02-13,AD,Andorra,EURO,0,37140,0,148
2022-02-14,AD,Andorra,EURO,0,37140,0,148
.
3085a
2022-02-12,AS,American Samoa,WPRO,0,57,0,0
2022-02-13,AS,American Samoa,WPRO,0,57,0,0
2022-02-14,AS,American Samoa,WPRO,0,57,0,0
.
2314a
2022-02-12,DZ,Algeria,AFRO,532,260723,13,6703
2022-02-13,DZ,Algeria,AFRO,503,261226,12,6715
2022-02-14,DZ,Algeria,AFRO,526,261752,14,6729
.
1543a
2022-02-12,AL,Albania,EURO,531,267551,5,3407
2022-02-13,AL,Albania,EURO,457,268008,3,3410
2022-02-14,AL,Albania,EURO,296,268304,4,3414
.
772a
2022-02-12,AF,Afghanistan,EMRO,490,169938,5,7482
2022-02-13,AF,Afghanistan,EMRO,214,170152,6,7488
2022-02-14,AF,Afghanistan,EMRO,452,170604,6,7494
.
w WHO-COVID-19-global-data.csv_2022-02-15_19:40:02
q

ed_heredoc
# 
# Dateiname: WHO-COVID-19-global-data.csv_2022-02-15_19:40:02 
# Zugriffsrechte -rw-r--r-- setzen 
  chmod 644 WHO-COVID-19-global-data.csv_2022-02-15_19:40:02 
# ctime war: - 
# atime auf    2022-06-24 00:58:50.692079000 +0200  setzen 
  touch -a -d '2022-06-24 00:58:50.692079000 +0200' WHO-COVID-19-global-data.csv_2022-02-15_19:40:02 
# mtime auf    2022-02-14 20:30:01.991558000 +0100  setzen 
  touch -m -d '2022-02-14 20:30:01.991558000 +0100' WHO-COVID-19-global-data.csv_2022-02-15_19:40:02 
