#!/bin/bash
#
#
# Dies ist ein Script um aus der Datei (Vorgaenger) 
#   WHO-COVID-19-global-data.csv_2022-02-21_21:20:01 
# die Datei 
#   WHO-COVID-19-global-data.csv_2022-02-21_22:20:01
# zu generieren. .
#
# Wenn  sich mehrere Dateien mit Endnug .diff.bash im Verz. befinden können 
# sie mit 
#   for datei in $(ls *.diff.bash) ;do ./${datei} ; done
# ausgeführt werden. Wichtig ist, das die Reihenfolge des Aufrufs stimmt 
# weil jedes Script auf das Ergebnis des Vorgängerscripts angewiesen ist. 
#
# Bekannter Fehler: wenn die Originaldatei keinen Zeilenumbruch am Dateiende 
# hatte hängt das ed-Script einen Zeilenumbruch an. 
#
/bin/ed WHO-COVID-19-global-data.csv_2022-02-21_21:20:01 <<ed_heredoc
184387c
2022-02-18,ZW,Zimbabwe,AFRO,385,232598,2,5381
2022-02-19,ZW,Zimbabwe,AFRO,432,233030,4,5385
2022-02-20,ZW,Zimbabwe,AFRO,194,233224,1,5386
.
183609c
2022-02-18,ZM,Zambia,AFRO,319,310474,2,3941
2022-02-19,ZM,Zambia,AFRO,290,310764,1,3942
2022-02-20,ZM,Zambia,AFRO,252,311016,1,3943
.
182831c
2022-02-18,YE,Yemen,EMRO,11,11718,1,2114
2022-02-19,YE,Yemen,EMRO,13,11731,1,2115
2022-02-20,YE,Yemen,EMRO,0,11731,5,2120
.
182053a
2022-02-19,WF,Wallis and Futuna,WPRO,0,453,0,7
2022-02-20,WF,Wallis and Futuna,WPRO,0,453,0,7
.
181275a
2022-02-19,VN,Viet Nam,WPRO,42439,2685463,80,39358
2022-02-20,VN,Viet Nam,WPRO,54830,2740293,65,39423
.
180497a
2022-02-19,VE,Venezuela (Bolivarian Republic of),AMRO,632,509600,10,5582
2022-02-20,VE,Venezuela (Bolivarian Republic of),AMRO,347,509947,9,5591
.
179719a
2022-02-19,VU,Vanuatu,WPRO,0,11,0,0
2022-02-20,VU,Vanuatu,WPRO,0,11,0,0
.
178941a
2022-02-19,UZ,Uzbekistan,EURO,191,235063,3,1617
2022-02-20,UZ,Uzbekistan,EURO,204,235267,2,1619
.
178163a
2022-02-19,UY,Uruguay,AMRO,5517,800833,18,6838
2022-02-20,UY,Uruguay,AMRO,7179,808012,16,6854
.
177385a
2022-02-19,VI,United States Virgin Islands,AMRO,9,15255,0,108
2022-02-20,VI,United States Virgin Islands,AMRO,28,15283,0,108
.
176607a
2022-02-19,US,United States of America,AMRO,100586,77622175,2225,924209
2022-02-20,US,United States of America,AMRO,107306,77729481,2078,926287
.
175829a
2022-02-19,TZ,United Republic of Tanzania,AFRO,0,33549,0,796
2022-02-20,TZ,United Republic of Tanzania,AFRO,0,33549,0,796
.
175051a
2022-02-19,AE,United Arab Emirates,EMRO,882,873092,2,2292
2022-02-20,AE,United Arab Emirates,EMRO,790,873882,1,2293
.
174273a
2022-02-19,UA,Ukraine,EURO,31125,4703323,260,104366
2022-02-20,UA,Ukraine,EURO,17448,4720771,152,104518
.
173495c
2022-02-18,UG,Uganda,AFRO,108,163040,1,3583
2022-02-19,UG,Uganda,AFRO,31,163071,1,3584
2022-02-20,UG,Uganda,AFRO,28,163099,1,3585
.
172717a
2022-02-19,TV,Tuvalu,WPRO,0,0,0,0
2022-02-20,TV,Tuvalu,WPRO,0,0,0,0
.
171939a
2022-02-19,TC,Turks and Caicos Islands,AMRO,3,5839,1,36
2022-02-20,TC,Turks and Caicos Islands,AMRO,4,5843,0,36
.
171161a
2022-02-19,TM,Turkmenistan,EURO,0,0,0,0
2022-02-20,TM,Turkmenistan,EURO,0,0,0,0
.
170383a
2022-02-19,TR,Turkey,EURO,87411,13352785,264,91910
2022-02-20,TR,Turkey,EURO,80454,13433239,278,92188
.
169605c
2022-02-18,TN,Tunisia,EMRO,6398,980612,80,27375
2022-02-19,TN,Tunisia,EMRO,0,980612,0,27375
2022-02-20,TN,Tunisia,EMRO,0,980612,0,27375
.
168827a
2022-02-19,TT,Trinidad and Tobago,AMRO,624,122717,4,3553
2022-02-20,TT,Trinidad and Tobago,AMRO,440,123157,9,3562
.
168049a
2022-02-19,TO,Tonga,WPRO,0,210,0,0
2022-02-20,TO,Tonga,WPRO,-1,209,0,0
.
167271a
2022-02-19,TK,Tokelau,WPRO,0,0,0,0
2022-02-20,TK,Tokelau,WPRO,0,0,0,0
.
166493c
2022-02-18,TG,Togo,AFRO,6,36710,0,271
2022-02-19,TG,Togo,AFRO,0,36710,0,271
2022-02-20,TG,Togo,AFRO,14,36724,0,271
.
165715a
2022-02-19,TL,Timor-Leste,SEARO,53,22314,0,125
2022-02-20,TL,Timor-Leste,SEARO,44,22358,0,125
.
164937a
2022-02-19,GB,The United Kingdom,EURO,47147,18546209,158,160379
2022-02-20,GB,The United Kingdom,EURO,34011,18580220,128,160507
.
164159a
2022-02-19,TH,Thailand,SEARO,18885,2693362,29,22594
2022-02-20,TH,Thailand,SEARO,18953,2712315,30,22624
.
163381a
2022-02-19,TJ,Tajikistan,EURO,3,17786,0,125
2022-02-20,TJ,Tajikistan,EURO,0,17786,0,125
.
162603c
2022-02-18,SY,Syrian Arab Republic,EMRO,130,53278,3,3041
2022-02-19,SY,Syrian Arab Republic,EMRO,125,53403,3,3044
2022-02-20,SY,Syrian Arab Republic,EMRO,124,53527,3,3047
.
161783,161825c
2022-01-07,CH,Switzerland,EURO,26119,1495659,12,11992
2022-01-08,CH,Switzerland,EURO,27269,1522928,28,12020
2022-01-09,CH,Switzerland,EURO,17775,1540703,17,12037
2022-01-10,CH,Switzerland,EURO,13379,1554082,10,12047
2022-01-11,CH,Switzerland,EURO,34535,1588617,18,12065
2022-01-12,CH,Switzerland,EURO,30912,1619529,12,12077
2022-01-13,CH,Switzerland,EURO,29608,1649137,10,12087
2022-01-14,CH,Switzerland,EURO,28615,1677752,14,12101
2022-01-15,CH,Switzerland,EURO,27625,1705377,13,12114
2022-01-16,CH,Switzerland,EURO,19294,1724671,16,12130
2022-01-17,CH,Switzerland,EURO,14759,1739430,14,12144
2022-01-18,CH,Switzerland,EURO,41801,1781231,12,12156
2022-01-19,CH,Switzerland,EURO,39315,1820546,16,12172
2022-01-20,CH,Switzerland,EURO,39095,1859641,21,12193
2022-01-21,CH,Switzerland,EURO,37658,1897299,20,12213
2022-01-22,CH,Switzerland,EURO,36634,1933933,12,12225
2022-01-23,CH,Switzerland,EURO,24634,1958567,17,12242
2022-01-24,CH,Switzerland,EURO,18339,1976906,8,12250
2022-01-25,CH,Switzerland,EURO,48391,2025297,8,12258
2022-01-26,CH,Switzerland,EURO,44219,2069516,19,12277
2022-01-27,CH,Switzerland,EURO,41517,2111033,10,12287
2022-01-28,CH,Switzerland,EURO,37813,2148846,11,12298
2022-01-29,CH,Switzerland,EURO,35726,2184572,17,12315
2022-01-30,CH,Switzerland,EURO,23350,2207922,15,12330
2022-01-31,CH,Switzerland,EURO,18066,2225988,22,12352
2022-02-01,CH,Switzerland,EURO,43346,2269334,14,12366
2022-02-02,CH,Switzerland,EURO,36625,2305959,15,12381
2022-02-03,CH,Switzerland,EURO,34115,2340074,16,12397
2022-02-04,CH,Switzerland,EURO,28939,2369013,11,12408
2022-02-05,CH,Switzerland,EURO,26361,2395374,7,12415
2022-02-06,CH,Switzerland,EURO,18204,2413578,11,12426
2022-02-07,CH,Switzerland,EURO,14441,2428019,12,12438
2022-02-08,CH,Switzerland,EURO,32204,2460223,16,12454
2022-02-09,CH,Switzerland,EURO,27011,2487234,13,12467
2022-02-10,CH,Switzerland,EURO,25489,2512723,15,12482
2022-02-11,CH,Switzerland,EURO,22257,2534980,12,12494
2022-02-12,CH,Switzerland,EURO,19714,2554694,15,12509
2022-02-13,CH,Switzerland,EURO,13995,2568689,11,12520
2022-02-14,CH,Switzerland,EURO,10722,2579411,7,12527
2022-02-15,CH,Switzerland,EURO,24642,2604053,6,12533
2022-02-16,CH,Switzerland,EURO,20532,2624585,11,12544
2022-02-17,CH,Switzerland,EURO,18566,2643151,6,12550
2022-02-18,CH,Switzerland,EURO,9780,2652931,2,12552
2022-02-19,CH,Switzerland,EURO,125,2653056,1,12553
2022-02-20,CH,Switzerland,EURO,0,2653056,0,12553
.
161758,161780c
2021-12-13,CH,Switzerland,EURO,4396,1132542,28,11488
2021-12-14,CH,Switzerland,EURO,12430,1144972,21,11509
2021-12-15,CH,Switzerland,EURO,10529,1155501,35,11544
2021-12-16,CH,Switzerland,EURO,9532,1165033,33,11577
2021-12-17,CH,Switzerland,EURO,9143,1174176,29,11606
2021-12-18,CH,Switzerland,EURO,8737,1182913,24,11630
2021-12-19,CH,Switzerland,EURO,5876,1188789,21,11651
2021-12-20,CH,Switzerland,EURO,4332,1193121,20,11671
2021-12-21,CH,Switzerland,EURO,11469,1204590,29,11700
2021-12-22,CH,Switzerland,EURO,10779,1215369,20,11720
2021-12-23,CH,Switzerland,EURO,11007,1226376,24,11744
2021-12-24,CH,Switzerland,EURO,11269,1237645,26,11770
2021-12-25,CH,Switzerland,EURO,9633,1247278,11,11781
2021-12-26,CH,Switzerland,EURO,6451,1253729,20,11801
2021-12-27,CH,Switzerland,EURO,7371,1261100,13,11814
2021-12-28,CH,Switzerland,EURO,17422,1278522,17,11831
2021-12-29,CH,Switzerland,EURO,17669,1296191,25,11856
2021-12-30,CH,Switzerland,EURO,18993,1315184,14,11870
2021-12-31,CH,Switzerland,EURO,19743,1334927,23,11893
2022-01-01,CH,Switzerland,EURO,16133,1351060,24,11917
2022-01-02,CH,Switzerland,EURO,9395,1360455,17,11934
2022-01-03,CH,Switzerland,EURO,12807,1373262,12,11946
2022-01-04,CH,Switzerland,EURO,32267,1405529,11,11957
.
161459,161739c
2021-02-17,CH,Switzerland,EURO,1137,543464,8,9500
2021-02-18,CH,Switzerland,EURO,1215,544679,9,9509
2021-02-19,CH,Switzerland,EURO,1007,545686,10,9519
2021-02-20,CH,Switzerland,EURO,1094,546780,14,9533
2021-02-21,CH,Switzerland,EURO,691,547471,15,9548
2021-02-22,CH,Switzerland,EURO,527,547998,11,9559
2021-02-23,CH,Switzerland,EURO,1407,549405,9,9568
2021-02-24,CH,Switzerland,EURO,1258,550663,10,9578
2021-02-25,CH,Switzerland,EURO,1077,551740,8,9586
2021-02-26,CH,Switzerland,EURO,1119,552859,10,9596
2021-02-27,CH,Switzerland,EURO,1080,553939,9,9605
2021-02-28,CH,Switzerland,EURO,723,554662,10,9615
2021-03-01,CH,Switzerland,EURO,547,555209,7,9622
2021-03-02,CH,Switzerland,EURO,1419,556628,8,9630
2021-03-03,CH,Switzerland,EURO,1230,557858,11,9641
2021-03-04,CH,Switzerland,EURO,1240,559098,9,9650
2021-03-05,CH,Switzerland,EURO,1063,560161,9,9659
2021-03-06,CH,Switzerland,EURO,1278,561439,10,9669
2021-03-07,CH,Switzerland,EURO,765,562204,8,9677
2021-03-08,CH,Switzerland,EURO,582,562786,9,9686
2021-03-09,CH,Switzerland,EURO,1702,564488,10,9696
2021-03-10,CH,Switzerland,EURO,1388,565876,8,9704
2021-03-11,CH,Switzerland,EURO,1385,567261,12,9716
2021-03-12,CH,Switzerland,EURO,1341,568602,13,9729
2021-03-13,CH,Switzerland,EURO,1342,569944,9,9738
2021-03-14,CH,Switzerland,EURO,923,570867,14,9752
2021-03-15,CH,Switzerland,EURO,703,571570,9,9761
2021-03-16,CH,Switzerland,EURO,1922,573492,9,9770
2021-03-17,CH,Switzerland,EURO,1653,575145,11,9781
2021-03-18,CH,Switzerland,EURO,1824,576969,13,9794
2021-03-19,CH,Switzerland,EURO,1647,578616,9,9803
2021-03-20,CH,Switzerland,EURO,1545,580161,9,9812
2021-03-21,CH,Switzerland,EURO,1111,581272,4,9816
2021-03-22,CH,Switzerland,EURO,787,582059,7,9823
2021-03-23,CH,Switzerland,EURO,2263,584322,5,9828
2021-03-24,CH,Switzerland,EURO,1995,586317,12,9840
2021-03-25,CH,Switzerland,EURO,1931,588248,7,9847
2021-03-26,CH,Switzerland,EURO,2142,590390,13,9860
2021-03-27,CH,Switzerland,EURO,2000,592390,4,9864
2021-03-28,CH,Switzerland,EURO,1208,593598,10,9874
2021-03-29,CH,Switzerland,EURO,995,594593,9,9883
2021-03-30,CH,Switzerland,EURO,2532,597125,5,9888
2021-03-31,CH,Switzerland,EURO,2093,599218,12,9900
2021-04-01,CH,Switzerland,EURO,2132,601350,14,9914
2021-04-02,CH,Switzerland,EURO,1985,603335,12,9926
2021-04-03,CH,Switzerland,EURO,1205,604540,6,9932
2021-04-04,CH,Switzerland,EURO,1317,605857,12,9944
2021-04-05,CH,Switzerland,EURO,1022,606879,10,9954
2021-04-06,CH,Switzerland,EURO,1290,608169,17,9971
2021-04-07,CH,Switzerland,EURO,2690,610859,10,9981
2021-04-08,CH,Switzerland,EURO,2387,613246,10,9991
2021-04-09,CH,Switzerland,EURO,2490,615736,5,9996
2021-04-10,CH,Switzerland,EURO,2416,618152,8,10004
2021-04-11,CH,Switzerland,EURO,1682,619834,6,10010
2021-04-12,CH,Switzerland,EURO,1180,621014,7,10017
2021-04-13,CH,Switzerland,EURO,2742,623756,3,10020
2021-04-14,CH,Switzerland,EURO,2375,626131,10,10030
2021-04-15,CH,Switzerland,EURO,2214,628345,6,10036
2021-04-16,CH,Switzerland,EURO,2147,630492,4,10040
2021-04-17,CH,Switzerland,EURO,2121,632613,7,10047
2021-04-18,CH,Switzerland,EURO,1430,634043,9,10056
2021-04-19,CH,Switzerland,EURO,1048,635091,7,10063
2021-04-20,CH,Switzerland,EURO,2744,637835,8,10071
2021-04-21,CH,Switzerland,EURO,2391,640226,9,10080
2021-04-22,CH,Switzerland,EURO,2309,642535,5,10085
2021-04-23,CH,Switzerland,EURO,2266,644801,7,10092
2021-04-24,CH,Switzerland,EURO,2165,646966,10,10102
2021-04-25,CH,Switzerland,EURO,1456,648422,6,10108
2021-04-26,CH,Switzerland,EURO,1188,649610,9,10117
2021-04-27,CH,Switzerland,EURO,2441,652051,13,10130
2021-04-28,CH,Switzerland,EURO,2038,654089,11,10141
2021-04-29,CH,Switzerland,EURO,2009,656098,7,10148
2021-04-30,CH,Switzerland,EURO,1711,657809,8,10156
2021-05-01,CH,Switzerland,EURO,1677,659486,9,10165
2021-05-02,CH,Switzerland,EURO,1159,660645,12,10177
2021-05-03,CH,Switzerland,EURO,832,661477,8,10185
2021-05-04,CH,Switzerland,EURO,2019,663496,5,10190
2021-05-05,CH,Switzerland,EURO,1735,665231,4,10194
2021-05-06,CH,Switzerland,EURO,1649,666880,11,10205
2021-05-07,CH,Switzerland,EURO,1484,668364,4,10209
2021-05-08,CH,Switzerland,EURO,1573,669937,7,10216
2021-05-09,CH,Switzerland,EURO,1062,670999,5,10221
2021-05-10,CH,Switzerland,EURO,779,671778,5,10226
2021-05-11,CH,Switzerland,EURO,1718,673496,6,10232
2021-05-12,CH,Switzerland,EURO,1383,674879,4,10236
2021-05-13,CH,Switzerland,EURO,1441,676320,0,10236
2021-05-14,CH,Switzerland,EURO,672,676992,5,10241
2021-05-15,CH,Switzerland,EURO,1169,678161,4,10245
2021-05-16,CH,Switzerland,EURO,802,678963,2,10247
2021-05-17,CH,Switzerland,EURO,653,679616,9,10256
2021-05-18,CH,Switzerland,EURO,1671,681287,1,10257
2021-05-19,CH,Switzerland,EURO,1344,682631,3,10260
2021-05-20,CH,Switzerland,EURO,1212,683843,6,10266
2021-05-21,CH,Switzerland,EURO,1040,684883,3,10269
2021-05-22,CH,Switzerland,EURO,984,685867,10,10279
2021-05-23,CH,Switzerland,EURO,623,686490,5,10284
2021-05-24,CH,Switzerland,EURO,470,686960,5,10289
2021-05-25,CH,Switzerland,EURO,581,687541,4,10293
2021-05-26,CH,Switzerland,EURO,1148,688689,4,10297
2021-05-27,CH,Switzerland,EURO,923,689612,2,10299
2021-05-28,CH,Switzerland,EURO,849,690461,3,10302
2021-05-29,CH,Switzerland,EURO,751,691212,2,10304
2021-05-30,CH,Switzerland,EURO,500,691712,4,10308
2021-05-31,CH,Switzerland,EURO,357,692069,0,10308
2021-06-01,CH,Switzerland,EURO,854,692923,2,10310
2021-06-02,CH,Switzerland,EURO,652,693575,1,10311
2021-06-03,CH,Switzerland,EURO,551,694126,3,10314
2021-06-04,CH,Switzerland,EURO,468,694594,6,10320
2021-06-05,CH,Switzerland,EURO,491,695085,4,10324
2021-06-06,CH,Switzerland,EURO,313,695398,2,10326
2021-06-07,CH,Switzerland,EURO,187,695585,6,10332
2021-06-08,CH,Switzerland,EURO,584,696169,2,10334
2021-06-09,CH,Switzerland,EURO,417,696586,2,10336
2021-06-10,CH,Switzerland,EURO,375,696961,2,10338
2021-06-11,CH,Switzerland,EURO,304,697265,3,10341
2021-06-12,CH,Switzerland,EURO,318,697583,3,10344
2021-06-13,CH,Switzerland,EURO,194,697777,2,10346
2021-06-14,CH,Switzerland,EURO,121,697898,2,10348
2021-06-15,CH,Switzerland,EURO,328,698226,0,10348
2021-06-16,CH,Switzerland,EURO,233,698459,1,10349
2021-06-17,CH,Switzerland,EURO,191,698650,4,10353
2021-06-18,CH,Switzerland,EURO,156,698806,3,10356
2021-06-19,CH,Switzerland,EURO,149,698955,3,10359
2021-06-20,CH,Switzerland,EURO,103,699058,0,10359
2021-06-21,CH,Switzerland,EURO,78,699136,1,10360
2021-06-22,CH,Switzerland,EURO,165,699301,2,10362
2021-06-23,CH,Switzerland,EURO,122,699423,0,10362
2021-06-24,CH,Switzerland,EURO,127,699550,1,10363
2021-06-25,CH,Switzerland,EURO,113,699663,1,10364
2021-06-26,CH,Switzerland,EURO,98,699761,1,10365
2021-06-27,CH,Switzerland,EURO,60,699821,0,10365
2021-06-28,CH,Switzerland,EURO,59,699880,2,10367
2021-06-29,CH,Switzerland,EURO,150,700030,0,10367
2021-06-30,CH,Switzerland,EURO,115,700145,2,10369
2021-07-01,CH,Switzerland,EURO,159,700304,0,10369
2021-07-02,CH,Switzerland,EURO,169,700473,0,10369
2021-07-03,CH,Switzerland,EURO,165,700638,1,10370
2021-07-04,CH,Switzerland,EURO,129,700767,0,10370
2021-07-05,CH,Switzerland,EURO,139,700906,0,10370
2021-07-06,CH,Switzerland,EURO,310,701216,0,10370
2021-07-07,CH,Switzerland,EURO,289,701505,0,10370
2021-07-08,CH,Switzerland,EURO,320,701825,0,10370
2021-07-09,CH,Switzerland,EURO,316,702141,0,10370
2021-07-10,CH,Switzerland,EURO,327,702468,1,10371
2021-07-11,CH,Switzerland,EURO,255,702723,1,10372
2021-07-12,CH,Switzerland,EURO,230,702953,1,10373
2021-07-13,CH,Switzerland,EURO,571,703524,0,10373
2021-07-14,CH,Switzerland,EURO,522,704046,1,10374
2021-07-15,CH,Switzerland,EURO,590,704636,0,10374
2021-07-16,CH,Switzerland,EURO,623,705259,0,10374
2021-07-17,CH,Switzerland,EURO,645,705904,0,10374
2021-07-18,CH,Switzerland,EURO,454,706358,1,10375
2021-07-19,CH,Switzerland,EURO,394,706752,0,10375
2021-07-20,CH,Switzerland,EURO,857,707609,1,10376
2021-07-21,CH,Switzerland,EURO,737,708346,0,10376
2021-07-22,CH,Switzerland,EURO,873,709219,2,10378
2021-07-23,CH,Switzerland,EURO,724,709943,0,10378
2021-07-24,CH,Switzerland,EURO,743,710686,0,10378
2021-07-25,CH,Switzerland,EURO,539,711225,1,10379
2021-07-26,CH,Switzerland,EURO,480,711705,1,10380
2021-07-27,CH,Switzerland,EURO,951,712656,1,10381
2021-07-28,CH,Switzerland,EURO,740,713396,5,10386
2021-07-29,CH,Switzerland,EURO,785,714181,3,10389
2021-07-30,CH,Switzerland,EURO,783,714964,1,10390
2021-07-31,CH,Switzerland,EURO,803,715767,0,10390
2021-08-01,CH,Switzerland,EURO,656,716423,0,10390
2021-08-02,CH,Switzerland,EURO,535,716958,1,10391
2021-08-03,CH,Switzerland,EURO,1234,718192,1,10392
2021-08-04,CH,Switzerland,EURO,990,719182,1,10393
2021-08-05,CH,Switzerland,EURO,1070,720252,0,10393
2021-08-06,CH,Switzerland,EURO,1121,721373,0,10393
2021-08-07,CH,Switzerland,EURO,1153,722526,0,10393
2021-08-08,CH,Switzerland,EURO,1046,723572,0,10393
2021-08-09,CH,Switzerland,EURO,1008,724580,1,10394
2021-08-10,CH,Switzerland,EURO,2321,726901,2,10396
2021-08-11,CH,Switzerland,EURO,2030,728931,2,10398
2021-08-12,CH,Switzerland,EURO,2085,731016,3,10401
2021-08-13,CH,Switzerland,EURO,2167,733183,2,10403
2021-08-14,CH,Switzerland,EURO,2209,735392,1,10404
2021-08-15,CH,Switzerland,EURO,1679,737071,3,10407
2021-08-16,CH,Switzerland,EURO,1651,738722,2,10409
2021-08-17,CH,Switzerland,EURO,3951,742673,3,10412
2021-08-18,CH,Switzerland,EURO,2838,745511,4,10416
2021-08-19,CH,Switzerland,EURO,2710,748221,1,10417
2021-08-20,CH,Switzerland,EURO,2512,750733,4,10421
2021-08-21,CH,Switzerland,EURO,2561,753294,7,10428
2021-08-22,CH,Switzerland,EURO,1748,755042,3,10431
2021-08-23,CH,Switzerland,EURO,1633,756675,3,10434
2021-08-24,CH,Switzerland,EURO,3851,760526,6,10440
2021-08-25,CH,Switzerland,EURO,2916,763442,8,10448
2021-08-26,CH,Switzerland,EURO,2765,766207,4,10452
2021-08-27,CH,Switzerland,EURO,2693,768900,7,10459
2021-08-28,CH,Switzerland,EURO,2596,771496,4,10463
2021-08-29,CH,Switzerland,EURO,1677,773173,8,10471
2021-08-30,CH,Switzerland,EURO,1385,774558,5,10476
2021-08-31,CH,Switzerland,EURO,3562,778120,13,10489
2021-09-01,CH,Switzerland,EURO,2974,781094,4,10493
2021-09-02,CH,Switzerland,EURO,2942,784036,8,10501
2021-09-03,CH,Switzerland,EURO,3051,787087,4,10505
2021-09-04,CH,Switzerland,EURO,3077,790164,8,10513
2021-09-05,CH,Switzerland,EURO,1760,791924,6,10519
2021-09-06,CH,Switzerland,EURO,1399,793323,9,10528
2021-09-07,CH,Switzerland,EURO,3995,797318,8,10536
2021-09-08,CH,Switzerland,EURO,3044,800362,11,10547
2021-09-09,CH,Switzerland,EURO,3061,803423,7,10554
2021-09-10,CH,Switzerland,EURO,2769,806192,7,10561
2021-09-11,CH,Switzerland,EURO,2622,808814,5,10566
2021-09-12,CH,Switzerland,EURO,1551,810365,7,10573
2021-09-13,CH,Switzerland,EURO,1106,811471,10,10583
2021-09-14,CH,Switzerland,EURO,2764,814235,8,10591
2021-09-15,CH,Switzerland,EURO,2296,816531,3,10594
2021-09-16,CH,Switzerland,EURO,2242,818773,7,10601
2021-09-17,CH,Switzerland,EURO,1998,820771,3,10604
2021-09-18,CH,Switzerland,EURO,1691,822462,11,10615
2021-09-19,CH,Switzerland,EURO,1027,823489,4,10619
2021-09-20,CH,Switzerland,EURO,702,824191,6,10625
2021-09-21,CH,Switzerland,EURO,1880,826071,4,10629
2021-09-22,CH,Switzerland,EURO,1703,827774,4,10633
2021-09-23,CH,Switzerland,EURO,1531,829305,6,10639
2021-09-24,CH,Switzerland,EURO,1377,830682,7,10646
2021-09-25,CH,Switzerland,EURO,1343,832025,9,10655
2021-09-26,CH,Switzerland,EURO,886,832911,5,10660
2021-09-27,CH,Switzerland,EURO,607,833518,7,10667
2021-09-28,CH,Switzerland,EURO,1661,835179,3,10670
2021-09-29,CH,Switzerland,EURO,1208,836387,7,10677
2021-09-30,CH,Switzerland,EURO,1187,837574,11,10688
2021-10-01,CH,Switzerland,EURO,1195,838769,1,10689
2021-10-02,CH,Switzerland,EURO,1139,839908,5,10694
2021-10-03,CH,Switzerland,EURO,786,840694,5,10699
2021-10-04,CH,Switzerland,EURO,473,841167,3,10702
2021-10-05,CH,Switzerland,EURO,1278,842445,4,10706
2021-10-06,CH,Switzerland,EURO,1033,843478,6,10712
2021-10-07,CH,Switzerland,EURO,1008,844486,1,10713
2021-10-08,CH,Switzerland,EURO,1011,845497,8,10721
2021-10-09,CH,Switzerland,EURO,919,846416,3,10724
2021-10-10,CH,Switzerland,EURO,638,847054,5,10729
2021-10-11,CH,Switzerland,EURO,480,847534,4,10733
2021-10-12,CH,Switzerland,EURO,1172,848706,10,10743
2021-10-13,CH,Switzerland,EURO,964,849670,6,10749
2021-10-14,CH,Switzerland,EURO,963,850633,6,10755
2021-10-15,CH,Switzerland,EURO,958,851591,3,10758
2021-10-16,CH,Switzerland,EURO,985,852576,3,10761
2021-10-17,CH,Switzerland,EURO,700,853276,0,10761
2021-10-18,CH,Switzerland,EURO,680,853956,4,10765
2021-10-19,CH,Switzerland,EURO,1571,855527,2,10767
2021-10-20,CH,Switzerland,EURO,1289,856816,6,10773
2021-10-21,CH,Switzerland,EURO,1431,858247,9,10782
2021-10-22,CH,Switzerland,EURO,1371,859618,3,10785
2021-10-23,CH,Switzerland,EURO,1352,860970,5,10790
2021-10-24,CH,Switzerland,EURO,954,861924,4,10794
2021-10-25,CH,Switzerland,EURO,727,862651,4,10798
2021-10-26,CH,Switzerland,EURO,2024,864675,8,10806
2021-10-27,CH,Switzerland,EURO,1699,866374,5,10811
2021-10-28,CH,Switzerland,EURO,1807,868181,10,10821
2021-10-29,CH,Switzerland,EURO,1803,869984,7,10828
2021-10-30,CH,Switzerland,EURO,1864,871848,4,10832
2021-10-31,CH,Switzerland,EURO,1259,873107,6,10838
2021-11-01,CH,Switzerland,EURO,1081,874188,5,10843
2021-11-02,CH,Switzerland,EURO,2343,876531,5,10848
2021-11-03,CH,Switzerland,EURO,2983,879514,3,10851
2021-11-04,CH,Switzerland,EURO,2836,882350,3,10854
2021-11-05,CH,Switzerland,EURO,2843,885193,3,10857
2021-11-06,CH,Switzerland,EURO,2755,887948,7,10864
2021-11-07,CH,Switzerland,EURO,1931,889879,3,10867
2021-11-08,CH,Switzerland,EURO,1537,891416,10,10877
2021-11-09,CH,Switzerland,EURO,4204,895620,10,10887
2021-11-10,CH,Switzerland,EURO,3738,899358,11,10898
2021-11-11,CH,Switzerland,EURO,3970,903328,5,10903
2021-11-12,CH,Switzerland,EURO,3953,907281,13,10916
2021-11-13,CH,Switzerland,EURO,4144,911425,7,10923
2021-11-14,CH,Switzerland,EURO,2709,914134,7,10930
2021-11-15,CH,Switzerland,EURO,2165,916299,8,10938
2021-11-16,CH,Switzerland,EURO,6133,922432,8,10946
2021-11-17,CH,Switzerland,EURO,5626,928058,14,10960
2021-11-18,CH,Switzerland,EURO,6183,934241,13,10973
2021-11-19,CH,Switzerland,EURO,6055,940296,17,10990
2021-11-20,CH,Switzerland,EURO,6200,946496,6,10996
2021-11-21,CH,Switzerland,EURO,4141,950637,9,11005
2021-11-22,CH,Switzerland,EURO,3406,954043,13,11018
2021-11-23,CH,Switzerland,EURO,9167,963210,20,11038
2021-11-24,CH,Switzerland,EURO,8011,971221,18,11056
.
161017,161047c
2022-01-19,SE,Sweden,EURO,24198,1661766,33,15739
2022-01-20,SE,Sweden,EURO,39315,1701081,32,15771
2022-01-21,SE,Sweden,EURO,40623,1741704,32,15803
2022-01-22,SE,Sweden,EURO,43716,1785420,29,15832
2022-01-23,SE,Sweden,EURO,39809,1825229,39,15871
2022-01-24,SE,Sweden,EURO,37705,1862934,32,15903
2022-01-25,SE,Sweden,EURO,30983,1893917,34,15937
2022-01-26,SE,Sweden,EURO,33911,1927828,38,15975
2022-01-27,SE,Sweden,EURO,46669,1974497,38,16013
2022-01-28,SE,Sweden,EURO,41679,2016176,48,16061
2022-01-29,SE,Sweden,EURO,53894,2070070,33,16094
2022-01-30,SE,Sweden,EURO,39516,2109586,47,16141
2022-01-31,SE,Sweden,EURO,34330,2143916,43,16184
2022-02-01,SE,Sweden,EURO,15069,2158985,41,16225
2022-02-02,SE,Sweden,EURO,24802,2183787,40,16265
2022-02-03,SE,Sweden,EURO,40933,2224720,51,16316
2022-02-04,SE,Sweden,EURO,35944,2260664,46,16362
2022-02-05,SE,Sweden,EURO,28314,2288978,55,16417
2022-02-06,SE,Sweden,EURO,25717,2314695,48,16465
2022-02-07,SE,Sweden,EURO,19991,2334686,48,16513
2022-02-08,SE,Sweden,EURO,10076,2344762,41,16554
2022-02-09,SE,Sweden,EURO,9671,2354433,53,16607
2022-02-10,SE,Sweden,EURO,19613,2374046,45,16652
2022-02-11,SE,Sweden,EURO,15841,2389887,24,16676
2022-02-12,SE,Sweden,EURO,7437,2397324,38,16714
2022-02-13,SE,Sweden,EURO,5850,2403174,32,16746
2022-02-14,SE,Sweden,EURO,2817,2405991,14,16760
2022-02-15,SE,Sweden,EURO,1177,2407168,25,16785
2022-02-16,SE,Sweden,EURO,2548,2409716,37,16822
2022-02-17,SE,Sweden,EURO,4882,2414598,22,16844
2022-02-18,SE,Sweden,EURO,4044,2418642,8,16852
2022-02-19,SE,Sweden,EURO,4214,2422856,0,16852
2022-02-20,SE,Sweden,EURO,0,2422856,0,16852
.
160269a
2022-02-19,SR,Suriname,AMRO,99,77549,3,1307
2022-02-20,SR,Suriname,AMRO,85,77634,2,1309
.
159491a
2022-02-19,SD,Sudan,EMRO,0,59939,0,3821
2022-02-20,SD,Sudan,EMRO,0,59939,0,3821
.
158713c
2022-02-18,LK,Sri Lanka,SEARO,1282,634333,23,15949
2022-02-19,LK,Sri Lanka,SEARO,1273,635606,20,15969
2022-02-20,LK,Sri Lanka,SEARO,1231,636837,25,15994
.
157244,157935c
2020-03-29,ES,Spain,EURO,15058,102157,1152,7170
2020-03-30,ES,Spain,EURO,7096,109253,839,8009
2020-03-31,ES,Spain,EURO,5092,114345,811,8820
2020-04-01,ES,Spain,EURO,8008,122353,913,9733
2020-04-02,ES,Spain,EURO,7925,130278,899,10632
2020-04-03,ES,Spain,EURO,7058,137336,895,11527
2020-04-04,ES,Spain,EURO,6905,144241,858,12385
2020-04-05,ES,Spain,EURO,6821,151062,786,13171
2020-04-06,ES,Spain,EURO,4670,155732,740,13911
2020-04-07,ES,Spain,EURO,3147,158879,750,14661
2020-04-08,ES,Spain,EURO,5396,164275,766,15427
2020-04-09,ES,Spain,EURO,5324,169599,736,16163
2020-04-10,ES,Spain,EURO,5488,175087,749,16912
2020-04-11,ES,Spain,EURO,4609,179696,667,17579
2020-04-12,ES,Spain,EURO,4438,184134,676,18255
2020-04-13,ES,Spain,EURO,3075,187209,628,18883
2020-04-14,ES,Spain,EURO,2379,189588,544,19427
2020-04-15,ES,Spain,EURO,3127,192715,587,20014
2020-04-16,ES,Spain,EURO,3993,196708,607,20621
2020-04-17,ES,Spain,EURO,3702,200410,552,21173
2020-04-18,ES,Spain,EURO,3417,203827,487,21660
2020-04-19,ES,Spain,EURO,3462,207289,507,22167
2020-04-20,ES,Spain,EURO,2181,209470,435,22602
2020-04-21,ES,Spain,EURO,1446,210916,401,23003
2020-04-22,ES,Spain,EURO,2518,213434,387,23390
2020-04-23,ES,Spain,EURO,2728,216162,427,23817
2020-04-24,ES,Spain,EURO,2770,218932,344,24161
2020-04-25,ES,Spain,EURO,2222,221154,331,24492
2020-04-26,ES,Spain,EURO,2284,223438,330,24822
2020-04-27,ES,Spain,EURO,1292,224730,295,25117
2020-04-28,ES,Spain,EURO,818,225548,272,25389
2020-04-29,ES,Spain,EURO,1653,227201,258,25647
2020-04-30,ES,Spain,EURO,1736,228937,259,25906
2020-05-01,ES,Spain,EURO,1484,230421,236,26142
2020-05-02,ES,Spain,EURO,1438,231859,223,26365
2020-05-03,ES,Spain,EURO,792,232651,176,26541
2020-05-04,ES,Spain,EURO,566,233217,202,26743
2020-05-05,ES,Spain,EURO,452,233669,197,26940
2020-05-06,ES,Spain,EURO,1013,234682,186,27126
2020-05-07,ES,Spain,EURO,980,235662,183,27309
2020-05-08,ES,Spain,EURO,981,236643,153,27462
2020-05-09,ES,Spain,EURO,956,237599,166,27628
2020-05-10,ES,Spain,EURO,917,238516,146,27774
2020-05-11,ES,Spain,EURO,491,239007,125,27899
2020-05-12,ES,Spain,EURO,317,239324,110,28009
2020-05-13,ES,Spain,EURO,739,240063,122,28131
2020-05-14,ES,Spain,EURO,698,240761,113,28244
2020-05-15,ES,Spain,EURO,794,241555,87,28331
2020-05-16,ES,Spain,EURO,778,242333,86,28417
2020-05-17,ES,Spain,EURO,788,243121,77,28494
2020-05-18,ES,Spain,EURO,342,243463,63,28557
2020-05-19,ES,Spain,EURO,240,243703,61,28618
2020-05-20,ES,Spain,EURO,617,244320,72,28690
2020-05-21,ES,Spain,EURO,824,245144,70,28760
2020-05-22,ES,Spain,EURO,729,245873,57,28817
2020-05-23,ES,Spain,EURO,767,246640,70,28887
2020-05-24,ES,Spain,EURO,798,247438,71,28958
2020-05-25,ES,Spain,EURO,303,247741,60,29018
2020-05-26,ES,Spain,EURO,259,248000,55,29073
2020-05-27,ES,Spain,EURO,537,248537,68,29141
2020-05-28,ES,Spain,EURO,733,249270,55,29196
2020-05-29,ES,Spain,EURO,602,249872,45,29241
2020-05-30,ES,Spain,EURO,645,250517,41,29282
2020-05-31,ES,Spain,EURO,708,251225,45,29327
2020-06-01,ES,Spain,EURO,331,251556,43,29370
2020-06-02,ES,Spain,EURO,178,251734,40,29410
2020-06-03,ES,Spain,EURO,345,252079,35,29445
2020-06-04,ES,Spain,EURO,457,252536,47,29492
2020-06-05,ES,Spain,EURO,575,253111,39,29531
2020-06-06,ES,Spain,EURO,487,253598,48,29579
2020-06-07,ES,Spain,EURO,636,254234,23,29602
2020-06-08,ES,Spain,EURO,257,254491,29,29631
2020-06-09,ES,Spain,EURO,143,254634,21,29652
2020-06-10,ES,Spain,EURO,330,254964,29,29681
2020-06-11,ES,Spain,EURO,434,255398,15,29696
2020-06-12,ES,Spain,EURO,442,255840,31,29727
2020-06-13,ES,Spain,EURO,373,256213,24,29751
2020-06-14,ES,Spain,EURO,481,256694,19,29770
2020-06-15,ES,Spain,EURO,121,256815,23,29793
2020-06-16,ES,Spain,EURO,84,256899,20,29813
2020-06-17,ES,Spain,EURO,286,257185,20,29833
2020-06-18,ES,Spain,EURO,377,257562,11,29844
2020-06-19,ES,Spain,EURO,340,257902,25,29869
2020-06-20,ES,Spain,EURO,364,258266,12,29881
2020-06-21,ES,Spain,EURO,340,258606,18,29899
2020-06-22,ES,Spain,EURO,226,258832,14,29913
2020-06-23,ES,Spain,EURO,163,258995,15,29928
2020-06-24,ES,Spain,EURO,237,259232,7,29935
2020-06-25,ES,Spain,EURO,434,259666,8,29943
2020-06-26,ES,Spain,EURO,330,259996,12,29955
2020-06-27,ES,Spain,EURO,357,260353,11,29966
2020-06-28,ES,Spain,EURO,471,260824,9,29975
2020-06-29,ES,Spain,EURO,251,261075,3,29978
2020-06-30,ES,Spain,EURO,190,261265,12,29990
2020-07-01,ES,Spain,EURO,274,261539,11,30001
2020-07-02,ES,Spain,EURO,444,261983,11,30012
2020-07-03,ES,Spain,EURO,457,262440,10,30022
2020-07-04,ES,Spain,EURO,483,262923,1,30023
2020-07-05,ES,Spain,EURO,592,263515,5,30028
2020-07-06,ES,Spain,EURO,295,263810,7,30035
2020-07-07,ES,Spain,EURO,208,264018,1,30036
2020-07-08,ES,Spain,EURO,340,264358,3,30039
2020-07-09,ES,Spain,EURO,708,265066,6,30045
2020-07-10,ES,Spain,EURO,738,265804,4,30049
2020-07-11,ES,Spain,EURO,848,266652,1,30050
2020-07-12,ES,Spain,EURO,1147,267799,5,30055
2020-07-13,ES,Spain,EURO,614,268413,7,30062
2020-07-14,ES,Spain,EURO,387,268800,2,30064
2020-07-15,ES,Spain,EURO,852,269652,2,30066
2020-07-16,ES,Spain,EURO,1255,270907,3,30069
2020-07-17,ES,Spain,EURO,1557,272464,5,30074
2020-07-18,ES,Spain,EURO,1624,274088,2,30076
2020-07-19,ES,Spain,EURO,2071,276159,2,30078
2020-07-20,ES,Spain,EURO,1516,277675,4,30082
2020-07-21,ES,Spain,EURO,1149,278824,6,30088
2020-07-22,ES,Spain,EURO,1589,280413,8,30096
2020-07-23,ES,Spain,EURO,2320,282733,8,30104
2020-07-24,ES,Spain,EURO,2333,285066,4,30108
2020-07-25,ES,Spain,EURO,2363,287429,4,30112
2020-07-26,ES,Spain,EURO,2845,290274,8,30120
2020-07-27,ES,Spain,EURO,1714,291988,11,30131
2020-07-28,ES,Spain,EURO,1379,293367,7,30138
2020-07-29,ES,Spain,EURO,2039,295406,10,30148
2020-07-30,ES,Spain,EURO,2900,298306,13,30161
2020-07-31,ES,Spain,EURO,3150,301456,11,30172
2020-08-01,ES,Spain,EURO,3410,304866,12,30184
2020-08-02,ES,Spain,EURO,3823,308689,16,30200
2020-08-03,ES,Spain,EURO,3050,311739,12,30212
2020-08-04,ES,Spain,EURO,1841,313580,15,30227
2020-08-05,ES,Spain,EURO,2709,316289,12,30239
2020-08-06,ES,Spain,EURO,4406,320695,20,30259
2020-08-07,ES,Spain,EURO,4288,324983,13,30272
2020-08-08,ES,Spain,EURO,4816,329799,30,30302
2020-08-09,ES,Spain,EURO,5657,335456,23,30325
2020-08-10,ES,Spain,EURO,3498,338954,31,30356
2020-08-11,ES,Spain,EURO,2626,341580,18,30374
2020-08-12,ES,Spain,EURO,3848,345428,31,30405
2020-08-13,ES,Spain,EURO,5991,351419,31,30436
2020-08-14,ES,Spain,EURO,6393,357812,29,30465
2020-08-15,ES,Spain,EURO,7011,364823,25,30490
2020-08-16,ES,Spain,EURO,8329,373152,37,30527
2020-08-17,ES,Spain,EURO,4828,377980,30,30557
2020-08-18,ES,Spain,EURO,3296,381276,23,30580
2020-08-19,ES,Spain,EURO,4972,386248,31,30611
2020-08-20,ES,Spain,EURO,8463,394711,44,30655
2020-08-21,ES,Spain,EURO,8637,403348,47,30702
2020-08-22,ES,Spain,EURO,9025,412373,41,30743
2020-08-23,ES,Spain,EURO,10481,422854,44,30787
2020-08-24,ES,Spain,EURO,6054,428908,44,30831
2020-08-25,ES,Spain,EURO,4297,433205,55,30886
2020-08-26,ES,Spain,EURO,6035,439240,55,30941
2020-08-27,ES,Spain,EURO,10317,449557,44,30985
2020-08-28,ES,Spain,EURO,10298,459855,51,31036
2020-08-29,ES,Spain,EURO,10320,470175,49,31085
2020-08-30,ES,Spain,EURO,11956,482131,70,31155
2020-08-31,ES,Spain,EURO,6874,489005,53,31208
2020-09-01,ES,Spain,EURO,5182,494187,59,31267
2020-09-02,ES,Spain,EURO,6641,500828,65,31332
2020-09-03,ES,Spain,EURO,10475,511303,68,31400
2020-09-04,ES,Spain,EURO,10715,522018,79,31479
2020-09-05,ES,Spain,EURO,10962,532980,80,31559
2020-09-06,ES,Spain,EURO,13195,546175,80,31639
2020-09-07,ES,Spain,EURO,7881,554056,68,31707
2020-09-08,ES,Spain,EURO,5491,559547,61,31768
2020-09-09,ES,Spain,EURO,7038,566585,80,31848
2020-09-10,ES,Spain,EURO,11950,578535,84,31932
2020-09-11,ES,Spain,EURO,12791,591326,95,32027
2020-09-12,ES,Spain,EURO,12995,604321,96,32123
2020-09-13,ES,Spain,EURO,14410,618731,96,32219
2020-09-14,ES,Spain,EURO,8316,627047,102,32321
2020-09-15,ES,Spain,EURO,6403,633450,106,32427
2020-09-16,ES,Spain,EURO,8191,641641,109,32536
2020-09-17,ES,Spain,EURO,13808,655449,137,32673
2020-09-18,ES,Spain,EURO,14022,669471,109,32782
2020-09-19,ES,Spain,EURO,13784,683255,124,32906
2020-09-20,ES,Spain,EURO,16737,699992,115,33021
2020-09-21,ES,Spain,EURO,8328,708320,123,33144
2020-09-22,ES,Spain,EURO,5859,714179,103,33247
2020-09-23,ES,Spain,EURO,8024,722203,123,33370
2020-09-24,ES,Spain,EURO,12800,735003,127,33497
2020-09-25,ES,Spain,EURO,12751,747754,111,33608
2020-09-26,ES,Spain,EURO,12658,760412,133,33741
2020-09-27,ES,Spain,EURO,13538,773950,131,33872
2020-09-28,ES,Spain,EURO,7644,781594,116,33988
2020-09-29,ES,Spain,EURO,5045,786639,120,34108
2020-09-30,ES,Spain,EURO,7071,793710,141,34249
2020-10-01,ES,Spain,EURO,11324,805034,147,34396
2020-10-02,ES,Spain,EURO,11197,816231,153,34549
2020-10-03,ES,Spain,EURO,11056,827287,135,34684
2020-10-04,ES,Spain,EURO,12380,839667,132,34816
2020-10-05,ES,Spain,EURO,6886,846553,106,34922
2020-10-06,ES,Spain,EURO,5130,851683,96,35018
2020-10-07,ES,Spain,EURO,8877,860560,127,35145
2020-10-08,ES,Spain,EURO,12233,872793,132,35277
2020-10-09,ES,Spain,EURO,12410,885203,132,35409
2020-10-10,ES,Spain,EURO,13866,899069,134,35543
2020-10-11,ES,Spain,EURO,14789,913858,150,35693
2020-10-12,ES,Spain,EURO,8721,922579,137,35830
2020-10-13,ES,Spain,EURO,6762,929341,113,35943
2020-10-14,ES,Spain,EURO,6330,935671,128,36071
2020-10-15,ES,Spain,EURO,12373,948044,148,36219
2020-10-16,ES,Spain,EURO,16378,964422,141,36360
2020-10-17,ES,Spain,EURO,17520,981942,148,36508
2020-10-18,ES,Spain,EURO,18276,1000218,150,36658
2020-10-19,ES,Spain,EURO,11948,1012166,132,36790
2020-10-20,ES,Spain,EURO,8250,1020416,152,36942
2020-10-21,ES,Spain,EURO,15679,1036095,175,37117
2020-10-22,ES,Spain,EURO,20919,1057014,188,37305
2020-10-23,ES,Spain,EURO,23234,1080248,176,37481
2020-10-24,ES,Spain,EURO,23830,1104078,209,37690
2020-10-25,ES,Spain,EURO,25025,1129103,216,37906
2020-10-26,ES,Spain,EURO,15445,1144548,192,38098
2020-10-27,ES,Spain,EURO,11276,1155824,195,38293
2020-10-28,ES,Spain,EURO,20005,1175829,218,38511
2020-10-29,ES,Spain,EURO,24347,1200176,242,38753
2020-10-30,ES,Spain,EURO,24641,1224817,247,39000
2020-10-31,ES,Spain,EURO,24208,1249025,254,39254
2020-11-01,ES,Spain,EURO,24955,1273980,263,39517
2020-11-02,ES,Spain,EURO,16087,1290067,269,39786
2020-11-03,ES,Spain,EURO,10977,1301044,268,40054
2020-11-04,ES,Spain,EURO,15514,1316558,304,40358
2020-11-05,ES,Spain,EURO,22057,1338615,325,40683
2020-11-06,ES,Spain,EURO,24145,1362760,356,41039
2020-11-07,ES,Spain,EURO,23566,1386326,331,41370
2020-11-08,ES,Spain,EURO,23521,1409847,355,41725
2020-11-09,ES,Spain,EURO,14582,1424429,287,42012
2020-11-10,ES,Spain,EURO,9847,1434276,319,42331
2020-11-11,ES,Spain,EURO,16536,1450812,320,42651
2020-11-12,ES,Spain,EURO,20590,1471402,350,43001
2020-11-13,ES,Spain,EURO,19994,1491396,362,43363
2020-11-14,ES,Spain,EURO,19166,1510562,359,43722
2020-11-15,ES,Spain,EURO,18425,1528987,357,44079
2020-11-16,ES,Spain,EURO,10587,1539574,302,44381
2020-11-17,ES,Spain,EURO,6664,1546238,287,44668
2020-11-18,ES,Spain,EURO,12801,1559039,326,44994
2020-11-19,ES,Spain,EURO,15866,1574905,377,45371
2020-11-20,ES,Spain,EURO,14808,1589713,296,45667
2020-11-21,ES,Spain,EURO,13179,1602892,315,45982
2020-11-22,ES,Spain,EURO,12633,1615525,323,46305
2020-11-23,ES,Spain,EURO,7238,1622763,283,46588
2020-11-24,ES,Spain,EURO,4610,1627373,252,46840
2020-11-25,ES,Spain,EURO,9131,1636504,297,47137
2020-11-26,ES,Spain,EURO,10939,1647443,244,47381
2020-11-27,ES,Spain,EURO,9981,1657424,294,47675
2020-11-28,ES,Spain,EURO,9634,1667058,293,47968
2020-11-29,ES,Spain,EURO,9924,1676982,269,48237
2020-11-30,ES,Spain,EURO,5509,1682491,221,48458
2020-12-01,ES,Spain,EURO,3418,1685909,222,48680
2020-12-02,ES,Spain,EURO,7421,1693330,229,48909
2020-12-03,ES,Spain,EURO,9505,1702835,231,49140
2020-12-04,ES,Spain,EURO,8880,1711715,221,49361
2020-12-05,ES,Spain,EURO,8136,1719851,238,49599
2020-12-06,ES,Spain,EURO,8422,1728273,233,49832
2020-12-07,ES,Spain,EURO,4956,1733229,195,50027
2020-12-08,ES,Spain,EURO,3275,1736504,173,50200
2020-12-09,ES,Spain,EURO,5223,1741727,203,50403
2020-12-10,ES,Spain,EURO,4033,1745760,169,50572
2020-12-11,ES,Spain,EURO,8409,1754169,224,50796
2020-12-12,ES,Spain,EURO,10751,1764920,187,50983
2020-12-13,ES,Spain,EURO,11316,1776236,211,51194
2020-12-14,ES,Spain,EURO,6589,1782825,185,51379
2020-12-15,ES,Spain,EURO,4240,1787065,162,51541
2020-12-16,ES,Spain,EURO,9895,1796960,165,51706
2020-12-17,ES,Spain,EURO,12166,1809126,186,51892
2020-12-18,ES,Spain,EURO,11732,1820858,150,52042
2020-12-19,ES,Spain,EURO,10966,1831824,177,52219
2020-12-20,ES,Spain,EURO,12203,1844027,176,52395
2020-12-21,ES,Spain,EURO,6914,1850941,141,52536
2020-12-22,ES,Spain,EURO,4391,1855332,156,52692
2020-12-23,ES,Spain,EURO,10994,1866326,148,52840
2020-12-24,ES,Spain,EURO,13394,1879720,184,53024
2020-12-25,ES,Spain,EURO,14500,1894220,195,53219
2020-12-26,ES,Spain,EURO,9984,1904204,157,53376
2020-12-27,ES,Spain,EURO,4822,1909026,146,53522
2020-12-28,ES,Spain,EURO,6399,1915425,176,53698
2020-12-29,ES,Spain,EURO,5987,1921412,166,53864
2020-12-30,ES,Spain,EURO,15084,1936496,195,54059
2020-12-31,ES,Spain,EURO,18899,1955395,166,54225
2021-01-01,ES,Spain,EURO,21126,1976521,200,54425
2021-01-02,ES,Spain,EURO,15591,1992112,192,54617
2021-01-03,ES,Spain,EURO,7651,1999763,174,54791
2021-01-04,ES,Spain,EURO,10463,2010226,188,54979
2021-01-05,ES,Spain,EURO,9965,2020191,179,55158
2021-01-06,ES,Spain,EURO,22133,2042324,192,55350
2021-01-07,ES,Spain,EURO,30735,2073059,243,55593
2021-01-08,ES,Spain,EURO,14582,2087641,180,55773
2021-01-09,ES,Spain,EURO,26782,2114423,238,56011
2021-01-10,ES,Spain,EURO,32859,2147282,242,56253
2021-01-11,ES,Spain,EURO,19301,2166583,230,56483
2021-01-12,ES,Spain,EURO,13905,2180488,243,56726
2021-01-13,ES,Spain,EURO,32465,2212953,286,57012
2021-01-14,ES,Spain,EURO,37347,2250300,284,57296
2021-01-15,ES,Spain,EURO,38959,2289259,292,57588
2021-01-16,ES,Spain,EURO,38364,2327623,319,57907
2021-01-17,ES,Spain,EURO,42923,2370546,393,58300
2021-01-18,ES,Spain,EURO,24999,2395545,366,58666
2021-01-19,ES,Spain,EURO,18623,2414168,367,59033
2021-01-20,ES,Spain,EURO,35731,2449899,412,59445
2021-01-21,ES,Spain,EURO,42394,2492293,490,59935
2021-01-22,ES,Spain,EURO,41869,2534162,459,60394
2021-01-23,ES,Spain,EURO,40797,2574959,491,60885
2021-01-24,ES,Spain,EURO,42179,2617138,568,61453
2021-01-25,ES,Spain,EURO,23813,2640951,453,61906
2021-01-26,ES,Spain,EURO,17326,2658277,518,62424
2021-01-27,ES,Spain,EURO,32762,2691039,529,62953
2021-01-28,ES,Spain,EURO,37445,2728484,550,63503
2021-01-29,ES,Spain,EURO,35847,2764331,595,64098
2021-01-30,ES,Spain,EURO,33348,2797679,576,64674
2021-01-31,ES,Spain,EURO,32345,2830024,533,65207
2021-02-01,ES,Spain,EURO,18173,2848197,515,65722
2021-02-02,ES,Spain,EURO,11711,2859908,486,66208
2021-02-03,ES,Spain,EURO,22501,2882409,544,66752
2021-02-04,ES,Spain,EURO,25995,2908404,493,67245
2021-02-05,ES,Spain,EURO,23804,2932208,492,67737
2021-02-06,ES,Spain,EURO,21116,2953324,464,68201
2021-02-07,ES,Spain,EURO,20169,2973493,462,68663
2021-02-08,ES,Spain,EURO,10324,2983817,408,69071
2021-02-09,ES,Spain,EURO,6098,2989915,382,69453
2021-02-10,ES,Spain,EURO,13792,3003707,411,69864
2021-02-11,ES,Spain,EURO,15360,3019067,386,70250
2021-02-12,ES,Spain,EURO,13339,3032406,408,70658
2021-02-13,ES,Spain,EURO,11858,3044264,355,71013
2021-02-14,ES,Spain,EURO,11694,3055958,340,71353
2021-02-15,ES,Spain,EURO,5744,3061702,289,71642
2021-02-16,ES,Spain,EURO,3584,3065286,244,71886
2021-02-17,ES,Spain,EURO,8857,3074143,285,72171
2021-02-18,ES,Spain,EURO,9862,3084005,298,72469
2021-02-19,ES,Spain,EURO,8619,3092624,260,72729
2021-02-20,ES,Spain,EURO,8185,3100809,242,72971
2021-02-21,ES,Spain,EURO,7975,3108784,225,73196
2021-02-22,ES,Spain,EURO,4014,3112798,185,73381
2021-02-23,ES,Spain,EURO,2669,3115467,183,73564
2021-02-24,ES,Spain,EURO,6836,3122303,226,73790
2021-02-25,ES,Spain,EURO,7375,3129678,190,73980
2021-02-26,ES,Spain,EURO,6477,3136155,207,74187
2021-02-27,ES,Spain,EURO,6178,3142333,197,74384
2021-02-28,ES,Spain,EURO,6465,3148798,176,74560
2021-03-01,ES,Spain,EURO,3212,3152010,162,74722
2021-03-02,ES,Spain,EURO,2242,3154252,149,74871
2021-03-03,ES,Spain,EURO,5383,3159635,134,75005
2021-03-04,ES,Spain,EURO,5892,3165527,154,75159
2021-03-05,ES,Spain,EURO,5953,3171480,142,75301
2021-03-06,ES,Spain,EURO,5605,3177085,136,75437
2021-03-07,ES,Spain,EURO,5730,3182815,131,75568
2021-03-08,ES,Spain,EURO,2861,3185676,126,75694
2021-03-09,ES,Spain,EURO,2050,3187726,98,75792
2021-03-10,ES,Spain,EURO,5121,3192847,119,75911
2021-03-11,ES,Spain,EURO,5672,3198519,117,76028
2021-03-12,ES,Spain,EURO,5527,3204046,102,76130
2021-03-13,ES,Spain,EURO,5369,3209415,97,76227
2021-03-14,ES,Spain,EURO,5823,3215238,107,76334
2021-03-15,ES,Spain,EURO,2833,3218071,85,76419
2021-03-16,ES,Spain,EURO,1973,3220044,78,76497
2021-03-17,ES,Spain,EURO,5585,3225629,100,76597
2021-03-18,ES,Spain,EURO,6112,3231741,112,76709
2021-03-19,ES,Spain,EURO,5832,3237573,96,76805
2021-03-20,ES,Spain,EURO,6382,3243955,70,76875
2021-03-21,ES,Spain,EURO,4696,3248651,67,76942
2021-03-22,ES,Spain,EURO,2914,3251565,67,77009
2021-03-23,ES,Spain,EURO,2315,3253880,67,77076
2021-03-24,ES,Spain,EURO,6154,3260034,74,77150
2021-03-25,ES,Spain,EURO,7379,3267413,90,77240
2021-03-26,ES,Spain,EURO,6952,3274365,54,77294
2021-03-27,ES,Spain,EURO,7342,3281707,67,77361
2021-03-28,ES,Spain,EURO,7673,3289380,86,77447
2021-03-29,ES,Spain,EURO,4124,3293504,65,77512
2021-03-30,ES,Spain,EURO,2943,3296447,71,77583
2021-03-31,ES,Spain,EURO,7419,3303866,88,77671
2021-04-01,ES,Spain,EURO,8213,3312079,85,77756
2021-04-02,ES,Spain,EURO,9022,3321101,76,77832
2021-04-03,ES,Spain,EURO,5714,3326815,74,77906
2021-04-04,ES,Spain,EURO,3856,3330671,70,77976
2021-04-05,ES,Spain,EURO,4594,3335265,78,78054
2021-04-06,ES,Spain,EURO,4274,3339539,58,78112
2021-04-07,ES,Spain,EURO,7724,3347263,73,78185
2021-04-08,ES,Spain,EURO,10888,3358151,80,78265
2021-04-09,ES,Spain,EURO,10626,3368777,92,78357
2021-04-10,ES,Spain,EURO,10392,3379169,83,78440
2021-04-11,ES,Spain,EURO,10552,3389721,81,78521
2021-04-12,ES,Spain,EURO,5666,3395387,90,78611
2021-04-13,ES,Spain,EURO,3943,3399330,52,78663
2021-04-14,ES,Spain,EURO,9045,3408375,95,78758
2021-04-15,ES,Spain,EURO,10199,3418574,81,78839
2021-04-16,ES,Spain,EURO,10403,3428977,90,78929
2021-04-17,ES,Spain,EURO,9739,3438716,73,79002
2021-04-18,ES,Spain,EURO,10067,3448783,81,79083
2021-04-19,ES,Spain,EURO,5344,3454127,76,79159
2021-04-20,ES,Spain,EURO,3938,3458065,59,79218
2021-04-21,ES,Spain,EURO,8738,3466803,85,79303
2021-04-22,ES,Spain,EURO,10714,3477517,80,79383
2021-04-23,ES,Spain,EURO,9760,3487277,64,79447
2021-04-24,ES,Spain,EURO,9840,3497117,72,79519
2021-04-25,ES,Spain,EURO,9955,3507072,78,79597
2021-04-26,ES,Spain,EURO,5054,3512126,74,79671
2021-04-27,ES,Spain,EURO,3868,3515994,64,79735
2021-04-28,ES,Spain,EURO,8960,3524954,67,79802
2021-04-29,ES,Spain,EURO,9785,3534739,66,79868
2021-04-30,ES,Spain,EURO,9332,3544071,66,79934
2021-05-01,ES,Spain,EURO,8902,3552973,60,79994
2021-05-02,ES,Spain,EURO,9065,3562038,65,80059
2021-05-03,ES,Spain,EURO,3923,3565961,55,80114
2021-05-04,ES,Spain,EURO,3111,3569072,51,80165
2021-05-05,ES,Spain,EURO,6080,3575152,73,80238
2021-05-06,ES,Spain,EURO,7524,3582676,68,80306
2021-05-07,ES,Spain,EURO,7946,3590622,68,80374
2021-05-08,ES,Spain,EURO,6950,3597572,60,80434
2021-05-09,ES,Spain,EURO,7553,3605125,69,80503
2021-05-10,ES,Spain,EURO,3444,3608569,52,80555
2021-05-11,ES,Spain,EURO,2430,3610999,50,80605
2021-05-12,ES,Spain,EURO,6060,3617059,53,80658
2021-05-13,ES,Spain,EURO,5965,3623024,50,80708
2021-05-14,ES,Spain,EURO,5904,3628928,54,80762
2021-05-15,ES,Spain,EURO,5730,3634658,54,80816
2021-05-16,ES,Spain,EURO,5922,3640580,45,80861
2021-05-17,ES,Spain,EURO,2855,3643435,42,80903
2021-05-18,ES,Spain,EURO,2205,3645640,40,80943
2021-05-19,ES,Spain,EURO,5190,3650830,35,80978
2021-05-20,ES,Spain,EURO,6003,3656833,35,81013
2021-05-21,ES,Spain,EURO,5378,3662211,48,81061
2021-05-22,ES,Spain,EURO,5467,3667678,33,81094
2021-05-23,ES,Spain,EURO,5646,3673324,43,81137
2021-05-24,ES,Spain,EURO,2695,3676019,34,81171
2021-05-25,ES,Spain,EURO,1986,3678005,32,81203
2021-05-26,ES,Spain,EURO,4554,3682559,36,81239
2021-05-27,ES,Spain,EURO,5413,3687972,23,81262
2021-05-28,ES,Spain,EURO,5301,3693273,38,81300
2021-05-29,ES,Spain,EURO,5359,3698632,16,81316
2021-05-30,ES,Spain,EURO,5356,3703988,21,81337
2021-05-31,ES,Spain,EURO,2898,3706886,21,81358
2021-06-01,ES,Spain,EURO,1945,3708831,28,81386
2021-06-02,ES,Spain,EURO,4855,3713686,38,81424
2021-06-03,ES,Spain,EURO,5124,3718810,24,81448
2021-06-04,ES,Spain,EURO,5114,3723924,33,81481
2021-06-05,ES,Spain,EURO,4460,3728384,28,81509
2021-06-06,ES,Spain,EURO,4570,3732954,32,81541
2021-06-07,ES,Spain,EURO,2435,3735389,24,81565
2021-06-08,ES,Spain,EURO,1707,3737096,26,81591
2021-06-09,ES,Spain,EURO,4156,3741252,19,81610
2021-06-10,ES,Spain,EURO,4135,3745387,27,81637
2021-06-11,ES,Spain,EURO,4095,3749482,18,81655
2021-06-12,ES,Spain,EURO,4115,3753597,25,81680
2021-06-13,ES,Spain,EURO,3987,3757584,12,81692
2021-06-14,ES,Spain,EURO,2198,3759782,20,81712
2021-06-15,ES,Spain,EURO,1544,3761326,19,81731
2021-06-16,ES,Spain,EURO,3610,3764936,16,81747
2021-06-17,ES,Spain,EURO,4064,3769000,23,81770
2021-06-18,ES,Spain,EURO,3970,3772970,21,81791
2021-06-19,ES,Spain,EURO,3976,3776946,21,81812
2021-06-20,ES,Spain,EURO,3996,3780942,16,81828
2021-06-21,ES,Spain,EURO,2256,3783198,8,81836
2021-06-22,ES,Spain,EURO,1667,3784865,15,81851
2021-06-23,ES,Spain,EURO,3855,3788720,19,81870
2021-06-24,ES,Spain,EURO,4415,3793135,17,81887
2021-06-25,ES,Spain,EURO,5018,3798153,17,81904
2021-06-26,ES,Spain,EURO,3877,3802030,14,81918
2021-06-27,ES,Spain,EURO,5665,3807695,13,81931
2021-06-28,ES,Spain,EURO,3742,3811437,13,81944
2021-06-29,ES,Spain,EURO,3117,3814554,19,81963
2021-06-30,ES,Spain,EURO,8110,3822664,14,81977
2021-07-01,ES,Spain,EURO,10705,3833369,14,81991
2021-07-02,ES,Spain,EURO,13064,3846433,13,82004
2021-07-03,ES,Spain,EURO,14018,3860451,15,82019
2021-07-04,ES,Spain,EURO,14928,3875379,6,82025
2021-07-05,ES,Spain,EURO,10268,3885647,15,82040
2021-07-06,ES,Spain,EURO,7627,3893274,9,82049
2021-07-07,ES,Spain,EURO,16882,3910156,10,82059
2021-07-08,ES,Spain,EURO,20439,3930595,13,82072
2021-07-09,ES,Spain,EURO,23014,3953609,9,82081
2021-07-10,ES,Spain,EURO,22708,3976317,7,82088
2021-07-11,ES,Spain,EURO,24505,4000822,14,82102
2021-07-12,ES,Spain,EURO,14999,4015821,18,82120
2021-07-13,ES,Spain,EURO,12264,4028085,15,82135
2021-07-14,ES,Spain,EURO,25780,4053865,17,82152
2021-07-15,ES,Spain,EURO,28354,4082219,20,82172
2021-07-16,ES,Spain,EURO,29813,4112032,21,82193
2021-07-17,ES,Spain,EURO,29468,4141500,20,82213
2021-07-18,ES,Spain,EURO,29645,4171145,38,82251
2021-07-19,ES,Spain,EURO,18510,4189655,18,82269
2021-07-20,ES,Spain,EURO,14457,4204112,21,82290
2021-07-21,ES,Spain,EURO,29778,4233890,34,82324
2021-07-22,ES,Spain,EURO,31769,4265659,47,82371
2021-07-23,ES,Spain,EURO,31811,4297470,50,82421
2021-07-24,ES,Spain,EURO,31002,4328472,48,82469
2021-07-25,ES,Spain,EURO,30073,4358545,46,82515
2021-07-26,ES,Spain,EURO,18125,4376670,80,82595
2021-07-27,ES,Spain,EURO,12626,4389296,54,82649
2021-07-28,ES,Spain,EURO,25694,4414990,60,82709
2021-07-29,ES,Spain,EURO,28848,4443838,80,82789
2021-07-30,ES,Spain,EURO,26950,4470788,67,82856
2021-07-31,ES,Spain,EURO,25565,4496353,70,82926
2021-08-01,ES,Spain,EURO,25703,4522056,90,83016
2021-08-02,ES,Spain,EURO,14742,4536798,84,83100
2021-08-03,ES,Spain,EURO,9574,4546372,76,83176
2021-08-04,ES,Spain,EURO,19816,4566188,92,83268
2021-08-05,ES,Spain,EURO,21559,4587747,90,83358
2021-08-06,ES,Spain,EURO,20560,4608307,114,83472
2021-08-07,ES,Spain,EURO,19550,4627857,92,83564
2021-08-08,ES,Spain,EURO,19126,4646983,101,83665
2021-08-09,ES,Spain,EURO,10985,4657968,85,83750
2021-08-10,ES,Spain,EURO,7237,4665205,77,83827
2021-08-11,ES,Spain,EURO,15027,4680232,108,83935
2021-08-12,ES,Spain,EURO,17216,4697448,101,84036
2021-08-13,ES,Spain,EURO,15789,4713237,104,84140
2021-08-14,ES,Spain,EURO,14853,4728090,125,84265
2021-08-15,ES,Spain,EURO,13849,4741939,105,84370
2021-08-16,ES,Spain,EURO,8026,4749965,106,84476
2021-08-17,ES,Spain,EURO,5562,4755527,114,84590
2021-08-18,ES,Spain,EURO,9585,4765112,107,84697
2021-08-19,ES,Spain,EURO,11982,4777094,128,84825
2021-08-20,ES,Spain,EURO,12584,4789678,106,84931
2021-08-21,ES,Spain,EURO,11743,4801421,96,85027
2021-08-22,ES,Spain,EURO,11715,4813136,94,85121
2021-08-23,ES,Spain,EURO,6495,4819631,85,85206
2021-08-24,ES,Spain,EURO,4091,4823722,73,85279
2021-08-25,ES,Spain,EURO,9806,4833528,96,85375
2021-08-26,ES,Spain,EURO,9825,4843353,85,85460
2021-08-27,ES,Spain,EURO,9048,4852401,104,85564
2021-08-28,ES,Spain,EURO,8169,4860570,78,85642
2021-08-29,ES,Spain,EURO,8105,4868675,85,85727
2021-08-30,ES,Spain,EURO,4016,4872691,72,85799
2021-08-31,ES,Spain,EURO,2679,4875370,73,85872
2021-09-01,ES,Spain,EURO,6220,4881590,91,85963
2021-09-02,ES,Spain,EURO,7126,4888716,82,86045
2021-09-03,ES,Spain,EURO,5924,4894640,86,86131
2021-09-04,ES,Spain,EURO,5254,4899894,71,86202
2021-09-05,ES,Spain,EURO,4883,4904777,76,86278
2021-09-06,ES,Spain,EURO,2700,4907477,53,86331
2021-09-07,ES,Spain,EURO,1897,4909374,56,86387
2021-09-08,ES,Spain,EURO,4208,4913582,65,86452
2021-09-09,ES,Spain,EURO,4708,4918290,59,86511
2021-09-10,ES,Spain,EURO,3720,4922010,68,86579
2021-09-11,ES,Spain,EURO,3714,4925724,62,86641
2021-09-12,ES,Spain,EURO,3764,4929488,54,86695
2021-09-13,ES,Spain,EURO,1716,4931204,42,86737
2021-09-14,ES,Spain,EURO,1267,4932471,54,86791
2021-09-15,ES,Spain,EURO,3363,4935834,42,86833
2021-09-16,ES,Spain,EURO,3408,4939242,57,86890
2021-09-17,ES,Spain,EURO,2876,4942118,58,86948
2021-09-18,ES,Spain,EURO,2884,4945002,49,86997
2021-09-19,ES,Spain,EURO,2947,4947949,45,87042
2021-09-20,ES,Spain,EURO,1369,4949318,42,87084
2021-09-21,ES,Spain,EURO,891,4950209,46,87130
2021-09-22,ES,Spain,EURO,2380,4952589,41,87171
2021-09-23,ES,Spain,EURO,2710,4955299,44,87215
2021-09-24,ES,Spain,EURO,2491,4957790,31,87246
2021-09-25,ES,Spain,EURO,2299,4960089,29,87275
2021-09-26,ES,Spain,EURO,2442,4962531,38,87313
2021-09-27,ES,Spain,EURO,1222,4963753,27,87340
2021-09-28,ES,Spain,EURO,810,4964563,20,87360
2021-09-29,ES,Spain,EURO,2446,4967009,21,87381
2021-09-30,ES,Spain,EURO,2211,4969220,21,87402
2021-10-01,ES,Spain,EURO,2062,4971282,26,87428
2021-10-02,ES,Spain,EURO,1831,4973113,33,87461
2021-10-03,ES,Spain,EURO,1870,4974983,28,87489
2021-10-04,ES,Spain,EURO,971,4975954,30,87519
2021-10-05,ES,Spain,EURO,678,4976632,19,87538
2021-10-06,ES,Spain,EURO,1872,4978504,27,87565
2021-10-07,ES,Spain,EURO,1788,4980292,11,87576
2021-10-08,ES,Spain,EURO,1760,4982052,23,87599
2021-10-09,ES,Spain,EURO,1666,4983718,27,87626
2021-10-10,ES,Spain,EURO,1816,4985534,17,87643
2021-10-11,ES,Spain,EURO,880,4986414,16,87659
2021-10-12,ES,Spain,EURO,519,4986933,16,87675
2021-10-13,ES,Spain,EURO,1963,4988896,19,87694
2021-10-14,ES,Spain,EURO,821,4989717,17,87711
2021-10-15,ES,Spain,EURO,1858,4991575,19,87730
2021-10-16,ES,Spain,EURO,2019,4993594,17,87747
2021-10-17,ES,Spain,EURO,1999,4995593,19,87766
2021-10-18,ES,Spain,EURO,1108,4996701,14,87780
2021-10-19,ES,Spain,EURO,766,4997467,14,87794
2021-10-20,ES,Spain,EURO,2107,4999574,16,87810
2021-10-21,ES,Spain,EURO,2069,5001643,17,87827
2021-10-22,ES,Spain,EURO,2086,5003729,23,87850
2021-10-23,ES,Spain,EURO,1973,5005702,21,87871
2021-10-24,ES,Spain,EURO,2088,5007790,14,87885
2021-10-25,ES,Spain,EURO,1122,5008912,15,87900
2021-10-26,ES,Spain,EURO,835,5009747,14,87914
2021-10-27,ES,Spain,EURO,2242,5011989,15,87929
2021-10-28,ES,Spain,EURO,2083,5014072,18,87947
2021-10-29,ES,Spain,EURO,2107,5016179,15,87962
2021-10-30,ES,Spain,EURO,2124,5018303,18,87980
2021-10-31,ES,Spain,EURO,2427,5020730,7,87987
2021-11-01,ES,Spain,EURO,1348,5022078,19,88006
2021-11-02,ES,Spain,EURO,937,5023015,12,88018
2021-11-03,ES,Spain,EURO,996,5024011,13,88031
2021-11-04,ES,Spain,EURO,2873,5026884,9,88040
2021-11-05,ES,Spain,EURO,2916,5029800,17,88057
2021-11-06,ES,Spain,EURO,2969,5032769,10,88067
2021-11-07,ES,Spain,EURO,3170,5035939,11,88078
2021-11-08,ES,Spain,EURO,1823,5037762,15,88093
2021-11-09,ES,Spain,EURO,1200,5038962,20,88113
2021-11-10,ES,Spain,EURO,3415,5042377,29,88142
2021-11-11,ES,Spain,EURO,3810,5046187,25,88167
2021-11-12,ES,Spain,EURO,3851,5050038,22,88189
2021-11-13,ES,Spain,EURO,4330,5054368,17,88206
2021-11-14,ES,Spain,EURO,4875,5059243,28,88234
2021-11-15,ES,Spain,EURO,2879,5062122,18,88252
2021-11-16,ES,Spain,EURO,2126,5064248,21,88273
2021-11-17,ES,Spain,EURO,5576,5069824,23,88296
2021-11-18,ES,Spain,EURO,6318,5076142,25,88321
2021-11-19,ES,Spain,EURO,6407,5082549,21,88342
2021-11-20,ES,Spain,EURO,6827,5089376,22,88364
2021-11-21,ES,Spain,EURO,7702,5097078,12,88376
2021-11-22,ES,Spain,EURO,4465,5101543,21,88397
2021-11-23,ES,Spain,EURO,3160,5104703,26,88423
2021-11-24,ES,Spain,EURO,8085,5112788,25,88448
2021-11-25,ES,Spain,EURO,9079,5121867,21,88469
2021-11-26,ES,Spain,EURO,9581,5131448,18,88487
2021-11-27,ES,Spain,EURO,9872,5141320,27,88514
2021-11-28,ES,Spain,EURO,11014,5152334,28,88542
2021-11-29,ES,Spain,EURO,6747,5159081,28,88570
2021-11-30,ES,Spain,EURO,4513,5163594,19,88589
2021-12-01,ES,Spain,EURO,11463,5175057,34,88623
2021-12-02,ES,Spain,EURO,13218,5188275,39,88662
2021-12-03,ES,Spain,EURO,14263,5202538,30,88692
2021-12-04,ES,Spain,EURO,15449,5217987,35,88727
2021-12-05,ES,Spain,EURO,16041,5234028,37,88764
2021-12-06,ES,Spain,EURO,11010,5245038,34,88798
2021-12-07,ES,Spain,EURO,7622,5252660,38,88836
2021-12-08,ES,Spain,EURO,7945,5260605,47,88883
2021-12-09,ES,Spain,EURO,18060,5278665,44,88927
2021-12-10,ES,Spain,EURO,11909,5290574,42,88969
2021-12-11,ES,Spain,EURO,20854,5311428,45,89014
2021-12-12,ES,Spain,EURO,25792,5337220,43,89057
2021-12-13,ES,Spain,EURO,16507,5353727,41,89098
2021-12-14,ES,Spain,EURO,12866,5366593,36,89134
2021-12-15,ES,Spain,EURO,27041,5393634,56,89190
2021-12-16,ES,Spain,EURO,31923,5425557,57,89247
2021-12-17,ES,Spain,EURO,36444,5462001,43,89290
2021-12-18,ES,Spain,EURO,38188,5500189,72,89362
2021-12-19,ES,Spain,EURO,43968,5544157,69,89431
2021-12-20,ES,Spain,EURO,26538,5570695,61,89492
2021-12-21,ES,Spain,EURO,22171,5592866,65,89557
2021-12-22,ES,Spain,EURO,54687,5647553,78,89635
2021-12-23,ES,Spain,EURO,73882,5721435,70,89705
2021-12-24,ES,Spain,EURO,85548,5806983,62,89767
2021-12-25,ES,Spain,EURO,95814,5902797,67,89834
2021-12-26,ES,Spain,EURO,74291,5977088,62,89896
2021-12-27,ES,Spain,EURO,46409,6023497,70,89966
2021-12-28,ES,Spain,EURO,51759,6075256,68,90034
2021-12-29,ES,Spain,EURO,114523,6189779,88,90122
2021-12-30,ES,Spain,EURO,135886,6325665,81,90203
2021-12-31,ES,Spain,EURO,147673,6473338,93,90296
2022-01-01,ES,Spain,EURO,145544,6618882,89,90385
2022-01-02,ES,Spain,EURO,103429,6722311,85,90470
2022-01-03,ES,Spain,EURO,58047,6780358,96,90566
2022-01-04,ES,Spain,EURO,70046,6850404,88,90654
2022-01-05,ES,Spain,EURO,143770,6994174,117,90771
2022-01-06,ES,Spain,EURO,164826,7159000,121,90892
2022-01-07,ES,Spain,EURO,160302,7319302,120,91012
2022-01-08,ES,Spain,EURO,74434,7393736,100,91112
2022-01-09,ES,Spain,EURO,148041,7541777,110,91222
2022-01-10,ES,Spain,EURO,89933,7631710,128,91350
2022-01-11,ES,Spain,EURO,90128,7721838,127,91477
2022-01-12,ES,Spain,EURO,171231,7893069,160,91637
2022-01-13,ES,Spain,EURO,168325,8061394,132,91769
2022-01-14,ES,Spain,EURO,157602,8218996,137,91906
2022-01-15,ES,Spain,EURO,146323,8365319,172,92078
2022-01-16,ES,Spain,EURO,131411,8496730,175,92253
2022-01-17,ES,Spain,EURO,83862,8580592,146,92399
2022-01-18,ES,Spain,EURO,73969,8654561,187,92586
2022-01-19,ES,Spain,EURO,153286,8807847,194,92780
2022-01-20,ES,Spain,EURO,146190,8954037,177,92957
2022-01-21,ES,Spain,EURO,139506,9093543,197,93154
2022-01-22,ES,Spain,EURO,129928,9223471,180,93334
2022-01-23,ES,Spain,EURO,124894,9348365,208,93542
2022-01-24,ES,Spain,EURO,71000,9419365,155,93697
2022-01-25,ES,Spain,EURO,64891,9484256,178,93875
2022-01-26,ES,Spain,EURO,129169,9613425,223,94098
2022-01-27,ES,Spain,EURO,116382,9729807,204,94302
2022-01-28,ES,Spain,EURO,108443,9838250,208,94510
2022-01-29,ES,Spain,EURO,92509,9930759,182,94692
2022-01-30,ES,Spain,EURO,82994,10013753,210,94902
2022-01-31,ES,Spain,EURO,46258,10060011,212,95114
2022-02-01,ES,Spain,EURO,39035,10099046,197,95311
2022-02-02,ES,Spain,EURO,79337,10178383,214,95525
2022-02-03,ES,Spain,EURO,70533,10248916,199,95724
2022-02-04,ES,Spain,EURO,64752,10313668,181,95905
2022-02-05,ES,Spain,EURO,57142,10370810,187,96092
2022-02-06,ES,Spain,EURO,52447,10423257,171,96263
2022-02-07,ES,Spain,EURO,27377,10450634,133,96396
2022-02-08,ES,Spain,EURO,23165,10473799,171,96567
2022-02-09,ES,Spain,EURO,51694,10525493,177,96744
2022-02-10,ES,Spain,EURO,45364,10570857,164,96908
2022-02-11,ES,Spain,EURO,41665,10612522,157,97065
2022-02-12,ES,Spain,EURO,35965,10648487,122,97187
2022-02-13,ES,Spain,EURO,29856,10678343,123,97310
2022-02-14,ES,Spain,EURO,15695,10694038,112,97422
2022-02-15,ES,Spain,EURO,13311,10707349,94,97516
2022-02-16,ES,Spain,EURO,28866,10736215,78,97594
2022-02-17,ES,Spain,EURO,26952,10763167,89,97683
2022-02-18,ES,Spain,EURO,15441,10778608,27,97710
2022-02-19,ES,Spain,EURO,0,10778608,0,97710
2022-02-20,ES,Spain,EURO,0,10778608,0,97710
.
157157a
2022-02-19,SS,South Sudan,AFRO,20,16923,0,137
2022-02-20,SS,South Sudan,AFRO,7,16930,0,137
.
156379c
2022-02-18,ZA,South Africa,AFRO,3056,3652024,435,97955
2022-02-19,ZA,South Africa,AFRO,2800,3654824,343,98298
2022-02-20,ZA,South Africa,AFRO,2267,3657091,319,98617
.
155601a
2022-02-19,SO,Somalia,EMRO,0,26260,0,1345
2022-02-20,SO,Somalia,EMRO,0,26260,0,1345
.
154823a
2022-02-19,SB,Solomon Islands,WPRO,119,5684,3,77
2022-02-20,SB,Solomon Islands,WPRO,0,5684,0,77
.
153679,154045c
2021-02-17,SI,Slovenia,EURO,746,180482,6,4073
2021-02-18,SI,Slovenia,EURO,1100,181582,6,4079
2021-02-19,SI,Slovenia,EURO,875,182457,8,4087
2021-02-20,SI,Slovenia,EURO,911,183368,5,4092
2021-02-21,SI,Slovenia,EURO,960,184328,7,4099
2021-02-22,SI,Slovenia,EURO,419,184747,4,4103
2021-02-23,SI,Slovenia,EURO,250,184997,5,4108
2021-02-24,SI,Slovenia,EURO,903,185900,6,4114
2021-02-25,SI,Slovenia,EURO,1095,186995,10,4124
2021-02-26,SI,Slovenia,EURO,859,187854,7,4131
2021-02-27,SI,Slovenia,EURO,920,188774,12,4143
2021-02-28,SI,Slovenia,EURO,949,189723,10,4153
2021-03-01,SI,Slovenia,EURO,455,190178,10,4163
2021-03-02,SI,Slovenia,EURO,246,190424,11,4174
2021-03-03,SI,Slovenia,EURO,730,191154,6,4180
2021-03-04,SI,Slovenia,EURO,1212,192366,7,4187
2021-03-05,SI,Slovenia,EURO,1022,193388,9,4196
2021-03-06,SI,Slovenia,EURO,885,194273,7,4203
2021-03-07,SI,Slovenia,EURO,926,195199,2,4205
2021-03-08,SI,Slovenia,EURO,384,195583,4,4209
2021-03-09,SI,Slovenia,EURO,211,195794,3,4212
2021-03-10,SI,Slovenia,EURO,743,196537,7,4219
2021-03-11,SI,Slovenia,EURO,960,197497,7,4226
2021-03-12,SI,Slovenia,EURO,862,198359,12,4238
2021-03-13,SI,Slovenia,EURO,772,199131,7,4245
2021-03-14,SI,Slovenia,EURO,852,199983,5,4250
2021-03-15,SI,Slovenia,EURO,482,200465,4,4254
2021-03-16,SI,Slovenia,EURO,205,200670,4,4258
2021-03-17,SI,Slovenia,EURO,921,201591,4,4262
2021-03-18,SI,Slovenia,EURO,1114,202705,8,4270
2021-03-19,SI,Slovenia,EURO,976,203681,3,4273
2021-03-20,SI,Slovenia,EURO,944,204625,10,4283
2021-03-21,SI,Slovenia,EURO,1034,205659,10,4293
2021-03-22,SI,Slovenia,EURO,518,206177,6,4299
2021-03-23,SI,Slovenia,EURO,290,206467,8,4307
2021-03-24,SI,Slovenia,EURO,988,207455,8,4315
2021-03-25,SI,Slovenia,EURO,1289,208744,12,4327
2021-03-26,SI,Slovenia,EURO,1163,209907,6,4333
2021-03-27,SI,Slovenia,EURO,1037,210944,9,4342
2021-03-28,SI,Slovenia,EURO,1252,212196,6,4348
2021-03-29,SI,Slovenia,EURO,641,212837,6,4354
2021-03-30,SI,Slovenia,EURO,289,213126,6,4360
2021-03-31,SI,Slovenia,EURO,1084,214210,11,4371
2021-04-01,SI,Slovenia,EURO,1572,215782,12,4383
2021-04-02,SI,Slovenia,EURO,1340,217122,7,4390
2021-04-03,SI,Slovenia,EURO,1172,218294,11,4401
2021-04-04,SI,Slovenia,EURO,1300,219594,6,4407
2021-04-05,SI,Slovenia,EURO,721,220315,9,4416
2021-04-06,SI,Slovenia,EURO,283,220598,5,4421
2021-04-07,SI,Slovenia,EURO,273,220871,9,4430
2021-04-08,SI,Slovenia,EURO,1193,222064,6,4436
2021-04-09,SI,Slovenia,EURO,1531,223595,5,4441
2021-04-10,SI,Slovenia,EURO,1284,224879,3,4444
2021-04-11,SI,Slovenia,EURO,1257,226136,12,4456
2021-04-12,SI,Slovenia,EURO,549,226685,4,4460
2021-04-13,SI,Slovenia,EURO,291,226976,5,4465
2021-04-14,SI,Slovenia,EURO,1050,228026,7,4472
2021-04-15,SI,Slovenia,EURO,1236,229262,6,4478
2021-04-16,SI,Slovenia,EURO,894,230156,4,4482
2021-04-17,SI,Slovenia,EURO,862,231018,9,4491
2021-04-18,SI,Slovenia,EURO,772,231790,7,4498
2021-04-19,SI,Slovenia,EURO,476,232266,4,4502
2021-04-20,SI,Slovenia,EURO,233,232499,9,4511
2021-04-21,SI,Slovenia,EURO,726,233225,8,4519
2021-04-22,SI,Slovenia,EURO,1040,234265,5,4524
2021-04-23,SI,Slovenia,EURO,744,235009,14,4538
2021-04-24,SI,Slovenia,EURO,901,235910,2,4540
2021-04-25,SI,Slovenia,EURO,831,236741,9,4549
2021-04-26,SI,Slovenia,EURO,417,237158,8,4557
2021-04-27,SI,Slovenia,EURO,192,237350,9,4566
2021-04-28,SI,Slovenia,EURO,810,238160,2,4568
2021-04-29,SI,Slovenia,EURO,404,238564,12,4580
2021-04-30,SI,Slovenia,EURO,921,239485,9,4589
2021-05-01,SI,Slovenia,EURO,949,240434,8,4597
2021-05-02,SI,Slovenia,EURO,1019,241453,9,4606
2021-05-03,SI,Slovenia,EURO,367,241820,4,4610
2021-05-04,SI,Slovenia,EURO,210,242030,8,4618
2021-05-05,SI,Slovenia,EURO,893,242923,3,4621
2021-05-06,SI,Slovenia,EURO,930,243853,9,4630
2021-05-07,SI,Slovenia,EURO,777,244630,2,4632
2021-05-08,SI,Slovenia,EURO,609,245239,3,4635
2021-05-09,SI,Slovenia,EURO,634,245873,0,4635
2021-05-10,SI,Slovenia,EURO,291,246164,7,4642
2021-05-11,SI,Slovenia,EURO,146,246310,7,4649
2021-05-12,SI,Slovenia,EURO,491,246801,2,4651
2021-05-13,SI,Slovenia,EURO,730,247531,5,4656
2021-05-14,SI,Slovenia,EURO,599,248130,5,4661
2021-05-15,SI,Slovenia,EURO,472,248602,7,4668
2021-05-16,SI,Slovenia,EURO,496,249098,2,4670
2021-05-17,SI,Slovenia,EURO,293,249391,3,4673
2021-05-18,SI,Slovenia,EURO,115,249506,5,4678
2021-05-19,SI,Slovenia,EURO,497,250003,4,4682
2021-05-20,SI,Slovenia,EURO,538,250541,4,4686
2021-05-21,SI,Slovenia,EURO,358,250899,5,4691
2021-05-22,SI,Slovenia,EURO,334,251233,2,4693
2021-05-23,SI,Slovenia,EURO,382,251615,2,4695
2021-05-24,SI,Slovenia,EURO,158,251773,1,4696
2021-05-25,SI,Slovenia,EURO,84,251857,2,4698
2021-05-26,SI,Slovenia,EURO,323,252180,1,4699
2021-05-27,SI,Slovenia,EURO,391,252571,4,4703
2021-05-28,SI,Slovenia,EURO,367,252938,1,4704
2021-05-29,SI,Slovenia,EURO,289,253227,3,4707
2021-05-30,SI,Slovenia,EURO,356,253583,3,4710
2021-05-31,SI,Slovenia,EURO,137,253720,4,4714
2021-06-01,SI,Slovenia,EURO,92,253812,2,4716
2021-06-02,SI,Slovenia,EURO,323,254135,1,4717
2021-06-03,SI,Slovenia,EURO,373,254508,3,4720
2021-06-04,SI,Slovenia,EURO,273,254781,2,4722
2021-06-05,SI,Slovenia,EURO,280,255061,3,4725
2021-06-06,SI,Slovenia,EURO,247,255308,1,4726
2021-06-07,SI,Slovenia,EURO,157,255465,2,4728
2021-06-08,SI,Slovenia,EURO,58,255523,2,4730
2021-06-09,SI,Slovenia,EURO,220,255743,3,4733
2021-06-10,SI,Slovenia,EURO,254,255997,0,4733
2021-06-11,SI,Slovenia,EURO,195,256192,3,4736
2021-06-12,SI,Slovenia,EURO,123,256315,3,4739
2021-06-13,SI,Slovenia,EURO,126,256441,3,4742
2021-06-14,SI,Slovenia,EURO,91,256532,5,4747
2021-06-15,SI,Slovenia,EURO,24,256556,3,4750
2021-06-16,SI,Slovenia,EURO,113,256669,3,4753
2021-06-17,SI,Slovenia,EURO,117,256786,1,4754
2021-06-18,SI,Slovenia,EURO,84,256870,0,4754
2021-06-19,SI,Slovenia,EURO,89,256959,1,4755
2021-06-20,SI,Slovenia,EURO,84,257043,0,4755
2021-06-21,SI,Slovenia,EURO,26,257069,2,4757
2021-06-22,SI,Slovenia,EURO,19,257088,2,4759
2021-06-23,SI,Slovenia,EURO,67,257155,2,4761
2021-06-24,SI,Slovenia,EURO,54,257209,0,4761
2021-06-25,SI,Slovenia,EURO,43,257252,1,4762
2021-06-26,SI,Slovenia,EURO,46,257298,1,4763
2021-06-27,SI,Slovenia,EURO,11,257309,2,4765
2021-06-28,SI,Slovenia,EURO,19,257328,0,4765
2021-06-29,SI,Slovenia,EURO,11,257339,0,4765
2021-06-30,SI,Slovenia,EURO,36,257375,0,4765
2021-07-01,SI,Slovenia,EURO,47,257422,0,4765
2021-07-02,SI,Slovenia,EURO,23,257445,0,4765
2021-07-03,SI,Slovenia,EURO,24,257469,0,4765
2021-07-04,SI,Slovenia,EURO,30,257499,0,4765
2021-07-05,SI,Slovenia,EURO,9,257508,0,4765
2021-07-06,SI,Slovenia,EURO,8,257516,1,4766
2021-07-07,SI,Slovenia,EURO,48,257564,1,4767
2021-07-08,SI,Slovenia,EURO,73,257637,3,4770
2021-07-09,SI,Slovenia,EURO,69,257706,0,4770
2021-07-10,SI,Slovenia,EURO,81,257787,2,4772
2021-07-11,SI,Slovenia,EURO,81,257868,0,4772
2021-07-12,SI,Slovenia,EURO,24,257892,0,4772
2021-07-13,SI,Slovenia,EURO,11,257903,2,4774
2021-07-14,SI,Slovenia,EURO,84,257987,0,4774
2021-07-15,SI,Slovenia,EURO,83,258070,0,4774
2021-07-16,SI,Slovenia,EURO,56,258126,0,4774
2021-07-17,SI,Slovenia,EURO,63,258189,0,4774
2021-07-18,SI,Slovenia,EURO,61,258250,0,4774
2021-07-19,SI,Slovenia,EURO,21,258271,0,4774
2021-07-20,SI,Slovenia,EURO,9,258280,0,4774
2021-07-21,SI,Slovenia,EURO,89,258369,0,4774
2021-07-22,SI,Slovenia,EURO,110,258479,0,4774
2021-07-23,SI,Slovenia,EURO,70,258549,0,4774
2021-07-24,SI,Slovenia,EURO,58,258607,0,4774
2021-07-25,SI,Slovenia,EURO,93,258700,1,4775
2021-07-26,SI,Slovenia,EURO,32,258732,0,4775
2021-07-27,SI,Slovenia,EURO,21,258753,0,4775
2021-07-28,SI,Slovenia,EURO,106,258859,0,4775
2021-07-29,SI,Slovenia,EURO,85,258944,0,4775
2021-07-30,SI,Slovenia,EURO,99,259043,0,4775
2021-07-31,SI,Slovenia,EURO,117,259160,0,4775
2021-08-01,SI,Slovenia,EURO,135,259295,1,4776
2021-08-02,SI,Slovenia,EURO,58,259353,0,4776
2021-08-03,SI,Slovenia,EURO,31,259384,0,4776
2021-08-04,SI,Slovenia,EURO,181,259565,0,4776
2021-08-05,SI,Slovenia,EURO,139,259704,0,4776
2021-08-06,SI,Slovenia,EURO,139,259843,0,4776
2021-08-07,SI,Slovenia,EURO,143,259986,1,4777
2021-08-08,SI,Slovenia,EURO,134,260120,0,4777
2021-08-09,SI,Slovenia,EURO,67,260187,0,4777
2021-08-10,SI,Slovenia,EURO,46,260233,0,4777
2021-08-11,SI,Slovenia,EURO,219,260452,0,4777
2021-08-12,SI,Slovenia,EURO,247,260699,0,4777
2021-08-13,SI,Slovenia,EURO,250,260949,0,4777
2021-08-14,SI,Slovenia,EURO,199,261148,0,4777
2021-08-15,SI,Slovenia,EURO,264,261412,0,4777
2021-08-16,SI,Slovenia,EURO,97,261509,0,4777
2021-08-17,SI,Slovenia,EURO,57,261566,0,4777
2021-08-18,SI,Slovenia,EURO,318,261884,0,4777
2021-08-19,SI,Slovenia,EURO,387,262271,2,4779
2021-08-20,SI,Slovenia,EURO,382,262653,4,4783
2021-08-21,SI,Slovenia,EURO,335,262988,0,4783
2021-08-22,SI,Slovenia,EURO,388,263376,0,4783
2021-08-23,SI,Slovenia,EURO,246,263622,2,4785
2021-08-24,SI,Slovenia,EURO,117,263739,1,4786
2021-08-25,SI,Slovenia,EURO,476,264215,3,4789
2021-08-26,SI,Slovenia,EURO,509,264724,1,4790
2021-08-27,SI,Slovenia,EURO,511,265235,1,4791
2021-08-28,SI,Slovenia,EURO,544,265779,3,4794
2021-08-29,SI,Slovenia,EURO,540,266319,2,4796
2021-08-30,SI,Slovenia,EURO,277,266596,0,4796
2021-08-31,SI,Slovenia,EURO,144,266740,0,4796
2021-09-01,SI,Slovenia,EURO,541,267281,2,4798
2021-09-02,SI,Slovenia,EURO,772,268053,2,4800
2021-09-03,SI,Slovenia,EURO,668,268721,1,4801
2021-09-04,SI,Slovenia,EURO,611,269332,1,4802
2021-09-05,SI,Slovenia,EURO,743,270075,2,4804
2021-09-06,SI,Slovenia,EURO,318,270393,0,4804
2021-09-07,SI,Slovenia,EURO,236,270629,0,4804
2021-09-08,SI,Slovenia,EURO,881,271510,3,4807
2021-09-09,SI,Slovenia,EURO,1095,272605,5,4812
2021-09-10,SI,Slovenia,EURO,1019,273624,2,4814
2021-09-11,SI,Slovenia,EURO,999,274623,3,4817
2021-09-12,SI,Slovenia,EURO,1088,275711,5,4822
2021-09-13,SI,Slovenia,EURO,560,276271,0,4822
2021-09-14,SI,Slovenia,EURO,285,276556,3,4825
2021-09-15,SI,Slovenia,EURO,1394,277950,4,4829
2021-09-16,SI,Slovenia,EURO,1365,279315,5,4834
2021-09-17,SI,Slovenia,EURO,1327,280642,8,4842
2021-09-18,SI,Slovenia,EURO,1145,281787,4,4846
2021-09-19,SI,Slovenia,EURO,1253,283040,6,4852
2021-09-20,SI,Slovenia,EURO,545,283585,3,4855
2021-09-21,SI,Slovenia,EURO,292,283877,6,4861
2021-09-22,SI,Slovenia,EURO,1308,285185,5,4866
2021-09-23,SI,Slovenia,EURO,1189,286374,7,4873
2021-09-24,SI,Slovenia,EURO,1012,287386,4,4877
2021-09-25,SI,Slovenia,EURO,941,288327,7,4884
2021-09-26,SI,Slovenia,EURO,1007,289334,8,4892
2021-09-27,SI,Slovenia,EURO,447,289781,7,4899
2021-09-28,SI,Slovenia,EURO,286,290067,7,4906
2021-09-29,SI,Slovenia,EURO,1041,291108,13,4919
2021-09-30,SI,Slovenia,EURO,1342,292450,4,4923
2021-10-01,SI,Slovenia,EURO,1028,293478,9,4932
2021-10-02,SI,Slovenia,EURO,973,294451,5,4937
2021-10-03,SI,Slovenia,EURO,993,295444,9,4946
2021-10-04,SI,Slovenia,EURO,533,295977,7,4953
2021-10-05,SI,Slovenia,EURO,225,296202,7,4960
2021-10-06,SI,Slovenia,EURO,980,297182,7,4967
2021-10-07,SI,Slovenia,EURO,1209,298391,11,4978
2021-10-08,SI,Slovenia,EURO,969,299360,4,4982
2021-10-09,SI,Slovenia,EURO,842,300202,3,4985
2021-10-10,SI,Slovenia,EURO,883,301085,10,4995
2021-10-11,SI,Slovenia,EURO,489,301574,9,5004
2021-10-12,SI,Slovenia,EURO,188,301762,6,5010
2021-10-13,SI,Slovenia,EURO,1005,302767,2,5012
2021-10-14,SI,Slovenia,EURO,1229,303996,4,5016
2021-10-15,SI,Slovenia,EURO,1082,305078,9,5025
2021-10-16,SI,Slovenia,EURO,1105,306183,5,5030
2021-10-17,SI,Slovenia,EURO,1438,307621,4,5034
2021-10-18,SI,Slovenia,EURO,632,308253,4,5038
2021-10-19,SI,Slovenia,EURO,364,308617,7,5045
2021-10-20,SI,Slovenia,EURO,1673,310290,5,5050
2021-10-21,SI,Slovenia,EURO,2155,312445,7,5057
2021-10-22,SI,Slovenia,EURO,1852,314297,11,5068
2021-10-23,SI,Slovenia,EURO,1969,316266,4,5072
2021-10-24,SI,Slovenia,EURO,2272,318538,11,5083
2021-10-25,SI,Slovenia,EURO,1498,320036,5,5088
2021-10-26,SI,Slovenia,EURO,708,320744,9,5097
2021-10-27,SI,Slovenia,EURO,2296,323040,10,5107
2021-10-28,SI,Slovenia,EURO,3138,326178,11,5118
2021-10-29,SI,Slovenia,EURO,2632,328810,11,5129
2021-10-30,SI,Slovenia,EURO,2517,331327,15,5144
2021-10-31,SI,Slovenia,EURO,2991,334318,7,5151
2021-11-01,SI,Slovenia,EURO,1664,335982,8,5159
2021-11-02,SI,Slovenia,EURO,1258,337240,12,5171
2021-11-03,SI,Slovenia,EURO,1136,338376,10,5181
2021-11-04,SI,Slovenia,EURO,3462,341838,19,5200
2021-11-05,SI,Slovenia,EURO,4518,346356,12,5212
2021-11-06,SI,Slovenia,EURO,3779,350135,17,5229
2021-11-07,SI,Slovenia,EURO,3664,353799,12,5241
2021-11-08,SI,Slovenia,EURO,2325,356124,15,5256
2021-11-09,SI,Slovenia,EURO,1288,357412,20,5276
2021-11-10,SI,Slovenia,EURO,3348,360760,13,5289
2021-11-11,SI,Slovenia,EURO,4483,365243,20,5309
2021-11-12,SI,Slovenia,EURO,3573,368816,12,5321
2021-11-13,SI,Slovenia,EURO,3435,372251,12,5333
2021-11-14,SI,Slovenia,EURO,3667,375918,24,5357
2021-11-15,SI,Slovenia,EURO,2369,378287,24,5381
2021-11-16,SI,Slovenia,EURO,1820,380107,23,5404
2021-11-17,SI,Slovenia,EURO,3771,383878,9,5413
2021-11-18,SI,Slovenia,EURO,4283,388161,15,5428
2021-11-19,SI,Slovenia,EURO,3667,391828,26,5454
2021-11-20,SI,Slovenia,EURO,3518,395346,25,5479
2021-11-21,SI,Slovenia,EURO,3239,398585,20,5499
2021-11-22,SI,Slovenia,EURO,2248,400833,27,5526
2021-11-23,SI,Slovenia,EURO,1390,402223,18,5544
2021-11-24,SI,Slovenia,EURO,3400,405623,19,5563
2021-11-25,SI,Slovenia,EURO,3143,408766,19,5582
2021-11-26,SI,Slovenia,EURO,2670,411436,14,5596
2021-11-27,SI,Slovenia,EURO,2367,413803,18,5614
2021-11-28,SI,Slovenia,EURO,2227,416030,25,5639
2021-11-29,SI,Slovenia,EURO,1481,417511,31,5670
2021-11-30,SI,Slovenia,EURO,1039,418550,21,5691
2021-12-01,SI,Slovenia,EURO,2484,421034,19,5710
2021-12-02,SI,Slovenia,EURO,2258,423292,23,5733
2021-12-03,SI,Slovenia,EURO,2128,425420,20,5753
2021-12-04,SI,Slovenia,EURO,1739,427159,20,5773
2021-12-05,SI,Slovenia,EURO,1908,429067,22,5795
2021-12-06,SI,Slovenia,EURO,1116,430183,20,5815
2021-12-07,SI,Slovenia,EURO,775,430958,11,5826
2021-12-08,SI,Slovenia,EURO,1955,432913,18,5844
2021-12-09,SI,Slovenia,EURO,1852,434765,17,5861
2021-12-10,SI,Slovenia,EURO,1688,436453,14,5875
2021-12-11,SI,Slovenia,EURO,1324,437777,19,5894
2021-12-12,SI,Slovenia,EURO,1480,439257,15,5909
2021-12-13,SI,Slovenia,EURO,786,440043,12,5921
2021-12-14,SI,Slovenia,EURO,677,440720,19,5940
2021-12-15,SI,Slovenia,EURO,1716,442436,16,5956
2021-12-16,SI,Slovenia,EURO,1530,443966,14,5970
2021-12-17,SI,Slovenia,EURO,1347,445313,7,5977
2021-12-18,SI,Slovenia,EURO,1281,446594,11,5988
2021-12-19,SI,Slovenia,EURO,1288,447882,16,6004
2021-12-20,SI,Slovenia,EURO,769,448651,12,6016
2021-12-21,SI,Slovenia,EURO,586,449237,8,6024
2021-12-22,SI,Slovenia,EURO,1558,450795,10,6034
2021-12-23,SI,Slovenia,EURO,1255,452050,9,6043
2021-12-24,SI,Slovenia,EURO,1124,453174,8,6051
2021-12-25,SI,Slovenia,EURO,1207,454381,9,6060
2021-12-26,SI,Slovenia,EURO,1091,455472,4,6064
2021-12-27,SI,Slovenia,EURO,666,456138,11,6075
2021-12-28,SI,Slovenia,EURO,701,456839,9,6084
2021-12-29,SI,Slovenia,EURO,1819,458658,11,6095
2021-12-30,SI,Slovenia,EURO,1871,460529,17,6112
2021-12-31,SI,Slovenia,EURO,1691,462220,7,6119
2022-01-01,SI,Slovenia,EURO,1898,464118,5,6124
2022-01-02,SI,Slovenia,EURO,1668,465786,7,6131
2022-01-03,SI,Slovenia,EURO,835,466621,8,6139
2022-01-04,SI,Slovenia,EURO,1010,467631,9,6148
2022-01-05,SI,Slovenia,EURO,3403,471034,10,6158
2022-01-06,SI,Slovenia,EURO,4084,475118,8,6166
2022-01-07,SI,Slovenia,EURO,3848,478966,7,6173
2022-01-08,SI,Slovenia,EURO,4085,483051,11,6184
2022-01-09,SI,Slovenia,EURO,4492,487543,5,6189
2022-01-10,SI,Slovenia,EURO,3360,490903,6,6195
2022-01-11,SI,Slovenia,EURO,2530,493433,8,6203
2022-01-12,SI,Slovenia,EURO,5174,498607,4,6207
2022-01-13,SI,Slovenia,EURO,7436,506043,12,6219
2022-01-14,SI,Slovenia,EURO,6879,512922,9,6228
2022-01-15,SI,Slovenia,EURO,6941,519863,9,6237
2022-01-16,SI,Slovenia,EURO,7604,527467,6,6243
2022-01-17,SI,Slovenia,EURO,6022,533489,4,6247
2022-01-18,SI,Slovenia,EURO,4979,538468,7,6254
2022-01-19,SI,Slovenia,EURO,8695,547163,10,6264
2022-01-20,SI,Slovenia,EURO,12302,559465,14,6278
2022-01-21,SI,Slovenia,EURO,10306,569771,5,6283
2022-01-22,SI,Slovenia,EURO,9866,579637,11,6294
2022-01-23,SI,Slovenia,EURO,9960,589597,13,6307
2022-01-24,SI,Slovenia,EURO,14191,603788,18,6325
2022-01-25,SI,Slovenia,EURO,8414,612202,13,6338
2022-01-26,SI,Slovenia,EURO,12839,625041,15,6353
2022-01-27,SI,Slovenia,EURO,17513,642554,22,6375
2022-01-28,SI,Slovenia,EURO,14227,656781,16,6391
2022-01-29,SI,Slovenia,EURO,16897,673678,10,6401
2022-01-30,SI,Slovenia,EURO,14903,688581,18,6419
2022-01-31,SI,Slovenia,EURO,13868,702449,20,6439
2022-02-01,SI,Slovenia,EURO,8583,711032,18,6457
2022-02-02,SI,Slovenia,EURO,11731,722763,19,6476
2022-02-03,SI,Slovenia,EURO,24234,746997,20,6496
2022-02-04,SI,Slovenia,EURO,16787,763784,21,6517
2022-02-05,SI,Slovenia,EURO,11768,775552,28,6545
2022-02-06,SI,Slovenia,EURO,11734,787286,31,6576
2022-02-07,SI,Slovenia,EURO,7531,794817,29,6605
2022-02-08,SI,Slovenia,EURO,5545,800362,23,6628
2022-02-09,SI,Slovenia,EURO,11192,811554,21,6649
2022-02-10,SI,Slovenia,EURO,5130,816684,24,6673
2022-02-11,SI,Slovenia,EURO,12197,828881,15,6688
2022-02-12,SI,Slovenia,EURO,7564,836445,25,6713
2022-02-13,SI,Slovenia,EURO,7390,843835,25,6738
2022-02-14,SI,Slovenia,EURO,4296,848131,13,6751
2022-02-15,SI,Slovenia,EURO,3637,851768,21,6772
2022-02-16,SI,Slovenia,EURO,7154,858922,17,6789
2022-02-17,SI,Slovenia,EURO,4735,863657,11,6800
2022-02-18,SI,Slovenia,EURO,4561,868218,9,6809
2022-02-19,SI,Slovenia,EURO,3818,872036,7,6816
2022-02-20,SI,Slovenia,EURO,3734,875770,0,6816
.
153267a
2022-02-19,SK,Slovakia,EURO,17933,1342436,24,18225
2022-02-20,SK,Slovakia,EURO,11912,1354348,15,18240
.
152489a
2022-02-19,SX,Sint Maarten,AMRO,6,9511,0,84
2022-02-20,SX,Sint Maarten,AMRO,0,9511,0,84
.
151711a
2022-02-19,XB,Sint Eustatius,AMRO,4,441,0,3
2022-02-20,XB,Sint Eustatius,AMRO,0,441,0,3
.
150933a
2022-02-19,SG,Singapore,WPRO,18094,551519,7,937
2022-02-20,SG,Singapore,WPRO,24836,576355,4,941
.
150155c
2022-02-18,SL,Sierra Leone,AFRO,2,7661,0,125
2022-02-19,SL,Sierra Leone,AFRO,0,7661,0,125
2022-02-20,SL,Sierra Leone,AFRO,0,7661,0,125
.
149377c
2022-02-18,SC,Seychelles,AFRO,62,38978,0,151
2022-02-19,SC,Seychelles,AFRO,55,39033,0,151
2022-02-20,SC,Seychelles,AFRO,0,39033,0,151
.
148599a
2022-02-19,RS,Serbia,EURO,6298,1874134,62,14728
2022-02-20,RS,Serbia,EURO,5103,1879237,69,14797
.
147821c
2022-02-18,SN,Senegal,AFRO,26,85495,1,1958
2022-02-19,SN,Senegal,AFRO,26,85521,0,1958
2022-02-20,SN,Senegal,AFRO,24,85545,0,1958
.
147043a
2022-02-19,SA,Saudi Arabia,EMRO,1376,737334,3,8981
2022-02-20,SA,Saudi Arabia,EMRO,997,738331,1,8982
.
146265a
2022-02-19,ST,Sao Tome and Principe,AFRO,2,5924,0,71
2022-02-20,ST,Sao Tome and Principe,AFRO,1,5925,0,71
.
145443,145487c
2022-01-05,SM,San Marino,EURO,176,8894,0,102
2022-01-06,SM,San Marino,EURO,250,9144,1,103
2022-01-07,SM,San Marino,EURO,18,9162,0,103
2022-01-08,SM,San Marino,EURO,260,9422,0,103
2022-01-09,SM,San Marino,EURO,164,9586,0,103
2022-01-10,SM,San Marino,EURO,14,9600,0,103
2022-01-11,SM,San Marino,EURO,274,9874,0,103
2022-01-12,SM,San Marino,EURO,219,10093,0,103
2022-01-13,SM,San Marino,EURO,177,10270,0,103
2022-01-14,SM,San Marino,EURO,150,10420,0,103
2022-01-15,SM,San Marino,EURO,148,10568,0,103
2022-01-16,SM,San Marino,EURO,128,10696,0,103
2022-01-17,SM,San Marino,EURO,6,10702,0,103
2022-01-18,SM,San Marino,EURO,223,10925,0,103
2022-01-19,SM,San Marino,EURO,217,11142,0,103
2022-01-20,SM,San Marino,EURO,210,11352,2,105
2022-01-21,SM,San Marino,EURO,178,11530,1,106
2022-01-22,SM,San Marino,EURO,172,11702,1,107
2022-01-23,SM,San Marino,EURO,141,11843,0,107
2022-01-24,SM,San Marino,EURO,14,11857,1,108
2022-01-25,SM,San Marino,EURO,211,12068,0,108
2022-01-26,SM,San Marino,EURO,238,12306,1,109
2022-01-27,SM,San Marino,EURO,231,12537,0,109
2022-01-28,SM,San Marino,EURO,166,12703,0,109
2022-01-29,SM,San Marino,EURO,143,12846,0,109
2022-01-30,SM,San Marino,EURO,109,12955,0,109
2022-01-31,SM,San Marino,EURO,13,12968,0,109
2022-02-01,SM,San Marino,EURO,193,13161,0,109
2022-02-02,SM,San Marino,EURO,129,13290,0,109
2022-02-03,SM,San Marino,EURO,103,13393,0,109
2022-02-04,SM,San Marino,EURO,102,13495,0,109
2022-02-05,SM,San Marino,EURO,94,13589,0,109
2022-02-06,SM,San Marino,EURO,13,13602,0,109
2022-02-07,SM,San Marino,EURO,17,13619,0,109
2022-02-08,SM,San Marino,EURO,133,13752,0,109
2022-02-09,SM,San Marino,EURO,62,13814,0,109
2022-02-10,SM,San Marino,EURO,65,13879,1,110
2022-02-11,SM,San Marino,EURO,52,13931,0,110
2022-02-12,SM,San Marino,EURO,37,13968,0,110
2022-02-13,SM,San Marino,EURO,36,14004,0,110
2022-02-14,SM,San Marino,EURO,6,14010,0,110
2022-02-15,SM,San Marino,EURO,52,14062,0,110
2022-02-16,SM,San Marino,EURO,37,14099,0,110
2022-02-17,SM,San Marino,EURO,31,14130,0,110
2022-02-18,SM,San Marino,EURO,22,14152,2,112
2022-02-19,SM,San Marino,EURO,39,14191,0,112
2022-02-20,SM,San Marino,EURO,13,14204,0,112
.
144709a
2022-02-19,WS,Samoa,WPRO,0,33,0,0
2022-02-20,WS,Samoa,WPRO,0,33,0,0
.
143930,143931c
2022-02-17,VC,Saint Vincent and the Grenadines,AMRO,16,8278,1,104
2022-02-18,VC,Saint Vincent and the Grenadines,AMRO,0,8278,0,104
2022-02-19,VC,Saint Vincent and the Grenadines,AMRO,0,8278,0,104
2022-02-20,VC,Saint Vincent and the Grenadines,AMRO,0,8278,0,104
.
143153a
2022-02-19,PM,Saint Pierre and Miquelon,AMRO,0,965,0,1
2022-02-20,PM,Saint Pierre and Miquelon,AMRO,0,965,0,1
.
142375a
2022-02-19,MF,Saint Martin,AMRO,58,9790,0,44
2022-02-20,MF,Saint Martin,AMRO,0,9790,0,44
.
141597a
2022-02-19,LC,Saint Lucia,AMRO,42,22468,3,356
2022-02-20,LC,Saint Lucia,AMRO,0,22468,0,356
.
140819a
2022-02-19,KN,Saint Kitts and Nevis,AMRO,0,5511,0,40
2022-02-20,KN,Saint Kitts and Nevis,AMRO,0,5511,0,40
.
140041a
2022-02-19,SH,Saint Helena,AFRO,0,0,0,0
2022-02-20,SH,Saint Helena,AFRO,0,0,0,0
.
139263a
2022-02-19,BL,Saint Barthélemy,AMRO,51,3684,0,4
2022-02-20,BL,Saint Barthélemy,AMRO,0,3684,0,4
.
138485a
2022-02-19,XC,Saba,AMRO,0,205,0,0
2022-02-20,XC,Saba,AMRO,0,205,0,0
.
137707a
2022-02-19,RW,Rwanda,AFRO,22,129359,2,1454
2022-02-20,RW,Rwanda,AFRO,10,129369,1,1455
.
136929a
2022-02-19,RU,Russian Federation,EURO,179147,15199720,798,344755
2022-02-20,RU,Russian Federation,EURO,170699,15370419,745,345500
.
136151a
2022-02-19,RO,Romania,EURO,14524,2643614,135,62323
2022-02-20,RO,Romania,EURO,12319,2655933,148,62471
.
135373a
2022-02-19,RE,Réunion,AFRO,0,278494,0,603
2022-02-20,RE,Réunion,AFRO,0,278494,0,603
.
134595a
2022-02-19,MD,Republic of Moldova,EURO,1615,494219,25,11093
2022-02-20,MD,Republic of Moldova,EURO,965,495184,10,11103
.
133817c
2022-02-18,KR,Republic of Korea,WPRO,109823,1755798,45,7283
2022-02-19,KR,Republic of Korea,WPRO,102210,1858008,71,7354
2022-02-20,KR,Republic of Korea,WPRO,104814,1962822,51,7405
.
133039a
2022-02-19,QA,Qatar,EMRO,452,353346,1,661
2022-02-20,QA,Qatar,EMRO,434,353780,1,662
.
132261a
2022-02-19,PR,Puerto Rico,AMRO,377,470669,9,4069
2022-02-20,PR,Puerto Rico,AMRO,563,471232,9,4078
.
131483a
2022-02-19,PT,Portugal,EURO,15482,3163869,51,20759
2022-02-20,PT,Portugal,EURO,14160,3178029,37,20796
.
130705a
2022-02-19,PL,Poland,EURO,20880,5540162,283,109792
2022-02-20,PL,Poland,EURO,13679,5553841,25,109817
.
129927a
2022-02-19,PN,Pitcairn Islands,WPRO,0,0,0,0
2022-02-20,PN,Pitcairn Islands,WPRO,0,0,0,0
.
129149a
2022-02-19,PH,Philippines,WPRO,2032,3648825,79,55409
2022-02-20,PH,Philippines,WPRO,1666,3650491,198,55607
.
128371a
2022-02-19,PE,Peru,AMRO,8656,3474965,175,208964
2022-02-20,PE,Peru,AMRO,6787,3481752,146,209110
.
127593a
2022-02-19,PY,Paraguay,AMRO,1726,632444,37,18116
2022-02-20,PY,Paraguay,AMRO,1289,633733,31,18147
.
126815a
2022-02-19,PG,Papua New Guinea,WPRO,329,39909,8,636
2022-02-20,PG,Papua New Guinea,WPRO,0,39909,0,636
.
126037a
2022-02-19,PA,Panama,AMRO,1221,747916,6,7993
2022-02-20,PA,Panama,AMRO,1219,749135,7,8000
.
125259a
2022-02-19,PW,Palau,WPRO,38,3463,0,5
2022-02-20,PW,Palau,WPRO,0,3463,0,5
.
124481a
2022-02-19,PK,Pakistan,EMRO,2400,1496693,33,29950
2022-02-20,PK,Pakistan,EMRO,1983,1498676,26,29976
.
123703a
2022-02-19, ,Other,Other,0,764,0,13
2022-02-20, ,Other,Other,0,764,0,13
.
122925a
2022-02-19,OM,Oman,EMRO,0,372060,0,4225
2022-02-20,OM,Oman,EMRO,0,372060,0,4225
.
122147a
2022-02-19,PS,"occupied Palestinian territory, including east Jerusalem",EMRO,2545,630501,15,5372
2022-02-20,PS,"occupied Palestinian territory, including east Jerusalem",EMRO,1255,631756,19,5391
.
121334,121369c
2022-01-14,NO,Norway,EURO,11115,484826,9,1401
2022-01-15,NO,Norway,EURO,10878,495704,0,1401
2022-01-16,NO,Norway,EURO,11345,507049,0,1401
2022-01-17,NO,Norway,EURO,7745,514794,0,1401
2022-01-18,NO,Norway,EURO,8640,523434,8,1409
2022-01-19,NO,Norway,EURO,20813,544247,2,1411
2022-01-20,NO,Norway,EURO,18528,562775,1,1412
2022-01-21,NO,Norway,EURO,18148,580923,1,1413
2022-01-22,NO,Norway,EURO,18277,599200,0,1413
2022-01-23,NO,Norway,EURO,18554,617754,0,1413
2022-01-24,NO,Norway,EURO,12267,630021,0,1413
2022-01-25,NO,Norway,EURO,12864,642885,23,1436
2022-01-26,NO,Norway,EURO,28360,671245,2,1438
2022-01-27,NO,Norway,EURO,23586,694831,2,1440
2022-01-28,NO,Norway,EURO,22084,716915,0,1440
2022-01-29,NO,Norway,EURO,20087,737002,0,1440
2022-01-30,NO,Norway,EURO,18997,755999,0,1440
2022-01-31,NO,Norway,EURO,10774,766773,0,1440
2022-02-01,NO,Norway,EURO,11545,778318,25,1465
2022-02-02,NO,Norway,EURO,27859,806177,0,1465
2022-02-03,NO,Norway,EURO,23460,829637,1,1466
2022-02-04,NO,Norway,EURO,20345,849982,0,1466
2022-02-05,NO,Norway,EURO,17527,867509,0,1466
2022-02-06,NO,Norway,EURO,17414,884923,0,1466
2022-02-07,NO,Norway,EURO,10957,895880,0,1466
2022-02-08,NO,Norway,EURO,11091,906971,40,1506
2022-02-09,NO,Norway,EURO,29453,936424,6,1512
2022-02-10,NO,Norway,EURO,25500,961924,0,1512
2022-02-11,NO,Norway,EURO,24002,985926,1,1513
2022-02-12,NO,Norway,EURO,21918,1007844,0,1513
2022-02-13,NO,Norway,EURO,20517,1028361,0,1513
2022-02-14,NO,Norway,EURO,9168,1037529,0,1513
2022-02-15,NO,Norway,EURO,7816,1045345,32,1545
2022-02-16,NO,Norway,EURO,20247,1065592,3,1548
2022-02-17,NO,Norway,EURO,16635,1082227,0,1548
2022-02-18,NO,Norway,EURO,17149,1099376,0,1548
2022-02-19,NO,Norway,EURO,15711,1115087,0,1548
2022-02-20,NO,Norway,EURO,14766,1129853,0,1548
.
120591a
2022-02-19,MP,Northern Mariana Islands (Commonwealth of the),WPRO,158,8311,0,25
2022-02-20,MP,Northern Mariana Islands (Commonwealth of the),WPRO,111,8422,1,26
.
119813a
2022-02-19,MK,North Macedonia,EURO,905,291820,18,8869
2022-02-20,MK,North Macedonia,EURO,840,292660,22,8891
.
119035a
2022-02-19,NU,Niue,WPRO,0,0,0,0
2022-02-20,NU,Niue,WPRO,0,0,0,0
.
118257a
2022-02-19,NG,Nigeria,AFRO,84,254221,1,3142
2022-02-20,NG,Nigeria,AFRO,22,254243,0,3142
.
117479a
2022-02-19,NE,Niger,AFRO,0,8728,0,303
2022-02-20,NE,Niger,AFRO,6,8734,0,303
.
116701a
2022-02-19,NI,Nicaragua,AMRO,0,13877,0,223
2022-02-20,NI,Nicaragua,AMRO,0,13877,0,223
.
115923a
2022-02-19,NZ,New Zealand,WPRO,1611,28155,0,53
2022-02-20,NZ,New Zealand,WPRO,2395,30550,0,53
.
115145a
2022-02-19,NC,New Caledonia,WPRO,1037,44021,0,287
2022-02-20,NC,New Caledonia,WPRO,0,44021,0,287
.
114210,114367c
2021-09-14,NL,Netherlands,EURO,1751,1972446,4,18073
2021-09-15,NL,Netherlands,EURO,2001,1974447,10,18083
2021-09-16,NL,Netherlands,EURO,2375,1976822,7,18090
2021-09-17,NL,Netherlands,EURO,2090,1978912,7,18097
2021-09-18,NL,Netherlands,EURO,2126,1981038,10,18107
2021-09-19,NL,Netherlands,EURO,2014,1983052,4,18111
2021-09-20,NL,Netherlands,EURO,1664,1984716,3,18114
2021-09-21,NL,Netherlands,EURO,1353,1986069,9,18123
2021-09-22,NL,Netherlands,EURO,1663,1987732,5,18128
2021-09-23,NL,Netherlands,EURO,1894,1989626,4,18132
2021-09-24,NL,Netherlands,EURO,1810,1991436,12,18144
2021-09-25,NL,Netherlands,EURO,1693,1993129,3,18147
2021-09-26,NL,Netherlands,EURO,1600,1994729,2,18149
2021-09-27,NL,Netherlands,EURO,1599,1996328,1,18150
2021-09-28,NL,Netherlands,EURO,1386,1997714,4,18154
2021-09-29,NL,Netherlands,EURO,1717,1999431,8,18162
2021-09-30,NL,Netherlands,EURO,1751,2001182,6,18168
2021-10-01,NL,Netherlands,EURO,1701,2002883,2,18170
2021-10-02,NL,Netherlands,EURO,1717,2004600,6,18176
2021-10-03,NL,Netherlands,EURO,1669,2006269,5,18181
2021-10-04,NL,Netherlands,EURO,1602,2007871,1,18182
2021-10-05,NL,Netherlands,EURO,1610,2009481,2,18184
2021-10-06,NL,Netherlands,EURO,1899,2011380,7,18191
2021-10-07,NL,Netherlands,EURO,1904,2013284,3,18194
2021-10-08,NL,Netherlands,EURO,2733,2016017,6,18200
2021-10-09,NL,Netherlands,EURO,2769,2018786,2,18202
2021-10-10,NL,Netherlands,EURO,2483,2021269,2,18204
2021-10-11,NL,Netherlands,EURO,2735,2024004,0,18204
2021-10-12,NL,Netherlands,EURO,2249,2026253,5,18209
2021-10-13,NL,Netherlands,EURO,2883,2029136,6,18215
2021-10-14,NL,Netherlands,EURO,3718,2032854,12,18227
2021-10-15,NL,Netherlands,EURO,3635,2036489,4,18231
2021-10-16,NL,Netherlands,EURO,3695,2040184,6,18237
2021-10-17,NL,Netherlands,EURO,3691,2043875,5,18242
2021-10-18,NL,Netherlands,EURO,3659,2047534,6,18248
2021-10-19,NL,Netherlands,EURO,3348,2050882,1,18249
2021-10-20,NL,Netherlands,EURO,3914,2054796,13,18262
2021-10-21,NL,Netherlands,EURO,4582,2059378,9,18271
2021-10-22,NL,Netherlands,EURO,5177,2064555,7,18278
2021-10-23,NL,Netherlands,EURO,5836,2070391,10,18288
2021-10-24,NL,Netherlands,EURO,5671,2076062,25,18313
2021-10-25,NL,Netherlands,EURO,6302,2082364,1,18314
2021-10-26,NL,Netherlands,EURO,5298,2087662,6,18320
2021-10-27,NL,Netherlands,EURO,5754,2093416,19,18339
2021-10-28,NL,Netherlands,EURO,7262,2100678,17,18356
2021-10-29,NL,Netherlands,EURO,7666,2108344,15,18371
2021-10-30,NL,Netherlands,EURO,7387,2115731,13,18384
2021-10-31,NL,Netherlands,EURO,7941,2123672,13,18397
2021-11-01,NL,Netherlands,EURO,8151,2131823,14,18411
2021-11-02,NL,Netherlands,EURO,7690,2139513,11,18422
2021-11-03,NL,Netherlands,EURO,7692,2147205,18,18440
2021-11-04,NL,Netherlands,EURO,9146,2156351,33,18473
2021-11-05,NL,Netherlands,EURO,10204,2166555,24,18497
2021-11-06,NL,Netherlands,EURO,10874,2177429,20,18517
2021-11-07,NL,Netherlands,EURO,11970,2189399,36,18553
2021-11-08,NL,Netherlands,EURO,11340,2200739,8,18561
2021-11-09,NL,Netherlands,EURO,11757,2212496,22,18583
2021-11-10,NL,Netherlands,EURO,11284,2223780,28,18611
2021-11-11,NL,Netherlands,EURO,12645,2236425,25,18636
2021-11-12,NL,Netherlands,EURO,16249,2252674,25,18661
2021-11-13,NL,Netherlands,EURO,16051,2268725,31,18692
2021-11-14,NL,Netherlands,EURO,13801,2282526,32,18724
2021-11-15,NL,Netherlands,EURO,11976,2294502,7,18731
2021-11-16,NL,Netherlands,EURO,19192,2313694,16,18747
2021-11-17,NL,Netherlands,EURO,20143,2333837,35,18782
2021-11-18,NL,Netherlands,EURO,20704,2354541,44,18826
2021-11-19,NL,Netherlands,EURO,23563,2378104,34,18860
2021-11-20,NL,Netherlands,EURO,20973,2399077,39,18899
2021-11-21,NL,Netherlands,EURO,21758,2420835,55,18954
2021-11-22,NL,Netherlands,EURO,20632,2441467,11,18965
2021-11-23,NL,Netherlands,EURO,22986,2464453,29,18994
2021-11-24,NL,Netherlands,EURO,22949,2487402,53,19047
2021-11-25,NL,Netherlands,EURO,23700,2511102,50,19097
2021-11-26,NL,Netherlands,EURO,22174,2533276,61,19158
2021-11-27,NL,Netherlands,EURO,21264,2554540,59,19217
2021-11-28,NL,Netherlands,EURO,21989,2576529,54,19271
2021-11-29,NL,Netherlands,EURO,22067,2598596,43,19314
2021-11-30,NL,Netherlands,EURO,21454,2620050,33,19347
2021-12-01,NL,Netherlands,EURO,22058,2642108,65,19412
2021-12-02,NL,Netherlands,EURO,18497,2660605,43,19455
2021-12-03,NL,Netherlands,EURO,23031,2683636,65,19520
2021-12-04,NL,Netherlands,EURO,21480,2705116,62,19582
2021-12-05,NL,Netherlands,EURO,22600,2727716,56,19638
2021-12-06,NL,Netherlands,EURO,23051,2750767,26,19664
2021-12-07,NL,Netherlands,EURO,20977,2771744,34,19698
2021-12-08,NL,Netherlands,EURO,17942,2789686,68,19766
2021-12-09,NL,Netherlands,EURO,18055,2807741,71,19837
2021-12-10,NL,Netherlands,EURO,19731,2827472,78,19915
2021-12-11,NL,Netherlands,EURO,17445,2844917,84,19999
2021-12-12,NL,Netherlands,EURO,17746,2862663,69,20068
2021-12-13,NL,Netherlands,EURO,16604,2879267,39,20107
2021-12-14,NL,Netherlands,EURO,13790,2893057,28,20135
2021-12-15,NL,Netherlands,EURO,12796,2905853,74,20209
2021-12-16,NL,Netherlands,EURO,13496,2919349,41,20250
2021-12-17,NL,Netherlands,EURO,16348,2935697,54,20304
2021-12-18,NL,Netherlands,EURO,15338,2951035,59,20363
2021-12-19,NL,Netherlands,EURO,14661,2965696,50,20413
2021-12-20,NL,Netherlands,EURO,13256,2978952,48,20461
2021-12-21,NL,Netherlands,EURO,12141,2991093,35,20496
2021-12-22,NL,Netherlands,EURO,9392,3000485,31,20527
2021-12-23,NL,Netherlands,EURO,13397,3013882,48,20575
2021-12-24,NL,Netherlands,EURO,13315,3027197,40,20615
2021-12-25,NL,Netherlands,EURO,12468,3039665,40,20655
2021-12-26,NL,Netherlands,EURO,12555,3052220,45,20700
2021-12-27,NL,Netherlands,EURO,11893,3064113,11,20711
2021-12-28,NL,Netherlands,EURO,11428,3075541,12,20723
2021-12-29,NL,Netherlands,EURO,9134,3084675,75,20798
2021-12-30,NL,Netherlands,EURO,15696,3100371,50,20848
2021-12-31,NL,Netherlands,EURO,14759,3115130,40,20888
2022-01-01,NL,Netherlands,EURO,16681,3131811,33,20921
2022-01-02,NL,Netherlands,EURO,15583,3147394,27,20948
2022-01-03,NL,Netherlands,EURO,17426,3164820,6,20954
2022-01-04,NL,Netherlands,EURO,14494,3179314,14,20968
2022-01-05,NL,Netherlands,EURO,18507,3197821,19,20987
2022-01-06,NL,Netherlands,EURO,24439,3222260,38,21025
2022-01-07,NL,Netherlands,EURO,24526,3246786,12,21037
2022-01-08,NL,Netherlands,EURO,34727,3281513,24,21061
2022-01-09,NL,Netherlands,EURO,27787,3309300,8,21069
2022-01-10,NL,Netherlands,EURO,32337,3341637,7,21076
2022-01-11,NL,Netherlands,EURO,27740,3369377,7,21083
2022-01-12,NL,Netherlands,EURO,28853,3398230,18,21101
2022-01-13,NL,Netherlands,EURO,31908,3430138,8,21109
2022-01-14,NL,Netherlands,EURO,33152,3463290,13,21122
2022-01-15,NL,Netherlands,EURO,35196,3498486,16,21138
2022-01-16,NL,Netherlands,EURO,31628,3530114,6,21144
2022-01-17,NL,Netherlands,EURO,35775,3565889,6,21150
2022-01-18,NL,Netherlands,EURO,41773,3607662,3,21153
2022-01-19,NL,Netherlands,EURO,31021,3638683,10,21163
2022-01-20,NL,Netherlands,EURO,37985,3676668,10,21173
2022-01-21,NL,Netherlands,EURO,39724,3716392,10,21183
2022-01-22,NL,Netherlands,EURO,57192,3773584,11,21194
2022-01-23,NL,Netherlands,EURO,45762,3819346,8,21202
2022-01-24,NL,Netherlands,EURO,64657,3884003,1,21203
2022-01-25,NL,Netherlands,EURO,64090,3948093,8,21211
2022-01-26,NL,Netherlands,EURO,53485,4001578,7,21218
2022-01-27,NL,Netherlands,EURO,57884,4059462,11,21229
2022-01-28,NL,Netherlands,EURO,64013,4123475,14,21243
2022-01-29,NL,Netherlands,EURO,73146,4196621,8,21251
2022-01-30,NL,Netherlands,EURO,38915,4235536,8,21259
2022-01-31,NL,Netherlands,EURO,74506,4310042,2,21261
2022-02-01,NL,Netherlands,EURO,110827,4420869,5,21266
2022-02-02,NL,Netherlands,EURO,104651,4525520,15,21281
2022-02-03,NL,Netherlands,EURO,66103,4591623,10,21291
2022-02-04,NL,Netherlands,EURO,81702,4673325,10,21301
2022-02-05,NL,Netherlands,EURO,71322,4744647,5,21306
2022-02-06,NL,Netherlands,EURO,52970,4797617,10,21316
2022-02-07,NL,Netherlands,EURO,80007,4877624,7,21323
2022-02-08,NL,Netherlands,EURO,81623,4959247,4,21327
2022-02-09,NL,Netherlands,EURO,390870,5350117,8,21335
2022-02-10,NL,Netherlands,EURO,86536,5436653,7,21342
2022-02-11,NL,Netherlands,EURO,86748,5523401,15,21357
2022-02-12,NL,Netherlands,EURO,80651,5604052,19,21376
2022-02-13,NL,Netherlands,EURO,70338,5674390,12,21388
2022-02-14,NL,Netherlands,EURO,60106,5734496,7,21395
2022-02-15,NL,Netherlands,EURO,55061,5789557,6,21401
2022-02-16,NL,Netherlands,EURO,53511,5843068,12,21413
2022-02-17,NL,Netherlands,EURO,63761,5906829,18,21431
2022-02-18,NL,Netherlands,EURO,56373,5963202,18,21449
2022-02-19,NL,Netherlands,EURO,49276,6012478,16,21465
2022-02-20,NL,Netherlands,EURO,33629,6046107,10,21475
.
113589a
2022-02-19,NP,Nepal,SEARO,198,975330,4,11917
2022-02-20,NP,Nepal,SEARO,229,975559,4,11921
.
112811a
2022-02-19,NR,Nauru,WPRO,0,0,0,0
2022-02-20,NR,Nauru,WPRO,0,0,0,0
.
112033c
2022-02-18,NA,Namibia,AFRO,29,156872,1,3996
2022-02-19,NA,Namibia,AFRO,0,156872,0,3996
2022-02-20,NA,Namibia,AFRO,0,156872,0,3996
.
111255c
2022-02-18,MM,Myanmar,SEARO,3058,559314,3,19322
2022-02-19,MM,Myanmar,SEARO,3050,562364,5,19327
2022-02-20,MM,Myanmar,SEARO,3303,565667,4,19331
.
110477a
2022-02-19,MZ,Mozambique,AFRO,50,224841,0,2189
2022-02-20,MZ,Mozambique,AFRO,41,224882,0,2189
.
109699c
2022-02-18,MA,Morocco,EMRO,636,1157637,22,15855
2022-02-19,MA,Morocco,EMRO,508,1158145,15,15870
2022-02-20,MA,Morocco,EMRO,524,1158669,11,15881
.
108921a
2022-02-19,MS,Montserrat,AMRO,0,163,0,2
2022-02-20,MS,Montserrat,AMRO,0,163,0,2
.
108138,108143c
2022-02-13,ME,Montenegro,EURO,396,226162,8,2632
2022-02-14,ME,Montenegro,EURO,331,226493,2,2634
2022-02-15,ME,Montenegro,EURO,223,226716,1,2635
2022-02-16,ME,Montenegro,EURO,345,227061,3,2638
2022-02-17,ME,Montenegro,EURO,419,227480,3,2641
2022-02-18,ME,Montenegro,EURO,385,227865,3,2644
2022-02-19,ME,Montenegro,EURO,320,228185,2,2646
2022-02-20,ME,Montenegro,EURO,334,228519,4,2650
.
108064,108065c
2021-12-01,ME,Montenegro,EURO,282,157385,14,2307
2021-12-02,ME,Montenegro,EURO,243,157628,0,2307
.
107365c
2022-02-18,MN,Mongolia,WPRO,874,894595,0,2080
2022-02-19,MN,Mongolia,WPRO,3919,898514,5,2085
2022-02-20,MN,Mongolia,WPRO,488,899002,2,2087
.
106587a
2022-02-19,MC,Monaco,EURO,34,9162,1,51
2022-02-20,MC,Monaco,EURO,24,9186,0,51
.
105809a
2022-02-19,FM,Micronesia (Federated States of),WPRO,0,0,0,0
2022-02-20,FM,Micronesia (Federated States of),WPRO,0,0,0,0
.
105031a
2022-02-19,MX,Mexico,AMRO,21565,5366405,470,314598
2022-02-20,MX,Mexico,AMRO,21449,5387854,457,315055
.
104253c
2022-02-18,YT,Mayotte,AFRO,0,36572,0,187
2022-02-19,YT,Mayotte,AFRO,0,36572,0,187
2022-02-20,YT,Mayotte,AFRO,0,36572,0,187
.
103475a
2022-02-19,MU,Mauritius,AFRO,0,70862,0,786
2022-02-20,MU,Mauritius,AFRO,0,70862,0,786
.
102697c
2022-02-18,MR,Mauritania,AFRO,9,58593,2,975
2022-02-19,MR,Mauritania,AFRO,0,58593,0,975
2022-02-20,MR,Mauritania,AFRO,11,58604,1,976
.
101919a
2022-02-19,MQ,Martinique,AMRO,0,107144,0,859
2022-02-20,MQ,Martinique,AMRO,3590,110734,2,861
.
101141a
2022-02-19,MH,Marshall Islands,WPRO,0,4,0,0
2022-02-20,MH,Marshall Islands,WPRO,0,4,0,0
.
100363a
2022-02-19,MT,Malta,EURO,79,70513,0,594
2022-02-20,MT,Malta,EURO,72,70585,0,594
.
99585a
2022-02-19,ML,Mali,AFRO,30,30334,0,717
2022-02-20,ML,Mali,AFRO,5,30339,0,717
.
98807c
2022-02-18,MV,Maldives,SEARO,607,163581,0,290
2022-02-19,MV,Maldives,SEARO,648,164229,0,290
2022-02-20,MV,Maldives,SEARO,844,165073,1,291
.
98029a
2022-02-19,MY,Malaysia,WPRO,27808,3166023,24,32264
2022-02-20,MY,Malaysia,WPRO,28825,3194848,46,32310
.
97251c
2022-02-18,MW,Malawi,AFRO,28,85134,1,2600
2022-02-19,MW,Malawi,AFRO,45,85179,2,2602
2022-02-20,MW,Malawi,AFRO,26,85205,3,2605
.
96473a
2022-02-19,MG,Madagascar,AFRO,0,62844,0,1335
2022-02-20,MG,Madagascar,AFRO,589,63433,15,1350
.
95695a
2022-02-19,LU,Luxembourg,EURO,636,177372,1,983
2022-02-20,LU,Luxembourg,EURO,0,177372,0,983
.
94917a
2022-02-19,LT,Lithuania,EURO,8368,856361,17,8236
2022-02-20,LT,Lithuania,EURO,5688,862049,15,8251
.
94135,94139c
2022-02-14,LI,Liechtenstein,EURO,69,10766,2,73
2022-02-15,LI,Liechtenstein,EURO,118,10884,0,73
2022-02-16,LI,Liechtenstein,EURO,100,10984,0,73
2022-02-17,LI,Liechtenstein,EURO,82,11066,1,74
2022-02-18,LI,Liechtenstein,EURO,72,11138,0,74
2022-02-19,LI,Liechtenstein,EURO,0,11138,0,74
2022-02-20,LI,Liechtenstein,EURO,0,11138,0,74
.
93361a
2022-02-19,LY,Libya,EMRO,1208,482153,9,6178
2022-02-20,LY,Libya,EMRO,0,482153,0,6178
.
92583a
2022-02-19,LR,Liberia,AFRO,0,7360,0,290
2022-02-20,LR,Liberia,AFRO,0,7360,0,290
.
91805a
2022-02-19,LS,Lesotho,AFRO,0,32434,0,696
2022-02-20,LS,Lesotho,AFRO,0,32434,0,696
.
91027c
2022-02-18,LB,Lebanon,EMRO,5211,1035209,19,9909
2022-02-19,LB,Lebanon,EMRO,4090,1039299,20,9929
2022-02-20,LB,Lebanon,EMRO,3729,1043028,21,9950
.
90249a
2022-02-19,LV,Latvia,EURO,10285,567176,20,5093
2022-02-20,LV,Latvia,EURO,11992,579168,6,5099
.
89471a
2022-02-19,LA,Lao People's Democratic Republic,WPRO,251,140604,3,605
2022-02-20,LA,Lao People's Democratic Republic,WPRO,285,140889,3,608
.
88693a
2022-02-19,KG,Kyrgyzstan,EURO,32,200287,3,2942
2022-02-20,KG,Kyrgyzstan,EURO,35,200322,2,2944
.
87915c
2022-02-18,KW,Kuwait,EMRO,1501,609453,1,2525
2022-02-19,KW,Kuwait,EMRO,1348,610801,2,2527
2022-02-20,KW,Kuwait,EMRO,1019,611820,1,2528
.
87137a
2022-02-19,XK,Kosovo[1],EURO,236,224673,4,3080
2022-02-20,XK,Kosovo[1],EURO,249,224922,8,3088
.
86359a
2022-02-19,KI,Kiribati,WPRO,53,2810,0,9
2022-02-20,KI,Kiribati,WPRO,13,2823,0,9
.
85581c
2022-02-18,KE,Kenya,AFRO,69,322614,0,5633
2022-02-19,KE,Kenya,AFRO,26,322640,0,5633
2022-02-20,KE,Kenya,AFRO,29,322669,2,5635
.
84803a
2022-02-19,KZ,Kazakhstan,EURO,1066,1385444,6,18857
2022-02-20,KZ,Kazakhstan,EURO,886,1386330,9,18866
.
84025c
2022-02-18,JO,Jordan,EMRO,15107,1541379,23,13608
2022-02-19,JO,Jordan,EMRO,12379,1553758,21,13629
2022-02-20,JO,Jordan,EMRO,7064,1560822,28,13657
.
83247a
2022-02-19,JE,Jersey,EURO,205,35506,1,109
2022-02-20,JE,Jersey,EURO,0,35506,0,109
.
82469a
2022-02-19,JP,Japan,WPRO,92939,4334739,235,21433
2022-02-20,JP,Japan,WPRO,77153,4411892,203,21636
.
81691a
2022-02-19,JM,Jamaica,AMRO,59,127436,2,2771
2022-02-20,JM,Jamaica,AMRO,0,127436,0,2771
.
80913a
2022-02-19,IT,Italy,EURO,53700,12377098,314,152596
2022-02-20,IT,Italy,EURO,50675,12427773,252,152848
.
79752,80135c
2021-01-31,IL,Israel,EURO,2627,640568,38,4765
2021-02-01,IL,Israel,EURO,5239,645807,51,4816
2021-02-02,IL,Israel,EURO,8929,654736,46,4862
2021-02-03,IL,Israel,EURO,8023,662759,61,4923
2021-02-04,IL,Israel,EURO,7463,670222,57,4980
2021-02-05,IL,Israel,EURO,7262,677484,48,5028
2021-02-06,IL,Israel,EURO,6600,684084,34,5062
2021-02-07,IL,Israel,EURO,2660,686744,51,5113
2021-02-08,IL,Israel,EURO,4606,691350,44,5157
2021-02-09,IL,Israel,EURO,7856,699206,30,5187
2021-02-10,IL,Israel,EURO,6169,705375,42,5229
2021-02-11,IL,Israel,EURO,5676,711051,32,5261
2021-02-12,IL,Israel,EURO,5064,716115,30,5291
2021-02-13,IL,Israel,EURO,4674,720789,41,5332
2021-02-14,IL,Israel,EURO,1890,722679,29,5361
2021-02-15,IL,Israel,EURO,3489,726168,37,5398
2021-02-16,IL,Israel,EURO,5199,731367,16,5414
2021-02-17,IL,Israel,EURO,4583,735950,42,5456
2021-02-18,IL,Israel,EURO,4168,740118,27,5483
2021-02-19,IL,Israel,EURO,3338,743456,35,5518
2021-02-20,IL,Israel,EURO,3794,747250,22,5540
2021-02-21,IL,Israel,EURO,1255,748505,26,5566
2021-02-22,IL,Israel,EURO,3114,751619,25,5591
2021-02-23,IL,Israel,EURO,4812,756431,15,5606
2021-02-24,IL,Israel,EURO,4443,760874,35,5641
2021-02-25,IL,Israel,EURO,4376,765250,27,5668
2021-02-26,IL,Israel,EURO,3820,769070,23,5691
2021-02-27,IL,Israel,EURO,3819,772889,22,5713
2021-02-28,IL,Israel,EURO,1443,774332,30,5743
2021-03-01,IL,Israel,EURO,3030,777362,21,5764
2021-03-02,IL,Israel,EURO,4852,782214,18,5782
2021-03-03,IL,Israel,EURO,4392,786606,21,5803
2021-03-04,IL,Israel,EURO,4669,791275,17,5820
2021-03-05,IL,Israel,EURO,3659,794934,17,5837
2021-03-06,IL,Israel,EURO,3695,798629,18,5855
2021-03-07,IL,Israel,EURO,1843,800472,20,5875
2021-03-08,IL,Israel,EURO,2364,802836,16,5891
2021-03-09,IL,Israel,EURO,3796,806632,21,5912
2021-03-10,IL,Israel,EURO,3127,809759,15,5927
2021-03-11,IL,Israel,EURO,2843,812602,17,5944
2021-03-12,IL,Israel,EURO,2553,815155,18,5962
2021-03-13,IL,Israel,EURO,2414,817569,12,5974
2021-03-14,IL,Israel,EURO,787,818356,16,5990
2021-03-15,IL,Israel,EURO,1411,819767,26,6016
2021-03-16,IL,Israel,EURO,2130,821897,17,6033
2021-03-17,IL,Israel,EURO,1566,823463,16,6049
2021-03-18,IL,Israel,EURO,1541,825004,14,6063
2021-03-19,IL,Israel,EURO,1254,826258,9,6072
2021-03-20,IL,Israel,EURO,1086,827344,12,6084
2021-03-21,IL,Israel,EURO,351,827695,7,6091
2021-03-22,IL,Israel,EURO,681,828376,14,6105
2021-03-23,IL,Israel,EURO,987,829363,14,6119
2021-03-24,IL,Israel,EURO,694,830057,14,6133
2021-03-25,IL,Israel,EURO,479,830536,10,6143
2021-03-26,IL,Israel,EURO,894,831430,9,6152
2021-03-27,IL,Israel,EURO,541,831971,11,6163
2021-03-28,IL,Israel,EURO,239,832210,6,6169
2021-03-29,IL,Israel,EURO,132,832342,13,6182
2021-03-30,IL,Israel,EURO,383,832725,11,6193
2021-03-31,IL,Israel,EURO,452,833177,13,6206
2021-04-01,IL,Israel,EURO,499,833676,14,6220
2021-04-02,IL,Israel,EURO,334,834010,8,6228
2021-04-03,IL,Israel,EURO,419,834429,15,6243
2021-04-04,IL,Israel,EURO,124,834553,7,6250
2021-04-05,IL,Israel,EURO,197,834750,8,6258
2021-04-06,IL,Israel,EURO,383,835133,6,6264
2021-04-07,IL,Israel,EURO,307,835440,8,6272
2021-04-08,IL,Israel,EURO,274,835714,9,6281
2021-04-09,IL,Israel,EURO,212,835926,9,6290
2021-04-10,IL,Israel,EURO,226,836152,10,6300
2021-04-11,IL,Israel,EURO,86,836238,9,6309
2021-04-12,IL,Israel,EURO,141,836379,6,6315
2021-04-13,IL,Israel,EURO,224,836603,6,6321
2021-04-14,IL,Israel,EURO,198,836801,13,6334
2021-04-15,IL,Israel,EURO,195,836996,3,6337
2021-04-16,IL,Israel,EURO,95,837091,3,6340
2021-04-17,IL,Israel,EURO,110,837201,5,6345
2021-04-18,IL,Israel,EURO,88,837289,7,6352
2021-04-19,IL,Israel,EURO,193,837482,4,6356
2021-04-20,IL,Israel,EURO,144,837626,3,6359
2021-04-21,IL,Israel,EURO,173,837799,4,6363
2021-04-22,IL,Israel,EURO,119,837918,2,6365
2021-04-23,IL,Israel,EURO,156,838074,2,6367
2021-04-24,IL,Israel,EURO,112,838186,5,6372
2021-04-25,IL,Israel,EURO,36,838222,4,6376
2021-04-26,IL,Israel,EURO,82,838304,1,6377
2021-04-27,IL,Israel,EURO,103,838407,3,6380
2021-04-28,IL,Israel,EURO,115,838522,6,6386
2021-04-29,IL,Israel,EURO,106,838628,0,6386
2021-04-30,IL,Israel,EURO,98,838726,2,6388
2021-05-01,IL,Israel,EURO,79,838805,2,6390
2021-05-02,IL,Israel,EURO,15,838820,2,6392
2021-05-03,IL,Israel,EURO,57,838877,1,6393
2021-05-04,IL,Israel,EURO,86,838963,3,6396
2021-05-05,IL,Israel,EURO,65,839028,2,6398
2021-05-06,IL,Israel,EURO,73,839101,2,6400
2021-05-07,IL,Israel,EURO,54,839155,2,6402
2021-05-08,IL,Israel,EURO,34,839189,2,6404
2021-05-09,IL,Israel,EURO,16,839205,1,6405
2021-05-10,IL,Israel,EURO,33,839238,1,6406
2021-05-11,IL,Israel,EURO,67,839305,2,6408
2021-05-12,IL,Israel,EURO,40,839345,1,6409
2021-05-13,IL,Israel,EURO,29,839374,1,6410
2021-05-14,IL,Israel,EURO,34,839408,2,6412
2021-05-15,IL,Israel,EURO,27,839435,0,6412
2021-05-16,IL,Israel,EURO,20,839455,1,6413
2021-05-17,IL,Israel,EURO,36,839491,1,6414
2021-05-18,IL,Israel,EURO,15,839506,3,6417
2021-05-19,IL,Israel,EURO,23,839529,0,6417
2021-05-20,IL,Israel,EURO,56,839585,0,6417
2021-05-21,IL,Israel,EURO,35,839620,0,6417
2021-05-22,IL,Israel,EURO,22,839642,2,6419
2021-05-23,IL,Israel,EURO,12,839654,0,6419
2021-05-24,IL,Israel,EURO,28,839682,1,6420
2021-05-25,IL,Israel,EURO,30,839712,1,6421
2021-05-26,IL,Israel,EURO,23,839735,1,6422
2021-05-27,IL,Israel,EURO,16,839751,0,6422
2021-05-28,IL,Israel,EURO,16,839767,2,6424
2021-05-29,IL,Israel,EURO,18,839785,1,6425
2021-05-30,IL,Israel,EURO,13,839798,0,6425
2021-05-31,IL,Israel,EURO,4,839802,0,6425
2021-06-01,IL,Israel,EURO,14,839816,0,6425
2021-06-02,IL,Israel,EURO,35,839851,2,6427
2021-06-03,IL,Israel,EURO,13,839864,0,6427
2021-06-04,IL,Israel,EURO,11,839875,1,6428
2021-06-05,IL,Israel,EURO,31,839906,0,6428
2021-06-06,IL,Israel,EURO,6,839912,1,6429
2021-06-07,IL,Israel,EURO,5,839917,0,6429
2021-06-08,IL,Israel,EURO,7,839924,1,6430
2021-06-09,IL,Israel,EURO,30,839954,1,6431
2021-06-10,IL,Israel,EURO,9,839963,1,6432
2021-06-11,IL,Israel,EURO,18,839981,0,6432
2021-06-12,IL,Israel,EURO,18,839999,0,6432
2021-06-13,IL,Israel,EURO,5,840004,0,6432
2021-06-14,IL,Israel,EURO,3,840007,1,6433
2021-06-15,IL,Israel,EURO,26,840033,0,6433
2021-06-16,IL,Israel,EURO,27,840060,0,6433
2021-06-17,IL,Israel,EURO,14,840074,1,6434
2021-06-18,IL,Israel,EURO,29,840103,0,6434
2021-06-19,IL,Israel,EURO,35,840138,0,6434
2021-06-20,IL,Israel,EURO,47,840185,1,6435
2021-06-21,IL,Israel,EURO,52,840237,0,6435
2021-06-22,IL,Israel,EURO,125,840362,0,6435
2021-06-23,IL,Israel,EURO,113,840475,0,6435
2021-06-24,IL,Israel,EURO,152,840627,0,6435
2021-06-25,IL,Israel,EURO,245,840872,0,6435
2021-06-26,IL,Israel,EURO,238,841110,1,6436
2021-06-27,IL,Israel,EURO,122,841232,0,6436
2021-06-28,IL,Israel,EURO,145,841377,0,6436
2021-06-29,IL,Israel,EURO,289,841666,0,6436
2021-06-30,IL,Israel,EURO,303,841969,0,6436
2021-07-01,IL,Israel,EURO,342,842311,0,6436
2021-07-02,IL,Israel,EURO,299,842610,0,6436
2021-07-03,IL,Israel,EURO,368,842978,0,6436
2021-07-04,IL,Israel,EURO,189,843167,0,6436
2021-07-05,IL,Israel,EURO,350,843517,0,6436
2021-07-06,IL,Israel,EURO,504,844021,0,6436
2021-07-07,IL,Israel,EURO,544,844565,0,6436
2021-07-08,IL,Israel,EURO,527,845092,1,6437
2021-07-09,IL,Israel,EURO,473,845565,2,6439
2021-07-10,IL,Israel,EURO,544,846109,0,6439
2021-07-11,IL,Israel,EURO,261,846370,2,6441
2021-07-12,IL,Israel,EURO,443,846813,3,6444
2021-07-13,IL,Israel,EURO,765,847578,2,6446
2021-07-14,IL,Israel,EURO,750,848328,0,6446
2021-07-15,IL,Israel,EURO,774,849102,3,6449
2021-07-16,IL,Israel,EURO,877,849979,1,6450
2021-07-17,IL,Israel,EURO,1148,851127,1,6451
2021-07-18,IL,Israel,EURO,439,851566,2,6453
2021-07-19,IL,Israel,EURO,838,852404,3,6456
2021-07-20,IL,Israel,EURO,1400,853804,2,6458
2021-07-21,IL,Israel,EURO,1413,855217,2,6460
2021-07-22,IL,Israel,EURO,1371,856588,3,6463
2021-07-23,IL,Israel,EURO,1289,857877,1,6464
2021-07-24,IL,Israel,EURO,1442,859319,0,6464
2021-07-25,IL,Israel,EURO,973,860292,3,6467
2021-07-26,IL,Israel,EURO,1434,861726,4,6471
2021-07-27,IL,Israel,EURO,2135,863861,1,6472
2021-07-28,IL,Israel,EURO,2302,866163,1,6473
2021-07-29,IL,Israel,EURO,2199,868362,6,6479
2021-07-30,IL,Israel,EURO,2180,870542,6,6485
2021-07-31,IL,Israel,EURO,2464,873006,2,6487
2021-08-01,IL,Israel,EURO,2104,875110,5,6492
2021-08-02,IL,Israel,EURO,2126,877236,9,6501
2021-08-03,IL,Israel,EURO,3862,881098,9,6510
2021-08-04,IL,Israel,EURO,3312,884410,10,6520
2021-08-05,IL,Israel,EURO,3510,887920,5,6525
2021-08-06,IL,Israel,EURO,3887,891807,16,6541
2021-08-07,IL,Israel,EURO,3890,895697,14,6555
2021-08-08,IL,Israel,EURO,2936,898633,12,6567
2021-08-09,IL,Israel,EURO,3447,902080,19,6586
2021-08-10,IL,Israel,EURO,6382,908462,11,6597
2021-08-11,IL,Israel,EURO,5859,914321,17,6614
2021-08-12,IL,Israel,EURO,6027,920348,16,6630
2021-08-13,IL,Israel,EURO,6154,926502,19,6649
2021-08-14,IL,Israel,EURO,5975,932477,24,6673
2021-08-15,IL,Israel,EURO,4233,936710,18,6691
2021-08-16,IL,Israel,EURO,5199,941909,20,6711
2021-08-17,IL,Israel,EURO,8798,950707,28,6739
2021-08-18,IL,Israel,EURO,7993,958700,20,6759
2021-08-19,IL,Israel,EURO,8037,966737,22,6781
2021-08-20,IL,Israel,EURO,7842,974579,24,6805
2021-08-21,IL,Israel,EURO,7908,982487,24,6829
2021-08-22,IL,Israel,EURO,5416,987903,25,6854
2021-08-23,IL,Israel,EURO,6594,994497,33,6887
2021-08-24,IL,Israel,EURO,10115,1004612,20,6907
2021-08-25,IL,Israel,EURO,10087,1014699,31,6938
2021-08-26,IL,Israel,EURO,9245,1023944,28,6966
2021-08-27,IL,Israel,EURO,9124,1033068,32,6998
2021-08-28,IL,Israel,EURO,8700,1041768,25,7023
2021-08-29,IL,Israel,EURO,7279,1049047,23,7046
2021-08-30,IL,Israel,EURO,6792,1055839,29,7075
2021-08-31,IL,Israel,EURO,11158,1066997,26,7101
2021-09-01,IL,Israel,EURO,10447,1077444,31,7132
2021-09-02,IL,Israel,EURO,11302,1088746,31,7163
2021-09-03,IL,Israel,EURO,11346,1100092,31,7194
2021-09-04,IL,Israel,EURO,9912,1110004,34,7228
2021-09-05,IL,Israel,EURO,5067,1115071,26,7254
2021-09-06,IL,Israel,EURO,5868,1120939,26,7280
2021-09-07,IL,Israel,EURO,10871,1131810,23,7303
2021-09-08,IL,Israel,EURO,6866,1138676,27,7330
2021-09-09,IL,Israel,EURO,3320,1141996,29,7359
2021-09-10,IL,Israel,EURO,7961,1149957,22,7381
2021-09-11,IL,Israel,EURO,9901,1159858,17,7398
2021-09-12,IL,Israel,EURO,10292,1170150,27,7425
2021-09-13,IL,Israel,EURO,7808,1177958,22,7447
2021-09-14,IL,Israel,EURO,10955,1188913,20,7467
2021-09-15,IL,Israel,EURO,9859,1198772,29,7496
2021-09-16,IL,Israel,EURO,8865,1207637,20,7516
2021-09-17,IL,Israel,EURO,3286,1210923,21,7537
2021-09-18,IL,Israel,EURO,5024,1215947,17,7554
2021-09-19,IL,Israel,EURO,8617,1224564,17,7571
2021-09-20,IL,Israel,EURO,6554,1231118,28,7599
2021-09-21,IL,Israel,EURO,8828,1239946,15,7614
2021-09-22,IL,Israel,EURO,4828,1244774,17,7631
2021-09-23,IL,Israel,EURO,6026,1250800,19,7650
2021-09-24,IL,Israel,EURO,6453,1257253,19,7669
2021-09-25,IL,Israel,EURO,4990,1262243,21,7690
2021-09-26,IL,Israel,EURO,2653,1264896,24,7714
2021-09-27,IL,Israel,EURO,3874,1268770,14,7728
2021-09-28,IL,Israel,EURO,5246,1274016,17,7745
2021-09-29,IL,Israel,EURO,2441,1276457,21,7766
2021-09-30,IL,Israel,EURO,3636,1280093,23,7789
2021-10-01,IL,Israel,EURO,4398,1284491,14,7803
2021-10-02,IL,Israel,EURO,3622,1288113,22,7825
2021-10-03,IL,Israel,EURO,1739,1289852,18,7843
2021-10-04,IL,Israel,EURO,2700,1292552,23,7866
2021-10-05,IL,Israel,EURO,3278,1295830,11,7877
2021-10-06,IL,Israel,EURO,2556,1298386,15,7892
2021-10-07,IL,Israel,EURO,2428,1300814,15,7907
2021-10-08,IL,Israel,EURO,2120,1302934,17,7924
2021-10-09,IL,Israel,EURO,2024,1304958,6,7930
2021-10-10,IL,Israel,EURO,1040,1305998,14,7944
2021-10-11,IL,Israel,EURO,1490,1307488,14,7958
2021-10-12,IL,Israel,EURO,2343,1309831,13,7971
2021-10-13,IL,Israel,EURO,1816,1311647,10,7981
2021-10-14,IL,Israel,EURO,1772,1313419,11,7992
2021-10-15,IL,Israel,EURO,1345,1314764,14,8006
2021-10-16,IL,Israel,EURO,1575,1316339,10,8016
2021-10-17,IL,Israel,EURO,740,1317079,9,8025
2021-10-18,IL,Israel,EURO,1221,1318300,6,8031
2021-10-19,IL,Israel,EURO,1508,1319808,9,8040
2021-10-20,IL,Israel,EURO,1150,1320958,3,8043
2021-10-21,IL,Israel,EURO,1036,1321994,8,8051
2021-10-22,IL,Israel,EURO,993,1322987,7,8058
2021-10-23,IL,Israel,EURO,983,1323970,4,8062
2021-10-24,IL,Israel,EURO,332,1324302,8,8070
2021-10-25,IL,Israel,EURO,842,1325144,6,8076
2021-10-26,IL,Israel,EURO,930,1326074,11,8087
2021-10-27,IL,Israel,EURO,729,1326803,9,8096
2021-10-28,IL,Israel,EURO,648,1327451,5,8101
2021-10-29,IL,Israel,EURO,661,1328112,7,8108
2021-10-30,IL,Israel,EURO,617,1328729,6,8114
2021-10-31,IL,Israel,EURO,226,1328955,3,8117
2021-11-01,IL,Israel,EURO,528,1329483,2,8119
2021-11-02,IL,Israel,EURO,691,1330174,4,8123
2021-11-03,IL,Israel,EURO,667,1330841,3,8126
2021-11-04,IL,Israel,EURO,616,1331457,5,8131
2021-11-05,IL,Israel,EURO,519,1331976,6,8137
2021-11-06,IL,Israel,EURO,558,1332534,1,8138
2021-11-07,IL,Israel,EURO,199,1332733,1,8139
2021-11-08,IL,Israel,EURO,502,1333235,4,8143
2021-11-09,IL,Israel,EURO,566,1333801,3,8146
2021-11-10,IL,Israel,EURO,473,1334274,6,8152
2021-11-11,IL,Israel,EURO,498,1334772,5,8157
2021-11-12,IL,Israel,EURO,393,1335165,3,8160
2021-11-13,IL,Israel,EURO,448,1335613,2,8162
2021-11-14,IL,Israel,EURO,225,1335838,2,8164
2021-11-15,IL,Israel,EURO,397,1336235,0,8164
2021-11-16,IL,Israel,EURO,535,1336770,5,8169
2021-11-17,IL,Israel,EURO,558,1337328,4,8173
2021-11-18,IL,Israel,EURO,483,1337811,1,8174
2021-11-19,IL,Israel,EURO,469,1338280,3,8177
2021-11-20,IL,Israel,EURO,508,1338788,3,8180
2021-11-21,IL,Israel,EURO,237,1339025,6,8186
2021-11-22,IL,Israel,EURO,453,1339478,1,8187
2021-11-23,IL,Israel,EURO,715,1340193,2,8189
2021-11-24,IL,Israel,EURO,604,1340797,0,8189
2021-11-25,IL,Israel,EURO,543,1341340,3,8192
2021-11-26,IL,Israel,EURO,540,1341880,3,8195
2021-11-27,IL,Israel,EURO,540,1342420,2,8197
2021-11-28,IL,Israel,EURO,169,1342589,1,8198
2021-11-29,IL,Israel,EURO,542,1343131,3,8201
2021-11-30,IL,Israel,EURO,697,1343828,3,8204
2021-12-01,IL,Israel,EURO,577,1344405,3,8207
2021-12-02,IL,Israel,EURO,563,1344968,1,8208
2021-12-03,IL,Israel,EURO,519,1345487,2,8210
2021-12-04,IL,Israel,EURO,486,1345973,1,8211
2021-12-05,IL,Israel,EURO,248,1346221,2,8213
2021-12-06,IL,Israel,EURO,539,1346760,1,8214
2021-12-07,IL,Israel,EURO,739,1347499,2,8216
2021-12-08,IL,Israel,EURO,813,1348312,3,8219
2021-12-09,IL,Israel,EURO,714,1349026,6,8225
2021-12-10,IL,Israel,EURO,647,1349673,1,8226
2021-12-11,IL,Israel,EURO,607,1350280,2,8228
2021-12-12,IL,Israel,EURO,236,1350516,1,8229
2021-12-13,IL,Israel,EURO,492,1351008,2,8231
2021-12-14,IL,Israel,EURO,771,1351779,4,8235
2021-12-15,IL,Israel,EURO,702,1352481,1,8236
2021-12-16,IL,Israel,EURO,789,1353270,1,8237
2021-12-17,IL,Israel,EURO,862,1354132,1,8238
2021-12-18,IL,Israel,EURO,877,1355009,2,8240
2021-12-19,IL,Israel,EURO,393,1355402,2,8242
2021-12-20,IL,Israel,EURO,1021,1356423,2,8244
2021-12-21,IL,Israel,EURO,1330,1357753,2,8246
2021-12-22,IL,Israel,EURO,1200,1358953,0,8246
2021-12-23,IL,Israel,EURO,1417,1360370,0,8246
2021-12-24,IL,Israel,EURO,1514,1361884,1,8247
2021-12-25,IL,Israel,EURO,1789,1363673,1,8248
2021-12-26,IL,Israel,EURO,806,1364479,0,8248
2021-12-27,IL,Israel,EURO,1806,1366285,2,8250
2021-12-28,IL,Israel,EURO,2974,1369259,3,8253
2021-12-29,IL,Israel,EURO,3245,1372504,1,8254
2021-12-30,IL,Israel,EURO,4075,1376579,2,8256
2021-12-31,IL,Israel,EURO,5081,1381660,0,8256
2022-01-01,IL,Israel,EURO,5493,1387153,1,8257
2022-01-02,IL,Israel,EURO,4231,1391384,2,8259
2022-01-03,IL,Israel,EURO,6615,1397999,5,8264
2022-01-04,IL,Israel,EURO,10953,1408952,4,8268
2022-01-05,IL,Israel,EURO,12641,1421593,1,8269
2022-01-06,IL,Israel,EURO,18559,1440152,4,8273
2022-01-07,IL,Israel,EURO,19102,1459254,2,8275
2022-01-08,IL,Israel,EURO,21988,1481242,3,8278
2022-01-09,IL,Israel,EURO,22872,1504114,5,8283
2022-01-10,IL,Israel,EURO,31147,1535261,7,8290
2022-01-11,IL,Israel,EURO,41424,1576685,9,8299
2022-01-12,IL,Israel,EURO,46806,1623491,7,8306
2022-01-13,IL,Israel,EURO,48632,1672123,7,8313
2022-01-14,IL,Israel,EURO,49289,1721412,10,8323
2022-01-15,IL,Israel,EURO,45873,1767285,10,8333
2022-01-16,IL,Israel,EURO,45079,1812364,16,8349
2022-01-17,IL,Israel,EURO,64753,1877117,17,8366
2022-01-18,IL,Israel,EURO,72031,1949148,21,8387
2022-01-19,IL,Israel,EURO,73830,2022978,17,8404
2022-01-20,IL,Israel,EURO,75003,2097981,24,8428
2022-01-21,IL,Israel,EURO,75075,2173056,25,8453
2022-01-22,IL,Israel,EURO,65607,2238663,38,8491
2022-01-23,IL,Israel,EURO,67904,2306567,37,8528
2022-01-24,IL,Israel,EURO,85200,2391767,40,8568
2022-01-25,IL,Israel,EURO,83691,2475458,54,8622
2022-01-26,IL,Israel,EURO,76322,2551780,43,8665
2022-01-27,IL,Israel,EURO,67868,2619648,52,8717
2022-01-28,IL,Israel,EURO,57709,2677357,37,8754
2022-01-29,IL,Israel,EURO,53756,2731113,51,8805
2022-01-30,IL,Israel,EURO,49423,2780536,55,8860
2022-01-31,IL,Israel,EURO,74502,2855038,54,8914
2022-02-01,IL,Israel,EURO,67842,2922880,55,8969
2022-02-02,IL,Israel,EURO,60543,2983423,66,9035
2022-02-03,IL,Israel,EURO,60905,3044328,71,9106
2022-02-04,IL,Israel,EURO,46763,3091091,70,9176
2022-02-05,IL,Israel,EURO,38242,3129333,53,9229
2022-02-06,IL,Israel,EURO,33656,3162989,63,9292
2022-02-07,IL,Israel,EURO,52715,3215704,59,9351
2022-02-08,IL,Israel,EURO,44008,3259712,70,9421
2022-02-09,IL,Israel,EURO,38265,3297977,55,9476
2022-02-10,IL,Israel,EURO,37285,3335262,54,9530
2022-02-11,IL,Israel,EURO,27924,3363186,72,9602
2022-02-12,IL,Israel,EURO,22511,3385697,57,9659
2022-02-13,IL,Israel,EURO,18046,3403743,54,9713
2022-02-14,IL,Israel,EURO,31594,3435337,45,9758
2022-02-15,IL,Israel,EURO,23666,3459003,47,9805
2022-02-16,IL,Israel,EURO,20422,3479425,39,9844
2022-02-17,IL,Israel,EURO,21284,3500709,35,9879
2022-02-18,IL,Israel,EURO,15383,3516092,34,9913
2022-02-19,IL,Israel,EURO,12583,3528675,21,9934
2022-02-20,IL,Israel,EURO,10358,3539033,24,9958
.
79407,79746c
2020-02-21,IL,Israel,EURO,8,8,0,0
2020-02-22,IL,Israel,EURO,0,8,0,0
2020-02-23,IL,Israel,EURO,0,8,0,0
2020-02-24,IL,Israel,EURO,0,8,0,0
2020-02-25,IL,Israel,EURO,1,9,0,0
2020-02-26,IL,Israel,EURO,0,9,0,0
2020-02-27,IL,Israel,EURO,0,9,0,0
2020-02-28,IL,Israel,EURO,1,10,0,0
2020-02-29,IL,Israel,EURO,3,13,0,0
2020-03-01,IL,Israel,EURO,0,13,0,0
2020-03-02,IL,Israel,EURO,1,14,0,0
2020-03-03,IL,Israel,EURO,5,19,0,0
2020-03-04,IL,Israel,EURO,3,22,0,0
2020-03-05,IL,Israel,EURO,0,22,0,0
2020-03-06,IL,Israel,EURO,9,31,0,0
2020-03-07,IL,Israel,EURO,4,35,0,0
2020-03-08,IL,Israel,EURO,4,39,0,0
2020-03-09,IL,Israel,EURO,9,48,0,0
2020-03-10,IL,Israel,EURO,4,52,0,0
2020-03-11,IL,Israel,EURO,33,85,0,0
2020-03-12,IL,Israel,EURO,18,103,0,0
2020-03-13,IL,Israel,EURO,23,126,0,0
2020-03-14,IL,Israel,EURO,35,161,0,0
2020-03-15,IL,Israel,EURO,29,190,0,0
2020-03-16,IL,Israel,EURO,40,230,0,0
2020-03-17,IL,Israel,EURO,73,303,0,0
2020-03-18,IL,Israel,EURO,94,397,0,0
2020-03-19,IL,Israel,EURO,125,522,0,0
2020-03-20,IL,Israel,EURO,134,656,0,0
2020-03-21,IL,Israel,EURO,168,824,1,1
2020-03-22,IL,Israel,EURO,209,1033,0,1
2020-03-23,IL,Israel,EURO,252,1285,0,1
2020-03-24,IL,Israel,EURO,349,1634,0,1
2020-03-25,IL,Israel,EURO,420,2054,3,4
2020-03-26,IL,Israel,EURO,423,2477,1,5
2020-03-27,IL,Israel,EURO,520,2997,5,10
2020-03-28,IL,Israel,EURO,431,3428,2,12
2020-03-29,IL,Israel,EURO,476,3904,1,13
2020-03-30,IL,Israel,EURO,528,4432,3,16
2020-03-31,IL,Israel,EURO,549,4981,1,17
2020-04-01,IL,Israel,EURO,738,5719,4,21
2020-04-02,IL,Israel,EURO,693,6412,8,29
2020-04-03,IL,Israel,EURO,724,7136,9,38
2020-04-04,IL,Israel,EURO,600,7736,5,43
2020-04-05,IL,Israel,EURO,427,8163,6,49
2020-04-06,IL,Israel,EURO,584,8747,7,56
2020-04-07,IL,Israel,EURO,449,9196,8,64
2020-04-08,IL,Israel,EURO,376,9572,8,72
2020-04-09,IL,Israel,EURO,340,9912,8,80
2020-04-10,IL,Israel,EURO,340,10252,9,89
2020-04-11,IL,Israel,EURO,355,10607,8,97
2020-04-12,IL,Israel,EURO,342,10949,6,103
2020-04-13,IL,Israel,EURO,551,11500,6,109
2020-04-14,IL,Israel,EURO,437,11937,9,118
2020-04-15,IL,Israel,EURO,394,12331,8,126
2020-04-16,IL,Israel,EURO,305,12636,13,139
2020-04-17,IL,Israel,EURO,296,12932,7,146
2020-04-18,IL,Israel,EURO,297,13229,9,155
2020-04-19,IL,Israel,EURO,288,13517,11,166
2020-04-20,IL,Israel,EURO,274,13791,8,174
2020-04-21,IL,Israel,EURO,297,14088,6,180
2020-04-22,IL,Israel,EURO,279,14367,10,190
2020-04-23,IL,Israel,EURO,226,14593,3,193
2020-04-24,IL,Israel,EURO,274,14867,4,197
2020-04-25,IL,Israel,EURO,250,15117,3,200
2020-04-26,IL,Israel,EURO,159,15276,3,203
2020-04-27,IL,Israel,EURO,82,15358,2,205
2020-04-28,IL,Israel,EURO,127,15485,4,209
2020-04-29,IL,Israel,EURO,161,15646,5,214
2020-04-30,IL,Israel,EURO,82,15728,6,220
2020-05-01,IL,Israel,EURO,143,15871,6,226
2020-05-02,IL,Israel,EURO,116,15987,4,230
2020-05-03,IL,Israel,EURO,57,16044,3,233
2020-05-04,IL,Israel,EURO,26,16070,3,236
2020-05-05,IL,Israel,EURO,55,16125,3,239
2020-05-06,IL,Israel,EURO,33,16158,2,241
2020-05-07,IL,Israel,EURO,65,16223,1,242
2020-05-08,IL,Israel,EURO,61,16284,1,243
2020-05-09,IL,Israel,EURO,33,16317,6,249
2020-05-10,IL,Israel,EURO,20,16337,3,252
2020-05-11,IL,Israel,EURO,29,16366,4,256
2020-05-12,IL,Israel,EURO,39,16405,5,261
2020-05-13,IL,Israel,EURO,23,16428,3,264
2020-05-14,IL,Israel,EURO,39,16467,3,267
2020-05-15,IL,Israel,EURO,22,16489,3,270
2020-05-16,IL,Israel,EURO,12,16501,0,270
2020-05-17,IL,Israel,EURO,5,16506,3,273
2020-05-18,IL,Israel,EURO,15,16521,4,277
2020-05-19,IL,Israel,EURO,27,16548,3,280
2020-05-20,IL,Israel,EURO,22,16570,2,282
2020-05-21,IL,Israel,EURO,15,16585,1,283
2020-05-22,IL,Israel,EURO,18,16603,0,283
2020-05-23,IL,Israel,EURO,19,16622,0,283
2020-05-24,IL,Israel,EURO,5,16627,0,283
2020-05-25,IL,Israel,EURO,13,16640,1,284
2020-05-26,IL,Israel,EURO,22,16662,2,286
2020-05-27,IL,Israel,EURO,50,16712,0,286
2020-05-28,IL,Israel,EURO,40,16752,2,288
2020-05-29,IL,Israel,EURO,77,16829,1,289
2020-05-30,IL,Israel,EURO,113,16942,0,289
2020-05-31,IL,Israel,EURO,29,16971,0,289
2020-06-01,IL,Israel,EURO,87,17058,0,289
2020-06-02,IL,Israel,EURO,100,17158,3,292
2020-06-03,IL,Israel,EURO,122,17280,2,294
2020-06-04,IL,Israel,EURO,96,17376,1,295
2020-06-05,IL,Israel,EURO,142,17518,0,295
2020-06-06,IL,Israel,EURO,127,17645,1,296
2020-06-07,IL,Israel,EURO,78,17723,4,300
2020-06-08,IL,Israel,EURO,140,17863,2,302
2020-06-09,IL,Israel,EURO,179,18042,0,302
2020-06-10,IL,Israel,EURO,174,18216,1,303
2020-06-11,IL,Israel,EURO,241,18457,1,304
2020-06-12,IL,Israel,EURO,193,18650,0,304
2020-06-13,IL,Israel,EURO,184,18834,0,304
2020-06-14,IL,Israel,EURO,149,18983,1,305
2020-06-15,IL,Israel,EURO,137,19120,2,307
2020-06-16,IL,Israel,EURO,200,19320,0,307
2020-06-17,IL,Israel,EURO,298,19618,1,308
2020-06-18,IL,Israel,EURO,268,19886,0,308
2020-06-19,IL,Israel,EURO,303,20189,0,308
2020-06-20,IL,Israel,EURO,311,20500,1,309
2020-06-21,IL,Israel,EURO,161,20661,1,310
2020-06-22,IL,Israel,EURO,174,20835,0,310
2020-06-23,IL,Israel,EURO,344,21179,1,311
2020-06-24,IL,Israel,EURO,452,21631,2,313
2020-06-25,IL,Israel,EURO,485,22116,3,316
2020-06-26,IL,Israel,EURO,516,22632,4,320
2020-06-27,IL,Israel,EURO,464,23096,3,323
2020-06-28,IL,Israel,EURO,397,23493,3,326
2020-06-29,IL,Israel,EURO,383,23876,2,328
2020-06-30,IL,Israel,EURO,759,24635,0,328
2020-07-01,IL,Israel,EURO,789,25424,1,329
2020-07-02,IL,Israel,EURO,968,26392,3,332
2020-07-03,IL,Israel,EURO,1154,27546,1,333
2020-07-04,IL,Israel,EURO,941,28487,3,336
2020-07-05,IL,Israel,EURO,821,29308,5,341
2020-07-06,IL,Israel,EURO,825,30133,2,343
2020-07-07,IL,Israel,EURO,1128,31261,8,351
2020-07-08,IL,Israel,EURO,1384,32645,5,356
2020-07-09,IL,Israel,EURO,1330,33975,5,361
2020-07-10,IL,Israel,EURO,1522,35497,5,366
2020-07-11,IL,Israel,EURO,1405,36902,4,370
2020-07-12,IL,Israel,EURO,1168,38070,5,375
2020-07-13,IL,Israel,EURO,1236,39306,7,382
2020-07-14,IL,Israel,EURO,1717,41023,4,386
2020-07-15,IL,Israel,EURO,1601,42624,7,393
2020-07-16,IL,Israel,EURO,1873,44497,6,399
2020-07-17,IL,Israel,EURO,1936,46433,9,408
2020-07-18,IL,Israel,EURO,1601,48034,12,420
2020-07-19,IL,Israel,EURO,1444,49478,8,428
2020-07-20,IL,Israel,EURO,1016,50494,10,438
2020-07-21,IL,Israel,EURO,1886,52380,12,450
2020-07-22,IL,Israel,EURO,2004,54384,9,459
2020-07-23,IL,Israel,EURO,2041,56425,6,465
2020-07-24,IL,Israel,EURO,1987,58412,16,481
2020-07-25,IL,Israel,EURO,1824,60236,8,489
2020-07-26,IL,Israel,EURO,1110,61346,7,496
2020-07-27,IL,Israel,EURO,1040,62386,11,507
2020-07-28,IL,Israel,EURO,2048,64434,7,514
2020-07-29,IL,Israel,EURO,2120,66554,8,522
2020-07-30,IL,Israel,EURO,1957,68511,15,537
2020-07-31,IL,Israel,EURO,1786,70297,15,552
2020-08-01,IL,Israel,EURO,1359,71656,14,566
2020-08-02,IL,Israel,EURO,623,72279,14,580
2020-08-03,IL,Israel,EURO,708,72987,12,592
2020-08-04,IL,Israel,EURO,1799,74786,15,607
2020-08-05,IL,Israel,EURO,1726,76512,11,618
2020-08-06,IL,Israel,EURO,1686,78198,10,628
2020-08-07,IL,Israel,EURO,1675,79873,9,637
2020-08-08,IL,Israel,EURO,1761,81634,12,649
2020-08-09,IL,Israel,EURO,754,82388,13,662
2020-08-10,IL,Israel,EURO,922,83310,8,670
2020-08-11,IL,Israel,EURO,1697,85007,15,685
2020-08-12,IL,Israel,EURO,1823,86830,11,696
2020-08-13,IL,Israel,EURO,1617,88447,16,712
2020-08-14,IL,Israel,EURO,1640,90087,16,728
2020-08-15,IL,Israel,EURO,1389,91476,12,740
2020-08-16,IL,Israel,EURO,754,92230,10,750
2020-08-17,IL,Israel,EURO,1069,93299,20,770
2020-08-18,IL,Israel,EURO,1649,94948,4,774
2020-08-19,IL,Israel,EURO,1647,96595,14,788
2020-08-20,IL,Israel,EURO,1639,98234,12,800
2020-08-21,IL,Israel,EURO,1485,99719,14,814
2020-08-22,IL,Israel,EURO,1491,101210,13,827
2020-08-23,IL,Israel,EURO,710,101920,10,837
2020-08-24,IL,Israel,EURO,964,102884,13,850
2020-08-25,IL,Israel,EURO,1901,104785,16,866
2020-08-26,IL,Israel,EURO,1958,106743,19,885
2020-08-27,IL,Israel,EURO,1984,108727,11,896
2020-08-28,IL,Israel,EURO,2106,110833,11,907
2020-08-29,IL,Israel,EURO,1833,112666,13,920
2020-08-30,IL,Israel,EURO,908,113574,5,925
2020-08-31,IL,Israel,EURO,1100,114674,14,939
2020-09-01,IL,Israel,EURO,2171,116845,23,962
2020-09-02,IL,Israel,EURO,2255,119100,15,977
2020-09-03,IL,Israel,EURO,3194,122294,13,990
2020-09-04,IL,Israel,EURO,2666,124960,16,1006
2020-09-05,IL,Israel,EURO,2623,127583,12,1018
2020-09-06,IL,Israel,EURO,1504,129087,15,1033
2020-09-07,IL,Israel,EURO,2175,131262,12,1045
2020-09-08,IL,Israel,EURO,3386,134648,17,1062
2020-09-09,IL,Israel,EURO,3488,138136,20,1082
2020-09-10,IL,Israel,EURO,3991,142127,15,1097
2020-09-11,IL,Israel,EURO,4153,146280,14,1111
2020-09-12,IL,Israel,EURO,3973,150253,20,1131
2020-09-13,IL,Israel,EURO,2718,152971,15,1146
2020-09-14,IL,Israel,EURO,3172,156143,17,1163
2020-09-15,IL,Israel,EURO,4803,160946,20,1183
2020-09-16,IL,Israel,EURO,5528,166474,16,1199
2020-09-17,IL,Israel,EURO,4568,171042,26,1225
2020-09-18,IL,Israel,EURO,5378,176420,17,1242
2020-09-19,IL,Israel,EURO,5333,181753,21,1263
2020-09-20,IL,Israel,EURO,3809,185562,28,1291
2020-09-21,IL,Israel,EURO,2576,188138,21,1312
2020-09-22,IL,Israel,EURO,3870,192008,32,1344
2020-09-23,IL,Israel,EURO,7017,199025,25,1369
2020-09-24,IL,Israel,EURO,7142,206167,25,1394
2020-09-25,IL,Israel,EURO,8259,214426,31,1425
2020-09-26,IL,Israel,EURO,8388,222814,29,1454
2020-09-27,IL,Israel,EURO,5881,228695,27,1481
2020-09-28,IL,Israel,EURO,3436,232131,31,1512
2020-09-29,IL,Israel,EURO,1154,233285,29,1541
2020-09-30,IL,Israel,EURO,4988,238273,35,1576
2020-10-01,IL,Israel,EURO,9051,247324,37,1613
2020-10-02,IL,Israel,EURO,7720,255044,46,1659
2020-10-03,IL,Israel,EURO,7053,262097,25,1684
2020-10-04,IL,Israel,EURO,2593,264690,38,1722
2020-10-05,IL,Israel,EURO,2932,267622,37,1759
2020-10-06,IL,Israel,EURO,5702,273324,27,1786
2020-10-07,IL,Israel,EURO,4717,278041,45,1831
2020-10-08,IL,Israel,EURO,4153,282194,26,1857
2020-10-09,IL,Israel,EURO,3752,285946,47,1904
2020-10-10,IL,Israel,EURO,2954,288900,40,1944
2020-10-11,IL,Israel,EURO,916,289816,35,1979
2020-10-12,IL,Israel,EURO,1638,291454,45,2024
2020-10-13,IL,Israel,EURO,3154,294608,30,2054
2020-10-14,IL,Israel,EURO,2335,296943,37,2091
2020-10-15,IL,Israel,EURO,2118,299061,34,2125
2020-10-16,IL,Israel,EURO,1609,300670,32,2157
2020-10-17,IL,Israel,EURO,1496,302166,35,2192
2020-10-18,IL,Israel,EURO,410,302576,32,2224
2020-10-19,IL,Israel,EURO,923,303499,33,2257
2020-10-20,IL,Israel,EURO,1516,305015,31,2288
2020-10-21,IL,Israel,EURO,1192,306207,20,2308
2020-10-22,IL,Israel,EURO,1170,307377,25,2333
2020-10-23,IL,Israel,EURO,1031,308408,29,2362
2020-10-24,IL,Israel,EURO,849,309257,26,2388
2020-10-25,IL,Israel,EURO,247,309504,26,2414
2020-10-26,IL,Israel,EURO,604,310108,34,2448
2020-10-27,IL,Israel,EURO,883,310991,28,2476
2020-10-28,IL,Israel,EURO,885,311876,28,2504
2020-10-29,IL,Israel,EURO,724,312600,10,2514
2020-10-30,IL,Israel,EURO,647,313247,19,2533
2020-10-31,IL,Israel,EURO,681,313928,12,2545
2020-11-01,IL,Israel,EURO,228,314156,25,2570
2020-11-02,IL,Israel,EURO,657,314813,19,2589
2020-11-03,IL,Israel,EURO,792,315605,15,2604
2020-11-04,IL,Israel,EURO,844,316449,26,2630
2020-11-05,IL,Israel,EURO,769,317218,15,2645
2020-11-06,IL,Israel,EURO,568,317786,14,2659
2020-11-07,IL,Israel,EURO,689,318475,16,2675
2020-11-08,IL,Israel,EURO,212,318687,8,2683
2020-11-09,IL,Israel,EURO,535,319222,7,2690
2020-11-10,IL,Israel,EURO,723,319945,8,2698
2020-11-11,IL,Israel,EURO,673,320618,10,2708
2020-11-12,IL,Israel,EURO,768,321386,7,2715
2020-11-13,IL,Israel,EURO,837,322223,12,2727
2020-11-14,IL,Israel,EURO,761,322984,5,2732
2020-11-15,IL,Israel,EURO,292,323276,11,2743
2020-11-16,IL,Israel,EURO,627,323903,14,2757
2020-11-17,IL,Israel,EURO,874,324777,9,2766
2020-11-18,IL,Israel,EURO,830,325607,12,2778
2020-11-19,IL,Israel,EURO,797,326404,7,2785
2020-11-20,IL,Israel,EURO,771,327175,8,2793
2020-11-21,IL,Israel,EURO,772,327947,6,2799
2020-11-22,IL,Israel,EURO,423,328370,12,2811
2020-11-23,IL,Israel,EURO,763,329133,16,2827
2020-11-24,IL,Israel,EURO,961,330094,7,2834
2020-11-25,IL,Israel,EURO,859,330953,5,2839
2020-11-26,IL,Israel,EURO,1081,332034,5,2844
2020-11-27,IL,Israel,EURO,1085,333119,9,2853
2020-11-28,IL,Israel,EURO,1033,334152,7,2860
2020-11-29,IL,Israel,EURO,582,334734,9,2869
2020-11-30,IL,Israel,EURO,1026,335760,10,2879
2020-12-01,IL,Israel,EURO,1257,337017,6,2885
2020-12-02,IL,Israel,EURO,1200,338217,10,2895
2020-12-03,IL,Israel,EURO,1588,339805,5,2900
2020-12-04,IL,Israel,EURO,1448,341253,10,2910
2020-12-05,IL,Israel,EURO,1515,342768,9,2919
2020-12-06,IL,Israel,EURO,1000,343768,10,2929
2020-12-07,IL,Israel,EURO,1357,345125,8,2937
2020-12-08,IL,Israel,EURO,1863,346988,7,2944
2020-12-09,IL,Israel,EURO,1769,348757,12,2956
2020-12-10,IL,Israel,EURO,1869,350626,13,2969
2020-12-11,IL,Israel,EURO,2007,352633,13,2982
2020-12-12,IL,Israel,EURO,1835,354468,11,2993
2020-12-13,IL,Israel,EURO,1298,355766,16,3009
2020-12-14,IL,Israel,EURO,1727,357493,9,3018
2020-12-15,IL,Israel,EURO,2322,359815,11,3029
2020-12-16,IL,Israel,EURO,2893,362708,15,3044
2020-12-17,IL,Israel,EURO,2860,365568,15,3059
2020-12-18,IL,Israel,EURO,2847,368415,17,3076
2020-12-19,IL,Israel,EURO,2793,371208,16,3092
2020-12-20,IL,Israel,EURO,1889,373097,20,3112
2020-12-21,IL,Israel,EURO,3095,376192,18,3130
2020-12-22,IL,Israel,EURO,3860,380052,16,3146
2020-12-23,IL,Israel,EURO,4381,384433,13,3159
2020-12-24,IL,Israel,EURO,4039,388472,25,3184
2020-12-25,IL,Israel,EURO,4050,392522,15,3199
2020-12-26,IL,Israel,EURO,4006,396528,21,3220
2020-12-27,IL,Israel,EURO,2660,399188,23,3243
2020-12-28,IL,Israel,EURO,3534,402722,21,3264
2020-12-29,IL,Israel,EURO,5523,408245,32,3296
2020-12-30,IL,Israel,EURO,5631,413876,25,3321
2020-12-31,IL,Israel,EURO,5871,419747,16,3337
2021-01-01,IL,Israel,EURO,5866,425613,36,3373
2021-01-02,IL,Israel,EURO,6014,431627,34,3407
2021-01-03,IL,Israel,EURO,4212,435839,27,3434
2021-01-04,IL,Israel,EURO,5232,441071,26,3460
2021-01-05,IL,Israel,EURO,8424,449495,38,3498
2021-01-06,IL,Israel,EURO,8230,457725,23,3521
2021-01-07,IL,Israel,EURO,7884,465609,43,3564
2021-01-08,IL,Israel,EURO,7663,473272,48,3612
2021-01-09,IL,Israel,EURO,8162,481434,46,3658
2021-01-10,IL,Israel,EURO,5165,486599,20,3678
2021-01-11,IL,Israel,EURO,6954,493553,43,3721
2021-01-12,IL,Israel,EURO,9730,503283,28,3749
2021-01-13,IL,Israel,EURO,9296,512579,55,3804
2021-01-14,IL,Israel,EURO,9473,522052,57,3861
2021-01-15,IL,Israel,EURO,9300,531352,59,3920
2021-01-16,IL,Israel,EURO,8431,539783,52,3972
2021-01-17,IL,Israel,EURO,5086,544869,47,4019
2021-01-18,IL,Israel,EURO,5660,550529,56,4075
2021-01-19,IL,Israel,EURO,10123,560652,46,4121
2021-01-20,IL,Israel,EURO,8633,569285,43,4164
2021-01-21,IL,Israel,EURO,8361,577646,56,4220
2021-01-22,IL,Israel,EURO,7268,584914,47,4267
2021-01-23,IL,Israel,EURO,7387,592301,65,4332
2021-01-24,IL,Israel,EURO,2447,594748,52,4384
2021-01-25,IL,Israel,EURO,4936,599684,75,4459
.
79357a
2022-02-19,IM,Isle of Man,EURO,45,22267,0,79
2022-02-20,IM,Isle of Man,EURO,34,22301,0,79
.
78579a
2022-02-19,IE,Ireland,EURO,4795,1265124,15,6417
2022-02-20,IE,Ireland,EURO,0,1265124,0,6417
.
77801a
2022-02-19,IQ,Iraq,EMRO,2326,2288777,16,24840
2022-02-20,IQ,Iraq,EMRO,1234,2290011,11,24851
.
77023a
2022-02-19,IR,Iran (Islamic Republic of),EMRO,19317,6913427,187,134607
2022-02-20,IR,Iran (Islamic Republic of),EMRO,12058,6925485,191,134798
.
76245a
2022-02-19,ID,Indonesia,SEARO,59384,5149021,158,146202
2022-02-20,ID,Indonesia,SEARO,48484,5197505,163,146365
.
75467a
2022-02-19,IN,India,SEARO,22270,42802505,325,511230
2022-02-20,IN,India,SEARO,19968,42822473,673,511903
.
74683,74689c
2022-02-12,IS,Iceland,EURO,2078,87627,0,54
2022-02-13,IS,Iceland,EURO,2079,89706,1,55
2022-02-14,IS,Iceland,EURO,1954,91660,0,55
2022-02-15,IS,Iceland,EURO,1874,93534,1,56
2022-02-16,IS,Iceland,EURO,2601,96135,2,58
2022-02-17,IS,Iceland,EURO,2962,99097,0,58
2022-02-18,IS,Iceland,EURO,2417,101514,0,58
2022-02-19,IS,Iceland,EURO,2638,104152,0,58
2022-02-20,IS,Iceland,EURO,2847,106999,0,58
.
73911a
2022-02-19,HU,Hungary,EURO,0,1746424,0,43066
2022-02-20,HU,Hungary,EURO,0,1746424,0,43066
.
73133a
2022-02-19,HN,Honduras,AMRO,0,406872,0,10641
2022-02-20,HN,Honduras,AMRO,0,406872,0,10641
.
72355a
2022-02-19,VA,Holy See,EURO,0,26,0,0
2022-02-20,VA,Holy See,EURO,0,26,0,0
.
71577a
2022-02-19,HT,Haiti,AMRO,107,30162,5,814
2022-02-20,HT,Haiti,AMRO,0,30162,0,814
.
70799a
2022-02-19,GY,Guyana,AMRO,72,62537,1,1203
2022-02-20,GY,Guyana,AMRO,48,62585,5,1208
.
70021c
2022-02-18,GW,Guinea-Bissau,AFRO,2,7891,0,164
2022-02-19,GW,Guinea-Bissau,AFRO,14,7905,2,166
2022-02-20,GW,Guinea-Bissau,AFRO,2,7907,0,166
.
69243a
2022-02-19,GN,Guinea,AFRO,0,36329,0,436
2022-02-20,GN,Guinea,AFRO,25,36354,2,438
.
68465a
2022-02-19,GG,Guernsey,EURO,180,13150,0,31
2022-02-20,GG,Guernsey,EURO,0,13150,0,31
.
67687a
2022-02-19,GT,Guatemala,AMRO,4503,749257,30,16709
2022-02-20,GT,Guatemala,AMRO,4024,753281,35,16744
.
66909c
2022-02-18,GU,Guam,WPRO,699,35460,0,315
2022-02-19,GU,Guam,WPRO,334,35794,1,316
2022-02-20,GU,Guam,WPRO,0,35794,0,316
.
66131a
2022-02-19,GP,Guadeloupe,AMRO,4034,122211,20,909
2022-02-20,GP,Guadeloupe,AMRO,0,122211,0,909
.
65353a
2022-02-19,GD,Grenada,AMRO,39,13491,0,214
2022-02-20,GD,Grenada,AMRO,0,13491,0,214
.
64575a
2022-02-19,GL,Greenland,EURO,16,11581,1,12
2022-02-20,GL,Greenland,EURO,0,11581,0,12
.
63797a
2022-02-19,GR,Greece,EURO,18604,2274025,88,25183
2022-02-20,GR,Greece,EURO,15305,2289330,77,25260
.
63019a
2022-02-19,GI,Gibraltar,EURO,81,14873,0,101
2022-02-20,GI,Gibraltar,EURO,0,14873,0,101
.
62241c
2022-02-18,GH,Ghana,AFRO,61,158220,2,1433
2022-02-19,GH,Ghana,AFRO,0,158220,0,1433
2022-02-20,GH,Ghana,AFRO,0,158220,0,1433
.
61463a
2022-02-19,DE,Germany,EURO,189105,13445094,210,121202
2022-02-20,DE,Germany,EURO,118032,13563126,73,121275
.
60685a
2022-02-19,GE,Georgia,EURO,13288,1539493,51,15822
2022-02-20,GE,Georgia,EURO,9400,1548893,34,15856
.
59907a
2022-02-19,GM,Gambia,AFRO,0,11924,0,365
2022-02-20,GM,Gambia,AFRO,0,11924,0,365
.
59129a
2022-02-19,GA,Gabon,AFRO,38,47484,1,303
2022-02-20,GA,Gabon,AFRO,0,47484,0,303
.
58351a
2022-02-19,PF,French Polynesia,WPRO,1855,62571,0,637
2022-02-20,PF,French Polynesia,WPRO,0,62571,0,637
.
57573a
2022-02-19,GF,French Guiana,AMRO,0,77414,0,386
2022-02-20,GF,French Guiana,AMRO,40,77454,1,387
.
56795c
2022-02-18,FR,France,EURO,92318,21436504,286,133169
2022-02-19,FR,France,EURO,78410,21514914,284,133453
2022-02-20,FR,France,EURO,73008,21587922,145,133598
.
55688,56017c
2021-03-26,FI,Finland,EURO,607,75651,3,870
2021-03-27,FI,Finland,EURO,688,76339,3,873
2021-03-28,FI,Finland,EURO,352,76691,4,877
2021-03-29,FI,Finland,EURO,375,77066,1,878
2021-03-30,FI,Finland,EURO,655,77721,3,881
2021-03-31,FI,Finland,EURO,572,78293,2,883
2021-04-01,FI,Finland,EURO,551,78844,1,884
2021-04-02,FI,Finland,EURO,487,79331,2,886
2021-04-03,FI,Finland,EURO,361,79692,2,888
2021-04-04,FI,Finland,EURO,324,80016,3,891
2021-04-05,FI,Finland,EURO,322,80338,1,892
2021-04-06,FI,Finland,EURO,360,80698,0,892
2021-04-07,FI,Finland,EURO,545,81243,1,893
2021-04-08,FI,Finland,EURO,425,81668,4,897
2021-04-09,FI,Finland,EURO,407,82075,1,898
2021-04-10,FI,Finland,EURO,352,82427,2,900
2021-04-11,FI,Finland,EURO,227,82654,2,902
2021-04-12,FI,Finland,EURO,240,82894,0,902
2021-04-13,FI,Finland,EURO,405,83299,1,903
2021-04-14,FI,Finland,EURO,323,83622,4,907
2021-04-15,FI,Finland,EURO,343,83965,1,908
2021-04-16,FI,Finland,EURO,274,84239,2,910
2021-04-17,FI,Finland,EURO,265,84504,5,915
2021-04-18,FI,Finland,EURO,172,84676,2,917
2021-04-19,FI,Finland,EURO,157,84833,0,917
2021-04-20,FI,Finland,EURO,286,85119,3,920
2021-04-21,FI,Finland,EURO,286,85405,1,921
2021-04-22,FI,Finland,EURO,233,85638,2,923
2021-04-23,FI,Finland,EURO,257,85895,0,923
2021-04-24,FI,Finland,EURO,255,86150,1,924
2021-04-25,FI,Finland,EURO,154,86304,1,925
2021-04-26,FI,Finland,EURO,140,86444,0,925
2021-04-27,FI,Finland,EURO,242,86686,3,928
2021-04-28,FI,Finland,EURO,229,86915,2,930
2021-04-29,FI,Finland,EURO,275,87190,2,932
2021-04-30,FI,Finland,EURO,201,87391,1,933
2021-05-01,FI,Finland,EURO,197,87588,2,935
2021-05-02,FI,Finland,EURO,109,87697,0,935
2021-05-03,FI,Finland,EURO,135,87832,2,937
2021-05-04,FI,Finland,EURO,316,88148,0,937
2021-05-05,FI,Finland,EURO,206,88354,0,937
2021-05-06,FI,Finland,EURO,265,88619,1,938
2021-05-07,FI,Finland,EURO,239,88858,2,940
2021-05-08,FI,Finland,EURO,214,89072,1,941
2021-05-09,FI,Finland,EURO,134,89206,0,941
2021-05-10,FI,Finland,EURO,130,89336,0,941
2021-05-11,FI,Finland,EURO,257,89593,1,942
2021-05-12,FI,Finland,EURO,215,89808,1,943
2021-05-13,FI,Finland,EURO,256,90064,2,945
2021-05-14,FI,Finland,EURO,157,90221,2,947
2021-05-15,FI,Finland,EURO,249,90470,5,952
2021-05-16,FI,Finland,EURO,164,90634,6,958
2021-05-17,FI,Finland,EURO,134,90768,2,960
2021-05-18,FI,Finland,EURO,284,91052,0,960
2021-05-19,FI,Finland,EURO,217,91269,3,963
2021-05-20,FI,Finland,EURO,231,91500,6,969
2021-05-21,FI,Finland,EURO,217,91717,0,969
2021-05-22,FI,Finland,EURO,169,91886,0,969
2021-05-23,FI,Finland,EURO,108,91994,2,971
2021-05-24,FI,Finland,EURO,93,92087,2,973
2021-05-25,FI,Finland,EURO,188,92275,0,973
2021-05-26,FI,Finland,EURO,153,92428,0,973
2021-05-27,FI,Finland,EURO,143,92571,1,974
2021-05-28,FI,Finland,EURO,127,92698,0,974
2021-05-29,FI,Finland,EURO,135,92833,0,974
2021-05-30,FI,Finland,EURO,64,92897,0,974
2021-05-31,FI,Finland,EURO,78,92975,2,976
2021-06-01,FI,Finland,EURO,150,93125,0,976
2021-06-02,FI,Finland,EURO,122,93247,1,977
2021-06-03,FI,Finland,EURO,119,93366,0,977
2021-06-04,FI,Finland,EURO,111,93477,0,977
2021-06-05,FI,Finland,EURO,102,93579,1,978
2021-06-06,FI,Finland,EURO,64,93643,0,978
2021-06-07,FI,Finland,EURO,60,93703,0,978
2021-06-08,FI,Finland,EURO,139,93842,1,979
2021-06-09,FI,Finland,EURO,101,93943,1,980
2021-06-10,FI,Finland,EURO,81,94024,0,980
2021-06-11,FI,Finland,EURO,73,94097,1,981
2021-06-12,FI,Finland,EURO,70,94167,0,981
2021-06-13,FI,Finland,EURO,47,94214,0,981
2021-06-14,FI,Finland,EURO,48,94262,0,981
2021-06-15,FI,Finland,EURO,93,94355,0,981
2021-06-16,FI,Finland,EURO,78,94433,2,983
2021-06-17,FI,Finland,EURO,64,94497,0,983
2021-06-18,FI,Finland,EURO,91,94588,0,983
2021-06-19,FI,Finland,EURO,81,94669,0,983
2021-06-20,FI,Finland,EURO,57,94726,0,983
2021-06-21,FI,Finland,EURO,80,94806,0,983
2021-06-22,FI,Finland,EURO,112,94918,1,984
2021-06-23,FI,Finland,EURO,109,95027,0,984
2021-06-24,FI,Finland,EURO,143,95170,1,985
2021-06-25,FI,Finland,EURO,162,95332,0,985
2021-06-26,FI,Finland,EURO,195,95527,0,985
2021-06-27,FI,Finland,EURO,131,95658,0,985
2021-06-28,FI,Finland,EURO,119,95777,0,985
2021-06-29,FI,Finland,EURO,230,96007,0,985
2021-06-30,FI,Finland,EURO,261,96268,0,985
2021-07-01,FI,Finland,EURO,196,96464,0,985
2021-07-02,FI,Finland,EURO,203,96667,0,985
2021-07-03,FI,Finland,EURO,167,96834,0,985
2021-07-04,FI,Finland,EURO,132,96966,0,985
2021-07-05,FI,Finland,EURO,108,97074,0,985
2021-07-06,FI,Finland,EURO,243,97317,1,986
2021-07-07,FI,Finland,EURO,261,97578,1,987
2021-07-08,FI,Finland,EURO,292,97870,0,987
2021-07-09,FI,Finland,EURO,284,98154,0,987
2021-07-10,FI,Finland,EURO,308,98462,0,987
2021-07-11,FI,Finland,EURO,149,98611,0,987
2021-07-12,FI,Finland,EURO,160,98771,2,989
2021-07-13,FI,Finland,EURO,330,99101,2,991
2021-07-14,FI,Finland,EURO,342,99443,1,992
2021-07-15,FI,Finland,EURO,381,99824,0,992
2021-07-16,FI,Finland,EURO,381,100205,0,992
2021-07-17,FI,Finland,EURO,355,100560,0,992
2021-07-18,FI,Finland,EURO,206,100766,0,992
2021-07-19,FI,Finland,EURO,249,101015,0,992
2021-07-20,FI,Finland,EURO,420,101435,0,992
2021-07-21,FI,Finland,EURO,423,101858,0,992
2021-07-22,FI,Finland,EURO,468,102326,2,994
2021-07-23,FI,Finland,EURO,487,102813,0,994
2021-07-24,FI,Finland,EURO,478,103291,2,996
2021-07-25,FI,Finland,EURO,301,103592,1,997
2021-07-26,FI,Finland,EURO,351,103943,1,998
2021-07-27,FI,Finland,EURO,771,104714,2,1000
2021-07-28,FI,Finland,EURO,726,105440,1,1001
2021-07-29,FI,Finland,EURO,810,106250,1,1002
2021-07-30,FI,Finland,EURO,772,107022,4,1006
2021-07-31,FI,Finland,EURO,696,107718,0,1006
2021-08-01,FI,Finland,EURO,408,108126,1,1007
2021-08-02,FI,Finland,EURO,477,108603,0,1007
2021-08-03,FI,Finland,EURO,893,109496,3,1010
2021-08-04,FI,Finland,EURO,840,110336,3,1013
2021-08-05,FI,Finland,EURO,784,111120,4,1017
2021-08-06,FI,Finland,EURO,875,111995,1,1018
2021-08-07,FI,Finland,EURO,685,112680,2,1020
2021-08-08,FI,Finland,EURO,485,113165,4,1024
2021-08-09,FI,Finland,EURO,537,113702,0,1024
2021-08-10,FI,Finland,EURO,1037,114739,1,1025
2021-08-11,FI,Finland,EURO,826,115565,1,1026
2021-08-12,FI,Finland,EURO,923,116488,1,1027
2021-08-13,FI,Finland,EURO,789,117277,1,1028
2021-08-14,FI,Finland,EURO,740,118017,2,1030
2021-08-15,FI,Finland,EURO,426,118443,0,1030
2021-08-16,FI,Finland,EURO,445,118888,2,1032
2021-08-17,FI,Finland,EURO,768,119656,0,1032
2021-08-18,FI,Finland,EURO,741,120397,1,1033
2021-08-19,FI,Finland,EURO,708,121105,3,1036
2021-08-20,FI,Finland,EURO,670,121775,2,1038
2021-08-21,FI,Finland,EURO,655,122430,1,1039
2021-08-22,FI,Finland,EURO,397,122827,0,1039
2021-08-23,FI,Finland,EURO,457,123284,2,1041
2021-08-24,FI,Finland,EURO,682,123966,1,1042
2021-08-25,FI,Finland,EURO,608,124574,3,1045
2021-08-26,FI,Finland,EURO,699,125273,2,1047
2021-08-27,FI,Finland,EURO,610,125883,2,1049
2021-08-28,FI,Finland,EURO,704,126587,2,1051
2021-08-29,FI,Finland,EURO,439,127026,0,1051
2021-08-30,FI,Finland,EURO,464,127490,1,1052
2021-08-31,FI,Finland,EURO,744,128234,6,1058
2021-09-01,FI,Finland,EURO,651,128885,2,1060
2021-09-02,FI,Finland,EURO,648,129533,1,1061
2021-09-03,FI,Finland,EURO,649,130182,2,1063
2021-09-04,FI,Finland,EURO,520,130702,1,1064
2021-09-05,FI,Finland,EURO,336,131038,0,1064
2021-09-06,FI,Finland,EURO,346,131384,0,1064
2021-09-07,FI,Finland,EURO,580,131964,6,1070
2021-09-08,FI,Finland,EURO,521,132485,3,1073
2021-09-09,FI,Finland,EURO,482,132967,1,1074
2021-09-10,FI,Finland,EURO,461,133428,2,1076
2021-09-11,FI,Finland,EURO,496,133924,0,1076
2021-09-12,FI,Finland,EURO,331,134255,1,1077
2021-09-13,FI,Finland,EURO,283,134538,5,1082
2021-09-14,FI,Finland,EURO,534,135072,1,1083
2021-09-15,FI,Finland,EURO,480,135552,2,1085
2021-09-16,FI,Finland,EURO,454,136006,1,1086
2021-09-17,FI,Finland,EURO,437,136443,1,1087
2021-09-18,FI,Finland,EURO,389,136832,1,1088
2021-09-19,FI,Finland,EURO,240,137072,0,1088
2021-09-20,FI,Finland,EURO,285,137357,5,1093
2021-09-21,FI,Finland,EURO,489,137846,1,1094
2021-09-22,FI,Finland,EURO,489,138335,1,1095
2021-09-23,FI,Finland,EURO,483,138818,2,1097
2021-09-24,FI,Finland,EURO,481,139299,4,1101
2021-09-25,FI,Finland,EURO,425,139724,3,1104
2021-09-26,FI,Finland,EURO,299,140023,1,1105
2021-09-27,FI,Finland,EURO,355,140378,3,1108
2021-09-28,FI,Finland,EURO,684,141062,3,1111
2021-09-29,FI,Finland,EURO,645,141707,4,1115
2021-09-30,FI,Finland,EURO,669,142376,4,1119
2021-10-01,FI,Finland,EURO,619,142995,3,1122
2021-10-02,FI,Finland,EURO,532,143527,5,1127
2021-10-03,FI,Finland,EURO,356,143883,3,1130
2021-10-04,FI,Finland,EURO,383,144266,5,1135
2021-10-05,FI,Finland,EURO,746,145012,4,1139
2021-10-06,FI,Finland,EURO,727,145739,7,1146
2021-10-07,FI,Finland,EURO,747,146486,2,1148
2021-10-08,FI,Finland,EURO,610,147096,3,1151
2021-10-09,FI,Finland,EURO,596,147692,8,1159
2021-10-10,FI,Finland,EURO,425,148117,5,1164
2021-10-11,FI,Finland,EURO,399,148516,3,1167
2021-10-12,FI,Finland,EURO,691,149207,5,1172
2021-10-13,FI,Finland,EURO,610,149817,3,1175
2021-10-14,FI,Finland,EURO,639,150456,3,1178
2021-10-15,FI,Finland,EURO,559,151015,4,1182
2021-10-16,FI,Finland,EURO,563,151578,2,1184
2021-10-17,FI,Finland,EURO,345,151923,1,1185
2021-10-18,FI,Finland,EURO,319,152242,4,1189
2021-10-19,FI,Finland,EURO,661,152903,6,1195
2021-10-20,FI,Finland,EURO,550,153453,1,1196
2021-10-21,FI,Finland,EURO,516,153969,2,1198
2021-10-22,FI,Finland,EURO,623,154592,2,1200
2021-10-23,FI,Finland,EURO,581,155173,8,1208
2021-10-24,FI,Finland,EURO,376,155549,4,1212
2021-10-25,FI,Finland,EURO,392,155941,2,1214
2021-10-26,FI,Finland,EURO,799,156740,13,1227
2021-10-27,FI,Finland,EURO,679,157419,4,1231
2021-10-28,FI,Finland,EURO,640,158059,5,1236
2021-10-29,FI,Finland,EURO,593,158652,5,1241
2021-10-30,FI,Finland,EURO,655,159307,2,1243
2021-10-31,FI,Finland,EURO,405,159712,3,1246
2021-11-01,FI,Finland,EURO,439,160151,5,1251
2021-11-02,FI,Finland,EURO,973,161124,12,1263
2021-11-03,FI,Finland,EURO,754,161878,3,1266
2021-11-04,FI,Finland,EURO,771,162649,7,1273
2021-11-05,FI,Finland,EURO,802,163451,9,1282
2021-11-06,FI,Finland,EURO,842,164293,11,1293
2021-11-07,FI,Finland,EURO,514,164807,9,1302
2021-11-08,FI,Finland,EURO,506,165313,4,1306
2021-11-09,FI,Finland,EURO,1123,166436,12,1318
2021-11-10,FI,Finland,EURO,836,167272,9,1327
2021-11-11,FI,Finland,EURO,971,168243,4,1331
2021-11-12,FI,Finland,EURO,934,169177,6,1337
2021-11-13,FI,Finland,EURO,946,170123,5,1342
2021-11-14,FI,Finland,EURO,618,170741,3,1345
2021-11-15,FI,Finland,EURO,570,171311,6,1351
2021-11-16,FI,Finland,EURO,1253,172564,17,1368
2021-11-17,FI,Finland,EURO,1200,173764,9,1377
2021-11-18,FI,Finland,EURO,1172,174936,5,1382
2021-11-19,FI,Finland,EURO,1214,176150,4,1386
2021-11-20,FI,Finland,EURO,1275,177425,6,1392
2021-11-21,FI,Finland,EURO,709,178134,8,1400
2021-11-22,FI,Finland,EURO,674,178808,5,1405
2021-11-23,FI,Finland,EURO,1423,180231,10,1415
2021-11-24,FI,Finland,EURO,1336,181567,10,1425
2021-11-25,FI,Finland,EURO,1257,182824,10,1435
2021-11-26,FI,Finland,EURO,1277,184101,11,1446
2021-11-27,FI,Finland,EURO,1301,185402,8,1454
2021-11-28,FI,Finland,EURO,793,186195,8,1462
2021-11-29,FI,Finland,EURO,791,186986,3,1465
2021-11-30,FI,Finland,EURO,1701,188687,15,1480
2021-12-01,FI,Finland,EURO,1427,190114,7,1487
2021-12-02,FI,Finland,EURO,1443,191557,12,1499
2021-12-03,FI,Finland,EURO,1468,193025,5,1504
2021-12-04,FI,Finland,EURO,1531,194556,6,1510
2021-12-05,FI,Finland,EURO,970,195526,7,1517
2021-12-06,FI,Finland,EURO,1003,196529,5,1522
2021-12-07,FI,Finland,EURO,1078,197607,3,1525
2021-12-08,FI,Finland,EURO,1924,199531,7,1532
2021-12-09,FI,Finland,EURO,1734,201265,9,1541
2021-12-10,FI,Finland,EURO,1712,202977,7,1548
2021-12-11,FI,Finland,EURO,1802,204779,6,1554
2021-12-12,FI,Finland,EURO,1124,205903,7,1561
2021-12-13,FI,Finland,EURO,1270,207173,5,1566
2021-12-14,FI,Finland,EURO,2357,209530,7,1573
2021-12-15,FI,Finland,EURO,1833,211363,6,1579
2021-12-16,FI,Finland,EURO,2101,213464,8,1587
2021-12-17,FI,Finland,EURO,1989,215453,8,1595
2021-12-18,FI,Finland,EURO,2174,217627,8,1603
2021-12-19,FI,Finland,EURO,1614,219241,2,1605
2021-12-20,FI,Finland,EURO,1753,220994,5,1610
2021-12-21,FI,Finland,EURO,3041,224035,8,1618
2021-12-22,FI,Finland,EURO,3170,227205,7,1625
2021-12-23,FI,Finland,EURO,3538,230743,8,1633
2021-12-24,FI,Finland,EURO,3901,234644,10,1643
2021-12-25,FI,Finland,EURO,2273,236917,6,1649
2021-12-26,FI,Finland,EURO,2676,239593,5,1654
2021-12-27,FI,Finland,EURO,3307,242900,9,1663
2021-12-28,FI,Finland,EURO,6661,249561,17,1680
2021-12-29,FI,Finland,EURO,6872,256433,12,1692
2021-12-30,FI,Finland,EURO,7392,263825,14,1706
2021-12-31,FI,Finland,EURO,7327,271152,20,1726
2022-01-01,FI,Finland,EURO,6872,278024,20,1746
2022-01-02,FI,Finland,EURO,3990,282014,11,1757
2022-01-03,FI,Finland,EURO,4969,286983,13,1770
2022-01-04,FI,Finland,EURO,9491,296474,17,1787
2022-01-05,FI,Finland,EURO,9947,306421,23,1810
2022-01-06,FI,Finland,EURO,9748,316169,20,1830
2022-01-07,FI,Finland,EURO,7400,323569,15,1845
2022-01-08,FI,Finland,EURO,9559,333128,19,1864
2022-01-09,FI,Finland,EURO,5983,339111,20,1884
2022-01-10,FI,Finland,EURO,6845,345956,14,1898
2022-01-11,FI,Finland,EURO,11084,357040,25,1923
2022-01-12,FI,Finland,EURO,9725,366765,14,1937
2022-01-13,FI,Finland,EURO,9441,376206,19,1956
2022-01-14,FI,Finland,EURO,8673,384879,20,1976
2022-01-15,FI,Finland,EURO,8672,393551,19,1995
2022-01-16,FI,Finland,EURO,5868,399419,19,2014
2022-01-17,FI,Finland,EURO,6460,405879,18,2032
2022-01-18,FI,Finland,EURO,10929,416808,25,2057
2022-01-19,FI,Finland,EURO,9671,426479,14,2071
2022-01-20,FI,Finland,EURO,9104,435583,14,2085
2022-01-21,FI,Finland,EURO,8702,444285,15,2100
2022-01-22,FI,Finland,EURO,7901,452186,12,2112
2022-01-23,FI,Finland,EURO,4643,456829,12,2124
2022-01-24,FI,Finland,EURO,5127,461956,9,2133
2022-01-25,FI,Finland,EURO,9435,471391,23,2156
2022-01-26,FI,Finland,EURO,7925,479316,9,2165
2022-01-27,FI,Finland,EURO,6509,485825,17,2182
2022-01-28,FI,Finland,EURO,6552,492377,14,2196
2022-01-29,FI,Finland,EURO,6068,498445,16,2212
2022-01-30,FI,Finland,EURO,3977,502422,9,2221
2022-01-31,FI,Finland,EURO,4199,506621,5,2226
2022-02-01,FI,Finland,EURO,8254,514875,22,2248
2022-02-02,FI,Finland,EURO,6976,521851,10,2258
2022-02-03,FI,Finland,EURO,6618,528469,14,2272
2022-02-04,FI,Finland,EURO,6066,534535,14,2286
2022-02-05,FI,Finland,EURO,5708,540243,8,2294
2022-02-06,FI,Finland,EURO,3422,543665,10,2304
2022-02-07,FI,Finland,EURO,4167,547832,5,2309
2022-02-08,FI,Finland,EURO,8626,556458,6,2315
2022-02-09,FI,Finland,EURO,7287,563745,0,2315
2022-02-10,FI,Finland,EURO,6410,570155,6,2321
2022-02-11,FI,Finland,EURO,5839,575994,1,2322
2022-02-12,FI,Finland,EURO,5269,581263,3,2325
2022-02-13,FI,Finland,EURO,3316,584579,2,2327
2022-02-14,FI,Finland,EURO,3783,588362,0,2327
2022-02-15,FI,Finland,EURO,7354,595716,1,2328
2022-02-16,FI,Finland,EURO,6255,601971,0,2328
2022-02-17,FI,Finland,EURO,6103,608074,0,2328
2022-02-18,FI,Finland,EURO,5532,613606,1,2329
2022-02-19,FI,Finland,EURO,5026,618632,0,2329
2022-02-20,FI,Finland,EURO,2267,620899,0,2329
.
55239c
2022-02-18,FJ,Fiji,WPRO,57,63600,0,823
2022-02-19,FJ,Fiji,WPRO,24,63624,1,824
2022-02-20,FJ,Fiji,WPRO,0,63624,0,824
.
54461a
2022-02-19,FO,Faroe Islands,EURO,356,31448,0,24
2022-02-20,FO,Faroe Islands,EURO,426,31874,0,24
.
53683a
2022-02-19,FK,Falkland Islands (Malvinas),AMRO,0,105,0,0
2022-02-20,FK,Falkland Islands (Malvinas),AMRO,0,105,0,0
.
52905c
2022-02-18,ET,Ethiopia,AFRO,115,467975,1,7430
2022-02-19,ET,Ethiopia,AFRO,259,468234,5,7435
2022-02-20,ET,Ethiopia,AFRO,50,468284,3,7438
.
52127c
2022-02-18,SZ,Eswatini,AFRO,25,68925,0,1386
2022-02-19,SZ,Eswatini,AFRO,32,68957,0,1386
2022-02-20,SZ,Eswatini,AFRO,15,68972,2,1388
.
51349a
2022-02-19,EE,Estonia,EURO,6970,455636,0,2152
2022-02-20,EE,Estonia,EURO,4111,459747,10,2162
.
50571c
2022-02-18,ER,Eritrea,AFRO,1,9681,0,103
2022-02-19,ER,Eritrea,AFRO,2,9683,0,103
2022-02-20,ER,Eritrea,AFRO,4,9687,0,103
.
49793a
2022-02-19,GQ,Equatorial Guinea,AFRO,1,15870,0,182
2022-02-20,GQ,Equatorial Guinea,AFRO,0,15870,0,182
.
49015a
2022-02-19,SV,El Salvador,AMRO,0,147786,5,4032
2022-02-20,SV,El Salvador,AMRO,0,147786,0,4032
.
48237c
2022-02-18,EG,Egypt,EMRO,2071,463370,61,23580
2022-02-19,EG,Egypt,EMRO,2053,465423,52,23632
2022-02-20,EG,Egypt,EMRO,2025,467448,62,23694
.
47459a
2022-02-19,EC,Ecuador,AMRO,4577,808925,38,35105
2022-02-20,EC,Ecuador,AMRO,0,808925,0,35105
.
46681a
2022-02-19,DO,Dominican Republic,AMRO,311,571200,0,4354
2022-02-20,DO,Dominican Republic,AMRO,0,571200,0,4354
.
45903a
2022-02-19,DM,Dominica,AMRO,0,10752,0,57
2022-02-20,DM,Dominica,AMRO,0,10752,0,57
.
45125c
2022-02-18,DJ,Djibouti,EMRO,2,15537,0,189
2022-02-19,DJ,Djibouti,EMRO,0,15537,0,189
2022-02-20,DJ,Djibouti,EMRO,4,15541,0,189
.
44347a
2022-02-19,DK,Denmark,EURO,35658,2519057,43,4250
2022-02-20,DK,Denmark,EURO,33304,2552361,28,4278
.
43569c
2022-02-18,CD,Democratic Republic of the Congo,AFRO,6,85840,19,1335
2022-02-19,CD,Democratic Republic of the Congo,AFRO,36,85876,0,1335
2022-02-20,CD,Democratic Republic of the Congo,AFRO,0,85876,0,1335
.
42791a
2022-02-19,KP,Democratic People's Republic of Korea,SEARO,0,0,0,0
2022-02-20,KP,Democratic People's Republic of Korea,SEARO,0,0,0,0
.
42013a
2022-02-19,CZ,Czechia,EURO,13888,3497820,82,38188
2022-02-20,CZ,Czechia,EURO,8256,3506076,38,38226
.
41235c
2022-02-18,CY,Cyprus,EURO,2122,300357,16,814
2022-02-19,CY,Cyprus,EURO,2304,302661,5,819
2022-02-20,CY,Cyprus,EURO,1764,304425,4,823
.
40457a
2022-02-19,CW,Curaçao,AMRO,78,38608,0,260
2022-02-20,CW,Curaçao,AMRO,0,38608,0,260
.
39679a
2022-02-19,CU,Cuba,AMRO,647,1064128,2,8484
2022-02-20,CU,Cuba,AMRO,629,1064757,2,8486
.
38901a
2022-02-19,HR,Croatia,EURO,3599,1035632,50,14729
2022-02-20,HR,Croatia,EURO,3525,1039157,44,14773
.
38123a
2022-02-19,CI,Côte d’Ivoire,AFRO,69,81322,0,791
2022-02-20,CI,Côte d’Ivoire,AFRO,24,81346,0,791
.
37345a
2022-02-19,CR,Costa Rica,AMRO,4005,779323,27,7874
2022-02-20,CR,Costa Rica,AMRO,4114,783437,20,7894
.
36567a
2022-02-19,CK,Cook Islands,WPRO,1,4,0,0
2022-02-20,CK,Cook Islands,WPRO,0,4,0,0
.
35789a
2022-02-19,CG,Congo,AFRO,20,23894,1,376
2022-02-20,CG,Congo,AFRO,0,23894,0,376
.
35011c
2022-02-18,KM,Comoros,AFRO,2,8012,0,160
2022-02-19,KM,Comoros,AFRO,0,8012,0,160
2022-02-20,KM,Comoros,AFRO,4,8016,0,160
.
34233a
2022-02-19,CO,Colombia,AMRO,4013,6035143,147,137733
2022-02-20,CO,Colombia,AMRO,4020,6039163,136,137869
.
33455a
2022-02-19,CN,China,WPRO,3833,168155,21,5747
2022-02-20,CN,China,WPRO,6331,174486,17,5764
.
32677a
2022-02-19,CL,Chile,AMRO,35906,2783458,131,41067
2022-02-20,CL,Chile,AMRO,35788,2819246,129,41196
.
31899a
2022-02-19,TD,Chad,AFRO,0,7216,0,190
2022-02-20,TD,Chad,AFRO,0,7216,0,190
.
31121a
2022-02-19,CF,Central African Republic,AFRO,0,14187,0,113
2022-02-20,CF,Central African Republic,AFRO,0,14187,0,113
.
30343a
2022-02-19,KY,Cayman Islands,AMRO,0,18728,0,17
2022-02-20,KY,Cayman Islands,AMRO,0,18728,0,17
.
29565a
2022-02-19,CA,Canada,AMRO,10105,3227289,136,35923
2022-02-20,CA,Canada,AMRO,0,3227289,0,35923
.
28787c
2022-02-18,CM,Cameroon,AFRO,258,118933,3,1918
2022-02-19,CM,Cameroon,AFRO,0,118933,0,1918
2022-02-20,CM,Cameroon,AFRO,0,118933,0,1918
.
28009a
2022-02-19,KH,Cambodia,WPRO,414,125201,0,3015
2022-02-20,KH,Cambodia,WPRO,552,125753,0,3015
.
27231a
2022-02-19,CV,Cabo Verde,AFRO,2,55858,0,400
2022-02-20,CV,Cabo Verde,AFRO,2,55860,0,400
.
26453c
2022-02-18,BI,Burundi,AFRO,16,37963,0,15
2022-02-19,BI,Burundi,AFRO,21,37984,0,15
2022-02-20,BI,Burundi,AFRO,0,37984,0,15
.
25675c
2022-02-18,BF,Burkina Faso,AFRO,14,20743,0,375
2022-02-19,BF,Burkina Faso,AFRO,1,20744,0,375
2022-02-20,BF,Burkina Faso,AFRO,1,20745,0,375
.
24897a
2022-02-19,BG,Bulgaria,EURO,4616,1063808,89,34973
2022-02-20,BG,Bulgaria,EURO,2605,1066413,25,34998
.
24119a
2022-02-19,BN,Brunei Darussalam,WPRO,2988,30587,0,60
2022-02-20,BN,Brunei Darussalam,WPRO,1926,32513,0,60
.
23341a
2022-02-19,VG,British Virgin Islands,AMRO,0,6050,0,62
2022-02-20,VG,British Virgin Islands,AMRO,0,6050,0,62
.
22563a
2022-02-19,BR,Brazil,AMRO,131049,27937835,1128,641902
2022-02-20,BR,Brazil,AMRO,121027,28058862,1127,643029
.
21785c
2022-02-18,BW,Botswana,AFRO,1422,261913,5,2608
2022-02-19,BW,Botswana,AFRO,0,261913,0,2608
2022-02-20,BW,Botswana,AFRO,0,261913,0,2608
.
21007a
2022-02-19,BA,Bosnia and Herzegovina,EURO,616,367641,31,15263
2022-02-20,BA,Bosnia and Herzegovina,EURO,663,368304,6,15269
.
20229a
2022-02-19,XA,Bonaire,AMRO,13,6852,0,28
2022-02-20,XA,Bonaire,AMRO,0,6852,0,28
.
19451a
2022-02-19,BO,Bolivia (Plurinational State of),AMRO,1086,888175,16,21358
2022-02-20,BO,Bolivia (Plurinational State of),AMRO,1336,889511,14,21372
.
18673a
2022-02-19,BT,Bhutan,SEARO,347,9557,0,5
2022-02-20,BT,Bhutan,SEARO,521,10078,1,6
.
17895a
2022-02-19,BM,Bermuda,AMRO,25,11316,0,122
2022-02-20,BM,Bermuda,AMRO,0,11316,0,122
.
17117a
2022-02-19,BJ,Benin,AFRO,0,26567,0,163
2022-02-20,BJ,Benin,AFRO,0,26567,0,163
.
16339a
2022-02-19,BZ,Belize,AMRO,172,55975,0,633
2022-02-20,BZ,Belize,AMRO,104,56079,8,641
.
15420,15561c
2021-09-30,BE,Belgium,EURO,2167,1237915,7,25755
2021-10-01,BE,Belgium,EURO,2163,1240078,11,25766
2021-10-02,BE,Belgium,EURO,2149,1242227,6,25772
2021-10-03,BE,Belgium,EURO,1147,1243374,8,25780
2021-10-04,BE,Belgium,EURO,678,1244052,8,25788
2021-10-05,BE,Belgium,EURO,2791,1246843,5,25793
2021-10-06,BE,Belgium,EURO,2290,1249133,14,25807
2021-10-07,BE,Belgium,EURO,2545,1251678,13,25820
2021-10-08,BE,Belgium,EURO,2516,1254194,11,25831
2021-10-09,BE,Belgium,EURO,2543,1256737,7,25838
2021-10-10,BE,Belgium,EURO,1424,1258161,11,25849
2021-10-11,BE,Belgium,EURO,820,1258981,4,25853
2021-10-12,BE,Belgium,EURO,3924,1262905,18,25871
2021-10-13,BE,Belgium,EURO,3435,1266340,13,25884
2021-10-14,BE,Belgium,EURO,3595,1269935,8,25892
2021-10-15,BE,Belgium,EURO,3890,1273825,10,25902
2021-10-16,BE,Belgium,EURO,4168,1277993,18,25920
2021-10-17,BE,Belgium,EURO,2376,1280369,14,25934
2021-10-18,BE,Belgium,EURO,1490,1281859,10,25944
2021-10-19,BE,Belgium,EURO,6570,1288429,19,25963
2021-10-20,BE,Belgium,EURO,6296,1294725,13,25976
2021-10-21,BE,Belgium,EURO,6552,1301277,14,25990
2021-10-22,BE,Belgium,EURO,6905,1308182,10,26000
2021-10-23,BE,Belgium,EURO,7147,1315329,18,26018
2021-10-24,BE,Belgium,EURO,4090,1319419,20,26038
2021-10-25,BE,Belgium,EURO,2450,1321869,16,26054
2021-10-26,BE,Belgium,EURO,9703,1331572,18,26072
2021-10-27,BE,Belgium,EURO,9401,1340973,27,26099
2021-10-28,BE,Belgium,EURO,9224,1350197,33,26132
2021-10-29,BE,Belgium,EURO,9195,1359392,18,26150
2021-10-30,BE,Belgium,EURO,9289,1368681,21,26171
2021-10-31,BE,Belgium,EURO,4971,1373652,16,26187
2021-11-01,BE,Belgium,EURO,3058,1376710,18,26205
2021-11-02,BE,Belgium,EURO,3582,1380292,25,26230
2021-11-03,BE,Belgium,EURO,11714,1392006,20,26250
2021-11-04,BE,Belgium,EURO,10706,1402712,17,26267
2021-11-05,BE,Belgium,EURO,10181,1412893,26,26293
2021-11-06,BE,Belgium,EURO,11139,1424032,25,26318
2021-11-07,BE,Belgium,EURO,6453,1430485,30,26348
2021-11-08,BE,Belgium,EURO,4073,1434558,15,26363
2021-11-09,BE,Belgium,EURO,15267,1449825,28,26391
2021-11-10,BE,Belgium,EURO,13017,1462842,27,26418
2021-11-11,BE,Belgium,EURO,12750,1475592,26,26444
2021-11-12,BE,Belgium,EURO,5054,1480646,32,26476
2021-11-13,BE,Belgium,EURO,13751,1494397,39,26515
2021-11-14,BE,Belgium,EURO,8361,1502758,20,26535
2021-11-15,BE,Belgium,EURO,5506,1508264,27,26562
2021-11-16,BE,Belgium,EURO,20837,1529101,46,26608
2021-11-17,BE,Belgium,EURO,18431,1547532,29,26637
2021-11-18,BE,Belgium,EURO,18148,1565680,42,26679
2021-11-19,BE,Belgium,EURO,18572,1584252,43,26722
2021-11-20,BE,Belgium,EURO,19150,1603402,33,26755
2021-11-21,BE,Belgium,EURO,11215,1614617,36,26791
2021-11-22,BE,Belgium,EURO,6754,1621371,36,26827
2021-11-23,BE,Belgium,EURO,25624,1646995,35,26862
2021-11-24,BE,Belgium,EURO,21138,1668133,38,26900
2021-11-25,BE,Belgium,EURO,20173,1688306,49,26949
2021-11-26,BE,Belgium,EURO,20229,1708535,44,26993
2021-11-27,BE,Belgium,EURO,20044,1728579,40,27033
2021-11-28,BE,Belgium,EURO,11588,1740167,48,27081
2021-11-29,BE,Belgium,EURO,7072,1747239,47,27128
2021-11-30,BE,Belgium,EURO,25204,1772443,45,27173
2021-12-01,BE,Belgium,EURO,20869,1793312,61,27234
2021-12-02,BE,Belgium,EURO,19669,1812981,43,27277
2021-12-03,BE,Belgium,EURO,18329,1831310,53,27330
2021-12-04,BE,Belgium,EURO,17768,1849078,48,27378
2021-12-05,BE,Belgium,EURO,9635,1858713,45,27423
2021-12-06,BE,Belgium,EURO,5976,1864689,57,27480
2021-12-07,BE,Belgium,EURO,20737,1885426,39,27519
2021-12-08,BE,Belgium,EURO,15682,1901108,49,27568
2021-12-09,BE,Belgium,EURO,15079,1916187,55,27623
2021-12-10,BE,Belgium,EURO,13436,1929623,35,27658
2021-12-11,BE,Belgium,EURO,13103,1942726,48,27706
2021-12-12,BE,Belgium,EURO,7112,1949838,45,27751
2021-12-13,BE,Belgium,EURO,3908,1953746,44,27795
2021-12-14,BE,Belgium,EURO,13885,1967631,43,27838
2021-12-15,BE,Belgium,EURO,10582,1978213,37,27875
2021-12-16,BE,Belgium,EURO,9281,1987494,41,27916
2021-12-17,BE,Belgium,EURO,8110,1995604,37,27953
2021-12-18,BE,Belgium,EURO,7743,2003347,26,27979
2021-12-19,BE,Belgium,EURO,4753,2008100,36,28015
2021-12-20,BE,Belgium,EURO,2850,2010950,38,28053
2021-12-21,BE,Belgium,EURO,9111,2020061,36,28089
2021-12-22,BE,Belgium,EURO,7372,2027433,36,28125
2021-12-23,BE,Belgium,EURO,7388,2034821,37,28162
2021-12-24,BE,Belgium,EURO,7524,2042345,36,28198
2021-12-25,BE,Belgium,EURO,6518,2048863,35,28233
2021-12-26,BE,Belgium,EURO,2817,2051680,20,28253
2021-12-27,BE,Belgium,EURO,4566,2056246,22,28275
2021-12-28,BE,Belgium,EURO,13296,2069542,28,28303
2021-12-29,BE,Belgium,EURO,12818,2082360,21,28324
2021-12-30,BE,Belgium,EURO,15043,2097403,34,28358
2021-12-31,BE,Belgium,EURO,16059,2113462,29,28387
2022-01-01,BE,Belgium,EURO,12288,2125750,16,28403
2022-01-02,BE,Belgium,EURO,4069,2129819,22,28425
2022-01-03,BE,Belgium,EURO,9085,2138904,15,28440
2022-01-04,BE,Belgium,EURO,27579,2166483,25,28465
2022-01-05,BE,Belgium,EURO,28116,2194599,17,28482
2022-01-06,BE,Belgium,EURO,26043,2220642,14,28496
2022-01-07,BE,Belgium,EURO,23632,2244274,19,28515
2022-01-08,BE,Belgium,EURO,23798,2268072,19,28534
2022-01-09,BE,Belgium,EURO,15343,2283415,17,28551
2022-01-10,BE,Belgium,EURO,11224,2294639,23,28574
2022-01-11,BE,Belgium,EURO,37751,2332390,25,28599
2022-01-12,BE,Belgium,EURO,31692,2364082,24,28623
2022-01-13,BE,Belgium,EURO,31143,2395225,23,28646
2022-01-14,BE,Belgium,EURO,30101,2425326,21,28667
2022-01-15,BE,Belgium,EURO,31829,2457155,17,28684
2022-01-16,BE,Belgium,EURO,21172,2478327,14,28698
2022-01-17,BE,Belgium,EURO,14991,2493318,20,28718
2022-01-18,BE,Belgium,EURO,62665,2555983,32,28750
2022-01-19,BE,Belgium,EURO,60707,2616690,28,28778
2022-01-20,BE,Belgium,EURO,60889,2677579,38,28816
2022-01-21,BE,Belgium,EURO,57262,2734841,17,28833
2022-01-22,BE,Belgium,EURO,56432,2791273,23,28856
2022-01-23,BE,Belgium,EURO,32779,2824052,26,28882
2022-01-24,BE,Belgium,EURO,20745,2844797,17,28899
2022-01-25,BE,Belgium,EURO,75948,2920745,26,28925
2022-01-26,BE,Belgium,EURO,62487,2983232,37,28962
2022-01-27,BE,Belgium,EURO,54737,3037969,32,28994
2022-01-28,BE,Belgium,EURO,47499,3085468,29,29023
2022-01-29,BE,Belgium,EURO,41413,3126881,45,29068
2022-01-30,BE,Belgium,EURO,23219,3150100,27,29095
2022-01-31,BE,Belgium,EURO,13204,3163304,37,29132
2022-02-01,BE,Belgium,EURO,50012,3213316,29,29161
2022-02-02,BE,Belgium,EURO,36721,3250037,40,29201
2022-02-03,BE,Belgium,EURO,30839,3280876,49,29250
2022-02-04,BE,Belgium,EURO,25852,3306728,45,29295
2022-02-05,BE,Belgium,EURO,22373,3329101,61,29356
2022-02-06,BE,Belgium,EURO,12464,3341565,36,29392
2022-02-07,BE,Belgium,EURO,7282,3348847,40,29432
2022-02-08,BE,Belgium,EURO,27403,3376250,36,29468
2022-02-09,BE,Belgium,EURO,19385,3395635,47,29515
2022-02-10,BE,Belgium,EURO,16765,3412400,55,29570
2022-02-11,BE,Belgium,EURO,14192,3426592,67,29637
2022-02-12,BE,Belgium,EURO,12169,3438761,45,29682
2022-02-13,BE,Belgium,EURO,6737,3445498,39,29721
2022-02-14,BE,Belgium,EURO,4843,3450341,38,29759
2022-02-15,BE,Belgium,EURO,16467,3466808,49,29808
2022-02-16,BE,Belgium,EURO,11520,3478328,41,29849
2022-02-17,BE,Belgium,EURO,10549,3488877,28,29877
2022-02-18,BE,Belgium,EURO,5331,3494208,33,29910
2022-02-19,BE,Belgium,EURO,15,3494223,10,29920
2022-02-20,BE,Belgium,EURO,0,3494223,0,29920
.
15348,15349c
2021-07-20,BE,Belgium,EURO,2134,1101985,0,25368
2021-07-21,BE,Belgium,EURO,1954,1103939,0,25368
.
14783a
2022-02-19,BY,Belarus,EURO,8194,868078,16,6329
2022-02-20,BY,Belarus,EURO,7856,875934,19,6348
.
14005a
2022-02-19,BB,Barbados,AMRO,272,52909,2,307
2022-02-20,BB,Barbados,AMRO,344,53253,0,307
.
13227a
2022-02-19,BD,Bangladesh,SEARO,2150,1931304,13,28944
2022-02-20,BD,Bangladesh,SEARO,1987,1933291,21,28965
.
12449c
2022-02-18,BH,Bahrain,EMRO,3762,481512,1,1433
2022-02-19,BH,Bahrain,EMRO,3651,485163,2,1435
2022-02-20,BH,Bahrain,EMRO,3260,488423,2,1437
.
11671a
2022-02-19,BS,Bahamas,AMRO,46,33018,0,768
2022-02-20,BS,Bahamas,AMRO,0,33018,0,768
.
10893a
2022-02-19,AZ,Azerbaijan,EURO,3817,768019,25,9182
2022-02-20,AZ,Azerbaijan,EURO,3690,771709,29,9211
.
10115a
2022-02-19,AT,Austria,EURO,30849,2438256,20,13976
2022-02-20,AT,Austria,EURO,25714,2463970,16,13992
.
9337c
2022-02-18,AU,Australia,WPRO,24532,2630721,66,4798
2022-02-19,AU,Australia,WPRO,22872,2653593,37,4835
2022-02-20,AU,Australia,WPRO,19716,2673309,45,4880
.
8559a
2022-02-19,AW,Aruba,AMRO,24,33568,0,198
2022-02-20,AW,Aruba,AMRO,0,33568,0,198
.
7781a
2022-02-19,AM,Armenia,EURO,1469,414764,30,8308
2022-02-20,AM,Armenia,EURO,700,415464,14,8322
.
7003a
2022-02-19,AR,Argentina,AMRO,15389,8815247,138,125062
2022-02-20,AR,Argentina,AMRO,7807,8823054,123,125185
.
6225a
2022-02-19,AG,Antigua and Barbuda,AMRO,5,7400,0,135
2022-02-20,AG,Antigua and Barbuda,AMRO,8,7408,0,135
.
5447a
2022-02-19,AI,Anguilla,AMRO,0,2506,0,9
2022-02-20,AI,Anguilla,AMRO,0,2506,0,9
.
4669c
2022-02-18,AO,Angola,AFRO,17,98585,0,1899
2022-02-19,AO,Angola,AFRO,20,98605,0,1899
2022-02-20,AO,Angola,AFRO,12,98617,0,1899
.
3891a
2022-02-19,AD,Andorra,EURO,67,37589,0,150
2022-02-20,AD,Andorra,EURO,0,37589,0,150
.
3113a
2022-02-19,AS,American Samoa,WPRO,0,57,0,0
2022-02-20,AS,American Samoa,WPRO,0,57,0,0
.
2335c
2022-02-18,DZ,Algeria,AFRO,375,263369,10,6772
2022-02-19,DZ,Algeria,AFRO,316,263685,8,6780
2022-02-20,DZ,Algeria,AFRO,251,263936,7,6787
.
1557a
2022-02-19,AL,Albania,EURO,303,269904,1,3433
2022-02-20,AL,Albania,EURO,260,270164,5,3438
.
779a
2022-02-19,AF,Afghanistan,EMRO,197,171870,5,7529
2022-02-20,AF,Afghanistan,EMRO,60,171930,5,7534
.
w WHO-COVID-19-global-data.csv_2022-02-21_22:20:01
q

ed_heredoc
# 
# Dateiname: WHO-COVID-19-global-data.csv_2022-02-21_22:20:01 
# Zugriffsrechte -rw-r--r-- setzen 
  chmod 644 WHO-COVID-19-global-data.csv_2022-02-21_22:20:01 
# ctime war: - 
# atime auf    2022-06-24 00:58:49.124079000 +0200  setzen 
  touch -a -d '2022-06-24 00:58:49.124079000 +0200' WHO-COVID-19-global-data.csv_2022-02-21_22:20:01 
# mtime auf    2022-02-21 21:20:01.577230000 +0100  setzen 
  touch -m -d '2022-02-21 21:20:01.577230000 +0100' WHO-COVID-19-global-data.csv_2022-02-21_22:20:01 
