#!/bin/bash
#
#
# Dies ist ein Script um aus der Datei (Vorgaenger) 
#   WHO-COVID-19-global-data.csv_2022-02-25_18:30:01 
# die Datei 
#   WHO-COVID-19-global-data.csv_2022-02-28_19:00:01
# zu generieren. .
#
# Wenn  sich mehrere Dateien mit Endnug .diff.bash im Verz. befinden können 
# sie mit 
#   for datei in $(ls *.diff.bash) ;do ./${datei} ; done
# ausgeführt werden. Wichtig ist, das die Reihenfolge des Aufrufs stimmt 
# weil jedes Script auf das Ergebnis des Vorgängerscripts angewiesen ist. 
#
# Bekannter Fehler: wenn die Originaldatei keinen Zeilenumbruch am Dateiende 
# hatte hängt das ed-Script einen Zeilenumbruch an. 
#
/bin/ed WHO-COVID-19-global-data.csv_2022-02-25_18:30:01 <<ed_heredoc
185809a
2022-02-25,ZW,Zimbabwe,AFRO,378,234967,2,5390
.
185025a
2022-02-25,ZM,Zambia,AFRO,230,312118,0,3947
.
184241a
2022-02-25,YE,Yemen,EMRO,0,11751,0,2130
.
183457a
2022-02-25,WF,Wallis and Futuna,WPRO,0,453,0,7
.
182673a
2022-02-25,VN,Viet Nam,WPRO,69128,3041506,165,39884
.
181889a
2022-02-25,VE,Venezuela (Bolivarian Republic of),AMRO,391,512560,3,5624
.
181105a
2022-02-25,VU,Vanuatu,WPRO,4,19,0,0
.
180321a
2022-02-25,UZ,Uzbekistan,EURO,156,236036,2,1628
.
179537a
2022-02-25,UY,Uruguay,AMRO,4030,827814,14,6919
.
178753a
2022-02-25,VI,United States Virgin Islands,AMRO,10,15327,0,109
.
177969a
2022-02-25,US,United States of America,AMRO,76613,78050838,3481,935093
.
177185a
2022-02-25,TZ,United Republic of Tanzania,AFRO,0,33620,0,798
.
176401a
2022-02-25,AE,United Arab Emirates,EMRO,782,877406,1,2299
.
175617a
2022-02-25,UA,Ukraine,EURO,11664,4821288,159,105664
.
174833a
2022-02-25,UG,Uganda,AFRO,52,163231,0,3585
.
174049a
2022-02-25,TV,Tuvalu,WPRO,0,0,0,0
.
173265a
2022-02-25,TC,Turks and Caicos Islands,AMRO,7,5855,0,36
.
172481a
2022-02-25,TM,Turkmenistan,EURO,0,0,0,0
.
171697a
2022-02-25,TR,Turkey,EURO,79708,13840998,281,93539
.
170913a
2022-02-25,TN,Tunisia,EMRO,0,992574,0,27640
.
170129a
2022-02-25,TT,Trinidad and Tobago,AMRO,1376,125864,21,3603
.
169345c
2022-02-24,TO,Tonga,WPRO,18,287,0,0
2022-02-25,TO,Tonga,WPRO,0,287,1,1
.
168561a
2022-02-25,TK,Tokelau,WPRO,0,0,0,0
.
167777a
2022-02-25,TG,Togo,AFRO,6,36777,0,272
.
166993a
2022-02-25,TL,Timor-Leste,SEARO,0,22584,0,126
.
166209a
2022-02-25,GB,The United Kingdom,EURO,38481,18773168,125,161104
.
165425a
2022-02-25,TH,Thailand,SEARO,24932,2819282,41,22809
.
164641a
2022-02-25,TJ,Tajikistan,EURO,0,17786,0,125
.
163857a
2022-02-25,SY,Syrian Arab Republic,EMRO,0,54040,0,3059
.
163050,163073c
2022-02-01,CH,Switzerland,EURO,43228,2268548,14,12370
2022-02-02,CH,Switzerland,EURO,36531,2305079,15,12385
2022-02-03,CH,Switzerland,EURO,34051,2339130,17,12402
2022-02-04,CH,Switzerland,EURO,28875,2368005,11,12413
2022-02-05,CH,Switzerland,EURO,26325,2394330,7,12420
2022-02-06,CH,Switzerland,EURO,18174,2412504,12,12432
2022-02-07,CH,Switzerland,EURO,14419,2426923,12,12444
2022-02-08,CH,Switzerland,EURO,32156,2459079,17,12461
2022-02-09,CH,Switzerland,EURO,26963,2486042,13,12474
2022-02-10,CH,Switzerland,EURO,25460,2511502,15,12489
2022-02-11,CH,Switzerland,EURO,22225,2533727,12,12501
2022-02-12,CH,Switzerland,EURO,19678,2553405,16,12517
2022-02-13,CH,Switzerland,EURO,13979,2567384,12,12529
2022-02-14,CH,Switzerland,EURO,10710,2578094,10,12539
2022-02-15,CH,Switzerland,EURO,24634,2602728,6,12545
2022-02-16,CH,Switzerland,EURO,20512,2623240,12,12557
2022-02-17,CH,Switzerland,EURO,19088,2642328,7,12564
2022-02-18,CH,Switzerland,EURO,14249,2656577,10,12574
2022-02-19,CH,Switzerland,EURO,13386,2669963,6,12580
2022-02-20,CH,Switzerland,EURO,9768,2679731,11,12591
2022-02-21,CH,Switzerland,EURO,8041,2687772,7,12598
2022-02-22,CH,Switzerland,EURO,19561,2707333,11,12609
2022-02-23,CH,Switzerland,EURO,16544,2723877,5,12614
2022-02-24,CH,Switzerland,EURO,12012,2735889,2,12616
2022-02-25,CH,Switzerland,EURO,10,2735899,0,12616
.
163015,163047c
2021-12-28,CH,Switzerland,EURO,17423,1278507,17,11834
2021-12-29,CH,Switzerland,EURO,17668,1296175,25,11859
2021-12-30,CH,Switzerland,EURO,18994,1315169,14,11873
2021-12-31,CH,Switzerland,EURO,19742,1334911,23,11896
2022-01-01,CH,Switzerland,EURO,16133,1351044,24,11920
2022-01-02,CH,Switzerland,EURO,9395,1360439,17,11937
2022-01-03,CH,Switzerland,EURO,12807,1373246,12,11949
2022-01-04,CH,Switzerland,EURO,32269,1405515,11,11960
2022-01-05,CH,Switzerland,EURO,33363,1438878,10,11970
2022-01-06,CH,Switzerland,EURO,30648,1469526,13,11983
2022-01-07,CH,Switzerland,EURO,26122,1495648,12,11995
2022-01-08,CH,Switzerland,EURO,27269,1522917,28,12023
2022-01-09,CH,Switzerland,EURO,17776,1540693,17,12040
2022-01-10,CH,Switzerland,EURO,13381,1554074,10,12050
2022-01-11,CH,Switzerland,EURO,34534,1588608,18,12068
2022-01-12,CH,Switzerland,EURO,30909,1619517,12,12080
2022-01-13,CH,Switzerland,EURO,29608,1649125,10,12090
2022-01-14,CH,Switzerland,EURO,28616,1677741,14,12104
2022-01-15,CH,Switzerland,EURO,27623,1705364,13,12117
2022-01-16,CH,Switzerland,EURO,19292,1724656,16,12133
2022-01-17,CH,Switzerland,EURO,14757,1739413,14,12147
2022-01-18,CH,Switzerland,EURO,41800,1781213,12,12159
2022-01-19,CH,Switzerland,EURO,39312,1820525,16,12175
2022-01-20,CH,Switzerland,EURO,39095,1859620,21,12196
2022-01-21,CH,Switzerland,EURO,37655,1897275,20,12216
2022-01-22,CH,Switzerland,EURO,36638,1933913,12,12228
2022-01-23,CH,Switzerland,EURO,24631,1958544,17,12245
2022-01-24,CH,Switzerland,EURO,18335,1976879,8,12253
2022-01-25,CH,Switzerland,EURO,48330,2025209,8,12261
2022-01-26,CH,Switzerland,EURO,44117,2069326,19,12280
2022-01-27,CH,Switzerland,EURO,41390,2110716,11,12291
2022-01-28,CH,Switzerland,EURO,37705,2148421,11,12302
2022-01-29,CH,Switzerland,EURO,35610,2184031,17,12319
.
162610,162989c
2020-11-18,CH,Switzerland,EURO,5418,282677,94,3757
2020-11-19,CH,Switzerland,EURO,4854,287531,108,3865
2020-11-20,CH,Switzerland,EURO,4490,292021,83,3948
2020-11-21,CH,Switzerland,EURO,4328,296349,84,4032
2020-11-22,CH,Switzerland,EURO,2573,298922,82,4114
2020-11-23,CH,Switzerland,EURO,1872,300794,82,4196
2020-11-24,CH,Switzerland,EURO,5434,306228,98,4294
2020-11-25,CH,Switzerland,EURO,4432,310660,92,4386
2020-11-26,CH,Switzerland,EURO,4293,314953,93,4479
2020-11-27,CH,Switzerland,EURO,3951,318904,79,4558
2020-11-28,CH,Switzerland,EURO,4067,322971,87,4645
2020-11-29,CH,Switzerland,EURO,2311,325282,89,4734
2020-11-30,CH,Switzerland,EURO,1691,326973,84,4818
2020-12-01,CH,Switzerland,EURO,5268,332241,95,4913
2020-12-02,CH,Switzerland,EURO,4252,336493,88,5001
2020-12-03,CH,Switzerland,EURO,4423,340916,93,5094
2020-12-04,CH,Switzerland,EURO,4319,345235,81,5175
2020-12-05,CH,Switzerland,EURO,4558,349793,82,5257
2020-12-06,CH,Switzerland,EURO,2519,352312,96,5353
2020-12-07,CH,Switzerland,EURO,1938,354250,70,5423
2020-12-08,CH,Switzerland,EURO,5828,360078,80,5503
2020-12-09,CH,Switzerland,EURO,4670,364748,97,5600
2020-12-10,CH,Switzerland,EURO,5241,369989,87,5687
2020-12-11,CH,Switzerland,EURO,4638,374627,83,5770
2020-12-12,CH,Switzerland,EURO,4679,379306,90,5860
2020-12-13,CH,Switzerland,EURO,2864,382170,85,5945
2020-12-14,CH,Switzerland,EURO,2086,384256,85,6030
2020-12-15,CH,Switzerland,EURO,5914,390170,98,6128
2020-12-16,CH,Switzerland,EURO,5166,395336,91,6219
2020-12-17,CH,Switzerland,EURO,4819,400155,94,6313
2020-12-18,CH,Switzerland,EURO,4386,404541,88,6401
2020-12-19,CH,Switzerland,EURO,4345,408886,92,6493
2020-12-20,CH,Switzerland,EURO,2677,411563,80,6573
2020-12-21,CH,Switzerland,EURO,1955,413518,99,6672
2020-12-22,CH,Switzerland,EURO,5623,419141,89,6761
2020-12-23,CH,Switzerland,EURO,4606,423747,82,6843
2020-12-24,CH,Switzerland,EURO,4475,428222,81,6924
2020-12-25,CH,Switzerland,EURO,3048,431270,89,7013
2020-12-26,CH,Switzerland,EURO,1721,432991,63,7076
2020-12-27,CH,Switzerland,EURO,2357,435348,96,7172
2020-12-28,CH,Switzerland,EURO,2116,437464,92,7264
2020-12-29,CH,Switzerland,EURO,5035,442499,83,7347
2020-12-30,CH,Switzerland,EURO,4463,446962,78,7425
2020-12-31,CH,Switzerland,EURO,4210,451172,92,7517
2021-01-01,CH,Switzerland,EURO,3055,454227,82,7599
2021-01-02,CH,Switzerland,EURO,1684,455911,76,7675
2021-01-03,CH,Switzerland,EURO,2727,458638,70,7745
2021-01-04,CH,Switzerland,EURO,2225,460863,67,7812
2021-01-05,CH,Switzerland,EURO,5287,466150,51,7863
2021-01-06,CH,Switzerland,EURO,4178,470328,64,7927
2021-01-07,CH,Switzerland,EURO,3355,473683,63,7990
2021-01-08,CH,Switzerland,EURO,3177,476860,65,8055
2021-01-09,CH,Switzerland,EURO,3055,479915,49,8104
2021-01-10,CH,Switzerland,EURO,1686,481601,69,8173
2021-01-11,CH,Switzerland,EURO,1296,482897,58,8231
2021-01-12,CH,Switzerland,EURO,3468,486365,59,8290
2021-01-13,CH,Switzerland,EURO,2610,488975,55,8345
2021-01-14,CH,Switzerland,EURO,2491,491466,59,8404
2021-01-15,CH,Switzerland,EURO,2239,493705,49,8453
2021-01-16,CH,Switzerland,EURO,2159,495864,65,8518
2021-01-17,CH,Switzerland,EURO,1337,497201,51,8569
2021-01-18,CH,Switzerland,EURO,894,498095,37,8606
2021-01-19,CH,Switzerland,EURO,2944,501039,38,8644
2021-01-20,CH,Switzerland,EURO,2333,503372,62,8706
2021-01-21,CH,Switzerland,EURO,2278,505650,46,8752
2021-01-22,CH,Switzerland,EURO,2057,507707,47,8799
2021-01-23,CH,Switzerland,EURO,2041,509748,44,8843
2021-01-24,CH,Switzerland,EURO,1101,510849,46,8889
2021-01-25,CH,Switzerland,EURO,730,511579,49,8938
2021-01-26,CH,Switzerland,EURO,2493,514072,32,8970
2021-01-27,CH,Switzerland,EURO,1838,515910,41,9011
2021-01-28,CH,Switzerland,EURO,1875,517785,34,9045
2021-01-29,CH,Switzerland,EURO,1781,519566,42,9087
2021-01-30,CH,Switzerland,EURO,1766,521332,36,9123
2021-01-31,CH,Switzerland,EURO,1020,522352,30,9153
2021-02-01,CH,Switzerland,EURO,744,523096,27,9180
2021-02-02,CH,Switzerland,EURO,2164,525260,31,9211
2021-02-03,CH,Switzerland,EURO,1652,526912,24,9235
2021-02-04,CH,Switzerland,EURO,1733,528645,19,9254
2021-02-05,CH,Switzerland,EURO,1441,530086,24,9278
2021-02-06,CH,Switzerland,EURO,1505,531591,22,9300
2021-02-07,CH,Switzerland,EURO,887,532478,26,9326
2021-02-08,CH,Switzerland,EURO,673,533151,19,9345
2021-02-09,CH,Switzerland,EURO,1751,534902,20,9365
2021-02-10,CH,Switzerland,EURO,1351,536253,16,9381
2021-02-11,CH,Switzerland,EURO,1259,537512,23,9404
2021-02-12,CH,Switzerland,EURO,1171,538683,14,9418
2021-02-13,CH,Switzerland,EURO,1131,539814,15,9433
2021-02-14,CH,Switzerland,EURO,719,540533,18,9451
2021-02-15,CH,Switzerland,EURO,485,541018,22,9473
2021-02-16,CH,Switzerland,EURO,1304,542322,19,9492
2021-02-17,CH,Switzerland,EURO,1137,543459,8,9500
2021-02-18,CH,Switzerland,EURO,1215,544674,9,9509
2021-02-19,CH,Switzerland,EURO,1008,545682,10,9519
2021-02-20,CH,Switzerland,EURO,1094,546776,14,9533
2021-02-21,CH,Switzerland,EURO,691,547467,15,9548
2021-02-22,CH,Switzerland,EURO,527,547994,11,9559
2021-02-23,CH,Switzerland,EURO,1407,549401,9,9568
2021-02-24,CH,Switzerland,EURO,1258,550659,10,9578
2021-02-25,CH,Switzerland,EURO,1077,551736,8,9586
2021-02-26,CH,Switzerland,EURO,1119,552855,10,9596
2021-02-27,CH,Switzerland,EURO,1080,553935,9,9605
2021-02-28,CH,Switzerland,EURO,723,554658,10,9615
2021-03-01,CH,Switzerland,EURO,547,555205,7,9622
2021-03-02,CH,Switzerland,EURO,1419,556624,8,9630
2021-03-03,CH,Switzerland,EURO,1230,557854,11,9641
2021-03-04,CH,Switzerland,EURO,1240,559094,9,9650
2021-03-05,CH,Switzerland,EURO,1063,560157,9,9659
2021-03-06,CH,Switzerland,EURO,1278,561435,10,9669
2021-03-07,CH,Switzerland,EURO,765,562200,8,9677
2021-03-08,CH,Switzerland,EURO,582,562782,9,9686
2021-03-09,CH,Switzerland,EURO,1702,564484,10,9696
2021-03-10,CH,Switzerland,EURO,1388,565872,8,9704
2021-03-11,CH,Switzerland,EURO,1385,567257,12,9716
2021-03-12,CH,Switzerland,EURO,1340,568597,13,9729
2021-03-13,CH,Switzerland,EURO,1342,569939,9,9738
2021-03-14,CH,Switzerland,EURO,923,570862,14,9752
2021-03-15,CH,Switzerland,EURO,703,571565,9,9761
2021-03-16,CH,Switzerland,EURO,1922,573487,9,9770
2021-03-17,CH,Switzerland,EURO,1653,575140,11,9781
2021-03-18,CH,Switzerland,EURO,1824,576964,13,9794
2021-03-19,CH,Switzerland,EURO,1647,578611,9,9803
2021-03-20,CH,Switzerland,EURO,1545,580156,9,9812
2021-03-21,CH,Switzerland,EURO,1111,581267,4,9816
2021-03-22,CH,Switzerland,EURO,787,582054,7,9823
2021-03-23,CH,Switzerland,EURO,2263,584317,5,9828
2021-03-24,CH,Switzerland,EURO,1995,586312,12,9840
2021-03-25,CH,Switzerland,EURO,1931,588243,7,9847
2021-03-26,CH,Switzerland,EURO,2142,590385,13,9860
2021-03-27,CH,Switzerland,EURO,2000,592385,4,9864
2021-03-28,CH,Switzerland,EURO,1208,593593,10,9874
2021-03-29,CH,Switzerland,EURO,995,594588,9,9883
2021-03-30,CH,Switzerland,EURO,2532,597120,5,9888
2021-03-31,CH,Switzerland,EURO,2093,599213,12,9900
2021-04-01,CH,Switzerland,EURO,2132,601345,14,9914
2021-04-02,CH,Switzerland,EURO,1985,603330,12,9926
2021-04-03,CH,Switzerland,EURO,1205,604535,6,9932
2021-04-04,CH,Switzerland,EURO,1317,605852,12,9944
2021-04-05,CH,Switzerland,EURO,1022,606874,10,9954
2021-04-06,CH,Switzerland,EURO,1290,608164,17,9971
2021-04-07,CH,Switzerland,EURO,2690,610854,10,9981
2021-04-08,CH,Switzerland,EURO,2387,613241,10,9991
2021-04-09,CH,Switzerland,EURO,2490,615731,5,9996
2021-04-10,CH,Switzerland,EURO,2416,618147,8,10004
2021-04-11,CH,Switzerland,EURO,1682,619829,6,10010
2021-04-12,CH,Switzerland,EURO,1180,621009,7,10017
2021-04-13,CH,Switzerland,EURO,2742,623751,3,10020
2021-04-14,CH,Switzerland,EURO,2375,626126,10,10030
2021-04-15,CH,Switzerland,EURO,2214,628340,6,10036
2021-04-16,CH,Switzerland,EURO,2147,630487,4,10040
2021-04-17,CH,Switzerland,EURO,2121,632608,7,10047
2021-04-18,CH,Switzerland,EURO,1430,634038,9,10056
2021-04-19,CH,Switzerland,EURO,1048,635086,7,10063
2021-04-20,CH,Switzerland,EURO,2744,637830,8,10071
2021-04-21,CH,Switzerland,EURO,2391,640221,9,10080
2021-04-22,CH,Switzerland,EURO,2309,642530,5,10085
2021-04-23,CH,Switzerland,EURO,2266,644796,7,10092
2021-04-24,CH,Switzerland,EURO,2165,646961,10,10102
2021-04-25,CH,Switzerland,EURO,1456,648417,6,10108
2021-04-26,CH,Switzerland,EURO,1188,649605,9,10117
2021-04-27,CH,Switzerland,EURO,2441,652046,13,10130
2021-04-28,CH,Switzerland,EURO,2038,654084,11,10141
2021-04-29,CH,Switzerland,EURO,2009,656093,7,10148
2021-04-30,CH,Switzerland,EURO,1711,657804,8,10156
2021-05-01,CH,Switzerland,EURO,1677,659481,9,10165
2021-05-02,CH,Switzerland,EURO,1159,660640,12,10177
2021-05-03,CH,Switzerland,EURO,832,661472,8,10185
2021-05-04,CH,Switzerland,EURO,2019,663491,5,10190
2021-05-05,CH,Switzerland,EURO,1735,665226,4,10194
2021-05-06,CH,Switzerland,EURO,1649,666875,11,10205
2021-05-07,CH,Switzerland,EURO,1484,668359,4,10209
2021-05-08,CH,Switzerland,EURO,1573,669932,7,10216
2021-05-09,CH,Switzerland,EURO,1062,670994,5,10221
2021-05-10,CH,Switzerland,EURO,779,671773,5,10226
2021-05-11,CH,Switzerland,EURO,1718,673491,6,10232
2021-05-12,CH,Switzerland,EURO,1383,674874,4,10236
2021-05-13,CH,Switzerland,EURO,1441,676315,0,10236
2021-05-14,CH,Switzerland,EURO,672,676987,5,10241
2021-05-15,CH,Switzerland,EURO,1169,678156,4,10245
2021-05-16,CH,Switzerland,EURO,802,678958,2,10247
2021-05-17,CH,Switzerland,EURO,653,679611,9,10256
2021-05-18,CH,Switzerland,EURO,1671,681282,1,10257
2021-05-19,CH,Switzerland,EURO,1344,682626,3,10260
2021-05-20,CH,Switzerland,EURO,1212,683838,6,10266
2021-05-21,CH,Switzerland,EURO,1040,684878,3,10269
2021-05-22,CH,Switzerland,EURO,984,685862,10,10279
2021-05-23,CH,Switzerland,EURO,623,686485,5,10284
2021-05-24,CH,Switzerland,EURO,470,686955,5,10289
2021-05-25,CH,Switzerland,EURO,581,687536,4,10293
2021-05-26,CH,Switzerland,EURO,1148,688684,4,10297
2021-05-27,CH,Switzerland,EURO,923,689607,2,10299
2021-05-28,CH,Switzerland,EURO,849,690456,3,10302
2021-05-29,CH,Switzerland,EURO,751,691207,2,10304
2021-05-30,CH,Switzerland,EURO,500,691707,4,10308
2021-05-31,CH,Switzerland,EURO,357,692064,0,10308
2021-06-01,CH,Switzerland,EURO,854,692918,2,10310
2021-06-02,CH,Switzerland,EURO,652,693570,1,10311
2021-06-03,CH,Switzerland,EURO,551,694121,3,10314
2021-06-04,CH,Switzerland,EURO,468,694589,6,10320
2021-06-05,CH,Switzerland,EURO,491,695080,4,10324
2021-06-06,CH,Switzerland,EURO,313,695393,2,10326
2021-06-07,CH,Switzerland,EURO,187,695580,6,10332
2021-06-08,CH,Switzerland,EURO,584,696164,2,10334
2021-06-09,CH,Switzerland,EURO,417,696581,2,10336
2021-06-10,CH,Switzerland,EURO,375,696956,2,10338
2021-06-11,CH,Switzerland,EURO,304,697260,3,10341
2021-06-12,CH,Switzerland,EURO,318,697578,3,10344
2021-06-13,CH,Switzerland,EURO,194,697772,2,10346
2021-06-14,CH,Switzerland,EURO,121,697893,2,10348
2021-06-15,CH,Switzerland,EURO,328,698221,0,10348
2021-06-16,CH,Switzerland,EURO,233,698454,1,10349
2021-06-17,CH,Switzerland,EURO,191,698645,4,10353
2021-06-18,CH,Switzerland,EURO,156,698801,3,10356
2021-06-19,CH,Switzerland,EURO,149,698950,3,10359
2021-06-20,CH,Switzerland,EURO,103,699053,0,10359
2021-06-21,CH,Switzerland,EURO,78,699131,1,10360
2021-06-22,CH,Switzerland,EURO,165,699296,2,10362
2021-06-23,CH,Switzerland,EURO,122,699418,0,10362
2021-06-24,CH,Switzerland,EURO,127,699545,1,10363
2021-06-25,CH,Switzerland,EURO,113,699658,1,10364
2021-06-26,CH,Switzerland,EURO,98,699756,1,10365
2021-06-27,CH,Switzerland,EURO,60,699816,0,10365
2021-06-28,CH,Switzerland,EURO,59,699875,2,10367
2021-06-29,CH,Switzerland,EURO,150,700025,0,10367
2021-06-30,CH,Switzerland,EURO,115,700140,2,10369
2021-07-01,CH,Switzerland,EURO,159,700299,0,10369
2021-07-02,CH,Switzerland,EURO,169,700468,0,10369
2021-07-03,CH,Switzerland,EURO,165,700633,1,10370
2021-07-04,CH,Switzerland,EURO,129,700762,0,10370
2021-07-05,CH,Switzerland,EURO,139,700901,0,10370
2021-07-06,CH,Switzerland,EURO,310,701211,0,10370
2021-07-07,CH,Switzerland,EURO,289,701500,0,10370
2021-07-08,CH,Switzerland,EURO,320,701820,0,10370
2021-07-09,CH,Switzerland,EURO,316,702136,0,10370
2021-07-10,CH,Switzerland,EURO,327,702463,1,10371
2021-07-11,CH,Switzerland,EURO,255,702718,1,10372
2021-07-12,CH,Switzerland,EURO,230,702948,1,10373
2021-07-13,CH,Switzerland,EURO,571,703519,0,10373
2021-07-14,CH,Switzerland,EURO,521,704040,1,10374
2021-07-15,CH,Switzerland,EURO,590,704630,0,10374
2021-07-16,CH,Switzerland,EURO,623,705253,0,10374
2021-07-17,CH,Switzerland,EURO,645,705898,0,10374
2021-07-18,CH,Switzerland,EURO,454,706352,1,10375
2021-07-19,CH,Switzerland,EURO,394,706746,0,10375
2021-07-20,CH,Switzerland,EURO,857,707603,1,10376
2021-07-21,CH,Switzerland,EURO,737,708340,0,10376
2021-07-22,CH,Switzerland,EURO,873,709213,2,10378
2021-07-23,CH,Switzerland,EURO,724,709937,0,10378
2021-07-24,CH,Switzerland,EURO,743,710680,0,10378
2021-07-25,CH,Switzerland,EURO,538,711218,1,10379
2021-07-26,CH,Switzerland,EURO,480,711698,1,10380
2021-07-27,CH,Switzerland,EURO,951,712649,1,10381
2021-07-28,CH,Switzerland,EURO,740,713389,5,10386
2021-07-29,CH,Switzerland,EURO,785,714174,3,10389
2021-07-30,CH,Switzerland,EURO,783,714957,1,10390
2021-07-31,CH,Switzerland,EURO,803,715760,0,10390
2021-08-01,CH,Switzerland,EURO,656,716416,0,10390
2021-08-02,CH,Switzerland,EURO,535,716951,1,10391
2021-08-03,CH,Switzerland,EURO,1234,718185,1,10392
2021-08-04,CH,Switzerland,EURO,990,719175,1,10393
2021-08-05,CH,Switzerland,EURO,1070,720245,0,10393
2021-08-06,CH,Switzerland,EURO,1121,721366,0,10393
2021-08-07,CH,Switzerland,EURO,1153,722519,0,10393
2021-08-08,CH,Switzerland,EURO,1046,723565,0,10393
2021-08-09,CH,Switzerland,EURO,1008,724573,1,10394
2021-08-10,CH,Switzerland,EURO,2320,726893,2,10396
2021-08-11,CH,Switzerland,EURO,2030,728923,2,10398
2021-08-12,CH,Switzerland,EURO,2085,731008,3,10401
2021-08-13,CH,Switzerland,EURO,2167,733175,2,10403
2021-08-14,CH,Switzerland,EURO,2208,735383,1,10404
2021-08-15,CH,Switzerland,EURO,1679,737062,3,10407
2021-08-16,CH,Switzerland,EURO,1651,738713,2,10409
2021-08-17,CH,Switzerland,EURO,3951,742664,3,10412
2021-08-18,CH,Switzerland,EURO,2838,745502,4,10416
2021-08-19,CH,Switzerland,EURO,2710,748212,1,10417
2021-08-20,CH,Switzerland,EURO,2512,750724,4,10421
2021-08-21,CH,Switzerland,EURO,2561,753285,7,10428
2021-08-22,CH,Switzerland,EURO,1748,755033,3,10431
2021-08-23,CH,Switzerland,EURO,1633,756666,3,10434
2021-08-24,CH,Switzerland,EURO,3851,760517,6,10440
2021-08-25,CH,Switzerland,EURO,2916,763433,8,10448
2021-08-26,CH,Switzerland,EURO,2765,766198,4,10452
2021-08-27,CH,Switzerland,EURO,2693,768891,7,10459
2021-08-28,CH,Switzerland,EURO,2596,771487,4,10463
2021-08-29,CH,Switzerland,EURO,1677,773164,8,10471
2021-08-30,CH,Switzerland,EURO,1385,774549,5,10476
2021-08-31,CH,Switzerland,EURO,3562,778111,13,10489
2021-09-01,CH,Switzerland,EURO,2974,781085,4,10493
2021-09-02,CH,Switzerland,EURO,2942,784027,8,10501
2021-09-03,CH,Switzerland,EURO,3051,787078,4,10505
2021-09-04,CH,Switzerland,EURO,3077,790155,8,10513
2021-09-05,CH,Switzerland,EURO,1760,791915,6,10519
2021-09-06,CH,Switzerland,EURO,1399,793314,9,10528
2021-09-07,CH,Switzerland,EURO,3995,797309,8,10536
2021-09-08,CH,Switzerland,EURO,3044,800353,11,10547
2021-09-09,CH,Switzerland,EURO,3060,803413,7,10554
2021-09-10,CH,Switzerland,EURO,2769,806182,7,10561
2021-09-11,CH,Switzerland,EURO,2622,808804,5,10566
2021-09-12,CH,Switzerland,EURO,1551,810355,7,10573
2021-09-13,CH,Switzerland,EURO,1106,811461,10,10583
2021-09-14,CH,Switzerland,EURO,2764,814225,8,10591
2021-09-15,CH,Switzerland,EURO,2296,816521,3,10594
2021-09-16,CH,Switzerland,EURO,2242,818763,7,10601
2021-09-17,CH,Switzerland,EURO,1998,820761,3,10604
2021-09-18,CH,Switzerland,EURO,1691,822452,11,10615
2021-09-19,CH,Switzerland,EURO,1027,823479,4,10619
2021-09-20,CH,Switzerland,EURO,702,824181,6,10625
2021-09-21,CH,Switzerland,EURO,1880,826061,4,10629
2021-09-22,CH,Switzerland,EURO,1703,827764,4,10633
2021-09-23,CH,Switzerland,EURO,1531,829295,6,10639
2021-09-24,CH,Switzerland,EURO,1377,830672,7,10646
2021-09-25,CH,Switzerland,EURO,1343,832015,9,10655
2021-09-26,CH,Switzerland,EURO,886,832901,5,10660
2021-09-27,CH,Switzerland,EURO,607,833508,7,10667
2021-09-28,CH,Switzerland,EURO,1661,835169,3,10670
2021-09-29,CH,Switzerland,EURO,1208,836377,7,10677
2021-09-30,CH,Switzerland,EURO,1187,837564,11,10688
2021-10-01,CH,Switzerland,EURO,1195,838759,1,10689
2021-10-02,CH,Switzerland,EURO,1139,839898,5,10694
2021-10-03,CH,Switzerland,EURO,786,840684,5,10699
2021-10-04,CH,Switzerland,EURO,473,841157,3,10702
2021-10-05,CH,Switzerland,EURO,1278,842435,4,10706
2021-10-06,CH,Switzerland,EURO,1033,843468,6,10712
2021-10-07,CH,Switzerland,EURO,1009,844477,1,10713
2021-10-08,CH,Switzerland,EURO,1010,845487,8,10721
2021-10-09,CH,Switzerland,EURO,919,846406,3,10724
2021-10-10,CH,Switzerland,EURO,638,847044,5,10729
2021-10-11,CH,Switzerland,EURO,480,847524,4,10733
2021-10-12,CH,Switzerland,EURO,1172,848696,10,10743
2021-10-13,CH,Switzerland,EURO,964,849660,6,10749
2021-10-14,CH,Switzerland,EURO,963,850623,6,10755
2021-10-15,CH,Switzerland,EURO,958,851581,3,10758
2021-10-16,CH,Switzerland,EURO,985,852566,3,10761
2021-10-17,CH,Switzerland,EURO,700,853266,0,10761
2021-10-18,CH,Switzerland,EURO,680,853946,4,10765
2021-10-19,CH,Switzerland,EURO,1571,855517,2,10767
2021-10-20,CH,Switzerland,EURO,1289,856806,6,10773
2021-10-21,CH,Switzerland,EURO,1430,858236,9,10782
2021-10-22,CH,Switzerland,EURO,1372,859608,3,10785
2021-10-23,CH,Switzerland,EURO,1352,860960,5,10790
2021-10-24,CH,Switzerland,EURO,954,861914,4,10794
2021-10-25,CH,Switzerland,EURO,727,862641,4,10798
2021-10-26,CH,Switzerland,EURO,2024,864665,8,10806
2021-10-27,CH,Switzerland,EURO,1699,866364,5,10811
2021-10-28,CH,Switzerland,EURO,1807,868171,10,10821
2021-10-29,CH,Switzerland,EURO,1803,869974,7,10828
2021-10-30,CH,Switzerland,EURO,1864,871838,4,10832
2021-10-31,CH,Switzerland,EURO,1259,873097,6,10838
2021-11-01,CH,Switzerland,EURO,1081,874178,5,10843
2021-11-02,CH,Switzerland,EURO,2343,876521,5,10848
2021-11-03,CH,Switzerland,EURO,2983,879504,3,10851
2021-11-04,CH,Switzerland,EURO,2836,882340,3,10854
2021-11-05,CH,Switzerland,EURO,2843,885183,3,10857
2021-11-06,CH,Switzerland,EURO,2755,887938,7,10864
2021-11-07,CH,Switzerland,EURO,1931,889869,3,10867
2021-11-08,CH,Switzerland,EURO,1537,891406,10,10877
2021-11-09,CH,Switzerland,EURO,4204,895610,10,10887
2021-11-10,CH,Switzerland,EURO,3738,899348,11,10898
2021-11-11,CH,Switzerland,EURO,3969,903317,5,10903
2021-11-12,CH,Switzerland,EURO,3953,907270,13,10916
2021-11-13,CH,Switzerland,EURO,4144,911414,7,10923
2021-11-14,CH,Switzerland,EURO,2709,914123,7,10930
2021-11-15,CH,Switzerland,EURO,2165,916288,8,10938
2021-11-16,CH,Switzerland,EURO,6133,922421,8,10946
2021-11-17,CH,Switzerland,EURO,5626,928047,14,10960
2021-11-18,CH,Switzerland,EURO,6183,934230,13,10973
2021-11-19,CH,Switzerland,EURO,6055,940285,17,10990
2021-11-20,CH,Switzerland,EURO,6201,946486,6,10996
2021-11-21,CH,Switzerland,EURO,4141,950627,9,11005
2021-11-22,CH,Switzerland,EURO,3406,954033,13,11018
2021-11-23,CH,Switzerland,EURO,9167,963200,20,11038
2021-11-24,CH,Switzerland,EURO,8011,971211,18,11056
2021-11-25,CH,Switzerland,EURO,8468,979679,18,11074
2021-11-26,CH,Switzerland,EURO,7987,987666,8,11082
2021-11-27,CH,Switzerland,EURO,7968,995634,14,11096
2021-11-28,CH,Switzerland,EURO,5262,1000896,16,11112
2021-11-29,CH,Switzerland,EURO,4243,1005139,19,11131
2021-11-30,CH,Switzerland,EURO,11502,1016641,21,11152
2021-12-01,CH,Switzerland,EURO,10000,1026641,27,11179
2021-12-02,CH,Switzerland,EURO,10420,1037061,28,11207
.
162276,162289c
2022-02-11,SE,Sweden,EURO,15841,2389859,35,16715
2022-02-12,SE,Sweden,EURO,7431,2397290,44,16759
2022-02-13,SE,Sweden,EURO,5850,2403140,42,16801
2022-02-14,SE,Sweden,EURO,2817,2405957,30,16831
2022-02-15,SE,Sweden,EURO,1177,2407134,42,16873
2022-02-16,SE,Sweden,EURO,2548,2409682,59,16932
2022-02-17,SE,Sweden,EURO,4882,2414564,38,16970
2022-02-18,SE,Sweden,EURO,4050,2418614,34,17004
2022-02-19,SE,Sweden,EURO,4217,2422831,26,17030
2022-02-20,SE,Sweden,EURO,3423,2426254,22,17052
2022-02-21,SE,Sweden,EURO,1970,2428224,12,17064
2022-02-22,SE,Sweden,EURO,1088,2429312,9,17073
2022-02-23,SE,Sweden,EURO,2294,2431606,7,17080
2022-02-24,SE,Sweden,EURO,3424,2435030,2,17082
2022-02-25,SE,Sweden,EURO,2820,2437850,1,17083
.
161505a
2022-02-25,SR,Suriname,AMRO,55,77935,0,1314
.
160721a
2022-02-25,SD,Sudan,EMRO,0,61376,0,3901
.
159937a
2022-02-25,LK,Sri Lanka,SEARO,1208,641786,30,16116
.
159151,159153c
2022-02-22,ES,Spain,EURO,17299,10878828,129,98588
2022-02-23,ES,Spain,EURO,22366,10901194,173,98761
2022-02-24,ES,Spain,EURO,21911,10923105,175,98936
2022-02-25,ES,Spain,EURO,26892,10949997,226,99162
.
158369a
2022-02-25,SS,South Sudan,AFRO,5,16955,0,137
.
157585a
2022-02-25,ZA,South Africa,AFRO,2411,3667560,40,99018
.
156801a
2022-02-25,SO,Somalia,EMRO,0,26313,0,1348
.
156017a
2022-02-25,SB,Solomon Islands,WPRO,306,6654,5,92
.
155217,155233c
2022-02-08,SI,Slovenia,EURO,5547,800383,25,6630
2022-02-09,SI,Slovenia,EURO,11198,811581,23,6653
2022-02-10,SI,Slovenia,EURO,5131,816712,25,6678
2022-02-11,SI,Slovenia,EURO,12199,828911,15,6693
2022-02-12,SI,Slovenia,EURO,7567,836478,26,6719
2022-02-13,SI,Slovenia,EURO,7395,843873,31,6750
2022-02-14,SI,Slovenia,EURO,4305,848178,15,6765
2022-02-15,SI,Slovenia,EURO,3643,851821,22,6787
2022-02-16,SI,Slovenia,EURO,7160,858981,28,6815
2022-02-17,SI,Slovenia,EURO,4742,863723,19,6834
2022-02-18,SI,Slovenia,EURO,4569,868292,13,6847
2022-02-19,SI,Slovenia,EURO,3832,872124,14,6861
2022-02-20,SI,Slovenia,EURO,3751,875875,7,6868
2022-02-21,SI,Slovenia,EURO,2294,878169,11,6879
2022-02-22,SI,Slovenia,EURO,2028,880197,5,6884
2022-02-23,SI,Slovenia,EURO,2312,882509,4,6888
2022-02-24,SI,Slovenia,EURO,2380,884889,5,6893
2022-02-25,SI,Slovenia,EURO,2335,887224,0,6893
.
154449a
2022-02-25,SK,Slovakia,EURO,12829,1421546,37,18375
.
153665a
2022-02-25,SX,Sint Maarten,AMRO,2,9537,0,85
.
152881a
2022-02-25,XB,Sint Eustatius,AMRO,0,453,0,3
.
152097a
2022-02-25,SG,Singapore,WPRO,18593,661198,12,975
.
151313a
2022-02-25,SL,Sierra Leone,AFRO,0,7664,0,125
.
150529a
2022-02-25,SC,Seychelles,AFRO,0,39251,0,160
.
149745a
2022-02-25,RS,Serbia,EURO,3718,1900293,49,15059
.
148961a
2022-02-25,SN,Senegal,AFRO,18,85637,0,1960
.
148177a
2022-02-25,SA,Saudi Arabia,EMRO,677,742541,1,8991
.
147393a
2022-02-25,ST,Sao Tome and Principe,AFRO,0,5932,0,72
.
146609a
2022-02-25,SM,San Marino,EURO,19,14310,0,112
.
145825a
2022-02-25,WS,Samoa,WPRO,0,33,1,1
.
145041a
2022-02-25,VC,Saint Vincent and the Grenadines,AMRO,2,8305,0,106
.
144257a
2022-02-25,PM,Saint Pierre and Miquelon,AMRO,0,995,0,1
.
143473a
2022-02-25,MF,Saint Martin,AMRO,0,9790,0,44
.
142689a
2022-02-25,LC,Saint Lucia,AMRO,0,22594,0,357
.
141905a
2022-02-25,KN,Saint Kitts and Nevis,AMRO,1,5524,0,42
.
141121a
2022-02-25,SH,Saint Helena,AFRO,0,0,0,0
.
140337a
2022-02-25,BL,Saint Barthélemy,AMRO,0,3684,0,4
.
139553a
2022-02-25,XC,Saba,AMRO,0,208,0,0
.
138769a
2022-02-25,RW,Rwanda,AFRO,32,129468,0,1457
.
137985a
2022-02-25,RU,Russian Federation,EURO,123460,16052028,787,349365
.
137201a
2022-02-25,RO,Romania,EURO,10749,2708315,115,63073
.
136417a
2022-02-25,RE,Réunion,AFRO,0,292126,0,640
.
135633a
2022-02-25,MD,Republic of Moldova,EURO,1129,500144,14,11185
.
134849c
2022-02-24,KR,Republic of Korea,WPRO,170015,2499187,82,7689
2022-02-25,KR,Republic of Korea,WPRO,165890,2665077,94,7783
.
134065a
2022-02-25,QA,Qatar,EMRO,343,355740,0,664
.
133281a
2022-02-25,PR,Puerto Rico,AMRO,384,472484,10,4098
.
132497a
2022-02-25,PT,Portugal,EURO,11636,3231075,19,20941
.
131713a
2022-02-25,PL,Poland,EURO,16700,5637646,198,111056
.
130929a
2022-02-25,PN,Pitcairn Islands,WPRO,0,0,0,0
.
130145c
2022-02-24,PH,Philippines,WPRO,1422,3655597,201,55977
2022-02-25,PH,Philippines,WPRO,1745,3657342,188,56165
.
129361a
2022-02-25,PE,Peru,AMRO,3012,3503892,119,209927
.
128577a
2022-02-25,PY,Paraguay,AMRO,928,638153,22,18281
.
127793a
2022-02-25,PG,Papua New Guinea,WPRO,290,41038,0,638
.
127009a
2022-02-25,PA,Panama,AMRO,734,752907,11,8047
.
126225a
2022-02-25,PW,Palau,WPRO,29,3696,0,6
.
125441a
2022-02-25,PK,Pakistan,EMRO,1455,1505328,18,30114
.
124657a
2022-02-25, ,Other,Other,0,764,0,13
.
123873a
2022-02-25,OM,Oman,EMRO,696,379618,0,4238
.
123089a
2022-02-25,PS,"occupied Palestinian territory, including east Jerusalem",EMRO,0,640214,0,5458
.
122271,122305c
2022-01-21,NO,Norway,EURO,18151,580929,1,1413
2022-01-22,NO,Norway,EURO,18277,599206,0,1413
2022-01-23,NO,Norway,EURO,18554,617760,0,1413
2022-01-24,NO,Norway,EURO,12267,630027,0,1413
2022-01-25,NO,Norway,EURO,12864,642891,23,1436
2022-01-26,NO,Norway,EURO,28361,671252,2,1438
2022-01-27,NO,Norway,EURO,23586,694838,2,1440
2022-01-28,NO,Norway,EURO,22084,716922,0,1440
2022-01-29,NO,Norway,EURO,20088,737010,0,1440
2022-01-30,NO,Norway,EURO,18997,756007,0,1440
2022-01-31,NO,Norway,EURO,10776,766783,0,1440
2022-02-01,NO,Norway,EURO,11546,778329,25,1465
2022-02-02,NO,Norway,EURO,27860,806189,0,1465
2022-02-03,NO,Norway,EURO,23463,829652,1,1466
2022-02-04,NO,Norway,EURO,20349,850001,0,1466
2022-02-05,NO,Norway,EURO,17528,867529,0,1466
2022-02-06,NO,Norway,EURO,17414,884943,0,1466
2022-02-07,NO,Norway,EURO,10958,895901,0,1466
2022-02-08,NO,Norway,EURO,11092,906993,40,1506
2022-02-09,NO,Norway,EURO,29458,936451,6,1512
2022-02-10,NO,Norway,EURO,25504,961955,0,1512
2022-02-11,NO,Norway,EURO,24007,985962,1,1513
2022-02-12,NO,Norway,EURO,21921,1007883,0,1513
2022-02-13,NO,Norway,EURO,20518,1028401,0,1513
2022-02-14,NO,Norway,EURO,9175,1037576,0,1513
2022-02-15,NO,Norway,EURO,7826,1045402,32,1545
2022-02-16,NO,Norway,EURO,20253,1065655,3,1548
2022-02-17,NO,Norway,EURO,16647,1082302,0,1548
2022-02-18,NO,Norway,EURO,17167,1099469,0,1548
2022-02-19,NO,Norway,EURO,15787,1115256,0,1548
2022-02-20,NO,Norway,EURO,15628,1130884,0,1548
2022-02-21,NO,Norway,EURO,7625,1138509,0,1548
2022-02-22,NO,Norway,EURO,7443,1145952,48,1596
2022-02-23,NO,Norway,EURO,21216,1167168,1,1597
2022-02-24,NO,Norway,EURO,14356,1181524,1,1598
2022-02-25,NO,Norway,EURO,4887,1186411,0,1598
.
121521a
2022-02-25,MP,Northern Mariana Islands (Commonwealth of the),WPRO,157,9265,0,27
.
120729,120737c
2022-02-16,MK,North Macedonia,EURO,1266,288704,18,8830
2022-02-17,MK,North Macedonia,EURO,1091,289795,25,8855
2022-02-18,MK,North Macedonia,EURO,1116,290911,18,8873
2022-02-19,MK,North Macedonia,EURO,905,291816,20,8893
2022-02-20,MK,North Macedonia,EURO,840,292656,24,8917
2022-02-21,MK,North Macedonia,EURO,668,293324,10,8927
2022-02-22,MK,North Macedonia,EURO,235,293559,12,8939
2022-02-23,MK,North Macedonia,EURO,848,294407,11,8950
2022-02-24,MK,North Macedonia,EURO,674,295081,12,8962
2022-02-25,MK,North Macedonia,EURO,631,295712,6,8968
.
119953a
2022-02-25,NU,Niue,WPRO,0,0,0,0
.
119169a
2022-02-25,NG,Nigeria,AFRO,76,254428,0,3142
.
118385a
2022-02-25,NE,Niger,AFRO,0,8746,0,306
.
117601a
2022-02-25,NI,Nicaragua,AMRO,0,13958,0,224
.
116817c
2022-02-24,NZ,New Zealand,WPRO,8715,45039,0,56
2022-02-25,NZ,New Zealand,WPRO,12030,57069,0,56
.
116033a
2022-02-25,NC,New Caledonia,WPRO,911,52457,0,299
.
115215,115249c
2022-01-21,NL,Netherlands,EURO,39723,3716385,10,21182
2022-01-22,NL,Netherlands,EURO,57193,3773578,11,21193
2022-01-23,NL,Netherlands,EURO,45761,3819339,8,21201
2022-01-24,NL,Netherlands,EURO,64656,3883995,1,21202
2022-01-25,NL,Netherlands,EURO,64088,3948083,8,21210
2022-01-26,NL,Netherlands,EURO,53482,4001565,7,21217
2022-01-27,NL,Netherlands,EURO,57883,4059448,11,21228
2022-01-28,NL,Netherlands,EURO,64009,4123457,14,21242
2022-01-29,NL,Netherlands,EURO,73145,4196602,8,21250
2022-01-30,NL,Netherlands,EURO,38913,4235515,8,21258
2022-01-31,NL,Netherlands,EURO,74508,4310023,2,21260
2022-02-01,NL,Netherlands,EURO,110828,4420851,5,21265
2022-02-02,NL,Netherlands,EURO,104640,4525491,15,21280
2022-02-03,NL,Netherlands,EURO,66096,4591587,10,21290
2022-02-04,NL,Netherlands,EURO,81694,4673281,10,21300
2022-02-05,NL,Netherlands,EURO,71310,4744591,5,21305
2022-02-06,NL,Netherlands,EURO,52955,4797546,10,21315
2022-02-07,NL,Netherlands,EURO,79981,4877527,7,21322
2022-02-08,NL,Netherlands,EURO,81819,4959346,4,21326
2022-02-09,NL,Netherlands,EURO,390658,5350004,8,21334
2022-02-10,NL,Netherlands,EURO,86503,5436507,7,21341
2022-02-11,NL,Netherlands,EURO,86720,5523227,15,21356
2022-02-12,NL,Netherlands,EURO,80605,5603832,19,21375
2022-02-13,NL,Netherlands,EURO,70301,5674133,12,21387
2022-02-14,NL,Netherlands,EURO,60073,5734206,7,21394
2022-02-15,NL,Netherlands,EURO,55031,5789237,6,21400
2022-02-16,NL,Netherlands,EURO,53468,5842705,12,21412
2022-02-17,NL,Netherlands,EURO,63704,5906409,18,21430
2022-02-18,NL,Netherlands,EURO,56322,5962731,18,21448
2022-02-19,NL,Netherlands,EURO,49245,6011976,16,21464
2022-02-20,NL,Netherlands,EURO,33524,6045500,10,21474
2022-02-21,NL,Netherlands,EURO,36299,6081799,8,21482
2022-02-22,NL,Netherlands,EURO,35927,6117726,7,21489
2022-02-23,NL,Netherlands,EURO,34548,6152274,18,21507
2022-02-24,NL,Netherlands,EURO,41463,6193737,11,21518
2022-02-25,NL,Netherlands,EURO,41216,6234953,13,21531
.
115146,115208c
2021-11-13,NL,Netherlands,EURO,16052,2268726,31,18692
2021-11-14,NL,Netherlands,EURO,13801,2282527,32,18724
2021-11-15,NL,Netherlands,EURO,11976,2294503,7,18731
2021-11-16,NL,Netherlands,EURO,19192,2313695,16,18747
2021-11-17,NL,Netherlands,EURO,20143,2333838,35,18782
2021-11-18,NL,Netherlands,EURO,20704,2354542,44,18826
2021-11-19,NL,Netherlands,EURO,23563,2378105,34,18860
2021-11-20,NL,Netherlands,EURO,20973,2399078,39,18899
2021-11-21,NL,Netherlands,EURO,21758,2420836,55,18954
2021-11-22,NL,Netherlands,EURO,20632,2441468,11,18965
2021-11-23,NL,Netherlands,EURO,22986,2464454,29,18994
2021-11-24,NL,Netherlands,EURO,22949,2487403,53,19047
2021-11-25,NL,Netherlands,EURO,23700,2511103,50,19097
2021-11-26,NL,Netherlands,EURO,22174,2533277,61,19158
2021-11-27,NL,Netherlands,EURO,21264,2554541,59,19217
2021-11-28,NL,Netherlands,EURO,21989,2576530,54,19271
2021-11-29,NL,Netherlands,EURO,22067,2598597,43,19314
2021-11-30,NL,Netherlands,EURO,21454,2620051,33,19347
2021-12-01,NL,Netherlands,EURO,22058,2642109,65,19412
2021-12-02,NL,Netherlands,EURO,18497,2660606,43,19455
2021-12-03,NL,Netherlands,EURO,23031,2683637,65,19520
2021-12-04,NL,Netherlands,EURO,21479,2705116,61,19581
2021-12-05,NL,Netherlands,EURO,22600,2727716,56,19637
2021-12-06,NL,Netherlands,EURO,23051,2750767,26,19663
2021-12-07,NL,Netherlands,EURO,20977,2771744,34,19697
2021-12-08,NL,Netherlands,EURO,17942,2789686,68,19765
2021-12-09,NL,Netherlands,EURO,18055,2807741,71,19836
2021-12-10,NL,Netherlands,EURO,19731,2827472,78,19914
2021-12-11,NL,Netherlands,EURO,17445,2844917,84,19998
2021-12-12,NL,Netherlands,EURO,17746,2862663,69,20067
2021-12-13,NL,Netherlands,EURO,16604,2879267,39,20106
2021-12-14,NL,Netherlands,EURO,13790,2893057,28,20134
2021-12-15,NL,Netherlands,EURO,12796,2905853,74,20208
2021-12-16,NL,Netherlands,EURO,13496,2919349,41,20249
2021-12-17,NL,Netherlands,EURO,16348,2935697,54,20303
2021-12-18,NL,Netherlands,EURO,15338,2951035,59,20362
2021-12-19,NL,Netherlands,EURO,14661,2965696,50,20412
2021-12-20,NL,Netherlands,EURO,13256,2978952,48,20460
2021-12-21,NL,Netherlands,EURO,12141,2991093,35,20495
2021-12-22,NL,Netherlands,EURO,9392,3000485,31,20526
2021-12-23,NL,Netherlands,EURO,13397,3013882,48,20574
2021-12-24,NL,Netherlands,EURO,13315,3027197,40,20614
2021-12-25,NL,Netherlands,EURO,12468,3039665,40,20654
2021-12-26,NL,Netherlands,EURO,12555,3052220,45,20699
2021-12-27,NL,Netherlands,EURO,11893,3064113,11,20710
2021-12-28,NL,Netherlands,EURO,11428,3075541,12,20722
2021-12-29,NL,Netherlands,EURO,9134,3084675,75,20797
2021-12-30,NL,Netherlands,EURO,15696,3100371,50,20847
2021-12-31,NL,Netherlands,EURO,14759,3115130,40,20887
2022-01-01,NL,Netherlands,EURO,16681,3131811,33,20920
2022-01-02,NL,Netherlands,EURO,15583,3147394,27,20947
2022-01-03,NL,Netherlands,EURO,17426,3164820,6,20953
2022-01-04,NL,Netherlands,EURO,14494,3179314,14,20967
2022-01-05,NL,Netherlands,EURO,18507,3197821,19,20986
2022-01-06,NL,Netherlands,EURO,24439,3222260,38,21024
2022-01-07,NL,Netherlands,EURO,24526,3246786,12,21036
2022-01-08,NL,Netherlands,EURO,34727,3281513,24,21060
2022-01-09,NL,Netherlands,EURO,27786,3309299,8,21068
2022-01-10,NL,Netherlands,EURO,32337,3341636,7,21075
2022-01-11,NL,Netherlands,EURO,27740,3369376,7,21082
2022-01-12,NL,Netherlands,EURO,28853,3398229,18,21100
2022-01-13,NL,Netherlands,EURO,31908,3430137,8,21108
2022-01-14,NL,Netherlands,EURO,33149,3463286,13,21121
.
114465a
2022-02-25,NP,Nepal,SEARO,0,976512,0,11931
.
113681a
2022-02-25,NR,Nauru,WPRO,0,0,0,0
.
112897a
2022-02-25,NA,Namibia,AFRO,46,157106,4,4006
.
112113c
2022-02-24,MM,Myanmar,SEARO,2938,578446,4,19353
2022-02-25,MM,Myanmar,SEARO,0,578446,0,19353
.
111329a
2022-02-25,MZ,Mozambique,AFRO,16,224999,1,2192
.
110545a
2022-02-25,MA,Morocco,EMRO,0,1159941,0,15938
.
109761a
2022-02-25,MS,Montserrat,AMRO,0,163,0,2
.
108972,108977c
2022-02-19,ME,Montenegro,EURO,328,228223,2,2646
2022-02-20,ME,Montenegro,EURO,334,228557,4,2650
2022-02-21,ME,Montenegro,EURO,253,228810,5,2655
2022-02-22,ME,Montenegro,EURO,161,228971,3,2658
2022-02-23,ME,Montenegro,EURO,264,229235,8,2666
2022-02-24,ME,Montenegro,EURO,196,229431,3,2669
2022-02-25,ME,Montenegro,EURO,194,229625,1,2670
.
108193c
2022-02-24,MN,Mongolia,WPRO,1717,905451,2,2091
2022-02-25,MN,Mongolia,WPRO,517,905968,4,2095
.
107409a
2022-02-25,MC,Monaco,EURO,26,9331,0,51
.
106625a
2022-02-25,FM,Micronesia (Federated States of),WPRO,0,0,0,0
.
105841a
2022-02-25,MX,Mexico,AMRO,18671,5455237,449,316941
.
105057a
2022-02-25,YT,Mayotte,AFRO,0,36631,0,187
.
104273a
2022-02-25,MU,Mauritius,AFRO,0,70862,0,786
.
103489a
2022-02-25,MR,Mauritania,AFRO,0,58621,0,977
.
102705a
2022-02-25,MQ,Martinique,AMRO,0,112115,0,871
.
101921a
2022-02-25,MH,Marshall Islands,WPRO,0,4,0,0
.
101137a
2022-02-25,MT,Malta,EURO,95,71000,0,601
.
100353a
2022-02-25,ML,Mali,AFRO,3,30359,0,722
.
99569c
2022-02-24,MV,Maldives,SEARO,628,168124,1,294
2022-02-25,MV,Maldives,SEARO,0,168124,0,294
.
98785a
2022-02-25,MY,Malaysia,WPRO,32070,3337227,46,32534
.
98001a
2022-02-25,MW,Malawi,AFRO,19,85276,2,2612
.
97217a
2022-02-25,MG,Madagascar,AFRO,0,63433,0,1350
.
96433a
2022-02-25,LU,Luxembourg,EURO,819,181195,0,988
.
95649a
2022-02-25,LT,Lithuania,EURO,5675,891538,32,8368
.
94864,94865c
2022-02-23,LI,Liechtenstein,EURO,87,11574,0,74
2022-02-24,LI,Liechtenstein,EURO,90,11664,0,74
2022-02-25,LI,Liechtenstein,EURO,0,11664,0,74
.
94081a
2022-02-25,LY,Libya,EMRO,1276,491216,10,6232
.
93297a
2022-02-25,LR,Liberia,AFRO,0,7360,0,290
.
92513a
2022-02-25,LS,Lesotho,AFRO,0,32599,0,696
.
91729a
2022-02-25,LB,Lebanon,EMRO,0,1057000,0,10027
.
90945a
2022-02-25,LV,Latvia,EURO,11088,624008,14,5159
.
90161a
2022-02-25,LA,Lao People's Democratic Republic,WPRO,239,141933,1,617
.
89377a
2022-02-25,KG,Kyrgyzstan,EURO,25,200427,2,2952
.
88593a
2022-02-25,KW,Kuwait,EMRO,866,617275,1,2534
.
87809a
2022-02-25,XK,Kosovo[1],EURO,189,225810,3,3098
.
87025a
2022-02-25,KI,Kiribati,WPRO,16,2883,0,11
.
86241a
2022-02-25,KE,Kenya,AFRO,0,322781,0,5638
.
85457a
2022-02-25,KZ,Kazakhstan,EURO,575,1389288,13,18906
.
84673a
2022-02-25,JO,Jordan,EMRO,7415,1606837,16,13767
.
83889a
2022-02-25,JE,Jersey,EURO,284,36704,1,112
.
83105a
2022-02-25,JP,Japan,WPRO,65657,4750496,226,22755
.
82321a
2022-02-25,JM,Jamaica,AMRO,58,127799,10,2808
.
81537a
2022-02-25,IT,Italy,EURO,47493,12651251,249,154013
.
80519,80753c
2021-07-05,IL,Israel,EURO,352,843536,0,6437
2021-07-06,IL,Israel,EURO,504,844040,0,6437
2021-07-07,IL,Israel,EURO,546,844586,0,6437
2021-07-08,IL,Israel,EURO,527,845113,1,6438
2021-07-09,IL,Israel,EURO,473,845586,2,6440
2021-07-10,IL,Israel,EURO,544,846130,0,6440
2021-07-11,IL,Israel,EURO,261,846391,2,6442
2021-07-12,IL,Israel,EURO,443,846834,3,6445
2021-07-13,IL,Israel,EURO,765,847599,2,6447
2021-07-14,IL,Israel,EURO,750,848349,0,6447
2021-07-15,IL,Israel,EURO,774,849123,3,6450
2021-07-16,IL,Israel,EURO,877,850000,1,6451
2021-07-17,IL,Israel,EURO,1148,851148,1,6452
2021-07-18,IL,Israel,EURO,439,851587,2,6454
2021-07-19,IL,Israel,EURO,838,852425,3,6457
2021-07-20,IL,Israel,EURO,1400,853825,2,6459
2021-07-21,IL,Israel,EURO,1413,855238,2,6461
2021-07-22,IL,Israel,EURO,1372,856610,3,6464
2021-07-23,IL,Israel,EURO,1289,857899,1,6465
2021-07-24,IL,Israel,EURO,1442,859341,0,6465
2021-07-25,IL,Israel,EURO,973,860314,3,6468
2021-07-26,IL,Israel,EURO,1435,861749,4,6472
2021-07-27,IL,Israel,EURO,2135,863884,1,6473
2021-07-28,IL,Israel,EURO,2303,866187,1,6474
2021-07-29,IL,Israel,EURO,2200,868387,6,6480
2021-07-30,IL,Israel,EURO,2180,870567,6,6486
2021-07-31,IL,Israel,EURO,2465,873032,2,6488
2021-08-01,IL,Israel,EURO,2104,875136,5,6493
2021-08-02,IL,Israel,EURO,2126,877262,9,6502
2021-08-03,IL,Israel,EURO,3862,881124,9,6511
2021-08-04,IL,Israel,EURO,3312,884436,10,6521
2021-08-05,IL,Israel,EURO,3510,887946,5,6526
2021-08-06,IL,Israel,EURO,3887,891833,16,6542
2021-08-07,IL,Israel,EURO,3889,895722,14,6556
2021-08-08,IL,Israel,EURO,2936,898658,12,6568
2021-08-09,IL,Israel,EURO,3447,902105,19,6587
2021-08-10,IL,Israel,EURO,6382,908487,11,6598
2021-08-11,IL,Israel,EURO,5859,914346,17,6615
2021-08-12,IL,Israel,EURO,6027,920373,16,6631
2021-08-13,IL,Israel,EURO,6154,926527,19,6650
2021-08-14,IL,Israel,EURO,5975,932502,24,6674
2021-08-15,IL,Israel,EURO,4233,936735,18,6692
2021-08-16,IL,Israel,EURO,5199,941934,20,6712
2021-08-17,IL,Israel,EURO,8797,950731,28,6740
2021-08-18,IL,Israel,EURO,7993,958724,20,6760
2021-08-19,IL,Israel,EURO,8037,966761,22,6782
2021-08-20,IL,Israel,EURO,7842,974603,24,6806
2021-08-21,IL,Israel,EURO,7908,982511,24,6830
2021-08-22,IL,Israel,EURO,5416,987927,25,6855
2021-08-23,IL,Israel,EURO,6594,994521,33,6888
2021-08-24,IL,Israel,EURO,10114,1004635,20,6908
2021-08-25,IL,Israel,EURO,10087,1014722,31,6939
2021-08-26,IL,Israel,EURO,9245,1023967,28,6967
2021-08-27,IL,Israel,EURO,9124,1033091,32,6999
2021-08-28,IL,Israel,EURO,8700,1041791,25,7024
2021-08-29,IL,Israel,EURO,7279,1049070,23,7047
2021-08-30,IL,Israel,EURO,6792,1055862,29,7076
2021-08-31,IL,Israel,EURO,11157,1067019,26,7102
2021-09-01,IL,Israel,EURO,10447,1077466,31,7133
2021-09-02,IL,Israel,EURO,11302,1088768,31,7164
2021-09-03,IL,Israel,EURO,11346,1100114,31,7195
2021-09-04,IL,Israel,EURO,9912,1110026,34,7229
2021-09-05,IL,Israel,EURO,5067,1115093,26,7255
2021-09-06,IL,Israel,EURO,5867,1120960,26,7281
2021-09-07,IL,Israel,EURO,10871,1131831,23,7304
2021-09-08,IL,Israel,EURO,6866,1138697,27,7331
2021-09-09,IL,Israel,EURO,3320,1142017,29,7360
2021-09-10,IL,Israel,EURO,7961,1149978,22,7382
2021-09-11,IL,Israel,EURO,9901,1159879,17,7399
2021-09-12,IL,Israel,EURO,10292,1170171,27,7426
2021-09-13,IL,Israel,EURO,7808,1177979,22,7448
2021-09-14,IL,Israel,EURO,10954,1188933,20,7468
2021-09-15,IL,Israel,EURO,9858,1198791,29,7497
2021-09-16,IL,Israel,EURO,8865,1207656,20,7517
2021-09-17,IL,Israel,EURO,3286,1210942,21,7538
2021-09-18,IL,Israel,EURO,5024,1215966,17,7555
2021-09-19,IL,Israel,EURO,8618,1224584,17,7572
2021-09-20,IL,Israel,EURO,6554,1231138,28,7600
2021-09-21,IL,Israel,EURO,8828,1239966,15,7615
2021-09-22,IL,Israel,EURO,4828,1244794,17,7632
2021-09-23,IL,Israel,EURO,6026,1250820,19,7651
2021-09-24,IL,Israel,EURO,6452,1257272,19,7670
2021-09-25,IL,Israel,EURO,4990,1262262,21,7691
2021-09-26,IL,Israel,EURO,2653,1264915,24,7715
2021-09-27,IL,Israel,EURO,3874,1268789,14,7729
2021-09-28,IL,Israel,EURO,5246,1274035,17,7746
2021-09-29,IL,Israel,EURO,2441,1276476,21,7767
2021-09-30,IL,Israel,EURO,3636,1280112,23,7790
2021-10-01,IL,Israel,EURO,4398,1284510,14,7804
2021-10-02,IL,Israel,EURO,3622,1288132,22,7826
2021-10-03,IL,Israel,EURO,1739,1289871,18,7844
2021-10-04,IL,Israel,EURO,2700,1292571,23,7867
2021-10-05,IL,Israel,EURO,3278,1295849,11,7878
2021-10-06,IL,Israel,EURO,2556,1298405,15,7893
2021-10-07,IL,Israel,EURO,2428,1300833,15,7908
2021-10-08,IL,Israel,EURO,2120,1302953,17,7925
2021-10-09,IL,Israel,EURO,2024,1304977,6,7931
2021-10-10,IL,Israel,EURO,1040,1306017,14,7945
2021-10-11,IL,Israel,EURO,1490,1307507,14,7959
2021-10-12,IL,Israel,EURO,2343,1309850,13,7972
2021-10-13,IL,Israel,EURO,1816,1311666,10,7982
2021-10-14,IL,Israel,EURO,1772,1313438,11,7993
2021-10-15,IL,Israel,EURO,1345,1314783,14,8007
2021-10-16,IL,Israel,EURO,1575,1316358,10,8017
2021-10-17,IL,Israel,EURO,740,1317098,9,8026
2021-10-18,IL,Israel,EURO,1221,1318319,6,8032
2021-10-19,IL,Israel,EURO,1508,1319827,9,8041
2021-10-20,IL,Israel,EURO,1150,1320977,3,8044
2021-10-21,IL,Israel,EURO,1036,1322013,8,8052
2021-10-22,IL,Israel,EURO,993,1323006,7,8059
2021-10-23,IL,Israel,EURO,983,1323989,4,8063
2021-10-24,IL,Israel,EURO,332,1324321,8,8071
2021-10-25,IL,Israel,EURO,842,1325163,6,8077
2021-10-26,IL,Israel,EURO,930,1326093,11,8088
2021-10-27,IL,Israel,EURO,729,1326822,9,8097
2021-10-28,IL,Israel,EURO,648,1327470,5,8102
2021-10-29,IL,Israel,EURO,661,1328131,7,8109
2021-10-30,IL,Israel,EURO,617,1328748,6,8115
2021-10-31,IL,Israel,EURO,226,1328974,3,8118
2021-11-01,IL,Israel,EURO,528,1329502,2,8120
2021-11-02,IL,Israel,EURO,691,1330193,4,8124
2021-11-03,IL,Israel,EURO,667,1330860,3,8127
2021-11-04,IL,Israel,EURO,616,1331476,5,8132
2021-11-05,IL,Israel,EURO,519,1331995,6,8138
2021-11-06,IL,Israel,EURO,558,1332553,1,8139
2021-11-07,IL,Israel,EURO,199,1332752,1,8140
2021-11-08,IL,Israel,EURO,502,1333254,4,8144
2021-11-09,IL,Israel,EURO,566,1333820,3,8147
2021-11-10,IL,Israel,EURO,473,1334293,6,8153
2021-11-11,IL,Israel,EURO,498,1334791,5,8158
2021-11-12,IL,Israel,EURO,393,1335184,3,8161
2021-11-13,IL,Israel,EURO,448,1335632,2,8163
2021-11-14,IL,Israel,EURO,225,1335857,2,8165
2021-11-15,IL,Israel,EURO,398,1336255,0,8165
2021-11-16,IL,Israel,EURO,535,1336790,5,8170
2021-11-17,IL,Israel,EURO,558,1337348,4,8174
2021-11-18,IL,Israel,EURO,483,1337831,1,8175
2021-11-19,IL,Israel,EURO,469,1338300,3,8178
2021-11-20,IL,Israel,EURO,508,1338808,3,8181
2021-11-21,IL,Israel,EURO,237,1339045,6,8187
2021-11-22,IL,Israel,EURO,453,1339498,1,8188
2021-11-23,IL,Israel,EURO,715,1340213,2,8190
2021-11-24,IL,Israel,EURO,604,1340817,0,8190
2021-11-25,IL,Israel,EURO,543,1341360,3,8193
2021-11-26,IL,Israel,EURO,540,1341900,3,8196
2021-11-27,IL,Israel,EURO,540,1342440,2,8198
2021-11-28,IL,Israel,EURO,169,1342609,1,8199
2021-11-29,IL,Israel,EURO,542,1343151,3,8202
2021-11-30,IL,Israel,EURO,697,1343848,3,8205
2021-12-01,IL,Israel,EURO,577,1344425,3,8208
2021-12-02,IL,Israel,EURO,563,1344988,1,8209
2021-12-03,IL,Israel,EURO,519,1345507,2,8211
2021-12-04,IL,Israel,EURO,486,1345993,1,8212
2021-12-05,IL,Israel,EURO,248,1346241,2,8214
2021-12-06,IL,Israel,EURO,539,1346780,1,8215
2021-12-07,IL,Israel,EURO,739,1347519,2,8217
2021-12-08,IL,Israel,EURO,813,1348332,3,8220
2021-12-09,IL,Israel,EURO,714,1349046,6,8226
2021-12-10,IL,Israel,EURO,647,1349693,1,8227
2021-12-11,IL,Israel,EURO,607,1350300,2,8229
2021-12-12,IL,Israel,EURO,236,1350536,1,8230
2021-12-13,IL,Israel,EURO,492,1351028,2,8232
2021-12-14,IL,Israel,EURO,771,1351799,4,8236
2021-12-15,IL,Israel,EURO,702,1352501,1,8237
2021-12-16,IL,Israel,EURO,789,1353290,1,8238
2021-12-17,IL,Israel,EURO,862,1354152,1,8239
2021-12-18,IL,Israel,EURO,877,1355029,2,8241
2021-12-19,IL,Israel,EURO,393,1355422,2,8243
2021-12-20,IL,Israel,EURO,1021,1356443,2,8245
2021-12-21,IL,Israel,EURO,1330,1357773,2,8247
2021-12-22,IL,Israel,EURO,1200,1358973,0,8247
2021-12-23,IL,Israel,EURO,1417,1360390,0,8247
2021-12-24,IL,Israel,EURO,1514,1361904,1,8248
2021-12-25,IL,Israel,EURO,1789,1363693,1,8249
2021-12-26,IL,Israel,EURO,806,1364499,0,8249
2021-12-27,IL,Israel,EURO,1806,1366305,2,8251
2021-12-28,IL,Israel,EURO,2974,1369279,3,8254
2021-12-29,IL,Israel,EURO,3245,1372524,1,8255
2021-12-30,IL,Israel,EURO,4075,1376599,2,8257
2021-12-31,IL,Israel,EURO,5081,1381680,0,8257
2022-01-01,IL,Israel,EURO,5493,1387173,1,8258
2022-01-02,IL,Israel,EURO,4231,1391404,2,8260
2022-01-03,IL,Israel,EURO,6614,1398018,5,8265
2022-01-04,IL,Israel,EURO,10953,1408971,4,8269
2022-01-05,IL,Israel,EURO,12641,1421612,1,8270
2022-01-06,IL,Israel,EURO,18561,1440173,4,8274
2022-01-07,IL,Israel,EURO,19104,1459277,2,8276
2022-01-08,IL,Israel,EURO,21993,1481270,3,8279
2022-01-09,IL,Israel,EURO,22873,1504143,5,8284
2022-01-10,IL,Israel,EURO,31155,1535298,7,8291
2022-01-11,IL,Israel,EURO,41423,1576721,9,8300
2022-01-12,IL,Israel,EURO,47429,1624150,7,8307
2022-01-13,IL,Israel,EURO,48548,1672698,7,8314
2022-01-14,IL,Israel,EURO,49222,1721920,11,8325
2022-01-15,IL,Israel,EURO,45814,1767734,11,8336
2022-01-16,IL,Israel,EURO,45061,1812795,17,8353
2022-01-17,IL,Israel,EURO,64749,1877544,19,8372
2022-01-18,IL,Israel,EURO,72024,1949568,23,8395
2022-01-19,IL,Israel,EURO,73824,2023392,20,8415
2022-01-20,IL,Israel,EURO,75015,2098407,24,8439
2022-01-21,IL,Israel,EURO,75077,2173484,25,8464
2022-01-22,IL,Israel,EURO,65611,2239095,38,8502
2022-01-23,IL,Israel,EURO,67906,2307001,40,8542
2022-01-24,IL,Israel,EURO,85201,2392202,41,8583
2022-01-25,IL,Israel,EURO,83699,2475901,55,8638
2022-01-26,IL,Israel,EURO,76327,2552228,43,8681
2022-01-27,IL,Israel,EURO,67869,2620097,52,8733
2022-01-28,IL,Israel,EURO,57710,2677807,37,8770
2022-01-29,IL,Israel,EURO,53758,2731565,51,8821
2022-01-30,IL,Israel,EURO,49425,2780990,55,8876
2022-01-31,IL,Israel,EURO,74505,2855495,55,8931
2022-02-01,IL,Israel,EURO,67842,2923337,57,8988
2022-02-02,IL,Israel,EURO,60545,2983882,65,9053
2022-02-03,IL,Israel,EURO,60905,3044787,73,9126
2022-02-04,IL,Israel,EURO,46764,3091551,71,9197
2022-02-05,IL,Israel,EURO,38249,3129800,52,9249
2022-02-06,IL,Israel,EURO,33658,3163458,63,9312
2022-02-07,IL,Israel,EURO,52720,3216178,62,9374
2022-02-08,IL,Israel,EURO,44011,3260189,69,9443
2022-02-09,IL,Israel,EURO,38264,3298453,60,9503
2022-02-10,IL,Israel,EURO,37397,3335850,57,9560
2022-02-11,IL,Israel,EURO,27922,3363772,74,9634
2022-02-12,IL,Israel,EURO,22510,3386282,59,9693
2022-02-13,IL,Israel,EURO,18044,3404326,55,9748
2022-02-14,IL,Israel,EURO,31590,3435916,45,9793
2022-02-15,IL,Israel,EURO,23661,3459577,48,9841
2022-02-16,IL,Israel,EURO,20422,3479999,39,9880
2022-02-17,IL,Israel,EURO,21287,3501286,37,9917
2022-02-18,IL,Israel,EURO,15405,3516691,36,9953
2022-02-19,IL,Israel,EURO,12589,3529280,23,9976
2022-02-20,IL,Israel,EURO,10363,3539643,26,10002
2022-02-21,IL,Israel,EURO,17682,3557325,30,10032
2022-02-22,IL,Israel,EURO,12974,3570299,25,10057
2022-02-23,IL,Israel,EURO,12130,3582429,24,10081
2022-02-24,IL,Israel,EURO,11818,3594247,22,10103
2022-02-25,IL,Israel,EURO,9120,3603367,5,10108
.
80394,80451c
2021-03-02,IL,Israel,EURO,4851,782213,18,5782
2021-03-03,IL,Israel,EURO,4392,786605,21,5803
2021-03-04,IL,Israel,EURO,4669,791274,17,5820
2021-03-05,IL,Israel,EURO,3659,794933,17,5837
2021-03-06,IL,Israel,EURO,3695,798628,18,5855
2021-03-07,IL,Israel,EURO,1844,800472,20,5875
2021-03-08,IL,Israel,EURO,2364,802836,16,5891
2021-03-09,IL,Israel,EURO,3796,806632,21,5912
2021-03-10,IL,Israel,EURO,3127,809759,15,5927
2021-03-11,IL,Israel,EURO,2843,812602,17,5944
2021-03-12,IL,Israel,EURO,2553,815155,18,5962
2021-03-13,IL,Israel,EURO,2414,817569,12,5974
2021-03-14,IL,Israel,EURO,787,818356,16,5990
2021-03-15,IL,Israel,EURO,1412,819768,26,6016
2021-03-16,IL,Israel,EURO,2130,821898,17,6033
2021-03-17,IL,Israel,EURO,1566,823464,16,6049
2021-03-18,IL,Israel,EURO,1541,825005,14,6063
2021-03-19,IL,Israel,EURO,1254,826259,9,6072
2021-03-20,IL,Israel,EURO,1086,827345,12,6084
2021-03-21,IL,Israel,EURO,351,827696,7,6091
2021-03-22,IL,Israel,EURO,681,828377,14,6105
2021-03-23,IL,Israel,EURO,987,829364,14,6119
2021-03-24,IL,Israel,EURO,694,830058,14,6133
2021-03-25,IL,Israel,EURO,479,830537,10,6143
2021-03-26,IL,Israel,EURO,898,831435,9,6152
2021-03-27,IL,Israel,EURO,542,831977,11,6163
2021-03-28,IL,Israel,EURO,239,832216,6,6169
2021-03-29,IL,Israel,EURO,132,832348,13,6182
2021-03-30,IL,Israel,EURO,383,832731,11,6193
2021-03-31,IL,Israel,EURO,453,833184,13,6206
2021-04-01,IL,Israel,EURO,499,833683,14,6220
2021-04-02,IL,Israel,EURO,334,834017,8,6228
2021-04-03,IL,Israel,EURO,419,834436,15,6243
2021-04-04,IL,Israel,EURO,124,834560,7,6250
2021-04-05,IL,Israel,EURO,197,834757,8,6258
2021-04-06,IL,Israel,EURO,383,835140,6,6264
2021-04-07,IL,Israel,EURO,307,835447,8,6272
2021-04-08,IL,Israel,EURO,274,835721,9,6281
2021-04-09,IL,Israel,EURO,212,835933,9,6290
2021-04-10,IL,Israel,EURO,226,836159,10,6300
2021-04-11,IL,Israel,EURO,86,836245,9,6309
2021-04-12,IL,Israel,EURO,141,836386,6,6315
2021-04-13,IL,Israel,EURO,224,836610,6,6321
2021-04-14,IL,Israel,EURO,198,836808,13,6334
2021-04-15,IL,Israel,EURO,195,837003,3,6337
2021-04-16,IL,Israel,EURO,95,837098,3,6340
2021-04-17,IL,Israel,EURO,110,837208,5,6345
2021-04-18,IL,Israel,EURO,88,837296,7,6352
2021-04-19,IL,Israel,EURO,194,837490,4,6356
2021-04-20,IL,Israel,EURO,144,837634,3,6359
2021-04-21,IL,Israel,EURO,173,837807,4,6363
2021-04-22,IL,Israel,EURO,120,837927,2,6365
2021-04-23,IL,Israel,EURO,157,838084,2,6367
2021-04-24,IL,Israel,EURO,112,838196,5,6372
2021-04-25,IL,Israel,EURO,36,838232,4,6376
2021-04-26,IL,Israel,EURO,82,838314,1,6377
2021-04-27,IL,Israel,EURO,103,838417,3,6380
2021-04-28,IL,Israel,EURO,116,838533,6,6386
.
80154,80346c
2020-07-05,IL,Israel,EURO,820,29307,5,341
2020-07-06,IL,Israel,EURO,825,30132,2,343
2020-07-07,IL,Israel,EURO,1128,31260,8,351
2020-07-08,IL,Israel,EURO,1384,32644,5,356
2020-07-09,IL,Israel,EURO,1330,33974,5,361
2020-07-10,IL,Israel,EURO,1522,35496,5,366
2020-07-11,IL,Israel,EURO,1405,36901,4,370
2020-07-12,IL,Israel,EURO,1168,38069,5,375
2020-07-13,IL,Israel,EURO,1236,39305,7,382
2020-07-14,IL,Israel,EURO,1717,41022,4,386
2020-07-15,IL,Israel,EURO,1601,42623,7,393
2020-07-16,IL,Israel,EURO,1873,44496,6,399
2020-07-17,IL,Israel,EURO,1936,46432,9,408
2020-07-18,IL,Israel,EURO,1601,48033,12,420
2020-07-19,IL,Israel,EURO,1444,49477,8,428
2020-07-20,IL,Israel,EURO,1016,50493,10,438
2020-07-21,IL,Israel,EURO,1886,52379,12,450
2020-07-22,IL,Israel,EURO,2004,54383,9,459
2020-07-23,IL,Israel,EURO,2041,56424,6,465
2020-07-24,IL,Israel,EURO,1987,58411,16,481
2020-07-25,IL,Israel,EURO,1824,60235,8,489
2020-07-26,IL,Israel,EURO,1110,61345,7,496
2020-07-27,IL,Israel,EURO,1040,62385,11,507
2020-07-28,IL,Israel,EURO,2048,64433,7,514
2020-07-29,IL,Israel,EURO,2120,66553,8,522
2020-07-30,IL,Israel,EURO,1957,68510,15,537
2020-07-31,IL,Israel,EURO,1786,70296,15,552
2020-08-01,IL,Israel,EURO,1359,71655,14,566
2020-08-02,IL,Israel,EURO,623,72278,14,580
2020-08-03,IL,Israel,EURO,708,72986,12,592
2020-08-04,IL,Israel,EURO,1799,74785,15,607
2020-08-05,IL,Israel,EURO,1726,76511,11,618
2020-08-06,IL,Israel,EURO,1686,78197,10,628
2020-08-07,IL,Israel,EURO,1675,79872,9,637
2020-08-08,IL,Israel,EURO,1761,81633,12,649
2020-08-09,IL,Israel,EURO,754,82387,13,662
2020-08-10,IL,Israel,EURO,922,83309,8,670
2020-08-11,IL,Israel,EURO,1697,85006,15,685
2020-08-12,IL,Israel,EURO,1823,86829,11,696
2020-08-13,IL,Israel,EURO,1617,88446,16,712
2020-08-14,IL,Israel,EURO,1640,90086,16,728
2020-08-15,IL,Israel,EURO,1389,91475,12,740
2020-08-16,IL,Israel,EURO,754,92229,10,750
2020-08-17,IL,Israel,EURO,1069,93298,20,770
2020-08-18,IL,Israel,EURO,1649,94947,4,774
2020-08-19,IL,Israel,EURO,1647,96594,14,788
2020-08-20,IL,Israel,EURO,1639,98233,12,800
2020-08-21,IL,Israel,EURO,1485,99718,14,814
2020-08-22,IL,Israel,EURO,1491,101209,13,827
2020-08-23,IL,Israel,EURO,710,101919,10,837
2020-08-24,IL,Israel,EURO,964,102883,13,850
2020-08-25,IL,Israel,EURO,1901,104784,16,866
2020-08-26,IL,Israel,EURO,1958,106742,19,885
2020-08-27,IL,Israel,EURO,1984,108726,11,896
2020-08-28,IL,Israel,EURO,2106,110832,11,907
2020-08-29,IL,Israel,EURO,1833,112665,13,920
2020-08-30,IL,Israel,EURO,908,113573,5,925
2020-08-31,IL,Israel,EURO,1099,114672,14,939
2020-09-01,IL,Israel,EURO,2171,116843,23,962
2020-09-02,IL,Israel,EURO,2255,119098,15,977
2020-09-03,IL,Israel,EURO,3194,122292,13,990
2020-09-04,IL,Israel,EURO,2666,124958,16,1006
2020-09-05,IL,Israel,EURO,2623,127581,12,1018
2020-09-06,IL,Israel,EURO,1504,129085,15,1033
2020-09-07,IL,Israel,EURO,2176,131261,12,1045
2020-09-08,IL,Israel,EURO,3386,134647,17,1062
2020-09-09,IL,Israel,EURO,3488,138135,20,1082
2020-09-10,IL,Israel,EURO,3991,142126,15,1097
2020-09-11,IL,Israel,EURO,4153,146279,14,1111
2020-09-12,IL,Israel,EURO,3973,150252,20,1131
2020-09-13,IL,Israel,EURO,2718,152970,15,1146
2020-09-14,IL,Israel,EURO,3172,156142,17,1163
2020-09-15,IL,Israel,EURO,4803,160945,20,1183
2020-09-16,IL,Israel,EURO,5528,166473,16,1199
2020-09-17,IL,Israel,EURO,4568,171041,26,1225
2020-09-18,IL,Israel,EURO,5378,176419,17,1242
2020-09-19,IL,Israel,EURO,5333,181752,21,1263
2020-09-20,IL,Israel,EURO,3809,185561,28,1291
2020-09-21,IL,Israel,EURO,2576,188137,21,1312
2020-09-22,IL,Israel,EURO,3870,192007,32,1344
2020-09-23,IL,Israel,EURO,7017,199024,25,1369
2020-09-24,IL,Israel,EURO,7142,206166,25,1394
2020-09-25,IL,Israel,EURO,8259,214425,31,1425
2020-09-26,IL,Israel,EURO,8388,222813,29,1454
2020-09-27,IL,Israel,EURO,5881,228694,27,1481
2020-09-28,IL,Israel,EURO,3436,232130,31,1512
2020-09-29,IL,Israel,EURO,1154,233284,29,1541
2020-09-30,IL,Israel,EURO,4988,238272,35,1576
2020-10-01,IL,Israel,EURO,9051,247323,37,1613
2020-10-02,IL,Israel,EURO,7720,255043,46,1659
2020-10-03,IL,Israel,EURO,7053,262096,25,1684
2020-10-04,IL,Israel,EURO,2593,264689,38,1722
2020-10-05,IL,Israel,EURO,2932,267621,37,1759
2020-10-06,IL,Israel,EURO,5702,273323,27,1786
2020-10-07,IL,Israel,EURO,4717,278040,45,1831
2020-10-08,IL,Israel,EURO,4153,282193,26,1857
2020-10-09,IL,Israel,EURO,3752,285945,47,1904
2020-10-10,IL,Israel,EURO,2954,288899,40,1944
2020-10-11,IL,Israel,EURO,916,289815,35,1979
2020-10-12,IL,Israel,EURO,1638,291453,45,2024
2020-10-13,IL,Israel,EURO,3154,294607,30,2054
2020-10-14,IL,Israel,EURO,2335,296942,37,2091
2020-10-15,IL,Israel,EURO,2118,299060,34,2125
2020-10-16,IL,Israel,EURO,1609,300669,32,2157
2020-10-17,IL,Israel,EURO,1496,302165,35,2192
2020-10-18,IL,Israel,EURO,410,302575,32,2224
2020-10-19,IL,Israel,EURO,923,303498,33,2257
2020-10-20,IL,Israel,EURO,1516,305014,31,2288
2020-10-21,IL,Israel,EURO,1192,306206,20,2308
2020-10-22,IL,Israel,EURO,1170,307376,25,2333
2020-10-23,IL,Israel,EURO,1031,308407,29,2362
2020-10-24,IL,Israel,EURO,849,309256,26,2388
2020-10-25,IL,Israel,EURO,247,309503,26,2414
2020-10-26,IL,Israel,EURO,604,310107,34,2448
2020-10-27,IL,Israel,EURO,883,310990,28,2476
2020-10-28,IL,Israel,EURO,885,311875,28,2504
2020-10-29,IL,Israel,EURO,724,312599,10,2514
2020-10-30,IL,Israel,EURO,647,313246,19,2533
2020-10-31,IL,Israel,EURO,681,313927,12,2545
2020-11-01,IL,Israel,EURO,228,314155,25,2570
2020-11-02,IL,Israel,EURO,657,314812,19,2589
2020-11-03,IL,Israel,EURO,792,315604,15,2604
2020-11-04,IL,Israel,EURO,844,316448,26,2630
2020-11-05,IL,Israel,EURO,769,317217,15,2645
2020-11-06,IL,Israel,EURO,568,317785,14,2659
2020-11-07,IL,Israel,EURO,689,318474,16,2675
2020-11-08,IL,Israel,EURO,212,318686,8,2683
2020-11-09,IL,Israel,EURO,535,319221,7,2690
2020-11-10,IL,Israel,EURO,723,319944,8,2698
2020-11-11,IL,Israel,EURO,673,320617,10,2708
2020-11-12,IL,Israel,EURO,768,321385,7,2715
2020-11-13,IL,Israel,EURO,837,322222,12,2727
2020-11-14,IL,Israel,EURO,761,322983,5,2732
2020-11-15,IL,Israel,EURO,292,323275,11,2743
2020-11-16,IL,Israel,EURO,627,323902,14,2757
2020-11-17,IL,Israel,EURO,874,324776,9,2766
2020-11-18,IL,Israel,EURO,830,325606,12,2778
2020-11-19,IL,Israel,EURO,797,326403,7,2785
2020-11-20,IL,Israel,EURO,771,327174,8,2793
2020-11-21,IL,Israel,EURO,772,327946,6,2799
2020-11-22,IL,Israel,EURO,423,328369,12,2811
2020-11-23,IL,Israel,EURO,763,329132,16,2827
2020-11-24,IL,Israel,EURO,961,330093,7,2834
2020-11-25,IL,Israel,EURO,859,330952,5,2839
2020-11-26,IL,Israel,EURO,1081,332033,5,2844
2020-11-27,IL,Israel,EURO,1085,333118,9,2853
2020-11-28,IL,Israel,EURO,1033,334151,7,2860
2020-11-29,IL,Israel,EURO,582,334733,9,2869
2020-11-30,IL,Israel,EURO,1026,335759,10,2879
2020-12-01,IL,Israel,EURO,1257,337016,6,2885
2020-12-02,IL,Israel,EURO,1200,338216,10,2895
2020-12-03,IL,Israel,EURO,1588,339804,5,2900
2020-12-04,IL,Israel,EURO,1448,341252,10,2910
2020-12-05,IL,Israel,EURO,1515,342767,9,2919
2020-12-06,IL,Israel,EURO,1000,343767,10,2929
2020-12-07,IL,Israel,EURO,1357,345124,8,2937
2020-12-08,IL,Israel,EURO,1863,346987,7,2944
2020-12-09,IL,Israel,EURO,1769,348756,12,2956
2020-12-10,IL,Israel,EURO,1869,350625,13,2969
2020-12-11,IL,Israel,EURO,2007,352632,13,2982
2020-12-12,IL,Israel,EURO,1835,354467,11,2993
2020-12-13,IL,Israel,EURO,1298,355765,16,3009
2020-12-14,IL,Israel,EURO,1727,357492,9,3018
2020-12-15,IL,Israel,EURO,2322,359814,11,3029
2020-12-16,IL,Israel,EURO,2893,362707,15,3044
2020-12-17,IL,Israel,EURO,2860,365567,15,3059
2020-12-18,IL,Israel,EURO,2847,368414,17,3076
2020-12-19,IL,Israel,EURO,2793,371207,16,3092
2020-12-20,IL,Israel,EURO,1889,373096,20,3112
2020-12-21,IL,Israel,EURO,3095,376191,18,3130
2020-12-22,IL,Israel,EURO,3860,380051,16,3146
2020-12-23,IL,Israel,EURO,4381,384432,13,3159
2020-12-24,IL,Israel,EURO,4039,388471,25,3184
2020-12-25,IL,Israel,EURO,4050,392521,15,3199
2020-12-26,IL,Israel,EURO,4006,396527,21,3220
2020-12-27,IL,Israel,EURO,2660,399187,23,3243
2020-12-28,IL,Israel,EURO,3534,402721,21,3264
2020-12-29,IL,Israel,EURO,5522,408243,32,3296
2020-12-30,IL,Israel,EURO,5632,413875,25,3321
2020-12-31,IL,Israel,EURO,5870,419745,16,3337
2021-01-01,IL,Israel,EURO,5866,425611,36,3373
2021-01-02,IL,Israel,EURO,6014,431625,34,3407
2021-01-03,IL,Israel,EURO,4212,435837,27,3434
2021-01-04,IL,Israel,EURO,5232,441069,26,3460
2021-01-05,IL,Israel,EURO,8424,449493,38,3498
2021-01-06,IL,Israel,EURO,8230,457723,23,3521
2021-01-07,IL,Israel,EURO,7884,465607,43,3564
2021-01-08,IL,Israel,EURO,7663,473270,48,3612
2021-01-09,IL,Israel,EURO,8162,481432,46,3658
2021-01-10,IL,Israel,EURO,5165,486597,20,3678
2021-01-11,IL,Israel,EURO,6954,493551,43,3721
2021-01-12,IL,Israel,EURO,9730,503281,28,3749
2021-01-13,IL,Israel,EURO,9297,512578,55,3804
.
79969a
2022-02-25,IM,Isle of Man,EURO,69,22577,1,80
.
79185a
2022-02-25,IE,Ireland,EURO,3729,1287908,11,6471
.
78401a
2022-02-25,IQ,Iraq,EMRO,1499,2298164,14,24931
.
77617a
2022-02-25,IR,Iran (Islamic Republic of),EMRO,12957,7011932,226,135952
.
76833a
2022-02-25,ID,Indonesia,SEARO,49447,5457775,244,147586
.
76049a
2022-02-25,IN,India,SEARO,13166,42894345,302,513226
.
75265a
2022-02-25,IS,Iceland,EURO,3443,118684,1,61
.
74481a
2022-02-25,HU,Hungary,EURO,4498,1779174,88,43752
.
73697a
2022-02-25,HN,Honduras,AMRO,0,409708,0,10684
.
72913a
2022-02-25,VA,Holy See,EURO,0,26,0,0
.
72127,72129c
2022-02-22,HT,Haiti,AMRO,27,30314,1,820
2022-02-23,HT,Haiti,AMRO,22,30336,0,820
2022-02-24,HT,Haiti,AMRO,0,30336,0,820
2022-02-25,HT,Haiti,AMRO,0,30336,0,820
.
71345a
2022-02-25,GY,Guyana,AMRO,33,62779,0,1215
.
70561a
2022-02-25,GW,Guinea-Bissau,AFRO,0,7972,0,166
.
69777a
2022-02-25,GN,Guinea,AFRO,0,36393,0,440
.
68993a
2022-02-25,GG,Guernsey,EURO,0,13503,0,31
.
68209a
2022-02-25,GT,Guatemala,AMRO,4379,766475,28,16861
.
67425a
2022-02-25,GU,Guam,WPRO,0,36588,1,321
.
66641a
2022-02-25,GP,Guadeloupe,AMRO,0,122211,0,909
.
65857a
2022-02-25,GD,Grenada,AMRO,61,13626,0,214
.
65073a
2022-02-25,GL,Greenland,EURO,26,11715,0,16
.
64289a
2022-02-25,GR,Greece,EURO,15819,2369396,65,25603
.
63505a
2022-02-25,GI,Gibraltar,EURO,86,15256,0,101
.
62721a
2022-02-25,GH,Ghana,AFRO,0,159124,0,1442
.
61937a
2022-02-25,DE,Germany,EURO,210743,14399012,226,122371
.
61153a
2022-02-25,GE,Georgia,EURO,7482,1591936,32,16054
.
60369a
2022-02-25,GM,Gambia,AFRO,0,11924,0,365
.
59585a
2022-02-25,GA,Gabon,AFRO,0,47520,0,303
.
58801a
2022-02-25,PF,French Polynesia,WPRO,0,65583,0,638
.
58017a
2022-02-25,GF,French Guiana,AMRO,18,77625,0,391
.
57233a
2022-02-25,FR,France,EURO,66714,21879794,281,134723
.
56449a
2022-02-25,FI,Finland,EURO,71,637729,0,2364
.
55665a
2022-02-25,FJ,Fiji,WPRO,0,63687,0,826
.
54881a
2022-02-25,FO,Faroe Islands,EURO,407,33590,1,26
.
54097a
2022-02-25,FK,Falkland Islands (Malvinas),AMRO,0,109,0,0
.
53313a
2022-02-25,ET,Ethiopia,AFRO,69,468564,4,7450
.
52529a
2022-02-25,SZ,Eswatini,AFRO,45,69095,0,1390
.
51745a
2022-02-25,EE,Estonia,EURO,5014,483955,9,2204
.
50961a
2022-02-25,ER,Eritrea,AFRO,2,9696,0,103
.
50177a
2022-02-25,GQ,Equatorial Guinea,AFRO,3,15877,0,182
.
49393a
2022-02-25,SV,El Salvador,AMRO,0,147786,4,4058
.
48609a
2022-02-25,EG,Egypt,EMRO,0,475341,0,23889
.
47825a
2022-02-25,EC,Ecuador,AMRO,0,820541,0,35172
.
47041a
2022-02-25,DO,Dominican Republic,AMRO,862,573458,3,4363
.
46257c
2022-02-24,DM,Dominica,AMRO,38,10991,0,57
2022-02-25,DM,Dominica,AMRO,0,10991,0,57
.
45473a
2022-02-25,DJ,Djibouti,EMRO,0,15543,0,189
.
44689a
2022-02-25,DK,Denmark,EURO,25209,2691663,39,4461
.
43905a
2022-02-25,CD,Democratic Republic of the Congo,AFRO,61,85999,0,1335
.
43121a
2022-02-25,KP,Democratic People's Republic of Korea,SEARO,0,0,0,0
.
41778,42337c
2020-08-14,CZ,Czechia,EURO,331,19454,1,396
2020-08-15,CZ,Czechia,EURO,291,19745,2,398
2020-08-16,CZ,Czechia,EURO,197,19942,2,400
2020-08-17,CZ,Czechia,EURO,121,20063,2,402
2020-08-18,CZ,Czechia,EURO,191,20254,4,406
2020-08-19,CZ,Czechia,EURO,281,20535,0,406
2020-08-20,CZ,Czechia,EURO,313,20848,3,409
2020-08-21,CZ,Czechia,EURO,246,21094,3,412
2020-08-22,CZ,Czechia,EURO,506,21600,3,415
2020-08-23,CZ,Czechia,EURO,234,21834,0,415
2020-08-24,CZ,Czechia,EURO,136,21970,3,418
2020-08-25,CZ,Czechia,EURO,259,22229,1,419
2020-08-26,CZ,Czechia,EURO,364,22593,2,421
2020-08-27,CZ,Czechia,EURO,396,22989,1,422
2020-08-28,CZ,Czechia,EURO,350,23339,0,422
2020-08-29,CZ,Czechia,EURO,485,23824,0,422
2020-08-30,CZ,Czechia,EURO,320,24144,3,425
2020-08-31,CZ,Czechia,EURO,275,24419,1,426
2020-09-01,CZ,Czechia,EURO,256,24675,1,427
2020-09-02,CZ,Czechia,EURO,497,25172,1,428
2020-09-03,CZ,Czechia,EURO,645,25817,0,428
2020-09-04,CZ,Czechia,EURO,675,26492,4,432
2020-09-05,CZ,Czechia,EURO,797,27289,3,435
2020-09-06,CZ,Czechia,EURO,504,27793,5,440
2020-09-07,CZ,Czechia,EURO,410,28203,3,443
2020-09-08,CZ,Czechia,EURO,561,28764,2,445
2020-09-09,CZ,Czechia,EURO,1161,29925,5,450
2020-09-10,CZ,Czechia,EURO,1158,31083,3,453
2020-09-11,CZ,Czechia,EURO,1383,32466,5,458
2020-09-12,CZ,Czechia,EURO,1442,33908,3,461
2020-09-13,CZ,Czechia,EURO,1537,35445,6,467
2020-09-14,CZ,Czechia,EURO,791,36236,5,472
2020-09-15,CZ,Czechia,EURO,1028,37264,6,478
2020-09-16,CZ,Czechia,EURO,1676,38940,10,488
2020-09-17,CZ,Czechia,EURO,2133,41073,7,495
2020-09-18,CZ,Czechia,EURO,3125,44198,7,502
2020-09-19,CZ,Czechia,EURO,2108,46306,12,514
2020-09-20,CZ,Czechia,EURO,2045,48351,8,522
2020-09-21,CZ,Czechia,EURO,984,49335,6,528
2020-09-22,CZ,Czechia,EURO,1477,50812,15,543
2020-09-23,CZ,Czechia,EURO,2387,53199,10,553
2020-09-24,CZ,Czechia,EURO,2305,55504,22,575
2020-09-25,CZ,Czechia,EURO,2906,58410,10,585
2020-09-26,CZ,Czechia,EURO,2945,61355,10,595
2020-09-27,CZ,Czechia,EURO,1981,63336,16,611
2020-09-28,CZ,Czechia,EURO,1305,64641,16,627
2020-09-29,CZ,Czechia,EURO,1284,65925,11,638
2020-09-30,CZ,Czechia,EURO,1962,67887,21,659
2020-10-01,CZ,Czechia,EURO,2925,70812,16,675
2020-10-02,CZ,Czechia,EURO,3503,74315,29,704
2020-10-03,CZ,Czechia,EURO,3795,78110,21,725
2020-10-04,CZ,Czechia,EURO,2554,80664,13,738
2020-10-05,CZ,Czechia,EURO,1841,82505,35,773
2020-10-06,CZ,Czechia,EURO,3117,85622,29,802
2020-10-07,CZ,Czechia,EURO,4458,90080,38,840
2020-10-08,CZ,Czechia,EURO,5336,95416,51,891
2020-10-09,CZ,Czechia,EURO,5394,100810,26,917
2020-10-10,CZ,Czechia,EURO,8618,109428,61,978
2020-10-11,CZ,Czechia,EURO,4637,114065,53,1031
2020-10-12,CZ,Czechia,EURO,3104,117169,43,1074
2020-10-13,CZ,Czechia,EURO,4307,121476,70,1144
2020-10-14,CZ,Czechia,EURO,8324,129800,53,1197
2020-10-15,CZ,Czechia,EURO,9544,139344,67,1264
2020-10-16,CZ,Czechia,EURO,9724,149068,63,1327
2020-10-17,CZ,Czechia,EURO,11104,160172,80,1407
2020-10-18,CZ,Czechia,EURO,8713,168885,81,1488
2020-10-19,CZ,Czechia,EURO,5059,173944,82,1570
2020-10-20,CZ,Czechia,EURO,8078,182022,110,1680
2020-10-21,CZ,Czechia,EURO,11985,194007,109,1789
2020-10-22,CZ,Czechia,EURO,14971,208978,131,1920
2020-10-23,CZ,Czechia,EURO,14158,223136,127,2047
2020-10-24,CZ,Czechia,EURO,15248,238384,125,2172
2020-10-25,CZ,Czechia,EURO,12473,250857,143,2315
2020-10-26,CZ,Czechia,EURO,7300,258157,154,2469
2020-10-27,CZ,Czechia,EURO,10275,268432,163,2632
2020-10-28,CZ,Czechia,EURO,15667,284099,195,2827
2020-10-29,CZ,Czechia,EURO,12977,297076,168,2995
2020-10-30,CZ,Czechia,EURO,13050,310126,199,3194
2020-10-31,CZ,Czechia,EURO,13605,323731,217,3411
2020-11-01,CZ,Czechia,EURO,11428,335159,193,3604
2020-11-02,CZ,Czechia,EURO,6551,341710,224,3828
2020-11-03,CZ,Czechia,EURO,9241,350951,223,4051
2020-11-04,CZ,Czechia,EURO,12090,363041,261,4312
2020-11-05,CZ,Czechia,EURO,15726,378767,228,4540
2020-11-06,CZ,Czechia,EURO,13237,392004,196,4736
2020-11-07,CZ,Czechia,EURO,11546,403550,217,4953
2020-11-08,CZ,Czechia,EURO,7721,411271,203,5156
2020-11-09,CZ,Czechia,EURO,3611,414882,206,5362
2020-11-10,CZ,Czechia,EURO,6048,420930,186,5548
2020-11-11,CZ,Czechia,EURO,9057,429987,215,5763
2020-11-12,CZ,Czechia,EURO,8919,438906,184,5947
2020-11-13,CZ,Czechia,EURO,7874,446780,174,6121
2020-11-14,CZ,Czechia,EURO,7358,454138,181,6302
2020-11-15,CZ,Czechia,EURO,4196,458334,185,6487
2020-11-16,CZ,Czechia,EURO,1891,460225,152,6639
2020-11-17,CZ,Czechia,EURO,5423,465648,173,6812
2020-11-18,CZ,Czechia,EURO,4246,469894,139,6951
2020-11-19,CZ,Czechia,EURO,5514,475408,155,7106
2020-11-20,CZ,Czechia,EURO,6470,481878,134,7240
2020-11-21,CZ,Czechia,EURO,5809,487687,117,7357
2020-11-22,CZ,Czechia,EURO,3191,490878,132,7489
2020-11-23,CZ,Czechia,EURO,1508,492386,126,7615
2020-11-24,CZ,Czechia,EURO,4379,496765,129,7744
2020-11-25,CZ,Czechia,EURO,5861,502626,136,7880
2020-11-26,CZ,Czechia,EURO,4929,507555,123,8003
2020-11-27,CZ,Czechia,EURO,4049,511604,130,8133
2020-11-28,CZ,Czechia,EURO,4463,516067,138,8271
2020-11-29,CZ,Czechia,EURO,2668,518735,117,8388
2020-11-30,CZ,Czechia,EURO,1074,519809,95,8483
2020-12-01,CZ,Czechia,EURO,3573,523382,126,8609
2020-12-02,CZ,Czechia,EURO,5181,528563,100,8709
2020-12-03,CZ,Czechia,EURO,4561,533124,116,8825
2020-12-04,CZ,Czechia,EURO,4624,537748,102,8927
2020-12-05,CZ,Czechia,EURO,4747,542495,92,9019
2020-12-06,CZ,Czechia,EURO,3313,545808,129,9148
2020-12-07,CZ,Czechia,EURO,1112,546920,91,9239
2020-12-08,CZ,Czechia,EURO,4251,551171,94,9333
2020-12-09,CZ,Czechia,EURO,5855,557026,95,9428
2020-12-10,CZ,Czechia,EURO,6417,563443,82,9510
2020-12-11,CZ,Czechia,EURO,5877,569320,116,9626
2020-12-12,CZ,Czechia,EURO,6210,575530,105,9731
2020-12-13,CZ,Czechia,EURO,3655,579185,97,9828
2020-12-14,CZ,Czechia,EURO,1998,581183,108,9936
2020-12-15,CZ,Czechia,EURO,5179,586362,130,10066
2020-12-16,CZ,Czechia,EURO,7914,594276,105,10171
2020-12-17,CZ,Czechia,EURO,8264,602540,114,10285
2020-12-18,CZ,Czechia,EURO,7618,610158,106,10391
2020-12-19,CZ,Czechia,EURO,8857,619015,100,10491
2020-12-20,CZ,Czechia,EURO,5359,624374,114,10605
2020-12-21,CZ,Czechia,EURO,3420,627794,98,10703
2020-12-22,CZ,Czechia,EURO,7977,635771,104,10807
2020-12-23,CZ,Czechia,EURO,10957,646728,102,10909
2020-12-24,CZ,Czechia,EURO,14178,660906,115,11024
2020-12-25,CZ,Czechia,EURO,4382,665288,111,11135
2020-12-26,CZ,Czechia,EURO,2680,667968,106,11241
2020-12-27,CZ,Czechia,EURO,3046,671014,125,11366
2020-12-28,CZ,Czechia,EURO,3799,674813,108,11474
2020-12-29,CZ,Czechia,EURO,11011,685824,131,11605
2020-12-30,CZ,Czechia,EURO,16549,702373,132,11737
2020-12-31,CZ,Czechia,EURO,17126,719499,150,11887
2021-01-01,CZ,Czechia,EURO,13338,732837,129,12016
2021-01-02,CZ,Czechia,EURO,3460,736297,152,12168
2021-01-03,CZ,Czechia,EURO,5003,741300,152,12320
2021-01-04,CZ,Czechia,EURO,6295,747595,141,12461
2021-01-05,CZ,Czechia,EURO,13006,760601,152,12613
2021-01-06,CZ,Czechia,EURO,17469,778070,181,12794
2021-01-07,CZ,Czechia,EURO,17878,795948,162,12956
2021-01-08,CZ,Czechia,EURO,14995,810943,187,13143
2021-01-09,CZ,Czechia,EURO,13171,824114,197,13340
2021-01-10,CZ,Czechia,EURO,8487,832601,165,13505
2021-01-11,CZ,Czechia,EURO,4338,836939,184,13689
2021-01-12,CZ,Czechia,EURO,9445,846384,163,13852
2021-01-13,CZ,Czechia,EURO,10835,857219,177,14029
2021-01-14,CZ,Czechia,EURO,10954,868173,164,14193
2021-01-15,CZ,Czechia,EURO,8126,876299,181,14374
2021-01-16,CZ,Czechia,EURO,9349,885648,165,14539
2021-01-17,CZ,Czechia,EURO,5256,890904,156,14695
2021-01-18,CZ,Czechia,EURO,2653,893557,158,14853
2021-01-19,CZ,Czechia,EURO,7699,901256,160,15013
2021-01-20,CZ,Czechia,EURO,9636,910892,157,15170
2021-01-21,CZ,Czechia,EURO,8246,919138,148,15318
2021-01-22,CZ,Czechia,EURO,7591,926729,152,15470
2021-01-23,CZ,Czechia,EURO,8496,935225,136,15606
2021-01-24,CZ,Czechia,EURO,4250,939475,143,15749
2021-01-25,CZ,Czechia,EURO,2413,941888,145,15894
2021-01-26,CZ,Czechia,EURO,7012,948900,140,16034
2021-01-27,CZ,Czechia,EURO,9215,958115,143,16177
2021-01-28,CZ,Czechia,EURO,8549,966664,160,16337
2021-01-29,CZ,Czechia,EURO,8042,974706,135,16472
2021-01-30,CZ,Czechia,EURO,8070,982776,152,16624
2021-01-31,CZ,Czechia,EURO,4069,986845,126,16750
2021-02-01,CZ,Czechia,EURO,2586,989431,120,16870
2021-02-02,CZ,Czechia,EURO,7260,996691,133,17003
2021-02-03,CZ,Czechia,EURO,9172,1005863,135,17138
2021-02-04,CZ,Czechia,EURO,9689,1015552,137,17275
2021-02-05,CZ,Czechia,EURO,8121,1023673,129,17404
2021-02-06,CZ,Czechia,EURO,8643,1032316,127,17531
2021-02-07,CZ,Czechia,EURO,4827,1037143,128,17659
2021-02-08,CZ,Czechia,EURO,2459,1039602,131,17790
2021-02-09,CZ,Czechia,EURO,7822,1047424,139,17929
2021-02-10,CZ,Czechia,EURO,10313,1057737,133,18062
2021-02-11,CZ,Czechia,EURO,9578,1067315,133,18195
2021-02-12,CZ,Czechia,EURO,9050,1076365,130,18325
2021-02-13,CZ,Czechia,EURO,8852,1085217,144,18469
2021-02-14,CZ,Czechia,EURO,5151,1090368,117,18586
2021-02-15,CZ,Czechia,EURO,2886,1093254,150,18736
2021-02-16,CZ,Czechia,EURO,8925,1102179,130,18866
2021-02-17,CZ,Czechia,EURO,12627,1114806,150,19016
2021-02-18,CZ,Czechia,EURO,10961,1125767,132,19148
2021-02-19,CZ,Czechia,EURO,11727,1137494,173,19321
2021-02-20,CZ,Czechia,EURO,11305,1148799,181,19502
2021-02-21,CZ,Czechia,EURO,6784,1155583,177,19679
2021-02-22,CZ,Czechia,EURO,4076,1159659,148,19827
2021-02-23,CZ,Czechia,EURO,11456,1171115,165,19992
2021-02-24,CZ,Czechia,EURO,15870,1186985,148,20140
2021-02-25,CZ,Czechia,EURO,13830,1200815,143,20283
2021-02-26,CZ,Czechia,EURO,14615,1215430,182,20465
2021-02-27,CZ,Czechia,EURO,14833,1230263,191,20656
2021-02-28,CZ,Czechia,EURO,7869,1238132,193,20849
2021-03-01,CZ,Czechia,EURO,4602,1242734,183,21032
2021-03-02,CZ,Czechia,EURO,12371,1255105,205,21237
2021-03-03,CZ,Czechia,EURO,16821,1271926,193,21430
2021-03-04,CZ,Czechia,EURO,15270,1287196,201,21631
2021-03-05,CZ,Czechia,EURO,14677,1301873,218,21849
2021-03-06,CZ,Czechia,EURO,13193,1315066,186,22035
2021-03-07,CZ,Czechia,EURO,9139,1324205,209,22244
2021-03-08,CZ,Czechia,EURO,4005,1328210,204,22448
2021-03-09,CZ,Czechia,EURO,10702,1338912,236,22684
2021-03-10,CZ,Czechia,EURO,15405,1354317,231,22915
2021-03-11,CZ,Czechia,EURO,14593,1368910,229,23144
2021-03-12,CZ,Czechia,EURO,11289,1380199,229,23373
2021-03-13,CZ,Czechia,EURO,14995,1395194,213,23586
2021-03-14,CZ,Czechia,EURO,7053,1402247,178,23764
2021-03-15,CZ,Czechia,EURO,3354,1405601,229,23993
2021-03-16,CZ,Czechia,EURO,10664,1416265,238,24231
2021-03-17,CZ,Czechia,EURO,14085,1430350,219,24450
2021-03-18,CZ,Czechia,EURO,12085,1442435,199,24649
2021-03-19,CZ,Czechia,EURO,10726,1453161,214,24863
2021-03-20,CZ,Czechia,EURO,9754,1462915,174,25037
2021-03-21,CZ,Czechia,EURO,5519,1468434,185,25222
2021-03-22,CZ,Czechia,EURO,2400,1470834,193,25415
2021-03-23,CZ,Czechia,EURO,8267,1479101,210,25625
2021-03-24,CZ,Czechia,EURO,11004,1490105,193,25818
2021-03-25,CZ,Czechia,EURO,8884,1498989,185,26003
2021-03-26,CZ,Czechia,EURO,7954,1506943,161,26164
2021-03-27,CZ,Czechia,EURO,7753,1514696,155,26319
2021-03-28,CZ,Czechia,EURO,3983,1518679,181,26500
2021-03-29,CZ,Czechia,EURO,1747,1520426,117,26617
2021-03-30,CZ,Czechia,EURO,6958,1527384,181,26798
2021-03-31,CZ,Czechia,EURO,8657,1536041,171,26969
2021-04-01,CZ,Czechia,EURO,7281,1543322,153,27122
2021-04-02,CZ,Czechia,EURO,6259,1549581,152,27274
2021-04-03,CZ,Czechia,EURO,3854,1553435,104,27378
2021-04-04,CZ,Czechia,EURO,2162,1555597,126,27504
2021-04-05,CZ,Czechia,EURO,1933,1557530,146,27650
2021-04-06,CZ,Czechia,EURO,1437,1558967,124,27774
2021-04-07,CZ,Czechia,EURO,5602,1564569,115,27889
2021-04-08,CZ,Czechia,EURO,7065,1571634,121,28010
2021-04-09,CZ,Czechia,EURO,5305,1576939,122,28132
2021-04-10,CZ,Czechia,EURO,4851,1581790,107,28239
2021-04-11,CZ,Czechia,EURO,2221,1584011,110,28349
2021-04-12,CZ,Czechia,EURO,987,1584998,93,28442
2021-04-13,CZ,Czechia,EURO,3884,1588882,84,28526
2021-04-14,CZ,Czechia,EURO,5094,1593976,91,28617
2021-04-15,CZ,Czechia,EURO,3728,1597704,90,28707
2021-04-16,CZ,Czechia,EURO,3286,1600990,86,28793
2021-04-17,CZ,Czechia,EURO,3229,1604219,66,28859
2021-04-18,CZ,Czechia,EURO,1546,1605765,74,28933
2021-04-19,CZ,Czechia,EURO,844,1606609,78,29011
2021-04-20,CZ,Czechia,EURO,3353,1609962,72,29083
2021-04-21,CZ,Czechia,EURO,3821,1613783,64,29147
2021-04-22,CZ,Czechia,EURO,2968,1616751,64,29211
2021-04-23,CZ,Czechia,EURO,2639,1619390,56,29267
2021-04-24,CZ,Czechia,EURO,2615,1622005,54,29321
2021-04-25,CZ,Czechia,EURO,1319,1623324,57,29378
2021-04-26,CZ,Czechia,EURO,832,1624156,53,29431
2021-04-27,CZ,Czechia,EURO,2605,1626761,58,29489
2021-04-28,CZ,Czechia,EURO,3259,1630020,51,29540
2021-04-29,CZ,Czechia,EURO,2499,1632519,67,29607
2021-04-30,CZ,Czechia,EURO,2238,1634757,43,29650
2021-05-01,CZ,Czechia,EURO,2185,1636942,49,29699
2021-05-02,CZ,Czechia,EURO,1179,1638121,33,29732
2021-05-03,CZ,Czechia,EURO,514,1638635,34,29766
2021-05-04,CZ,Czechia,EURO,2226,1640861,39,29805
2021-05-05,CZ,Czechia,EURO,2427,1643288,44,29849
2021-05-06,CZ,Czechia,EURO,1887,1645175,37,29886
2021-05-07,CZ,Czechia,EURO,1582,1646757,43,29929
2021-05-08,CZ,Czechia,EURO,1650,1648407,29,29958
2021-05-09,CZ,Czechia,EURO,731,1649138,31,29989
2021-05-10,CZ,Czechia,EURO,388,1649526,35,30024
2021-05-11,CZ,Czechia,EURO,1557,1651083,33,30057
2021-05-12,CZ,Czechia,EURO,1701,1652784,33,30090
2021-05-13,CZ,Czechia,EURO,1274,1654058,33,30123
2021-05-14,CZ,Czechia,EURO,1233,1655291,21,30144
2021-05-15,CZ,Czechia,EURO,1058,1656349,18,30162
2021-05-16,CZ,Czechia,EURO,599,1656948,16,30178
2021-05-17,CZ,Czechia,EURO,260,1657208,13,30191
2021-05-18,CZ,Czechia,EURO,1144,1658352,23,30214
2021-05-19,CZ,Czechia,EURO,1211,1659563,14,30228
2021-05-20,CZ,Czechia,EURO,785,1660348,17,30245
2021-05-21,CZ,Czechia,EURO,689,1661037,17,30262
2021-05-22,CZ,Czechia,EURO,679,1661716,13,30275
2021-05-23,CZ,Czechia,EURO,336,1662052,11,30286
2021-05-24,CZ,Czechia,EURO,199,1662251,13,30299
2021-05-25,CZ,Czechia,EURO,703,1662954,6,30305
2021-05-26,CZ,Czechia,EURO,668,1663622,8,30313
2021-05-27,CZ,Czechia,EURO,546,1664168,10,30323
2021-05-28,CZ,Czechia,EURO,516,1664684,16,30339
2021-05-29,CZ,Czechia,EURO,458,1665142,7,30346
2021-05-30,CZ,Czechia,EURO,222,1665364,6,30352
2021-05-31,CZ,Czechia,EURO,113,1665477,4,30356
2021-06-01,CZ,Czechia,EURO,522,1665999,10,30366
2021-06-02,CZ,Czechia,EURO,484,1666483,7,30373
2021-06-03,CZ,Czechia,EURO,357,1666840,5,30378
2021-06-04,CZ,Czechia,EURO,437,1667277,3,30381
2021-06-05,CZ,Czechia,EURO,330,1667607,7,30388
2021-06-06,CZ,Czechia,EURO,153,1667760,3,30391
2021-06-07,CZ,Czechia,EURO,99,1667859,4,30395
2021-06-08,CZ,Czechia,EURO,299,1668158,4,30399
2021-06-09,CZ,Czechia,EURO,387,1668545,6,30405
2021-06-10,CZ,Czechia,EURO,260,1668805,2,30407
2021-06-11,CZ,Czechia,EURO,195,1669000,6,30413
2021-06-12,CZ,Czechia,EURO,182,1669182,2,30415
2021-06-13,CZ,Czechia,EURO,77,1669259,4,30419
2021-06-14,CZ,Czechia,EURO,42,1669301,3,30422
2021-06-15,CZ,Czechia,EURO,178,1669479,0,30422
2021-06-16,CZ,Czechia,EURO,211,1669690,4,30426
2021-06-17,CZ,Czechia,EURO,133,1669823,1,30427
2021-06-18,CZ,Czechia,EURO,164,1669987,5,30432
2021-06-19,CZ,Czechia,EURO,149,1670136,3,30435
2021-06-20,CZ,Czechia,EURO,64,1670200,0,30435
2021-06-21,CZ,Czechia,EURO,59,1670259,1,30436
2021-06-22,CZ,Czechia,EURO,122,1670381,1,30437
2021-06-23,CZ,Czechia,EURO,112,1670493,3,30440
2021-06-24,CZ,Czechia,EURO,112,1670605,0,30440
2021-06-25,CZ,Czechia,EURO,98,1670703,4,30444
2021-06-26,CZ,Czechia,EURO,133,1670836,1,30445
2021-06-27,CZ,Czechia,EURO,67,1670903,2,30447
2021-06-28,CZ,Czechia,EURO,59,1670962,0,30447
2021-06-29,CZ,Czechia,EURO,156,1671118,0,30447
2021-06-30,CZ,Czechia,EURO,163,1671281,0,30447
2021-07-01,CZ,Czechia,EURO,138,1671419,2,30449
2021-07-02,CZ,Czechia,EURO,170,1671589,1,30450
2021-07-03,CZ,Czechia,EURO,167,1671756,2,30452
2021-07-04,CZ,Czechia,EURO,125,1671881,0,30452
2021-07-05,CZ,Czechia,EURO,109,1671990,2,30454
2021-07-06,CZ,Czechia,EURO,130,1672120,0,30454
2021-07-07,CZ,Czechia,EURO,111,1672231,0,30454
2021-07-08,CZ,Czechia,EURO,280,1672511,1,30455
2021-07-09,CZ,Czechia,EURO,259,1672770,0,30455
2021-07-10,CZ,Czechia,EURO,286,1673056,0,30455
2021-07-11,CZ,Czechia,EURO,163,1673219,0,30455
2021-07-12,CZ,Czechia,EURO,158,1673377,2,30457
2021-07-13,CZ,Czechia,EURO,242,1673619,0,30457
2021-07-14,CZ,Czechia,EURO,323,1673942,0,30457
2021-07-15,CZ,Czechia,EURO,258,1674200,0,30457
2021-07-16,CZ,Czechia,EURO,220,1674420,0,30457
2021-07-17,CZ,Czechia,EURO,245,1674665,2,30459
2021-07-18,CZ,Czechia,EURO,197,1674862,0,30459
2021-07-19,CZ,Czechia,EURO,117,1674979,1,30460
2021-07-20,CZ,Czechia,EURO,222,1675201,2,30462
2021-07-21,CZ,Czechia,EURO,300,1675501,0,30462
2021-07-22,CZ,Czechia,EURO,233,1675734,1,30463
2021-07-23,CZ,Czechia,EURO,212,1675946,0,30463
2021-07-24,CZ,Czechia,EURO,189,1676135,0,30463
2021-07-25,CZ,Czechia,EURO,127,1676262,0,30463
2021-07-26,CZ,Czechia,EURO,81,1676343,0,30463
2021-07-27,CZ,Czechia,EURO,200,1676543,0,30463
2021-07-28,CZ,Czechia,EURO,256,1676799,0,30463
2021-07-29,CZ,Czechia,EURO,202,1677001,0,30463
2021-07-30,CZ,Czechia,EURO,207,1677208,0,30463
2021-07-31,CZ,Czechia,EURO,140,1677348,0,30463
2021-08-01,CZ,Czechia,EURO,117,1677465,2,30465
2021-08-02,CZ,Czechia,EURO,77,1677542,2,30467
2021-08-03,CZ,Czechia,EURO,153,1677695,1,30468
2021-08-04,CZ,Czechia,EURO,242,1677937,0,30468
2021-08-05,CZ,Czechia,EURO,209,1678146,0,30468
2021-08-06,CZ,Czechia,EURO,165,1678311,1,30469
2021-08-07,CZ,Czechia,EURO,179,1678490,2,30471
2021-08-08,CZ,Czechia,EURO,156,1678646,0,30471
2021-08-09,CZ,Czechia,EURO,107,1678753,0,30471
2021-08-10,CZ,Czechia,EURO,176,1678929,1,30472
2021-08-11,CZ,Czechia,EURO,261,1679190,0,30472
2021-08-12,CZ,Czechia,EURO,220,1679410,1,30473
2021-08-13,CZ,Czechia,EURO,190,1679600,0,30473
2021-08-14,CZ,Czechia,EURO,223,1679823,0,30473
2021-08-15,CZ,Czechia,EURO,142,1679965,0,30473
2021-08-16,CZ,Czechia,EURO,77,1680042,3,30476
2021-08-17,CZ,Czechia,EURO,216,1680258,3,30479
2021-08-18,CZ,Czechia,EURO,300,1680558,1,30480
2021-08-19,CZ,Czechia,EURO,209,1680767,2,30482
2021-08-20,CZ,Czechia,EURO,166,1680933,2,30484
2021-08-21,CZ,Czechia,EURO,171,1681104,1,30485
2021-08-22,CZ,Czechia,EURO,135,1681239,0,30485
2021-08-23,CZ,Czechia,EURO,107,1681346,0,30485
2021-08-24,CZ,Czechia,EURO,214,1681560,1,30486
2021-08-25,CZ,Czechia,EURO,253,1681813,1,30487
2021-08-26,CZ,Czechia,EURO,250,1682063,2,30489
2021-08-27,CZ,Czechia,EURO,214,1682277,0,30489
2021-08-28,CZ,Czechia,EURO,183,1682460,1,30490
2021-08-29,CZ,Czechia,EURO,133,1682593,2,30492
2021-08-30,CZ,Czechia,EURO,81,1682674,1,30493
2021-08-31,CZ,Czechia,EURO,241,1682915,0,30493
2021-09-01,CZ,Czechia,EURO,292,1683207,0,30493
2021-09-02,CZ,Czechia,EURO,262,1683469,0,30493
2021-09-03,CZ,Czechia,EURO,306,1683775,2,30495
2021-09-04,CZ,Czechia,EURO,310,1684085,0,30495
2021-09-05,CZ,Czechia,EURO,207,1684292,0,30495
2021-09-06,CZ,Czechia,EURO,141,1684433,0,30495
2021-09-07,CZ,Czechia,EURO,393,1684826,1,30496
2021-09-08,CZ,Czechia,EURO,583,1685409,2,30498
2021-09-09,CZ,Czechia,EURO,382,1685791,1,30499
2021-09-10,CZ,Czechia,EURO,420,1686211,0,30499
2021-09-11,CZ,Czechia,EURO,445,1686656,0,30499
2021-09-12,CZ,Czechia,EURO,251,1686907,0,30499
2021-09-13,CZ,Czechia,EURO,137,1687044,2,30501
2021-09-14,CZ,Czechia,EURO,495,1687539,0,30501
2021-09-15,CZ,Czechia,EURO,557,1688096,3,30504
2021-09-16,CZ,Czechia,EURO,524,1688620,3,30507
2021-09-17,CZ,Czechia,EURO,562,1689182,0,30507
2021-09-18,CZ,Czechia,EURO,448,1689630,2,30509
2021-09-19,CZ,Czechia,EURO,302,1689932,5,30514
2021-09-20,CZ,Czechia,EURO,188,1690120,2,30516
2021-09-21,CZ,Czechia,EURO,481,1690601,4,30520
2021-09-22,CZ,Czechia,EURO,597,1691198,2,30522
2021-09-23,CZ,Czechia,EURO,523,1691721,2,30524
2021-09-24,CZ,Czechia,EURO,484,1692205,3,30527
2021-09-25,CZ,Czechia,EURO,534,1692739,0,30527
2021-09-26,CZ,Czechia,EURO,419,1693158,2,30529
2021-09-27,CZ,Czechia,EURO,252,1693410,0,30529
2021-09-28,CZ,Czechia,EURO,677,1694087,0,30529
2021-09-29,CZ,Czechia,EURO,474,1694561,3,30532
2021-09-30,CZ,Czechia,EURO,735,1695296,5,30537
2021-10-01,CZ,Czechia,EURO,922,1696218,1,30538
2021-10-02,CZ,Czechia,EURO,829,1697047,1,30539
2021-10-03,CZ,Czechia,EURO,552,1697599,1,30540
2021-10-04,CZ,Czechia,EURO,318,1697917,4,30544
2021-10-05,CZ,Czechia,EURO,823,1698740,4,30548
2021-10-06,CZ,Czechia,EURO,1135,1699875,3,30551
2021-10-07,CZ,Czechia,EURO,1048,1700923,5,30556
2021-10-08,CZ,Czechia,EURO,992,1701915,3,30559
2021-10-09,CZ,Czechia,EURO,1019,1702934,4,30563
2021-10-10,CZ,Czechia,EURO,668,1703602,3,30566
2021-10-11,CZ,Czechia,EURO,338,1703940,4,30570
2021-10-12,CZ,Czechia,EURO,1346,1705286,5,30575
2021-10-13,CZ,Czechia,EURO,1508,1706794,7,30582
2021-10-14,CZ,Czechia,EURO,1500,1708294,6,30588
2021-10-15,CZ,Czechia,EURO,1541,1709835,6,30594
2021-10-16,CZ,Czechia,EURO,1782,1711617,10,30604
2021-10-17,CZ,Czechia,EURO,1158,1712775,8,30612
2021-10-18,CZ,Czechia,EURO,796,1713571,11,30623
2021-10-19,CZ,Czechia,EURO,2539,1716110,12,30635
2021-10-20,CZ,Czechia,EURO,3249,1719359,10,30645
2021-10-21,CZ,Czechia,EURO,3281,1722640,7,30652
2021-10-22,CZ,Czechia,EURO,3646,1726286,10,30662
2021-10-23,CZ,Czechia,EURO,4239,1730525,14,30676
2021-10-24,CZ,Czechia,EURO,2756,1733281,13,30689
2021-10-25,CZ,Czechia,EURO,1840,1735121,21,30710
2021-10-26,CZ,Czechia,EURO,4287,1739408,20,30730
2021-10-27,CZ,Czechia,EURO,6291,1745699,16,30746
2021-10-28,CZ,Czechia,EURO,5866,1751565,21,30767
2021-10-29,CZ,Czechia,EURO,4357,1755922,26,30793
2021-10-30,CZ,Czechia,EURO,5760,1761682,26,30819
2021-10-31,CZ,Czechia,EURO,5061,1766743,25,30844
2021-11-01,CZ,Czechia,EURO,2792,1769535,31,30875
2021-11-02,CZ,Czechia,EURO,7618,1777153,31,30906
2021-11-03,CZ,Czechia,EURO,9941,1787094,36,30942
2021-11-04,CZ,Czechia,EURO,9483,1796577,45,30987
2021-11-05,CZ,Czechia,EURO,8494,1805071,45,31032
2021-11-06,CZ,Czechia,EURO,9258,1814329,57,31089
2021-11-07,CZ,Czechia,EURO,5745,1820074,53,31142
2021-11-08,CZ,Czechia,EURO,3013,1823087,39,31181
2021-11-09,CZ,Czechia,EURO,9289,1832376,49,31230
2021-11-10,CZ,Czechia,EURO,14583,1846959,63,31293
2021-11-11,CZ,Czechia,EURO,13571,1860530,75,31368
2021-11-12,CZ,Czechia,EURO,10454,1870984,71,31439
2021-11-13,CZ,Czechia,EURO,14260,1885244,67,31506
2021-11-14,CZ,Czechia,EURO,9183,1894427,74,31580
2021-11-15,CZ,Czechia,EURO,5699,1900126,63,31643
2021-11-16,CZ,Czechia,EURO,11563,1911689,93,31736
2021-11-17,CZ,Czechia,EURO,22541,1934230,70,31806
2021-11-18,CZ,Czechia,EURO,14201,1948431,82,31888
2021-11-19,CZ,Czechia,EURO,13520,1961951,121,32009
2021-11-20,CZ,Czechia,EURO,22972,1984923,113,32122
2021-11-21,CZ,Czechia,EURO,14415,1999338,96,32218
2021-11-22,CZ,Czechia,EURO,8278,2007616,113,32331
2021-11-23,CZ,Czechia,EURO,14518,2022134,111,32442
2021-11-24,CZ,Czechia,EURO,25912,2048046,115,32557
2021-11-25,CZ,Czechia,EURO,18047,2066093,93,32650
2021-11-26,CZ,Czechia,EURO,27937,2094030,115,32765
2021-11-27,CZ,Czechia,EURO,20384,2114414,118,32883
2021-11-28,CZ,Czechia,EURO,12528,2126942,95,32978
2021-11-29,CZ,Czechia,EURO,9307,2136249,119,33097
2021-11-30,CZ,Czechia,EURO,17617,2153866,108,33205
2021-12-01,CZ,Czechia,EURO,22025,2175891,121,33326
2021-12-02,CZ,Czechia,EURO,21154,2197045,140,33466
2021-12-03,CZ,Czechia,EURO,18627,2215672,125,33591
2021-12-04,CZ,Czechia,EURO,17685,2233357,121,33712
2021-12-05,CZ,Czechia,EURO,10982,2244339,109,33821
2021-12-06,CZ,Czechia,EURO,6335,2250674,110,33931
2021-12-07,CZ,Czechia,EURO,15581,2266255,126,34057
2021-12-08,CZ,Czechia,EURO,19537,2285792,112,34169
2021-12-09,CZ,Czechia,EURO,16209,2302001,113,34282
2021-12-10,CZ,Czechia,EURO,14265,2316266,114,34396
2021-12-11,CZ,Czechia,EURO,12401,2328667,121,34517
2021-12-12,CZ,Czechia,EURO,9086,2337753,100,34617
2021-12-13,CZ,Czechia,EURO,4129,2341882,124,34741
2021-12-14,CZ,Czechia,EURO,11905,2353787,114,34855
2021-12-15,CZ,Czechia,EURO,16707,2370494,114,34969
2021-12-16,CZ,Czechia,EURO,11618,2382112,124,35093
2021-12-17,CZ,Czechia,EURO,9501,2391613,97,35190
2021-12-18,CZ,Czechia,EURO,8962,2400575,93,35283
2021-12-19,CZ,Czechia,EURO,5985,2406560,103,35386
2021-12-20,CZ,Czechia,EURO,3744,2410304,69,35455
2021-12-21,CZ,Czechia,EURO,8600,2418904,79,35534
2021-12-22,CZ,Czechia,EURO,11846,2430750,81,35615
2021-12-23,CZ,Czechia,EURO,7696,2438446,84,35699
2021-12-24,CZ,Czechia,EURO,7361,2445807,60,35759
2021-12-25,CZ,Czechia,EURO,2045,2447852,80,35839
2021-12-26,CZ,Czechia,EURO,1090,2448942,68,35907
2021-12-27,CZ,Czechia,EURO,2015,2450957,85,35992
2021-12-28,CZ,Czechia,EURO,6864,2457821,51,36043
2021-12-29,CZ,Czechia,EURO,9078,2466899,72,36115
2021-12-30,CZ,Czechia,EURO,6160,2473059,75,36190
2021-12-31,CZ,Czechia,EURO,5756,2478815,58,36248
2022-01-01,CZ,Czechia,EURO,4998,2483813,55,36303
2022-01-02,CZ,Czechia,EURO,1093,2484906,46,36349
2022-01-03,CZ,Czechia,EURO,1931,2486837,51,36400
2022-01-04,CZ,Czechia,EURO,9357,2496194,60,36460
2022-01-05,CZ,Czechia,EURO,10180,2506374,60,36520
2022-01-06,CZ,Czechia,EURO,7388,2513762,39,36559
2022-01-07,CZ,Czechia,EURO,6641,2520403,58,36617
2022-01-08,CZ,Czechia,EURO,6674,2527077,45,36662
2022-01-09,CZ,Czechia,EURO,3963,2531040,43,36705
2022-01-10,CZ,Czechia,EURO,2764,2533804,23,36728
2022-01-11,CZ,Czechia,EURO,7361,2541165,43,36771
2022-01-12,CZ,Czechia,EURO,12378,2553543,38,36809
2022-01-13,CZ,Czechia,EURO,11467,2565010,41,36850
2022-01-14,CZ,Czechia,EURO,11693,2576703,33,36883
2022-01-15,CZ,Czechia,EURO,13227,2589930,32,36915
2022-01-16,CZ,Czechia,EURO,9293,2599223,25,36940
2022-01-17,CZ,Czechia,EURO,7246,2606469,29,36969
2022-01-18,CZ,Czechia,EURO,20309,2626778,27,36996
2022-01-19,CZ,Czechia,EURO,28503,2655281,25,37021
2022-01-20,CZ,Czechia,EURO,26020,2681301,27,37048
2022-01-21,CZ,Czechia,EURO,26939,2708240,19,37067
2022-01-22,CZ,Czechia,EURO,26623,2734863,21,37088
2022-01-23,CZ,Czechia,EURO,18357,2753220,22,37110
2022-01-24,CZ,Czechia,EURO,12902,2766122,18,37128
2022-01-25,CZ,Czechia,EURO,30395,2796517,22,37150
2022-01-26,CZ,Czechia,EURO,39638,2836155,14,37164
2022-01-27,CZ,Czechia,EURO,54701,2890856,21,37185
2022-01-28,CZ,Czechia,EURO,34813,2925669,27,37212
2022-01-29,CZ,Czechia,EURO,47270,2972939,22,37234
2022-01-30,CZ,Czechia,EURO,18285,2991224,27,37261
2022-01-31,CZ,Czechia,EURO,23942,3015166,28,37289
2022-02-01,CZ,Czechia,EURO,29555,3044721,34,37323
2022-02-02,CZ,Czechia,EURO,57235,3101956,44,37367
2022-02-03,CZ,Czechia,EURO,43334,3145290,39,37406
2022-02-04,CZ,Czechia,EURO,37688,3182978,37,37443
2022-02-05,CZ,Czechia,EURO,28713,3211691,54,37497
2022-02-06,CZ,Czechia,EURO,24006,3235697,48,37545
2022-02-07,CZ,Czechia,EURO,9070,3244767,45,37590
2022-02-08,CZ,Czechia,EURO,29622,3274389,60,37650
2022-02-09,CZ,Czechia,EURO,37749,3312138,52,37702
2022-02-10,CZ,Czechia,EURO,29051,3341189,45,37747
2022-02-11,CZ,Czechia,EURO,22668,3363857,56,37803
2022-02-12,CZ,Czechia,EURO,22135,3385992,58,37861
2022-02-13,CZ,Czechia,EURO,10954,3396946,62,37923
2022-02-14,CZ,Czechia,EURO,7194,3404140,55,37978
2022-02-15,CZ,Czechia,EURO,19472,3423612,47,38025
2022-02-16,CZ,Czechia,EURO,28286,3451898,46,38071
2022-02-17,CZ,Czechia,EURO,16992,3468890,51,38122
2022-02-18,CZ,Czechia,EURO,15522,3484412,55,38177
2022-02-19,CZ,Czechia,EURO,13766,3498178,55,38232
2022-02-20,CZ,Czechia,EURO,8220,3506398,50,38282
2022-02-21,CZ,Czechia,EURO,4272,3510670,47,38329
2022-02-22,CZ,Czechia,EURO,13455,3524125,53,38382
2022-02-23,CZ,Czechia,EURO,14204,3538329,51,38433
2022-02-24,CZ,Czechia,EURO,11206,3549535,35,38468
2022-02-25,CZ,Czechia,EURO,10025,3559560,23,38491
.
41553a
2022-02-25,CY,Cyprus,EURO,1935,315341,1,834
.
40769a
2022-02-25,CW,Curaçao,AMRO,52,38830,0,261
.
39985a
2022-02-25,CU,Cuba,AMRO,595,1067522,0,8494
.
39201a
2022-02-25,HR,Croatia,EURO,2559,1049667,22,14964
.
38417a
2022-02-25,CI,Côte d’Ivoire,AFRO,0,81410,0,791
.
37633a
2022-02-25,CR,Costa Rica,AMRO,3195,797030,15,7969
.
36849a
2022-02-25,CK,Cook Islands,WPRO,2,8,0,0
.
36065a
2022-02-25,CG,Congo,AFRO,0,23967,0,378
.
35281a
2022-02-25,KM,Comoros,AFRO,0,8024,0,160
.
34497a
2022-02-25,CO,Colombia,AMRO,2181,6054307,79,138364
.
33713a
2022-02-25,CN,China,WPRO,9103,212966,40,5913
.
32929a
2022-02-25,CL,Chile,AMRO,32764,2953895,224,41795
.
32145a
2022-02-25,TD,Chad,AFRO,0,7248,0,190
.
31361a
2022-02-25,CF,Central African Republic,AFRO,0,14187,0,113
.
30577a
2022-02-25,KY,Cayman Islands,AMRO,645,19373,0,17
.
29793a
2022-02-25,CA,Canada,AMRO,6853,3261911,93,36254
.
29009a
2022-02-25,CM,Cameroon,AFRO,0,119107,0,1920
.
28225a
2022-02-25,KH,Cambodia,WPRO,466,128599,3,3026
.
27441a
2022-02-25,CV,Cabo Verde,AFRO,6,55876,0,401
.
26657a
2022-02-25,BI,Burundi,AFRO,16,38063,0,15
.
25873a
2022-02-25,BF,Burkina Faso,AFRO,0,20751,0,375
.
25089a
2022-02-25,BG,Bulgaria,EURO,2854,1083425,59,35357
.
24305a
2022-02-25,BN,Brunei Darussalam,WPRO,3721,48055,1,64
.
23521a
2022-02-25,VG,British Virgin Islands,AMRO,0,6074,0,62
.
22737a
2022-02-25,BR,Brazil,AMRO,133563,28484890,999,646419
.
21953a
2022-02-25,BW,Botswana,AFRO,0,262652,0,2614
.
21169a
2022-02-25,BA,Bosnia and Herzegovina,EURO,425,370295,12,15392
.
20385a
2022-02-25,XA,Bonaire,AMRO,6,6911,0,28
.
19601c
2022-02-24,BO,Bolivia (Plurinational State of),AMRO,739,891851,6,21406
2022-02-25,BO,Bolivia (Plurinational State of),AMRO,0,891851,0,21406
.
18817a
2022-02-25,BT,Bhutan,SEARO,359,11369,0,6
.
18033a
2022-02-25,BM,Bermuda,AMRO,43,11466,0,123
.
17249a
2022-02-25,BJ,Benin,AFRO,0,26567,0,163
.
16465a
2022-02-25,BZ,Belize,AMRO,76,56450,1,648
.
15353,15681c
2021-04-02,BE,Belgium,EURO,4687,891295,40,23255
2021-04-03,BE,Belgium,EURO,4894,896189,46,23301
2021-04-04,BE,Belgium,EURO,2701,898890,40,23341
2021-04-05,BE,Belgium,EURO,1513,900403,36,23377
2021-04-06,BE,Belgium,EURO,1562,901965,49,23426
2021-04-07,BE,Belgium,EURO,5259,907224,46,23472
2021-04-08,BE,Belgium,EURO,4741,911965,43,23515
2021-04-09,BE,Belgium,EURO,4466,916431,43,23558
2021-04-10,BE,Belgium,EURO,4496,920927,44,23602
2021-04-11,BE,Belgium,EURO,2361,923288,46,23648
2021-04-12,BE,Belgium,EURO,1305,924593,22,23670
2021-04-13,BE,Belgium,EURO,4729,929322,44,23714
2021-04-14,BE,Belgium,EURO,4281,933603,37,23751
2021-04-15,BE,Belgium,EURO,3899,937502,39,23790
2021-04-16,BE,Belgium,EURO,3807,941309,42,23832
2021-04-17,BE,Belgium,EURO,4021,945330,45,23877
2021-04-18,BE,Belgium,EURO,2322,947652,30,23907
2021-04-19,BE,Belgium,EURO,1312,948964,35,23942
2021-04-20,BE,Belgium,EURO,5433,954397,50,23992
2021-04-21,BE,Belgium,EURO,4458,958855,36,24028
2021-04-22,BE,Belgium,EURO,4068,962923,36,24064
2021-04-23,BE,Belgium,EURO,3801,966724,43,24107
2021-04-24,BE,Belgium,EURO,3636,970360,42,24149
2021-04-25,BE,Belgium,EURO,1889,972249,36,24185
2021-04-26,BE,Belgium,EURO,1138,973387,39,24224
2021-04-27,BE,Belgium,EURO,4270,977657,44,24268
2021-04-28,BE,Belgium,EURO,3760,981417,26,24294
2021-04-29,BE,Belgium,EURO,3448,984865,49,24343
2021-04-30,BE,Belgium,EURO,3347,988212,46,24389
2021-05-01,BE,Belgium,EURO,3487,991699,33,24422
2021-05-02,BE,Belgium,EURO,1335,993034,28,24450
2021-05-03,BE,Belgium,EURO,1137,994171,34,24484
2021-05-04,BE,Belgium,EURO,4331,998502,43,24527
2021-05-05,BE,Belgium,EURO,3651,1002153,40,24567
2021-05-06,BE,Belgium,EURO,3615,1005768,38,24605
2021-05-07,BE,Belgium,EURO,3515,1009283,38,24643
2021-05-08,BE,Belgium,EURO,3294,1012577,26,24669
2021-05-09,BE,Belgium,EURO,1714,1014291,42,24711
2021-05-10,BE,Belgium,EURO,855,1015146,32,24743
2021-05-11,BE,Belgium,EURO,3362,1018508,28,24771
2021-05-12,BE,Belgium,EURO,2989,1021497,17,24788
2021-05-13,BE,Belgium,EURO,2807,1024304,19,24807
2021-05-14,BE,Belgium,EURO,943,1025247,21,24828
2021-05-15,BE,Belgium,EURO,2557,1027804,20,24848
2021-05-16,BE,Belgium,EURO,1254,1029058,22,24870
2021-05-17,BE,Belgium,EURO,735,1029793,17,24887
2021-05-18,BE,Belgium,EURO,3576,1033369,24,24911
2021-05-19,BE,Belgium,EURO,3265,1036634,17,24928
2021-05-20,BE,Belgium,EURO,3118,1039752,25,24953
2021-05-21,BE,Belgium,EURO,2409,1042161,16,24969
2021-05-22,BE,Belgium,EURO,2425,1044586,19,24988
2021-05-23,BE,Belgium,EURO,1434,1046020,18,25006
2021-05-24,BE,Belgium,EURO,773,1046793,11,25017
2021-05-25,BE,Belgium,EURO,899,1047692,19,25036
2021-05-26,BE,Belgium,EURO,2789,1050481,16,25052
2021-05-27,BE,Belgium,EURO,2534,1053015,14,25066
2021-05-28,BE,Belgium,EURO,2215,1055230,6,25072
2021-05-29,BE,Belgium,EURO,2023,1057253,11,25083
2021-05-30,BE,Belgium,EURO,1116,1058369,16,25099
2021-05-31,BE,Belgium,EURO,603,1058972,18,25117
2021-06-01,BE,Belgium,EURO,2026,1060998,14,25131
2021-06-02,BE,Belgium,EURO,1682,1062680,11,25142
2021-06-03,BE,Belgium,EURO,1498,1064178,16,25158
2021-06-04,BE,Belgium,EURO,1466,1065644,15,25173
2021-06-05,BE,Belgium,EURO,1349,1066993,10,25183
2021-06-06,BE,Belgium,EURO,647,1067640,13,25196
2021-06-07,BE,Belgium,EURO,399,1068039,7,25203
2021-06-08,BE,Belgium,EURO,1237,1069276,5,25208
2021-06-09,BE,Belgium,EURO,1041,1070317,13,25221
2021-06-10,BE,Belgium,EURO,841,1071158,6,25227
2021-06-11,BE,Belgium,EURO,764,1071922,7,25234
2021-06-12,BE,Belgium,EURO,779,1072701,9,25243
2021-06-13,BE,Belgium,EURO,390,1073091,6,25249
2021-06-14,BE,Belgium,EURO,209,1073300,4,25253
2021-06-15,BE,Belgium,EURO,765,1074065,6,25259
2021-06-16,BE,Belgium,EURO,535,1074600,6,25265
2021-06-17,BE,Belgium,EURO,419,1075019,6,25271
2021-06-18,BE,Belgium,EURO,450,1075469,7,25278
2021-06-19,BE,Belgium,EURO,424,1075893,9,25287
2021-06-20,BE,Belgium,EURO,274,1076167,6,25293
2021-06-21,BE,Belgium,EURO,139,1076306,3,25296
2021-06-22,BE,Belgium,EURO,482,1076788,5,25301
2021-06-23,BE,Belgium,EURO,365,1077153,3,25304
2021-06-24,BE,Belgium,EURO,396,1077549,5,25309
2021-06-25,BE,Belgium,EURO,339,1077888,5,25314
2021-06-26,BE,Belgium,EURO,398,1078286,5,25319
2021-06-27,BE,Belgium,EURO,259,1078545,2,25321
2021-06-28,BE,Belgium,EURO,177,1078722,3,25324
2021-06-29,BE,Belgium,EURO,598,1079320,2,25326
2021-06-30,BE,Belgium,EURO,557,1079877,5,25331
2021-07-01,BE,Belgium,EURO,628,1080505,2,25333
2021-07-02,BE,Belgium,EURO,676,1081181,5,25338
2021-07-03,BE,Belgium,EURO,724,1081905,3,25341
2021-07-04,BE,Belgium,EURO,521,1082426,3,25344
2021-07-05,BE,Belgium,EURO,366,1082792,2,25346
2021-07-06,BE,Belgium,EURO,998,1083790,3,25349
2021-07-07,BE,Belgium,EURO,1042,1084832,1,25350
2021-07-08,BE,Belgium,EURO,1173,1086005,0,25350
2021-07-09,BE,Belgium,EURO,1227,1087232,2,25352
2021-07-10,BE,Belgium,EURO,1289,1088521,2,25354
2021-07-11,BE,Belgium,EURO,1004,1089525,5,25359
2021-07-12,BE,Belgium,EURO,781,1090306,0,25359
2021-07-13,BE,Belgium,EURO,1764,1092070,2,25361
2021-07-14,BE,Belgium,EURO,1429,1093499,0,25361
2021-07-15,BE,Belgium,EURO,1446,1094945,1,25362
2021-07-16,BE,Belgium,EURO,1390,1096335,2,25364
2021-07-17,BE,Belgium,EURO,1570,1097905,2,25366
2021-07-18,BE,Belgium,EURO,1104,1099009,0,25366
2021-07-19,BE,Belgium,EURO,838,1099847,2,25368
2021-07-20,BE,Belgium,EURO,2134,1101981,0,25368
2021-07-21,BE,Belgium,EURO,1954,1103935,0,25368
2021-07-22,BE,Belgium,EURO,790,1104725,3,25371
2021-07-23,BE,Belgium,EURO,1914,1106639,4,25375
2021-07-24,BE,Belgium,EURO,1656,1108295,2,25377
2021-07-25,BE,Belgium,EURO,1158,1109453,3,25380
2021-07-26,BE,Belgium,EURO,784,1110237,2,25382
2021-07-27,BE,Belgium,EURO,2112,1112349,1,25383
2021-07-28,BE,Belgium,EURO,1600,1113949,4,25387
2021-07-29,BE,Belgium,EURO,1752,1115701,1,25388
2021-07-30,BE,Belgium,EURO,1782,1117483,6,25394
2021-07-31,BE,Belgium,EURO,1797,1119280,6,25400
2021-08-01,BE,Belgium,EURO,1186,1120466,3,25403
2021-08-02,BE,Belgium,EURO,1056,1121522,1,25404
2021-08-03,BE,Belgium,EURO,2251,1123773,5,25409
2021-08-04,BE,Belgium,EURO,1950,1125723,5,25414
2021-08-05,BE,Belgium,EURO,1875,1127598,4,25418
2021-08-06,BE,Belgium,EURO,1836,1129434,3,25421
2021-08-07,BE,Belgium,EURO,2133,1131567,3,25424
2021-08-08,BE,Belgium,EURO,1275,1132842,3,25427
2021-08-09,BE,Belgium,EURO,922,1133764,3,25430
2021-08-10,BE,Belgium,EURO,2597,1136361,5,25435
2021-08-11,BE,Belgium,EURO,2218,1138579,2,25437
2021-08-12,BE,Belgium,EURO,1992,1140571,2,25439
2021-08-13,BE,Belgium,EURO,2158,1142729,3,25442
2021-08-14,BE,Belgium,EURO,2273,1145002,5,25447
2021-08-15,BE,Belgium,EURO,1352,1146354,4,25451
2021-08-16,BE,Belgium,EURO,766,1147120,2,25453
2021-08-17,BE,Belgium,EURO,2829,1149949,5,25458
2021-08-18,BE,Belgium,EURO,2247,1152196,3,25461
2021-08-19,BE,Belgium,EURO,2265,1154461,4,25465
2021-08-20,BE,Belgium,EURO,2007,1156468,9,25474
2021-08-21,BE,Belgium,EURO,2245,1158713,9,25483
2021-08-22,BE,Belgium,EURO,1285,1159998,7,25490
2021-08-23,BE,Belgium,EURO,956,1160954,7,25497
2021-08-24,BE,Belgium,EURO,2654,1163608,3,25500
2021-08-25,BE,Belgium,EURO,2460,1166068,6,25506
2021-08-26,BE,Belgium,EURO,2395,1168463,7,25513
2021-08-27,BE,Belgium,EURO,2186,1170649,6,25519
2021-08-28,BE,Belgium,EURO,2217,1172866,5,25524
2021-08-29,BE,Belgium,EURO,1372,1174238,4,25528
2021-08-30,BE,Belgium,EURO,833,1175071,4,25532
2021-08-31,BE,Belgium,EURO,2943,1178014,5,25537
2021-09-01,BE,Belgium,EURO,2358,1180372,4,25541
2021-09-02,BE,Belgium,EURO,2222,1182594,7,25548
2021-09-03,BE,Belgium,EURO,2113,1184707,6,25554
2021-09-04,BE,Belgium,EURO,2155,1186862,6,25560
2021-09-05,BE,Belgium,EURO,1243,1188105,10,25570
2021-09-06,BE,Belgium,EURO,733,1188838,8,25578
2021-09-07,BE,Belgium,EURO,2800,1191638,7,25585
2021-09-08,BE,Belgium,EURO,2361,1193999,9,25594
2021-09-09,BE,Belgium,EURO,2190,1196189,9,25603
2021-09-10,BE,Belgium,EURO,2105,1198294,6,25609
2021-09-11,BE,Belgium,EURO,2323,1200617,7,25616
2021-09-12,BE,Belgium,EURO,1306,1201923,7,25623
2021-09-13,BE,Belgium,EURO,679,1202602,7,25630
2021-09-14,BE,Belgium,EURO,2930,1205532,7,25637
2021-09-15,BE,Belgium,EURO,2496,1208028,8,25645
2021-09-16,BE,Belgium,EURO,2322,1210350,7,25652
2021-09-17,BE,Belgium,EURO,2426,1212776,1,25653
2021-09-18,BE,Belgium,EURO,2390,1215166,5,25658
2021-09-19,BE,Belgium,EURO,1260,1216426,9,25667
2021-09-20,BE,Belgium,EURO,652,1217078,7,25674
2021-09-21,BE,Belgium,EURO,2940,1220018,6,25680
2021-09-22,BE,Belgium,EURO,2269,1222287,5,25685
2021-09-23,BE,Belgium,EURO,2171,1224458,11,25696
2021-09-24,BE,Belgium,EURO,2080,1226538,11,25707
2021-09-25,BE,Belgium,EURO,2253,1228791,7,25714
2021-09-26,BE,Belgium,EURO,1216,1230007,7,25721
2021-09-27,BE,Belgium,EURO,723,1230730,7,25728
2021-09-28,BE,Belgium,EURO,2628,1233358,13,25741
2021-09-29,BE,Belgium,EURO,2391,1235749,7,25748
2021-09-30,BE,Belgium,EURO,2167,1237916,7,25755
2021-10-01,BE,Belgium,EURO,2163,1240079,11,25766
2021-10-02,BE,Belgium,EURO,2149,1242228,6,25772
2021-10-03,BE,Belgium,EURO,1147,1243375,8,25780
2021-10-04,BE,Belgium,EURO,679,1244054,8,25788
2021-10-05,BE,Belgium,EURO,2792,1246846,5,25793
2021-10-06,BE,Belgium,EURO,2290,1249136,14,25807
2021-10-07,BE,Belgium,EURO,2545,1251681,13,25820
2021-10-08,BE,Belgium,EURO,2516,1254197,11,25831
2021-10-09,BE,Belgium,EURO,2544,1256741,7,25838
2021-10-10,BE,Belgium,EURO,1424,1258165,11,25849
2021-10-11,BE,Belgium,EURO,820,1258985,4,25853
2021-10-12,BE,Belgium,EURO,3924,1262909,18,25871
2021-10-13,BE,Belgium,EURO,3435,1266344,13,25884
2021-10-14,BE,Belgium,EURO,3597,1269941,8,25892
2021-10-15,BE,Belgium,EURO,3890,1273831,10,25902
2021-10-16,BE,Belgium,EURO,4168,1277999,18,25920
2021-10-17,BE,Belgium,EURO,2376,1280375,14,25934
2021-10-18,BE,Belgium,EURO,1490,1281865,10,25944
2021-10-19,BE,Belgium,EURO,6570,1288435,19,25963
2021-10-20,BE,Belgium,EURO,6296,1294731,13,25976
2021-10-21,BE,Belgium,EURO,6552,1301283,14,25990
2021-10-22,BE,Belgium,EURO,6905,1308188,10,26000
2021-10-23,BE,Belgium,EURO,7147,1315335,18,26018
2021-10-24,BE,Belgium,EURO,4090,1319425,20,26038
2021-10-25,BE,Belgium,EURO,2450,1321875,16,26054
2021-10-26,BE,Belgium,EURO,9703,1331578,18,26072
2021-10-27,BE,Belgium,EURO,9401,1340979,27,26099
2021-10-28,BE,Belgium,EURO,9224,1350203,33,26132
2021-10-29,BE,Belgium,EURO,9196,1359399,18,26150
2021-10-30,BE,Belgium,EURO,9289,1368688,21,26171
2021-10-31,BE,Belgium,EURO,4971,1373659,16,26187
2021-11-01,BE,Belgium,EURO,3058,1376717,18,26205
2021-11-02,BE,Belgium,EURO,3582,1380299,25,26230
2021-11-03,BE,Belgium,EURO,11714,1392013,20,26250
2021-11-04,BE,Belgium,EURO,10706,1402719,17,26267
2021-11-05,BE,Belgium,EURO,10181,1412900,26,26293
2021-11-06,BE,Belgium,EURO,11140,1424040,25,26318
2021-11-07,BE,Belgium,EURO,6453,1430493,30,26348
2021-11-08,BE,Belgium,EURO,4073,1434566,15,26363
2021-11-09,BE,Belgium,EURO,15267,1449833,28,26391
2021-11-10,BE,Belgium,EURO,13017,1462850,27,26418
2021-11-11,BE,Belgium,EURO,12750,1475600,26,26444
2021-11-12,BE,Belgium,EURO,5055,1480655,32,26476
2021-11-13,BE,Belgium,EURO,13752,1494407,39,26515
2021-11-14,BE,Belgium,EURO,8362,1502769,20,26535
2021-11-15,BE,Belgium,EURO,5506,1508275,27,26562
2021-11-16,BE,Belgium,EURO,20837,1529112,46,26608
2021-11-17,BE,Belgium,EURO,18431,1547543,29,26637
2021-11-18,BE,Belgium,EURO,18148,1565691,42,26679
2021-11-19,BE,Belgium,EURO,18572,1584263,43,26722
2021-11-20,BE,Belgium,EURO,19151,1603414,33,26755
2021-11-21,BE,Belgium,EURO,11215,1614629,36,26791
2021-11-22,BE,Belgium,EURO,6754,1621383,36,26827
2021-11-23,BE,Belgium,EURO,25624,1647007,35,26862
2021-11-24,BE,Belgium,EURO,21139,1668146,38,26900
2021-11-25,BE,Belgium,EURO,20174,1688320,49,26949
2021-11-26,BE,Belgium,EURO,20231,1708551,44,26993
2021-11-27,BE,Belgium,EURO,20044,1728595,40,27033
2021-11-28,BE,Belgium,EURO,11589,1740184,48,27081
2021-11-29,BE,Belgium,EURO,7072,1747256,47,27128
2021-11-30,BE,Belgium,EURO,25206,1772462,45,27173
2021-12-01,BE,Belgium,EURO,20870,1793332,61,27234
2021-12-02,BE,Belgium,EURO,19669,1813001,43,27277
2021-12-03,BE,Belgium,EURO,18329,1831330,53,27330
2021-12-04,BE,Belgium,EURO,17768,1849098,48,27378
2021-12-05,BE,Belgium,EURO,9636,1858734,45,27423
2021-12-06,BE,Belgium,EURO,5978,1864712,57,27480
2021-12-07,BE,Belgium,EURO,20737,1885449,39,27519
2021-12-08,BE,Belgium,EURO,15682,1901131,49,27568
2021-12-09,BE,Belgium,EURO,15080,1916211,55,27623
2021-12-10,BE,Belgium,EURO,13437,1929648,35,27658
2021-12-11,BE,Belgium,EURO,13103,1942751,48,27706
2021-12-12,BE,Belgium,EURO,7112,1949863,45,27751
2021-12-13,BE,Belgium,EURO,3908,1953771,44,27795
2021-12-14,BE,Belgium,EURO,13885,1967656,43,27838
2021-12-15,BE,Belgium,EURO,10582,1978238,37,27875
2021-12-16,BE,Belgium,EURO,9282,1987520,41,27916
2021-12-17,BE,Belgium,EURO,8110,1995630,37,27953
2021-12-18,BE,Belgium,EURO,7745,2003375,26,27979
2021-12-19,BE,Belgium,EURO,4753,2008128,36,28015
2021-12-20,BE,Belgium,EURO,2850,2010978,38,28053
2021-12-21,BE,Belgium,EURO,9111,2020089,36,28089
2021-12-22,BE,Belgium,EURO,7372,2027461,36,28125
2021-12-23,BE,Belgium,EURO,7389,2034850,37,28162
2021-12-24,BE,Belgium,EURO,7524,2042374,36,28198
2021-12-25,BE,Belgium,EURO,6519,2048893,35,28233
2021-12-26,BE,Belgium,EURO,2818,2051711,20,28253
2021-12-27,BE,Belgium,EURO,4566,2056277,22,28275
2021-12-28,BE,Belgium,EURO,13296,2069573,28,28303
2021-12-29,BE,Belgium,EURO,12818,2082391,21,28324
2021-12-30,BE,Belgium,EURO,15045,2097436,34,28358
2021-12-31,BE,Belgium,EURO,16059,2113495,29,28387
2022-01-01,BE,Belgium,EURO,12291,2125786,16,28403
2022-01-02,BE,Belgium,EURO,4070,2129856,22,28425
2022-01-03,BE,Belgium,EURO,9086,2138942,15,28440
2022-01-04,BE,Belgium,EURO,27579,2166521,25,28465
2022-01-05,BE,Belgium,EURO,28121,2194642,17,28482
2022-01-06,BE,Belgium,EURO,26044,2220686,14,28496
2022-01-07,BE,Belgium,EURO,23634,2244320,19,28515
2022-01-08,BE,Belgium,EURO,23800,2268120,19,28534
2022-01-09,BE,Belgium,EURO,15345,2283465,17,28551
2022-01-10,BE,Belgium,EURO,11225,2294690,23,28574
2022-01-11,BE,Belgium,EURO,37756,2332446,25,28599
2022-01-12,BE,Belgium,EURO,31695,2364141,24,28623
2022-01-13,BE,Belgium,EURO,31148,2395289,23,28646
2022-01-14,BE,Belgium,EURO,30107,2425396,21,28667
2022-01-15,BE,Belgium,EURO,31840,2457236,17,28684
2022-01-16,BE,Belgium,EURO,21174,2478410,14,28698
2022-01-17,BE,Belgium,EURO,14991,2493401,20,28718
2022-01-18,BE,Belgium,EURO,62703,2556104,32,28750
2022-01-19,BE,Belgium,EURO,60712,2616816,28,28778
2022-01-20,BE,Belgium,EURO,60893,2677709,38,28816
2022-01-21,BE,Belgium,EURO,57267,2734976,17,28833
2022-01-22,BE,Belgium,EURO,56441,2791417,23,28856
2022-01-23,BE,Belgium,EURO,32786,2824203,26,28882
2022-01-24,BE,Belgium,EURO,20746,2844949,17,28899
2022-01-25,BE,Belgium,EURO,75953,2920902,26,28925
2022-01-26,BE,Belgium,EURO,62495,2983397,37,28962
2022-01-27,BE,Belgium,EURO,54749,3038146,32,28994
2022-01-28,BE,Belgium,EURO,47505,3085651,29,29023
2022-01-29,BE,Belgium,EURO,41418,3127069,45,29068
2022-01-30,BE,Belgium,EURO,23221,3150290,27,29095
2022-01-31,BE,Belgium,EURO,13205,3163495,37,29132
2022-02-01,BE,Belgium,EURO,50018,3213513,29,29161
2022-02-02,BE,Belgium,EURO,36728,3250241,40,29201
2022-02-03,BE,Belgium,EURO,30843,3281084,49,29250
2022-02-04,BE,Belgium,EURO,25861,3306945,45,29295
2022-02-05,BE,Belgium,EURO,22380,3329325,61,29356
2022-02-06,BE,Belgium,EURO,12469,3341794,36,29392
2022-02-07,BE,Belgium,EURO,7285,3349079,40,29432
2022-02-08,BE,Belgium,EURO,27413,3376492,36,29468
2022-02-09,BE,Belgium,EURO,19394,3395886,47,29515
2022-02-10,BE,Belgium,EURO,16770,3412656,55,29570
2022-02-11,BE,Belgium,EURO,14195,3426851,67,29637
2022-02-12,BE,Belgium,EURO,12171,3439022,46,29683
2022-02-13,BE,Belgium,EURO,6740,3445762,39,29722
2022-02-14,BE,Belgium,EURO,4844,3450606,38,29760
2022-02-15,BE,Belgium,EURO,16478,3467084,52,29812
2022-02-16,BE,Belgium,EURO,11524,3478608,42,29854
2022-02-17,BE,Belgium,EURO,10605,3489213,33,29887
2022-02-18,BE,Belgium,EURO,9274,3498487,41,29928
2022-02-19,BE,Belgium,EURO,7711,3506198,47,29975
2022-02-20,BE,Belgium,EURO,4495,3510693,24,29999
2022-02-21,BE,Belgium,EURO,2917,3513610,31,30030
2022-02-22,BE,Belgium,EURO,10924,3524534,22,30052
2022-02-23,BE,Belgium,EURO,7950,3532484,26,30078
2022-02-24,BE,Belgium,EURO,5182,3537666,19,30097
2022-02-25,BE,Belgium,EURO,9,3537675,4,30101
.
14897a
2022-02-25,BY,Belarus,EURO,5996,902315,14,6421
.
14113a
2022-02-25,BB,Barbados,AMRO,192,54536,1,312
.
13329a
2022-02-25,BD,Bangladesh,SEARO,0,1939651,0,29005
.
12545a
2022-02-25,BH,Bahrain,EMRO,0,501643,0,1444
.
11761c
2022-02-24,BS,Bahamas,AMRO,23,33091,1,771
2022-02-25,BS,Bahamas,AMRO,0,33091,0,771
.
10977a
2022-02-25,AZ,Azerbaijan,EURO,1755,781538,23,9330
.
10193a
2022-02-25,AT,Austria,EURO,29495,2596719,26,14122
.
9409c
2022-02-24,AU,Australia,WPRO,23843,2746380,61,5026
2022-02-25,AU,Australia,WPRO,25802,2772182,60,5086
.
8625a
2022-02-25,AW,Aruba,AMRO,12,33643,0,211
.
7841a
2022-02-25,AM,Armenia,EURO,572,418792,21,8413
.
7057a
2022-02-25,AR,Argentina,AMRO,10298,8878486,97,125872
.
6273a
2022-02-25,AG,Antigua and Barbuda,AMRO,6,7435,0,135
.
5489a
2022-02-25,AI,Anguilla,AMRO,0,2528,0,9
.
4705a
2022-02-25,AO,Angola,AFRO,3,98701,0,1899
.
3921a
2022-02-25,AD,Andorra,EURO,57,37958,0,151
.
3137a
2022-02-25,AS,American Samoa,WPRO,12,84,0,0
.
2353a
2022-02-25,DZ,Algeria,AFRO,115,264603,4,6820
.
1569a
2022-02-25,AL,Albania,EURO,213,270947,4,3457
.
785a
2022-02-25,AF,Afghanistan,EMRO,123,173047,3,7578
.
w WHO-COVID-19-global-data.csv_2022-02-28_19:00:01
q

ed_heredoc
# 
# Dateiname: WHO-COVID-19-global-data.csv_2022-02-28_19:00:01 
# Zugriffsrechte -rw-r--r-- setzen 
  chmod 644 WHO-COVID-19-global-data.csv_2022-02-28_19:00:01 
# ctime war: - 
# atime auf    2022-06-24 00:58:45.952079000 +0200  setzen 
  touch -a -d '2022-06-24 00:58:45.952079000 +0200' WHO-COVID-19-global-data.csv_2022-02-28_19:00:01 
# mtime auf    2022-02-25 18:30:02.284109000 +0100  setzen 
  touch -m -d '2022-02-25 18:30:02.284109000 +0100' WHO-COVID-19-global-data.csv_2022-02-28_19:00:01 
